<?php

/*
Plugin Name: Simple Social Press

Description: Automatically Publish Your Facebook Videos To Your Website and Grow Your Email List on Autopilot.

Version: 1.2.0.0

Author: Hani Mourra

Plugin URI: http://www.simplesocialpress.com/
*/


define( 'SSPRESS_PLUGIN_VERSION', '1.2.0.0' );
define( 'SSPRESS_STORE_URL', 'http://simplepodcastpress.com' );
define( 'SSPRESS_ITEM_NAME', 'Simple Social Press' );

if( !class_exists( 'SSP_SL_Plugin_Updater' ) ) {
	include( dirname( __FILE__ ) . '/updater/SSP_SL_Plugin_Updater.php' );
}


function ssp_sl_plugin_update() {


global $pagenow;

if ( $pagenow == 'plugin.php' ) {
	
	set_site_transient( 'update_plugins', null );
}

    $license_key = get_option('edd_sspress_license_key');
	
	$edd_updater = new SSP_SL_Plugin_Updater( SSPRESS_STORE_URL, __FILE__, array(
			'version' 	=> SSPRESS_PLUGIN_VERSION,
			'license' 	=> $license_key,
			'item_name' => SSPRESS_ITEM_NAME,
			'author' 	=> 'Hani Mourra'  
		)
	);

}


add_action( 'admin_init', 'ssp_sl_plugin_update', 0 );




include_once('ssp.php');
include_once(ABSPATH . 'wp-includes/pluggable.php');

$ob_wp_simplesocialpress=new wp_simplesocialpress();
	if(isset($ob_wp_simplesocialpress)){
		register_activation_hook( __FILE__,array(&$ob_wp_simplesocialpress,'simplesocialpress_activate'));
		register_deactivation_hook( __FILE__, array(&$ob_wp_simplesocialpress,'simplesocialpress_deactivate') );
	}
	


?>