<?php
/*************************************************************************************************************
file responsive-player.php is a part of Simple Live Press and contains proprietary code - simplelivepress.com
*************************************************************************************************************/
add_action(
	'wp',
	array ( FB_Player::get_instance(), 'plugin_setup' )
);
 
class FB_Player
{
	/**
	 * Plugin instance.
	 *
	 * @see get_instance()
	 * @type object
	 */
	protected static $instance = NULL;
 
	/**
	 * URL to this plugin's directory.
	 *
	 * @type string
	 */
	public $plugin_url = '';
 
	/**
	 * Path to this plugin's directory.
	 *
	 * @type string
	 */
	public $plugin_path = '';
 
	/**
	 * Access this plugin’s working instance
	 *
	 * @wp-hook plugins_loaded
	 * @since   2012.09.13
	 * @return  object of this class
	 */
	public static function get_instance()
	{
		NULL === self::$instance and self::$instance = new self;
		return self::$instance;
	}
 
	/**
	 * Used for regular plugin work.
	 *
	 * @wp-hook plugins_loaded
	 * @since   2012.09.10
	 * @return  void
	 */
	public function plugin_setup()
	{
 
		$this->plugin_url    = plugins_url( '/', __FILE__ );
		$this->plugin_path   = plugin_dir_path( __FILE__ );
		
		if ( ! is_admin() ) {
			if ($this->has_shortcode('ssp-video') or $this->has_shortcode('ssp-optin') or $this->has_shortcode('ssp-live') or $this->has_shortcode('ssp-ctabuttons') or $this->has_postmeta()) {
				add_action( 'wp_default_scripts', array( $this, 'enqueue_jquery' ) );
				add_action( 'wp_enqueue_scripts', array( $this, 'sbpress_enqueue_scripts' ) );
	        	add_action('wp_footer', array( &$this, 'two_step_optin_fn' ) );
			}
		}
		
		$isLicenseValid = get_option('sspress_ls');
        
        if ($isLicenseValid !== 'valid') 
        {
          return; 
        }
        
        // Only If license is valid, then load the shortcodes and css/jquery
        else {
        
            add_shortcode( 'ssp-ctabuttons', array( $this, 'sbp_ctabuttons_fn' ) );
            add_shortcode( 'ssp-optin', array( $this, 'sbp_optin_fn' ) );
			add_shortcode( 'ssp-video', array( $this, 'sbpressplayer_fn' ) );
			add_shortcode( 'ssp-captions', array( $this, 'sbpresscaption_fn' ) );
			add_shortcode( 'ssp-timestamp', array( $this, 'ssp_timestamp_fn') );

            add_shortcode( 'ssp-poweredby', array( $this, 'sbp_poweredby_fn' ) );
			add_shortcode( 'ssp-live', array( $this, 'sbpressblablive_fn' ) );
        }
	}
 
	/**
	 * Constructor. Intentionally left empty and public.
	 *
	 * @see plugin_setup()
	 * @since 2012.09.12
	 */
	public function __construct() {}   
    
    function sbp_blab_fn($atts, $sp_settings = null, $live=false) 
	{
		global $post;

        if ($sp_settings == null) {
      		$sp_settings = get_option('ssp_settings');
		}    
      		
		if( isset($atts['height'] ) )
			$blab_height = $atts['height'];
		else {
			
			$blab_height = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_container_height']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_container_height'] : '';
			if ($blab_height == null)
				$blab_height = '';
		}
		
		if( isset($atts['width'] ) )
			$blab_width = $atts['width'];
		else {
			
			$blab_width = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_container_width']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_container_width'] : '';
			if ($blab_width == null)
				$blab_width = '';
		}
		
		if( isset($atts['id'] ) ) {
			$stream_id = $atts['id'];
		    if (!get_post_meta( $post->ID, '_fb_videoid', true ))
				update_post_meta($post->ID, '_fb_videoid', $stream_id);							
		}
		
		else {
			//$stream_id =  get_post_meta( $post->ID, '_fb_videoid', true );
            if ($live)
                $stream_id = get_post_meta( $post->ID, '_fb_livevideoid', true );
            else
                $stream_id = get_post_meta( $post->ID, '_fb_videoid', true );
        }
		
		if (empty($stream_id)){
			$stream_id = get_post_meta( $post->ID, '_fb_id', true );
		}

		if( isset($atts['src'] ) )
			$stream_src = $atts['src'];
		
		else
			$stream_src = 'https://www.facebook.com/video/embed?video_id=' . $stream_id;
			//$stream_src = 'https://www.facebook.com/video.php?v='. $stream_id;
	
 
		$sbp_show_data_setting	=	isset($sp_settings[SSP_CHANNEL]['settings']['sbp_show_data']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_show_data'] : '';
		$sbp_show_data_text = ($sbp_show_data_setting == 1) ? 'data-show-text="true"' : ''; 
		$cap_pos =  isset($sp_settings[SSP_CHANNEL]['settings']['sbp_blab_caption_position']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_blab_caption_position'] : '';
		$ssp_captions = get_post_meta( $post->ID, 'ssp_captions', true );

		//$html = '<center><iframe src="https://www.facebook.com/plugins/video.php?href=https%3A%2F%2Fwww.facebook.com%2Ffacebook%2Fvideos%2F'.$stream_id.'%2F&width=500&show_text=false&appId='.SSPFAI.'&height=281" width="100%" height="'. $blab_height .'" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowTransparency="true"></iframe></center>';
		
		//$html = '<iframe id="ssp-responsive" src="https://www.facebook.com/plugins/video.php?href=https%3A%2F%2Fwww.facebook.com%2Ffacebook%2Fvideos%2F'.$stream_id.'%2F&show_text=false&appId='.SSPFAI.'" width="600" height="'. $blab_height .'" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowTransparency="true"></iframe>';
		
		// Latest Working:
		//$html = '<iframe id="ssp-responsive" src="https://www.facebook.com/plugins/video.php?href=https%3A%2F%2Fwww.facebook.com%2Ffacebook%2Fvideos%2F'.$stream_id.'%2F&show_text=false&appId='.SSPFAI.'" width="'.$blab_width.'" height="'. $blab_height .'" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowTransparency="true"></iframe>';
		
		// Uses JS SDK
		//$html = '<center><div class="fb-video" data-href="https://www.facebook.com/video.php?v='.$stream_id.'" '.$sbp_show_data_text.' data-width="'.$blab_width.'" data-height="'.$blab_height.'" data-allowfullscreen="true"></div></center>';
		
        
        // Uses JS SDK - LATEST OFFICIAL WORKING
		//ob_start();
		//echo '<div id="fb-root"></div><div class="fb-video" data-href="https://www.facebook.com/facebook/videos/'.$stream_id.'" '.$sbp_show_data_text.' data-width="'.$blab_width.'" data-height="'.$blab_height.'" data-allowfullscreen="true"></div>';
		//$output = ob_get_contents();
		//ob_end_clean();
        if ($cap_pos == 'top'){
			$html = $ssp_captions . '<div id="fb-root"></div><script async defer src="https://connect.facebook.net/en_US/sdk.js"></script><div class="fb-video" data-href="https://www.facebook.com/facebook/videos/'.$stream_id.'" '.$sbp_show_data_text.' data-width="'.$blab_width.'" data-height="'.$blab_height.'" data-allowfullscreen="true" data-show-captions="true"></div>';	
		} else if ($cap_pos == 'bottom'){
			$html = '<div id="fb-root"></div><script async defer src="https://connect.facebook.net/en_US/sdk.js"></script><div class="fb-video" data-href="https://www.facebook.com/facebook/videos/'.$stream_id.'" '.$sbp_show_data_text.' data-width="'.$blab_width.'" data-height="'.$blab_height.'" data-allowfullscreen="true" data-show-captions="true"></div>' . $ssp_captions;
		}else if ($cap_pos == 'off'){
			$html = '<div id="fb-root"></div><script async defer src="https://connect.facebook.net/en_US/sdk.js"></script><div class="fb-video" data-href="https://www.facebook.com/facebook/videos/'.$stream_id.'" '.$sbp_show_data_text.' data-width="'.$blab_width.'" data-height="'.$blab_height.'" data-allowfullscreen="true" data-show-captions="true"></div>';
		}
        else {
			$html = '<div id="fb-root"></div><script async defer src="https://connect.facebook.net/en_US/sdk.js"></script><div class="fb-video" data-href="https://www.facebook.com/facebook/videos/'.$stream_id.'" '.$sbp_show_data_text.' data-width="'.$blab_width.'" data-height="'.$blab_height.'" data-allowfullscreen="true" data-show-captions="true"></div>';
		}
		
        //$html = '<iframe src="https://www.facebook.com/plugins/video.php?href=https%3A%2F%2Fwww.facebook.com%2Fhanimourra%2Fvideos%2F10154376483732463%2F&show_text=0&width=560&mute=0" width="560" height="315" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowTransparency="true" allowFullScreen="true"></iframe>';
            
		//$html = '<amp-iframe width="'.$blab_width.'"  height="'.$blab_height.'" layout="responsive" sandbox="allow-scripts allow-same-origin allow-popups" allowfullscreen frameborder="0"src="https://www.facebook.com/facebook/videos/'.$stream_id.'"></amp-iframe>';
		
        //return $html;
        //return $output;
		
		//$html = '<center><iframe width="100%" height="' . $blab_height . '" align="center"' . $stream_src . ' frameBorder="0"> </iframe></center>';
		//$html = '<center><iframe src="https://www.facebook.com/plugins/video.php?href=https%3A%2F%2Fwww.facebook.com%2Ffacebook%2Fvideos%2F'.$stream_id.'%2F&width=500&show_text=false&appId='.SSPFAI.'&height=385" width="100%" height="'. $blab_height .'" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowTransparency="true"></iframe></center>';
		
		//$html = '<div class="ssp-video-container"><iframe src="'.$stream_src.'&show_text=false&appId='.SSPFAI.'" style="border:none;overflow:hidden" scrolling="no" allowTransparency="true"></iframe></div>';
		
		//return $html;
		
		//$html = '<div class="ssp-video-container"><iframe src="'.$stream_src.'"></iframe></div>';
		return $html;
	}
	
  	function sbp_share_fn($atts) 
	{     
        $post_id = get_the_ID();
		$sbp_btn_twitter_url =  'https://twitter.com/intent/tweet?text=Join us live on Blab -> &url=' .get_permalink( $post_id) .'&hashtags=blab&related=blab';
		$sbp_btn_facebook_url = 'https://www.facebook.com/sharer/sharer.php?u='.get_permalink( $post_id);
			
		$html = '
		<div class="sbpbuttons">
		<a class="sbp-button-twitter" target="_blank" href="'.$sbp_btn_twitter_url.'">Tell a Little Bird</a>
		<a class="sbp-button-facebook" target="_blank" href="'.$sbp_btn_facebook_url.'">Share on Facebook</a>
		</div>';
  	
		return $html;
	}      

	function sbp_ctabuttons_fn($atts, $sp_settings = null) 
	{     
        global $post;
        if ($sp_settings == null) {
      		$sp_settings = get_option('ssp_settings');
		}
		
        //$sbp_btn_downloadaudio = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio'];
		$sbp_btn_followblab = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab'] : '';
		$sbp_btn_share = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share'] : '';
        $sbp_btn_custom1 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom1']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom1'] : '';
		$sbp_btn_custom2 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom2']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom2'] : '';
		$sbp_btn_custom3 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom3']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom3'] : '';
        $sbp_btn_custom4 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom4']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom4'] : '';
		$sbp_btn_custom5 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom5']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom5'] : '';
		$sbp_btn_custom6 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom6']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom6'] : '';
                            
		//$sbp_btn_downloadaudio_display =($sbp_btn_downloadaudio == 0) ? 'display:none !important;' : '';
		//if( ( isset($atts['live']) ) AND ($atts['live'] == true) )
			//$sbp_btn_downloadaudio_display = 'display:none !important';
		$sbp_btn_followblab_display =($sbp_btn_followblab == 0) ? 'display:none !important;' : '';
		$sbp_btn_share_display =($sbp_btn_share == 0) ? 'display:none !important;' : '';
        $sbp_btn_custom1_display =($sbp_btn_custom1 == 0) ? 'display:none !important;' : '';
		$sbp_btn_custom2_display =($sbp_btn_custom2 == 0) ? 'display:none !important;' : '';
		$sbp_btn_custom3_display =($sbp_btn_custom3 == 0) ? 'display:none !important;' : '';
        $sbp_btn_custom4_display =($sbp_btn_custom4 == 0) ? 'display:none !important;' : '';
		$sbp_btn_custom5_display =($sbp_btn_custom5 == 0) ? 'display:none !important;' : '';
		$sbp_btn_custom6_display =($sbp_btn_custom6 == 0) ? 'display:none !important;' : '';
		
        //$sbp_btn_downloadaudio_name = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio_name'];
        //if (!$sbp_btn_downloadaudio_name)
            //$sbp_btn_downloadaudio_name = 'Listen To The Audio Version';
        if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_name'])) {
			$sbp_btn_followblab_name = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_name'];
			if (!$sbp_btn_followblab_name)
				$sbp_btn_followblab_name = 'Connect on Facebook';
		}
		else 
			$sbp_btn_followblab_name = 'Connect on Facebook';
        if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_name'])) {
			$sbp_btn_share_name = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_name'];
			if (!$sbp_btn_share_name)
				$sbp_btn_share_name = 'Share';
		}
        else 
			$sbp_btn_share_name = 'Share';
        $sbp_btn_custom_name1 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name1']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name1'] : '';
		$sbp_btn_custom_name2 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name2']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name2'] : '';
		$sbp_btn_custom_name3 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name3']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name3'] : '';
        $sbp_btn_custom_name4 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name4']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name4'] : '';
		$sbp_btn_custom_name5 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name5']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name5'] : '';
		$sbp_btn_custom_name6 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name6']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name6'] : '';

        //$sbp_btn_downloadaudio_url = get_post_meta( $post->ID, '_blab_audio', true );            
        $sbp_btn_followblab_url = 'https://facebook.com/'. $sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile'];
        $sbp_btn_custom_url1 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url1']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url1'] : '';
		$sbp_btn_custom_url2 = isset ($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url2']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url2'] : '';
		$sbp_btn_custom_url3 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url3']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url3'] : '';
        $sbp_btn_custom_url4 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url4']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url4'] : '';
		$sbp_btn_custom_url5 = isset ($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url5']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url5'] : '';
		$sbp_btn_custom_url6 = isset ($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url6']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url6'] : '';
        $sbp_LeadBox_btn_code = '';
		$btn_sbpleadbox_checkbox = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_checkbox']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_checkbox'] : '';
		
		//Custom Button 6 Logic 
		$ssp_btn_custom_name_post = get_post_meta( $post->ID, '_ssp_btn_custom_name', true );
		$ssp_btn_custom_url_post = get_post_meta( $post->ID, '_ssp_btn_custom_url', true );

		$sbp_btn_custom_name6 = (empty($ssp_btn_custom_name_post) ? $sbp_btn_custom_name6 : $ssp_btn_custom_name_post );
		$sbp_btn_custom_url6 = (empty($ssp_btn_custom_url_post) ? $sbp_btn_custom_url6 : $ssp_btn_custom_url_post );


        if ($btn_sbpleadbox_checkbox) {
			$sbp_LeadBox_btn_code = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_code']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_code'] : '';
			$sbp_LeadBox_btn_code = htmlspecialchars_decode($sbp_LeadBox_btn_code, ENT_QUOTES) ;
			$sbp_LeadBox_btn_code = str_replace('<a','<a class="sbp-button-leadbox"', $sbp_LeadBox_btn_code);
		}

		$ShareLink = get_permalink($post->ID);
		if (extension_loaded('mbstring'))
			$ShareTitle = urlencode(strip_tags(mb_convert_encoding(get_the_title($post->ID), 'UTF-8', 'HTML-ENTITIES')));
		else
			$ShareTitle = urlencode(strip_tags(get_the_title($post->ID)));
	
	$sbp_btn_followblab_name = stripslashes_deep($sbp_btn_followblab_name);
          
		$html = <<<HTML

<div class="sbpbuttons">
                <a class="sbp-button-followblab" target="_blank" style="$sbp_btn_followblab_display" href="$sbp_btn_followblab_url">$sbp_btn_followblab_name</a>
                <a class="sbp-button-share" target="_blank" style="$sbp_btn_share_display" href="#">$sbp_btn_share_name</a>
					<div class="webui-popover-content share-buttons">
							<a href="https://www.facebook.com/sharer/sharer.php?u=$ShareLink" title="Share on Facebook" target="_blank" class="facebook"><i class="fa fa-facebook"></i></a>
							<a href="https://twitter.com/share?text=$ShareTitle-&url=$ShareLink" title="Share on Twitter" target="_blank" class="twitter"><i class="fa fa-twitter"></i></a>
							<a href="https://plus.google.com/share?url=$ShareLink" title="Share on Google+" target="_blank" class="google-plus"><i class="fa fa-google-plus"></i></a>
					</div>
                <a class="sbp-button-custom1" target="_blank" style="$sbp_btn_custom1_display" href="$sbp_btn_custom_url1">$sbp_btn_custom_name1</a>
				<a class="sbp-button-custom2" target="_blank" style="$sbp_btn_custom2_display" href="$sbp_btn_custom_url2">$sbp_btn_custom_name2</a>
				<a class="sbp-button-custom3" target="_blank" style="$sbp_btn_custom3_display" href="$sbp_btn_custom_url3">$sbp_btn_custom_name3</a>
				<a class="sbp-button-custom4" target="_blank" style="$sbp_btn_custom4_display" href="$sbp_btn_custom_url4">$sbp_btn_custom_name4</a>
				<a class="sbp-button-custom5" target="_blank" style="$sbp_btn_custom5_display" href="$sbp_btn_custom_url5">$sbp_btn_custom_name5</a>
				<a class="sbp-button-custom6" target="_blank" style="$sbp_btn_custom6_display" href="$sbp_btn_custom_url6">$sbp_btn_custom_name6</a>
                $sbp_LeadBox_btn_code
                
</div>
HTML;
  	
		return $html;
	}

    
    function sbp_poweredby_fn($atts = 0, $sp_settings = null) 
	{
        $html = '';
		$refUrl = '';
		if ($sp_settings == null) {
      		$sp_settings = get_option('ssp_settings');
		}
		$disablePoweredBy = $sp_settings[SSP_CHANNEL]['settings']['sbp_disable_poweredby'];
        $refUrl = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_poweredby_url']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_poweredby_url'] : '';
        
        if ($refUrl)
            $refUrl = "/?ref=".$refUrl;
                  
        if (!$disablePoweredBy) {
            $html .= '
            <div class="sbp_poweredby"><center>Powered by the <a target="_blank" href="http://simplepodcastpress.com/ssp'.$refUrl.'">Simple Social Press</a></center></div>
            ';
        }

		return $html;
		
	}
        
	function sbp_optin_fn($atts, $sp_settings = null) 
	{
		 if ($sp_settings == null) {
      		$sp_settings = get_option('ssp_settings');
		}
		
		$hide_email = '';
		$sbp_auto_resp_url_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_url']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_url'] : '';
		$sbp_auto_resp_heading_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_heading']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_heading'] : '';
		$sbp_auto_resp_sub_heading_get =  isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_sub_heading']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_sub_heading'] : '';
		$sbp_auto_resp_hidden_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_hidden']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_hidden'] : '';
		$sbp_auto_resp_name_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_name']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_name'] : '';
		$sbp_auto_resp_email_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_email']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_email'] : '';
		$sbp_auto_resp_email_submitt = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_submitt']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_submitt'] : '';
		$sbp_optin_box = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box'] : '';
		$sbp_two_step_optin = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_two_step_optin']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_two_step_optin'] : '';
		$ssp_privacy_page = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_page']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_page'] : '';


						 switch ( $sbp_two_step_optin ) {
							 case 1 :
									$hide_first_name = '';
							 break;
							 case 2 :
									$hide_first_name = 'display:none !important;';
							 break;
							 case 3 :
									$hide_first_name = 'display:none !important;';
									$hide_email = 'display:none !important;';
							 break;
							 case 4 :
									$hide_first_name = 'display:none !important;';
									$hide_email = 'display:none !important;';
									$hide_first_name_two_step = 'display:none !important;';
							 break;
						}
		 if ($sbp_optin_box == 1){
			$s = '';
			$d = '';
				//echo $ssp_privacy_page;
			if (($ssp_privacy_page == 'disabled') or ($ssp_privacy_page == '') ){
					$d= 'display:none;';
			}else{
					$s = 'disabled=disabled';
			}
		$ssp_pp_text = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_policy_text']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_policy_text'] : '';
		$parse = parse_url($sbp_auto_resp_url_get);
		$action_url = isset($parse['host']) ? $parse['host'] : '';
		if ($action_url != 'app.convertkit.com'){
			$method = 'method="post"';
		}else{
			$method = '';
		}
        $ssp_pp = '<a href="'. get_the_permalink($ssp_privacy_page) .'" target="_blank">Privacy Policy</a>';
		$ssp_pp_text = str_replace ('Privacy Policy', $ssp_pp, $ssp_pp_text);

			 $html = '<div id="sbp-box-below-video" class="sbp-optin-box">
					<div class="sbp-optin-box-padding">
					<div class="sbp-optin-box-content">
					<div class="sbp-optin-box-headline">' . stripslashes($sbp_auto_resp_heading_get) .'</div>
					<div class="sbp-optin-box-subheadline">' . stripslashes($sbp_auto_resp_sub_heading_get) . '</div>
					<div class="sbp-optin-box-form-wrap">
					<form accept-charset="utf-8" action="'. $sbp_auto_resp_url_get .'" '.$method.' target="_blank">
					'. htmlspecialchars_decode($sbp_auto_resp_hidden_get, ENT_QUOTES) . '
					<div class="sbp-optin-box-field" style="'.$hide_first_name.'">
					 <input placeholder="First Name" type="text" name="'. $sbp_auto_resp_name_get .'"></div>
					<div class="sbp-optin-box-field" style="'.$hide_email.'">
					 <input placeholder="Email" type="text" name="'. $sbp_auto_resp_email_get .'"></div>
					 <br><div style="'.$d.'"><input type="checkbox" name="checkbox" value="check" id="consent" />'.$ssp_pp_text.'<br></div>';

					if ($sbp_two_step_optin == 3 or  $sbp_two_step_optin == 4){	
						$html .= '<a class="sbp-optin-box-submit" data-reveal-id="sbp-two-step-optin"  href="#">'. stripslashes($sbp_auto_resp_email_submitt).'</a>';
					}else{
						$html .= '<div class="sbp-optin-box-field-submit"><input type="submit"  '.$s.' id="sspoptinboxsubmit" name="submit" class="sbp-optin-box-submit" value=" ' . stripslashes($sbp_auto_resp_email_submitt) . '"></div>';					
					}
				$html .= '
					</form>
					</div>
					</div>
					</div>
					</div>
					';			
        }

if ($ssp_privacy_page != 'disabled'){

$html .= <<<HTML
		<script type="text/javascript">
			jQuery(document).ready(function() {
				jQuery("#consent").click(function() {
					if (jQuery(this).is(":checked")) {
						jQuery("#sspoptinboxsubmit").removeAttr("disabled");
					} else {
						jQuery("#sspoptinboxsubmit").attr("disabled", "disabled");
					}
				});
			});
		</script>
HTML;
}
		return $html;
		
	}

function two_step_optin_fn($atts, $sp_settings = null) 
	{
     if ($sp_settings == null) {
      		$sp_settings = get_option('ssp_settings');
	}
	
	$html = '';
	$sbp_auto_resp_url_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_url']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_url'] : '';
    $sbp_auto_resp_heading_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_heading']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_heading'] : '';
    $sbp_auto_resp_sub_heading_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_sub_heading']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_sub_heading'] : '';
    $sbp_auto_resp_hidden_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_hidden']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_hidden'] : '';
    $sbp_auto_resp_name_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_name']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_name'] : '';
    $sbp_auto_resp_email_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_email']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_email'] : '';
    $sbp_auto_resp_email_submitt = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_submitt']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_submitt'] : '';
    $sbp_optin_box = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box'] : '';
	$sbp_two_step_optin = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_two_step_optin']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_two_step_optin'] : '';
					 switch ( $sbp_two_step_optin ) {
						 case 1 :
								$hide_first_name = '';
						 break;
						 case 2 :
								$hide_first_name = 'display:none !important;';
						 break;
						 case 3 :
								$hide_first_name = 'display:none !important;';
						 break;
						 case 4 :
								$hide_first_name = 'display:none !important;';
								$hide_email = 'display:none !important;';
								$hide_first_name_two_step = 'display:none !important;';
						 break;

					}
		$parse = parse_url($sbp_auto_resp_url_get);
		$action_url = isset($parse['host']) ? $parse['host'] : '';
		if ($action_url != 'app.convertkit.com'){
			$method = 'method="post"';
		}
    
        if ( ($sbp_two_step_optin == 3) || ($sbp_two_step_optin == 4) ) {
            $html .= '
             <div id="sbp-two-step-optin" class="reveal-modal">
                 <a class="close-reveal-modal">&#215;</a>
                <div id="sbp-box-below-video" class="sbp-optin-box">
				<div class="sbp-optin-box-padding">
				<div class="sbp-optin-box-content">
				<div class="sbp-optin-box-headline">' . stripslashes($sbp_auto_resp_heading_get) .'</div>
				<div class="sbp-optin-box-subheadline">' . stripslashes($sbp_auto_resp_sub_heading_get) . '</div>
				<div class="sbp-optin-box-form-wrap">
				<form accept-charset="utf-8" action="'. $sbp_auto_resp_url_get .'" '.$method.' target="_blank">
				'. htmlspecialchars_decode($sbp_auto_resp_hidden_get, ENT_QUOTES) . '
				<div class="sbp-optin-box-field" style="'.$hide_first_name_two_step.'">
				 <input placeholder="First Name" type="text" name="'. $sbp_auto_resp_name_get .'"></div>
				<div class="sbp-optin-box-field">
				 <input placeholder="Email" type="text" name="'. $sbp_auto_resp_email_get .'"></div>
				<div class="sbp-optin-box-field-submit"><input type="submit" name="submit" class="sbp-optin-box-submit" value=" ' . stripslashes($sbp_auto_resp_email_submitt) . '"></div>
				</form>
				</div>
				</div>
				</div>
				</div>
			</div>
                ';
        }

										
						
        

echo $html;
		
	}

	function sbpresscaption_fn ($atts = 0){
		global $post;
		// $html = sbpressplayer_fn($atts);
		// $cap_pos =  isset($sp_settings[SSP_CHANNEL]['settings']['sbp_blab_caption_position']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_blab_caption_position'] : '';
		$ssp_captions = get_post_meta( $post->ID, 'ssp_captions', true );

        // if ($cap_pos == 'top'){
		// 	$html = $ssp_captions . $html;;
		// } else if ($cap_pos == 'bottom'){
		// 	$html = $html . $ssp_captions;
		// }else if ($cap_pos == 'off'){
		// 	$html = $html;
		// }

		return $ssp_captions;
	}
    
    function sbpressplayer_fn($atts = 0) 
	{
    	$sp_settings = get_option('ssp_settings');
		
		$html = '';
		$ctabuttonspart = '';
		$optinpart = '';
		$poweredby = '';
		
        $audiopart = $this->sbp_blab_fn($atts, $sp_settings);
		$sbp_optin_box = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box'] : '';        
		
		if( isset($atts['video'] ) ) {
			if ($atts['video'] == 'off')
				return;
		}
		
       if ( isset($atts['hide']) ) {
			if (($atts['hide'] == 'true') || ($atts['hide'] == 'TRUE'))
              return;
       }
        
        if( isset( $atts['optin'] )) { 
            $optin = $atts['optin'];
            if($optin != 'off')
                $optinpart = $this->sbp_optin_fn($atts, $sp_settings);
        }
        else {
	       // If Optin Option is disabled, don't add it to the player
	       if ($sbp_optin_box == 1)
		      $optinpart = $this->sbp_optin_fn($atts, $sp_settings);
        }

            
        
        if( isset( $atts['ctabuttons'] )) {
            $ctabuttons = $atts['ctabuttons'];
            if($ctabuttons != 'off')
                $ctabuttonspart = $this->sbp_ctabuttons_fn($atts, $sp_settings);
        }
        else
            $ctabuttonspart = $this->sbp_ctabuttons_fn($atts, $sp_settings);
		
		if( isset( $atts['poweredby'] )) {
            $poweredbylink = $atts['poweredby'];
            if($poweredbylink != 'off')
                $poweredby = $this->sbp_poweredby_fn($atts, $sp_settings);
        }
        else
            $poweredby = $this->sbp_poweredby_fn($atts, $sp_settings);

	    
        $html = '<center><div class="ssp-fb-container">' . $audiopart . $ctabuttonspart . $optinpart . $poweredby . '</div></center>';

        
        return $html;
    }
	function url_get_contents($url) {
		$getresponse = wp_remote_get($url, array( 'timeout' => 60, 'redirection' => 20, 'sslverify' => false, ) );
		$response = wp_remote_retrieve_body($getresponse);
		return $response;
	} 
	
	
	function sbpressblablive_fn($atts) 
	{
		global $post;
		
		$access_token = get_option('sfp_access_token');
		$sp_settings = get_option('ssp_settings');     
		$fbid = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile'] : '' ;
        $fb_stream = 'https://graph.facebook.com/'.FB_API_VER.'/'.$fbid.'/videos/uploaded?date_format=U&fields=created_time%2Cid%2Cembeddable%2Clive_status%2Csource%2Cdescription%2Cthumbnails%7Buri%2Cis_preferred%7D%2Ctitle%2Ccontent_tags&access_token='.$access_token;
		$offair = "We are not broadcasting Live at the moment ...";
		if (isset($atts['offair']))
			$offair = $atts['offair'];
		$fbObject = json_decode($this->url_get_contents($fb_stream));
        $foundLiveVideo = false;
		delete_post_meta($post->ID, '_fb_livevideoid');
		if( isset($fbObject->data) ) {
            foreach ($fbObject->data as $fbvideo){
			 if (isset($fbvideo->live_status) && ($fbvideo->live_status === "LIVE")) {
				$foundLiveVideo = true;
				break;
			 }
            }//endforeach
		}
			
        // To simlulate live for testing only
        //update_post_meta($post->ID, '_fb_livevideoid', '9999999');
        //$blab_title = '<h3>' . 'WE ARE LIVE NOW' . '</h3>';
        //return $blab_title . $this->sbp_blab_fn($atts,null,true);
        
		if (!$foundLiveVideo) {
			$html= '<h3>' . $offair . '</h3>';
            return $html;
        }
		else {
			$stream_id = $fbvideo->id;
			update_post_meta($post->ID, '_fb_livevideoid', $stream_id);
			if (isset($fbvideo->title)) {
				//echo '<h3>' . $fbvideo->title . '</h3>';
                $blab_title = '<h3>' . $fbvideo->title . '</h3>';
            }
			else {
				$title = $fbvideo->description;
				if (strlen($title) > 400)
					$title = substr($title,0,400) . '...';
				//echo '<h3>' . $title . '</h3>';
                $blab_title = '<h3>' . $title . '</h3>';
			}
			return $blab_title . $this->sbp_blab_fn($atts,null,true);
		}
        
    }
	// Sort by published date_create
	function sortFunction($a,$b){
		    return strtotime($b['pc_published_date']) - strtotime($a['pc_published_date']);
	}
	
	function sbp_episodes_fn($atts) {
		
    	$sp_settings = get_option('ssp_settings');
		
		global $wpdb;
		$table_name = $wpdb->prefix.'sbp_streams';
		$episodes = $wpdb->get_results("select * from $table_name ") or die("No Blabs Found");
		$audiodownloadurl = '';
		
		$direct_download_button = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_direct_download_button']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_direct_download_button'] : '';
		
		if($direct_download_button)
        	$audiodownloadurl = SSPRESS_PLUGIN_URL . '/responsive_player/downloadaudio.php?file=';
	
			
		$html = '		
					
					<table id="grid-basic" class="table table-condensed table-hover table-striped" style="font-size: 14px;" >
							<thead>
									<tr>
											<td class="sbp-episodes-released-title" data-column-id="released" data-header-css-class="releasedColumn">Released</th>
											<td class="sbp-episodes-blab-title" data-column-id="name">Episode</th>
											<td class="sbp-episodes-download-title" data-column-id="link" data-header-css-class="downloadColumn" data-formatter="link" data-sortable="false"></th>
									</tr>
							</thead>
							<tbody>';
		foreach($episodes as $episode){
			$episode_array[] = (array)$episode;
		
			
			usort($episode_array,array( $this, 'sortFunction')); 
		}
				

		foreach($episode_array as $latest_episode){
						
			$html.='
			    <tr>
							<td class="sbp-episodes-released" >';
							//$arr = split(' ',$latest_episode['pc_published_date']);
							$arr = explode(' ',$latest_episode['pc_published_date']);
							$html.=$arr[1]." &nbsp;".$arr[2]." &nbsp;".$arr[3];
							$html.='</td>
							<td class="sbp-episodes-blab" >'.$latest_episode['pc_title'].'</td>
							<td class="sbp-episodes-download" ><a href="'.$audiodownloadurl.$latest_episode['pc_audio_file'].'">Download</a></td>
					</tr> ';
			}
    $html.='</tbody></table>';
			
		return $html;
		
	}
          
    
	// Simple podcast press enqueue_scripts which calls two diferent CSS files.
    function sbpress_enqueue_scripts()
	{
		$css_version = rand(10, 99)/10;

		// Handle the location of the CSS file for multisite
		if(is_multisite()) {
			$uploads = wp_upload_dir();
		  	$sbp_audiocss_file = trailingslashit($uploads['baseurl']).'sbp-player.css';
		}
		else
			$sbp_audiocss_file = SSPRESS_PLUGIN_URL . '/responsive_player/css/sbp-player.css';
		
	    wp_register_style( 'font-awesome', 'https://netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css' );
		wp_enqueue_style( 'font-awesome' );
	    wp_register_style( 'font-oswald', 'https://fonts.googleapis.com/css?family=Oswald:300,400,700' );
		wp_enqueue_style( 'font-oswald' );
		wp_enqueue_style( 'ssp-resp-player-css', $sbp_audiocss_file, false, $css_version, 'all' );
		//wp_enqueue_script( 'sbp-resp-player-js', SSPRESS_PLUGIN_URL . '/responsive_player/js/audio-player.js', false, false, false );
		wp_enqueue_script( 'ssp-resp-player-js', SSPRESS_PLUGIN_URL . '/responsive_player/js/responsive.js', array('jquery'), false, false );
		wp_enqueue_style( 'ssp-jquery-reveal-css', SSPRESS_PLUGIN_URL . '/responsive_player/css/reveal.css', false, $css_version, 'all' );
        wp_enqueue_script( 'ssp-jquery-reveal', SSPRESS_PLUGIN_URL . '/responsive_player/js/jquery.reveal.js', array('jquery'), false, false );
		wp_enqueue_script( 'popover-js', SSPRESS_PLUGIN_URL . '/responsive_player/js/jquery.webui-popover.min.js', array('jquery'), false, false );
		wp_enqueue_script( 'scripts-js', SSPRESS_PLUGIN_URL . '/responsive_player/js/scripts.js', array('jquery'), false, false );
		//wp_enqueue_script( 'amp-iframe', SSPRESS_PLUGIN_URL . '/responsive_player/js/amp-iframe-01.js', array('jquery'), false, false );


		//Just using regular tables for now, not the Bootgrid table
		//wp_enqueue_style( 'jquery-bootgrid-css', $this->plugin_url . 'css/jquery.bootgrid.css', false, $css_version, 'all' );
        //wp_enqueue_script( 'jquery-bootgrid', $this->plugin_url . 'js/jquery.bootgrid.js', array('jquery'), false, true );
		wp_enqueue_style( 'popover-css',SSPRESS_PLUGIN_URL.'/responsive_player/css/jquery.webui-popover.min.css', false, $css_version, 'all' );

	} 



	/**
	 * Description: Prints jQuery in footer on front-end.
	 * Author:      Dominik Schilling
	 * Author URI:  http://wpgrafie.de/
	 */
	function enqueue_jquery( &$scripts ) {

			$scripts->add_data( 'jquery', 'group', 1 );
	}


	/* function template_filter() {

		//if not a page or single post, kick
		if ( !is_single() && !is_page() )
			return;

		remove_filter( 'the_content', 'wpautop' );
		add_filter('template_include', array( $this, 'template_callback' ), 100);
	
	}
	*/
	
		/**
	 * Callback to replace the current template with our blank template
	 * @return string the path to the plugin's template.php
	 */
	/*
	
	function template_callback( $template ) {
		return dirname(__FILE__) . '/template.php';
	}
	*/
	function ssp_timestamp_fn($atts = null)
	{
		
		if( isset( $atts['time'] )) { 
            $time = $atts['time'];
		}
		

		//$arr = split(':',$time);
		$arr = explode(':',$time);
		if ( !isset($arr[2]) ){
				$m = (int)$arr[0];
				$s = (int)$arr[1];
				$interval = $m*60+$s;
		}else{
				$h = (int)$arr[0]; 
				$m = (int)$arr[1];
				$s = (int)$arr[2];
				$interval = $h*3600+$m*60+$s; 
		}
		$ssp_remove_brackets_timestamp = true;
		
			if( ( is_single() && is_main_query() ) || is_page() ){
				if (!$ssp_remove_brackets_timestamp){
					return '<a class="ssp-timestamp" time="'.$interval.'">['.$time.']</a>';
				}else{
					return '<a class="ssp-timestamp" time="'.$interval.'">'.$time.'</a>';
				}
			}
			else{
				if (!$spp_remove_brackets_timestamp){
					return '<span>['.$time.']</span>';  
				}else{
					return '<span>'.$time.'</span>';  
				}
			}
	}
	
	
	private function has_shortcode( $shortcode = '' ) 
	{  
		$post_to_check = get_post(get_the_ID());  
		$found = false;  
		if ( !$shortcode ) 
			return $found;  

		if (empty($post_to_check->ID)){
			return;
		}
		if ( stripos( $post_to_check->post_content, '[' . $shortcode) !== false ) 
			$found = true;  

		return $found;  
	}
	private function has_postmeta() 
	{  
		global $post;
		$found = false;  
		if (empty($post->ID)){
			return;
		}
		$streamid = get_post_meta($post->ID, '_fb_videoid');
		if ($streamid) 
			$found = true;  

		return $found;  
	}
}