<?php header("Content-type: text/css; charset: UTF-8");

$sp_settings = get_option('ssp_settings');    

$container_width = $sp_settings[SSP_CHANNEL]['settings']['sbp_container_width']; 
if ($container_width)
	$container_width = 'max-width: ' . $container_width . 'px;';
else 
	//$container_width = 'max-width: 100%;';
	$container_width = '';

$submit_button_color = $sp_settings[SSP_CHANNEL]['settings']['sbp_submit_button_color'];
if (!$submit_button_color)
	$submit_button_color = '#3b5998';

$submit_button_text = $sp_settings[SSP_CHANNEL]['settings']['sbp_submit_button_text'];
if (!$submit_button_text)
	$submit_button_text = '#ffffff';

$opt_container_color = $sp_settings[SSP_CHANNEL]['settings']['sbp_opt_container_color'];
if (!$opt_container_color)
	$opt_container_color = '#fcfcfc';

if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio_color'])) {
	$btn_sbp_downloadaudio_color = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio_color'];
	if (!$btn_sbp_downloadaudio_color)
		$btn_sbp_downloadaudio_color = '#3b5998';
}
else
	$btn_sbp_downloadaudio_color = '#3b5998';

if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_color'])) {
	$btn_sbp_followblab_color = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_color'];
	if (!$btn_sbp_followblab_color)
		$btn_sbp_followblab_color = '#3b5998';
}
else
	$btn_sbp_followblab_color = '#3b5998';

if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_color'])) {
	$btn_sbp_share_color = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_color'];
	if (!$btn_sbp_share_color)
		$btn_sbp_share_color = '#3b5998';
}
else
	$btn_sbp_share_color = '#3b5998';

$btn_sbp_custom_color1 = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color1'];
if (!$btn_sbp_custom_color1)
	$btn_sbp_custom_color1 = '#3b5998';

$btn_sbp_custom_color2 = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color2'];
if (!$btn_sbp_custom_color2)
	$btn_sbp_custom_color2 = '#3b5998';

$btn_sbp_custom_color3 = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color3'];
if (!$btn_sbp_custom_color3)
	$btn_sbp_custom_color3 = '#3b5998';

$btn_sbp_custom_color4 = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color4'];
if (!$btn_sbp_custom_color4)
	$btn_sbp_custom_color4 = '#3b5998';

$btn_sbp_custom_color5 = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color5'];
if (!$btn_sbp_custom_color5)
	$btn_sbp_custom_color5 = '#3b5998';

$btn_sbp_custom_color6 = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color6'];
if (!$btn_sbp_custom_color6)
	$btn_sbp_custom_color6 = '#3b5998';

$btn_sbpleadbox_color = $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_color'];
if (!$btn_sbpleadbox_color)
	$btn_sbpleadbox_color = '#3b5998';

$minbutton_width = $sp_settings[SSP_CHANNEL]['settings']['sbp_minbutton_width']; 
if ($minbutton_width)
	$minbutton_width = 'min-width: ' . $minbutton_width . 'px !important;';
else 
	$minbutton_width = 'min-width: 130px !important;';

$btn_sbp_downloadaudio_hover = sbpressAdjBrightness($btn_sbp_downloadaudio_color , 30);
$btn_sbp_followblab_hover = sbpressAdjBrightness($btn_sbp_followblab_color , 30);
$btn_sbp_share_hover = sbpressAdjBrightness($btn_sbp_share_color , 30);
$btn_sbp_custom_color1_hover = sbpressAdjBrightness($btn_sbp_custom_color1 , 30);
$btn_sbp_custom_color2_hover = sbpressAdjBrightness($btn_sbp_custom_color2 , 30);
$btn_sbp_custom_color3_hover = sbpressAdjBrightness($btn_sbp_custom_color3 , 30);
$btn_sbp_custom_color4_hover = sbpressAdjBrightness($btn_sbp_custom_color4 , 30);
$btn_sbp_custom_color5_hover = sbpressAdjBrightness($btn_sbp_custom_color5 , 30);
$btn_sbp_custom_color6_hover = sbpressAdjBrightness($btn_sbp_custom_color6 , 30);
$btn_sbpleadbox_color_hover = sbpressAdjBrightness($btn_sbpleadbox_color , 30);


$submit_button_color_hover = 	sbpressAdjBrightness($submit_button_color,30); 

function sbpressAdjBrightness($hex, $steps) {
    // Steps should be between -255 and 255. Negative = darker, positive = lighter
    $steps = max(-255, min(255, $steps));

    // Format the hex color string
    $hex = str_replace('#', '', $hex);
    if (strlen($hex) == 3) {
        $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
    }

    // Get decimal values
    $r = hexdec(substr($hex,0,2));
    $g = hexdec(substr($hex,2,2));
    $b = hexdec(substr($hex,4,2));

    // Adjust number of steps and keep it inside 0 to 255
    $r = max(0,min(255,$r + ($r * ($steps / 255))));
    $g = max(0,min(255,$g + $steps));  
    $b = max(0,min(255,$b + $steps));

    $r_hex = str_pad(dechex($r), 2, '0', STR_PAD_LEFT);
    $g_hex = str_pad(dechex($g), 2, '0', STR_PAD_LEFT);
    $b_hex = str_pad(dechex($b), 2, '0', STR_PAD_LEFT);

    return '#'.$r_hex.$g_hex.$b_hex;
}

$sbp_flat_player = 'true';
$btn_style_round = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_style_round'];
?>


/* Responsive Player */
.sbp-responsive-video {
	position: relative;
	padding-bottom: 56.25%; /* This is default, but will be overriden */
	height: 0;

}


.sbp_poweredby {
font-size:12px;
margin-top: 15px;
}



/* Float Clearing
--------------------------------------------- */

audio:before, audio:after, buttons:before, buttons:after, sbpbuttons:before, sbpbuttons:after, sbp-optin-box:before, sbp-optin-box:after
{
	content: " ";
	display: table;
}



.ssp-fb-container{
margin-bottom: 25px;
clear: both;
<?php echo $container_width; ?>
}

/* responsiveness */

@media only screen and ( max-width: 32.5em ) /* 520 */
{
	body
	{
		/* -webkit-box-shadow: inset 0 0 9.375em rgba( 0, 0, 0, .5 );  */
		/* -moz-box-shadow: inset 0 0 9.375em rgba( 0, 0, 0, 5 );  */
		/* box-shadow: inset 0 0 9.375em rgba( 0, 0, 0, .5 );  */
	}
	#wrapper
	{
		width: 100%;
		height: auto;
		position: static;
		padding: 1.25em; /* 20 */
		margin: 0;
	}



}



/* portrait phone */
@media screen and (max-width:29.9999em) {

}



/* landscape phone and portrait tablet (>= 480px < 960px) */
@media screen and (min-width:30em) and (max-width:59.9999em) {

    .download-box 
    {
        font-weight: normal !important;
        /* text-align: center !important; */
    }


}


/* landscape tablet and normal monitor (>= 960px < 1440px) */
@media screen and (min-width:60em) and (max-width:89.9999em) {
}

/* bigger monitor (>= 1440px) */
@media screen and (min-width:90em) {
}

/* big monitor (>= 1920px) */
@media screen and (min-width:120em) {
}




/* Container Box Properties */

.download-box {
    font-weight: normal !important;
    text-align: center !important;
}






/* Button Properties */

.sbpbuttons {
    text-align: center !important;
	<?php echo $container_width; ?>
	padding-top: 10px;
}

.sbpbuttons a {
	text-decoration: none !important;
}


.sbp-button-twitter, .sbp-button-facebook {
    /* margin-top: 5px !important; */
    width: 250px;
    margin-bottom: 5px !important;
    font-weight: bold !important;
    box-shadow: none !important;
    color: #FFFFFF !important;
    cursor: pointer !important;
    outline: medium none !important;
    padding: 11px 41px 11px 41px !important;
    top: 30px !important;
    text-decoration: none !important;
    font-size: 15px !important;
    display: inline-block;
}


.sbp-button-downloadaudio, .sbp-button-followblab,.sbp-button-share, .sbp-button-custom1, .sbp-button-custom2, .sbp-button-custom3, .sbp-button-custom4, .sbp-button-custom5, .sbp-button-custom6, .sbp-button-leadbox {
    /* margin-top: 5px !important; */
    margin-bottom: 5px !important;
    margin-left: 2px !important;
	<?php echo $minbutton_width; ?>
    font-weight: bold !important;
    box-shadow: none !important;
    color: #FFFFFF !important;
    cursor: pointer !important;
    outline: medium none !important;
    padding: 11px !important;
    top: 30px !important;
    text-decoration: none !important;
    font-size: 15px !important;
    display: inline-block;
}



.button-sbpsidebar {
    
    margin-top: 0px !important;
    text-align: center !important;

    border: 0px solid transparent !important;
    font-weight: bold !important;
    box-shadow: none !important;
    color: #FFFFFF !important;
    cursor: pointer !important;
    outline: medium none !important;
    padding-top: 7px !important;
    padding-bottom: 7px !important;
    text-transform: uppercase !important;
    text-decoration: none !important;
    font-size: 12px !important;
    text-transform: uppercase !important;
    width: 100% !important; 
    line-height: 250% !important;
    display:block !important; 
    
}


.button-sbpsidebar2 {
    
    margin-top: 1px;
    text-align: center !important;

    border: 0px solid transparent !important;
    font-weight: bold !important;
    box-shadow: none !important;
    color: #FFFFFF !important;
    cursor: pointer !important;
    outline: medium none !important;
    padding-top: 7px !important;
    padding-bottom: 7px !important;
    text-transform: uppercase !important;
	top: 30px !important;
    text-decoration: none !important;
    font-size: 12px !important;
    text-transform: uppercase !important;
    width: 98.5% !important; 
    line-height: 250% !important;
    display:inline-table !important; 
      
    
}

.sbp-button-twitter{
    background-color: #00aced; 
}
.sbp-button-facebook{
    background-color: #3b5998;
}
.sbp-button-downloadaudio{
    background-color: <?php echo $btn_sbp_downloadaudio_color; ?>;
}
.sbp-button-followblab{
    background-color: <?php echo $btn_sbp_followblab_color; ?>;
}
.sbp-button-share{
    background-color: <?php echo $btn_sbp_share_color; ?>;
}

.sbp-button-custom1{
    background-color: <?php echo $btn_sbp_custom_color1; ?>;

}
.sbp-button-custom2{
    background-color: <?php echo $btn_sbp_custom_color2; ?>;

}

.sbp-button-custom3{
    background-color: <?php echo $btn_sbp_custom_color3; ?>;

}

.sbp-button-custom4{
    background-color: <?php echo $btn_sbp_custom_color4; ?>;

}
.sbp-button-custom5{
    background-color: <?php echo $btn_sbp_custom_color5; ?>;

}

.sbp-button-custom6{
    background-color: <?php echo $btn_sbp_custom_color6; ?>;

}


.sbp-button-leadbox{

    background-color: <?php echo $btn_sbpleadbox_color; ?>;

}


/* Button Hover Properties */

.button:hover, .sbp-button-downloadaudio:hover, .sbp-button-followblab:hover,.sbp-button-share:hover, .sbp-button-custom1:hover, .sbp-button-custom2:hover, .sbp-button-custom3:hover, .sbp-button-custom4:hover, .sbp-button-custom5:hover, .sbp-button-custom6:hover, .sbp-button-leadbox:hover, .sbp-button-twitter, .sbp-button-facebook {
    color: #FFFFFF !important;
    text-decoration: none !important;
}


.button-sbpsidebar:hover {
}


.sbp-button-twitter:hover{
    background-color: #66ADFF;
}

.sbp-button-facebook:hover{
    background-color: #4c70ba;
}

.sbp-button-downloadaudio:hover{
    background-color: <?php echo $btn_sbp_downloadaudio_hover; ?>;
}

.sbp-button-followblab:hover{
    background-color: <?php echo $btn_sbp_followblab_hover; ?>;
}

.sbp-button-share:hover{
    background-color: <?php echo $btn_sbp_share_hover; ?>;
}

.sbp-button-custom1:hover{
    background-color: <?php echo $btn_sbp_custom_color1_hover; ?>;
}
.sbp-button-custom2:hover{
    background-color: <?php echo $btn_sbp_custom_color2_hover; ?>;
}

.sbp-button-custom3:hover{
    background-color: <?php echo $btn_sbp_custom_color3_hover; ?>;
}

.sbp-button-custom4:hover{
    background-color: <?php echo $btn_sbp_custom_color4_hover; ?>;
}
.sbp-button-custom5:hover{
    background-color: <?php echo $btn_sbp_custom_color5_hover; ?>;
}

.sbp-button-custom6:hover{
    background-color: <?php echo $btn_sbp_custom_color6_hover; ?>;
}

.sbp-button-leadbox:hover{
    background-color: <?php echo $btn_sbpleadbox_color_hover; ?>;
}


/* sbp Optin Box Properties */

.sbp-optin-box {
display:inline-table !important;
text-align: center !important;
box-sizing: border-box !important;
clear: both !important;
color: rgb(34, 34, 34) !important;
display: block !important;
font-size: 15px !important;
line-height: 18px !important;
margin-bottom: 0px !important;
margin-left: 0px !important;
margin-right: 0px !important;
margin-top: 5px !important;
<?php echo $container_width; ?>
}



.sbp-optin-box-padding {
background-color: <?php echo $opt_container_color; ?> !important;
background-position: 50% 0% !important;
background-repeat: no-repeat !important;
border-bottom-style: solid !important;
border-bottom-width: 0px !important;
border-image-outset: 0px !important;
border-image-repeat: stretch !important;
border-image-slice: 100% !important;
border-image-source: none !important;
border-image-width: 1 !important;
border-left-style: solid !important;
border-left-width: 0px !important;
border-right-style: solid !important;
border-right-width: 0px !important;
border-top-left-radius: 0px !important;
border-top-right-radius: 0px !important;
border-bottom-left-radius: 0px !important;
border-bottom-right-radius: 0px !important;
border-top-style: solid !important;
border-top-width: 0px !important;
box-sizing: border-box !important;
color: rgb(34, 34, 34) !important;
display: block !important;
font-size: 15px !important;

line-height: 18px !important;
margin-bottom: 0px !important;
margin-left: 0px !important;
margin-right: 0px !important;
margin-top: 0px !important;
padding-bottom: 15px !important;
padding-left: 15px !important; 
padding-right: 15px !important;
padding-top: 15px !important;
}



.sbp-optin-box-form-wrap form {
padding-top:10px;
margin:0 !important;
}

.clear-subscribe {
clear:both !important;
}

.sbp-optin-box-content {
text-align: center !important;
box-sizing: border-box !important;
color: rgb(40, 40, 40) !important;
display: block !important;
font-size: 15px !important;
line-height: 18px !important;
position: relative !important;
z-index: 10 !important;
}


@media only screen and (max-width:480px){

.subscribetxt{
font-size: 17px !important;
}


}

@media only screen and (max-width: 600px){
/* height:166px !important; */
}



.sbp-optin-box-headline {
word-break: normal !important;
text-align: center !important;
box-sizing: border-box !important;
clear: none !important;
color: rgb(40, 40, 40) !important;
display: inline-block !important;
font-size: 25px !important;
font-style: normal !important;
font-weight: bold !important;
letter-spacing: normal !important;
line-height: 23px !important;
margin-bottom: 7px !important;
margin-left: 0px !important;
margin-right: 0px !important;
margin-top: 0px !important;
text-transform: none !important;
}


.sbp-optin-box-subheadline {
word-break: normal !important;
text-align: center !important;
box-sizing: border-box !important;
clear: none !important;
color: rgb(85, 85, 85) !important;
display: block !important;
font-size: 20px !important;
font-style: normal !important;
font-weight: bold !important;
line-height: 18px !important;
margin-bottom: 10px !important;
margin-left: 0px !important;
margin-right: 0px !important;
margin-top: 0px !important;
text-transform: none !important;
font-family:Arial, Helvetica, sans-serif !important;
}



.sbp-optin-box-form-wrap {
box-sizing: border-box !important;
color: rgb(40, 40, 40) !important;
display: block !important;
font-size: 15px !important;
line-height: 18px !important;
overflow-x: hidden !important;
overflow-y: hidden !important;
}

.sbp-optin-box-field {
text-align: center !important;
box-sizing: border-box !important;
color: rgb(40, 40, 40) !important;
display: inline-block !important;
/* text-transform: uppercase !important; */
border: 2px solid transparent !important;
line-height: 18px !important;
margin-bottom: 10px !important;
margin-left: 0px !important;
margin-right: 0px !important;
margin-top: 0px !important;
max-width: 400px !important; /* 200 */
min-width:200px !important; /* 170 */
zoom: 1 !important;

box-shadow: none !important;
-webkit-box-shadow: none !important;
-moz-box-shadow: none !important;
}
.sbp-optin-box-field-submit input[type='submit'][disabled]{
	background-color: #EBEBE4 !important;
}

.sbp-optin-box-field-submit {
text-align: center !important;
box-sizing: border-box !important;
color: rgb(40, 40, 40) !important;
display: inline-block !important;
font-size: 15px !important;  /* 15px */
/* text-transform: uppercase !important; */
border: 2px solid transparent !important;
line-height: 18px !important;
margin-bottom: 10px !important;
margin-left: 0px !important;
margin-right: 0px !important;
margin-top: 10px !important;
zoom: 1 !important;

box-shadow: none !important;
-webkit-box-shadow: none !important;
-moz-box-shadow: none !important;
}

.sbp-optin-box-field input[type*="text"]{
text-align: center !important;
font-size: 15px !important; /* 15px */
height: 46px !important;
line-height: 18px !important;
border: 2px solid transparent !important;
margin:0;
display: inline-block !important;
width: 90% !important;
border-radius: 0px !important;
background-color: #FFFFFF !important;
border: 1px solid #CCCCCC !important;
padding-left: 5px !important; 
padding-right: 5px !important; 
padding-top: 0px !important;
padding-bottom: 0px !important;
box-shadow: none !important;
-webkit-box-shadow: none !important;
-moz-box-shadow: none !important;
vertical-align: middle !important;

}


sbp-optin-box-field input[type*="text"]:focus {
  box-shadow: 0 0 0px rgba(0, 0, 0, 0) !important;
  padding: 0px 0px 0px 0px !important;
  margin: 0px 0px 0px 0px !important;
  border: 0px solid rgba(0, 0, 0, 0) !important;
}



.sbp-optin-box-lastfield-second-row {
text-align: center !important;
box-sizing: border-box !important;
color: rgb(40, 40, 40) !important;
display: block !important;
font-size: 15px !important; /* 15px */
height: 40px !important;
line-height: 18px !important;
margin-bottom: 10px !important;
margin-left: 0px !important;
margin-right: 0px !important;
margin-top: 0px !important;
width: auto !important;
zoom: 1 !important;
padding-left: 20px !important; 
padding-right: 20px !important; 

}

.sbp-optin-box-lastfield {
text-align: center !important;
box-sizing: border-box !important;
color: rgb(40, 40, 40) !important;
display: inline-block !important;
font-size: 15px !important;  /* 15px */
/* text-transform: uppercase !important; */
border: 2px solid transparent !important;
line-height: 18px !important;
margin-bottom: 10px !important;
margin-left: 0px !important;
margin-right: 0px !important;
margin-top: 0px !important;
max-width: 400px !important; /* 200 */
min-width:200px !important; /* 170 */
zoom: 1 !important;
box-shadow: none !important;
-webkit-box-shadow: none !important;
-moz-box-shadow: none !important;


}

.sbp-optin-box-lastfield input[type*="submit"] {
text-align: center !important;
line-height: 18px !important; 
margin-top: 0px !important; 
vertical-align: middle !important;
}


.sbp-optin-box-submit {
-webkit-appearance: none !important;
-webkit-background-clip: border-box !important;
-webkit-background-origin: padding-box !important;
-webkit-background-size: auto !important;
-webkit-box-shadow: none !important;
-webkit-rtl-ordering: logical !important;
-webkit-user-select: text !important;
-webkit-writing-mode: horizontal-tb !important;
align-items: flex-start !important;
background-attachment: scroll !important;
background-clip: border-box !important;
background-color: <?php echo $submit_button_color; ?> !important;
background-image: none !important;
background-origin: padding-box !important;
background-size: auto;
border-bottom-color: <?php echo $submit_button_color; ?> !important;
border-bottom-left-radius: 0px !important;
border-bottom-right-radius: 0px !important;
border-bottom-style: solid !important;
border-bottom-width: 3px !important;
border-image-outset: 0px !important;
border-image-repeat: stretch !important;
border-image-slice: 100% !important;
border-image-source: none !important;
border-image-width: 1 !important;
border-left-color: <?php echo $submit_button_color; ?> !important;
border-left-style: solid !important;
border-left-width: 3px !important;
border-right-color: <?php echo $submit_button_color; ?> !important;
border-right-style: solid !important;
border-right-width: 3px !important;
border-top-color: <?php echo $submit_button_color; ?> !important;
border-top-left-radius: 0px !important;
border-top-right-radius: 0px !important;
border-top-style: solid !important;
border-top-width: 3px !important;
box-shadow: none !important;
box-sizing: border-box !important;
color: <?php echo $submit_button_text; ?> !important;
cursor: pointer !important;
display: inline-block !important;
font-size: 15px !important;  /* 16px */
font-style: normal !important;
letter-spacing: normal !important;
line-height: 18px !important;
margin-bottom: 0px !important;
margin-left: 0px !important;
margin-right: 0px !important;
margin-top: 0px !important;
max-width: 100% !important;
padding-bottom: 5px !important;
padding-left: 5px !important; 
padding-right: 5px !important; 
padding-top: 5px !important;
text-align: center !important;
text-indent: 0px !important;
text-shadow: none !important;
text-transform: none !important;
border: 2px solid transparent !important;
white-space: pre !important;
width: auto !important;
word-spacing: 0px !important;
/* writing-mode: lr-tb !important; */
zoom: 1 !important;
text-align: center !important;

border: 2px solid transparent !important;

    font-weight: bold !important;
    box-shadow: none !important;
    color: #FFFFFF !important;
    cursor: pointer !important;
    outline: medium none !important;
    padding: 14px !important;
    border-radius: 0px !important;
    text-decoration: none !important;
background-color: <?php echo $submit_button_color; ?> !important;
border: <?php echo $submit_button_color; ?> !important;
color: <?php echo $submit_button_text; ?> !important;
vertical-align: middle !important;

}
.sbp-optin-box-submit:hover{

background-color:<?php echo $submit_button_color_hover; ?> !important;

}



@media only screen and (max-width:480px){


.sbp-optin-box-subheadline{
}

.subscribetxt{
font-size: 17px !important;
}


}

@media only screen and (max-width: 600px) and (max-width: 700px){

}
@media (max-width: 767px) {
/* height:221px !important; */
}

@media (min-width: 768px) and (max-width: 778px) {

}
@media (min-width: 768px) and (max-width: 979px) {

}


.ssp-video-container {
  position: relative;
  height: 0;
  overflow: hidden;
}

/* 16x9 Aspect Ratio */
.ssp-video-container-16x9 {
  padding-bottom: 56.25%;
}

/* 4x3 Aspect Ratio */
.ssp-video-container-4x3 {
  padding-bottom: 75%;
}

.ssp-video-container iframe {
  position: absolute;
  top:0;
  left: 0;
  width: 100%;
  height: 100%;
}




/* Blab Tables */

.releasedColumn
{
	width: 17%;
}
	
.downloadColumn { 
	width: 15%;
}

td.sbp-episodes-released, td.sbp-episodes-released-title  { 
	width: 17%;
}
td.sbp-episodes-download, td.sbp-episodes-download-title { 
	width: 15%;
	text-align: center;
}

td.sbp-episodes-released-title, td.sbp-episodes-podcast-title {
	font-weight: bold;
}
.ssp-timestamp{
    cursor: pointer;
}

/* Round buttons and opt-in box - must be at the end */
<?php if ($btn_style_round == 1){ ?>

 .sbp-button-downloadaudio, .sbp-button-followblab, .sbp-button-share, .sbp-button-custom1, .sbp-button-custom2, .sbp-button-custom3, .sbp-button-custom4, .sbp-button-custom5, .sbp-button-custom6, .sbp-button-leadbox, .sbp-optin-box-lastfield input[type*="submit"], .sbp-optin-box-field input[type*="text"], .sbp-optin-box-submit, .sbp-optin-box-submit-button, .sbp-button-twitter, .sbp-button-facebook {
		
		-webkit-border-radius: 4px !important;
		-moz-border-radius: 4px !important;
        border-radius: 4px !important;
        vertical-align: middle !important;
}

<?php } ?>