<?php 


if (!defined('ABSPATH')) die();

if (!class_exists('SSP_CFG_CustomFields')) {
	
	class SSP_CFG_CustomFields {
		
		function __construct() {
			
			$this->constants();
			$this->includes();
			
			add_action('admin_print_scripts',   'ssp_cfg_admin_print_scripts');

			
			add_action('enqueue_block_editor_assets', 'ssp_cfg_load_assets_editor');
			add_action('add_meta_boxes',              'ssp_cfg_add_meta_box');
			add_action('save_post',array($this,"ssp_cfg_metabox_save"));
			
		} 
		
		function constants() {
			
			if (!defined('SSP_CFG_URL'))     define('SSP_CFG_URL',     plugin_dir_url(__FILE__));
			if (!defined('SSP_CFG_DIR'))     define('SSP_CFG_DIR',     plugin_dir_path(__FILE__));
			if (!defined('SSP_CFG_FILE'))    define('SSP_CFG_FILE',    plugin_basename(__FILE__));
			if (!defined('SSP_CFG_SLUG'))    define('SSP_CFG_SLUG',    basename(dirname(__FILE__)));
			
		}
		
		function includes() {
			
			if (is_admin()) {
				
				require_once SSP_CFG_DIR .'inc/plugin-core.php';
				require_once SSP_CFG_DIR .'inc/resources-enqueue.php';				
			}
			
		}
		function ssp_cfg_metabox_save($post_id,$cron=false)
		{
			if (!$cron) {
				if ((empty($_POST['meta[303153][value]'])) || (!get_post_meta($post_id, '_fb_videoid', true)))
					return;

				$audio_url = $_POST['meta[303153][value]'];

				update_post_meta($post_id, '_fb_videoid', $audio_url);
			}
		}
		
	}
	
	$SSP_CFG_CustomFields = new SSP_CFG_CustomFields(); 
	
}
