<?php // plugin core

if (!defined('ABSPATH')) exit;

function ssp_cfg_add_meta_box() {
	
	global $post;
	
	$wp_version = get_bloginfo('version');
	
	$is_version_wp = version_compare($wp_version, '4.9.8', '>');
	
	$is_gutenberg_plugin = is_plugin_active('gutenberg/gutenberg.php');
	
	if (!$is_version_wp && !$is_gutenberg_plugin) return;
	
	if (isset($_GET['classic-editor'])) return;
	
	// if (!has_meta($post->ID)) return; // always show Custom Fields
	$meta_exist =  get_post_meta($post->ID, '_fb_videoid', true); 
	if (empty($meta_exist)) {
		return;
	}
	
	foreach (ssp_cfg_get_post_types() as $post_type) {
		
		add_meta_box('ssp_cfg_custom_fields', __('SSP Custom Fields', 'custom-fields-gutenberg'), 'ssp_cfg_display_meta_box', $post_type, 'normal');
		
	}
	
}

function ssp_cfg_display_meta_box($post) {
	
	$metadata = has_meta($post->ID);
	
	if ($metadata) {
		
		echo '<div class="g7g-meta-box">';
		
		if (ssp_cfg_display_row_table($metadata)) {
			
			echo '<table>';
			echo '<thead>';
			echo '<tr>';
			echo '<th>'. __('Name',  'custom-fields-gutenberg') .'</th>';
			echo '<th>'. __('Value', 'custom-fields-gutenberg') .'</th>';
			echo '</tr>';
			echo '</thead>';
			echo '<tbody>';
			
			foreach ($metadata as $meta) {
				
				echo ssp_cfg_list_meta_row($meta);
				
			}
			
			echo '</tbody>';
			echo '</table>';
			
		}
		
		echo ssp_cfg_meta_form($post);
		
		echo '</div>';
		
	}

}
function ssp_cfg_metabox_save($post_id,$cron=false)
{
	if (!$cron) {
		if ((empty($_POST['meta[303153][value]'])) || (!get_post_meta($post_id, '_fb_videoid', true)))
			return;

		$audio_url = $_POST['meta[303153][value]'];

		update_post_meta($post_id, '_fb_videoid', $audio_url);
	}
}
function ssp_cfg_list_meta_row($meta) {
	
	$meta_key = isset($meta['meta_key'])   ? esc_attr($meta['meta_key']) : null;
	$meta_val = isset($meta['meta_value']) ? esc_textarea($meta['meta_value']) : null;
	$meta_id  = isset($meta['meta_id'])    ? (int) $meta['meta_id'] : null;
	$post_id  = isset($meta['post_id'])    ? (int) $meta['post_id'] : null;
	
	if (empty($meta_key)) {
		
		delete_metadata_by_mid('post', $meta_id);
		
		return '';
		
	}
	
	if (!ssp_cfg_display_protected($meta_key)) return '';

	if (!ssp_cfg_display_empty($meta_val)) return '';
	
	if (!ssp_cfg_display_field($meta_key)) return '';
	
	if (is_serialized($meta_val)) {
		
		if (is_serialized_string($meta_val)) $meta_val = maybe_unserialize($meta_val);
		
		else return '';
		
	}
	
	$r  = '<tr id="meta-'. $meta_id .'">';
	
	$r .= '<td><label class="screen-reader-text" for="meta-'. $meta_id .'-key">'. __('Key', 'custom-fields-gutenberg') .'</label>';
	
	$r .= '<input name="meta['. $meta_id .'][key]" id="meta-'. $meta_id .'-key" disable type="text" size="20" value="'. $meta_key .'" disabled="disabled" />';
	
	$r .= wp_nonce_field('change-meta', '_ajax_nonce', false, false);
	
	$r .= '</td>';
	
	$r .= '<td><label class="screen-reader-text" for="meta-'. $meta_id .'-value">'. __('Value', 'custom-fields-gutenberg') .'</label>';
	
	$r .= '<textarea name="meta['. $meta_id .'][value]" id="meta-'. $meta_id .'-value" rows="2" cols="30">'. $meta_val .'</textarea>';
	
	$r .= '</td>';
	
	$r .= '</tr>';
	
	return $r;
	
}

function ssp_cfg_meta_form($post = null) {
	
	global $wpdb;
	
	$post = get_post($post);
	
	$keys = apply_filters('postmeta_form_keys', null, $post);
	
	if (null === $keys) {
		
		$limit = apply_filters('postmeta_form_limit', 30);
		
		$sql = "SELECT DISTINCT meta_key 
				FROM $wpdb->postmeta 
				WHERE meta_key NOT BETWEEN '_' AND '_z' 
				HAVING meta_key NOT LIKE %s 
				ORDER BY meta_key 
				LIMIT %d";
		
		$keys = $wpdb->get_col($wpdb->prepare($sql, $wpdb->esc_like('_') . '%', $limit));
		
	}

	if ($keys) {
		
		natcasesort($keys);
		
		$meta_key_input_id = 'metakeyselect';
		
	} else {
		
		$meta_key_input_id = 'metakeyinput';
		
	}
	
	?>
	
	<?php
	
}

function ssp_cfg_display_row_table($metadata) {
	
	
	$exclude_protected = 0;
	$exclude_empty     = 0;
	
	$display = false;
	
	if (!is_array($metadata)) return false;
	
	foreach ($metadata as $meta) {
		
		$meta_key = isset($meta['meta_key'])   ? $meta['meta_key']   : null;
		$meta_val = isset($meta['meta_value']) ? $meta['meta_value'] : null;
		
		if (substr($meta_key, 0, 1) !== '_') {
			
			if (!empty($meta_val)) {
				
				$display = true;
				break;
				 
			} elseif (empty($meta_val) && !$exclude_empty) {
				
				$display = true;
				break;
				
			}
			
		} else {
			
			if (!$exclude_protected) {
				
				if (!empty($meta_val)) {
					
					$display = true;
					break;
					 
				} elseif (empty($meta_val) && !$exclude_empty) {
					
					$display = true;
					break;
					
				}
				
			}
			
		}
		
	}
	
	return $display;
	
}

function ssp_cfg_get_post_types() {
	
	$post_types = get_post_types(array(), 'objects');
	
	$unset = array('attachment', 'revision', 'nav_menu_item', 'custom_css', 'customize_changeset', 'oembed_cache');
	
	$unset = apply_filters('ssp_cfg_post_types_unset', $unset);
	
	$types = array();
	
	foreach($post_types as $key => $post_type) {
		
		$types[$key]['name']  = $post_type->name;
		$types[$key]['label'] = $post_type->label;
		
		if (in_array($post_type->name, $unset) || !post_type_supports($post_type->name, 'custom-fields')) unset($types[$key]);
		
	}
	
	return apply_filters('ssp_cfg_get_post_types', $types);
	
}


function ssp_cfg_display_protected($meta_key) {
		
	return true;
	
}

function ssp_cfg_display_empty($meta_val) {
	
	
	return true;
	
}

function ssp_cfg_display_field($meta_key) {
	if ($meta_key !='_fb_videoid')
		return false;
	else 
		return true;
	
}

function ssp_cfg_random_string($length = 10) {
	
	$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	
	$charactersLength = strlen($characters);
	
	$randomString = '';
	
	for ($i = 0; $i < $length; $i++) {
		
		$randomString .= $characters[rand(0, $charactersLength - 1)];
		
	}
	
	return $randomString;
	
}

