<?php

namespace wpbuddy\rich_snippets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$helper = \wpbuddy\rich_snippets\pro\Helper_Model::instance();

switch ( $helper->user_has_valid_support() ) {
	case 'valid':
		$icon       = 'yes';
		$str        = __( 'Cool! You are eligible for support until %1$s.', 'rich-snippets-schema' );
		$renew_form = false;
		break;
	case 'about-to-expire':
		$icon = 'warning';
		$str  = _x(
			'Your item support will soon end (on %1$s). However still %2$s to go!',
			'First is the exact date. Second is the human time diff.',
			'rich-snippets-schema'
		);
		$renew_form = true;
		break;
	case 'expired':
		$icon = 'no';
		$str  = __( 'Oh no! You are not eligible for support. It has expired on %1$s.', 'rich-snippets-schema' );
		$renew_form = true;
		break;
}

if ( isset( $str ) ) {
	$str = sprintf(
		$str,
		date_i18n( get_option( 'date_format', 'd.m.Y' ), $helper->get_user_support_expiration_date() ),
		human_time_diff( current_time( 'timestamp' ), $helper->get_user_support_expiration_date() )
	);

	?>
    <div class="wpb-rs-support-validity">
        <span class="dashicons dashicons-<?php echo $icon; ?>"></span>
        <p><?php echo $str; ?></p>
    </div>
	<?php if ( isset( $renew_form ) ): ?>
        <a target="_blank" class="button"
           href="<?php echo esc_url( $helper->get_campaignify( 'https://rich-snippets.io/ext/renew-support', 'validity-metabox' ) ); ?>"
           target="_blank"><?php _e( 'Renew support now', 'rich-snippets-schema' ); ?></a>
	<?php endif;
} else {
	_e( 'The plugin was not able to gather any information for your purchase code.', 'rich-snippets-schema' );
}

