<?php

namespace wpbuddy\rich_snippets\pro;

use wpbuddy\rich_snippets\WPBuddy_Model;
use function wpbuddy\rich_snippets\rich_snippets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


/**
 * Class Updates-
 *
 * Performs plugin updates (if any).
 *
 * @package wpbuddy\rich_snippets
 *
 * @since   2.0.0
 */
final class Update_Model {
	/**
	 * Writes information into the
	 *
	 * @param bool $original
	 * @param string $action
	 * @param \stdClass $args
	 *
	 * @return bool|object
	 * @since 2.0.0
	 *
	 */
	public static function update_window_information( $original = false, string $action = '', $args = null ) {

		if ( 'plugin_information' != $action ) {
			return $original;
		}

		if ( ! isset( $args->slug ) ) {
			return $original;
		}

		$plugin_basename = plugin_basename( rich_snippets()->get_plugin_file() );

		if ( $args->slug !== $plugin_basename ) {
			return $original;
		}

		if ( ! function_exists( 'get_plugin_data' ) ) {
			$file = ABSPATH . 'wp-admin/includes/plugin.php';

			if ( is_file( $file ) ) {
				require $file;
			} else {
				return $original;
			}
		}

		$pluginData = get_plugin_data( rich_snippets()->get_plugin_file(), false, false );

		$latestData = Update_Controller::check_plugin_update( false, $pluginData );

		if ( ! is_array( $latestData ) ) {
			return $original;
		}

		return (object) $latestData;
	}

}
