<?php

namespace wpbuddy\rich_snippets\pro;

use wpbuddy\rich_snippets\WPBuddy_Model;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


/**
 * Class Helper.
 *
 * Helps to fetch some data.
 *
 * @package wpbuddy\rich_snippets
 *
 * @since   2.19.0
 */
class Helper_Model extends \wpbuddy\rich_snippets\Helper_Model {
	/**
	 * @return \wpbuddy\rich_snippets\Helper_Model|Helper_Model|null
	 */
	public static function instance() {

		if ( null === self::$_instance ) {
			self::$_instance = new self;
		}

		return self::$_instance;
	}

	/**
	 * Magic function.
	 *
	 * @return bool
	 *
	 * @since 2.3.0
	 */
	public function magic() {

		if ( true !== boolval( get_option( base64_decode( 'd3BiX3JzL3ZlcmlmaWVk' ), false ) ) ) {
			return false;
		}

		if ( true !== boolval( get_option( 'd3BiX3JzL3ZlcmlmaWVk', false ) ) ) {
			return false;
		}

		return true;
	}


	/**
	 * Returns the value from the string $name.
	 *
	 * @param array|object $var
	 * @param string $name
	 *
	 * @return mixed
	 * @since 2.10.0
	 */
	public function get_deep( $var, $name ) {
		$names       = explode( '->', $name );
		$names       = array_filter( $names ); # filter empty values
		$search_name = array_shift( $names );

		if ( is_array( $var ) && isset( $var[ $search_name ] ) ) {
			if ( count( $names ) > 0 ) {
				return $this->get_deep( $var[ $search_name ], implode( '->', $names ) );
			} else {
				return $var[ $search_name ];
			}
		}

		if ( is_object( $var ) && isset( $var->{$search_name} ) ) {
			if ( count( $names ) > 0 ) {
				return $this->get_deep( $var->{$search_name}, implode( '->', $names ) );
			} else {
				return $var->{$search_name};
			}
		}

		return $var;
	}


	/**
	 * Checks if a user has valid support.
	 *
	 * @since 2.19.13
	 */
	public function user_has_valid_support() {
		$response = WPBuddy_Model::request(
			'/wpbuddy/rich_snippets_manager/v1/support?field=supported_until'
		);

		if ( is_object( $response ) && isset( $response->supported_until ) ) {
			$supported_until = absint( $response->supported_until );

			if ( current_time( 'timestamp' ) <= ( $supported_until - MONTH_IN_SECONDS ) ) {
				return 'valid';
			} else if ( current_time( 'timestamp' ) <= $supported_until ) {
				return 'about-to-expire';
			} else {
				return 'expired';
			}
		}

		return 'no-connection';
	}

	/**
	 * Get support expiration timestamp.
	 *
	 * @return int
	 * @since 2.19.13
	 */
	public function get_user_support_expiration_date() {
		$response = WPBuddy_Model::request(
			'/wpbuddy/rich_snippets_manager/v1/support?field=supported_until'
		);

		if ( is_object( $response ) && isset( $response->supported_until ) ) {
			return $response->supported_until;
		}

		return 0;
	}

	/**
	 * Filters HTML.
	 *
	 * @param string $content
	 * @param array $allowed_html
	 *
	 * @return string
	 * @see https://developers.google.com/search/docs/data-types/faqpage#answer
	 *
	 * @since 2.2.4.0
	 */
	public function filter_html( $content, $allowed_html = [] ) {
		if ( count( $allowed_html ) <= 0 ) {
			$allowed_html = [
				'h1'     => [],
				'h2'     => [],
				'h3'     => [],
				'h4'     => [],
				'h5'     => [],
				'h6'     => [],
				'br'     => [],
				'ol'     => [],
				'ul'     => [],
				'li'     => [],
				'a'      => [
					'href' => array(),
				],
				'p'      => [],
				'div'    => [],
				'b'      => [],
				'strong' => [],
				'i'      => [],
				'em'     => [],
			];
		}

		/**
		 * Allowed HTML filter.
		 *
		 * Allows to change what HTML types are allowed on input fields.
		 *
		 * @hook  wpbuddy/rich_snippets/allowed_html
		 *
		 * @param {array} $allowed_html Array of allowed HTML tags. @see wp_kses() function in WordPress.
		 * @param {string} $content The value of the current field.
		 *
		 * @returns {array} Array of allowed HTML tags. @see wp_kses() function in WordPress.
		 *
		 * @since 2.24.0
		 */
		$allowed_html = apply_filters( 'wpbuddy/rich_snippets/allowed_html', $allowed_html, $content );


		return wp_kses( $content, $allowed_html );
	}
}