<?php

namespace wpbuddy\rich_snippets\pro;

use wpbuddy\rich_snippets\Position_Rule;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


/**
 * Class Admin_Position_Controller
 *
 * Starts up all the admin things needed to positioning snippets.
 *
 * @package wpbuddy\rich_snippets\pro
 *
 * @since   2.19.14
 */
class Admin_Position_Controller extends \wpbuddy\rich_snippets\Admin_Position_Controller {

	/**
	 * Get the singleton instance.
	 *
	 * Creates a new instance of the class if it does not exists.
	 *
	 * @return   Admin_Position_Controller
	 *
	 * @since 2.0.0
	 */
	public static function instance() {

		if ( null === self::$_instance ) {
			self::$_instance = new self;
		}

		return self::$_instance;
	}

	/**
	 * Init the controller.
	 *
	 * @since 2.19.14
	 */
	public function init() {
		parent::init();
		add_filter( 'wpbuddy/rich_snippets/position/params', [
			self::instance(),
			'position_params'
		] );

	}

	/**
	 * Activate disabled rule params from the FREE version.
	 *
	 * @param $params
	 *
	 * @return mixed
	 *
	 * @since 2.19.14
	 */
	public function position_params( $params ) {
		$set_to_true = [
			'post_type',
			'post',
			'post_template',
			'post_status',
			'post_format',
			'post_category',
			'child_terms',
			'post_taxonomy',
			'page_template',
			'page_type',
			'page_parent',
			'user',
		];

		foreach ( $params as $group_key => $group ) {
			foreach ( $group['params'] as $param_key => $param ) {
				if ( ! in_array( $param_key, $set_to_true, true ) ) {
					continue;
				}

				$params[ $group_key ]['params'][ $param_key ]['active'] = true;
			}
		}

		return $params;
	}

}