/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */
!(function webpackUniversalModuleDefinition(e, t) {
    'object' == typeof exports && 'object' == typeof module
        ? (module.exports = t())
        : 'function' == typeof define && define.amd
        ? define('pdfjs-dist/build/pdf.worker', [], t)
        : 'object' == typeof exports
        ? (exports['pdfjs-dist/build/pdf.worker'] = t())
        : (e['pdfjs-dist/build/pdf.worker'] = e.pdfjsWorker = t());
})(this, function () {
    return (() => {
        'use strict';
        var e = [
                ,
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.WorkerTask = t.WorkerMessageHandler = void 0;
                    var a = r(2),
                        i = r(5),
                        n = r(7),
                        s = r(64),
                        o = r(4),
                        c = r(89),
                        l = r(90),
                        h = r(9);
                    class WorkerTask {
                        constructor(e) {
                            this.name = e;
                            this.terminated = !1;
                            this._capability = (0, a.createPromiseCapability)();
                        }
                        get finished() {
                            return this._capability.promise;
                        }
                        finish() {
                            this._capability.resolve();
                        }
                        terminate() {
                            this.terminated = !0;
                        }
                        ensureNotTerminated() {
                            if (this.terminated) throw new Error('Worker task was terminated');
                        }
                    }
                    t.WorkerTask = WorkerTask;
                    class WorkerMessageHandler {
                        static setup(e, t) {
                            let r = !1;
                            e.on('test', function wphSetupTest(t) {
                                if (r) return;
                                r = !0;
                                if (!(t instanceof Uint8Array)) {
                                    e.send('test', null);
                                    return;
                                }
                                const a = 255 === t[0];
                                e.postMessageTransfers = a;
                                e.send('test', { supportTransfers: a });
                            });
                            e.on('configure', function wphConfigure(e) {
                                (0, a.setVerbosityLevel)(e.verbosity);
                            });
                            e.on('GetDocRequest', function wphSetupDoc(e) {
                                return WorkerMessageHandler.createDocumentHandler(e, t);
                            });
                        }
                        static createDocumentHandler(e, t) {
                            let r,
                                o = !1,
                                u = null;
                            const d = [],
                                f = (0, a.getVerbosityLevel)(),
                                g = e.apiVersion,
                                p = '2.9.359';
                            if (g !== p)
                                throw new Error(`The API version "${g}" does not match the Worker version "2.9.359".`);
                            const m = [];
                            for (const e in []) m.push(e);
                            if (m.length)
                                throw new Error(
                                    'The `Array.prototype` contains unexpected enumerable properties: ' +
                                        m.join(', ') +
                                        '; thus breaking e.g. `for...in` iteration of `Array`s.'
                                );
                            if ('undefined' == typeof ReadableStream)
                                throw new Error(
                                    'The browser/environment lacks native support for critical functionality used by the PDF.js library (e.g. `ReadableStream`); please use a `legacy`-build instead.'
                                );
                            const b = e.docId,
                                y = e.docBaseUrl,
                                w = e.docId + '_worker';
                            let S = new c.MessageHandler(w, b, t);
                            S.postMessageTransfers = e.postMessageTransfers;
                            function ensureNotTerminated() {
                                if (o) throw new Error('Worker was terminated');
                            }
                            function startWorkerTask(e) {
                                d.push(e);
                            }
                            function finishWorkerTask(e) {
                                e.finish();
                                const t = d.indexOf(e);
                                d.splice(t, 1);
                            }
                            async function loadDocument(e) {
                                await r.ensureDoc('checkHeader');
                                await r.ensureDoc('parseStartXRef');
                                await r.ensureDoc('parse', [e]);
                                e || (await r.ensureDoc('checkFirstPage'));
                                const [t, a, i] = await Promise.all([
                                    r.ensureDoc('numPages'),
                                    r.ensureDoc('fingerprint'),
                                    r.ensureDoc('isPureXfa'),
                                ]);
                                if (i) {
                                    const e = new WorkerTask('loadXfaFonts');
                                    startWorkerTask(e);
                                    await r
                                        .loadXfaFonts(S, e)
                                        .catch((e) => {})
                                        .then(() => finishWorkerTask(e));
                                }
                                return { numPages: t, fingerprint: a, isPureXfa: i };
                            }
                            function getPdfManager(e, t, r) {
                                const i = (0, a.createPromiseCapability)();
                                let s;
                                const o = e.source;
                                if (o.data) {
                                    try {
                                        s = new n.LocalPdfManager(b, o.data, o.password, t, r, y);
                                        i.resolve(s);
                                    } catch (e) {
                                        i.reject(e);
                                    }
                                    return i.promise;
                                }
                                let c,
                                    h = [];
                                try {
                                    c = new l.PDFWorkerStream(S);
                                } catch (e) {
                                    i.reject(e);
                                    return i.promise;
                                }
                                const d = c.getFullReader();
                                d.headersReady
                                    .then(function () {
                                        if (!d.isRangeSupported) return;
                                        const e = o.disableAutoFetch || d.isStreamingSupported;
                                        s = new n.NetworkPdfManager(
                                            b,
                                            c,
                                            {
                                                msgHandler: S,
                                                password: o.password,
                                                length: d.contentLength,
                                                disableAutoFetch: e,
                                                rangeChunkSize: o.rangeChunkSize,
                                            },
                                            t,
                                            r,
                                            y
                                        );
                                        for (let e = 0; e < h.length; e++) s.sendProgressiveData(h[e]);
                                        h = [];
                                        i.resolve(s);
                                        u = null;
                                    })
                                    .catch(function (e) {
                                        i.reject(e);
                                        u = null;
                                    });
                                let f = 0;
                                new Promise(function (e, c) {
                                    const readChunk = function ({ value: e, done: l }) {
                                        try {
                                            ensureNotTerminated();
                                            if (l) {
                                                s ||
                                                    (function () {
                                                        const e = (0, a.arraysToBytes)(h);
                                                        o.length &&
                                                            e.length !== o.length &&
                                                            (0, a.warn)(
                                                                'reported HTTP length is different from actual'
                                                            );
                                                        try {
                                                            s = new n.LocalPdfManager(b, e, o.password, t, r, y);
                                                            i.resolve(s);
                                                        } catch (e) {
                                                            i.reject(e);
                                                        }
                                                        h = [];
                                                    })();
                                                u = null;
                                                return;
                                            }
                                            f += (0, a.arrayByteLength)(e);
                                            d.isStreamingSupported ||
                                                S.send('DocProgress', {
                                                    loaded: f,
                                                    total: Math.max(f, d.contentLength || 0),
                                                });
                                            s ? s.sendProgressiveData(e) : h.push(e);
                                            d.read().then(readChunk, c);
                                        } catch (e) {
                                            c(e);
                                        }
                                    };
                                    d.read().then(readChunk, c);
                                }).catch(function (e) {
                                    i.reject(e);
                                    u = null;
                                });
                                u = function (e) {
                                    c.cancelAllRequests(e);
                                };
                                return i.promise;
                            }
                            S.on('GetPage', function wphSetupGetPage(e) {
                                return r.getPage(e.pageIndex).then(function (e) {
                                    return Promise.all([
                                        r.ensure(e, 'rotate'),
                                        r.ensure(e, 'ref'),
                                        r.ensure(e, 'userUnit'),
                                        r.ensure(e, 'view'),
                                    ]).then(function ([e, t, r, a]) {
                                        return { rotate: e, ref: t, userUnit: r, view: a };
                                    });
                                });
                            });
                            S.on('GetPageIndex', function wphSetupGetPageIndex({ ref: e }) {
                                const t = i.Ref.get(e.num, e.gen);
                                return r.ensureCatalog('getPageIndex', [t]);
                            });
                            S.on('GetDestinations', function wphSetupGetDestinations(e) {
                                return r.ensureCatalog('destinations');
                            });
                            S.on('GetDestination', function wphSetupGetDestination(e) {
                                return r.ensureCatalog('getDestination', [e.id]);
                            });
                            S.on('GetPageLabels', function wphSetupGetPageLabels(e) {
                                return r.ensureCatalog('pageLabels');
                            });
                            S.on('GetPageLayout', function wphSetupGetPageLayout(e) {
                                return r.ensureCatalog('pageLayout');
                            });
                            S.on('GetPageMode', function wphSetupGetPageMode(e) {
                                return r.ensureCatalog('pageMode');
                            });
                            S.on('GetViewerPreferences', function (e) {
                                return r.ensureCatalog('viewerPreferences');
                            });
                            S.on('GetOpenAction', function (e) {
                                return r.ensureCatalog('openAction');
                            });
                            S.on('GetAttachments', function wphSetupGetAttachments(e) {
                                return r.ensureCatalog('attachments');
                            });
                            S.on('GetJavaScript', function wphSetupGetJavaScript(e) {
                                return r.ensureCatalog('javaScript');
                            });
                            S.on('GetDocJSActions', function wphSetupGetDocJSActions(e) {
                                return r.ensureCatalog('jsActions');
                            });
                            S.on('GetPageJSActions', function ({ pageIndex: e }) {
                                return r.getPage(e).then(function (e) {
                                    return r.ensure(e, 'jsActions');
                                });
                            });
                            S.on('GetPageXfa', function wphSetupGetXfa({ pageIndex: e }) {
                                return r.getPage(e).then(function (e) {
                                    return r.ensure(e, 'xfaData');
                                });
                            });
                            S.on('GetOutline', function wphSetupGetOutline(e) {
                                return r.ensureCatalog('documentOutline');
                            });
                            S.on('GetOptionalContentConfig', function (e) {
                                return r.ensureCatalog('optionalContentConfig');
                            });
                            S.on('GetPermissions', function (e) {
                                return r.ensureCatalog('permissions');
                            });
                            S.on('GetMetadata', function wphSetupGetMetadata(e) {
                                return Promise.all([r.ensureDoc('documentInfo'), r.ensureCatalog('metadata')]);
                            });
                            S.on('GetMarkInfo', function wphSetupGetMarkInfo(e) {
                                return r.ensureCatalog('markInfo');
                            });
                            S.on('GetData', function wphSetupGetData(e) {
                                r.requestLoadedStream();
                                return r.onLoadedStream().then(function (e) {
                                    return e.bytes;
                                });
                            });
                            S.on('GetStats', function wphSetupGetStats(e) {
                                return r.ensureXRef('stats');
                            });
                            S.on('GetAnnotations', function ({ pageIndex: e, intent: t }) {
                                return r.getPage(e).then(function (e) {
                                    return e.getAnnotationsData(t);
                                });
                            });
                            S.on('GetFieldObjects', function (e) {
                                return r.ensureDoc('fieldObjects');
                            });
                            S.on('HasJSActions', function (e) {
                                return r.ensureDoc('hasJSActions');
                            });
                            S.on('GetCalculationOrderIds', function (e) {
                                return r.ensureDoc('calculationOrderIds');
                            });
                            S.on('SaveDocument', function ({ numPages: e, annotationStorage: t, filename: n }) {
                                r.requestLoadedStream();
                                const o = [
                                    r.onLoadedStream(),
                                    r.ensureCatalog('acroForm'),
                                    r.ensureDoc('xref'),
                                    r.ensureDoc('startXRef'),
                                ];
                                for (let a = 0; a < e; a++)
                                    o.push(
                                        r.getPage(a).then(function (e) {
                                            const r = new WorkerTask(`Save: page ${a}`);
                                            startWorkerTask(r);
                                            return e.save(S, r, t).finally(function () {
                                                finishWorkerTask(r);
                                            });
                                        })
                                    );
                                return Promise.all(o).then(function ([e, t, r, o, ...c]) {
                                    let l = [];
                                    for (const e of c) l = e.filter((e) => null !== e).reduce((e, t) => e.concat(t), l);
                                    if (0 === l.length) return e.bytes;
                                    const h = (t instanceof i.Dict && t.get('XFA')) || [];
                                    let u = null;
                                    if (Array.isArray(h))
                                        for (let e = 0, t = h.length; e < t; e += 2)
                                            'datasets' === h[e] && (u = h[e + 1]);
                                    else (0, a.warn)('Unsupported XFA type.');
                                    let d = Object.create(null);
                                    if (r.trailer) {
                                        const e = Object.create(null),
                                            t = r.trailer.get('Info') || null;
                                        t instanceof i.Dict &&
                                            t.forEach((t, r) => {
                                                (0, a.isString)(t) &&
                                                    (0, a.isString)(r) &&
                                                    (e[t] = (0, a.stringToPDFString)(r));
                                            });
                                        d = {
                                            rootRef: r.trailer.getRaw('Root') || null,
                                            encryptRef: r.trailer.getRaw('Encrypt') || null,
                                            newRef: r.getNewRef(),
                                            infoRef: r.trailer.getRaw('Info') || null,
                                            info: e,
                                            fileIds: r.trailer.get('ID') || null,
                                            startXRef: o,
                                            filename: n,
                                        };
                                    }
                                    r.resetNewRef();
                                    return (0,
                                    s.incrementalUpdate)({ originalData: e.bytes, xrefInfo: d, newRefs: l, xref: r, datasetsRef: u });
                                });
                            });
                            S.on('GetOperatorList', function wphSetupRenderPage(e, t) {
                                const i = e.pageIndex;
                                r.getPage(i).then(function (r) {
                                    const n = new WorkerTask(`GetOperatorList: page ${i}`);
                                    startWorkerTask(n);
                                    const s = f >= a.VerbosityLevel.INFOS ? Date.now() : 0;
                                    r.getOperatorList({
                                        handler: S,
                                        sink: t,
                                        task: n,
                                        intent: e.intent,
                                        renderInteractiveForms: e.renderInteractiveForms,
                                        annotationStorage: e.annotationStorage,
                                    }).then(
                                        function (e) {
                                            finishWorkerTask(n);
                                            s &&
                                                (0, a.info)(
                                                    `page=${i + 1} - getOperatorList: time=${Date.now() - s}ms, len=${
                                                        e.length
                                                    }`
                                                );
                                            t.close();
                                        },
                                        function (e) {
                                            finishWorkerTask(n);
                                            if (!n.terminated) {
                                                S.send('UnsupportedFeature', {
                                                    featureId: a.UNSUPPORTED_FEATURES.errorOperatorList,
                                                });
                                                t.error(e);
                                            }
                                        }
                                    );
                                });
                            });
                            S.on('GetTextContent', function wphExtractText(e, t) {
                                const i = e.pageIndex;
                                t.onPull = function (e) {};
                                t.onCancel = function (e) {};
                                r.getPage(i).then(function (r) {
                                    const n = new WorkerTask('GetTextContent: page ' + i);
                                    startWorkerTask(n);
                                    const s = f >= a.VerbosityLevel.INFOS ? Date.now() : 0;
                                    r.extractTextContent({
                                        handler: S,
                                        task: n,
                                        sink: t,
                                        normalizeWhitespace: e.normalizeWhitespace,
                                        includeMarkedContent: e.includeMarkedContent,
                                        combineTextItems: e.combineTextItems,
                                    }).then(
                                        function () {
                                            finishWorkerTask(n);
                                            s &&
                                                (0, a.info)(
                                                    `page=${i + 1} - getTextContent: time=` + (Date.now() - s) + 'ms'
                                                );
                                            t.close();
                                        },
                                        function (e) {
                                            finishWorkerTask(n);
                                            n.terminated || t.error(e);
                                        }
                                    );
                                });
                            });
                            S.on('GetStructTree', function wphGetStructTree(e) {
                                return r.getPage(e.pageIndex).then(function (e) {
                                    return r.ensure(e, 'getStructTree');
                                });
                            });
                            S.on('FontFallback', function (e) {
                                return r.fontFallback(e.id, S);
                            });
                            S.on('Cleanup', function wphCleanup(e) {
                                return r.cleanup(!0);
                            });
                            S.on('Terminate', function wphTerminate(e) {
                                o = !0;
                                const t = [];
                                if (r) {
                                    r.terminate(new a.AbortException('Worker was terminated.'));
                                    const e = r.cleanup();
                                    t.push(e);
                                    r = null;
                                } else (0, i.clearPrimitiveCaches)();
                                u && u(new a.AbortException('Worker was terminated.'));
                                for (const e of d) {
                                    t.push(e.finished);
                                    e.terminate();
                                }
                                return Promise.all(t).then(function () {
                                    S.destroy();
                                    S = null;
                                });
                            });
                            S.on('Ready', function wphReady(t) {
                                !(function setupDoc(e) {
                                    function onSuccess(e) {
                                        ensureNotTerminated();
                                        S.send('GetDoc', { pdfInfo: e });
                                    }
                                    function onFailure(e) {
                                        ensureNotTerminated();
                                        if (e instanceof a.PasswordException) {
                                            const t = new WorkerTask(`PasswordException: response ${e.code}`);
                                            startWorkerTask(t);
                                            S.sendWithPromise('PasswordRequest', e)
                                                .then(function ({ password: e }) {
                                                    finishWorkerTask(t);
                                                    r.updatePassword(e);
                                                    pdfManagerReady();
                                                })
                                                .catch(function () {
                                                    finishWorkerTask(t);
                                                    S.send('DocException', e);
                                                });
                                        } else
                                            e instanceof a.InvalidPDFException ||
                                            e instanceof a.MissingPDFException ||
                                            e instanceof a.UnexpectedResponseException ||
                                            e instanceof a.UnknownErrorException
                                                ? S.send('DocException', e)
                                                : S.send(
                                                      'DocException',
                                                      new a.UnknownErrorException(e.message, e.toString())
                                                  );
                                    }
                                    function pdfManagerReady() {
                                        ensureNotTerminated();
                                        loadDocument(!1).then(onSuccess, function (e) {
                                            ensureNotTerminated();
                                            if (e instanceof h.XRefParseException) {
                                                r.requestLoadedStream();
                                                r.onLoadedStream().then(function () {
                                                    ensureNotTerminated();
                                                    loadDocument(!0).then(onSuccess, onFailure);
                                                });
                                            } else onFailure(e);
                                        });
                                    }
                                    ensureNotTerminated();
                                    getPdfManager(
                                        e,
                                        {
                                            maxImageSize: e.maxImageSize,
                                            disableFontFace: e.disableFontFace,
                                            ignoreErrors: e.ignoreErrors,
                                            isEvalSupported: e.isEvalSupported,
                                            fontExtraProperties: e.fontExtraProperties,
                                        },
                                        e.enableXfa
                                    )
                                        .then(function (e) {
                                            if (o) {
                                                e.terminate(new a.AbortException('Worker was terminated.'));
                                                throw new Error('Worker was terminated');
                                            }
                                            r = e;
                                            r.onLoadedStream().then(function (e) {
                                                S.send('DataLoaded', { length: e.bytes.byteLength });
                                            });
                                        })
                                        .then(pdfManagerReady, onFailure);
                                })(e);
                                e = null;
                            });
                            return w;
                        }
                        static initializeFromPort(e) {
                            const t = new c.MessageHandler('worker', 'main', e);
                            WorkerMessageHandler.setup(t, e);
                            t.send('ready', null);
                        }
                    }
                    t.WorkerMessageHandler = WorkerMessageHandler;
                    'undefined' == typeof window &&
                        !o.isNodeJS &&
                        'undefined' != typeof self &&
                        (function isMessagePort(e) {
                            return 'function' == typeof e.postMessage && 'onmessage' in e;
                        })(self) &&
                        WorkerMessageHandler.initializeFromPort(self);
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.arrayByteLength = arrayByteLength;
                    t.arraysToBytes = function arraysToBytes(e) {
                        const t = e.length;
                        if (1 === t && e[0] instanceof Uint8Array) return e[0];
                        let r = 0;
                        for (let a = 0; a < t; a++) r += arrayByteLength(e[a]);
                        let a = 0;
                        const i = new Uint8Array(r);
                        for (let r = 0; r < t; r++) {
                            let t = e[r];
                            t instanceof Uint8Array ||
                                (t = 'string' == typeof t ? stringToBytes(t) : new Uint8Array(t));
                            const n = t.byteLength;
                            i.set(t, a);
                            a += n;
                        }
                        return i;
                    };
                    t.assert = assert;
                    t.bytesToString = function bytesToString(e) {
                        assert(
                            null !== e && 'object' == typeof e && void 0 !== e.length,
                            'Invalid argument for bytesToString'
                        );
                        const t = e.length,
                            r = 8192;
                        if (t < r) return String.fromCharCode.apply(null, e);
                        const a = [];
                        for (let i = 0; i < t; i += r) {
                            const n = Math.min(i + r, t),
                                s = e.subarray(i, n);
                            a.push(String.fromCharCode.apply(null, s));
                        }
                        return a.join('');
                    };
                    t.createObjectURL = function createObjectURL(e, t = '', r = !1) {
                        if (URL.createObjectURL && !r) return URL.createObjectURL(new Blob([e], { type: t }));
                        const a = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
                        let i = `data:${t};base64,`;
                        for (let t = 0, r = e.length; t < r; t += 3) {
                            const n = 255 & e[t],
                                s = 255 & e[t + 1],
                                o = 255 & e[t + 2];
                            i +=
                                a[n >> 2] +
                                a[((3 & n) << 4) | (s >> 4)] +
                                a[t + 1 < r ? ((15 & s) << 2) | (o >> 6) : 64] +
                                a[t + 2 < r ? 63 & o : 64];
                        }
                        return i;
                    };
                    t.createPromiseCapability = function createPromiseCapability() {
                        const e = Object.create(null);
                        let t = !1;
                        Object.defineProperty(e, 'settled', { get: () => t });
                        e.promise = new Promise(function (r, a) {
                            e.resolve = function (e) {
                                t = !0;
                                r(e);
                            };
                            e.reject = function (e) {
                                t = !0;
                                a(e);
                            };
                        });
                        return e;
                    };
                    t.createValidAbsoluteUrl = function createValidAbsoluteUrl(e, t) {
                        if (!e) return null;
                        try {
                            const r = t ? new URL(e, t) : new URL(e);
                            if (
                                (function _isValidProtocol(e) {
                                    if (!e) return !1;
                                    switch (e.protocol) {
                                        case 'http:':
                                        case 'https:':
                                        case 'ftp:':
                                        case 'mailto:':
                                        case 'tel:':
                                            return !0;
                                        default:
                                            return !1;
                                    }
                                })(r)
                            )
                                return r;
                        } catch (e) {}
                        return null;
                    };
                    t.escapeString = function escapeString(e) {
                        return e.replace(/([()\\\n\r])/g, (e) => ('\n' === e ? '\\n' : '\r' === e ? '\\r' : `\\${e}`));
                    };
                    t.getModificationDate = function getModificationDate(e = new Date()) {
                        return [
                            e.getUTCFullYear().toString(),
                            (e.getUTCMonth() + 1).toString().padStart(2, '0'),
                            e.getUTCDate().toString().padStart(2, '0'),
                            e.getUTCHours().toString().padStart(2, '0'),
                            e.getUTCMinutes().toString().padStart(2, '0'),
                            e.getUTCSeconds().toString().padStart(2, '0'),
                        ].join('');
                    };
                    t.getVerbosityLevel = function getVerbosityLevel() {
                        return i;
                    };
                    t.info = function info(e) {
                        i >= a.INFOS && console.log(`Info: ${e}`);
                    };
                    t.isArrayBuffer = function isArrayBuffer(e) {
                        return 'object' == typeof e && null !== e && void 0 !== e.byteLength;
                    };
                    t.isArrayEqual = function isArrayEqual(e, t) {
                        if (e.length !== t.length) return !1;
                        for (let r = 0, a = e.length; r < a; r++) if (e[r] !== t[r]) return !1;
                        return !0;
                    };
                    t.isAscii = function isAscii(e) {
                        return /^[\x00-\x7F]*$/.test(e);
                    };
                    t.isBool = function isBool(e) {
                        return 'boolean' == typeof e;
                    };
                    t.isNum = function isNum(e) {
                        return 'number' == typeof e;
                    };
                    t.isSameOrigin = function isSameOrigin(e, t) {
                        let r;
                        try {
                            r = new URL(e);
                            if (!r.origin || 'null' === r.origin) return !1;
                        } catch (e) {
                            return !1;
                        }
                        const a = new URL(t, r);
                        return r.origin === a.origin;
                    };
                    t.isString = function isString(e) {
                        return 'string' == typeof e;
                    };
                    t.objectFromMap = function objectFromMap(e) {
                        const t = Object.create(null);
                        for (const [r, a] of e) t[r] = a;
                        return t;
                    };
                    t.objectSize = function objectSize(e) {
                        return Object.keys(e).length;
                    };
                    t.removeNullCharacters = function removeNullCharacters(e) {
                        if ('string' != typeof e) {
                            warn('The argument for removeNullCharacters must be a string.');
                            return e;
                        }
                        return e.replace(s, '');
                    };
                    t.setVerbosityLevel = function setVerbosityLevel(e) {
                        Number.isInteger(e) && (i = e);
                    };
                    t.shadow = shadow;
                    t.string32 = function string32(e) {
                        return String.fromCharCode((e >> 24) & 255, (e >> 16) & 255, (e >> 8) & 255, 255 & e);
                    };
                    t.stringToBytes = stringToBytes;
                    t.stringToPDFString = function stringToPDFString(e) {
                        const t = e.length,
                            r = [];
                        if ('þ' === e[0] && 'ÿ' === e[1])
                            for (let a = 2; a < t; a += 2)
                                r.push(String.fromCharCode((e.charCodeAt(a) << 8) | e.charCodeAt(a + 1)));
                        else if ('ÿ' === e[0] && 'þ' === e[1])
                            for (let a = 2; a < t; a += 2)
                                r.push(String.fromCharCode((e.charCodeAt(a + 1) << 8) | e.charCodeAt(a)));
                        else
                            for (let a = 0; a < t; ++a) {
                                const t = h[e.charCodeAt(a)];
                                r.push(t ? String.fromCharCode(t) : e.charAt(a));
                            }
                        return r.join('');
                    };
                    t.stringToUTF16BEString = function stringToUTF16BEString(e) {
                        const t = ['þÿ'];
                        for (let r = 0, a = e.length; r < a; r++) {
                            const a = e.charCodeAt(r);
                            t.push(String.fromCharCode((a >> 8) & 255), String.fromCharCode(255 & a));
                        }
                        return t.join('');
                    };
                    t.stringToUTF8String = function stringToUTF8String(e) {
                        return decodeURIComponent(escape(e));
                    };
                    t.unreachable = unreachable;
                    t.utf8StringToString = function utf8StringToString(e) {
                        return unescape(encodeURIComponent(e));
                    };
                    t.warn = warn;
                    t.VerbosityLevel =
                        t.Util =
                        t.UNSUPPORTED_FEATURES =
                        t.UnknownErrorException =
                        t.UnexpectedResponseException =
                        t.TextRenderingMode =
                        t.StreamType =
                        t.PermissionFlag =
                        t.PasswordResponses =
                        t.PasswordException =
                        t.PageActionEventType =
                        t.OPS =
                        t.MissingPDFException =
                        t.IsLittleEndianCached =
                        t.IsEvalSupportedCached =
                        t.InvalidPDFException =
                        t.ImageKind =
                        t.IDENTITY_MATRIX =
                        t.FormatError =
                        t.FontType =
                        t.FONT_IDENTITY_MATRIX =
                        t.DocumentActionEventType =
                        t.CMapCompressionType =
                        t.BaseException =
                        t.AnnotationType =
                        t.AnnotationStateModelType =
                        t.AnnotationReviewState =
                        t.AnnotationReplyType =
                        t.AnnotationMarkedState =
                        t.AnnotationFlag =
                        t.AnnotationFieldFlag =
                        t.AnnotationBorderStyleType =
                        t.AnnotationActionEventType =
                        t.AbortException =
                            void 0;
                    r(3);
                    t.IDENTITY_MATRIX = [1, 0, 0, 1, 0, 0];
                    t.FONT_IDENTITY_MATRIX = [0.001, 0, 0, 0.001, 0, 0];
                    t.PermissionFlag = {
                        PRINT: 4,
                        MODIFY_CONTENTS: 8,
                        COPY: 16,
                        MODIFY_ANNOTATIONS: 32,
                        FILL_INTERACTIVE_FORMS: 256,
                        COPY_FOR_ACCESSIBILITY: 512,
                        ASSEMBLE: 1024,
                        PRINT_HIGH_QUALITY: 2048,
                    };
                    t.TextRenderingMode = {
                        FILL: 0,
                        STROKE: 1,
                        FILL_STROKE: 2,
                        INVISIBLE: 3,
                        FILL_ADD_TO_PATH: 4,
                        STROKE_ADD_TO_PATH: 5,
                        FILL_STROKE_ADD_TO_PATH: 6,
                        ADD_TO_PATH: 7,
                        FILL_STROKE_MASK: 3,
                        ADD_TO_PATH_FLAG: 4,
                    };
                    t.ImageKind = { GRAYSCALE_1BPP: 1, RGB_24BPP: 2, RGBA_32BPP: 3 };
                    t.AnnotationType = {
                        TEXT: 1,
                        LINK: 2,
                        FREETEXT: 3,
                        LINE: 4,
                        SQUARE: 5,
                        CIRCLE: 6,
                        POLYGON: 7,
                        POLYLINE: 8,
                        HIGHLIGHT: 9,
                        UNDERLINE: 10,
                        SQUIGGLY: 11,
                        STRIKEOUT: 12,
                        STAMP: 13,
                        CARET: 14,
                        INK: 15,
                        POPUP: 16,
                        FILEATTACHMENT: 17,
                        SOUND: 18,
                        MOVIE: 19,
                        WIDGET: 20,
                        SCREEN: 21,
                        PRINTERMARK: 22,
                        TRAPNET: 23,
                        WATERMARK: 24,
                        THREED: 25,
                        REDACT: 26,
                    };
                    t.AnnotationStateModelType = { MARKED: 'Marked', REVIEW: 'Review' };
                    t.AnnotationMarkedState = { MARKED: 'Marked', UNMARKED: 'Unmarked' };
                    t.AnnotationReviewState = {
                        ACCEPTED: 'Accepted',
                        REJECTED: 'Rejected',
                        CANCELLED: 'Cancelled',
                        COMPLETED: 'Completed',
                        NONE: 'None',
                    };
                    t.AnnotationReplyType = { GROUP: 'Group', REPLY: 'R' };
                    t.AnnotationFlag = {
                        INVISIBLE: 1,
                        HIDDEN: 2,
                        PRINT: 4,
                        NOZOOM: 8,
                        NOROTATE: 16,
                        NOVIEW: 32,
                        READONLY: 64,
                        LOCKED: 128,
                        TOGGLENOVIEW: 256,
                        LOCKEDCONTENTS: 512,
                    };
                    t.AnnotationFieldFlag = {
                        READONLY: 1,
                        REQUIRED: 2,
                        NOEXPORT: 4,
                        MULTILINE: 4096,
                        PASSWORD: 8192,
                        NOTOGGLETOOFF: 16384,
                        RADIO: 32768,
                        PUSHBUTTON: 65536,
                        COMBO: 131072,
                        EDIT: 262144,
                        SORT: 524288,
                        FILESELECT: 1048576,
                        MULTISELECT: 2097152,
                        DONOTSPELLCHECK: 4194304,
                        DONOTSCROLL: 8388608,
                        COMB: 16777216,
                        RICHTEXT: 33554432,
                        RADIOSINUNISON: 33554432,
                        COMMITONSELCHANGE: 67108864,
                    };
                    t.AnnotationBorderStyleType = { SOLID: 1, DASHED: 2, BEVELED: 3, INSET: 4, UNDERLINE: 5 };
                    t.AnnotationActionEventType = {
                        E: 'Mouse Enter',
                        X: 'Mouse Exit',
                        D: 'Mouse Down',
                        U: 'Mouse Up',
                        Fo: 'Focus',
                        Bl: 'Blur',
                        PO: 'PageOpen',
                        PC: 'PageClose',
                        PV: 'PageVisible',
                        PI: 'PageInvisible',
                        K: 'Keystroke',
                        F: 'Format',
                        V: 'Validate',
                        C: 'Calculate',
                    };
                    t.DocumentActionEventType = {
                        WC: 'WillClose',
                        WS: 'WillSave',
                        DS: 'DidSave',
                        WP: 'WillPrint',
                        DP: 'DidPrint',
                    };
                    t.PageActionEventType = { O: 'PageOpen', C: 'PageClose' };
                    t.StreamType = {
                        UNKNOWN: 'UNKNOWN',
                        FLATE: 'FLATE',
                        LZW: 'LZW',
                        DCT: 'DCT',
                        JPX: 'JPX',
                        JBIG: 'JBIG',
                        A85: 'A85',
                        AHX: 'AHX',
                        CCF: 'CCF',
                        RLX: 'RLX',
                    };
                    t.FontType = {
                        UNKNOWN: 'UNKNOWN',
                        TYPE1: 'TYPE1',
                        TYPE1C: 'TYPE1C',
                        CIDFONTTYPE0: 'CIDFONTTYPE0',
                        CIDFONTTYPE0C: 'CIDFONTTYPE0C',
                        TRUETYPE: 'TRUETYPE',
                        CIDFONTTYPE2: 'CIDFONTTYPE2',
                        TYPE3: 'TYPE3',
                        OPENTYPE: 'OPENTYPE',
                        TYPE0: 'TYPE0',
                        MMTYPE1: 'MMTYPE1',
                    };
                    const a = { ERRORS: 0, WARNINGS: 1, INFOS: 5 };
                    t.VerbosityLevel = a;
                    t.CMapCompressionType = { NONE: 0, BINARY: 1, STREAM: 2 };
                    t.OPS = {
                        dependency: 1,
                        setLineWidth: 2,
                        setLineCap: 3,
                        setLineJoin: 4,
                        setMiterLimit: 5,
                        setDash: 6,
                        setRenderingIntent: 7,
                        setFlatness: 8,
                        setGState: 9,
                        save: 10,
                        restore: 11,
                        transform: 12,
                        moveTo: 13,
                        lineTo: 14,
                        curveTo: 15,
                        curveTo2: 16,
                        curveTo3: 17,
                        closePath: 18,
                        rectangle: 19,
                        stroke: 20,
                        closeStroke: 21,
                        fill: 22,
                        eoFill: 23,
                        fillStroke: 24,
                        eoFillStroke: 25,
                        closeFillStroke: 26,
                        closeEOFillStroke: 27,
                        endPath: 28,
                        clip: 29,
                        eoClip: 30,
                        beginText: 31,
                        endText: 32,
                        setCharSpacing: 33,
                        setWordSpacing: 34,
                        setHScale: 35,
                        setLeading: 36,
                        setFont: 37,
                        setTextRenderingMode: 38,
                        setTextRise: 39,
                        moveText: 40,
                        setLeadingMoveText: 41,
                        setTextMatrix: 42,
                        nextLine: 43,
                        showText: 44,
                        showSpacedText: 45,
                        nextLineShowText: 46,
                        nextLineSetSpacingShowText: 47,
                        setCharWidth: 48,
                        setCharWidthAndBounds: 49,
                        setStrokeColorSpace: 50,
                        setFillColorSpace: 51,
                        setStrokeColor: 52,
                        setStrokeColorN: 53,
                        setFillColor: 54,
                        setFillColorN: 55,
                        setStrokeGray: 56,
                        setFillGray: 57,
                        setStrokeRGBColor: 58,
                        setFillRGBColor: 59,
                        setStrokeCMYKColor: 60,
                        setFillCMYKColor: 61,
                        shadingFill: 62,
                        beginInlineImage: 63,
                        beginImageData: 64,
                        endInlineImage: 65,
                        paintXObject: 66,
                        markPoint: 67,
                        markPointProps: 68,
                        beginMarkedContent: 69,
                        beginMarkedContentProps: 70,
                        endMarkedContent: 71,
                        beginCompat: 72,
                        endCompat: 73,
                        paintFormXObjectBegin: 74,
                        paintFormXObjectEnd: 75,
                        beginGroup: 76,
                        endGroup: 77,
                        beginAnnotations: 78,
                        endAnnotations: 79,
                        beginAnnotation: 80,
                        endAnnotation: 81,
                        paintJpegXObject: 82,
                        paintImageMaskXObject: 83,
                        paintImageMaskXObjectGroup: 84,
                        paintImageXObject: 85,
                        paintInlineImageXObject: 86,
                        paintInlineImageXObjectGroup: 87,
                        paintImageXObjectRepeat: 88,
                        paintImageMaskXObjectRepeat: 89,
                        paintSolidColorImageMask: 90,
                        constructPath: 91,
                    };
                    t.UNSUPPORTED_FEATURES = {
                        unknown: 'unknown',
                        forms: 'forms',
                        javaScript: 'javaScript',
                        signatures: 'signatures',
                        smask: 'smask',
                        shadingPattern: 'shadingPattern',
                        font: 'font',
                        errorTilingPattern: 'errorTilingPattern',
                        errorExtGState: 'errorExtGState',
                        errorXObject: 'errorXObject',
                        errorFontLoadType3: 'errorFontLoadType3',
                        errorFontState: 'errorFontState',
                        errorFontMissing: 'errorFontMissing',
                        errorFontTranslate: 'errorFontTranslate',
                        errorColorSpace: 'errorColorSpace',
                        errorOperatorList: 'errorOperatorList',
                        errorFontToUnicode: 'errorFontToUnicode',
                        errorFontLoadNative: 'errorFontLoadNative',
                        errorFontBuildPath: 'errorFontBuildPath',
                        errorFontGetPath: 'errorFontGetPath',
                        errorMarkedContent: 'errorMarkedContent',
                    };
                    t.PasswordResponses = { NEED_PASSWORD: 1, INCORRECT_PASSWORD: 2 };
                    let i = a.WARNINGS;
                    function warn(e) {
                        i >= a.WARNINGS && console.log(`Warning: ${e}`);
                    }
                    function unreachable(e) {
                        throw new Error(e);
                    }
                    function assert(e, t) {
                        e || unreachable(t);
                    }
                    function shadow(e, t, r) {
                        Object.defineProperty(e, t, { value: r, enumerable: !0, configurable: !0, writable: !1 });
                        return r;
                    }
                    const n = (function BaseExceptionClosure() {
                        function BaseException(e) {
                            this.constructor === BaseException && unreachable('Cannot initialize BaseException.');
                            this.message = e;
                            this.name = this.constructor.name;
                        }
                        BaseException.prototype = new Error();
                        BaseException.constructor = BaseException;
                        return BaseException;
                    })();
                    t.BaseException = n;
                    t.PasswordException = class PasswordException extends n {
                        constructor(e, t) {
                            super(e);
                            this.code = t;
                        }
                    };
                    t.UnknownErrorException = class UnknownErrorException extends n {
                        constructor(e, t) {
                            super(e);
                            this.details = t;
                        }
                    };
                    t.InvalidPDFException = class InvalidPDFException extends n {};
                    t.MissingPDFException = class MissingPDFException extends n {};
                    t.UnexpectedResponseException = class UnexpectedResponseException extends n {
                        constructor(e, t) {
                            super(e);
                            this.status = t;
                        }
                    };
                    t.FormatError = class FormatError extends n {};
                    t.AbortException = class AbortException extends n {};
                    const s = /\x00/g;
                    function stringToBytes(e) {
                        assert('string' == typeof e, 'Invalid argument for stringToBytes');
                        const t = e.length,
                            r = new Uint8Array(t);
                        for (let a = 0; a < t; ++a) r[a] = 255 & e.charCodeAt(a);
                        return r;
                    }
                    function arrayByteLength(e) {
                        if (void 0 !== e.length) return e.length;
                        assert(void 0 !== e.byteLength, 'arrayByteLength - invalid argument.');
                        return e.byteLength;
                    }
                    const o = {
                        get value() {
                            return shadow(
                                this,
                                'value',
                                (function isLittleEndian() {
                                    const e = new Uint8Array(4);
                                    e[0] = 1;
                                    return 1 === new Uint32Array(e.buffer, 0, 1)[0];
                                })()
                            );
                        },
                    };
                    t.IsLittleEndianCached = o;
                    const c = {
                        get value() {
                            return shadow(
                                this,
                                'value',
                                (function isEvalSupported() {
                                    try {
                                        new Function('');
                                        return !0;
                                    } catch (e) {
                                        return !1;
                                    }
                                })()
                            );
                        },
                    };
                    t.IsEvalSupportedCached = c;
                    const l = [...Array(256).keys()].map((e) => e.toString(16).padStart(2, '0'));
                    class Util {
                        static makeHexColor(e, t, r) {
                            return `#${l[e]}${l[t]}${l[r]}`;
                        }
                        static transform(e, t) {
                            return [
                                e[0] * t[0] + e[2] * t[1],
                                e[1] * t[0] + e[3] * t[1],
                                e[0] * t[2] + e[2] * t[3],
                                e[1] * t[2] + e[3] * t[3],
                                e[0] * t[4] + e[2] * t[5] + e[4],
                                e[1] * t[4] + e[3] * t[5] + e[5],
                            ];
                        }
                        static applyTransform(e, t) {
                            return [e[0] * t[0] + e[1] * t[2] + t[4], e[0] * t[1] + e[1] * t[3] + t[5]];
                        }
                        static applyInverseTransform(e, t) {
                            const r = t[0] * t[3] - t[1] * t[2];
                            return [
                                (e[0] * t[3] - e[1] * t[2] + t[2] * t[5] - t[4] * t[3]) / r,
                                (-e[0] * t[1] + e[1] * t[0] + t[4] * t[1] - t[5] * t[0]) / r,
                            ];
                        }
                        static getAxialAlignedBoundingBox(e, t) {
                            const r = Util.applyTransform(e, t),
                                a = Util.applyTransform(e.slice(2, 4), t),
                                i = Util.applyTransform([e[0], e[3]], t),
                                n = Util.applyTransform([e[2], e[1]], t);
                            return [
                                Math.min(r[0], a[0], i[0], n[0]),
                                Math.min(r[1], a[1], i[1], n[1]),
                                Math.max(r[0], a[0], i[0], n[0]),
                                Math.max(r[1], a[1], i[1], n[1]),
                            ];
                        }
                        static inverseTransform(e) {
                            const t = e[0] * e[3] - e[1] * e[2];
                            return [
                                e[3] / t,
                                -e[1] / t,
                                -e[2] / t,
                                e[0] / t,
                                (e[2] * e[5] - e[4] * e[3]) / t,
                                (e[4] * e[1] - e[5] * e[0]) / t,
                            ];
                        }
                        static apply3dTransform(e, t) {
                            return [
                                e[0] * t[0] + e[1] * t[1] + e[2] * t[2],
                                e[3] * t[0] + e[4] * t[1] + e[5] * t[2],
                                e[6] * t[0] + e[7] * t[1] + e[8] * t[2],
                            ];
                        }
                        static singularValueDecompose2dScale(e) {
                            const t = [e[0], e[2], e[1], e[3]],
                                r = e[0] * t[0] + e[1] * t[2],
                                a = e[0] * t[1] + e[1] * t[3],
                                i = e[2] * t[0] + e[3] * t[2],
                                n = e[2] * t[1] + e[3] * t[3],
                                s = (r + n) / 2,
                                o = Math.sqrt((r + n) ** 2 - 4 * (r * n - i * a)) / 2,
                                c = s + o || 1,
                                l = s - o || 1;
                            return [Math.sqrt(c), Math.sqrt(l)];
                        }
                        static normalizeRect(e) {
                            const t = e.slice(0);
                            if (e[0] > e[2]) {
                                t[0] = e[2];
                                t[2] = e[0];
                            }
                            if (e[1] > e[3]) {
                                t[1] = e[3];
                                t[3] = e[1];
                            }
                            return t;
                        }
                        static intersect(e, t) {
                            function compare(e, t) {
                                return e - t;
                            }
                            const r = [e[0], e[2], t[0], t[2]].sort(compare),
                                a = [e[1], e[3], t[1], t[3]].sort(compare),
                                i = [];
                            e = Util.normalizeRect(e);
                            t = Util.normalizeRect(t);
                            if (!((r[0] === e[0] && r[1] === t[0]) || (r[0] === t[0] && r[1] === e[0]))) return null;
                            i[0] = r[1];
                            i[2] = r[2];
                            if (!((a[0] === e[1] && a[1] === t[1]) || (a[0] === t[1] && a[1] === e[1]))) return null;
                            i[1] = a[1];
                            i[3] = a[2];
                            return i;
                        }
                    }
                    t.Util = Util;
                    const h = [
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 728, 711, 710, 729, 733,
                        731, 730, 732, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 8226, 8224, 8225, 8230, 8212, 8211, 402, 8260, 8249, 8250, 8722, 8240, 8222,
                        8220, 8221, 8216, 8217, 8218, 8482, 64257, 64258, 321, 338, 352, 376, 381, 305, 322, 339, 353,
                        382, 0, 8364,
                    ];
                },
                (e, t, r) => {
                    r(4);
                },
                (e, t) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.isNodeJS = void 0;
                    const r = !(
                        'object' != typeof process ||
                        process + '' != '[object process]' ||
                        process.versions.nw ||
                        (process.versions.electron && process.type && 'browser' !== process.type)
                    );
                    t.isNodeJS = r;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.clearPrimitiveCaches = function clearPrimitiveCaches() {
                        o._clearCache();
                        s._clearCache();
                        l._clearCache();
                    };
                    t.isCmd = function isCmd(e, t) {
                        return e instanceof o && (void 0 === t || e.cmd === t);
                    };
                    t.isDict = function isDict(e, t) {
                        return e instanceof Dict && (void 0 === t || isName(e.get('Type'), t));
                    };
                    t.isEOF = function isEOF(e) {
                        return e === n;
                    };
                    t.isName = isName;
                    t.isRef = function isRef(e) {
                        return e instanceof l;
                    };
                    t.isRefsEqual = function isRefsEqual(e, t) {
                        return e.num === t.num && e.gen === t.gen;
                    };
                    t.isStream = function isStream(e) {
                        return e instanceof i.BaseStream;
                    };
                    t.RefSetCache = t.RefSet = t.Ref = t.Name = t.EOF = t.Dict = t.Cmd = void 0;
                    var a = r(2),
                        i = r(6);
                    const n = {};
                    t.EOF = n;
                    const s = (function NameClosure() {
                        let e = Object.create(null);
                        class Name {
                            constructor(e) {
                                this.name = e;
                            }
                            static get(t) {
                                const r = e[t];
                                return r || (e[t] = new Name(t));
                            }
                            static _clearCache() {
                                e = Object.create(null);
                            }
                        }
                        return Name;
                    })();
                    t.Name = s;
                    const o = (function CmdClosure() {
                        let e = Object.create(null);
                        class Cmd {
                            constructor(e) {
                                this.cmd = e;
                            }
                            static get(t) {
                                const r = e[t];
                                return r || (e[t] = new Cmd(t));
                            }
                            static _clearCache() {
                                e = Object.create(null);
                            }
                        }
                        return Cmd;
                    })();
                    t.Cmd = o;
                    const c = function nonSerializableClosure() {
                        return c;
                    };
                    class Dict {
                        constructor(e = null) {
                            this._map = Object.create(null);
                            this.xref = e;
                            this.objId = null;
                            this.suppressEncryption = !1;
                            this.__nonSerializable__ = c;
                        }
                        assignXref(e) {
                            this.xref = e;
                        }
                        get size() {
                            return Object.keys(this._map).length;
                        }
                        get(e, t, r) {
                            let a = this._map[e];
                            if (void 0 === a && void 0 !== t) {
                                a = this._map[t];
                                void 0 === a && void 0 !== r && (a = this._map[r]);
                            }
                            return a instanceof l && this.xref ? this.xref.fetch(a, this.suppressEncryption) : a;
                        }
                        async getAsync(e, t, r) {
                            let a = this._map[e];
                            if (void 0 === a && void 0 !== t) {
                                a = this._map[t];
                                void 0 === a && void 0 !== r && (a = this._map[r]);
                            }
                            return a instanceof l && this.xref ? this.xref.fetchAsync(a, this.suppressEncryption) : a;
                        }
                        getArray(e, t, r) {
                            let a = this._map[e];
                            if (void 0 === a && void 0 !== t) {
                                a = this._map[t];
                                void 0 === a && void 0 !== r && (a = this._map[r]);
                            }
                            a instanceof l && this.xref && (a = this.xref.fetch(a, this.suppressEncryption));
                            if (Array.isArray(a)) {
                                a = a.slice();
                                for (let e = 0, t = a.length; e < t; e++)
                                    a[e] instanceof l &&
                                        this.xref &&
                                        (a[e] = this.xref.fetch(a[e], this.suppressEncryption));
                            }
                            return a;
                        }
                        getRaw(e) {
                            return this._map[e];
                        }
                        getKeys() {
                            return Object.keys(this._map);
                        }
                        getRawValues() {
                            return Object.values(this._map);
                        }
                        set(e, t) {
                            this._map[e] = t;
                        }
                        has(e) {
                            return void 0 !== this._map[e];
                        }
                        forEach(e) {
                            for (const t in this._map) e(t, this.get(t));
                        }
                        static get empty() {
                            const e = new Dict(null);
                            e.set = (e, t) => {
                                (0, a.unreachable)('Should not call `set` on the empty dictionary.');
                            };
                            return (0, a.shadow)(this, 'empty', e);
                        }
                        static merge({ xref: e, dictArray: t, mergeSubDicts: r = !1 }) {
                            const a = new Dict(e);
                            if (!r) {
                                for (const e of t)
                                    if (e instanceof Dict)
                                        for (const [t, r] of Object.entries(e._map))
                                            void 0 === a._map[t] && (a._map[t] = r);
                                return a.size > 0 ? a : Dict.empty;
                            }
                            const i = new Map();
                            for (const e of t)
                                if (e instanceof Dict)
                                    for (const [t, r] of Object.entries(e._map)) {
                                        let e = i.get(t);
                                        if (void 0 === e) {
                                            e = [];
                                            i.set(t, e);
                                        }
                                        e.push(r);
                                    }
                            for (const [t, r] of i) {
                                if (1 === r.length || !(r[0] instanceof Dict)) {
                                    a._map[t] = r[0];
                                    continue;
                                }
                                const i = new Dict(e);
                                for (const e of r)
                                    if (e instanceof Dict)
                                        for (const [t, r] of Object.entries(e._map))
                                            void 0 === i._map[t] && (i._map[t] = r);
                                i.size > 0 && (a._map[t] = i);
                            }
                            i.clear();
                            return a.size > 0 ? a : Dict.empty;
                        }
                    }
                    t.Dict = Dict;
                    const l = (function RefClosure() {
                        let e = Object.create(null);
                        class Ref {
                            constructor(e, t) {
                                this.num = e;
                                this.gen = t;
                            }
                            toString() {
                                return 0 === this.gen ? `${this.num}R` : `${this.num}R${this.gen}`;
                            }
                            static get(t, r) {
                                const a = 0 === r ? `${t}R` : `${t}R${r}`,
                                    i = e[a];
                                return i || (e[a] = new Ref(t, r));
                            }
                            static _clearCache() {
                                e = Object.create(null);
                            }
                        }
                        return Ref;
                    })();
                    t.Ref = l;
                    t.RefSet = class RefSet {
                        constructor(e = null) {
                            this._set = new Set(e && e._set);
                        }
                        has(e) {
                            return this._set.has(e.toString());
                        }
                        put(e) {
                            this._set.add(e.toString());
                        }
                        remove(e) {
                            this._set.delete(e.toString());
                        }
                        forEach(e) {
                            for (const t of this._set.values()) e(t);
                        }
                        clear() {
                            this._set.clear();
                        }
                    };
                    t.RefSetCache = class RefSetCache {
                        constructor() {
                            this._map = new Map();
                        }
                        get size() {
                            return this._map.size;
                        }
                        get(e) {
                            return this._map.get(e.toString());
                        }
                        has(e) {
                            return this._map.has(e.toString());
                        }
                        put(e, t) {
                            this._map.set(e.toString(), t);
                        }
                        putAlias(e, t) {
                            this._map.set(e.toString(), this.get(t));
                        }
                        forEach(e) {
                            for (const t of this._map.values()) e(t);
                        }
                        clear() {
                            this._map.clear();
                        }
                    };
                    function isName(e, t) {
                        return e instanceof s && (void 0 === t || e.name === t);
                    }
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.BaseStream = void 0;
                    var a = r(2);
                    class BaseStream {
                        constructor() {
                            this.constructor === BaseStream && (0, a.unreachable)('Cannot initialize BaseStream.');
                        }
                        get length() {
                            (0, a.unreachable)('Abstract getter `length` accessed');
                        }
                        get isEmpty() {
                            (0, a.unreachable)('Abstract getter `isEmpty` accessed');
                        }
                        get isDataLoaded() {
                            return (0, a.shadow)(this, 'isDataLoaded', !0);
                        }
                        getByte() {
                            (0, a.unreachable)('Abstract method `getByte` called');
                        }
                        getBytes(e, t = !1) {
                            (0, a.unreachable)('Abstract method `getBytes` called');
                        }
                        peekByte() {
                            const e = this.getByte();
                            -1 !== e && this.pos--;
                            return e;
                        }
                        peekBytes(e, t = !1) {
                            const r = this.getBytes(e, t);
                            this.pos -= r.length;
                            return r;
                        }
                        getUint16() {
                            const e = this.getByte(),
                                t = this.getByte();
                            return -1 === e || -1 === t ? -1 : (e << 8) + t;
                        }
                        getInt32() {
                            return (
                                (this.getByte() << 24) + (this.getByte() << 16) + (this.getByte() << 8) + this.getByte()
                            );
                        }
                        getByteRange(e, t) {
                            (0, a.unreachable)('Abstract method `getByteRange` called');
                        }
                        getString(e) {
                            return (0, a.bytesToString)(this.getBytes(e, !1));
                        }
                        skip(e) {
                            this.pos += e || 1;
                        }
                        reset() {
                            (0, a.unreachable)('Abstract method `reset` called');
                        }
                        moveStart() {
                            (0, a.unreachable)('Abstract method `moveStart` called');
                        }
                        makeSubStream(e, t, r = null) {
                            (0, a.unreachable)('Abstract method `makeSubStream` called');
                        }
                        getBaseStreams() {
                            return null;
                        }
                    }
                    t.BaseStream = BaseStream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.NetworkPdfManager = t.LocalPdfManager = void 0;
                    var a = r(2),
                        i = r(8),
                        n = r(9),
                        s = r(11),
                        o = r(10);
                    function parseDocBaseUrl(e) {
                        if (e) {
                            const t = (0, a.createValidAbsoluteUrl)(e);
                            if (t) return t.href;
                            (0, a.warn)(`Invalid absolute docBaseUrl: "${e}".`);
                        }
                        return null;
                    }
                    class BasePdfManager {
                        constructor() {
                            this.constructor === BasePdfManager &&
                                (0, a.unreachable)('Cannot initialize BasePdfManager.');
                        }
                        get docId() {
                            return this._docId;
                        }
                        get password() {
                            return this._password;
                        }
                        get docBaseUrl() {
                            return this._docBaseUrl;
                        }
                        onLoadedStream() {
                            (0, a.unreachable)('Abstract method `onLoadedStream` called');
                        }
                        ensureDoc(e, t) {
                            return this.ensure(this.pdfDocument, e, t);
                        }
                        ensureXRef(e, t) {
                            return this.ensure(this.pdfDocument.xref, e, t);
                        }
                        ensureCatalog(e, t) {
                            return this.ensure(this.pdfDocument.catalog, e, t);
                        }
                        getPage(e) {
                            return this.pdfDocument.getPage(e);
                        }
                        fontFallback(e, t) {
                            return this.pdfDocument.fontFallback(e, t);
                        }
                        loadXfaFonts(e, t) {
                            return this.pdfDocument.loadXfaFonts(e, t);
                        }
                        cleanup(e = !1) {
                            return this.pdfDocument.cleanup(e);
                        }
                        async ensure(e, t, r) {
                            (0, a.unreachable)('Abstract method `ensure` called');
                        }
                        requestRange(e, t) {
                            (0, a.unreachable)('Abstract method `requestRange` called');
                        }
                        requestLoadedStream() {
                            (0, a.unreachable)('Abstract method `requestLoadedStream` called');
                        }
                        sendProgressiveData(e) {
                            (0, a.unreachable)('Abstract method `sendProgressiveData` called');
                        }
                        updatePassword(e) {
                            this._password = e;
                        }
                        terminate(e) {
                            (0, a.unreachable)('Abstract method `terminate` called');
                        }
                    }
                    t.LocalPdfManager = class LocalPdfManager extends BasePdfManager {
                        constructor(e, t, r, a, i, n) {
                            super();
                            this._docId = e;
                            this._password = r;
                            this._docBaseUrl = parseDocBaseUrl(n);
                            this.evaluatorOptions = a;
                            this.enableXfa = i;
                            const c = new o.Stream(t);
                            this.pdfDocument = new s.PDFDocument(this, c);
                            this._loadedStreamPromise = Promise.resolve(c);
                        }
                        async ensure(e, t, r) {
                            const a = e[t];
                            return 'function' == typeof a ? a.apply(e, r) : a;
                        }
                        requestRange(e, t) {
                            return Promise.resolve();
                        }
                        requestLoadedStream() {}
                        onLoadedStream() {
                            return this._loadedStreamPromise;
                        }
                        terminate(e) {}
                    };
                    t.NetworkPdfManager = class NetworkPdfManager extends BasePdfManager {
                        constructor(e, t, r, a, n, o) {
                            super();
                            this._docId = e;
                            this._password = r.password;
                            this._docBaseUrl = parseDocBaseUrl(o);
                            this.msgHandler = r.msgHandler;
                            this.evaluatorOptions = a;
                            this.enableXfa = n;
                            this.streamManager = new i.ChunkedStreamManager(t, {
                                msgHandler: r.msgHandler,
                                length: r.length,
                                disableAutoFetch: r.disableAutoFetch,
                                rangeChunkSize: r.rangeChunkSize,
                            });
                            this.pdfDocument = new s.PDFDocument(this, this.streamManager.getStream());
                        }
                        async ensure(e, t, r) {
                            try {
                                const a = e[t];
                                return 'function' == typeof a ? a.apply(e, r) : a;
                            } catch (a) {
                                if (!(a instanceof n.MissingDataException)) throw a;
                                await this.requestRange(a.begin, a.end);
                                return this.ensure(e, t, r);
                            }
                        }
                        requestRange(e, t) {
                            return this.streamManager.requestRange(e, t);
                        }
                        requestLoadedStream() {
                            this.streamManager.requestAllChunks();
                        }
                        sendProgressiveData(e) {
                            this.streamManager.onReceiveData({ chunk: e });
                        }
                        onLoadedStream() {
                            return this.streamManager.onLoadedStream();
                        }
                        terminate(e) {
                            this.streamManager.abort(e);
                        }
                    };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.ChunkedStreamManager = t.ChunkedStream = void 0;
                    var a = r(2),
                        i = r(9),
                        n = r(10);
                    class ChunkedStream extends n.Stream {
                        constructor(e, t, r) {
                            super(new Uint8Array(e), 0, e, null);
                            this.chunkSize = t;
                            this._loadedChunks = new Set();
                            this.numChunks = Math.ceil(e / t);
                            this.manager = r;
                            this.progressiveDataLength = 0;
                            this.lastSuccessfulEnsureByteChunk = -1;
                        }
                        getMissingChunks() {
                            const e = [];
                            for (let t = 0, r = this.numChunks; t < r; ++t) this._loadedChunks.has(t) || e.push(t);
                            return e;
                        }
                        get numChunksLoaded() {
                            return this._loadedChunks.size;
                        }
                        get isDataLoaded() {
                            return this.numChunksLoaded === this.numChunks;
                        }
                        onReceiveData(e, t) {
                            const r = this.chunkSize;
                            if (e % r != 0) throw new Error(`Bad begin offset: ${e}`);
                            const a = e + t.byteLength;
                            if (a % r != 0 && a !== this.bytes.length) throw new Error(`Bad end offset: ${a}`);
                            this.bytes.set(new Uint8Array(t), e);
                            const i = Math.floor(e / r),
                                n = Math.floor((a - 1) / r) + 1;
                            for (let e = i; e < n; ++e) this._loadedChunks.add(e);
                        }
                        onReceiveProgressiveData(e) {
                            let t = this.progressiveDataLength;
                            const r = Math.floor(t / this.chunkSize);
                            this.bytes.set(new Uint8Array(e), t);
                            t += e.byteLength;
                            this.progressiveDataLength = t;
                            const a = t >= this.end ? this.numChunks : Math.floor(t / this.chunkSize);
                            for (let e = r; e < a; ++e) this._loadedChunks.add(e);
                        }
                        ensureByte(e) {
                            if (e < this.progressiveDataLength) return;
                            const t = Math.floor(e / this.chunkSize);
                            if (t !== this.lastSuccessfulEnsureByteChunk) {
                                if (!this._loadedChunks.has(t)) throw new i.MissingDataException(e, e + 1);
                                this.lastSuccessfulEnsureByteChunk = t;
                            }
                        }
                        ensureRange(e, t) {
                            if (e >= t) return;
                            if (t <= this.progressiveDataLength) return;
                            const r = this.chunkSize,
                                a = Math.floor(e / r),
                                n = Math.floor((t - 1) / r) + 1;
                            for (let r = a; r < n; ++r)
                                if (!this._loadedChunks.has(r)) throw new i.MissingDataException(e, t);
                        }
                        nextEmptyChunk(e) {
                            const t = this.numChunks;
                            for (let r = 0; r < t; ++r) {
                                const a = (e + r) % t;
                                if (!this._loadedChunks.has(a)) return a;
                            }
                            return null;
                        }
                        hasChunk(e) {
                            return this._loadedChunks.has(e);
                        }
                        getByte() {
                            const e = this.pos;
                            if (e >= this.end) return -1;
                            e >= this.progressiveDataLength && this.ensureByte(e);
                            return this.bytes[this.pos++];
                        }
                        getBytes(e, t = !1) {
                            const r = this.bytes,
                                a = this.pos,
                                i = this.end;
                            if (!e) {
                                i > this.progressiveDataLength && this.ensureRange(a, i);
                                const e = r.subarray(a, i);
                                return t ? new Uint8ClampedArray(e) : e;
                            }
                            let n = a + e;
                            n > i && (n = i);
                            n > this.progressiveDataLength && this.ensureRange(a, n);
                            this.pos = n;
                            const s = r.subarray(a, n);
                            return t ? new Uint8ClampedArray(s) : s;
                        }
                        getByteRange(e, t) {
                            e < 0 && (e = 0);
                            t > this.end && (t = this.end);
                            t > this.progressiveDataLength && this.ensureRange(e, t);
                            return this.bytes.subarray(e, t);
                        }
                        makeSubStream(e, t, r = null) {
                            t
                                ? e + t > this.progressiveDataLength && this.ensureRange(e, e + t)
                                : e >= this.progressiveDataLength && this.ensureByte(e);
                            function ChunkedStreamSubstream() {}
                            ChunkedStreamSubstream.prototype = Object.create(this);
                            ChunkedStreamSubstream.prototype.getMissingChunks = function () {
                                const e = this.chunkSize,
                                    t = Math.floor(this.start / e),
                                    r = Math.floor((this.end - 1) / e) + 1,
                                    a = [];
                                for (let e = t; e < r; ++e) this._loadedChunks.has(e) || a.push(e);
                                return a;
                            };
                            Object.defineProperty(ChunkedStreamSubstream.prototype, 'isDataLoaded', {
                                get() {
                                    return (
                                        this.numChunksLoaded === this.numChunks || 0 === this.getMissingChunks().length
                                    );
                                },
                                configurable: !0,
                            });
                            const a = new ChunkedStreamSubstream();
                            a.pos = a.start = e;
                            a.end = e + t || this.end;
                            a.dict = r;
                            return a;
                        }
                        getBaseStreams() {
                            return [this];
                        }
                    }
                    t.ChunkedStream = ChunkedStream;
                    t.ChunkedStreamManager = class ChunkedStreamManager {
                        constructor(e, t) {
                            this.length = t.length;
                            this.chunkSize = t.rangeChunkSize;
                            this.stream = new ChunkedStream(this.length, this.chunkSize, this);
                            this.pdfNetworkStream = e;
                            this.disableAutoFetch = t.disableAutoFetch;
                            this.msgHandler = t.msgHandler;
                            this.currRequestId = 0;
                            this._chunksNeededByRequest = new Map();
                            this._requestsByChunk = new Map();
                            this._promisesByRequest = new Map();
                            this.progressiveDataLength = 0;
                            this.aborted = !1;
                            this._loadedStreamCapability = (0, a.createPromiseCapability)();
                        }
                        onLoadedStream() {
                            return this._loadedStreamCapability.promise;
                        }
                        sendRequest(e, t) {
                            const r = this.pdfNetworkStream.getRangeReader(e, t);
                            r.isStreamingSupported || (r.onProgress = this.onProgress.bind(this));
                            let i = [],
                                n = 0;
                            new Promise((e, t) => {
                                const readChunk = (s) => {
                                    try {
                                        if (!s.done) {
                                            const e = s.value;
                                            i.push(e);
                                            n += (0, a.arrayByteLength)(e);
                                            r.isStreamingSupported && this.onProgress({ loaded: n });
                                            r.read().then(readChunk, t);
                                            return;
                                        }
                                        const o = (0, a.arraysToBytes)(i);
                                        i = null;
                                        e(o);
                                    } catch (e) {
                                        t(e);
                                    }
                                };
                                r.read().then(readChunk, t);
                            }).then((t) => {
                                this.aborted || this.onReceiveData({ chunk: t, begin: e });
                            });
                        }
                        requestAllChunks() {
                            const e = this.stream.getMissingChunks();
                            this._requestChunks(e);
                            return this._loadedStreamCapability.promise;
                        }
                        _requestChunks(e) {
                            const t = this.currRequestId++,
                                r = new Set();
                            this._chunksNeededByRequest.set(t, r);
                            for (const t of e) this.stream.hasChunk(t) || r.add(t);
                            if (0 === r.size) return Promise.resolve();
                            const i = (0, a.createPromiseCapability)();
                            this._promisesByRequest.set(t, i);
                            const n = [];
                            for (const e of r) {
                                let r = this._requestsByChunk.get(e);
                                if (!r) {
                                    r = [];
                                    this._requestsByChunk.set(e, r);
                                    n.push(e);
                                }
                                r.push(t);
                            }
                            if (n.length > 0) {
                                const e = this.groupChunks(n);
                                for (const t of e) {
                                    const e = t.beginChunk * this.chunkSize,
                                        r = Math.min(t.endChunk * this.chunkSize, this.length);
                                    this.sendRequest(e, r);
                                }
                            }
                            return i.promise.catch((e) => {
                                if (!this.aborted) throw e;
                            });
                        }
                        getStream() {
                            return this.stream;
                        }
                        requestRange(e, t) {
                            t = Math.min(t, this.length);
                            const r = this.getBeginChunk(e),
                                a = this.getEndChunk(t),
                                i = [];
                            for (let e = r; e < a; ++e) i.push(e);
                            return this._requestChunks(i);
                        }
                        requestRanges(e = []) {
                            const t = [];
                            for (const r of e) {
                                const e = this.getBeginChunk(r.begin),
                                    a = this.getEndChunk(r.end);
                                for (let r = e; r < a; ++r) t.includes(r) || t.push(r);
                            }
                            t.sort(function (e, t) {
                                return e - t;
                            });
                            return this._requestChunks(t);
                        }
                        groupChunks(e) {
                            const t = [];
                            let r = -1,
                                a = -1;
                            for (let i = 0, n = e.length; i < n; ++i) {
                                const n = e[i];
                                r < 0 && (r = n);
                                if (a >= 0 && a + 1 !== n) {
                                    t.push({ beginChunk: r, endChunk: a + 1 });
                                    r = n;
                                }
                                i + 1 === e.length && t.push({ beginChunk: r, endChunk: n + 1 });
                                a = n;
                            }
                            return t;
                        }
                        onProgress(e) {
                            this.msgHandler.send('DocProgress', {
                                loaded: this.stream.numChunksLoaded * this.chunkSize + e.loaded,
                                total: this.length,
                            });
                        }
                        onReceiveData(e) {
                            const t = e.chunk,
                                r = void 0 === e.begin,
                                a = r ? this.progressiveDataLength : e.begin,
                                i = a + t.byteLength,
                                n = Math.floor(a / this.chunkSize),
                                s = i < this.length ? Math.floor(i / this.chunkSize) : Math.ceil(i / this.chunkSize);
                            if (r) {
                                this.stream.onReceiveProgressiveData(t);
                                this.progressiveDataLength = i;
                            } else this.stream.onReceiveData(a, t);
                            this.stream.isDataLoaded && this._loadedStreamCapability.resolve(this.stream);
                            const o = [];
                            for (let e = n; e < s; ++e) {
                                const t = this._requestsByChunk.get(e);
                                if (t) {
                                    this._requestsByChunk.delete(e);
                                    for (const r of t) {
                                        const t = this._chunksNeededByRequest.get(r);
                                        t.has(e) && t.delete(e);
                                        t.size > 0 || o.push(r);
                                    }
                                }
                            }
                            if (!this.disableAutoFetch && 0 === this._requestsByChunk.size) {
                                let e;
                                if (1 === this.stream.numChunksLoaded) {
                                    const t = this.stream.numChunks - 1;
                                    this.stream.hasChunk(t) || (e = t);
                                } else e = this.stream.nextEmptyChunk(s);
                                Number.isInteger(e) && this._requestChunks([e]);
                            }
                            for (const e of o) {
                                const t = this._promisesByRequest.get(e);
                                this._promisesByRequest.delete(e);
                                t.resolve();
                            }
                            this.msgHandler.send('DocProgress', {
                                loaded: this.stream.numChunksLoaded * this.chunkSize,
                                total: this.length,
                            });
                        }
                        onError(e) {
                            this._loadedStreamCapability.reject(e);
                        }
                        getBeginChunk(e) {
                            return Math.floor(e / this.chunkSize);
                        }
                        getEndChunk(e) {
                            return Math.floor((e - 1) / this.chunkSize) + 1;
                        }
                        abort(e) {
                            this.aborted = !0;
                            this.pdfNetworkStream && this.pdfNetworkStream.cancelAllRequests(e);
                            for (const t of this._promisesByRequest.values()) t.reject(e);
                        }
                    };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.collectActions = function collectActions(e, t, r) {
                        const n = Object.create(null),
                            s = getInheritableProperty({ dict: t, key: 'AA', stopWhenFound: !1 });
                        if (s)
                            for (let t = s.length - 1; t >= 0; t--) {
                                const a = s[t];
                                if (a instanceof i.Dict)
                                    for (const t of a.getKeys()) {
                                        const s = r[t];
                                        if (!s) continue;
                                        const o = a.getRaw(t),
                                            c = new i.RefSet(),
                                            l = [];
                                        _collectJS(o, e, l, c);
                                        l.length > 0 && (n[s] = l);
                                    }
                            }
                        if (t.has('A')) {
                            const r = t.get('A'),
                                a = new i.RefSet(),
                                s = [];
                            _collectJS(r, e, s, a);
                            s.length > 0 && (n.Action = s);
                        }
                        return (0, a.objectSize)(n) > 0 ? n : null;
                    };
                    t.encodeToXmlString = function encodeToXmlString(e) {
                        const t = [];
                        let r = 0;
                        for (let a = 0, i = e.length; a < i; a++) {
                            const i = e.codePointAt(a);
                            if (32 <= i && i <= 126) {
                                const n = s[i];
                                if (n) {
                                    r < a && t.push(e.substring(r, a));
                                    t.push(n);
                                    r = a + 1;
                                }
                            } else {
                                r < a && t.push(e.substring(r, a));
                                t.push(`&#x${i.toString(16).toUpperCase()};`);
                                i > 55295 && (i < 57344 || i > 65533) && a++;
                                r = a + 1;
                            }
                        }
                        if (0 === t.length) return e;
                        r < e.length && t.push(e.substring(r, e.length));
                        return t.join('');
                    };
                    t.escapePDFName = function escapePDFName(e) {
                        const t = [];
                        let r = 0;
                        for (let a = 0, i = e.length; a < i; a++) {
                            const i = e.charCodeAt(a);
                            if (
                                i < 33 ||
                                i > 126 ||
                                35 === i ||
                                40 === i ||
                                41 === i ||
                                60 === i ||
                                62 === i ||
                                91 === i ||
                                93 === i ||
                                123 === i ||
                                125 === i ||
                                47 === i ||
                                37 === i
                            ) {
                                r < a && t.push(e.substring(r, a));
                                t.push(`#${i.toString(16)}`);
                                r = a + 1;
                            }
                        }
                        if (0 === t.length) return e;
                        r < e.length && t.push(e.substring(r, e.length));
                        return t.join('');
                    };
                    t.getArrayLookupTableFactory = function getArrayLookupTableFactory(e) {
                        let t;
                        return function () {
                            if (e) {
                                let r = e();
                                e = null;
                                t = Object.create(null);
                                for (let e = 0, a = r.length; e < a; e += 2) t[r[e]] = r[e + 1];
                                r = null;
                            }
                            return t;
                        };
                    };
                    t.getInheritableProperty = getInheritableProperty;
                    t.getLookupTableFactory = function getLookupTableFactory(e) {
                        let t;
                        return function () {
                            if (e) {
                                t = Object.create(null);
                                e(t);
                                e = null;
                            }
                            return t;
                        };
                    };
                    t.isWhiteSpace = function isWhiteSpace(e) {
                        return 32 === e || 9 === e || 13 === e || 10 === e;
                    };
                    t.log2 = function log2(e) {
                        if (e <= 0) return 0;
                        return Math.ceil(Math.log2(e));
                    };
                    t.parseXFAPath = function parseXFAPath(e) {
                        const t = /(.+)\[([0-9]+)\]$/;
                        return e.split('.').map((e) => {
                            const r = e.match(t);
                            return r ? { name: r[1], pos: parseInt(r[2], 10) } : { name: e, pos: 0 };
                        });
                    };
                    t.readInt8 = function readInt8(e, t) {
                        return (e[t] << 24) >> 24;
                    };
                    t.readUint16 = function readUint16(e, t) {
                        return (e[t] << 8) | e[t + 1];
                    };
                    t.readUint32 = function readUint32(e, t) {
                        return ((e[t] << 24) | (e[t + 1] << 16) | (e[t + 2] << 8) | e[t + 3]) >>> 0;
                    };
                    t.toRomanNumerals = function toRomanNumerals(e, t = !1) {
                        (0, a.assert)(Number.isInteger(e) && e > 0, 'The number should be a positive integer.');
                        const r = [];
                        let i;
                        for (; e >= 1e3; ) {
                            e -= 1e3;
                            r.push('M');
                        }
                        i = (e / 100) | 0;
                        e %= 100;
                        r.push(n[i]);
                        i = (e / 10) | 0;
                        e %= 10;
                        r.push(n[10 + i]);
                        r.push(n[20 + e]);
                        const s = r.join('');
                        return t ? s.toLowerCase() : s;
                    };
                    t.validateCSSFont = function validateCSSFont(e) {
                        const t = new Set([
                                '100',
                                '200',
                                '300',
                                '400',
                                '500',
                                '600',
                                '700',
                                '800',
                                '900',
                                '1000',
                                'normal',
                                'bold',
                                'bolder',
                                'lighter',
                            ]),
                            { fontFamily: r, fontWeight: i, italicAngle: n } = e;
                        if (/^".*"$/.test(r)) {
                            if (/[^\\]"/.test(r.slice(1, r.length - 1))) {
                                (0, a.warn)(`XFA - FontFamily contains some unescaped ": ${r}.`);
                                return !1;
                            }
                        } else if (/^'.*'$/.test(r)) {
                            if (/[^\\]'/.test(r.slice(1, r.length - 1))) {
                                (0, a.warn)(`XFA - FontFamily contains some unescaped ': ${r}.`);
                                return !1;
                            }
                        } else
                            for (const e of r.split(/[ \t]+/))
                                if (/^([0-9]|(-([0-9]|-)))/.test(e) || !/^[a-zA-Z0-9\-_\\]+$/.test(e)) {
                                    (0, a.warn)(`XFA - FontFamily contains some invalid <custom-ident>: ${r}.`);
                                    return !1;
                                }
                        const s = i ? i.toString() : '';
                        e.fontWeight = t.has(s) ? s : '400';
                        const o = parseFloat(n);
                        e.italicAngle = isNaN(o) || o < -90 || o > 90 ? '14' : n.toString();
                        return !0;
                    };
                    t.XRefParseException = t.XRefEntryException = t.MissingDataException = void 0;
                    var a = r(2),
                        i = r(5);
                    class MissingDataException extends a.BaseException {
                        constructor(e, t) {
                            super(`Missing data [${e}, ${t})`);
                            this.begin = e;
                            this.end = t;
                        }
                    }
                    t.MissingDataException = MissingDataException;
                    class XRefEntryException extends a.BaseException {}
                    t.XRefEntryException = XRefEntryException;
                    class XRefParseException extends a.BaseException {}
                    t.XRefParseException = XRefParseException;
                    function getInheritableProperty({ dict: e, key: t, getArray: r = !1, stopWhenFound: a = !0 }) {
                        let n;
                        const s = new i.RefSet();
                        for (; e instanceof i.Dict && (!e.objId || !s.has(e.objId)); ) {
                            e.objId && s.put(e.objId);
                            const i = r ? e.getArray(t) : e.get(t);
                            if (void 0 !== i) {
                                if (a) return i;
                                n || (n = []);
                                n.push(i);
                            }
                            e = e.get('Parent');
                        }
                        return n;
                    }
                    const n = [
                        '',
                        'C',
                        'CC',
                        'CCC',
                        'CD',
                        'D',
                        'DC',
                        'DCC',
                        'DCCC',
                        'CM',
                        '',
                        'X',
                        'XX',
                        'XXX',
                        'XL',
                        'L',
                        'LX',
                        'LXX',
                        'LXXX',
                        'XC',
                        '',
                        'I',
                        'II',
                        'III',
                        'IV',
                        'V',
                        'VI',
                        'VII',
                        'VIII',
                        'IX',
                    ];
                    function _collectJS(e, t, r, n) {
                        if (!e) return;
                        let s = null;
                        if ((0, i.isRef)(e)) {
                            if (n.has(e)) return;
                            s = e;
                            n.put(s);
                            e = t.fetch(e);
                        }
                        if (Array.isArray(e)) for (const a of e) _collectJS(a, t, r, n);
                        else if (e instanceof i.Dict) {
                            if ((0, i.isName)(e.get('S'), 'JavaScript') && e.has('JS')) {
                                const t = e.get('JS');
                                let n;
                                n = (0, i.isStream)(t) ? t.getString() : t;
                                n = (0, a.stringToPDFString)(n);
                                n && r.push(n);
                            }
                            _collectJS(e.getRaw('Next'), t, r, n);
                        }
                        s && n.remove(s);
                    }
                    const s = { 60: '&lt;', 62: '&gt;', 38: '&amp;', 34: '&quot;', 39: '&apos;' };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.StringStream = t.Stream = t.NullStream = void 0;
                    var a = r(6),
                        i = r(2);
                    class Stream extends a.BaseStream {
                        constructor(e, t, r, a) {
                            super();
                            this.bytes = e instanceof Uint8Array ? e : new Uint8Array(e);
                            this.start = t || 0;
                            this.pos = this.start;
                            this.end = t + r || this.bytes.length;
                            this.dict = a;
                        }
                        get length() {
                            return this.end - this.start;
                        }
                        get isEmpty() {
                            return 0 === this.length;
                        }
                        getByte() {
                            return this.pos >= this.end ? -1 : this.bytes[this.pos++];
                        }
                        getBytes(e, t = !1) {
                            const r = this.bytes,
                                a = this.pos,
                                i = this.end;
                            if (!e) {
                                const e = r.subarray(a, i);
                                return t ? new Uint8ClampedArray(e) : e;
                            }
                            let n = a + e;
                            n > i && (n = i);
                            this.pos = n;
                            const s = r.subarray(a, n);
                            return t ? new Uint8ClampedArray(s) : s;
                        }
                        getByteRange(e, t) {
                            e < 0 && (e = 0);
                            t > this.end && (t = this.end);
                            return this.bytes.subarray(e, t);
                        }
                        reset() {
                            this.pos = this.start;
                        }
                        moveStart() {
                            this.start = this.pos;
                        }
                        makeSubStream(e, t, r = null) {
                            return new Stream(this.bytes.buffer, e, t, r);
                        }
                    }
                    t.Stream = Stream;
                    t.StringStream = class StringStream extends Stream {
                        constructor(e) {
                            super((0, i.stringToBytes)(e));
                        }
                    };
                    t.NullStream = class NullStream extends Stream {
                        constructor() {
                            super(new Uint8Array(0));
                        }
                    };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.PDFDocument = t.Page = void 0;
                    var a = r(2),
                        i = r(5),
                        n = r(9),
                        s = r(10),
                        o = r(12),
                        c = r(6),
                        l = r(65),
                        h = r(57),
                        u = r(17),
                        d = r(63),
                        f = r(55),
                        g = r(15),
                        p = r(19),
                        m = r(62),
                        b = r(67),
                        y = r(88);
                    const w = [0, 0, 612, 792];
                    class Page {
                        constructor({
                            pdfManager: e,
                            xref: t,
                            pageIndex: r,
                            pageDict: a,
                            ref: i,
                            globalIdFactory: n,
                            fontCache: s,
                            builtInCMapCache: o,
                            globalImageCache: c,
                            nonBlendModesSet: l,
                            xfaFactory: h,
                        }) {
                            this.pdfManager = e;
                            this.pageIndex = r;
                            this.pageDict = a;
                            this.xref = t;
                            this.ref = i;
                            this.fontCache = s;
                            this.builtInCMapCache = o;
                            this.globalImageCache = c;
                            this.nonBlendModesSet = l;
                            this.evaluatorOptions = e.evaluatorOptions;
                            this.resourcesPromise = null;
                            this.xfaFactory = h;
                            const u = { obj: 0 };
                            this._localIdFactory = class extends n {
                                static createObjId() {
                                    return `p${r}_${++u.obj}`;
                                }
                                static getPageObjId() {
                                    return `page${i.toString()}`;
                                }
                            };
                        }
                        _getInheritableProperty(e, t = !1) {
                            const r = (0, n.getInheritableProperty)({
                                dict: this.pageDict,
                                key: e,
                                getArray: t,
                                stopWhenFound: !1,
                            });
                            return Array.isArray(r)
                                ? 1 !== r.length && (0, i.isDict)(r[0])
                                    ? i.Dict.merge({ xref: this.xref, dictArray: r })
                                    : r[0]
                                : r;
                        }
                        get content() {
                            return this.pageDict.getArray('Contents');
                        }
                        get resources() {
                            return (0, a.shadow)(
                                this,
                                'resources',
                                this._getInheritableProperty('Resources') || i.Dict.empty
                            );
                        }
                        _getBoundingBox(e) {
                            if (this.xfaData) {
                                const { width: e, height: t } = this.xfaData.attributes.style;
                                return [0, 0, parseInt(e), parseInt(t)];
                            }
                            const t = this._getInheritableProperty(e, !0);
                            if (Array.isArray(t) && 4 === t.length) {
                                if (t[2] - t[0] != 0 && t[3] - t[1] != 0) return t;
                                (0, a.warn)(`Empty /${e} entry.`);
                            }
                            return null;
                        }
                        get mediaBox() {
                            return (0, a.shadow)(this, 'mediaBox', this._getBoundingBox('MediaBox') || w);
                        }
                        get cropBox() {
                            return (0, a.shadow)(this, 'cropBox', this._getBoundingBox('CropBox') || this.mediaBox);
                        }
                        get userUnit() {
                            let e = this.pageDict.get('UserUnit');
                            (!(0, a.isNum)(e) || e <= 0) && (e = 1);
                            return (0, a.shadow)(this, 'userUnit', e);
                        }
                        get view() {
                            const { cropBox: e, mediaBox: t } = this;
                            let r;
                            if (e === t || (0, a.isArrayEqual)(e, t)) r = t;
                            else {
                                const i = a.Util.intersect(e, t);
                                i && i[2] - i[0] != 0 && i[3] - i[1] != 0
                                    ? (r = i)
                                    : (0, a.warn)('Empty /CropBox and /MediaBox intersection.');
                            }
                            return (0, a.shadow)(this, 'view', r || t);
                        }
                        get rotate() {
                            let e = this._getInheritableProperty('Rotate') || 0;
                            e % 90 != 0 ? (e = 0) : e >= 360 ? (e %= 360) : e < 0 && (e = ((e % 360) + 360) % 360);
                            return (0, a.shadow)(this, 'rotate', e);
                        }
                        getContentStream() {
                            return this.pdfManager
                                .ensure(this, 'content')
                                .then((e) =>
                                    e instanceof c.BaseStream
                                        ? e
                                        : Array.isArray(e)
                                        ? new p.StreamsSequenceStream(e)
                                        : new s.NullStream()
                                );
                        }
                        get xfaData() {
                            return this.xfaFactory
                                ? (0, a.shadow)(this, 'xfaData', this.xfaFactory.getPage(this.pageIndex))
                                : (0, a.shadow)(this, 'xfaData', null);
                        }
                        save(e, t, r) {
                            const i = new g.PartialEvaluator({
                                xref: this.xref,
                                handler: e,
                                pageIndex: this.pageIndex,
                                idFactory: this._localIdFactory,
                                fontCache: this.fontCache,
                                builtInCMapCache: this.builtInCMapCache,
                                globalImageCache: this.globalImageCache,
                                options: this.evaluatorOptions,
                            });
                            return this._parsedAnnotations.then(function (e) {
                                const n = [];
                                for (const s of e)
                                    s.mustBePrinted(r) &&
                                        n.push(
                                            s.save(i, t, r).catch(function (e) {
                                                (0,
                                                a.warn)(`save - ignoring annotation data during "${t.name}" task: "${e}".`);
                                                return null;
                                            })
                                        );
                                return Promise.all(n);
                            });
                        }
                        loadResources(e) {
                            this.resourcesPromise ||
                                (this.resourcesPromise = this.pdfManager.ensure(this, 'resources'));
                            return this.resourcesPromise.then(() =>
                                new d.ObjectLoader(this.resources, e, this.xref).load()
                            );
                        }
                        getOperatorList({
                            handler: e,
                            sink: t,
                            task: r,
                            intent: i,
                            renderInteractiveForms: n,
                            annotationStorage: s,
                        }) {
                            const o = this.getContentStream(),
                                c = this.loadResources([
                                    'ColorSpace',
                                    'ExtGState',
                                    'Font',
                                    'Pattern',
                                    'Properties',
                                    'Shading',
                                    'XObject',
                                ]),
                                l = new g.PartialEvaluator({
                                    xref: this.xref,
                                    handler: e,
                                    pageIndex: this.pageIndex,
                                    idFactory: this._localIdFactory,
                                    fontCache: this.fontCache,
                                    builtInCMapCache: this.builtInCMapCache,
                                    globalImageCache: this.globalImageCache,
                                    options: this.evaluatorOptions,
                                }),
                                h = Promise.all([o, c]).then(([a]) => {
                                    const n = new f.OperatorList(i, t);
                                    e.send('StartRenderPage', {
                                        transparency: l.hasBlendModes(this.resources, this.nonBlendModesSet),
                                        pageIndex: this.pageIndex,
                                        intent: i,
                                    });
                                    return l
                                        .getOperatorList({
                                            stream: a,
                                            task: r,
                                            resources: this.resources,
                                            operatorList: n,
                                        })
                                        .then(function () {
                                            return n;
                                        });
                                });
                            return Promise.all([h, this._parsedAnnotations]).then(function ([e, t]) {
                                if (0 === t.length) {
                                    e.flush(!0);
                                    return { length: e.totalLength };
                                }
                                const o = [];
                                for (const e of t)
                                    (('display' === i && e.mustBeViewed(s)) || ('print' === i && e.mustBePrinted(s))) &&
                                        o.push(
                                            e.getOperatorList(l, r, n, s).catch(function (e) {
                                                (0,
                                                a.warn)(`getOperatorList - ignoring annotation data during "${r.name}" task: "${e}".`);
                                                return null;
                                            })
                                        );
                                return Promise.all(o).then(function (t) {
                                    e.addOp(a.OPS.beginAnnotations, []);
                                    for (const r of t) e.addOpList(r);
                                    e.addOp(a.OPS.endAnnotations, []);
                                    e.flush(!0);
                                    return { length: e.totalLength };
                                });
                            });
                        }
                        extractTextContent({
                            handler: e,
                            task: t,
                            normalizeWhitespace: r,
                            includeMarkedContent: a,
                            sink: i,
                            combineTextItems: n,
                        }) {
                            const s = this.getContentStream(),
                                o = this.loadResources(['ExtGState', 'Font', 'Properties', 'XObject']);
                            return Promise.all([s, o]).then(([s]) =>
                                new g.PartialEvaluator({
                                    xref: this.xref,
                                    handler: e,
                                    pageIndex: this.pageIndex,
                                    idFactory: this._localIdFactory,
                                    fontCache: this.fontCache,
                                    builtInCMapCache: this.builtInCMapCache,
                                    globalImageCache: this.globalImageCache,
                                    options: this.evaluatorOptions,
                                }).getTextContent({
                                    stream: s,
                                    task: t,
                                    resources: this.resources,
                                    normalizeWhitespace: r,
                                    includeMarkedContent: a,
                                    combineTextItems: n,
                                    sink: i,
                                })
                            );
                        }
                        async getStructTree() {
                            const e = await this.pdfManager.ensureCatalog('structTreeRoot');
                            if (!e) return null;
                            return (await this.pdfManager.ensure(this, '_parseStructTree', [e])).serializable;
                        }
                        _parseStructTree(e) {
                            const t = new m.StructTreePage(e, this.pageDict);
                            t.parse();
                            return t;
                        }
                        getAnnotationsData(e) {
                            return this._parsedAnnotations.then(function (t) {
                                const r = [];
                                for (let a = 0, i = t.length; a < i; a++)
                                    (!e || ('display' === e && t[a].viewable) || ('print' === e && t[a].printable)) &&
                                        r.push(t[a].data);
                                return r;
                            });
                        }
                        get annotations() {
                            const e = this._getInheritableProperty('Annots');
                            return (0, a.shadow)(this, 'annotations', Array.isArray(e) ? e : []);
                        }
                        get _parsedAnnotations() {
                            const e = this.pdfManager.ensure(this, 'annotations').then(() => {
                                const e = [];
                                for (const t of this.annotations)
                                    e.push(
                                        o.AnnotationFactory.create(
                                            this.xref,
                                            t,
                                            this.pdfManager,
                                            this._localIdFactory,
                                            !1
                                        ).catch(function (e) {
                                            (0, a.warn)(`_parsedAnnotations: "${e}".`);
                                            return null;
                                        })
                                    );
                                return Promise.all(e).then(function (e) {
                                    return e.filter((e) => !!e);
                                });
                            });
                            return (0, a.shadow)(this, '_parsedAnnotations', e);
                        }
                        get jsActions() {
                            const e = (0, n.collectActions)(this.xref, this.pageDict, a.PageActionEventType);
                            return (0, a.shadow)(this, 'jsActions', e);
                        }
                    }
                    t.Page = Page;
                    const S = new Uint8Array([37, 80, 68, 70, 45]),
                        x = new Uint8Array([115, 116, 97, 114, 116, 120, 114, 101, 102]),
                        k = new Uint8Array([101, 110, 100, 111, 98, 106]),
                        C = /^[1-9]\.[0-9]$/;
                    function find(e, t, r = 1024, a = !1) {
                        const i = t.length,
                            n = e.peekBytes(r),
                            s = n.length - i;
                        if (s <= 0) return !1;
                        if (a) {
                            const r = i - 1;
                            let a = n.length - 1;
                            for (; a >= r; ) {
                                let s = 0;
                                for (; s < i && n[a - s] === t[r - s]; ) s++;
                                if (s >= i) {
                                    e.pos += a - r;
                                    return !0;
                                }
                                a--;
                            }
                        } else {
                            let r = 0;
                            for (; r <= s; ) {
                                let a = 0;
                                for (; a < i && n[r + a] === t[a]; ) a++;
                                if (a >= i) {
                                    e.pos += r;
                                    return !0;
                                }
                                r++;
                            }
                        }
                        return !1;
                    }
                    t.PDFDocument = class PDFDocument {
                        constructor(e, t) {
                            let r;
                            if ((0, i.isStream)(t)) r = t;
                            else {
                                if (!(0, a.isArrayBuffer)(t)) throw new Error('PDFDocument: Unknown argument type');
                                r = new s.Stream(t);
                            }
                            if (r.length <= 0)
                                throw new a.InvalidPDFException('The PDF file is empty, i.e. its size is zero bytes.');
                            this.pdfManager = e;
                            this.stream = r;
                            this.xref = new y.XRef(r, e);
                            this._pagePromises = [];
                            this._version = null;
                            const n = { font: 0 };
                            this._globalIdFactory = class {
                                static getDocId() {
                                    return `g_${e.docId}`;
                                }
                                static createFontId() {
                                    return 'f' + ++n.font;
                                }
                                static createObjId() {
                                    (0, a.unreachable)('Abstract method `createObjId` called.');
                                }
                                static getPageObjId() {
                                    (0, a.unreachable)('Abstract method `getPageObjId` called.');
                                }
                            };
                        }
                        parse(e) {
                            this.xref.parse(e);
                            this.catalog = new h.Catalog(this.pdfManager, this.xref);
                            this.catalog.version && (this._version = this.catalog.version);
                        }
                        get linearization() {
                            let e = null;
                            try {
                                e = u.Linearization.create(this.stream);
                            } catch (e) {
                                if (e instanceof n.MissingDataException) throw e;
                                (0, a.info)(e);
                            }
                            return (0, a.shadow)(this, 'linearization', e);
                        }
                        get startXRef() {
                            const e = this.stream;
                            let t = 0;
                            if (this.linearization) {
                                e.reset();
                                find(e, k) && (t = e.pos + 6 - e.start);
                            } else {
                                const r = 1024,
                                    a = x.length;
                                let i = !1,
                                    s = e.end;
                                for (; !i && s > 0; ) {
                                    s -= r - a;
                                    s < 0 && (s = 0);
                                    e.pos = s;
                                    i = find(e, x, r, !0);
                                }
                                if (i) {
                                    e.skip(9);
                                    let r;
                                    do {
                                        r = e.getByte();
                                    } while ((0, n.isWhiteSpace)(r));
                                    let a = '';
                                    for (; r >= 32 && r <= 57; ) {
                                        a += String.fromCharCode(r);
                                        r = e.getByte();
                                    }
                                    t = parseInt(a, 10);
                                    isNaN(t) && (t = 0);
                                }
                            }
                            return (0, a.shadow)(this, 'startXRef', t);
                        }
                        checkHeader() {
                            const e = this.stream;
                            e.reset();
                            if (!find(e, S)) return;
                            e.moveStart();
                            let t,
                                r = '';
                            for (; (t = e.getByte()) > 32 && !(r.length >= 12); ) r += String.fromCharCode(t);
                            this._version || (this._version = r.substring(5));
                        }
                        parseStartXRef() {
                            this.xref.setStartXRef(this.startXRef);
                        }
                        get numPages() {
                            if (this.xfaFactory) return (0, a.shadow)(this, 'numPages', this.xfaFactory.numberPages);
                            const e = this.linearization,
                                t = e ? e.numPages : this.catalog.numPages;
                            return (0, a.shadow)(this, 'numPages', t);
                        }
                        _hasOnlyDocumentSignatures(e, t = 0) {
                            return (
                                !!Array.isArray(e) &&
                                e.every((e) => {
                                    if (!((e = this.xref.fetchIfRef(e)) instanceof i.Dict)) return !1;
                                    if (e.has('Kids')) {
                                        if (++t > 10) {
                                            (0, a.warn)('_hasOnlyDocumentSignatures: maximum recursion depth reached');
                                            return !1;
                                        }
                                        return this._hasOnlyDocumentSignatures(e.get('Kids'), t);
                                    }
                                    const r = (0, i.isName)(e.get('FT'), 'Sig'),
                                        n = e.get('Rect'),
                                        s = Array.isArray(n) && n.every((e) => 0 === e);
                                    return r && s;
                                })
                            );
                        }
                        get xfaData() {
                            const e = this.catalog.acroForm;
                            if (!e) return null;
                            const t = e.get('XFA'),
                                r = {
                                    'xdp:xdp': '',
                                    'template': '',
                                    'datasets': '',
                                    'config': '',
                                    'connectionSet': '',
                                    'localeSet': '',
                                    'stylesheet': '',
                                    '/xdp:xdp': '',
                                };
                            if ((0, i.isStream)(t) && !t.isEmpty)
                                try {
                                    r['xdp:xdp'] = (0, a.stringToUTF8String)(t.getString());
                                    return r;
                                } catch (e) {
                                    (0, a.warn)('XFA - Invalid utf-8 string.');
                                    return null;
                                }
                            if (!Array.isArray(t) || 0 === t.length) return null;
                            for (let e = 0, n = t.length; e < n; e += 2) {
                                let s;
                                s = 0 === e ? 'xdp:xdp' : e === n - 2 ? '/xdp:xdp' : t[e];
                                if (!r.hasOwnProperty(s)) continue;
                                const o = this.xref.fetchIfRef(t[e + 1]);
                                if ((0, i.isStream)(o) && !o.isEmpty)
                                    try {
                                        r[s] = (0, a.stringToUTF8String)(o.getString());
                                    } catch (e) {
                                        (0, a.warn)('XFA - Invalid utf-8 string.');
                                        return null;
                                    }
                            }
                            return r;
                        }
                        get xfaFactory() {
                            if (this.pdfManager.enableXfa && this.formInfo.hasXfa && !this.formInfo.hasAcroForm) {
                                const e = this.xfaData;
                                return (0, a.shadow)(this, 'xfaFactory', e ? new b.XFAFactory(e) : null);
                            }
                            return (0, a.shadow)(this, 'xfaFaxtory', null);
                        }
                        get isPureXfa() {
                            return null !== this.xfaFactory;
                        }
                        async loadXfaFonts(e, t) {
                            const r = await this.pdfManager.ensureCatalog('acroForm');
                            if (!r) return;
                            const s = await r.getAsync('DR');
                            if (!(s instanceof i.Dict)) return;
                            const o = new d.ObjectLoader(s, ['Font'], this.xref);
                            await o.load();
                            const c = s.get('Font');
                            if (!(c instanceof i.Dict)) return;
                            const l = new g.PartialEvaluator({
                                    xref: this.xref,
                                    handler: e,
                                    pageIndex: -1,
                                    idFactory: this._globalIdFactory,
                                    fontCache: this.catalog.fontCache,
                                    builtInCMapCache: this.catalog.builtInCMapCache,
                                }),
                                h = new f.OperatorList(),
                                u = {
                                    font: null,
                                    clone() {
                                        return this;
                                    },
                                },
                                p = new Map();
                            c.forEach((e, t) => {
                                p.set(e, t);
                            });
                            const m = [];
                            for (const [e, r] of p) {
                                const o = r.get('FontDescriptor');
                                if (!(o instanceof i.Dict)) continue;
                                const c = {
                                    fontFamily: o.get('FontFamily'),
                                    fontWeight: o.get('FontWeight'),
                                    italicAngle: -o.get('ItalicAngle'),
                                };
                                (0, n.validateCSSFont)(c) &&
                                    m.push(
                                        l
                                            .handleSetFont(s, [i.Name.get(e), 1], null, h, t, u, null, c)
                                            .catch(function (e) {
                                                (0, a.warn)(`loadXfaFonts: "${e}".`);
                                                return null;
                                            })
                                    );
                            }
                            await Promise.all(m);
                        }
                        get formInfo() {
                            const e = { hasFields: !1, hasAcroForm: !1, hasXfa: !1, hasSignatures: !1 },
                                t = this.catalog.acroForm;
                            if (!t) return (0, a.shadow)(this, 'formInfo', e);
                            try {
                                const r = t.get('Fields'),
                                    a = Array.isArray(r) && r.length > 0;
                                e.hasFields = a;
                                const n = t.get('XFA');
                                e.hasXfa = (Array.isArray(n) && n.length > 0) || ((0, i.isStream)(n) && !n.isEmpty);
                                const s = !!(1 & t.get('SigFlags')),
                                    o = s && this._hasOnlyDocumentSignatures(r);
                                e.hasAcroForm = a && !o;
                                e.hasSignatures = s;
                            } catch (e) {
                                if (e instanceof n.MissingDataException) throw e;
                                (0, a.warn)(`Cannot fetch form information: "${e}".`);
                            }
                            return (0, a.shadow)(this, 'formInfo', e);
                        }
                        get documentInfo() {
                            const e = {
                                Title: a.isString,
                                Author: a.isString,
                                Subject: a.isString,
                                Keywords: a.isString,
                                Creator: a.isString,
                                Producer: a.isString,
                                CreationDate: a.isString,
                                ModDate: a.isString,
                                Trapped: i.isName,
                            };
                            let t = this._version;
                            if ('string' != typeof t || !C.test(t)) {
                                (0, a.warn)(`Invalid PDF header version number: ${t}`);
                                t = null;
                            }
                            const r = {
                                PDFFormatVersion: t,
                                IsLinearized: !!this.linearization,
                                IsAcroFormPresent: this.formInfo.hasAcroForm,
                                IsXFAPresent: this.formInfo.hasXfa,
                                IsCollectionPresent: !!this.catalog.collection,
                                IsSignaturesPresent: this.formInfo.hasSignatures,
                            };
                            let s;
                            try {
                                s = this.xref.trailer.get('Info');
                            } catch (e) {
                                if (e instanceof n.MissingDataException) throw e;
                                (0, a.info)('The document information dictionary is invalid.');
                            }
                            if ((0, i.isDict)(s))
                                for (const t of s.getKeys()) {
                                    const n = s.get(t);
                                    if (e[t])
                                        e[t](n)
                                            ? (r[t] = 'string' != typeof n ? n : (0, a.stringToPDFString)(n))
                                            : (0, a.info)(`Bad value in document info for "${t}".`);
                                    else if ('string' == typeof t) {
                                        let e;
                                        if ((0, a.isString)(n)) e = (0, a.stringToPDFString)(n);
                                        else {
                                            if (!((0, i.isName)(n) || (0, a.isNum)(n) || (0, a.isBool)(n))) {
                                                (0, a.info)(`Unsupported value in document info for (custom) "${t}".`);
                                                continue;
                                            }
                                            e = n;
                                        }
                                        r.Custom || (r.Custom = Object.create(null));
                                        r.Custom[t] = e;
                                    }
                                }
                            return (0, a.shadow)(this, 'documentInfo', r);
                        }
                        get fingerprint() {
                            let e;
                            const t = this.xref.trailer.get('ID');
                            e =
                                Array.isArray(t) &&
                                t[0] &&
                                (0, a.isString)(t[0]) &&
                                '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0' !== t[0]
                                    ? (0, a.stringToBytes)(t[0])
                                    : (0, l.calculateMD5)(this.stream.getByteRange(0, 1024), 0, 1024);
                            const r = [];
                            for (let t = 0, a = e.length; t < a; t++) {
                                const a = e[t].toString(16);
                                r.push(a.padStart(2, '0'));
                            }
                            return (0, a.shadow)(this, 'fingerprint', r.join(''));
                        }
                        _getLinearizationPage(e) {
                            const { catalog: t, linearization: r } = this,
                                n = i.Ref.get(r.objectNumberFirst, 0);
                            return this.xref
                                .fetchAsync(n)
                                .then((e) => {
                                    if (
                                        (0, i.isDict)(e, 'Page') ||
                                        ((0, i.isDict)(e) && !e.has('Type') && e.has('Contents'))
                                    ) {
                                        n && !t.pageKidsCountCache.has(n) && t.pageKidsCountCache.put(n, 1);
                                        return [e, n];
                                    }
                                    throw new a.FormatError(
                                        "The Linearization dictionary doesn't point to a valid Page dictionary."
                                    );
                                })
                                .catch((r) => {
                                    (0, a.info)(r);
                                    return t.getPageDict(e);
                                });
                        }
                        getPage(e) {
                            if (void 0 !== this._pagePromises[e]) return this._pagePromises[e];
                            const { catalog: t, linearization: r } = this;
                            if (this.xfaFactory)
                                return Promise.resolve(
                                    new Page({
                                        pdfManager: this.pdfManager,
                                        xref: this.xref,
                                        pageIndex: e,
                                        pageDict: i.Dict.empty,
                                        ref: null,
                                        globalIdFactory: this._globalIdFactory,
                                        fontCache: t.fontCache,
                                        builtInCMapCache: t.builtInCMapCache,
                                        globalImageCache: t.globalImageCache,
                                        nonBlendModesSet: t.nonBlendModesSet,
                                        xfaFactory: this.xfaFactory,
                                    })
                                );
                            const a = r && r.pageFirst === e ? this._getLinearizationPage(e) : t.getPageDict(e);
                            return (this._pagePromises[e] = a.then(
                                ([r, a]) =>
                                    new Page({
                                        pdfManager: this.pdfManager,
                                        xref: this.xref,
                                        pageIndex: e,
                                        pageDict: r,
                                        ref: a,
                                        globalIdFactory: this._globalIdFactory,
                                        fontCache: t.fontCache,
                                        builtInCMapCache: t.builtInCMapCache,
                                        globalImageCache: t.globalImageCache,
                                        nonBlendModesSet: t.nonBlendModesSet,
                                        xfaFactory: null,
                                    })
                            ));
                        }
                        checkFirstPage() {
                            return this.getPage(0).catch(async (e) => {
                                if (e instanceof n.XRefEntryException) {
                                    this._pagePromises.length = 0;
                                    await this.cleanup();
                                    throw new n.XRefParseException();
                                }
                            });
                        }
                        fontFallback(e, t) {
                            return this.catalog.fontFallback(e, t);
                        }
                        async cleanup(e = !1) {
                            return this.catalog ? this.catalog.cleanup(e) : (0, i.clearPrimitiveCaches)();
                        }
                        _collectFieldObjects(e, t, r) {
                            const i = this.xref.fetchIfRef(t);
                            if (i.has('T')) {
                                const t = (0, a.stringToPDFString)(i.get('T'));
                                e = '' === e ? t : `${e}.${t}`;
                            }
                            r.has(e) || r.set(e, []);
                            r.get(e).push(
                                o.AnnotationFactory.create(this.xref, t, this.pdfManager, this._localIdFactory, !0)
                                    .then((e) => e && e.getFieldObject())
                                    .catch(function (e) {
                                        (0, a.warn)(`_collectFieldObjects: "${e}".`);
                                        return null;
                                    })
                            );
                            if (i.has('Kids')) {
                                const t = i.get('Kids');
                                for (const a of t) this._collectFieldObjects(e, a, r);
                            }
                        }
                        get fieldObjects() {
                            if (!this.formInfo.hasFields)
                                return (0, a.shadow)(this, 'fieldObjects', Promise.resolve(null));
                            const e = Object.create(null),
                                t = new Map();
                            for (const e of this.catalog.acroForm.get('Fields')) this._collectFieldObjects('', e, t);
                            const r = [];
                            for (const [a, i] of t)
                                r.push(
                                    Promise.all(i).then((t) => {
                                        (t = t.filter((e) => !!e)).length > 0 && (e[a] = t);
                                    })
                                );
                            return (0, a.shadow)(
                                this,
                                'fieldObjects',
                                Promise.all(r).then(() => e)
                            );
                        }
                        get hasJSActions() {
                            const e = this.pdfManager.ensureDoc('_parseHasJSActions');
                            return (0, a.shadow)(this, 'hasJSActions', e);
                        }
                        async _parseHasJSActions() {
                            const [e, t] = await Promise.all([
                                this.pdfManager.ensureCatalog('jsActions'),
                                this.pdfManager.ensureDoc('fieldObjects'),
                            ]);
                            return !!e || (!!t && Object.values(t).some((e) => e.some((e) => null !== e.actions)));
                        }
                        get calculationOrderIds() {
                            const e = this.catalog.acroForm;
                            if (!e || !e.has('CO')) return (0, a.shadow)(this, 'calculationOrderIds', null);
                            const t = e.get('CO');
                            if (!Array.isArray(t) || 0 === t.length)
                                return (0, a.shadow)(this, 'calculationOrderIds', null);
                            const r = t.filter(i.isRef).map((e) => e.toString());
                            return 0 === r.length
                                ? (0, a.shadow)(this, 'calculationOrderIds', null)
                                : (0, a.shadow)(this, 'calculationOrderIds', r);
                        }
                    };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.getQuadPoints = getQuadPoints;
                    t.MarkupAnnotation = t.AnnotationFactory = t.AnnotationBorderStyle = t.Annotation = void 0;
                    var a = r(2),
                        i = r(9),
                        n = r(13),
                        s = r(5),
                        o = r(57),
                        c = r(14),
                        l = r(59),
                        h = r(63),
                        u = r(55),
                        d = r(10),
                        f = r(64);
                    t.AnnotationFactory = class AnnotationFactory {
                        static create(e, t, r, a, i) {
                            return Promise.all([
                                r.ensureCatalog('acroForm'),
                                i ? this._getPageIndex(e, t, r) : -1,
                            ]).then(([n, s]) => r.ensure(this, '_create', [e, t, r, a, n, i, s]));
                        }
                        static _create(e, t, r, n, o, c, l = -1) {
                            const h = e.fetchIfRef(t);
                            if (!(0, s.isDict)(h)) return;
                            const u = (0, s.isRef)(t) ? t.toString() : `annot_${n.createObjId()}`;
                            let d = h.get('Subtype');
                            d = (0, s.isName)(d) ? d.name : null;
                            const f = {
                                xref: e,
                                ref: t,
                                dict: h,
                                subtype: d,
                                id: u,
                                pdfManager: r,
                                acroForm: o instanceof s.Dict ? o : s.Dict.empty,
                                collectFields: c,
                                pageIndex: l,
                            };
                            switch (d) {
                                case 'Link':
                                    return new LinkAnnotation(f);
                                case 'Text':
                                    return new TextAnnotation(f);
                                case 'Widget':
                                    let e = (0, i.getInheritableProperty)({ dict: h, key: 'FT' });
                                    e = (0, s.isName)(e) ? e.name : null;
                                    switch (e) {
                                        case 'Tx':
                                            return new TextWidgetAnnotation(f);
                                        case 'Btn':
                                            return new ButtonWidgetAnnotation(f);
                                        case 'Ch':
                                            return new ChoiceWidgetAnnotation(f);
                                        case 'Sig':
                                            return new SignatureWidgetAnnotation(f);
                                    }
                                    (0, a.warn)(
                                        `Unimplemented widget field type "${e}", falling back to base field type.`
                                    );
                                    return new WidgetAnnotation(f);
                                case 'Popup':
                                    return new PopupAnnotation(f);
                                case 'FreeText':
                                    return new FreeTextAnnotation(f);
                                case 'Line':
                                    return new LineAnnotation(f);
                                case 'Square':
                                    return new SquareAnnotation(f);
                                case 'Circle':
                                    return new CircleAnnotation(f);
                                case 'PolyLine':
                                    return new PolylineAnnotation(f);
                                case 'Polygon':
                                    return new PolygonAnnotation(f);
                                case 'Caret':
                                    return new CaretAnnotation(f);
                                case 'Ink':
                                    return new InkAnnotation(f);
                                case 'Highlight':
                                    return new HighlightAnnotation(f);
                                case 'Underline':
                                    return new UnderlineAnnotation(f);
                                case 'Squiggly':
                                    return new SquigglyAnnotation(f);
                                case 'StrikeOut':
                                    return new StrikeOutAnnotation(f);
                                case 'Stamp':
                                    return new StampAnnotation(f);
                                case 'FileAttachment':
                                    return new FileAttachmentAnnotation(f);
                                default:
                                    c ||
                                        (d
                                            ? (0, a.warn)(
                                                  `Unimplemented annotation type "${d}", falling back to base annotation.`
                                              )
                                            : (0, a.warn)('Annotation is missing the required /Subtype.'));
                                    return new Annotation(f);
                            }
                        }
                        static async _getPageIndex(e, t, r) {
                            try {
                                const a = await e.fetchIfRefAsync(t);
                                if (!(0, s.isDict)(a)) return -1;
                                const i = a.getRaw('P');
                                if (!(0, s.isRef)(i)) return -1;
                                return await r.ensureCatalog('getPageIndex', [i]);
                            } catch (e) {
                                (0, a.warn)(`_getPageIndex: "${e}".`);
                                return -1;
                            }
                        }
                    };
                    function getRgbColor(e) {
                        const t = new Uint8ClampedArray(3);
                        if (!Array.isArray(e)) return t;
                        switch (e.length) {
                            case 0:
                                return null;
                            case 1:
                                c.ColorSpace.singletons.gray.getRgbItem(e, 0, t, 0);
                                return t;
                            case 3:
                                c.ColorSpace.singletons.rgb.getRgbItem(e, 0, t, 0);
                                return t;
                            case 4:
                                c.ColorSpace.singletons.cmyk.getRgbItem(e, 0, t, 0);
                                return t;
                            default:
                                return t;
                        }
                    }
                    function getQuadPoints(e, t) {
                        if (!e.has('QuadPoints')) return null;
                        const r = e.getArray('QuadPoints');
                        if (!Array.isArray(r) || 0 === r.length || r.length % 8 > 0) return null;
                        const a = [];
                        for (let e = 0, i = r.length / 8; e < i; e++) {
                            a.push([]);
                            for (let i = 8 * e, n = 8 * e + 8; i < n; i += 2) {
                                const n = r[i],
                                    s = r[i + 1];
                                if (null !== t && (n < t[0] || n > t[2] || s < t[1] || s > t[3])) return null;
                                a[e].push({ x: n, y: s });
                            }
                        }
                        return a.map((e) => {
                            const [t, r, a, i] = e.reduce(
                                ([e, t, r, a], i) => [
                                    Math.min(e, i.x),
                                    Math.max(t, i.x),
                                    Math.min(r, i.y),
                                    Math.max(a, i.y),
                                ],
                                [Number.MAX_VALUE, Number.MIN_VALUE, Number.MAX_VALUE, Number.MIN_VALUE]
                            );
                            return [
                                { x: t, y: i },
                                { x: r, y: i },
                                { x: t, y: a },
                                { x: r, y: a },
                            ];
                        });
                    }
                    function getTransformMatrix(e, t, r) {
                        const [i, n, s, o] = a.Util.getAxialAlignedBoundingBox(t, r);
                        if (i === s || n === o) return [1, 0, 0, 1, e[0], e[1]];
                        const c = (e[2] - e[0]) / (s - i),
                            l = (e[3] - e[1]) / (o - n);
                        return [c, 0, 0, l, e[0] - i * c, e[1] - n * l];
                    }
                    class Annotation {
                        constructor(e) {
                            const t = e.dict;
                            this.setContents(t.get('Contents'));
                            this.setModificationDate(t.get('M'));
                            this.setFlags(t.get('F'));
                            this.setRectangle(t.getArray('Rect'));
                            this.setColor(t.getArray('C'));
                            this.setBorderStyle(t);
                            this.setAppearance(t);
                            this._streams = [];
                            this.appearance && this._streams.push(this.appearance);
                            this.data = {
                                annotationFlags: this.flags,
                                borderStyle: this.borderStyle,
                                color: this.color,
                                contents: this.contents,
                                hasAppearance: !!this.appearance,
                                id: e.id,
                                modificationDate: this.modificationDate,
                                rect: this.rectangle,
                                subtype: e.subtype,
                            };
                            if (e.collectFields) {
                                const r = t.get('Kids');
                                if (Array.isArray(r)) {
                                    const e = [];
                                    for (const t of r) (0, s.isRef)(t) && e.push(t.toString());
                                    0 !== e.length && (this.data.kidIds = e);
                                }
                                this.data.actions = (0, i.collectActions)(e.xref, t, a.AnnotationActionEventType);
                                this.data.fieldName = this._constructFieldName(t);
                                this.data.pageIndex = e.pageIndex;
                            }
                            this._fallbackFontDict = null;
                        }
                        _hasFlag(e, t) {
                            return !!(e & t);
                        }
                        _isViewable(e) {
                            return (
                                !this._hasFlag(e, a.AnnotationFlag.INVISIBLE) &&
                                !this._hasFlag(e, a.AnnotationFlag.NOVIEW)
                            );
                        }
                        _isPrintable(e) {
                            return (
                                this._hasFlag(e, a.AnnotationFlag.PRINT) &&
                                !this._hasFlag(e, a.AnnotationFlag.INVISIBLE)
                            );
                        }
                        mustBeViewed(e) {
                            const t = e && e.get(this.data.id);
                            return t && void 0 !== t.hidden
                                ? !t.hidden
                                : this.viewable && !this._hasFlag(this.flags, a.AnnotationFlag.HIDDEN);
                        }
                        mustBePrinted(e) {
                            const t = e && e.get(this.data.id);
                            return t && void 0 !== t.print ? t.print : this.printable;
                        }
                        get viewable() {
                            return null !== this.data.quadPoints && (0 === this.flags || this._isViewable(this.flags));
                        }
                        get printable() {
                            return null !== this.data.quadPoints && 0 !== this.flags && this._isPrintable(this.flags);
                        }
                        setContents(e) {
                            this.contents = (0, a.stringToPDFString)(e || '');
                        }
                        setModificationDate(e) {
                            this.modificationDate = (0, a.isString)(e) ? e : null;
                        }
                        setFlags(e) {
                            this.flags = Number.isInteger(e) && e > 0 ? e : 0;
                        }
                        hasFlag(e) {
                            return this._hasFlag(this.flags, e);
                        }
                        setRectangle(e) {
                            Array.isArray(e) && 4 === e.length
                                ? (this.rectangle = a.Util.normalizeRect(e))
                                : (this.rectangle = [0, 0, 0, 0]);
                        }
                        setColor(e) {
                            this.color = getRgbColor(e);
                        }
                        setBorderStyle(e) {
                            this.borderStyle = new AnnotationBorderStyle();
                            if ((0, s.isDict)(e))
                                if (e.has('BS')) {
                                    const t = e.get('BS'),
                                        r = t.get('Type');
                                    if (!r || (0, s.isName)(r, 'Border')) {
                                        this.borderStyle.setWidth(t.get('W'), this.rectangle);
                                        this.borderStyle.setStyle(t.get('S'));
                                        this.borderStyle.setDashArray(t.getArray('D'));
                                    }
                                } else if (e.has('Border')) {
                                    const t = e.getArray('Border');
                                    if (Array.isArray(t) && t.length >= 3) {
                                        this.borderStyle.setHorizontalCornerRadius(t[0]);
                                        this.borderStyle.setVerticalCornerRadius(t[1]);
                                        this.borderStyle.setWidth(t[2], this.rectangle);
                                        4 === t.length && this.borderStyle.setDashArray(t[3]);
                                    }
                                } else this.borderStyle.setWidth(0);
                        }
                        setAppearance(e) {
                            this.appearance = null;
                            const t = e.get('AP');
                            if (!(0, s.isDict)(t)) return;
                            const r = t.get('N');
                            if ((0, s.isStream)(r)) {
                                this.appearance = r;
                                return;
                            }
                            if (!(0, s.isDict)(r)) return;
                            const a = e.get('AS');
                            (0, s.isName)(a) && r.has(a.name) && (this.appearance = r.get(a.name));
                        }
                        loadResources(e) {
                            return this.appearance.dict.getAsync('Resources').then((t) => {
                                if (!t) return;
                                return new h.ObjectLoader(t, e, t.xref).load().then(function () {
                                    return t;
                                });
                            });
                        }
                        getOperatorList(e, t, r, i) {
                            if (!this.appearance) return Promise.resolve(new u.OperatorList());
                            const n = this.appearance,
                                s = this.data,
                                o = n.dict,
                                c = this.loadResources([
                                    'ExtGState',
                                    'ColorSpace',
                                    'Pattern',
                                    'Shading',
                                    'XObject',
                                    'Font',
                                ]),
                                l = o.getArray('BBox') || [0, 0, 1, 1],
                                h = o.getArray('Matrix') || [1, 0, 0, 1, 0, 0],
                                d = getTransformMatrix(s.rect, l, h);
                            return c.then((r) => {
                                const i = new u.OperatorList();
                                i.addOp(a.OPS.beginAnnotation, [s.rect, d, h]);
                                return e
                                    .getOperatorList({
                                        stream: n,
                                        task: t,
                                        resources: r,
                                        operatorList: i,
                                        fallbackFontDict: this._fallbackFontDict,
                                    })
                                    .then(() => {
                                        i.addOp(a.OPS.endAnnotation, []);
                                        this.reset();
                                        return i;
                                    });
                            });
                        }
                        async save(e, t, r) {
                            return null;
                        }
                        getFieldObject() {
                            return this.data.kidIds
                                ? {
                                      id: this.data.id,
                                      actions: this.data.actions,
                                      name: this.data.fieldName,
                                      type: '',
                                      kidIds: this.data.kidIds,
                                      page: this.data.pageIndex,
                                  }
                                : null;
                        }
                        reset() {
                            for (const e of this._streams) e.reset();
                        }
                        _constructFieldName(e) {
                            if (!e.has('T') && !e.has('Parent')) {
                                (0, a.warn)('Unknown field name, falling back to empty field name.');
                                return '';
                            }
                            if (!e.has('Parent')) return (0, a.stringToPDFString)(e.get('T'));
                            const t = [];
                            e.has('T') && t.unshift((0, a.stringToPDFString)(e.get('T')));
                            let r = e;
                            const i = new s.RefSet();
                            e.objId && i.put(e.objId);
                            for (; r.has('Parent'); ) {
                                r = r.get('Parent');
                                if (!(r instanceof s.Dict) || (r.objId && i.has(r.objId))) break;
                                r.objId && i.put(r.objId);
                                r.has('T') && t.unshift((0, a.stringToPDFString)(r.get('T')));
                            }
                            return t.join('.');
                        }
                    }
                    t.Annotation = Annotation;
                    class AnnotationBorderStyle {
                        constructor() {
                            this.width = 1;
                            this.style = a.AnnotationBorderStyleType.SOLID;
                            this.dashArray = [3];
                            this.horizontalCornerRadius = 0;
                            this.verticalCornerRadius = 0;
                        }
                        setWidth(e, t = [0, 0, 0, 0]) {
                            if ((0, s.isName)(e)) this.width = 0;
                            else if (Number.isInteger(e)) {
                                if (e > 0) {
                                    const r = (t[2] - t[0]) / 2,
                                        i = (t[3] - t[1]) / 2;
                                    if (r > 0 && i > 0 && (e > r || e > i)) {
                                        (0, a.warn)(`AnnotationBorderStyle.setWidth - ignoring width: ${e}`);
                                        e = 1;
                                    }
                                }
                                this.width = e;
                            }
                        }
                        setStyle(e) {
                            if ((0, s.isName)(e))
                                switch (e.name) {
                                    case 'S':
                                        this.style = a.AnnotationBorderStyleType.SOLID;
                                        break;
                                    case 'D':
                                        this.style = a.AnnotationBorderStyleType.DASHED;
                                        break;
                                    case 'B':
                                        this.style = a.AnnotationBorderStyleType.BEVELED;
                                        break;
                                    case 'I':
                                        this.style = a.AnnotationBorderStyleType.INSET;
                                        break;
                                    case 'U':
                                        this.style = a.AnnotationBorderStyleType.UNDERLINE;
                                }
                        }
                        setDashArray(e) {
                            if (Array.isArray(e) && e.length > 0) {
                                let t = !0,
                                    r = !0;
                                for (const a of e) {
                                    if (!(+a >= 0)) {
                                        t = !1;
                                        break;
                                    }
                                    a > 0 && (r = !1);
                                }
                                t && !r ? (this.dashArray = e) : (this.width = 0);
                            } else e && (this.width = 0);
                        }
                        setHorizontalCornerRadius(e) {
                            Number.isInteger(e) && (this.horizontalCornerRadius = e);
                        }
                        setVerticalCornerRadius(e) {
                            Number.isInteger(e) && (this.verticalCornerRadius = e);
                        }
                    }
                    t.AnnotationBorderStyle = AnnotationBorderStyle;
                    class MarkupAnnotation extends Annotation {
                        constructor(e) {
                            super(e);
                            const t = e.dict;
                            if (t.has('IRT')) {
                                const e = t.getRaw('IRT');
                                this.data.inReplyTo = (0, s.isRef)(e) ? e.toString() : null;
                                const r = t.get('RT');
                                this.data.replyType = (0, s.isName)(r) ? r.name : a.AnnotationReplyType.REPLY;
                            }
                            if (this.data.replyType === a.AnnotationReplyType.GROUP) {
                                const e = t.get('IRT');
                                this.data.title = (0, a.stringToPDFString)(e.get('T') || '');
                                this.setContents(e.get('Contents'));
                                this.data.contents = this.contents;
                                if (e.has('CreationDate')) {
                                    this.setCreationDate(e.get('CreationDate'));
                                    this.data.creationDate = this.creationDate;
                                } else this.data.creationDate = null;
                                if (e.has('M')) {
                                    this.setModificationDate(e.get('M'));
                                    this.data.modificationDate = this.modificationDate;
                                } else this.data.modificationDate = null;
                                this.data.hasPopup = e.has('Popup');
                                if (e.has('C')) {
                                    this.setColor(e.getArray('C'));
                                    this.data.color = this.color;
                                } else this.data.color = null;
                            } else {
                                this.data.title = (0, a.stringToPDFString)(t.get('T') || '');
                                this.setCreationDate(t.get('CreationDate'));
                                this.data.creationDate = this.creationDate;
                                this.data.hasPopup = t.has('Popup');
                                t.has('C') || (this.data.color = null);
                            }
                        }
                        setCreationDate(e) {
                            this.creationDate = (0, a.isString)(e) ? e : null;
                        }
                        _setDefaultAppearance({
                            xref: e,
                            extra: t,
                            strokeColor: r,
                            fillColor: a,
                            blendMode: i,
                            strokeAlpha: n,
                            fillAlpha: o,
                            pointsCallback: c,
                        }) {
                            let l = Number.MAX_VALUE,
                                h = Number.MAX_VALUE,
                                u = Number.MIN_VALUE,
                                f = Number.MIN_VALUE;
                            const g = ['q'];
                            t && g.push(t);
                            r && g.push(`${r[0]} ${r[1]} ${r[2]} RG`);
                            a && g.push(`${a[0]} ${a[1]} ${a[2]} rg`);
                            let p = this.data.quadPoints;
                            p ||
                                (p = [
                                    [
                                        { x: this.rectangle[0], y: this.rectangle[3] },
                                        { x: this.rectangle[2], y: this.rectangle[3] },
                                        { x: this.rectangle[0], y: this.rectangle[1] },
                                        { x: this.rectangle[2], y: this.rectangle[1] },
                                    ],
                                ]);
                            for (const e of p) {
                                const [t, r, a, i] = c(g, e);
                                l = Math.min(l, t);
                                u = Math.max(u, r);
                                h = Math.min(h, a);
                                f = Math.max(f, i);
                            }
                            g.push('Q');
                            const m = new s.Dict(e),
                                b = new s.Dict(e);
                            b.set('Subtype', s.Name.get('Form'));
                            const y = new d.StringStream(g.join(' '));
                            y.dict = b;
                            m.set('Fm0', y);
                            const w = new s.Dict(e);
                            i && w.set('BM', s.Name.get(i));
                            'number' == typeof n && w.set('CA', n);
                            'number' == typeof o && w.set('ca', o);
                            const S = new s.Dict(e);
                            S.set('GS0', w);
                            const x = new s.Dict(e);
                            x.set('ExtGState', S);
                            x.set('XObject', m);
                            const k = new s.Dict(e);
                            k.set('Resources', x);
                            const C = (this.data.rect = [l, h, u, f]);
                            k.set('BBox', C);
                            this.appearance = new d.StringStream('/GS0 gs /Fm0 Do');
                            this.appearance.dict = k;
                            this._streams.push(this.appearance, y);
                        }
                    }
                    t.MarkupAnnotation = MarkupAnnotation;
                    class WidgetAnnotation extends Annotation {
                        constructor(e) {
                            super(e);
                            const t = e.dict,
                                r = this.data;
                            this.ref = e.ref;
                            r.annotationType = a.AnnotationType.WIDGET;
                            void 0 === r.fieldName && (r.fieldName = this._constructFieldName(t));
                            void 0 === r.actions &&
                                (r.actions = (0, i.collectActions)(e.xref, t, a.AnnotationActionEventType));
                            const o = (0, i.getInheritableProperty)({ dict: t, key: 'V', getArray: !0 });
                            r.fieldValue = this._decodeFormValue(o);
                            const c = (0, i.getInheritableProperty)({ dict: t, key: 'DV', getArray: !0 });
                            r.defaultFieldValue = this._decodeFormValue(c);
                            r.alternativeText = (0, a.stringToPDFString)(t.get('TU') || '');
                            const l = (0, i.getInheritableProperty)({ dict: t, key: 'DA' }) || e.acroForm.get('DA');
                            this._defaultAppearance = (0, a.isString)(l) ? l : '';
                            r.defaultAppearanceData = (0, n.parseDefaultAppearance)(this._defaultAppearance);
                            const h = (0, i.getInheritableProperty)({ dict: t, key: 'FT' });
                            r.fieldType = (0, s.isName)(h) ? h.name : null;
                            const u = (0, i.getInheritableProperty)({ dict: t, key: 'DR' }),
                                d = e.acroForm.get('DR'),
                                f = this.appearance && this.appearance.dict.get('Resources');
                            this._fieldResources = {
                                localResources: u,
                                acroFormResources: d,
                                appearanceResources: f,
                                mergedResources: s.Dict.merge({
                                    xref: e.xref,
                                    dictArray: [u, f, d],
                                    mergeSubDicts: !0,
                                }),
                            };
                            r.fieldFlags = (0, i.getInheritableProperty)({ dict: t, key: 'Ff' });
                            (!Number.isInteger(r.fieldFlags) || r.fieldFlags < 0) && (r.fieldFlags = 0);
                            r.readOnly = this.hasFieldFlag(a.AnnotationFieldFlag.READONLY);
                            r.hidden = this._hasFlag(r.annotationFlags, a.AnnotationFlag.HIDDEN);
                        }
                        _decodeFormValue(e) {
                            return Array.isArray(e)
                                ? e.filter((e) => (0, a.isString)(e)).map((e) => (0, a.stringToPDFString)(e))
                                : (0, s.isName)(e)
                                ? (0, a.stringToPDFString)(e.name)
                                : (0, a.isString)(e)
                                ? (0, a.stringToPDFString)(e)
                                : null;
                        }
                        hasFieldFlag(e) {
                            return !!(this.data.fieldFlags & e);
                        }
                        getOperatorList(e, t, r, i) {
                            return !r || this instanceof SignatureWidgetAnnotation
                                ? this._hasText
                                    ? this._getAppearance(e, t, i).then((n) => {
                                          if (this.appearance && null === n) return super.getOperatorList(e, t, r, i);
                                          const s = new u.OperatorList();
                                          if (!this._defaultAppearance || null === n) return s;
                                          const o = [1, 0, 0, 1, 0, 0],
                                              c = [
                                                  0,
                                                  0,
                                                  this.data.rect[2] - this.data.rect[0],
                                                  this.data.rect[3] - this.data.rect[1],
                                              ],
                                              l = getTransformMatrix(this.data.rect, c, o);
                                          s.addOp(a.OPS.beginAnnotation, [this.data.rect, l, o]);
                                          const h = new d.StringStream(n);
                                          return e
                                              .getOperatorList({
                                                  stream: h,
                                                  task: t,
                                                  resources: this._fieldResources.mergedResources,
                                                  operatorList: s,
                                              })
                                              .then(function () {
                                                  s.addOp(a.OPS.endAnnotation, []);
                                                  return s;
                                              });
                                      })
                                    : super.getOperatorList(e, t, r, i)
                                : Promise.resolve(new u.OperatorList());
                        }
                        async save(e, t, r) {
                            if (!r) return null;
                            const i = r.get(this.data.id),
                                n = i && i.value;
                            if (n === this.data.fieldValue || void 0 === n) return null;
                            let o = await this._getAppearance(e, t, r);
                            if (null === o) return null;
                            const { xref: c } = e,
                                l = c.fetchIfRef(this.ref);
                            if (!(0, s.isDict)(l)) return null;
                            const h = [
                                    0,
                                    0,
                                    this.data.rect[2] - this.data.rect[0],
                                    this.data.rect[3] - this.data.rect[1],
                                ],
                                u = { path: (0, a.stringToPDFString)(l.get('T') || ''), value: n },
                                d = c.getNewRef(),
                                g = new s.Dict(c);
                            g.set('N', d);
                            const p = c.encrypt;
                            let m = null,
                                b = null;
                            if (p) {
                                m = p.createCipherTransform(this.ref.num, this.ref.gen);
                                b = p.createCipherTransform(d.num, d.gen);
                                o = b.encryptString(o);
                            }
                            l.set('V', (0, a.isAscii)(n) ? n : (0, a.stringToUTF16BEString)(n));
                            l.set('AP', g);
                            l.set('M', `D:${(0, a.getModificationDate)()}`);
                            const y = new s.Dict(c);
                            y.set('Length', o.length);
                            y.set('Subtype', s.Name.get('Form'));
                            y.set('Resources', this._getSaveFieldResources(c));
                            y.set('BBox', h);
                            const w = [`${this.ref.num} ${this.ref.gen} obj\n`];
                            (0, f.writeDict)(l, w, m);
                            w.push('\nendobj\n');
                            const S = [`${d.num} ${d.gen} obj\n`];
                            (0, f.writeDict)(y, S, b);
                            S.push(' stream\n', o, '\nendstream\nendobj\n');
                            return [
                                { ref: this.ref, data: w.join(''), xfa: u },
                                { ref: d, data: S.join(''), xfa: null },
                            ];
                        }
                        async _getAppearance(e, t, r) {
                            const i = this.hasFieldFlag(a.AnnotationFieldFlag.PASSWORD);
                            if (!r || i) return null;
                            const s = r.get(this.data.id);
                            let o = s && s.value;
                            if (void 0 === o) return null;
                            o = o.trim();
                            if ('' === o) return '';
                            let c = -1;
                            this.data.multiLine && (c = o.split(/\r\n|\r|\n/).length);
                            const l = this.data.rect[3] - this.data.rect[1],
                                h = this.data.rect[2] - this.data.rect[0];
                            this._defaultAppearance ||
                                (this.data.defaultAppearanceData = (0, n.parseDefaultAppearance)(
                                    (this._defaultAppearance = '/Helvetica 0 Tf 0 g')
                                ));
                            const [u, d] = this._computeFontSize(l, c),
                                f = await this._getFontData(e, t);
                            let g = f.descent;
                            isNaN(g) && (g = 0);
                            const p = 2 + Math.abs(g) * d,
                                m = this.data.textAlignment;
                            if (this.data.multiLine) return this._getMultilineAppearance(u, o, f, d, h, l, m, 2, p);
                            const b = f.encodeString(o).join('');
                            if (this.data.comb) return this._getCombAppearance(u, f, b, h, 2, p);
                            if (0 === m || m > 2)
                                return (
                                    '/Tx BMC q BT ' + u + ` 1 0 0 1 2 ${p} Tm (${(0, a.escapeString)(b)}) Tj ET Q EMC`
                                );
                            return (
                                '/Tx BMC q BT ' +
                                u +
                                ` 1 0 0 1 0 0 Tm ${this._renderText(b, f, d, h, m, 2, p)} ET Q EMC`
                            );
                        }
                        async _getFontData(e, t) {
                            const r = new u.OperatorList(),
                                a = {
                                    font: null,
                                    clone() {
                                        return this;
                                    },
                                },
                                { fontName: i, fontSize: n } = this.data.defaultAppearanceData;
                            await e.handleSetFont(
                                this._fieldResources.mergedResources,
                                [i && s.Name.get(i), n],
                                null,
                                r,
                                t,
                                a,
                                null
                            );
                            return a.font;
                        }
                        _computeFontSize(e, t) {
                            let { fontSize: r } = this.data.defaultAppearanceData;
                            if (!r) {
                                const roundWithOneDigit = (e) => Math.round(10 * e) / 10,
                                    a = 0.8;
                                if (-1 === t) r = roundWithOneDigit(a * e);
                                else {
                                    r = 10;
                                    let i = r / a,
                                        n = Math.round(e / i);
                                    n = Math.max(n, t);
                                    i = e / n;
                                    r = roundWithOneDigit(a * i);
                                }
                                const { fontName: i, fontColor: s } = this.data.defaultAppearanceData;
                                this._defaultAppearance = (0, n.createDefaultAppearance)({
                                    fontSize: r,
                                    fontName: i,
                                    fontColor: s,
                                });
                            }
                            return [this._defaultAppearance, r];
                        }
                        _renderText(e, t, r, i, n, s, o) {
                            const c = t.charsToGlyphs(e),
                                l = r / 1e3;
                            let h,
                                u = 0;
                            for (const e of c) u += e.width * l;
                            h = 1 === n ? (i - u) / 2 : 2 === n ? i - u - s : s;
                            h = h.toFixed(2);
                            return `${h} ${(o = o.toFixed(2))} Td (${(0, a.escapeString)(e)}) Tj`;
                        }
                        _getSaveFieldResources(e) {
                            const {
                                    localResources: t,
                                    appearanceResources: r,
                                    acroFormResources: a,
                                } = this._fieldResources,
                                i = this.data.defaultAppearanceData && this.data.defaultAppearanceData.fontName;
                            if (!i) return t || s.Dict.empty;
                            for (const e of [t, r])
                                if (e instanceof s.Dict) {
                                    const t = e.get('Font');
                                    if (t instanceof s.Dict && t.has(i)) return e;
                                }
                            if (a instanceof s.Dict) {
                                const r = a.get('Font');
                                if (r instanceof s.Dict && r.has(i)) {
                                    const a = new s.Dict(e);
                                    a.set(i, r.getRaw(i));
                                    const n = new s.Dict(e);
                                    n.set('Font', a);
                                    return s.Dict.merge({ xref: e, dictArray: [n, t], mergeSubDicts: !0 });
                                }
                            }
                            return t || s.Dict.empty;
                        }
                        getFieldObject() {
                            return null;
                        }
                    }
                    class TextWidgetAnnotation extends WidgetAnnotation {
                        constructor(e) {
                            super(e);
                            this._hasText = !0;
                            const t = e.dict;
                            (0, a.isString)(this.data.fieldValue) || (this.data.fieldValue = '');
                            let r = (0, i.getInheritableProperty)({ dict: t, key: 'Q' });
                            (!Number.isInteger(r) || r < 0 || r > 2) && (r = null);
                            this.data.textAlignment = r;
                            let n = (0, i.getInheritableProperty)({ dict: t, key: 'MaxLen' });
                            (!Number.isInteger(n) || n < 0) && (n = null);
                            this.data.maxLen = n;
                            this.data.multiLine = this.hasFieldFlag(a.AnnotationFieldFlag.MULTILINE);
                            this.data.comb =
                                this.hasFieldFlag(a.AnnotationFieldFlag.COMB) &&
                                !this.hasFieldFlag(a.AnnotationFieldFlag.MULTILINE) &&
                                !this.hasFieldFlag(a.AnnotationFieldFlag.PASSWORD) &&
                                !this.hasFieldFlag(a.AnnotationFieldFlag.FILESELECT) &&
                                null !== this.data.maxLen;
                        }
                        _getCombAppearance(e, t, r, i, n, s) {
                            const o = (i / this.data.maxLen).toFixed(2),
                                c = [],
                                l = t.getCharPositions(r);
                            for (const [e, t] of l) c.push(`(${(0, a.escapeString)(r.substring(e, t))}) Tj`);
                            return '/Tx BMC q BT ' + e + ` 1 0 0 1 ${n} ${s} Tm ${c.join(` ${o} 0 Td `)} ET Q EMC`;
                        }
                        _getMultilineAppearance(e, t, r, a, i, n, s, o, c) {
                            const l = t.split(/\r\n|\r|\n/),
                                h = [],
                                u = i - 2 * o;
                            for (const e of l) {
                                const t = this._splitLine(e, r, a, u);
                                for (const e of t) {
                                    const t = 0 === h.length ? o : 0;
                                    h.push(this._renderText(e, r, a, i, s, t, -a));
                                }
                            }
                            return '/Tx BMC q BT ' + e + ` 1 0 0 1 0 ${n} Tm ${h.join('\n')} ET Q EMC`;
                        }
                        _splitLine(e, t, r, a) {
                            e = t.encodeString(e).join('');
                            const i = t.charsToGlyphs(e);
                            if (i.length <= 1) return [e];
                            const n = t.getCharPositions(e),
                                s = r / 1e3,
                                o = [];
                            let c = -1,
                                l = -1,
                                h = -1,
                                u = 0,
                                d = 0;
                            for (let t = 0, r = i.length; t < r; t++) {
                                const [r, f] = n[t],
                                    g = i[t],
                                    p = g.width * s;
                                if (' ' === g.unicode)
                                    if (d + p > a) {
                                        o.push(e.substring(u, r));
                                        u = r;
                                        d = p;
                                        c = -1;
                                        h = -1;
                                    } else {
                                        d += p;
                                        c = r;
                                        l = f;
                                        h = t;
                                    }
                                else if (d + p > a)
                                    if (-1 !== c) {
                                        o.push(e.substring(u, l));
                                        u = l;
                                        t = h + 1;
                                        c = -1;
                                        d = 0;
                                    } else {
                                        o.push(e.substring(u, r));
                                        u = r;
                                        d = p;
                                    }
                                else d += p;
                            }
                            u < e.length && o.push(e.substring(u, e.length));
                            return o;
                        }
                        getFieldObject() {
                            return {
                                id: this.data.id,
                                value: this.data.fieldValue,
                                defaultValue: this.data.defaultFieldValue,
                                multiline: this.data.multiLine,
                                password: this.hasFieldFlag(a.AnnotationFieldFlag.PASSWORD),
                                charLimit: this.data.maxLen,
                                comb: this.data.comb,
                                editable: !this.data.readOnly,
                                hidden: this.data.hidden,
                                name: this.data.fieldName,
                                rect: this.data.rect,
                                actions: this.data.actions,
                                page: this.data.pageIndex,
                                type: 'text',
                            };
                        }
                    }
                    class ButtonWidgetAnnotation extends WidgetAnnotation {
                        constructor(e) {
                            super(e);
                            this.checkedAppearance = null;
                            this.uncheckedAppearance = null;
                            this.data.checkBox =
                                !this.hasFieldFlag(a.AnnotationFieldFlag.RADIO) &&
                                !this.hasFieldFlag(a.AnnotationFieldFlag.PUSHBUTTON);
                            this.data.radioButton =
                                this.hasFieldFlag(a.AnnotationFieldFlag.RADIO) &&
                                !this.hasFieldFlag(a.AnnotationFieldFlag.PUSHBUTTON);
                            this.data.pushButton = this.hasFieldFlag(a.AnnotationFieldFlag.PUSHBUTTON);
                            this.data.isTooltipOnly = !1;
                            this.data.checkBox
                                ? this._processCheckBox(e)
                                : this.data.radioButton
                                ? this._processRadioButton(e)
                                : this.data.pushButton
                                ? this._processPushButton(e)
                                : (0, a.warn)('Invalid field flags for button widget annotation');
                        }
                        getOperatorList(e, t, r, a) {
                            if (this.data.pushButton) return super.getOperatorList(e, t, !1, a);
                            if (a) {
                                const i = a.get(this.data.id),
                                    n = i && i.value;
                                if (void 0 === n) return super.getOperatorList(e, t, r, a);
                                let s;
                                s = n ? this.checkedAppearance : this.uncheckedAppearance;
                                if (s) {
                                    const i = this.appearance;
                                    this.appearance = s;
                                    const n = super.getOperatorList(e, t, r, a);
                                    this.appearance = i;
                                    return n;
                                }
                                return Promise.resolve(new u.OperatorList());
                            }
                            return super.getOperatorList(e, t, r, a);
                        }
                        async save(e, t, r) {
                            return this.data.checkBox
                                ? this._saveCheckbox(e, t, r)
                                : this.data.radioButton
                                ? this._saveRadioButton(e, t, r)
                                : null;
                        }
                        async _saveCheckbox(e, t, r) {
                            if (!r) return null;
                            const i = r.get(this.data.id),
                                n = i && i.value;
                            if (void 0 === n) return null;
                            if ((this.data.fieldValue && 'Off' !== this.data.fieldValue) === n) return null;
                            const o = e.xref.fetchIfRef(this.ref);
                            if (!(0, s.isDict)(o)) return null;
                            const c = {
                                    path: (0, a.stringToPDFString)(o.get('T') || ''),
                                    value: n ? this.data.exportValue : '',
                                },
                                l = s.Name.get(n ? this.data.exportValue : 'Off');
                            o.set('V', l);
                            o.set('AS', l);
                            o.set('M', `D:${(0, a.getModificationDate)()}`);
                            const h = e.xref.encrypt;
                            let u = null;
                            h && (u = h.createCipherTransform(this.ref.num, this.ref.gen));
                            const d = [`${this.ref.num} ${this.ref.gen} obj\n`];
                            (0, f.writeDict)(o, d, u);
                            d.push('\nendobj\n');
                            return [{ ref: this.ref, data: d.join(''), xfa: c }];
                        }
                        async _saveRadioButton(e, t, r) {
                            if (!r) return null;
                            const i = r.get(this.data.id),
                                n = i && i.value;
                            if (void 0 === n) return null;
                            if ((this.data.fieldValue === this.data.buttonValue) === n) return null;
                            const o = e.xref.fetchIfRef(this.ref);
                            if (!(0, s.isDict)(o)) return null;
                            const c = {
                                    path: (0, a.stringToPDFString)(o.get('T') || ''),
                                    value: n ? this.data.buttonValue : '',
                                },
                                l = s.Name.get(n ? this.data.buttonValue : 'Off');
                            let h = null;
                            const u = e.xref.encrypt;
                            if (n)
                                if ((0, s.isRef)(this.parent)) {
                                    const t = e.xref.fetch(this.parent);
                                    let r = null;
                                    u && (r = u.createCipherTransform(this.parent.num, this.parent.gen));
                                    t.set('V', l);
                                    h = [`${this.parent.num} ${this.parent.gen} obj\n`];
                                    (0, f.writeDict)(t, h, r);
                                    h.push('\nendobj\n');
                                } else (0, s.isDict)(this.parent) && this.parent.set('V', l);
                            o.set('AS', l);
                            o.set('M', `D:${(0, a.getModificationDate)()}`);
                            let d = null;
                            u && (d = u.createCipherTransform(this.ref.num, this.ref.gen));
                            const g = [`${this.ref.num} ${this.ref.gen} obj\n`];
                            (0, f.writeDict)(o, g, d);
                            g.push('\nendobj\n');
                            const p = [{ ref: this.ref, data: g.join(''), xfa: c }];
                            null !== h && p.push({ ref: this.parent, data: h.join(''), xfa: null });
                            return p;
                        }
                        _processCheckBox(e) {
                            const t = e.dict.get('AP');
                            if (!(0, s.isDict)(t)) return;
                            const r = t.get('N');
                            if (!(0, s.isDict)(r)) return;
                            const a = r.getKeys();
                            a.includes('Off') || a.push('Off');
                            if (2 === a.length) {
                                this.data.exportValue = 'Off' === a[0] ? a[1] : a[0];
                                this.checkedAppearance = r.get(this.data.exportValue);
                                this.uncheckedAppearance = r.get('Off') || null;
                                this._streams.push(this.checkedAppearance);
                                this.uncheckedAppearance && this._streams.push(this.uncheckedAppearance);
                                this._fallbackFontDict = this.fallbackFontDict;
                            }
                        }
                        _processRadioButton(e) {
                            this.data.fieldValue = this.data.buttonValue = null;
                            const t = e.dict.get('Parent');
                            if ((0, s.isDict)(t)) {
                                this.parent = e.dict.getRaw('Parent');
                                const r = t.get('V');
                                (0, s.isName)(r) && (this.data.fieldValue = this._decodeFormValue(r));
                            }
                            const r = e.dict.get('AP');
                            if (!(0, s.isDict)(r)) return;
                            const a = r.get('N');
                            if ((0, s.isDict)(a)) {
                                for (const e of a.getKeys())
                                    if ('Off' !== e) {
                                        this.data.buttonValue = this._decodeFormValue(e);
                                        break;
                                    }
                                this.checkedAppearance = a.get(this.data.buttonValue);
                                this.uncheckedAppearance = a.get('Off') || null;
                                this._streams.push(this.checkedAppearance);
                                this.uncheckedAppearance && this._streams.push(this.uncheckedAppearance);
                                this._fallbackFontDict = this.fallbackFontDict;
                            }
                        }
                        _processPushButton(e) {
                            if (e.dict.has('A') || e.dict.has('AA') || this.data.alternativeText) {
                                this.data.isTooltipOnly = !e.dict.has('A') && !e.dict.has('AA');
                                o.Catalog.parseDestDictionary({
                                    destDict: e.dict,
                                    resultObj: this.data,
                                    docBaseUrl: e.pdfManager.docBaseUrl,
                                });
                            } else (0, a.warn)('Push buttons without action dictionaries are not supported');
                        }
                        getFieldObject() {
                            let e,
                                t = 'button';
                            if (this.data.checkBox) {
                                t = 'checkbox';
                                e = this.data.exportValue;
                            } else if (this.data.radioButton) {
                                t = 'radiobutton';
                                e = this.data.buttonValue;
                            }
                            return {
                                id: this.data.id,
                                value: this.data.fieldValue || 'Off',
                                defaultValue: this.data.defaultFieldValue,
                                exportValues: e,
                                editable: !this.data.readOnly,
                                name: this.data.fieldName,
                                rect: this.data.rect,
                                hidden: this.data.hidden,
                                actions: this.data.actions,
                                page: this.data.pageIndex,
                                type: t,
                            };
                        }
                        get fallbackFontDict() {
                            const e = new s.Dict();
                            e.set('BaseFont', s.Name.get('ZapfDingbats'));
                            e.set('Type', s.Name.get('FallbackType'));
                            e.set('Subtype', s.Name.get('FallbackType'));
                            e.set('Encoding', s.Name.get('ZapfDingbatsEncoding'));
                            return (0, a.shadow)(this, 'fallbackFontDict', e);
                        }
                    }
                    class ChoiceWidgetAnnotation extends WidgetAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.options = [];
                            const t = (0, i.getInheritableProperty)({ dict: e.dict, key: 'Opt' });
                            if (Array.isArray(t)) {
                                const r = e.xref;
                                for (let e = 0, a = t.length; e < a; e++) {
                                    const a = r.fetchIfRef(t[e]),
                                        i = Array.isArray(a);
                                    this.data.options[e] = {
                                        exportValue: this._decodeFormValue(i ? r.fetchIfRef(a[0]) : a),
                                        displayValue: this._decodeFormValue(i ? r.fetchIfRef(a[1]) : a),
                                    };
                                }
                            }
                            (0, a.isString)(this.data.fieldValue)
                                ? (this.data.fieldValue = [this.data.fieldValue])
                                : this.data.fieldValue || (this.data.fieldValue = []);
                            this.data.combo = this.hasFieldFlag(a.AnnotationFieldFlag.COMBO);
                            this.data.multiSelect = this.hasFieldFlag(a.AnnotationFieldFlag.MULTISELECT);
                            this._hasText = !0;
                        }
                        getFieldObject() {
                            const e = this.data.combo ? 'combobox' : 'listbox',
                                t = this.data.fieldValue.length > 0 ? this.data.fieldValue[0] : null;
                            return {
                                id: this.data.id,
                                value: t,
                                defaultValue: this.data.defaultFieldValue,
                                editable: !this.data.readOnly,
                                name: this.data.fieldName,
                                rect: this.data.rect,
                                numItems: this.data.fieldValue.length,
                                multipleSelection: this.data.multiSelect,
                                hidden: this.data.hidden,
                                actions: this.data.actions,
                                items: this.data.options,
                                page: this.data.pageIndex,
                                type: e,
                            };
                        }
                    }
                    class SignatureWidgetAnnotation extends WidgetAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.fieldValue = null;
                        }
                        getFieldObject() {
                            return { id: this.data.id, value: null, page: this.data.pageIndex, type: 'signature' };
                        }
                    }
                    class TextAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            const t = e.dict;
                            this.data.annotationType = a.AnnotationType.TEXT;
                            if (this.data.hasAppearance) this.data.name = 'NoIcon';
                            else {
                                this.data.rect[1] = this.data.rect[3] - 22;
                                this.data.rect[2] = this.data.rect[0] + 22;
                                this.data.name = t.has('Name') ? t.get('Name').name : 'Note';
                            }
                            if (t.has('State')) {
                                this.data.state = t.get('State') || null;
                                this.data.stateModel = t.get('StateModel') || null;
                            } else {
                                this.data.state = null;
                                this.data.stateModel = null;
                            }
                        }
                    }
                    class LinkAnnotation extends Annotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.LINK;
                            const t = getQuadPoints(e.dict, this.rectangle);
                            t && (this.data.quadPoints = t);
                            o.Catalog.parseDestDictionary({
                                destDict: e.dict,
                                resultObj: this.data,
                                docBaseUrl: e.pdfManager.docBaseUrl,
                            });
                        }
                    }
                    class PopupAnnotation extends Annotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.POPUP;
                            let t = e.dict.get('Parent');
                            if (!t) {
                                (0, a.warn)('Popup annotation has a missing or invalid parent annotation.');
                                return;
                            }
                            const r = t.get('Subtype');
                            this.data.parentType = (0, s.isName)(r) ? r.name : null;
                            const i = e.dict.getRaw('Parent');
                            this.data.parentId = (0, s.isRef)(i) ? i.toString() : null;
                            const n = t.getArray('Rect');
                            Array.isArray(n) && 4 === n.length
                                ? (this.data.parentRect = a.Util.normalizeRect(n))
                                : (this.data.parentRect = [0, 0, 0, 0]);
                            const o = t.get('RT');
                            (0, s.isName)(o, a.AnnotationReplyType.GROUP) && (t = t.get('IRT'));
                            if (t.has('M')) {
                                this.setModificationDate(t.get('M'));
                                this.data.modificationDate = this.modificationDate;
                            } else this.data.modificationDate = null;
                            if (t.has('C')) {
                                this.setColor(t.getArray('C'));
                                this.data.color = this.color;
                            } else this.data.color = null;
                            if (!this.viewable) {
                                const e = t.get('F');
                                this._isViewable(e) && this.setFlags(e);
                            }
                            this.data.title = (0, a.stringToPDFString)(t.get('T') || '');
                            this.data.contents = (0, a.stringToPDFString)(t.get('Contents') || '');
                        }
                    }
                    class FreeTextAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.FREETEXT;
                        }
                    }
                    class LineAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.LINE;
                            const t = e.dict.getArray('L');
                            this.data.lineCoordinates = a.Util.normalizeRect(t);
                            if (!this.appearance) {
                                const r = this.color ? Array.from(this.color).map((e) => e / 255) : [0, 0, 0],
                                    i = e.dict.get('CA');
                                let n = null,
                                    s = e.dict.getArray('IC');
                                if (s) {
                                    s = getRgbColor(s);
                                    n = s ? Array.from(s).map((e) => e / 255) : null;
                                }
                                const o = n ? i : null,
                                    c = this.borderStyle.width || 1,
                                    l = 2 * c,
                                    h = [
                                        this.data.lineCoordinates[0] - l,
                                        this.data.lineCoordinates[1] - l,
                                        this.data.lineCoordinates[2] + l,
                                        this.data.lineCoordinates[3] + l,
                                    ];
                                a.Util.intersect(this.rectangle, h) || (this.rectangle = h);
                                this._setDefaultAppearance({
                                    xref: e.xref,
                                    extra: `${c} w`,
                                    strokeColor: r,
                                    fillColor: n,
                                    strokeAlpha: i,
                                    fillAlpha: o,
                                    pointsCallback: (e, r) => {
                                        e.push(`${t[0]} ${t[1]} m`, `${t[2]} ${t[3]} l`, 'S');
                                        return [r[0].x - c, r[1].x + c, r[3].y - c, r[1].y + c];
                                    },
                                });
                            }
                        }
                    }
                    class SquareAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.SQUARE;
                            if (!this.appearance) {
                                const t = this.color ? Array.from(this.color).map((e) => e / 255) : [0, 0, 0],
                                    r = e.dict.get('CA');
                                let a = null,
                                    i = e.dict.getArray('IC');
                                if (i) {
                                    i = getRgbColor(i);
                                    a = i ? Array.from(i).map((e) => e / 255) : null;
                                }
                                const n = a ? r : null;
                                this._setDefaultAppearance({
                                    xref: e.xref,
                                    extra: `${this.borderStyle.width} w`,
                                    strokeColor: t,
                                    fillColor: a,
                                    strokeAlpha: r,
                                    fillAlpha: n,
                                    pointsCallback: (e, t) => {
                                        const r = t[2].x + this.borderStyle.width / 2,
                                            i = t[2].y + this.borderStyle.width / 2,
                                            n = t[3].x - t[2].x - this.borderStyle.width,
                                            s = t[1].y - t[3].y - this.borderStyle.width;
                                        e.push(`${r} ${i} ${n} ${s} re`);
                                        a ? e.push('B') : e.push('S');
                                        return [t[0].x, t[1].x, t[3].y, t[1].y];
                                    },
                                });
                            }
                        }
                    }
                    class CircleAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.CIRCLE;
                            if (!this.appearance) {
                                const t = this.color ? Array.from(this.color).map((e) => e / 255) : [0, 0, 0],
                                    r = e.dict.get('CA');
                                let a = null,
                                    i = e.dict.getArray('IC');
                                if (i) {
                                    i = getRgbColor(i);
                                    a = i ? Array.from(i).map((e) => e / 255) : null;
                                }
                                const n = a ? r : null,
                                    s = (4 / 3) * Math.tan(Math.PI / 8);
                                this._setDefaultAppearance({
                                    xref: e.xref,
                                    extra: `${this.borderStyle.width} w`,
                                    strokeColor: t,
                                    fillColor: a,
                                    strokeAlpha: r,
                                    fillAlpha: n,
                                    pointsCallback: (e, t) => {
                                        const r = t[0].x + this.borderStyle.width / 2,
                                            i = t[0].y - this.borderStyle.width / 2,
                                            n = t[3].x - this.borderStyle.width / 2,
                                            o = t[3].y + this.borderStyle.width / 2,
                                            c = r + (n - r) / 2,
                                            l = i + (o - i) / 2,
                                            h = ((n - r) / 2) * s,
                                            u = ((o - i) / 2) * s;
                                        e.push(
                                            `${c} ${o} m`,
                                            `${c + h} ${o} ${n} ${l + u} ${n} ${l} c`,
                                            `${n} ${l - u} ${c + h} ${i} ${c} ${i} c`,
                                            `${c - h} ${i} ${r} ${l - u} ${r} ${l} c`,
                                            `${r} ${l + u} ${c - h} ${o} ${c} ${o} c`,
                                            'h'
                                        );
                                        a ? e.push('B') : e.push('S');
                                        return [t[0].x, t[1].x, t[3].y, t[1].y];
                                    },
                                });
                            }
                        }
                    }
                    class PolylineAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.POLYLINE;
                            this.data.vertices = [];
                            const t = e.dict.getArray('Vertices');
                            if (Array.isArray(t)) {
                                for (let e = 0, r = t.length; e < r; e += 2)
                                    this.data.vertices.push({ x: t[e], y: t[e + 1] });
                                if (!this.appearance) {
                                    const t = this.color ? Array.from(this.color).map((e) => e / 255) : [0, 0, 0],
                                        r = e.dict.get('CA'),
                                        i = this.borderStyle.width || 1,
                                        n = 2 * i,
                                        s = [1 / 0, 1 / 0, -1 / 0, -1 / 0];
                                    for (const e of this.data.vertices) {
                                        s[0] = Math.min(s[0], e.x - n);
                                        s[1] = Math.min(s[1], e.y - n);
                                        s[2] = Math.max(s[2], e.x + n);
                                        s[3] = Math.max(s[3], e.y + n);
                                    }
                                    a.Util.intersect(this.rectangle, s) || (this.rectangle = s);
                                    this._setDefaultAppearance({
                                        xref: e.xref,
                                        extra: `${i} w`,
                                        strokeColor: t,
                                        strokeAlpha: r,
                                        pointsCallback: (e, t) => {
                                            const r = this.data.vertices;
                                            for (let t = 0, a = r.length; t < a; t++)
                                                e.push(`${r[t].x} ${r[t].y} ${0 === t ? 'm' : 'l'}`);
                                            e.push('S');
                                            return [t[0].x, t[1].x, t[3].y, t[1].y];
                                        },
                                    });
                                }
                            }
                        }
                    }
                    class PolygonAnnotation extends PolylineAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.POLYGON;
                        }
                    }
                    class CaretAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.CARET;
                        }
                    }
                    class InkAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.INK;
                            this.data.inkLists = [];
                            const t = e.dict.getArray('InkList');
                            if (!Array.isArray(t)) return;
                            const r = e.xref;
                            for (let e = 0, a = t.length; e < a; ++e) {
                                this.data.inkLists.push([]);
                                for (let a = 0, i = t[e].length; a < i; a += 2)
                                    this.data.inkLists[e].push({
                                        x: r.fetchIfRef(t[e][a]),
                                        y: r.fetchIfRef(t[e][a + 1]),
                                    });
                            }
                            if (!this.appearance) {
                                const t = this.color ? Array.from(this.color).map((e) => e / 255) : [0, 0, 0],
                                    r = e.dict.get('CA'),
                                    i = this.borderStyle.width || 1,
                                    n = 2 * i,
                                    s = [1 / 0, 1 / 0, -1 / 0, -1 / 0];
                                for (const e of this.data.inkLists)
                                    for (const t of e) {
                                        s[0] = Math.min(s[0], t.x - n);
                                        s[1] = Math.min(s[1], t.y - n);
                                        s[2] = Math.max(s[2], t.x + n);
                                        s[3] = Math.max(s[3], t.y + n);
                                    }
                                a.Util.intersect(this.rectangle, s) || (this.rectangle = s);
                                this._setDefaultAppearance({
                                    xref: e.xref,
                                    extra: `${i} w`,
                                    strokeColor: t,
                                    strokeAlpha: r,
                                    pointsCallback: (e, t) => {
                                        for (const t of this.data.inkLists) {
                                            for (let r = 0, a = t.length; r < a; r++)
                                                e.push(`${t[r].x} ${t[r].y} ${0 === r ? 'm' : 'l'}`);
                                            e.push('S');
                                        }
                                        return [t[0].x, t[1].x, t[3].y, t[1].y];
                                    },
                                });
                            }
                        }
                    }
                    class HighlightAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.HIGHLIGHT;
                            if ((this.data.quadPoints = getQuadPoints(e.dict, null))) {
                                const t = this.appearance && this.appearance.dict.get('Resources');
                                if (!this.appearance || !t || !t.has('ExtGState')) {
                                    this.appearance &&
                                        (0, a.warn)('HighlightAnnotation - ignoring built-in appearance stream.');
                                    const t = this.color ? Array.from(this.color).map((e) => e / 255) : [1, 1, 0],
                                        r = e.dict.get('CA');
                                    this._setDefaultAppearance({
                                        xref: e.xref,
                                        fillColor: t,
                                        blendMode: 'Multiply',
                                        fillAlpha: r,
                                        pointsCallback: (e, t) => {
                                            e.push(
                                                `${t[0].x} ${t[0].y} m`,
                                                `${t[1].x} ${t[1].y} l`,
                                                `${t[3].x} ${t[3].y} l`,
                                                `${t[2].x} ${t[2].y} l`,
                                                'f'
                                            );
                                            return [t[0].x, t[1].x, t[3].y, t[1].y];
                                        },
                                    });
                                }
                            } else this.data.hasPopup = !1;
                        }
                    }
                    class UnderlineAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.UNDERLINE;
                            if ((this.data.quadPoints = getQuadPoints(e.dict, null))) {
                                if (!this.appearance) {
                                    const t = this.color ? Array.from(this.color).map((e) => e / 255) : [0, 0, 0],
                                        r = e.dict.get('CA');
                                    this._setDefaultAppearance({
                                        xref: e.xref,
                                        extra: '[] 0 d 1 w',
                                        strokeColor: t,
                                        strokeAlpha: r,
                                        pointsCallback: (e, t) => {
                                            e.push(`${t[2].x} ${t[2].y} m`, `${t[3].x} ${t[3].y} l`, 'S');
                                            return [t[0].x, t[1].x, t[3].y, t[1].y];
                                        },
                                    });
                                }
                            } else this.data.hasPopup = !1;
                        }
                    }
                    class SquigglyAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.SQUIGGLY;
                            if ((this.data.quadPoints = getQuadPoints(e.dict, null))) {
                                if (!this.appearance) {
                                    const t = this.color ? Array.from(this.color).map((e) => e / 255) : [0, 0, 0],
                                        r = e.dict.get('CA');
                                    this._setDefaultAppearance({
                                        xref: e.xref,
                                        extra: '[] 0 d 1 w',
                                        strokeColor: t,
                                        strokeAlpha: r,
                                        pointsCallback: (e, t) => {
                                            const r = (t[0].y - t[2].y) / 6;
                                            let a = r,
                                                i = t[2].x;
                                            const n = t[2].y,
                                                s = t[3].x;
                                            e.push(`${i} ${n + a} m`);
                                            do {
                                                i += 2;
                                                a = 0 === a ? r : 0;
                                                e.push(`${i} ${n + a} l`);
                                            } while (i < s);
                                            e.push('S');
                                            return [t[2].x, s, n - 2 * r, n + 2 * r];
                                        },
                                    });
                                }
                            } else this.data.hasPopup = !1;
                        }
                    }
                    class StrikeOutAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.STRIKEOUT;
                            if ((this.data.quadPoints = getQuadPoints(e.dict, null))) {
                                if (!this.appearance) {
                                    const t = this.color ? Array.from(this.color).map((e) => e / 255) : [0, 0, 0],
                                        r = e.dict.get('CA');
                                    this._setDefaultAppearance({
                                        xref: e.xref,
                                        extra: '[] 0 d 1 w',
                                        strokeColor: t,
                                        strokeAlpha: r,
                                        pointsCallback: (e, t) => {
                                            e.push(
                                                (t[0].x + t[2].x) / 2 + ' ' + (t[0].y + t[2].y) / 2 + ' m',
                                                (t[1].x + t[3].x) / 2 + ' ' + (t[1].y + t[3].y) / 2 + ' l',
                                                'S'
                                            );
                                            return [t[0].x, t[1].x, t[3].y, t[1].y];
                                        },
                                    });
                                }
                            } else this.data.hasPopup = !1;
                        }
                    }
                    class StampAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            this.data.annotationType = a.AnnotationType.STAMP;
                        }
                    }
                    class FileAttachmentAnnotation extends MarkupAnnotation {
                        constructor(e) {
                            super(e);
                            const t = new l.FileSpec(e.dict.get('FS'), e.xref);
                            this.data.annotationType = a.AnnotationType.FILEATTACHMENT;
                            this.data.file = t.serializable;
                        }
                    }
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.createDefaultAppearance = function createDefaultAppearance({
                        fontSize: e,
                        fontName: t,
                        fontColor: r,
                    }) {
                        let a;
                        a = r.every((e) => 0 === e)
                            ? '0 g'
                            : Array.from(r)
                                  .map((e) => (e / 255).toFixed(2))
                                  .join(' ') + ' rg';
                        return `/${(0, n.escapePDFName)(t)} ${e} Tf ${a}`;
                    };
                    t.parseDefaultAppearance = function parseDefaultAppearance(e) {
                        return new DefaultAppearanceEvaluator(e).parse();
                    };
                    var a = r(2),
                        i = r(14),
                        n = r(9),
                        s = r(15),
                        o = r(5),
                        c = r(10);
                    class DefaultAppearanceEvaluator extends s.EvaluatorPreprocessor {
                        constructor(e) {
                            super(new c.StringStream(e));
                        }
                        parse() {
                            const e = { fn: 0, args: [] },
                                t = { fontSize: 0, fontName: '', fontColor: new Uint8ClampedArray(3) };
                            try {
                                for (;;) {
                                    e.args.length = 0;
                                    if (!this.read(e)) break;
                                    if (0 !== this.savedStatesDepth) continue;
                                    const { fn: r, args: n } = e;
                                    switch (0 | r) {
                                        case a.OPS.setFont:
                                            const [e, r] = n;
                                            e instanceof o.Name && (t.fontName = e.name);
                                            'number' == typeof r && r > 0 && (t.fontSize = r);
                                            break;
                                        case a.OPS.setFillRGBColor:
                                            i.ColorSpace.singletons.rgb.getRgbItem(n, 0, t.fontColor, 0);
                                            break;
                                        case a.OPS.setFillGray:
                                            i.ColorSpace.singletons.gray.getRgbItem(n, 0, t.fontColor, 0);
                                            break;
                                        case a.OPS.setFillColorSpace:
                                            i.ColorSpace.singletons.cmyk.getRgbItem(n, 0, t.fontColor, 0);
                                    }
                                }
                            } catch (e) {
                                (0, a.warn)(`parseDefaultAppearance - ignoring errors: "${e}".`);
                            }
                            return t;
                        }
                    }
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.ColorSpace = void 0;
                    var a = r(2),
                        i = r(5),
                        n = r(9);
                    class ColorSpace {
                        constructor(e, t) {
                            this.constructor === ColorSpace && (0, a.unreachable)('Cannot initialize ColorSpace.');
                            this.name = e;
                            this.numComps = t;
                        }
                        getRgb(e, t) {
                            const r = new Uint8ClampedArray(3);
                            this.getRgbItem(e, t, r, 0);
                            return r;
                        }
                        getRgbItem(e, t, r, i) {
                            (0, a.unreachable)('Should not call ColorSpace.getRgbItem');
                        }
                        getRgbBuffer(e, t, r, i, n, s, o) {
                            (0, a.unreachable)('Should not call ColorSpace.getRgbBuffer');
                        }
                        getOutputLength(e, t) {
                            (0, a.unreachable)('Should not call ColorSpace.getOutputLength');
                        }
                        isPassthrough(e) {
                            return !1;
                        }
                        isDefaultDecode(e, t) {
                            return ColorSpace.isDefaultDecode(e, this.numComps);
                        }
                        fillRgb(e, t, r, a, i, n, s, o, c) {
                            const l = t * r;
                            let h = null;
                            const u = 1 << s,
                                d = r !== i || t !== a;
                            if (this.isPassthrough(s)) h = o;
                            else if (
                                1 === this.numComps &&
                                l > u &&
                                'DeviceGray' !== this.name &&
                                'DeviceRGB' !== this.name
                            ) {
                                const t = s <= 8 ? new Uint8Array(u) : new Uint16Array(u);
                                for (let e = 0; e < u; e++) t[e] = e;
                                const r = new Uint8ClampedArray(3 * u);
                                this.getRgbBuffer(t, 0, u, r, 0, s, 0);
                                if (d) {
                                    h = new Uint8Array(3 * l);
                                    let e = 0;
                                    for (let t = 0; t < l; ++t) {
                                        const a = 3 * o[t];
                                        h[e++] = r[a];
                                        h[e++] = r[a + 1];
                                        h[e++] = r[a + 2];
                                    }
                                } else {
                                    let t = 0;
                                    for (let a = 0; a < l; ++a) {
                                        const i = 3 * o[a];
                                        e[t++] = r[i];
                                        e[t++] = r[i + 1];
                                        e[t++] = r[i + 2];
                                        t += c;
                                    }
                                }
                            } else if (d) {
                                h = new Uint8ClampedArray(3 * l);
                                this.getRgbBuffer(o, 0, l, h, 0, s, 0);
                            } else this.getRgbBuffer(o, 0, a * n, e, 0, s, c);
                            if (h)
                                if (d)
                                    !(function resizeRgbImage(e, t, r, a, i, n, s) {
                                        s = 1 !== s ? 0 : s;
                                        const o = r / i,
                                            c = a / n;
                                        let l,
                                            h = 0;
                                        const u = new Uint16Array(i),
                                            d = 3 * r;
                                        for (let e = 0; e < i; e++) u[e] = 3 * Math.floor(e * o);
                                        for (let r = 0; r < n; r++) {
                                            const a = Math.floor(r * c) * d;
                                            for (let r = 0; r < i; r++) {
                                                l = a + u[r];
                                                t[h++] = e[l++];
                                                t[h++] = e[l++];
                                                t[h++] = e[l++];
                                                h += s;
                                            }
                                        }
                                    })(h, e, t, r, a, i, c);
                                else {
                                    let t = 0,
                                        r = 0;
                                    for (let i = 0, s = a * n; i < s; i++) {
                                        e[t++] = h[r++];
                                        e[t++] = h[r++];
                                        e[t++] = h[r++];
                                        t += c;
                                    }
                                }
                        }
                        get usesZeroToOneRange() {
                            return (0, a.shadow)(this, 'usesZeroToOneRange', !0);
                        }
                        static _cache(e, t, r, a) {
                            if (!r) throw new Error('ColorSpace._cache - expected "localColorSpaceCache" argument.');
                            if (!a) throw new Error('ColorSpace._cache - expected "parsedColorSpace" argument.');
                            let n, s;
                            if (e instanceof i.Ref) {
                                s = e;
                                e = t.fetch(e);
                            }
                            e instanceof i.Name && (n = e.name);
                            (n || s) && r.set(n, s, a);
                        }
                        static getCached(e, t, r) {
                            if (!r) throw new Error('ColorSpace.getCached - expected "localColorSpaceCache" argument.');
                            if (e instanceof i.Ref) {
                                const a = r.getByRef(e);
                                if (a) return a;
                                try {
                                    e = t.fetch(e);
                                } catch (e) {
                                    if (e instanceof n.MissingDataException) throw e;
                                }
                            }
                            if (e instanceof i.Name) {
                                const t = r.getByName(e.name);
                                if (t) return t;
                            }
                            return null;
                        }
                        static async parseAsync({
                            cs: e,
                            xref: t,
                            resources: r = null,
                            pdfFunctionFactory: a,
                            localColorSpaceCache: i,
                        }) {
                            const n = this._parse(e, t, r, a);
                            this._cache(e, t, i, n);
                            return n;
                        }
                        static parse({
                            cs: e,
                            xref: t,
                            resources: r = null,
                            pdfFunctionFactory: a,
                            localColorSpaceCache: i,
                        }) {
                            const n = this.getCached(e, t, i);
                            if (n) return n;
                            const s = this._parse(e, t, r, a);
                            this._cache(e, t, i, s);
                            return s;
                        }
                        static _parse(e, t, r = null, n) {
                            e = t.fetchIfRef(e);
                            if ((0, i.isName)(e))
                                switch (e.name) {
                                    case 'DeviceGray':
                                    case 'G':
                                        return this.singletons.gray;
                                    case 'DeviceRGB':
                                    case 'RGB':
                                        return this.singletons.rgb;
                                    case 'DeviceCMYK':
                                    case 'CMYK':
                                        return this.singletons.cmyk;
                                    case 'Pattern':
                                        return new PatternCS(null);
                                    default:
                                        if ((0, i.isDict)(r)) {
                                            const a = r.get('ColorSpace');
                                            if ((0, i.isDict)(a)) {
                                                const s = a.get(e.name);
                                                if (s) {
                                                    if ((0, i.isName)(s)) return this._parse(s, t, r, n);
                                                    e = s;
                                                    break;
                                                }
                                            }
                                        }
                                        throw new a.FormatError(`Unrecognized ColorSpace: ${e.name}`);
                                }
                            if (Array.isArray(e)) {
                                const i = t.fetchIfRef(e[0]).name;
                                let s, h, u, d, f, g;
                                switch (i) {
                                    case 'DeviceGray':
                                    case 'G':
                                        return this.singletons.gray;
                                    case 'DeviceRGB':
                                    case 'RGB':
                                        return this.singletons.rgb;
                                    case 'DeviceCMYK':
                                    case 'CMYK':
                                        return this.singletons.cmyk;
                                    case 'CalGray':
                                        s = t.fetchIfRef(e[1]);
                                        d = s.getArray('WhitePoint');
                                        f = s.getArray('BlackPoint');
                                        g = s.get('Gamma');
                                        return new o(d, f, g);
                                    case 'CalRGB':
                                        s = t.fetchIfRef(e[1]);
                                        d = s.getArray('WhitePoint');
                                        f = s.getArray('BlackPoint');
                                        g = s.getArray('Gamma');
                                        const p = s.getArray('Matrix');
                                        return new c(d, f, g, p);
                                    case 'ICCBased':
                                        const m = t.fetchIfRef(e[1]).dict;
                                        h = m.get('N');
                                        const b = m.get('Alternate');
                                        if (b) {
                                            const e = this._parse(b, t, r, n);
                                            if (e.numComps === h) return e;
                                            (0, a.warn)('ICCBased color space: Ignoring incorrect /Alternate entry.');
                                        }
                                        if (1 === h) return this.singletons.gray;
                                        if (3 === h) return this.singletons.rgb;
                                        if (4 === h) return this.singletons.cmyk;
                                        break;
                                    case 'Pattern':
                                        u = e[1] || null;
                                        u && (u = this._parse(u, t, r, n));
                                        return new PatternCS(u);
                                    case 'Indexed':
                                    case 'I':
                                        u = this._parse(e[1], t, r, n);
                                        const y = t.fetchIfRef(e[2]) + 1,
                                            w = t.fetchIfRef(e[3]);
                                        return new IndexedCS(u, y, w);
                                    case 'Separation':
                                    case 'DeviceN':
                                        const S = t.fetchIfRef(e[1]);
                                        h = Array.isArray(S) ? S.length : 1;
                                        u = this._parse(e[2], t, r, n);
                                        const x = n.create(e[3]);
                                        return new AlternateCS(h, u, x);
                                    case 'Lab':
                                        s = t.fetchIfRef(e[1]);
                                        d = s.getArray('WhitePoint');
                                        f = s.getArray('BlackPoint');
                                        const k = s.getArray('Range');
                                        return new l(d, f, k);
                                    default:
                                        throw new a.FormatError(`Unimplemented ColorSpace object: ${i}`);
                                }
                            }
                            throw new a.FormatError(`Unrecognized ColorSpace object: ${e}`);
                        }
                        static isDefaultDecode(e, t) {
                            if (!Array.isArray(e)) return !0;
                            if (2 * t !== e.length) {
                                (0, a.warn)('The decode map is not the correct length');
                                return !0;
                            }
                            for (let t = 0, r = e.length; t < r; t += 2) if (0 !== e[t] || 1 !== e[t + 1]) return !1;
                            return !0;
                        }
                        static get singletons() {
                            return (0, a.shadow)(this, 'singletons', {
                                get gray() {
                                    return (0, a.shadow)(this, 'gray', new DeviceGrayCS());
                                },
                                get rgb() {
                                    return (0, a.shadow)(this, 'rgb', new DeviceRgbCS());
                                },
                                get cmyk() {
                                    return (0, a.shadow)(this, 'cmyk', new s());
                                },
                            });
                        }
                    }
                    t.ColorSpace = ColorSpace;
                    class AlternateCS extends ColorSpace {
                        constructor(e, t, r) {
                            super('Alternate', e);
                            this.base = t;
                            this.tintFn = r;
                            this.tmpBuf = new Float32Array(t.numComps);
                        }
                        getRgbItem(e, t, r, a) {
                            const i = this.tmpBuf;
                            this.tintFn(e, t, i, 0);
                            this.base.getRgbItem(i, 0, r, a);
                        }
                        getRgbBuffer(e, t, r, a, i, n, s) {
                            const o = this.tintFn,
                                c = this.base,
                                l = 1 / ((1 << n) - 1),
                                h = c.numComps,
                                u = c.usesZeroToOneRange,
                                d = (c.isPassthrough(8) || !u) && 0 === s;
                            let f = d ? i : 0;
                            const g = d ? a : new Uint8ClampedArray(h * r),
                                p = this.numComps,
                                m = new Float32Array(p),
                                b = new Float32Array(h);
                            let y, w;
                            for (y = 0; y < r; y++) {
                                for (w = 0; w < p; w++) m[w] = e[t++] * l;
                                o(m, 0, b, 0);
                                if (u) for (w = 0; w < h; w++) g[f++] = 255 * b[w];
                                else {
                                    c.getRgbItem(b, 0, g, f);
                                    f += h;
                                }
                            }
                            d || c.getRgbBuffer(g, 0, r, a, i, 8, s);
                        }
                        getOutputLength(e, t) {
                            return this.base.getOutputLength((e * this.base.numComps) / this.numComps, t);
                        }
                    }
                    class PatternCS extends ColorSpace {
                        constructor(e) {
                            super('Pattern', null);
                            this.base = e;
                        }
                        isDefaultDecode(e, t) {
                            (0, a.unreachable)('Should not call PatternCS.isDefaultDecode');
                        }
                    }
                    class IndexedCS extends ColorSpace {
                        constructor(e, t, r) {
                            super('Indexed', 1);
                            this.base = e;
                            this.highVal = t;
                            const n = e.numComps * t;
                            this.lookup = new Uint8Array(n);
                            if ((0, i.isStream)(r)) {
                                const e = r.getBytes(n);
                                this.lookup.set(e);
                            } else {
                                if ('string' != typeof r)
                                    throw new a.FormatError(`IndexedCS - unrecognized lookup table: ${r}`);
                                for (let e = 0; e < n; ++e) this.lookup[e] = 255 & r.charCodeAt(e);
                            }
                        }
                        getRgbItem(e, t, r, a) {
                            const i = this.base.numComps,
                                n = e[t] * i;
                            this.base.getRgbBuffer(this.lookup, n, 1, r, a, 8, 0);
                        }
                        getRgbBuffer(e, t, r, a, i, n, s) {
                            const o = this.base,
                                c = o.numComps,
                                l = o.getOutputLength(c, s),
                                h = this.lookup;
                            for (let n = 0; n < r; ++n) {
                                const r = e[t++] * c;
                                o.getRgbBuffer(h, r, 1, a, i, 8, s);
                                i += l;
                            }
                        }
                        getOutputLength(e, t) {
                            return this.base.getOutputLength(e * this.base.numComps, t);
                        }
                        isDefaultDecode(e, t) {
                            if (!Array.isArray(e)) return !0;
                            if (2 !== e.length) {
                                (0, a.warn)('Decode map length is not correct');
                                return !0;
                            }
                            if (!Number.isInteger(t) || t < 1) {
                                (0, a.warn)('Bits per component is not correct');
                                return !0;
                            }
                            return 0 === e[0] && e[1] === (1 << t) - 1;
                        }
                    }
                    class DeviceGrayCS extends ColorSpace {
                        constructor() {
                            super('DeviceGray', 1);
                        }
                        getRgbItem(e, t, r, a) {
                            const i = 255 * e[t];
                            r[a] = r[a + 1] = r[a + 2] = i;
                        }
                        getRgbBuffer(e, t, r, a, i, n, s) {
                            const o = 255 / ((1 << n) - 1);
                            let c = t,
                                l = i;
                            for (let t = 0; t < r; ++t) {
                                const t = o * e[c++];
                                a[l++] = t;
                                a[l++] = t;
                                a[l++] = t;
                                l += s;
                            }
                        }
                        getOutputLength(e, t) {
                            return e * (3 + t);
                        }
                    }
                    class DeviceRgbCS extends ColorSpace {
                        constructor() {
                            super('DeviceRGB', 3);
                        }
                        getRgbItem(e, t, r, a) {
                            r[a] = 255 * e[t];
                            r[a + 1] = 255 * e[t + 1];
                            r[a + 2] = 255 * e[t + 2];
                        }
                        getRgbBuffer(e, t, r, a, i, n, s) {
                            if (8 === n && 0 === s) {
                                a.set(e.subarray(t, t + 3 * r), i);
                                return;
                            }
                            const o = 255 / ((1 << n) - 1);
                            let c = t,
                                l = i;
                            for (let t = 0; t < r; ++t) {
                                a[l++] = o * e[c++];
                                a[l++] = o * e[c++];
                                a[l++] = o * e[c++];
                                l += s;
                            }
                        }
                        getOutputLength(e, t) {
                            return ((e * (3 + t)) / 3) | 0;
                        }
                        isPassthrough(e) {
                            return 8 === e;
                        }
                    }
                    const s = (function DeviceCmykCSClosure() {
                            function convertToRgb(e, t, r, a, i) {
                                const n = e[t] * r,
                                    s = e[t + 1] * r,
                                    o = e[t + 2] * r,
                                    c = e[t + 3] * r;
                                a[i] =
                                    255 +
                                    n *
                                        (-4.387332384609988 * n +
                                            54.48615194189176 * s +
                                            18.82290502165302 * o +
                                            212.25662451639585 * c -
                                            285.2331026137004) +
                                    s *
                                        (1.7149763477362134 * s -
                                            5.6096736904047315 * o +
                                            -17.873870861415444 * c -
                                            5.497006427196366) +
                                    o * (-2.5217340131683033 * o - 21.248923337353073 * c + 17.5119270841813) +
                                    c * (-21.86122147463605 * c - 189.48180835922747);
                                a[i + 1] =
                                    255 +
                                    n *
                                        (8.841041422036149 * n +
                                            60.118027045597366 * s +
                                            6.871425592049007 * o +
                                            31.159100130055922 * c -
                                            79.2970844816548) +
                                    s *
                                        (-15.310361306967817 * s +
                                            17.575251261109482 * o +
                                            131.35250912493976 * c -
                                            190.9453302588951) +
                                    o * (4.444339102852739 * o + 9.8632861493405 * c - 24.86741582555878) +
                                    c * (-20.737325471181034 * c - 187.80453709719578);
                                a[i + 2] =
                                    255 +
                                    n *
                                        (0.8842522430003296 * n +
                                            8.078677503112928 * s +
                                            30.89978309703729 * o -
                                            0.23883238689178934 * c -
                                            14.183576799673286) +
                                    s *
                                        (10.49593273432072 * s +
                                            63.02378494754052 * o +
                                            50.606957656360734 * c -
                                            112.23884253719248) +
                                    o * (0.03296041114873217 * o + 115.60384449646641 * c - 193.58209356861505) +
                                    c * (-22.33816807309886 * c - 180.12613974708367);
                            }
                            return class DeviceCmykCS extends ColorSpace {
                                constructor() {
                                    super('DeviceCMYK', 4);
                                }
                                getRgbItem(e, t, r, a) {
                                    convertToRgb(e, t, 1, r, a);
                                }
                                getRgbBuffer(e, t, r, a, i, n, s) {
                                    const o = 1 / ((1 << n) - 1);
                                    for (let n = 0; n < r; n++) {
                                        convertToRgb(e, t, o, a, i);
                                        t += 4;
                                        i += 3 + s;
                                    }
                                }
                                getOutputLength(e, t) {
                                    return ((e / 4) * (3 + t)) | 0;
                                }
                            };
                        })(),
                        o = (function CalGrayCSClosure() {
                            function convertToRgb(e, t, r, a, i, n) {
                                const s = (t[r] * n) ** e.G,
                                    o = e.YW * s,
                                    c = Math.max(295.8 * o ** 0.3333333333333333 - 40.8, 0);
                                a[i] = c;
                                a[i + 1] = c;
                                a[i + 2] = c;
                            }
                            return class CalGrayCS extends ColorSpace {
                                constructor(e, t, r) {
                                    super('CalGray', 1);
                                    if (!e)
                                        throw new a.FormatError(
                                            'WhitePoint missing - required for color space CalGray'
                                        );
                                    t = t || [0, 0, 0];
                                    r = r || 1;
                                    this.XW = e[0];
                                    this.YW = e[1];
                                    this.ZW = e[2];
                                    this.XB = t[0];
                                    this.YB = t[1];
                                    this.ZB = t[2];
                                    this.G = r;
                                    if (this.XW < 0 || this.ZW < 0 || 1 !== this.YW)
                                        throw new a.FormatError(
                                            `Invalid WhitePoint components for ${this.name}, no fallback available`
                                        );
                                    if (this.XB < 0 || this.YB < 0 || this.ZB < 0) {
                                        (0, a.info)(`Invalid BlackPoint for ${this.name}, falling back to default.`);
                                        this.XB = this.YB = this.ZB = 0;
                                    }
                                    (0 === this.XB && 0 === this.YB && 0 === this.ZB) ||
                                        (0, a.warn)(
                                            `${this.name}, BlackPoint: XB: ${this.XB}, YB: ${this.YB}, ZB: ${this.ZB}, only default values are supported.`
                                        );
                                    if (this.G < 1) {
                                        (0, a.info)(
                                            `Invalid Gamma: ${this.G} for ${this.name}, falling back to default.`
                                        );
                                        this.G = 1;
                                    }
                                }
                                getRgbItem(e, t, r, a) {
                                    convertToRgb(this, e, t, r, a, 1);
                                }
                                getRgbBuffer(e, t, r, a, i, n, s) {
                                    const o = 1 / ((1 << n) - 1);
                                    for (let n = 0; n < r; ++n) {
                                        convertToRgb(this, e, t, a, i, o);
                                        t += 1;
                                        i += 3 + s;
                                    }
                                }
                                getOutputLength(e, t) {
                                    return e * (3 + t);
                                }
                            };
                        })(),
                        c = (function CalRGBCSClosure() {
                            const e = new Float32Array([
                                    0.8951, 0.2664, -0.1614, -0.7502, 1.7135, 0.0367, 0.0389, -0.0685, 1.0296,
                                ]),
                                t = new Float32Array([
                                    0.9869929, -0.1470543, 0.1599627, 0.4323053, 0.5183603, 0.0492912, -0.0085287,
                                    0.0400428, 0.9684867,
                                ]),
                                r = new Float32Array([
                                    3.2404542, -1.5371385, -0.4985314, -0.969266, 1.8760108, 0.041556, 0.0556434,
                                    -0.2040259, 1.0572252,
                                ]),
                                i = new Float32Array([1, 1, 1]),
                                n = new Float32Array(3),
                                s = new Float32Array(3),
                                o = new Float32Array(3);
                            function matrixProduct(e, t, r) {
                                r[0] = e[0] * t[0] + e[1] * t[1] + e[2] * t[2];
                                r[1] = e[3] * t[0] + e[4] * t[1] + e[5] * t[2];
                                r[2] = e[6] * t[0] + e[7] * t[1] + e[8] * t[2];
                            }
                            function sRGBTransferFunction(e) {
                                return e <= 0.0031308
                                    ? adjustToRange(0, 1, 12.92 * e)
                                    : e >= 0.99554525
                                    ? 1
                                    : adjustToRange(0, 1, 1.055 * e ** (1 / 2.4) - 0.055);
                            }
                            function adjustToRange(e, t, r) {
                                return Math.max(e, Math.min(t, r));
                            }
                            function decodeL(e) {
                                return e < 0 ? -decodeL(-e) : e > 8 ? ((e + 16) / 116) ** 3 : 0.0011070564598794539 * e;
                            }
                            function convertToRgb(a, c, l, h, u, d) {
                                const f = adjustToRange(0, 1, c[l] * d),
                                    g = adjustToRange(0, 1, c[l + 1] * d),
                                    p = adjustToRange(0, 1, c[l + 2] * d),
                                    m = 1 === f ? 1 : f ** a.GR,
                                    b = 1 === g ? 1 : g ** a.GG,
                                    y = 1 === p ? 1 : p ** a.GB,
                                    w = a.MXA * m + a.MXB * b + a.MXC * y,
                                    S = a.MYA * m + a.MYB * b + a.MYC * y,
                                    x = a.MZA * m + a.MZB * b + a.MZC * y,
                                    k = s;
                                k[0] = w;
                                k[1] = S;
                                k[2] = x;
                                const C = o;
                                !(function normalizeWhitePointToFlat(r, a, i) {
                                    if (1 === r[0] && 1 === r[2]) {
                                        i[0] = a[0];
                                        i[1] = a[1];
                                        i[2] = a[2];
                                        return;
                                    }
                                    const s = i;
                                    matrixProduct(e, a, s);
                                    const o = n;
                                    !(function convertToFlat(e, t, r) {
                                        r[0] = (1 * t[0]) / e[0];
                                        r[1] = (1 * t[1]) / e[1];
                                        r[2] = (1 * t[2]) / e[2];
                                    })(r, s, o);
                                    matrixProduct(t, o, i);
                                })(a.whitePoint, k, C);
                                const v = s;
                                !(function compensateBlackPoint(e, t, r) {
                                    if (0 === e[0] && 0 === e[1] && 0 === e[2]) {
                                        r[0] = t[0];
                                        r[1] = t[1];
                                        r[2] = t[2];
                                        return;
                                    }
                                    const a = decodeL(0),
                                        i = (1 - a) / (1 - decodeL(e[0])),
                                        n = 1 - i,
                                        s = (1 - a) / (1 - decodeL(e[1])),
                                        o = 1 - s,
                                        c = (1 - a) / (1 - decodeL(e[2])),
                                        l = 1 - c;
                                    r[0] = t[0] * i + n;
                                    r[1] = t[1] * s + o;
                                    r[2] = t[2] * c + l;
                                })(a.blackPoint, C, v);
                                const O = o;
                                !(function normalizeWhitePointToD65(r, a, i) {
                                    const s = i;
                                    matrixProduct(e, a, s);
                                    const o = n;
                                    !(function convertToD65(e, t, r) {
                                        r[0] = (0.95047 * t[0]) / e[0];
                                        r[1] = (1 * t[1]) / e[1];
                                        r[2] = (1.08883 * t[2]) / e[2];
                                    })(r, s, o);
                                    matrixProduct(t, o, i);
                                })(i, v, O);
                                const F = s;
                                matrixProduct(r, O, F);
                                h[u] = 255 * sRGBTransferFunction(F[0]);
                                h[u + 1] = 255 * sRGBTransferFunction(F[1]);
                                h[u + 2] = 255 * sRGBTransferFunction(F[2]);
                            }
                            return class CalRGBCS extends ColorSpace {
                                constructor(e, t, r, i) {
                                    super('CalRGB', 3);
                                    if (!e)
                                        throw new a.FormatError('WhitePoint missing - required for color space CalRGB');
                                    t = t || new Float32Array(3);
                                    r = r || new Float32Array([1, 1, 1]);
                                    i = i || new Float32Array([1, 0, 0, 0, 1, 0, 0, 0, 1]);
                                    const n = e[0],
                                        s = e[1],
                                        o = e[2];
                                    this.whitePoint = e;
                                    const c = t[0],
                                        l = t[1],
                                        h = t[2];
                                    this.blackPoint = t;
                                    this.GR = r[0];
                                    this.GG = r[1];
                                    this.GB = r[2];
                                    this.MXA = i[0];
                                    this.MYA = i[1];
                                    this.MZA = i[2];
                                    this.MXB = i[3];
                                    this.MYB = i[4];
                                    this.MZB = i[5];
                                    this.MXC = i[6];
                                    this.MYC = i[7];
                                    this.MZC = i[8];
                                    if (n < 0 || o < 0 || 1 !== s)
                                        throw new a.FormatError(
                                            `Invalid WhitePoint components for ${this.name}, no fallback available`
                                        );
                                    if (c < 0 || l < 0 || h < 0) {
                                        (0, a.info)(
                                            `Invalid BlackPoint for ${this.name} [${c}, ${l}, ${h}], falling back to default.`
                                        );
                                        this.blackPoint = new Float32Array(3);
                                    }
                                    if (this.GR < 0 || this.GG < 0 || this.GB < 0) {
                                        (0, a.info)(
                                            `Invalid Gamma [${this.GR}, ${this.GG}, ${this.GB}] for ${this.name}, falling back to default.`
                                        );
                                        this.GR = this.GG = this.GB = 1;
                                    }
                                }
                                getRgbItem(e, t, r, a) {
                                    convertToRgb(this, e, t, r, a, 1);
                                }
                                getRgbBuffer(e, t, r, a, i, n, s) {
                                    const o = 1 / ((1 << n) - 1);
                                    for (let n = 0; n < r; ++n) {
                                        convertToRgb(this, e, t, a, i, o);
                                        t += 3;
                                        i += 3 + s;
                                    }
                                }
                                getOutputLength(e, t) {
                                    return ((e * (3 + t)) / 3) | 0;
                                }
                            };
                        })(),
                        l = (function LabCSClosure() {
                            function fn_g(e) {
                                let t;
                                t = e >= 6 / 29 ? e ** 3 : (108 / 841) * (e - 4 / 29);
                                return t;
                            }
                            function decode(e, t, r, a) {
                                return r + (e * (a - r)) / t;
                            }
                            function convertToRgb(e, t, r, a, i, n) {
                                let s = t[r],
                                    o = t[r + 1],
                                    c = t[r + 2];
                                if (!1 !== a) {
                                    s = decode(s, a, 0, 100);
                                    o = decode(o, a, e.amin, e.amax);
                                    c = decode(c, a, e.bmin, e.bmax);
                                }
                                o > e.amax ? (o = e.amax) : o < e.amin && (o = e.amin);
                                c > e.bmax ? (c = e.bmax) : c < e.bmin && (c = e.bmin);
                                const l = (s + 16) / 116,
                                    h = l + o / 500,
                                    u = l - c / 200,
                                    d = e.XW * fn_g(h),
                                    f = e.YW * fn_g(l),
                                    g = e.ZW * fn_g(u);
                                let p, m, b;
                                if (e.ZW < 1) {
                                    p = 3.1339 * d + -1.617 * f + -0.4906 * g;
                                    m = -0.9785 * d + 1.916 * f + 0.0333 * g;
                                    b = 0.072 * d + -0.229 * f + 1.4057 * g;
                                } else {
                                    p = 3.2406 * d + -1.5372 * f + -0.4986 * g;
                                    m = -0.9689 * d + 1.8758 * f + 0.0415 * g;
                                    b = 0.0557 * d + -0.204 * f + 1.057 * g;
                                }
                                i[n] = 255 * Math.sqrt(p);
                                i[n + 1] = 255 * Math.sqrt(m);
                                i[n + 2] = 255 * Math.sqrt(b);
                            }
                            return class LabCS extends ColorSpace {
                                constructor(e, t, r) {
                                    super('Lab', 3);
                                    if (!e)
                                        throw new a.FormatError('WhitePoint missing - required for color space Lab');
                                    t = t || [0, 0, 0];
                                    r = r || [-100, 100, -100, 100];
                                    this.XW = e[0];
                                    this.YW = e[1];
                                    this.ZW = e[2];
                                    this.amin = r[0];
                                    this.amax = r[1];
                                    this.bmin = r[2];
                                    this.bmax = r[3];
                                    this.XB = t[0];
                                    this.YB = t[1];
                                    this.ZB = t[2];
                                    if (this.XW < 0 || this.ZW < 0 || 1 !== this.YW)
                                        throw new a.FormatError('Invalid WhitePoint components, no fallback available');
                                    if (this.XB < 0 || this.YB < 0 || this.ZB < 0) {
                                        (0, a.info)('Invalid BlackPoint, falling back to default');
                                        this.XB = this.YB = this.ZB = 0;
                                    }
                                    if (this.amin > this.amax || this.bmin > this.bmax) {
                                        (0, a.info)('Invalid Range, falling back to defaults');
                                        this.amin = -100;
                                        this.amax = 100;
                                        this.bmin = -100;
                                        this.bmax = 100;
                                    }
                                }
                                getRgbItem(e, t, r, a) {
                                    convertToRgb(this, e, t, !1, r, a);
                                }
                                getRgbBuffer(e, t, r, a, i, n, s) {
                                    const o = (1 << n) - 1;
                                    for (let n = 0; n < r; n++) {
                                        convertToRgb(this, e, t, o, a, i);
                                        t += 3;
                                        i += 3 + s;
                                    }
                                }
                                getOutputLength(e, t) {
                                    return ((e * (3 + t)) / 3) | 0;
                                }
                                isDefaultDecode(e, t) {
                                    return !0;
                                }
                                get usesZeroToOneRange() {
                                    return (0, a.shadow)(this, 'usesZeroToOneRange', !1);
                                }
                            };
                        })();
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.PartialEvaluator = t.EvaluatorPreprocessor = void 0;
                    var a = r(2),
                        i = r(16),
                        n = r(5),
                        s = r(34),
                        o = r(38),
                        c = r(37),
                        l = r(40),
                        h = r(41),
                        u = r(48),
                        d = r(42),
                        f = r(49),
                        g = r(17),
                        p = r(51),
                        m = r(52),
                        b = r(14),
                        y = r(19),
                        w = r(39),
                        S = r(9),
                        x = r(53),
                        k = r(54),
                        C = r(10),
                        v = r(55),
                        O = r(56);
                    const F = Object.freeze({
                            maxImageSize: -1,
                            disableFontFace: !1,
                            ignoreErrors: !1,
                            isEvalSupported: !0,
                            fontExtraProperties: !1,
                        }),
                        T = 1,
                        E = 2,
                        M = Promise.resolve();
                    function normalizeBlendMode(e, t = !1) {
                        if (Array.isArray(e)) {
                            for (let t = 0, r = e.length; t < r; t++) {
                                const r = normalizeBlendMode(e[t], !0);
                                if (r) return r;
                            }
                            (0, a.warn)(`Unsupported blend mode Array: ${e}`);
                            return 'source-over';
                        }
                        if (!(0, n.isName)(e)) return t ? null : 'source-over';
                        switch (e.name) {
                            case 'Normal':
                            case 'Compatible':
                                return 'source-over';
                            case 'Multiply':
                                return 'multiply';
                            case 'Screen':
                                return 'screen';
                            case 'Overlay':
                                return 'overlay';
                            case 'Darken':
                                return 'darken';
                            case 'Lighten':
                                return 'lighten';
                            case 'ColorDodge':
                                return 'color-dodge';
                            case 'ColorBurn':
                                return 'color-burn';
                            case 'HardLight':
                                return 'hard-light';
                            case 'SoftLight':
                                return 'soft-light';
                            case 'Difference':
                                return 'difference';
                            case 'Exclusion':
                                return 'exclusion';
                            case 'Hue':
                                return 'hue';
                            case 'Saturation':
                                return 'saturation';
                            case 'Color':
                                return 'color';
                            case 'Luminosity':
                                return 'luminosity';
                        }
                        if (t) return null;
                        (0, a.warn)(`Unsupported blend mode: ${e.name}`);
                        return 'source-over';
                    }
                    class TimeSlotManager {
                        static get TIME_SLOT_DURATION_MS() {
                            return (0, a.shadow)(this, 'TIME_SLOT_DURATION_MS', 20);
                        }
                        static get CHECK_TIME_EVERY() {
                            return (0, a.shadow)(this, 'CHECK_TIME_EVERY', 100);
                        }
                        constructor() {
                            this.reset();
                        }
                        check() {
                            if (++this.checked < TimeSlotManager.CHECK_TIME_EVERY) return !1;
                            this.checked = 0;
                            return this.endTime <= Date.now();
                        }
                        reset() {
                            this.endTime = Date.now() + TimeSlotManager.TIME_SLOT_DURATION_MS;
                            this.checked = 0;
                        }
                    }
                    class PartialEvaluator {
                        constructor({
                            xref: e,
                            handler: t,
                            pageIndex: r,
                            idFactory: a,
                            fontCache: i,
                            builtInCMapCache: n,
                            globalImageCache: s,
                            options: o = null,
                        }) {
                            this.xref = e;
                            this.handler = t;
                            this.pageIndex = r;
                            this.idFactory = a;
                            this.fontCache = i;
                            this.builtInCMapCache = n;
                            this.globalImageCache = s;
                            this.options = o || F;
                            this.parsingType3Font = !1;
                            this._fetchBuiltInCMapBound = this.fetchBuiltInCMap.bind(this);
                        }
                        get _pdfFunctionFactory() {
                            const e = new f.PDFFunctionFactory({
                                xref: this.xref,
                                isEvalSupported: this.options.isEvalSupported,
                            });
                            return (0, a.shadow)(this, '_pdfFunctionFactory', e);
                        }
                        clone(e = F) {
                            const t = Object.create(this);
                            t.options = e;
                            return t;
                        }
                        hasBlendModes(e, t) {
                            if (!(e instanceof n.Dict)) return !1;
                            if (e.objId && t.has(e.objId)) return !1;
                            const r = new n.RefSet(t);
                            e.objId && r.put(e.objId);
                            const i = [e],
                                s = this.xref;
                            for (; i.length; ) {
                                const e = i.shift(),
                                    t = e.get('ExtGState');
                                if (t instanceof n.Dict)
                                    for (let e of t.getRawValues()) {
                                        if (e instanceof n.Ref) {
                                            if (r.has(e)) continue;
                                            try {
                                                e = s.fetch(e);
                                            } catch (t) {
                                                r.put(e);
                                                (0, a.info)(`hasBlendModes - ignoring ExtGState: "${t}".`);
                                                continue;
                                            }
                                        }
                                        if (!(e instanceof n.Dict)) continue;
                                        e.objId && r.put(e.objId);
                                        const t = e.get('BM');
                                        if (t instanceof n.Name) {
                                            if ('Normal' !== t.name) return !0;
                                        } else if (void 0 !== t && Array.isArray(t))
                                            for (const e of t)
                                                if (e instanceof n.Name && 'Normal' !== e.name) return !0;
                                    }
                                const o = e.get('XObject');
                                if (o instanceof n.Dict)
                                    for (let e of o.getRawValues()) {
                                        if (e instanceof n.Ref) {
                                            if (r.has(e)) continue;
                                            try {
                                                e = s.fetch(e);
                                            } catch (t) {
                                                r.put(e);
                                                (0, a.info)(`hasBlendModes - ignoring XObject: "${t}".`);
                                                continue;
                                            }
                                        }
                                        if (!(0, n.isStream)(e)) continue;
                                        e.dict.objId && r.put(e.dict.objId);
                                        const t = e.dict.get('Resources');
                                        if (t instanceof n.Dict && (!t.objId || !r.has(t.objId))) {
                                            i.push(t);
                                            t.objId && r.put(t.objId);
                                        }
                                    }
                            }
                            r.forEach((e) => {
                                t.put(e);
                            });
                            return !1;
                        }
                        async fetchBuiltInCMap(e) {
                            const t = this.builtInCMapCache.get(e);
                            if (t) return t;
                            const r = this.handler.sendWithStream('FetchBuiltInCMap', { name: e }).getReader(),
                                i = await new Promise(function (e, t) {
                                    !(function pump() {
                                        r.read().then(function ({ value: t, done: r }) {
                                            if (!r) {
                                                e(t);
                                                pump();
                                            }
                                        }, t);
                                    })();
                                });
                            i.compressionType !== a.CMapCompressionType.NONE && this.builtInCMapCache.set(e, i);
                            return i;
                        }
                        async buildFormXObject(e, t, r, i, s, o, c) {
                            const l = t.dict,
                                h = l.getArray('Matrix');
                            let u = l.getArray('BBox');
                            u = Array.isArray(u) && 4 === u.length ? a.Util.normalizeRect(u) : null;
                            let d,
                                f = null;
                            if (l.has('OC')) {
                                f = await this.parseMarkedContentProps(l.get('OC'), e);
                                i.addOp(a.OPS.beginMarkedContentProps, ['OC', f]);
                            }
                            const g = l.get('Group');
                            if (g) {
                                d = { matrix: h, bbox: u, smask: r, isolated: !1, knockout: !1 };
                                const t = g.get('S');
                                let s = null;
                                if ((0, n.isName)(t, 'Transparency')) {
                                    d.isolated = g.get('I') || !1;
                                    d.knockout = g.get('K') || !1;
                                    if (g.has('CS')) {
                                        const t = g.getRaw('CS'),
                                            r = b.ColorSpace.getCached(t, this.xref, c);
                                        s =
                                            r ||
                                            (await this.parseColorSpace({
                                                cs: t,
                                                resources: e,
                                                localColorSpaceCache: c,
                                            }));
                                    }
                                }
                                if (r && r.backdrop) {
                                    s = s || b.ColorSpace.singletons.rgb;
                                    r.backdrop = s.getRgb(r.backdrop, 0);
                                }
                                i.addOp(a.OPS.beginGroup, [d]);
                            }
                            i.addOp(a.OPS.paintFormXObjectBegin, [h, u]);
                            return this.getOperatorList({
                                stream: t,
                                task: s,
                                resources: l.get('Resources') || e,
                                operatorList: i,
                                initialState: o,
                            }).then(function () {
                                i.addOp(a.OPS.paintFormXObjectEnd, []);
                                g && i.addOp(a.OPS.endGroup, [d]);
                                f && i.addOp(a.OPS.endMarkedContent, []);
                            });
                        }
                        _sendImgData(e, t, r = !1) {
                            const a = t ? [t.data.buffer] : null;
                            return this.parsingType3Font || r
                                ? this.handler.send('commonobj', [e, 'Image', t], a)
                                : this.handler.send('obj', [e, this.pageIndex, 'Image', t], a);
                        }
                        async buildPaintImageXObject({
                            resources: e,
                            image: t,
                            isInline: r = !1,
                            operatorList: i,
                            cacheKey: n,
                            localImageCache: s,
                            localColorSpaceCache: o,
                        }) {
                            const c = t.dict,
                                l = c.objId,
                                h = c.get('Width', 'W'),
                                u = c.get('Height', 'H');
                            if (!(h && (0, a.isNum)(h) && u && (0, a.isNum)(u))) {
                                (0, a.warn)('Image dimensions are missing, or not numbers.');
                                return;
                            }
                            const d = this.options.maxImageSize;
                            if (-1 !== d && h * u > d) {
                                (0, a.warn)('Image exceeded maximum allowed size and was removed.');
                                return;
                            }
                            let f, g;
                            if (c.get('ImageMask', 'IM') || !1) {
                                const e = c.get('Width', 'W'),
                                    r = c.get('Height', 'H'),
                                    o = (e + 7) >> 3,
                                    h = t.getBytes(o * r, !0),
                                    u = c.getArray('Decode', 'D');
                                f = O.PDFImage.createMask({
                                    imgArray: h,
                                    width: e,
                                    height: r,
                                    imageIsFromDecodeStream: t instanceof y.DecodeStream,
                                    inverseDecode: !!u && u[0] > 0,
                                });
                                f.cached = !!n;
                                g = [f];
                                i.addOp(a.OPS.paintImageMaskXObject, g);
                                n && s.set(n, l, { fn: a.OPS.paintImageMaskXObject, args: g });
                                return;
                            }
                            const p = c.get('SMask', 'SM') || !1,
                                m = c.get('Mask') || !1;
                            if (r && !p && !m && h + u < 200) {
                                const n = new O.PDFImage({
                                    xref: this.xref,
                                    res: e,
                                    image: t,
                                    isInline: r,
                                    pdfFunctionFactory: this._pdfFunctionFactory,
                                    localColorSpaceCache: o,
                                });
                                f = n.createImageData(!0);
                                i.addOp(a.OPS.paintInlineImageXObject, [f]);
                                return;
                            }
                            let b = `img_${this.idFactory.createObjId()}`,
                                w = !1;
                            if (this.parsingType3Font) b = `${this.idFactory.getDocId()}_type3_${b}`;
                            else if (l) {
                                w = this.globalImageCache.shouldCache(l, this.pageIndex);
                                w && (b = `${this.idFactory.getDocId()}_${b}`);
                            }
                            i.addDependency(b);
                            g = [b, h, u];
                            O.PDFImage.buildImage({
                                xref: this.xref,
                                res: e,
                                image: t,
                                isInline: r,
                                pdfFunctionFactory: this._pdfFunctionFactory,
                                localColorSpaceCache: o,
                            })
                                .then((e) => {
                                    f = e.createImageData(!1);
                                    n && l && w && this.globalImageCache.addByteSize(l, f.data.length);
                                    return this._sendImgData(b, f, w);
                                })
                                .catch((e) => {
                                    (0, a.warn)(`Unable to decode image "${b}": "${e}".`);
                                    return this._sendImgData(b, null, w);
                                });
                            i.addOp(a.OPS.paintImageXObject, g);
                            if (n) {
                                s.set(n, l, { fn: a.OPS.paintImageXObject, args: g });
                                if (l) {
                                    (0, a.assert)(!r, 'Cannot cache an inline image globally.');
                                    this.globalImageCache.addPageIndex(l, this.pageIndex);
                                    w &&
                                        this.globalImageCache.setData(l, {
                                            objId: b,
                                            fn: a.OPS.paintImageXObject,
                                            args: g,
                                            byteSize: 0,
                                        });
                                }
                            }
                        }
                        handleSMask(e, t, r, a, i, n) {
                            const s = e.get('G'),
                                o = { subtype: e.get('S').name, backdrop: e.get('BC') },
                                c = e.get('TR');
                            if ((0, f.isPDFFunction)(c)) {
                                const e = this._pdfFunctionFactory.create(c),
                                    t = new Uint8Array(256),
                                    r = new Float32Array(1);
                                for (let a = 0; a < 256; a++) {
                                    r[0] = a / 255;
                                    e(r, 0, r, 0);
                                    t[a] = (255 * r[0]) | 0;
                                }
                                o.transferMap = t;
                            }
                            return this.buildFormXObject(t, s, o, r, a, i.state.clone(), n);
                        }
                        handleTransferFunction(e) {
                            let t;
                            if (Array.isArray(e)) t = e;
                            else {
                                if (!(0, f.isPDFFunction)(e)) return null;
                                t = [e];
                            }
                            const r = [];
                            let a = 0,
                                i = 0;
                            for (const e of t) {
                                const t = this.xref.fetchIfRef(e);
                                a++;
                                if ((0, n.isName)(t, 'Identity')) {
                                    r.push(null);
                                    continue;
                                }
                                if (!(0, f.isPDFFunction)(t)) return null;
                                const s = this._pdfFunctionFactory.create(t),
                                    o = new Uint8Array(256),
                                    c = new Float32Array(1);
                                for (let e = 0; e < 256; e++) {
                                    c[0] = e / 255;
                                    s(c, 0, c, 0);
                                    o[e] = (255 * c[0]) | 0;
                                }
                                r.push(o);
                                i++;
                            }
                            return (1 !== a && 4 !== a) || 0 === i ? null : r;
                        }
                        handleTilingType(e, t, r, i, s, o, c, l, h) {
                            const d = new v.OperatorList(),
                                f = n.Dict.merge({ xref: this.xref, dictArray: [s.get('Resources'), r] });
                            return this.getOperatorList({ stream: i, task: c, resources: f, operatorList: d })
                                .then(function () {
                                    const r = d.getIR(),
                                        a = (0, u.getTilingPatternIR)(r, s, t);
                                    o.addDependencies(d.dependencies);
                                    o.addOp(e, a);
                                    l && h.set(l, s.objId, { operatorListIR: r, dict: s });
                                })
                                .catch((e) => {
                                    if (!(e instanceof a.AbortException)) {
                                        if (!this.options.ignoreErrors) throw e;
                                        this.handler.send('UnsupportedFeature', {
                                            featureId: a.UNSUPPORTED_FEATURES.errorTilingPattern,
                                        });
                                        (0, a.warn)(`handleTilingType - ignoring pattern: "${e}".`);
                                    }
                                });
                        }
                        handleSetFont(e, t, r, i, o, c, l = null, h = null) {
                            const u = t && t[0] instanceof n.Name ? t[0].name : null;
                            return this.loadFont(u, r, e, l, h)
                                .then((t) =>
                                    t.font.isType3Font
                                        ? t
                                              .loadType3Data(this, e, o)
                                              .then(function () {
                                                  i.addDependencies(t.type3Dependencies);
                                                  return t;
                                              })
                                              .catch((e) => {
                                                  this.handler.send('UnsupportedFeature', {
                                                      featureId: a.UNSUPPORTED_FEATURES.errorFontLoadType3,
                                                  });
                                                  return new TranslatedFont({
                                                      loadedName: 'g_font_error',
                                                      font: new s.ErrorFont(`Type3 font load error: ${e}`),
                                                      dict: t.font,
                                                      evaluatorOptions: this.options,
                                                  });
                                              })
                                        : t
                                )
                                .then((e) => {
                                    c.font = e.font;
                                    e.send(this.handler);
                                    return e.loadedName;
                                });
                        }
                        handleText(e, t) {
                            const r = t.font,
                                i = r.charsToGlyphs(e);
                            if (r.data) {
                                (!!(t.textRenderingMode & a.TextRenderingMode.ADD_TO_PATH_FLAG) ||
                                    'Pattern' === t.fillColorSpace.name ||
                                    r.disableFontFace ||
                                    this.options.disableFontFace) &&
                                    PartialEvaluator.buildFontPaths(r, i, this.handler, this.options);
                            }
                            return i;
                        }
                        ensureStateFont(e) {
                            if (e.font) return;
                            const t = new a.FormatError(
                                'Missing setFont (Tf) operator before text rendering operator.'
                            );
                            if (!this.options.ignoreErrors) throw t;
                            this.handler.send('UnsupportedFeature', {
                                featureId: a.UNSUPPORTED_FEATURES.errorFontState,
                            });
                            (0, a.warn)(`ensureStateFont: "${t}".`);
                        }
                        async setGState({
                            resources: e,
                            gState: t,
                            operatorList: r,
                            cacheKey: i,
                            task: s,
                            stateManager: o,
                            localGStateCache: c,
                            localColorSpaceCache: l,
                        }) {
                            const h = t.objId;
                            let u = !0;
                            const d = [],
                                f = t.getKeys();
                            let g = Promise.resolve();
                            for (let i = 0, c = f.length; i < c; i++) {
                                const c = f[i],
                                    h = t.get(c);
                                switch (c) {
                                    case 'Type':
                                        break;
                                    case 'LW':
                                    case 'LC':
                                    case 'LJ':
                                    case 'ML':
                                    case 'D':
                                    case 'RI':
                                    case 'FL':
                                    case 'CA':
                                    case 'ca':
                                        d.push([c, h]);
                                        break;
                                    case 'Font':
                                        u = !1;
                                        g = g.then(() =>
                                            this.handleSetFont(e, null, h[0], r, s, o.state).then(function (e) {
                                                r.addDependency(e);
                                                d.push([c, [e, h[1]]]);
                                            })
                                        );
                                        break;
                                    case 'BM':
                                        d.push([c, normalizeBlendMode(h)]);
                                        break;
                                    case 'SMask':
                                        if ((0, n.isName)(h, 'None')) {
                                            d.push([c, !1]);
                                            break;
                                        }
                                        if ((0, n.isDict)(h)) {
                                            u = !1;
                                            g = g.then(() => this.handleSMask(h, e, r, s, o, l));
                                            d.push([c, !0]);
                                        } else (0, a.warn)('Unsupported SMask type');
                                        break;
                                    case 'TR':
                                        const t = this.handleTransferFunction(h);
                                        d.push([c, t]);
                                        break;
                                    case 'OP':
                                    case 'op':
                                    case 'OPM':
                                    case 'BG':
                                    case 'BG2':
                                    case 'UCR':
                                    case 'UCR2':
                                    case 'TR2':
                                    case 'HT':
                                    case 'SM':
                                    case 'SA':
                                    case 'AIS':
                                    case 'TK':
                                        (0, a.info)('graphic state operator ' + c);
                                        break;
                                    default:
                                        (0, a.info)('Unknown graphic state operator ' + c);
                                }
                            }
                            return g.then(function () {
                                d.length > 0 && r.addOp(a.OPS.setGState, [d]);
                                u && c.set(i, h, d);
                            });
                        }
                        loadFont(e, t, r, i = null, c = null) {
                            const errorFont = async () =>
                                    new TranslatedFont({
                                        loadedName: 'g_font_error',
                                        font: new s.ErrorFont(`Font "${e}" is not available.`),
                                        dict: t,
                                        evaluatorOptions: this.options,
                                    }),
                                l = this.xref;
                            let h;
                            if (t) {
                                if (!(0, n.isRef)(t))
                                    throw new a.FormatError('The "font" object should be a reference.');
                                h = t;
                            } else {
                                const t = r.get('Font');
                                t && (h = t.getRaw(e));
                            }
                            if (!h) {
                                const r = `Font "${e || (t && t.toString())}" is not available`;
                                if (!this.options.ignoreErrors && !this.parsingType3Font) {
                                    (0, a.warn)(`${r}.`);
                                    return errorFont();
                                }
                                this.handler.send('UnsupportedFeature', {
                                    featureId: a.UNSUPPORTED_FEATURES.errorFontMissing,
                                });
                                (0, a.warn)(`${r} -- attempting to fallback to a default font.`);
                                h = i || PartialEvaluator.fallbackFontDict;
                            }
                            if (this.fontCache.has(h)) return this.fontCache.get(h);
                            t = l.fetchIfRef(h);
                            if (!(0, n.isDict)(t)) return errorFont();
                            if (t.cacheKey && this.fontCache.has(t.cacheKey)) return this.fontCache.get(t.cacheKey);
                            const u = (0, a.createPromiseCapability)();
                            let d;
                            try {
                                d = this.preEvaluateFont(t);
                                d.cssFontInfo = c;
                            } catch (e) {
                                (0, a.warn)(`loadFont - preEvaluateFont failed: "${e}".`);
                                return errorFont();
                            }
                            const { descriptor: f, hash: g } = d,
                                p = (0, n.isRef)(h);
                            let m;
                            p && (m = `f${h.toString()}`);
                            if (g && (0, n.isDict)(f)) {
                                f.fontAliases || (f.fontAliases = Object.create(null));
                                const e = f.fontAliases;
                                if (e[g]) {
                                    const t = e[g].aliasRef;
                                    if (p && t && this.fontCache.has(t)) {
                                        this.fontCache.putAlias(h, t);
                                        return this.fontCache.get(h);
                                    }
                                } else e[g] = { fontID: this.idFactory.createFontId() };
                                p && (e[g].aliasRef = h);
                                m = e[g].fontID;
                            }
                            if (p) this.fontCache.put(h, u.promise);
                            else {
                                m || (m = this.idFactory.createFontId());
                                t.cacheKey = `cacheKey_${m}`;
                                this.fontCache.put(t.cacheKey, u.promise);
                            }
                            (0, a.assert)(m && m.startsWith('f'), 'The "fontID" must be (correctly) defined.');
                            t.loadedName = `${this.idFactory.getDocId()}_${m}`;
                            this.translateFont(d)
                                .then((e) => {
                                    if (void 0 !== e.fontType) {
                                        l.stats.fontTypes[e.fontType] = !0;
                                    }
                                    u.resolve(
                                        new TranslatedFont({
                                            loadedName: t.loadedName,
                                            font: e,
                                            dict: t,
                                            evaluatorOptions: this.options,
                                        })
                                    );
                                })
                                .catch((e) => {
                                    this.handler.send('UnsupportedFeature', {
                                        featureId: a.UNSUPPORTED_FEATURES.errorFontTranslate,
                                    });
                                    (0, a.warn)(`loadFont - translateFont failed: "${e}".`);
                                    try {
                                        const e = f && f.get('FontFile3'),
                                            t = e && e.get('Subtype'),
                                            r = (0, o.getFontType)(d.type, t && t.name);
                                        l.stats.fontTypes[r] = !0;
                                    } catch (e) {}
                                    u.resolve(
                                        new TranslatedFont({
                                            loadedName: t.loadedName,
                                            font: new s.ErrorFont(e instanceof Error ? e.message : e),
                                            dict: t,
                                            evaluatorOptions: this.options,
                                        })
                                    );
                                });
                            return u.promise;
                        }
                        buildPath(e, t, r, i = !1) {
                            const n = e.length - 1;
                            r || (r = []);
                            if (n < 0 || e.fnArray[n] !== a.OPS.constructPath) {
                                if (i) {
                                    (0, a.warn)(`Encountered path operator "${t}" inside of a text object.`);
                                    e.addOp(a.OPS.save, null);
                                }
                                e.addOp(a.OPS.constructPath, [[t], r]);
                                i && e.addOp(a.OPS.restore, null);
                            } else {
                                const a = e.argsArray[n];
                                a[0].push(t);
                                Array.prototype.push.apply(a[1], r);
                            }
                        }
                        parseColorSpace({ cs: e, resources: t, localColorSpaceCache: r }) {
                            return b.ColorSpace.parseAsync({
                                cs: e,
                                xref: this.xref,
                                resources: t,
                                pdfFunctionFactory: this._pdfFunctionFactory,
                                localColorSpaceCache: r,
                            }).catch((e) => {
                                if (e instanceof a.AbortException) return null;
                                if (this.options.ignoreErrors) {
                                    this.handler.send('UnsupportedFeature', {
                                        featureId: a.UNSUPPORTED_FEATURES.errorColorSpace,
                                    });
                                    (0, a.warn)(`parseColorSpace - ignoring ColorSpace: "${e}".`);
                                    return null;
                                }
                                throw e;
                            });
                        }
                        handleColorN(e, t, r, i, s, o, c, l, h) {
                            const d = r.pop();
                            if (d instanceof n.Name) {
                                const f = d.name,
                                    g = h.getByName(f);
                                if (g)
                                    try {
                                        const a = i.base ? i.base.getRgb(r, 0) : null,
                                            n = (0, u.getTilingPatternIR)(g.operatorListIR, g.dict, a);
                                        e.addOp(t, n);
                                        return;
                                    } catch (e) {}
                                let p = s.get(f);
                                if (p) {
                                    const s = (0, n.isStream)(p) ? p.dict : p,
                                        d = s.get('PatternType');
                                    if (d === T) {
                                        const a = i.base ? i.base.getRgb(r, 0) : null;
                                        return this.handleTilingType(t, a, o, p, s, e, c, f, h);
                                    }
                                    if (d === E) {
                                        const r = s.get('Shading'),
                                            a = s.getArray('Matrix');
                                        p = u.Pattern.parseShading(
                                            r,
                                            a,
                                            this.xref,
                                            o,
                                            this.handler,
                                            this._pdfFunctionFactory,
                                            l
                                        );
                                        e.addOp(t, p.getIR());
                                        return;
                                    }
                                    throw new a.FormatError(`Unknown PatternType: ${d}`);
                                }
                            }
                            throw new a.FormatError(`Unknown PatternName: ${d}`);
                        }
                        _parseVisibilityExpression(e, t, r) {
                            if (++t > 10) {
                                (0, a.warn)('Visibility expression is too deeply nested');
                                return;
                            }
                            const i = e.length,
                                s = this.xref.fetchIfRef(e[0]);
                            if (i < 2 || !(0, n.isName)(s)) (0, a.warn)('Invalid visibility expression');
                            else {
                                switch (s.name) {
                                    case 'And':
                                    case 'Or':
                                    case 'Not':
                                        r.push(s.name);
                                        break;
                                    default:
                                        (0, a.warn)(`Invalid operator ${s.name} in visibility expression`);
                                        return;
                                }
                                for (let a = 1; a < i; a++) {
                                    const i = e[a],
                                        s = this.xref.fetchIfRef(i);
                                    if (Array.isArray(s)) {
                                        const e = [];
                                        r.push(e);
                                        this._parseVisibilityExpression(s, t, e);
                                    } else (0, n.isRef)(i) && r.push(i.toString());
                                }
                            }
                        }
                        async parseMarkedContentProps(e, t) {
                            let r;
                            if ((0, n.isName)(e)) {
                                r = t.get('Properties').get(e.name);
                            } else {
                                if (!(0, n.isDict)(e))
                                    throw new a.FormatError('Optional content properties malformed.');
                                r = e;
                            }
                            const i = r.get('Type').name;
                            if ('OCG' === i) return { type: i, id: r.objId };
                            if ('OCMD' === i) {
                                const e = r.get('VE');
                                if (Array.isArray(e)) {
                                    const t = [];
                                    this._parseVisibilityExpression(e, 0, t);
                                    if (t.length > 0) return { type: 'OCMD', expression: t };
                                }
                                const t = r.get('OCGs');
                                if (Array.isArray(t) || (0, n.isDict)(t)) {
                                    const e = [];
                                    if (Array.isArray(t)) for (const r of t) e.push(r.toString());
                                    else e.push(t.objId);
                                    return {
                                        type: i,
                                        ids: e,
                                        policy: (0, n.isName)(r.get('P')) ? r.get('P').name : null,
                                        expression: null,
                                    };
                                }
                                if ((0, n.isRef)(t)) return { type: i, id: t.toString() };
                            }
                            return null;
                        }
                        getOperatorList({
                            stream: e,
                            task: t,
                            resources: r,
                            operatorList: i,
                            initialState: s = null,
                            fallbackFontDict: o = null,
                        }) {
                            r = r || n.Dict.empty;
                            s = s || new EvalState();
                            if (!i) throw new Error('getOperatorList: missing "operatorList" parameter');
                            const c = this,
                                l = this.xref;
                            let h = !1;
                            const d = new p.LocalImageCache(),
                                f = new p.LocalColorSpaceCache(),
                                g = new p.LocalGStateCache(),
                                m = new p.LocalTilingPatternCache(),
                                y = r.get('XObject') || n.Dict.empty,
                                w = r.get('Pattern') || n.Dict.empty,
                                S = new StateManager(s),
                                x = new EvaluatorPreprocessor(e, l, S),
                                k = new TimeSlotManager();
                            function closePendingRestoreOPS(e) {
                                for (let e = 0, t = x.savedStatesDepth; e < t; e++) i.addOp(a.OPS.restore, []);
                            }
                            return new Promise(function promiseBody(e, s) {
                                const next = function (t) {
                                    Promise.all([t, i.ready]).then(function () {
                                        try {
                                            promiseBody(e, s);
                                        } catch (e) {
                                            s(e);
                                        }
                                    }, s);
                                };
                                t.ensureNotTerminated();
                                k.reset();
                                const p = {};
                                let C, v, O, F, T;
                                for (; !(C = k.check()); ) {
                                    p.args = null;
                                    if (!x.read(p)) break;
                                    let e = p.args,
                                        s = p.fn;
                                    switch (0 | s) {
                                        case a.OPS.paintXObject:
                                            T = e[0].name;
                                            if (T) {
                                                const t = d.getByName(T);
                                                if (t) {
                                                    i.addOp(t.fn, t.args);
                                                    e = null;
                                                    continue;
                                                }
                                            }
                                            next(
                                                new Promise(function (e, s) {
                                                    if (!T)
                                                        throw new a.FormatError('XObject must be referred to by name.');
                                                    let o = y.getRaw(T);
                                                    if (o instanceof n.Ref) {
                                                        const t = d.getByRef(o);
                                                        if (t) {
                                                            i.addOp(t.fn, t.args);
                                                            e();
                                                            return;
                                                        }
                                                        const r = c.globalImageCache.getData(o, c.pageIndex);
                                                        if (r) {
                                                            i.addDependency(r.objId);
                                                            i.addOp(r.fn, r.args);
                                                            e();
                                                            return;
                                                        }
                                                        o = l.fetch(o);
                                                    }
                                                    if (!(0, n.isStream)(o))
                                                        throw new a.FormatError('XObject should be a stream');
                                                    const h = o.dict.get('Subtype');
                                                    if (!(0, n.isName)(h))
                                                        throw new a.FormatError('XObject should have a Name subtype');
                                                    if ('Form' !== h.name)
                                                        if ('Image' !== h.name) {
                                                            if ('PS' !== h.name)
                                                                throw new a.FormatError(
                                                                    `Unhandled XObject subtype ${h.name}`
                                                                );
                                                            (0, a.info)('Ignored XObject subtype PS');
                                                            e();
                                                        } else
                                                            c.buildPaintImageXObject({
                                                                resources: r,
                                                                image: o,
                                                                operatorList: i,
                                                                cacheKey: T,
                                                                localImageCache: d,
                                                                localColorSpaceCache: f,
                                                            }).then(e, s);
                                                    else {
                                                        S.save();
                                                        c.buildFormXObject(r, o, null, i, t, S.state.clone(), f).then(
                                                            function () {
                                                                S.restore();
                                                                e();
                                                            },
                                                            s
                                                        );
                                                    }
                                                }).catch(function (e) {
                                                    if (!(e instanceof a.AbortException)) {
                                                        if (!c.options.ignoreErrors) throw e;
                                                        c.handler.send('UnsupportedFeature', {
                                                            featureId: a.UNSUPPORTED_FEATURES.errorXObject,
                                                        });
                                                        (0, a.warn)(`getOperatorList - ignoring XObject: "${e}".`);
                                                    }
                                                })
                                            );
                                            return;
                                        case a.OPS.setFont:
                                            var E = e[1];
                                            next(
                                                c.handleSetFont(r, e, null, i, t, S.state, o).then(function (e) {
                                                    i.addDependency(e);
                                                    i.addOp(a.OPS.setFont, [e, E]);
                                                })
                                            );
                                            return;
                                        case a.OPS.beginText:
                                            h = !0;
                                            break;
                                        case a.OPS.endText:
                                            h = !1;
                                            break;
                                        case a.OPS.endInlineImage:
                                            var D = e[0].cacheKey;
                                            if (D) {
                                                const t = d.getByName(D);
                                                if (t) {
                                                    i.addOp(t.fn, t.args);
                                                    e = null;
                                                    continue;
                                                }
                                            }
                                            next(
                                                c.buildPaintImageXObject({
                                                    resources: r,
                                                    image: e[0],
                                                    isInline: !0,
                                                    operatorList: i,
                                                    cacheKey: D,
                                                    localImageCache: d,
                                                    localColorSpaceCache: f,
                                                })
                                            );
                                            return;
                                        case a.OPS.showText:
                                            if (!S.state.font) {
                                                c.ensureStateFont(S.state);
                                                continue;
                                            }
                                            e[0] = c.handleText(e[0], S.state);
                                            break;
                                        case a.OPS.showSpacedText:
                                            if (!S.state.font) {
                                                c.ensureStateFont(S.state);
                                                continue;
                                            }
                                            var N = e[0],
                                                L = [],
                                                R = N.length,
                                                j = S.state;
                                            for (v = 0; v < R; ++v) {
                                                const e = N[v];
                                                (0, a.isString)(e)
                                                    ? Array.prototype.push.apply(L, c.handleText(e, j))
                                                    : (0, a.isNum)(e) && L.push(e);
                                            }
                                            e[0] = L;
                                            s = a.OPS.showText;
                                            break;
                                        case a.OPS.nextLineShowText:
                                            if (!S.state.font) {
                                                c.ensureStateFont(S.state);
                                                continue;
                                            }
                                            i.addOp(a.OPS.nextLine);
                                            e[0] = c.handleText(e[0], S.state);
                                            s = a.OPS.showText;
                                            break;
                                        case a.OPS.nextLineSetSpacingShowText:
                                            if (!S.state.font) {
                                                c.ensureStateFont(S.state);
                                                continue;
                                            }
                                            i.addOp(a.OPS.nextLine);
                                            i.addOp(a.OPS.setWordSpacing, [e.shift()]);
                                            i.addOp(a.OPS.setCharSpacing, [e.shift()]);
                                            e[0] = c.handleText(e[0], S.state);
                                            s = a.OPS.showText;
                                            break;
                                        case a.OPS.setTextRenderingMode:
                                            S.state.textRenderingMode = e[0];
                                            break;
                                        case a.OPS.setFillColorSpace: {
                                            const t = b.ColorSpace.getCached(e[0], l, f);
                                            if (t) {
                                                S.state.fillColorSpace = t;
                                                continue;
                                            }
                                            next(
                                                c
                                                    .parseColorSpace({
                                                        cs: e[0],
                                                        resources: r,
                                                        localColorSpaceCache: f,
                                                    })
                                                    .then(function (e) {
                                                        e && (S.state.fillColorSpace = e);
                                                    })
                                            );
                                            return;
                                        }
                                        case a.OPS.setStrokeColorSpace: {
                                            const t = b.ColorSpace.getCached(e[0], l, f);
                                            if (t) {
                                                S.state.strokeColorSpace = t;
                                                continue;
                                            }
                                            next(
                                                c
                                                    .parseColorSpace({
                                                        cs: e[0],
                                                        resources: r,
                                                        localColorSpaceCache: f,
                                                    })
                                                    .then(function (e) {
                                                        e && (S.state.strokeColorSpace = e);
                                                    })
                                            );
                                            return;
                                        }
                                        case a.OPS.setFillColor:
                                            F = S.state.fillColorSpace;
                                            e = F.getRgb(e, 0);
                                            s = a.OPS.setFillRGBColor;
                                            break;
                                        case a.OPS.setStrokeColor:
                                            F = S.state.strokeColorSpace;
                                            e = F.getRgb(e, 0);
                                            s = a.OPS.setStrokeRGBColor;
                                            break;
                                        case a.OPS.setFillGray:
                                            S.state.fillColorSpace = b.ColorSpace.singletons.gray;
                                            e = b.ColorSpace.singletons.gray.getRgb(e, 0);
                                            s = a.OPS.setFillRGBColor;
                                            break;
                                        case a.OPS.setStrokeGray:
                                            S.state.strokeColorSpace = b.ColorSpace.singletons.gray;
                                            e = b.ColorSpace.singletons.gray.getRgb(e, 0);
                                            s = a.OPS.setStrokeRGBColor;
                                            break;
                                        case a.OPS.setFillCMYKColor:
                                            S.state.fillColorSpace = b.ColorSpace.singletons.cmyk;
                                            e = b.ColorSpace.singletons.cmyk.getRgb(e, 0);
                                            s = a.OPS.setFillRGBColor;
                                            break;
                                        case a.OPS.setStrokeCMYKColor:
                                            S.state.strokeColorSpace = b.ColorSpace.singletons.cmyk;
                                            e = b.ColorSpace.singletons.cmyk.getRgb(e, 0);
                                            s = a.OPS.setStrokeRGBColor;
                                            break;
                                        case a.OPS.setFillRGBColor:
                                            S.state.fillColorSpace = b.ColorSpace.singletons.rgb;
                                            e = b.ColorSpace.singletons.rgb.getRgb(e, 0);
                                            break;
                                        case a.OPS.setStrokeRGBColor:
                                            S.state.strokeColorSpace = b.ColorSpace.singletons.rgb;
                                            e = b.ColorSpace.singletons.rgb.getRgb(e, 0);
                                            break;
                                        case a.OPS.setFillColorN:
                                            F = S.state.fillColorSpace;
                                            if ('Pattern' === F.name) {
                                                next(c.handleColorN(i, a.OPS.setFillColorN, e, F, w, r, t, f, m));
                                                return;
                                            }
                                            e = F.getRgb(e, 0);
                                            s = a.OPS.setFillRGBColor;
                                            break;
                                        case a.OPS.setStrokeColorN:
                                            F = S.state.strokeColorSpace;
                                            if ('Pattern' === F.name) {
                                                next(c.handleColorN(i, a.OPS.setStrokeColorN, e, F, w, r, t, f, m));
                                                return;
                                            }
                                            e = F.getRgb(e, 0);
                                            s = a.OPS.setStrokeRGBColor;
                                            break;
                                        case a.OPS.shadingFill:
                                            var _ = r.get('Shading');
                                            if (!_) throw new a.FormatError('No shading resource found');
                                            var U = _.get(e[0].name);
                                            if (!U) throw new a.FormatError('No shading object found');
                                            e = [
                                                u.Pattern.parseShading(
                                                    U,
                                                    null,
                                                    l,
                                                    r,
                                                    c.handler,
                                                    c._pdfFunctionFactory,
                                                    f
                                                ).getIR(),
                                            ];
                                            s = a.OPS.shadingFill;
                                            break;
                                        case a.OPS.setGState:
                                            T = e[0].name;
                                            if (T) {
                                                const t = g.getByName(T);
                                                if (t) {
                                                    t.length > 0 && i.addOp(a.OPS.setGState, [t]);
                                                    e = null;
                                                    continue;
                                                }
                                            }
                                            next(
                                                new Promise(function (e, s) {
                                                    if (!T)
                                                        throw new a.FormatError('GState must be referred to by name.');
                                                    const o = r.get('ExtGState');
                                                    if (!(o instanceof n.Dict))
                                                        throw new a.FormatError('ExtGState should be a dictionary.');
                                                    const l = o.get(T);
                                                    if (!(l instanceof n.Dict))
                                                        throw new a.FormatError('GState should be a dictionary.');
                                                    c.setGState({
                                                        resources: r,
                                                        gState: l,
                                                        operatorList: i,
                                                        cacheKey: T,
                                                        task: t,
                                                        stateManager: S,
                                                        localGStateCache: g,
                                                        localColorSpaceCache: f,
                                                    }).then(e, s);
                                                }).catch(function (e) {
                                                    if (!(e instanceof a.AbortException)) {
                                                        if (!c.options.ignoreErrors) throw e;
                                                        c.handler.send('UnsupportedFeature', {
                                                            featureId: a.UNSUPPORTED_FEATURES.errorExtGState,
                                                        });
                                                        (0, a.warn)(`getOperatorList - ignoring ExtGState: "${e}".`);
                                                    }
                                                })
                                            );
                                            return;
                                        case a.OPS.moveTo:
                                        case a.OPS.lineTo:
                                        case a.OPS.curveTo:
                                        case a.OPS.curveTo2:
                                        case a.OPS.curveTo3:
                                        case a.OPS.closePath:
                                        case a.OPS.rectangle:
                                            c.buildPath(i, s, e, h);
                                            continue;
                                        case a.OPS.markPoint:
                                        case a.OPS.markPointProps:
                                        case a.OPS.beginCompat:
                                        case a.OPS.endCompat:
                                            continue;
                                        case a.OPS.beginMarkedContentProps:
                                            if (!(0, n.isName)(e[0])) {
                                                (0, a.warn)(`Expected name for beginMarkedContentProps arg0=${e[0]}`);
                                                continue;
                                            }
                                            if ('OC' === e[0].name) {
                                                next(
                                                    c
                                                        .parseMarkedContentProps(e[1], r)
                                                        .then((e) => {
                                                            i.addOp(a.OPS.beginMarkedContentProps, ['OC', e]);
                                                        })
                                                        .catch((e) => {
                                                            if (!(e instanceof a.AbortException)) {
                                                                if (!c.options.ignoreErrors) throw e;
                                                                c.handler.send('UnsupportedFeature', {
                                                                    featureId:
                                                                        a.UNSUPPORTED_FEATURES.errorMarkedContent,
                                                                });
                                                                (0, a.warn)(
                                                                    `getOperatorList - ignoring beginMarkedContentProps: "${e}".`
                                                                );
                                                            }
                                                        })
                                                );
                                                return;
                                            }
                                            e = [e[0].name, e[1] instanceof n.Dict ? e[1].get('MCID') : null];
                                            break;
                                        case a.OPS.beginMarkedContent:
                                        case a.OPS.endMarkedContent:
                                        default:
                                            if (null !== e) {
                                                for (v = 0, O = e.length; v < O && !(e[v] instanceof n.Dict); v++);
                                                if (v < O) {
                                                    (0, a.warn)('getOperatorList - ignoring operator: ' + s);
                                                    continue;
                                                }
                                            }
                                    }
                                    i.addOp(s, e);
                                }
                                if (C) next(M);
                                else {
                                    closePendingRestoreOPS();
                                    e();
                                }
                            }).catch((e) => {
                                if (!(e instanceof a.AbortException)) {
                                    if (!this.options.ignoreErrors) throw e;
                                    this.handler.send('UnsupportedFeature', {
                                        featureId: a.UNSUPPORTED_FEATURES.errorOperatorList,
                                    });
                                    (0, a.warn)(`getOperatorList - ignoring errors during "${t.name}" task: "${e}".`);
                                    closePendingRestoreOPS();
                                }
                            });
                        }
                        getTextContent({
                            stream: e,
                            task: t,
                            resources: r,
                            stateManager: i = null,
                            normalizeWhitespace: s = !1,
                            combineTextItems: o = !1,
                            includeMarkedContent: c = !1,
                            sink: h,
                            seenStyles: u = new Set(),
                        }) {
                            r = r || n.Dict.empty;
                            i = i || new StateManager(new TextState());
                            const d = /\s/g,
                                f = { items: [], styles: Object.create(null) },
                                g = {
                                    initialized: !1,
                                    str: [],
                                    totalWidth: 0,
                                    totalHeight: 0,
                                    width: 0,
                                    height: 0,
                                    vertical: !1,
                                    lastCharSize: 0,
                                    prevTransform: null,
                                    textAdvanceScale: 0,
                                    spaceWidth: 0,
                                    spaceInFlowMin: 0,
                                    spaceInFlowMax: 0,
                                    trackingSpaceMin: 1 / 0,
                                    transform: null,
                                    fontName: null,
                                    hasEOL: !1,
                                    isLastCharWhiteSpace: !1,
                                },
                                b = this,
                                y = this.xref,
                                w = [];
                            let S = null;
                            const x = new p.LocalImageCache(),
                                k = new p.LocalGStateCache(),
                                C = new EvaluatorPreprocessor(e, y, i);
                            let v;
                            function getCurrentTextTransform() {
                                const e = v.font,
                                    t = [v.fontSize * v.textHScale, 0, 0, v.fontSize, 0, v.textRise];
                                if (
                                    e.isType3Font &&
                                    v.fontSize <= 1 &&
                                    !(0, a.isArrayEqual)(v.fontMatrix, a.FONT_IDENTITY_MATRIX)
                                ) {
                                    const r = e.bbox[3] - e.bbox[1];
                                    r > 0 && (t[3] *= r * v.fontMatrix[3]);
                                }
                                return a.Util.transform(v.ctm, a.Util.transform(v.textMatrix, t));
                            }
                            function ensureTextContentItem() {
                                if (g.initialized) return g;
                                const e = v.font,
                                    t = e.loadedName;
                                if (!u.has(t)) {
                                    u.add(t);
                                    f.styles[t] = {
                                        fontFamily: e.fallbackName,
                                        ascent: e.ascent,
                                        descent: e.descent,
                                        vertical: e.vertical,
                                    };
                                }
                                g.fontName = t;
                                const r = (g.transform = getCurrentTextTransform());
                                if (e.vertical) {
                                    g.width = g.totalWidth = Math.hypot(r[0], r[1]);
                                    g.height = g.totalHeight = 0;
                                    g.vertical = !0;
                                } else {
                                    g.width = g.totalWidth = 0;
                                    g.height = g.totalHeight = Math.hypot(r[2], r[3]);
                                    g.vertical = !1;
                                }
                                const a = Math.hypot(v.textLineMatrix[0], v.textLineMatrix[1]),
                                    i = Math.hypot(v.ctm[0], v.ctm[1]);
                                g.textAdvanceScale = i * a;
                                g.lastCharSize = g.lastCharSize || 0;
                                const n = (e.spaceWidth / 1e3) * v.fontSize;
                                if (n) {
                                    g.spaceWidth = n;
                                    g.trackingSpaceMin = 0.3 * n;
                                    g.spaceInFlowMin = 0.3 * n;
                                    g.spaceInFlowMax = 1.3 * n;
                                } else {
                                    g.spaceWidth = 0;
                                    g.trackingSpaceMin = 1 / 0;
                                }
                                g.hasEOL = !1;
                                g.initialized = !0;
                                return g;
                            }
                            function updateAdvanceScale() {
                                if (!g.initialized) return;
                                const e = Math.hypot(v.textLineMatrix[0], v.textLineMatrix[1]),
                                    t = Math.hypot(v.ctm[0], v.ctm[1]) * e;
                                if (t !== g.textAdvanceScale) {
                                    if (g.vertical) {
                                        g.totalHeight += g.height * g.textAdvanceScale;
                                        g.height = 0;
                                    } else {
                                        g.totalWidth += g.width * g.textAdvanceScale;
                                        g.width = 0;
                                    }
                                    g.textAdvanceScale = t;
                                }
                            }
                            function runBidiTransform(e) {
                                const t = e.str.join(''),
                                    r = (0, m.bidi)(t, -1, e.vertical);
                                return {
                                    str: s
                                        ? (function replaceWhitespace(e) {
                                              const t = e.length;
                                              let r,
                                                  a = 0;
                                              for (; a < t && (r = e.charCodeAt(a)) >= 32 && r <= 127; ) a++;
                                              return a < t ? e.replace(d, ' ') : e;
                                          })(r.str)
                                        : r.str,
                                    dir: r.dir,
                                    width: e.totalWidth,
                                    height: e.totalHeight,
                                    transform: e.transform,
                                    fontName: e.fontName,
                                    hasEOL: e.hasEOL,
                                };
                            }
                            function handleSetFont(e, t) {
                                return b.loadFont(e, t, r).then(function (e) {
                                    v.font = e.font;
                                    v.fontMatrix = e.font.fontMatrix || a.FONT_IDENTITY_MATRIX;
                                });
                            }
                            function buildTextContentItem({ chars: e, extraSpacing: t, isFirstChunk: r }) {
                                const a = v.font;
                                if (!e) {
                                    const e = v.charSpacing + t;
                                    e &&
                                        (a.vertical
                                            ? v.translateTextMatrix(0, e)
                                            : v.translateTextMatrix(e * v.textHScale, 0));
                                    return;
                                }
                                const i = (0, l.getNormalizedUnicodes)(),
                                    n = a.charsToGlyphs(e),
                                    s = v.fontMatrix[0] * v.fontSize;
                                r &&
                                    (function compareWithLastPosition(e) {
                                        if (!o || !v.font || !g.prevTransform) return;
                                        const t = getCurrentTextTransform(),
                                            r = t[4],
                                            a = t[5],
                                            i = g.prevTransform[4],
                                            n = g.prevTransform[5];
                                        if (i === r && n === a) return;
                                        const s = (r - i) / g.textAdvanceScale,
                                            c = (a - n) / g.textAdvanceScale,
                                            l = -0.5 * g.lastCharSize;
                                        if (v.font.vertical) {
                                            if (Math.abs(s) > g.width / g.textAdvanceScale) {
                                                appendEOL();
                                                return;
                                            }
                                            if (l > c) return;
                                            if (c > g.trackingSpaceMin) g.height += c;
                                            else if (!addFakeSpaces(c, 0, g.prevTransform))
                                                if (0 === g.str.length) {
                                                    f.items.push({
                                                        str: ' ',
                                                        dir: 'ltr',
                                                        width: 0,
                                                        height: c,
                                                        transform: g.prevTransform,
                                                        fontName: g.fontName,
                                                        hasEOL: !1,
                                                    });
                                                    g.isLastCharWhiteSpace = !0;
                                                } else g.height += c;
                                        } else if (Math.abs(c) > g.height / g.textAdvanceScale) appendEOL();
                                        else if (!(l > s))
                                            if (s <= g.trackingSpaceMin) g.width += s;
                                            else if (!addFakeSpaces(s, 0, g.prevTransform))
                                                if (0 === g.str.length) {
                                                    f.items.push({
                                                        str: ' ',
                                                        dir: 'ltr',
                                                        width: s,
                                                        height: 0,
                                                        transform: g.prevTransform,
                                                        fontName: g.fontName,
                                                        hasEOL: !1,
                                                    });
                                                    g.isLastCharWhiteSpace = !0;
                                                } else g.width += s;
                                    })();
                                let c = ensureTextContentItem(),
                                    h = 0,
                                    u = 0;
                                for (let e = 0, r = n.length; e < r; e++) {
                                    const o = n[e];
                                    let d = v.charSpacing + (e === r - 1 ? t : 0),
                                        f = o.unicode;
                                    if (o.isSpace) {
                                        d += v.wordSpacing;
                                        c.isLastCharWhiteSpace = !0;
                                    } else {
                                        f = i[f] || f;
                                        f = (0, l.reverseIfRtl)(f);
                                        c.isLastCharWhiteSpace = !1;
                                    }
                                    c.str.push(f);
                                    let p = (a.vertical && o.vmetric ? o.vmetric[0] : o.width) * s;
                                    if (a.vertical) {
                                        v.translateTextMatrix(0, p);
                                        p = Math.abs(p);
                                    } else {
                                        p *= v.textHScale;
                                        v.translateTextMatrix(p, 0);
                                    }
                                    h += p;
                                    if (d) {
                                        a.vertical || (d *= v.textHScale);
                                        p += d;
                                        const e = d > g.trackingSpaceMin && addFakeSpaces(d, h);
                                        a.vertical ? v.translateTextMatrix(0, d) : v.translateTextMatrix(d, 0);
                                        if (e) {
                                            c = ensureTextContentItem();
                                            h = 0;
                                        } else h += d;
                                    }
                                    u = p;
                                }
                                c.lastCharSize = u;
                                a.vertical ? (c.height += h) : (c.width += h);
                                c.prevTransform = getCurrentTextTransform();
                            }
                            function appendEOL() {
                                if (g.initialized) {
                                    g.hasEOL = !0;
                                    flushTextContentItem();
                                } else
                                    f.items.length > 0
                                        ? (f.items[f.items.length - 1].hasEOL = !0)
                                        : f.items.push({
                                              str: '',
                                              dir: 'ltr',
                                              width: 0,
                                              height: 0,
                                              transform: getCurrentTextTransform(),
                                              fontName: v.font.loadedName,
                                              hasEOL: !0,
                                          });
                                g.isLastCharWhiteSpace = !1;
                                g.lastCharSize = 0;
                            }
                            function addFakeSpaces(e, t, r = null) {
                                if (g.spaceInFlowMin <= e && e <= g.spaceInFlowMax) {
                                    if (g.initialized) {
                                        g.str.push(' ');
                                        g.isLastCharWhiteSpace = !0;
                                    }
                                    return !1;
                                }
                                const a = g.fontName;
                                let i = 0;
                                e *= g.textAdvanceScale;
                                if (g.vertical) {
                                    g.height += t;
                                    i = e;
                                    e = 0;
                                } else g.width += t;
                                flushTextContentItem();
                                if (g.isLastCharWhiteSpace) return !0;
                                g.isLastCharWhiteSpace = !0;
                                f.items.push({
                                    str: ' ',
                                    dir: 'ltr',
                                    width: e,
                                    height: i,
                                    transform: r || getCurrentTextTransform(),
                                    fontName: a,
                                    hasEOL: !1,
                                });
                                return !0;
                            }
                            function flushTextContentItem() {
                                if (g.initialized && g.str) {
                                    g.vertical
                                        ? (g.totalHeight += g.height * g.textAdvanceScale)
                                        : (g.totalWidth += g.width * g.textAdvanceScale);
                                    f.items.push(runBidiTransform(g));
                                    g.initialized = !1;
                                    g.str.length = 0;
                                }
                            }
                            function enqueueChunk() {
                                const e = f.items.length;
                                if (e > 0) {
                                    h.enqueue(f, e);
                                    f.items = [];
                                    f.styles = Object.create(null);
                                }
                            }
                            const O = new TimeSlotManager();
                            return new Promise(function promiseBody(e, l) {
                                const next = function (t) {
                                    enqueueChunk();
                                    Promise.all([t, h.ready]).then(function () {
                                        try {
                                            promiseBody(e, l);
                                        } catch (e) {
                                            l(e);
                                        }
                                    }, l);
                                };
                                t.ensureNotTerminated();
                                O.reset();
                                const d = {};
                                let p,
                                    m = [];
                                for (; !(p = O.check()); ) {
                                    m.length = 0;
                                    d.args = m;
                                    if (!C.read(d)) break;
                                    v = i.state;
                                    const e = d.fn;
                                    m = d.args;
                                    switch (0 | e) {
                                        case a.OPS.setFont:
                                            var F = m[0].name,
                                                T = m[1];
                                            if (v.font && F === v.fontName && T === v.fontSize) break;
                                            flushTextContentItem();
                                            v.fontName = F;
                                            v.fontSize = T;
                                            next(handleSetFont(F, null));
                                            return;
                                        case a.OPS.setTextRise:
                                            flushTextContentItem();
                                            v.textRise = m[0];
                                            break;
                                        case a.OPS.setHScale:
                                            flushTextContentItem();
                                            v.textHScale = m[0] / 100;
                                            break;
                                        case a.OPS.setLeading:
                                            flushTextContentItem();
                                            v.leading = m[0];
                                            break;
                                        case a.OPS.moveText:
                                            v.translateTextLineMatrix(m[0], m[1]);
                                            v.textMatrix = v.textLineMatrix.slice();
                                            break;
                                        case a.OPS.setLeadingMoveText:
                                            flushTextContentItem();
                                            v.leading = -m[1];
                                            v.translateTextLineMatrix(m[0], m[1]);
                                            v.textMatrix = v.textLineMatrix.slice();
                                            break;
                                        case a.OPS.nextLine:
                                            appendEOL();
                                            v.carriageReturn();
                                            break;
                                        case a.OPS.setTextMatrix:
                                            v.setTextMatrix(m[0], m[1], m[2], m[3], m[4], m[5]);
                                            v.setTextLineMatrix(m[0], m[1], m[2], m[3], m[4], m[5]);
                                            updateAdvanceScale();
                                            break;
                                        case a.OPS.setCharSpacing:
                                            v.charSpacing = m[0];
                                            break;
                                        case a.OPS.setWordSpacing:
                                            v.wordSpacing = m[0];
                                            break;
                                        case a.OPS.beginText:
                                            flushTextContentItem();
                                            v.textMatrix = a.IDENTITY_MATRIX.slice();
                                            v.textLineMatrix = a.IDENTITY_MATRIX.slice();
                                            break;
                                        case a.OPS.showSpacedText:
                                            if (!i.state.font) {
                                                b.ensureStateFont(i.state);
                                                continue;
                                            }
                                            const e = ((v.font.vertical ? 1 : -1) * v.fontSize) / 1e3,
                                                l = m[0];
                                            let d = !0;
                                            for (let t = 0, r = l.length; t < r - 1; t++) {
                                                const r = l[t];
                                                if ('string' == typeof r) w.push(r);
                                                else if ('number' == typeof r && 0 !== r) {
                                                    const t = w.join('');
                                                    w.length = 0;
                                                    buildTextContentItem({
                                                        chars: t,
                                                        extraSpacing: r * e,
                                                        isFirstChunk: d,
                                                    });
                                                    t && d && (d = !1);
                                                }
                                            }
                                            const p = l[l.length - 1];
                                            'string' == typeof p && w.push(p);
                                            if (w.length > 0) {
                                                const e = w.join('');
                                                w.length = 0;
                                                buildTextContentItem({ chars: e, extraSpacing: 0, isFirstChunk: d });
                                            }
                                            break;
                                        case a.OPS.showText:
                                            if (!i.state.font) {
                                                b.ensureStateFont(i.state);
                                                continue;
                                            }
                                            buildTextContentItem({ chars: m[0], extraSpacing: 0, isFirstChunk: !0 });
                                            break;
                                        case a.OPS.nextLineShowText:
                                            if (!i.state.font) {
                                                b.ensureStateFont(i.state);
                                                continue;
                                            }
                                            g.hasEOL = !0;
                                            flushTextContentItem();
                                            v.carriageReturn();
                                            buildTextContentItem({ chars: m[0], extraSpacing: 0, isFirstChunk: !0 });
                                            break;
                                        case a.OPS.nextLineSetSpacingShowText:
                                            if (!i.state.font) {
                                                b.ensureStateFont(i.state);
                                                continue;
                                            }
                                            g.hasEOL = !0;
                                            flushTextContentItem();
                                            v.wordSpacing = m[0];
                                            v.charSpacing = m[1];
                                            v.carriageReturn();
                                            buildTextContentItem({ chars: m[2], extraSpacing: 0, isFirstChunk: !0 });
                                            break;
                                        case a.OPS.paintXObject:
                                            flushTextContentItem();
                                            S || (S = r.get('XObject') || n.Dict.empty);
                                            var E = m[0].name;
                                            if (E && x.getByName(E)) break;
                                            next(
                                                new Promise(function (e, l) {
                                                    if (!E)
                                                        throw new a.FormatError('XObject must be referred to by name.');
                                                    let d = S.getRaw(E);
                                                    if (d instanceof n.Ref) {
                                                        if (x.getByRef(d)) {
                                                            e();
                                                            return;
                                                        }
                                                        if (b.globalImageCache.getData(d, b.pageIndex)) {
                                                            e();
                                                            return;
                                                        }
                                                        d = y.fetch(d);
                                                    }
                                                    if (!(0, n.isStream)(d))
                                                        throw new a.FormatError('XObject should be a stream');
                                                    const f = d.dict.get('Subtype');
                                                    if (!(0, n.isName)(f))
                                                        throw new a.FormatError('XObject should have a Name subtype');
                                                    if ('Form' !== f.name) {
                                                        x.set(E, d.dict.objId, !0);
                                                        e();
                                                        return;
                                                    }
                                                    const g = i.state.clone(),
                                                        p = new StateManager(g),
                                                        m = d.dict.getArray('Matrix');
                                                    Array.isArray(m) && 6 === m.length && p.transform(m);
                                                    enqueueChunk();
                                                    const w = {
                                                        enqueueInvoked: !1,
                                                        enqueue(e, t) {
                                                            this.enqueueInvoked = !0;
                                                            h.enqueue(e, t);
                                                        },
                                                        get desiredSize() {
                                                            return h.desiredSize;
                                                        },
                                                        get ready() {
                                                            return h.ready;
                                                        },
                                                    };
                                                    b.getTextContent({
                                                        stream: d,
                                                        task: t,
                                                        resources: d.dict.get('Resources') || r,
                                                        stateManager: p,
                                                        normalizeWhitespace: s,
                                                        combineTextItems: o,
                                                        includeMarkedContent: c,
                                                        sink: w,
                                                        seenStyles: u,
                                                    }).then(function () {
                                                        w.enqueueInvoked || x.set(E, d.dict.objId, !0);
                                                        e();
                                                    }, l);
                                                }).catch(function (e) {
                                                    if (!(e instanceof a.AbortException)) {
                                                        if (!b.options.ignoreErrors) throw e;
                                                        (0, a.warn)(`getTextContent - ignoring XObject: "${e}".`);
                                                    }
                                                })
                                            );
                                            return;
                                        case a.OPS.setGState:
                                            if ((E = m[0].name) && k.getByName(E)) break;
                                            next(
                                                new Promise(function (e, t) {
                                                    if (!E)
                                                        throw new a.FormatError('GState must be referred to by name.');
                                                    const i = r.get('ExtGState');
                                                    if (!(i instanceof n.Dict))
                                                        throw new a.FormatError('ExtGState should be a dictionary.');
                                                    const s = i.get(E);
                                                    if (!(s instanceof n.Dict))
                                                        throw new a.FormatError('GState should be a dictionary.');
                                                    const o = s.get('Font');
                                                    if (o) {
                                                        flushTextContentItem();
                                                        v.fontName = null;
                                                        v.fontSize = o[1];
                                                        handleSetFont(null, o[0]).then(e, t);
                                                    } else {
                                                        k.set(E, s.objId, !0);
                                                        e();
                                                    }
                                                }).catch(function (e) {
                                                    if (!(e instanceof a.AbortException)) {
                                                        if (!b.options.ignoreErrors) throw e;
                                                        (0, a.warn)(`getTextContent - ignoring ExtGState: "${e}".`);
                                                    }
                                                })
                                            );
                                            return;
                                        case a.OPS.beginMarkedContent:
                                            c &&
                                                f.items.push({
                                                    type: 'beginMarkedContent',
                                                    tag: (0, n.isName)(m[0]) ? m[0].name : null,
                                                });
                                            break;
                                        case a.OPS.beginMarkedContentProps:
                                            if (c) {
                                                flushTextContentItem();
                                                let e = null;
                                                (0, n.isDict)(m[1]) && (e = m[1].get('MCID'));
                                                f.items.push({
                                                    type: 'beginMarkedContentProps',
                                                    id: Number.isInteger(e)
                                                        ? `${b.idFactory.getPageObjId()}_mcid${e}`
                                                        : null,
                                                    tag: (0, n.isName)(m[0]) ? m[0].name : null,
                                                });
                                            }
                                            break;
                                        case a.OPS.endMarkedContent:
                                            if (c) {
                                                flushTextContentItem();
                                                f.items.push({ type: 'endMarkedContent' });
                                            }
                                    }
                                    if (f.items.length >= h.desiredSize) {
                                        p = !0;
                                        break;
                                    }
                                }
                                if (p) next(M);
                                else {
                                    flushTextContentItem();
                                    enqueueChunk();
                                    e();
                                }
                            }).catch((e) => {
                                if (!(e instanceof a.AbortException)) {
                                    if (!this.options.ignoreErrors) throw e;
                                    (0, a.warn)(`getTextContent - ignoring errors during "${t.name}" task: "${e}".`);
                                    flushTextContentItem();
                                    enqueueChunk();
                                }
                            });
                        }
                        extractDataStructures(e, t, r) {
                            const i = this.xref;
                            let s;
                            const l = this.readToUnicode(r.toUnicode || e.get('ToUnicode') || t.get('ToUnicode'));
                            if (r.composite) {
                                const t = e.get('CIDSystemInfo');
                                (0, n.isDict)(t) &&
                                    (r.cidSystemInfo = {
                                        registry: (0, a.stringToPDFString)(t.get('Registry')),
                                        ordering: (0, a.stringToPDFString)(t.get('Ordering')),
                                        supplement: t.get('Supplement'),
                                    });
                                const i = e.get('CIDToGIDMap');
                                (0, n.isStream)(i) && (s = i.getBytes());
                            }
                            const h = [];
                            let u,
                                d = null;
                            if (e.has('Encoding')) {
                                u = e.get('Encoding');
                                if ((0, n.isDict)(u)) {
                                    d = u.get('BaseEncoding');
                                    d = (0, n.isName)(d) ? d.name : null;
                                    if (u.has('Differences')) {
                                        const e = u.get('Differences');
                                        let t = 0;
                                        for (let r = 0, s = e.length; r < s; r++) {
                                            const s = i.fetchIfRef(e[r]);
                                            if ((0, a.isNum)(s)) t = s;
                                            else {
                                                if (!(0, n.isName)(s))
                                                    throw new a.FormatError(
                                                        `Invalid entry in 'Differences' array: ${s}`
                                                    );
                                                h[t++] = s.name;
                                            }
                                        }
                                    }
                                } else {
                                    if (!(0, n.isName)(u)) throw new a.FormatError('Encoding is not a Name nor a Dict');
                                    d = u.name;
                                }
                                'MacRomanEncoding' !== d &&
                                    'MacExpertEncoding' !== d &&
                                    'WinAnsiEncoding' !== d &&
                                    (d = null);
                            }
                            if (d) r.defaultEncoding = (0, c.getEncoding)(d);
                            else {
                                const e = !!(r.flags & o.FontFlags.Symbolic),
                                    t = !!(r.flags & o.FontFlags.Nonsymbolic);
                                u = c.StandardEncoding;
                                'TrueType' !== r.type || t || (u = c.WinAnsiEncoding);
                                if (e) {
                                    u = c.MacRomanEncoding;
                                    r.file ||
                                        (/Symbol/i.test(r.name)
                                            ? (u = c.SymbolSetEncoding)
                                            : /Dingbats|Wingdings/i.test(r.name) && (u = c.ZapfDingbatsEncoding));
                                }
                                r.defaultEncoding = u;
                            }
                            r.differences = h;
                            r.baseEncodingName = d;
                            r.hasEncoding = !!d || h.length > 0;
                            r.dict = e;
                            return l
                                .then((e) => {
                                    r.toUnicode = e;
                                    return this.buildToUnicode(r);
                                })
                                .then((e) => {
                                    r.toUnicode = e;
                                    s && (r.cidToGidMap = this.readCidToGidMap(s, e));
                                    return r;
                                });
                        }
                        _buildSimpleFontToUnicode(e, t = !1) {
                            (0, a.assert)(!e.composite, 'Must be a simple font.');
                            const r = [],
                                i = e.defaultEncoding.slice(),
                                n = e.baseEncodingName,
                                s = e.differences;
                            for (const e in s) {
                                const t = s[e];
                                '.notdef' !== t && (i[e] = t);
                            }
                            const o = (0, w.getGlyphsUnicode)();
                            for (const a in i) {
                                let s = i[a];
                                if ('' !== s)
                                    if (void 0 !== o[s]) r[a] = String.fromCharCode(o[s]);
                                    else {
                                        let i = 0;
                                        switch (s[0]) {
                                            case 'G':
                                                3 === s.length && (i = parseInt(s.substring(1), 16));
                                                break;
                                            case 'g':
                                                5 === s.length && (i = parseInt(s.substring(1), 16));
                                                break;
                                            case 'C':
                                            case 'c':
                                                if (s.length >= 3 && s.length <= 4) {
                                                    const r = s.substring(1);
                                                    if (t) {
                                                        i = parseInt(r, 16);
                                                        break;
                                                    }
                                                    i = +r;
                                                    if (Number.isNaN(i) && Number.isInteger(parseInt(r, 16)))
                                                        return this._buildSimpleFontToUnicode(e, !0);
                                                }
                                                break;
                                            default:
                                                const r = (0, l.getUnicodeForGlyph)(s, o);
                                                -1 !== r && (i = r);
                                        }
                                        if (i > 0 && i <= 1114111 && Number.isInteger(i)) {
                                            if (n && i === +a) {
                                                const e = (0, c.getEncoding)(n);
                                                if (e && (s = e[a])) {
                                                    r[a] = String.fromCharCode(o[s]);
                                                    continue;
                                                }
                                            }
                                            r[a] = String.fromCodePoint(i);
                                        }
                                    }
                            }
                            return new d.ToUnicodeMap(r);
                        }
                        buildToUnicode(e) {
                            e.hasIncludedToUnicodeMap = !!e.toUnicode && e.toUnicode.length > 0;
                            if (e.hasIncludedToUnicodeMap) {
                                !e.composite &&
                                    e.hasEncoding &&
                                    (e.fallbackToUnicode = this._buildSimpleFontToUnicode(e));
                                return Promise.resolve(e.toUnicode);
                            }
                            if (!e.composite) return Promise.resolve(this._buildSimpleFontToUnicode(e));
                            if (
                                e.composite &&
                                ((e.cMap.builtInCMap && !(e.cMap instanceof i.IdentityCMap)) ||
                                    ('Adobe' === e.cidSystemInfo.registry &&
                                        ('GB1' === e.cidSystemInfo.ordering ||
                                            'CNS1' === e.cidSystemInfo.ordering ||
                                            'Japan1' === e.cidSystemInfo.ordering ||
                                            'Korea1' === e.cidSystemInfo.ordering)))
                            ) {
                                const t = e.cidSystemInfo.registry,
                                    r = e.cidSystemInfo.ordering,
                                    s = n.Name.get(t + '-' + r + '-UCS2');
                                return i.CMapFactory.create({
                                    encoding: s,
                                    fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                                    useCMap: null,
                                }).then(function (t) {
                                    const r = e.cMap,
                                        i = [];
                                    r.forEach(function (e, r) {
                                        if (r > 65535) throw new a.FormatError('Max size of CID is 65,535');
                                        const n = t.lookup(r);
                                        n && (i[e] = String.fromCharCode((n.charCodeAt(0) << 8) + n.charCodeAt(1)));
                                    });
                                    return new d.ToUnicodeMap(i);
                                });
                            }
                            return Promise.resolve(new d.IdentityToUnicodeMap(e.firstChar, e.lastChar));
                        }
                        readToUnicode(e) {
                            return e
                                ? (0, n.isName)(e)
                                    ? i.CMapFactory.create({
                                          encoding: e,
                                          fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                                          useCMap: null,
                                      }).then(function (e) {
                                          return e instanceof i.IdentityCMap
                                              ? new d.IdentityToUnicodeMap(0, 65535)
                                              : new d.ToUnicodeMap(e.getMap());
                                      })
                                    : (0, n.isStream)(e)
                                    ? i.CMapFactory.create({
                                          encoding: e,
                                          fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                                          useCMap: null,
                                      }).then(
                                          function (e) {
                                              if (e instanceof i.IdentityCMap)
                                                  return new d.IdentityToUnicodeMap(0, 65535);
                                              const t = new Array(e.length);
                                              e.forEach(function (e, r) {
                                                  const a = [];
                                                  for (let e = 0; e < r.length; e += 2) {
                                                      const t = (r.charCodeAt(e) << 8) | r.charCodeAt(e + 1);
                                                      if (55296 != (63488 & t)) {
                                                          a.push(t);
                                                          continue;
                                                      }
                                                      e += 2;
                                                      const i = (r.charCodeAt(e) << 8) | r.charCodeAt(e + 1);
                                                      a.push(((1023 & t) << 10) + (1023 & i) + 65536);
                                                  }
                                                  t[e] = String.fromCodePoint.apply(String, a);
                                              });
                                              return new d.ToUnicodeMap(t);
                                          },
                                          (e) => {
                                              if (e instanceof a.AbortException) return null;
                                              if (this.options.ignoreErrors) {
                                                  this.handler.send('UnsupportedFeature', {
                                                      featureId: a.UNSUPPORTED_FEATURES.errorFontToUnicode,
                                                  });
                                                  (0, a.warn)(`readToUnicode - ignoring ToUnicode data: "${e}".`);
                                                  return null;
                                              }
                                              throw e;
                                          }
                                      )
                                    : Promise.resolve(null)
                                : Promise.resolve(null);
                        }
                        readCidToGidMap(e, t) {
                            const r = [];
                            for (let a = 0, i = e.length; a < i; a++) {
                                const i = (e[a++] << 8) | e[a],
                                    n = a >> 1;
                                (0 !== i || t.has(n)) && (r[n] = i);
                            }
                            return r;
                        }
                        extractWidths(e, t, r) {
                            const a = this.xref;
                            let i = [],
                                s = 0;
                            const c = [];
                            let l, h, u, d, f, g, p, m;
                            if (r.composite) {
                                s = e.has('DW') ? e.get('DW') : 1e3;
                                m = e.get('W');
                                if (m)
                                    for (h = 0, u = m.length; h < u; h++) {
                                        g = a.fetchIfRef(m[h++]);
                                        p = a.fetchIfRef(m[h]);
                                        if (Array.isArray(p))
                                            for (d = 0, f = p.length; d < f; d++) i[g++] = a.fetchIfRef(p[d]);
                                        else {
                                            const e = a.fetchIfRef(m[++h]);
                                            for (d = g; d <= p; d++) i[d] = e;
                                        }
                                    }
                                if (r.vertical) {
                                    let t = e.getArray('DW2') || [880, -1e3];
                                    l = [t[1], 0.5 * s, t[0]];
                                    t = e.get('W2');
                                    if (t)
                                        for (h = 0, u = t.length; h < u; h++) {
                                            g = a.fetchIfRef(t[h++]);
                                            p = a.fetchIfRef(t[h]);
                                            if (Array.isArray(p))
                                                for (d = 0, f = p.length; d < f; d++)
                                                    c[g++] = [
                                                        a.fetchIfRef(p[d++]),
                                                        a.fetchIfRef(p[d++]),
                                                        a.fetchIfRef(p[d]),
                                                    ];
                                            else {
                                                const e = [
                                                    a.fetchIfRef(t[++h]),
                                                    a.fetchIfRef(t[++h]),
                                                    a.fetchIfRef(t[++h]),
                                                ];
                                                for (d = g; d <= p; d++) c[d] = e;
                                            }
                                        }
                                }
                            } else {
                                const o = r.firstChar;
                                m = e.get('Widths');
                                if (m) {
                                    d = o;
                                    for (h = 0, u = m.length; h < u; h++) i[d++] = a.fetchIfRef(m[h]);
                                    s = parseFloat(t.get('MissingWidth')) || 0;
                                } else {
                                    const t = e.get('BaseFont');
                                    if ((0, n.isName)(t)) {
                                        const e = this.getBaseFontMetrics(t.name);
                                        i = this.buildCharCodeToWidth(e.widths, r);
                                        s = e.defaultWidth;
                                    }
                                }
                            }
                            let b = !0,
                                y = s;
                            for (const e in i) {
                                const t = i[e];
                                if (t)
                                    if (y) {
                                        if (y !== t) {
                                            b = !1;
                                            break;
                                        }
                                    } else y = t;
                            }
                            b && (r.flags |= o.FontFlags.FixedPitch);
                            r.defaultWidth = s;
                            r.widths = i;
                            r.defaultVMetrics = l;
                            r.vmetrics = c;
                        }
                        isSerifFont(e) {
                            const t = e.split('-')[0];
                            return t in (0, h.getSerifFonts)() || -1 !== t.search(/serif/gi);
                        }
                        getBaseFontMetrics(e) {
                            let t = 0,
                                r = Object.create(null),
                                i = !1;
                            let n = (0, h.getStdFontMap)()[e] || e;
                            const s = (0, x.getMetrics)();
                            n in s || (n = this.isSerifFont(e) ? 'Times-Roman' : 'Helvetica');
                            const o = s[n];
                            if ((0, a.isNum)(o)) {
                                t = o;
                                i = !0;
                            } else r = o();
                            return { defaultWidth: t, monospace: i, widths: r };
                        }
                        buildCharCodeToWidth(e, t) {
                            const r = Object.create(null),
                                a = t.differences,
                                i = t.defaultEncoding;
                            for (let t = 0; t < 256; t++)
                                t in a && e[a[t]] ? (r[t] = e[a[t]]) : t in i && e[i[t]] && (r[t] = e[i[t]]);
                            return r;
                        }
                        preEvaluateFont(e) {
                            const t = e;
                            let r = e.get('Subtype');
                            if (!(0, n.isName)(r)) throw new a.FormatError('invalid font Subtype');
                            let i,
                                s,
                                o = !1;
                            if ('Type0' === r.name) {
                                const t = e.get('DescendantFonts');
                                if (!t) throw new a.FormatError('Descendant fonts are not specified');
                                if (!((e = Array.isArray(t) ? this.xref.fetchIfRef(t[0]) : t) instanceof n.Dict))
                                    throw new a.FormatError('Descendant font is not a dictionary.');
                                r = e.get('Subtype');
                                if (!(0, n.isName)(r)) throw new a.FormatError('invalid font Subtype');
                                o = !0;
                            }
                            const c = e.get('FirstChar') || 0,
                                l = e.get('LastChar') || (o ? 65535 : 255),
                                h = e.get('FontDescriptor');
                            if (h) {
                                i = new k.MurmurHash3_64();
                                const r = t.getRaw('Encoding');
                                if ((0, n.isName)(r)) i.update(r.name);
                                else if ((0, n.isRef)(r)) i.update(r.toString());
                                else if ((0, n.isDict)(r))
                                    for (const e of r.getRawValues())
                                        if ((0, n.isName)(e)) i.update(e.name);
                                        else if ((0, n.isRef)(e)) i.update(e.toString());
                                        else if (Array.isArray(e)) {
                                            const t = e.length,
                                                r = new Array(t);
                                            for (let i = 0; i < t; i++) {
                                                const t = e[i];
                                                (0, n.isName)(t)
                                                    ? (r[i] = t.name)
                                                    : ((0, a.isNum)(t) || (0, n.isRef)(t)) && (r[i] = t.toString());
                                            }
                                            i.update(r.join());
                                        }
                                i.update(`${c}-${l}`);
                                s = e.get('ToUnicode') || t.get('ToUnicode');
                                if ((0, n.isStream)(s)) {
                                    const e = s.str || s,
                                        t = e.buffer
                                            ? new Uint8Array(e.buffer.buffer, 0, e.bufferLength)
                                            : new Uint8Array(e.bytes.buffer, e.start, e.end - e.start);
                                    i.update(t);
                                } else (0, n.isName)(s) && i.update(s.name);
                                const h = e.get('Widths') || t.get('Widths');
                                if (Array.isArray(h)) {
                                    const e = [];
                                    for (const t of h) ((0, a.isNum)(t) || (0, n.isRef)(t)) && e.push(t.toString());
                                    i.update(e.join());
                                }
                                if (o) {
                                    i.update('compositeFont');
                                    const r = e.get('W') || t.get('W');
                                    if (Array.isArray(r)) {
                                        const e = [];
                                        for (const t of r)
                                            if ((0, a.isNum)(t) || (0, n.isRef)(t)) e.push(t.toString());
                                            else if (Array.isArray(t)) {
                                                const r = [];
                                                for (const e of t)
                                                    ((0, a.isNum)(e) || (0, n.isRef)(e)) && r.push(e.toString());
                                                e.push(`[${r.join()}]`);
                                            }
                                        i.update(e.join());
                                    }
                                }
                            }
                            return {
                                descriptor: h,
                                dict: e,
                                baseDict: t,
                                composite: o,
                                type: r.name,
                                firstChar: c,
                                lastChar: l,
                                toUnicode: s,
                                hash: i ? i.hexdigest() : '',
                            };
                        }
                        async translateFont({
                            descriptor: e,
                            dict: t,
                            baseDict: r,
                            composite: c,
                            type: l,
                            firstChar: u,
                            lastChar: d,
                            toUnicode: f,
                            cssFontInfo: g,
                        }) {
                            const p = 'Type3' === l;
                            let m;
                            if (!e) {
                                if (!p) {
                                    let e = t.get('BaseFont');
                                    if (!(0, n.isName)(e)) throw new a.FormatError('Base font is not specified');
                                    e = e.name.replace(/[,_]/g, '-');
                                    const r = this.getBaseFontMetrics(e),
                                        i = e.split('-')[0],
                                        c =
                                            (this.isSerifFont(i) ? o.FontFlags.Serif : 0) |
                                            (r.monospace ? o.FontFlags.FixedPitch : 0) |
                                            ((0, h.getSymbolsFonts)()[i]
                                                ? o.FontFlags.Symbolic
                                                : o.FontFlags.Nonsymbolic);
                                    m = {
                                        type: l,
                                        name: e,
                                        widths: r.widths,
                                        defaultWidth: r.defaultWidth,
                                        flags: c,
                                        firstChar: u,
                                        lastChar: d,
                                        toUnicode: f,
                                        isType3Font: p,
                                    };
                                    const g = t.get('Widths');
                                    return this.extractDataStructures(t, t, m).then((t) => {
                                        if (g) {
                                            const e = [];
                                            let r = u;
                                            for (let t = 0, a = g.length; t < a; t++)
                                                e[r++] = this.xref.fetchIfRef(g[t]);
                                            t.widths = e;
                                        } else t.widths = this.buildCharCodeToWidth(r.widths, t);
                                        return new s.Font(e, null, t);
                                    });
                                }
                                (e = new n.Dict(null)).set('FontName', n.Name.get(l));
                                e.set('FontBBox', t.getArray('FontBBox') || [0, 0, 0, 0]);
                            }
                            let b,
                                y,
                                w,
                                S,
                                x,
                                k = e.get('FontName'),
                                v = t.get('BaseFont');
                            (0, a.isString)(k) && (k = n.Name.get(k));
                            (0, a.isString)(v) && (v = n.Name.get(v));
                            if (!p) {
                                const e = k && k.name,
                                    t = v && v.name;
                                if (e !== t) {
                                    (0, a.info)(
                                        `The FontDescriptor's FontName is "${e}" but should be the same as the Font's BaseFont "${t}".`
                                    );
                                    e && t && t.startsWith(e) && (k = v);
                                }
                            }
                            k = k || v;
                            if (!(0, n.isName)(k)) throw new a.FormatError('invalid font name');
                            try {
                                b = e.get('FontFile', 'FontFile2', 'FontFile3');
                            } catch (e) {
                                if (!this.options.ignoreErrors) throw e;
                                (0, a.warn)(`translateFont - fetching "${k.name}" font file: "${e}".`);
                                b = new C.NullStream();
                            }
                            if (b && b.dict) {
                                const e = b.dict.get('Subtype');
                                e instanceof n.Name && (y = e.name);
                                w = b.dict.get('Length1');
                                S = b.dict.get('Length2');
                                x = b.dict.get('Length3');
                            }
                            m = {
                                type: l,
                                name: k.name,
                                subtype: y,
                                file: b,
                                length1: w,
                                length2: S,
                                length3: x,
                                loadedName: r.loadedName,
                                composite: c,
                                fixedPitch: !1,
                                fontMatrix: t.getArray('FontMatrix') || a.FONT_IDENTITY_MATRIX,
                                firstChar: u,
                                lastChar: d,
                                toUnicode: f,
                                bbox: e.getArray('FontBBox'),
                                ascent: e.get('Ascent'),
                                descent: e.get('Descent'),
                                xHeight: e.get('XHeight'),
                                capHeight: e.get('CapHeight'),
                                flags: e.get('Flags'),
                                italicAngle: e.get('ItalicAngle'),
                                isType3Font: p,
                                cssFontInfo: g,
                            };
                            if (c) {
                                const e = r.get('Encoding');
                                (0, n.isName)(e) && (m.cidEncoding = e.name);
                                const t = await i.CMapFactory.create({
                                    encoding: e,
                                    fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                                    useCMap: null,
                                });
                                m.cMap = t;
                                m.vertical = m.cMap.vertical;
                            }
                            return this.extractDataStructures(t, r, m).then((r) => {
                                this.extractWidths(t, e, r);
                                return new s.Font(k.name, b, r);
                            });
                        }
                        static buildFontPaths(e, t, r, i) {
                            function buildPath(t) {
                                const n = `${e.loadedName}_path_${t}`;
                                try {
                                    if (e.renderer.hasBuiltPath(t)) return;
                                    r.send('commonobj', [n, 'FontPath', e.renderer.getPathJs(t)]);
                                } catch (e) {
                                    if (i.ignoreErrors) {
                                        r.send('UnsupportedFeature', {
                                            featureId: a.UNSUPPORTED_FEATURES.errorFontBuildPath,
                                        });
                                        (0, a.warn)(`buildFontPaths - ignoring ${n} glyph: "${e}".`);
                                        return;
                                    }
                                    throw e;
                                }
                            }
                            for (const e of t) {
                                buildPath(e.fontChar);
                                const t = e.accent;
                                t && t.fontChar && buildPath(t.fontChar);
                            }
                        }
                        static get fallbackFontDict() {
                            const e = new n.Dict();
                            e.set('BaseFont', n.Name.get('PDFJS-FallbackFont'));
                            e.set('Type', n.Name.get('FallbackType'));
                            e.set('Subtype', n.Name.get('FallbackType'));
                            e.set('Encoding', n.Name.get('WinAnsiEncoding'));
                            return (0, a.shadow)(this, 'fallbackFontDict', e);
                        }
                    }
                    t.PartialEvaluator = PartialEvaluator;
                    class TranslatedFont {
                        constructor({ loadedName: e, font: t, dict: r, evaluatorOptions: a }) {
                            this.loadedName = e;
                            this.font = t;
                            this.dict = r;
                            this._evaluatorOptions = a || F;
                            this.type3Loaded = null;
                            this.type3Dependencies = t.isType3Font ? new Set() : null;
                            this.sent = !1;
                        }
                        send(e) {
                            if (!this.sent) {
                                this.sent = !0;
                                e.send('commonobj', [
                                    this.loadedName,
                                    'Font',
                                    this.font.exportData(this._evaluatorOptions.fontExtraProperties),
                                ]);
                            }
                        }
                        fallback(e) {
                            if (this.font.data) {
                                this.font.disableFontFace = !0;
                                PartialEvaluator.buildFontPaths(
                                    this.font,
                                    this.font.glyphCacheValues,
                                    e,
                                    this._evaluatorOptions
                                );
                            }
                        }
                        loadType3Data(e, t, r) {
                            if (this.type3Loaded) return this.type3Loaded;
                            if (!this.font.isType3Font) throw new Error('Must be a Type3 font.');
                            const i = Object.create(e.options);
                            i.ignoreErrors = !1;
                            const n = e.clone(i);
                            n.parsingType3Font = !0;
                            const s = this.font,
                                o = this.type3Dependencies;
                            let c = Promise.resolve();
                            const l = this.dict.get('CharProcs'),
                                h = this.dict.get('Resources') || t,
                                u = Object.create(null);
                            for (const e of l.getKeys())
                                c = c.then(() => {
                                    const t = l.get(e),
                                        i = new v.OperatorList();
                                    return n
                                        .getOperatorList({ stream: t, task: r, resources: h, operatorList: i })
                                        .then(() => {
                                            i.fnArray[0] === a.OPS.setCharWidthAndBounds &&
                                                this._removeType3ColorOperators(i);
                                            u[e] = i.getIR();
                                            for (const e of i.dependencies) o.add(e);
                                        })
                                        .catch(function (t) {
                                            (0, a.warn)(`Type3 font resource "${e}" is not available.`);
                                            const r = new v.OperatorList();
                                            u[e] = r.getIR();
                                        });
                                });
                            this.type3Loaded = c.then(function () {
                                s.charProcOperatorList = u;
                            });
                            return this.type3Loaded;
                        }
                        _removeType3ColorOperators(e) {
                            let t = 1,
                                r = e.length;
                            for (; t < r; ) {
                                switch (e.fnArray[t]) {
                                    case a.OPS.setStrokeColorSpace:
                                    case a.OPS.setFillColorSpace:
                                    case a.OPS.setStrokeColor:
                                    case a.OPS.setStrokeColorN:
                                    case a.OPS.setFillColor:
                                    case a.OPS.setFillColorN:
                                    case a.OPS.setStrokeGray:
                                    case a.OPS.setFillGray:
                                    case a.OPS.setStrokeRGBColor:
                                    case a.OPS.setFillRGBColor:
                                    case a.OPS.setStrokeCMYKColor:
                                    case a.OPS.setFillCMYKColor:
                                    case a.OPS.shadingFill:
                                    case a.OPS.setRenderingIntent:
                                        e.fnArray.splice(t, 1);
                                        e.argsArray.splice(t, 1);
                                        r--;
                                        continue;
                                    case a.OPS.setGState:
                                        const [i] = e.argsArray[t];
                                        let n = 0,
                                            s = i.length;
                                        for (; n < s; ) {
                                            const [e] = i[n];
                                            switch (e) {
                                                case 'TR':
                                                case 'TR2':
                                                case 'HT':
                                                case 'BG':
                                                case 'BG2':
                                                case 'UCR':
                                                case 'UCR2':
                                                    i.splice(n, 1);
                                                    s--;
                                                    continue;
                                            }
                                            n++;
                                        }
                                }
                                t++;
                            }
                        }
                    }
                    class StateManager {
                        constructor(e = new EvalState()) {
                            this.state = e;
                            this.stateStack = [];
                        }
                        save() {
                            const e = this.state;
                            this.stateStack.push(this.state);
                            this.state = e.clone();
                        }
                        restore() {
                            const e = this.stateStack.pop();
                            e && (this.state = e);
                        }
                        transform(e) {
                            this.state.ctm = a.Util.transform(this.state.ctm, e);
                        }
                    }
                    class TextState {
                        constructor() {
                            this.ctm = new Float32Array(a.IDENTITY_MATRIX);
                            this.fontName = null;
                            this.fontSize = 0;
                            this.font = null;
                            this.fontMatrix = a.FONT_IDENTITY_MATRIX;
                            this.textMatrix = a.IDENTITY_MATRIX.slice();
                            this.textLineMatrix = a.IDENTITY_MATRIX.slice();
                            this.charSpacing = 0;
                            this.wordSpacing = 0;
                            this.leading = 0;
                            this.textHScale = 1;
                            this.textRise = 0;
                        }
                        setTextMatrix(e, t, r, a, i, n) {
                            const s = this.textMatrix;
                            s[0] = e;
                            s[1] = t;
                            s[2] = r;
                            s[3] = a;
                            s[4] = i;
                            s[5] = n;
                        }
                        setTextLineMatrix(e, t, r, a, i, n) {
                            const s = this.textLineMatrix;
                            s[0] = e;
                            s[1] = t;
                            s[2] = r;
                            s[3] = a;
                            s[4] = i;
                            s[5] = n;
                        }
                        translateTextMatrix(e, t) {
                            const r = this.textMatrix;
                            r[4] = r[0] * e + r[2] * t + r[4];
                            r[5] = r[1] * e + r[3] * t + r[5];
                        }
                        translateTextLineMatrix(e, t) {
                            const r = this.textLineMatrix;
                            r[4] = r[0] * e + r[2] * t + r[4];
                            r[5] = r[1] * e + r[3] * t + r[5];
                        }
                        carriageReturn() {
                            this.translateTextLineMatrix(0, -this.leading);
                            this.textMatrix = this.textLineMatrix.slice();
                        }
                        clone() {
                            const e = Object.create(this);
                            e.textMatrix = this.textMatrix.slice();
                            e.textLineMatrix = this.textLineMatrix.slice();
                            e.fontMatrix = this.fontMatrix.slice();
                            return e;
                        }
                    }
                    class EvalState {
                        constructor() {
                            this.ctm = new Float32Array(a.IDENTITY_MATRIX);
                            this.font = null;
                            this.textRenderingMode = a.TextRenderingMode.FILL;
                            this.fillColorSpace = b.ColorSpace.singletons.gray;
                            this.strokeColorSpace = b.ColorSpace.singletons.gray;
                        }
                        clone() {
                            return Object.create(this);
                        }
                    }
                    class EvaluatorPreprocessor {
                        static get opMap() {
                            const e = (0, S.getLookupTableFactory)(function (e) {
                                e.w = { id: a.OPS.setLineWidth, numArgs: 1, variableArgs: !1 };
                                e.J = { id: a.OPS.setLineCap, numArgs: 1, variableArgs: !1 };
                                e.j = { id: a.OPS.setLineJoin, numArgs: 1, variableArgs: !1 };
                                e.M = { id: a.OPS.setMiterLimit, numArgs: 1, variableArgs: !1 };
                                e.d = { id: a.OPS.setDash, numArgs: 2, variableArgs: !1 };
                                e.ri = { id: a.OPS.setRenderingIntent, numArgs: 1, variableArgs: !1 };
                                e.i = { id: a.OPS.setFlatness, numArgs: 1, variableArgs: !1 };
                                e.gs = { id: a.OPS.setGState, numArgs: 1, variableArgs: !1 };
                                e.q = { id: a.OPS.save, numArgs: 0, variableArgs: !1 };
                                e.Q = { id: a.OPS.restore, numArgs: 0, variableArgs: !1 };
                                e.cm = { id: a.OPS.transform, numArgs: 6, variableArgs: !1 };
                                e.m = { id: a.OPS.moveTo, numArgs: 2, variableArgs: !1 };
                                e.l = { id: a.OPS.lineTo, numArgs: 2, variableArgs: !1 };
                                e.c = { id: a.OPS.curveTo, numArgs: 6, variableArgs: !1 };
                                e.v = { id: a.OPS.curveTo2, numArgs: 4, variableArgs: !1 };
                                e.y = { id: a.OPS.curveTo3, numArgs: 4, variableArgs: !1 };
                                e.h = { id: a.OPS.closePath, numArgs: 0, variableArgs: !1 };
                                e.re = { id: a.OPS.rectangle, numArgs: 4, variableArgs: !1 };
                                e.S = { id: a.OPS.stroke, numArgs: 0, variableArgs: !1 };
                                e.s = { id: a.OPS.closeStroke, numArgs: 0, variableArgs: !1 };
                                e.f = { id: a.OPS.fill, numArgs: 0, variableArgs: !1 };
                                e.F = { id: a.OPS.fill, numArgs: 0, variableArgs: !1 };
                                e['f*'] = { id: a.OPS.eoFill, numArgs: 0, variableArgs: !1 };
                                e.B = { id: a.OPS.fillStroke, numArgs: 0, variableArgs: !1 };
                                e['B*'] = { id: a.OPS.eoFillStroke, numArgs: 0, variableArgs: !1 };
                                e.b = { id: a.OPS.closeFillStroke, numArgs: 0, variableArgs: !1 };
                                e['b*'] = { id: a.OPS.closeEOFillStroke, numArgs: 0, variableArgs: !1 };
                                e.n = { id: a.OPS.endPath, numArgs: 0, variableArgs: !1 };
                                e.W = { id: a.OPS.clip, numArgs: 0, variableArgs: !1 };
                                e['W*'] = { id: a.OPS.eoClip, numArgs: 0, variableArgs: !1 };
                                e.BT = { id: a.OPS.beginText, numArgs: 0, variableArgs: !1 };
                                e.ET = { id: a.OPS.endText, numArgs: 0, variableArgs: !1 };
                                e.Tc = { id: a.OPS.setCharSpacing, numArgs: 1, variableArgs: !1 };
                                e.Tw = { id: a.OPS.setWordSpacing, numArgs: 1, variableArgs: !1 };
                                e.Tz = { id: a.OPS.setHScale, numArgs: 1, variableArgs: !1 };
                                e.TL = { id: a.OPS.setLeading, numArgs: 1, variableArgs: !1 };
                                e.Tf = { id: a.OPS.setFont, numArgs: 2, variableArgs: !1 };
                                e.Tr = { id: a.OPS.setTextRenderingMode, numArgs: 1, variableArgs: !1 };
                                e.Ts = { id: a.OPS.setTextRise, numArgs: 1, variableArgs: !1 };
                                e.Td = { id: a.OPS.moveText, numArgs: 2, variableArgs: !1 };
                                e.TD = { id: a.OPS.setLeadingMoveText, numArgs: 2, variableArgs: !1 };
                                e.Tm = { id: a.OPS.setTextMatrix, numArgs: 6, variableArgs: !1 };
                                e['T*'] = { id: a.OPS.nextLine, numArgs: 0, variableArgs: !1 };
                                e.Tj = { id: a.OPS.showText, numArgs: 1, variableArgs: !1 };
                                e.TJ = { id: a.OPS.showSpacedText, numArgs: 1, variableArgs: !1 };
                                e["'"] = { id: a.OPS.nextLineShowText, numArgs: 1, variableArgs: !1 };
                                e['"'] = { id: a.OPS.nextLineSetSpacingShowText, numArgs: 3, variableArgs: !1 };
                                e.d0 = { id: a.OPS.setCharWidth, numArgs: 2, variableArgs: !1 };
                                e.d1 = { id: a.OPS.setCharWidthAndBounds, numArgs: 6, variableArgs: !1 };
                                e.CS = { id: a.OPS.setStrokeColorSpace, numArgs: 1, variableArgs: !1 };
                                e.cs = { id: a.OPS.setFillColorSpace, numArgs: 1, variableArgs: !1 };
                                e.SC = { id: a.OPS.setStrokeColor, numArgs: 4, variableArgs: !0 };
                                e.SCN = { id: a.OPS.setStrokeColorN, numArgs: 33, variableArgs: !0 };
                                e.sc = { id: a.OPS.setFillColor, numArgs: 4, variableArgs: !0 };
                                e.scn = { id: a.OPS.setFillColorN, numArgs: 33, variableArgs: !0 };
                                e.G = { id: a.OPS.setStrokeGray, numArgs: 1, variableArgs: !1 };
                                e.g = { id: a.OPS.setFillGray, numArgs: 1, variableArgs: !1 };
                                e.RG = { id: a.OPS.setStrokeRGBColor, numArgs: 3, variableArgs: !1 };
                                e.rg = { id: a.OPS.setFillRGBColor, numArgs: 3, variableArgs: !1 };
                                e.K = { id: a.OPS.setStrokeCMYKColor, numArgs: 4, variableArgs: !1 };
                                e.k = { id: a.OPS.setFillCMYKColor, numArgs: 4, variableArgs: !1 };
                                e.sh = { id: a.OPS.shadingFill, numArgs: 1, variableArgs: !1 };
                                e.BI = { id: a.OPS.beginInlineImage, numArgs: 0, variableArgs: !1 };
                                e.ID = { id: a.OPS.beginImageData, numArgs: 0, variableArgs: !1 };
                                e.EI = { id: a.OPS.endInlineImage, numArgs: 1, variableArgs: !1 };
                                e.Do = { id: a.OPS.paintXObject, numArgs: 1, variableArgs: !1 };
                                e.MP = { id: a.OPS.markPoint, numArgs: 1, variableArgs: !1 };
                                e.DP = { id: a.OPS.markPointProps, numArgs: 2, variableArgs: !1 };
                                e.BMC = { id: a.OPS.beginMarkedContent, numArgs: 1, variableArgs: !1 };
                                e.BDC = { id: a.OPS.beginMarkedContentProps, numArgs: 2, variableArgs: !1 };
                                e.EMC = { id: a.OPS.endMarkedContent, numArgs: 0, variableArgs: !1 };
                                e.BX = { id: a.OPS.beginCompat, numArgs: 0, variableArgs: !1 };
                                e.EX = { id: a.OPS.endCompat, numArgs: 0, variableArgs: !1 };
                                e.BM = null;
                                e.BD = null;
                                e.true = null;
                                e.fa = null;
                                e.fal = null;
                                e.fals = null;
                                e.false = null;
                                e.nu = null;
                                e.nul = null;
                                e.null = null;
                            });
                            return (0, a.shadow)(this, 'opMap', e());
                        }
                        static get MAX_INVALID_PATH_OPS() {
                            return (0, a.shadow)(this, 'MAX_INVALID_PATH_OPS', 20);
                        }
                        constructor(e, t, r = new StateManager()) {
                            this.parser = new g.Parser({ lexer: new g.Lexer(e, EvaluatorPreprocessor.opMap), xref: t });
                            this.stateManager = r;
                            this.nonProcessedArgs = [];
                            this._numInvalidPathOPS = 0;
                        }
                        get savedStatesDepth() {
                            return this.stateManager.stateStack.length;
                        }
                        read(e) {
                            let t = e.args;
                            for (;;) {
                                const r = this.parser.getObj();
                                if (r instanceof n.Cmd) {
                                    const i = r.cmd,
                                        n = EvaluatorPreprocessor.opMap[i];
                                    if (!n) {
                                        (0, a.warn)(`Unknown command "${i}".`);
                                        continue;
                                    }
                                    const s = n.id,
                                        o = n.numArgs;
                                    let c = null !== t ? t.length : 0;
                                    if (n.variableArgs)
                                        c > o &&
                                            (0, a.info)(
                                                `Command ${i}: expected [0, ${o}] args, but received ${c} args.`
                                            );
                                    else {
                                        if (c !== o) {
                                            const e = this.nonProcessedArgs;
                                            for (; c > o; ) {
                                                e.push(t.shift());
                                                c--;
                                            }
                                            for (; c < o && 0 !== e.length; ) {
                                                null === t && (t = []);
                                                t.unshift(e.pop());
                                                c++;
                                            }
                                        }
                                        if (c < o) {
                                            const e = `command ${i}: expected ${o} args, but received ${c} args.`;
                                            if (
                                                s >= a.OPS.moveTo &&
                                                s <= a.OPS.endPath &&
                                                ++this._numInvalidPathOPS > EvaluatorPreprocessor.MAX_INVALID_PATH_OPS
                                            )
                                                throw new a.FormatError(`Invalid ${e}`);
                                            (0, a.warn)(`Skipping ${e}`);
                                            null !== t && (t.length = 0);
                                            continue;
                                        }
                                    }
                                    this.preprocessCommand(s, t);
                                    e.fn = s;
                                    e.args = t;
                                    return !0;
                                }
                                if (r === n.EOF) return !1;
                                if (null !== r) {
                                    null === t && (t = []);
                                    t.push(r);
                                    if (t.length > 33) throw new a.FormatError('Too many arguments');
                                }
                            }
                        }
                        preprocessCommand(e, t) {
                            switch (0 | e) {
                                case a.OPS.save:
                                    this.stateManager.save();
                                    break;
                                case a.OPS.restore:
                                    this.stateManager.restore();
                                    break;
                                case a.OPS.transform:
                                    this.stateManager.transform(t);
                            }
                        }
                    }
                    t.EvaluatorPreprocessor = EvaluatorPreprocessor;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.IdentityCMap = t.CMapFactory = t.CMap = void 0;
                    var a = r(2),
                        i = r(5),
                        n = r(17),
                        s = r(9),
                        o = r(10);
                    const c = [
                            'Adobe-GB1-UCS2',
                            'Adobe-CNS1-UCS2',
                            'Adobe-Japan1-UCS2',
                            'Adobe-Korea1-UCS2',
                            '78-EUC-H',
                            '78-EUC-V',
                            '78-H',
                            '78-RKSJ-H',
                            '78-RKSJ-V',
                            '78-V',
                            '78ms-RKSJ-H',
                            '78ms-RKSJ-V',
                            '83pv-RKSJ-H',
                            '90ms-RKSJ-H',
                            '90ms-RKSJ-V',
                            '90msp-RKSJ-H',
                            '90msp-RKSJ-V',
                            '90pv-RKSJ-H',
                            '90pv-RKSJ-V',
                            'Add-H',
                            'Add-RKSJ-H',
                            'Add-RKSJ-V',
                            'Add-V',
                            'Adobe-CNS1-0',
                            'Adobe-CNS1-1',
                            'Adobe-CNS1-2',
                            'Adobe-CNS1-3',
                            'Adobe-CNS1-4',
                            'Adobe-CNS1-5',
                            'Adobe-CNS1-6',
                            'Adobe-GB1-0',
                            'Adobe-GB1-1',
                            'Adobe-GB1-2',
                            'Adobe-GB1-3',
                            'Adobe-GB1-4',
                            'Adobe-GB1-5',
                            'Adobe-Japan1-0',
                            'Adobe-Japan1-1',
                            'Adobe-Japan1-2',
                            'Adobe-Japan1-3',
                            'Adobe-Japan1-4',
                            'Adobe-Japan1-5',
                            'Adobe-Japan1-6',
                            'Adobe-Korea1-0',
                            'Adobe-Korea1-1',
                            'Adobe-Korea1-2',
                            'B5-H',
                            'B5-V',
                            'B5pc-H',
                            'B5pc-V',
                            'CNS-EUC-H',
                            'CNS-EUC-V',
                            'CNS1-H',
                            'CNS1-V',
                            'CNS2-H',
                            'CNS2-V',
                            'ETHK-B5-H',
                            'ETHK-B5-V',
                            'ETen-B5-H',
                            'ETen-B5-V',
                            'ETenms-B5-H',
                            'ETenms-B5-V',
                            'EUC-H',
                            'EUC-V',
                            'Ext-H',
                            'Ext-RKSJ-H',
                            'Ext-RKSJ-V',
                            'Ext-V',
                            'GB-EUC-H',
                            'GB-EUC-V',
                            'GB-H',
                            'GB-V',
                            'GBK-EUC-H',
                            'GBK-EUC-V',
                            'GBK2K-H',
                            'GBK2K-V',
                            'GBKp-EUC-H',
                            'GBKp-EUC-V',
                            'GBT-EUC-H',
                            'GBT-EUC-V',
                            'GBT-H',
                            'GBT-V',
                            'GBTpc-EUC-H',
                            'GBTpc-EUC-V',
                            'GBpc-EUC-H',
                            'GBpc-EUC-V',
                            'H',
                            'HKdla-B5-H',
                            'HKdla-B5-V',
                            'HKdlb-B5-H',
                            'HKdlb-B5-V',
                            'HKgccs-B5-H',
                            'HKgccs-B5-V',
                            'HKm314-B5-H',
                            'HKm314-B5-V',
                            'HKm471-B5-H',
                            'HKm471-B5-V',
                            'HKscs-B5-H',
                            'HKscs-B5-V',
                            'Hankaku',
                            'Hiragana',
                            'KSC-EUC-H',
                            'KSC-EUC-V',
                            'KSC-H',
                            'KSC-Johab-H',
                            'KSC-Johab-V',
                            'KSC-V',
                            'KSCms-UHC-H',
                            'KSCms-UHC-HW-H',
                            'KSCms-UHC-HW-V',
                            'KSCms-UHC-V',
                            'KSCpc-EUC-H',
                            'KSCpc-EUC-V',
                            'Katakana',
                            'NWP-H',
                            'NWP-V',
                            'RKSJ-H',
                            'RKSJ-V',
                            'Roman',
                            'UniCNS-UCS2-H',
                            'UniCNS-UCS2-V',
                            'UniCNS-UTF16-H',
                            'UniCNS-UTF16-V',
                            'UniCNS-UTF32-H',
                            'UniCNS-UTF32-V',
                            'UniCNS-UTF8-H',
                            'UniCNS-UTF8-V',
                            'UniGB-UCS2-H',
                            'UniGB-UCS2-V',
                            'UniGB-UTF16-H',
                            'UniGB-UTF16-V',
                            'UniGB-UTF32-H',
                            'UniGB-UTF32-V',
                            'UniGB-UTF8-H',
                            'UniGB-UTF8-V',
                            'UniJIS-UCS2-H',
                            'UniJIS-UCS2-HW-H',
                            'UniJIS-UCS2-HW-V',
                            'UniJIS-UCS2-V',
                            'UniJIS-UTF16-H',
                            'UniJIS-UTF16-V',
                            'UniJIS-UTF32-H',
                            'UniJIS-UTF32-V',
                            'UniJIS-UTF8-H',
                            'UniJIS-UTF8-V',
                            'UniJIS2004-UTF16-H',
                            'UniJIS2004-UTF16-V',
                            'UniJIS2004-UTF32-H',
                            'UniJIS2004-UTF32-V',
                            'UniJIS2004-UTF8-H',
                            'UniJIS2004-UTF8-V',
                            'UniJISPro-UCS2-HW-V',
                            'UniJISPro-UCS2-V',
                            'UniJISPro-UTF8-V',
                            'UniJISX0213-UTF32-H',
                            'UniJISX0213-UTF32-V',
                            'UniJISX02132004-UTF32-H',
                            'UniJISX02132004-UTF32-V',
                            'UniKS-UCS2-H',
                            'UniKS-UCS2-V',
                            'UniKS-UTF16-H',
                            'UniKS-UTF16-V',
                            'UniKS-UTF32-H',
                            'UniKS-UTF32-V',
                            'UniKS-UTF8-H',
                            'UniKS-UTF8-V',
                            'V',
                            'WP-Symbol',
                        ],
                        l = 2 ** 24 - 1;
                    class CMap {
                        constructor(e = !1) {
                            this.codespaceRanges = [[], [], [], []];
                            this.numCodespaceRanges = 0;
                            this._map = [];
                            this.name = '';
                            this.vertical = !1;
                            this.useCMap = null;
                            this.builtInCMap = e;
                        }
                        addCodespaceRange(e, t, r) {
                            this.codespaceRanges[e - 1].push(t, r);
                            this.numCodespaceRanges++;
                        }
                        mapCidRange(e, t, r) {
                            if (t - e > l) throw new Error('mapCidRange - ignoring data above MAX_MAP_RANGE.');
                            for (; e <= t; ) this._map[e++] = r++;
                        }
                        mapBfRange(e, t, r) {
                            if (t - e > l) throw new Error('mapBfRange - ignoring data above MAX_MAP_RANGE.');
                            const a = r.length - 1;
                            for (; e <= t; ) {
                                this._map[e++] = r;
                                r = r.substring(0, a) + String.fromCharCode(r.charCodeAt(a) + 1);
                            }
                        }
                        mapBfRangeToArray(e, t, r) {
                            if (t - e > l) throw new Error('mapBfRangeToArray - ignoring data above MAX_MAP_RANGE.');
                            const a = r.length;
                            let i = 0;
                            for (; e <= t && i < a; ) {
                                this._map[e] = r[i++];
                                ++e;
                            }
                        }
                        mapOne(e, t) {
                            this._map[e] = t;
                        }
                        lookup(e) {
                            return this._map[e];
                        }
                        contains(e) {
                            return void 0 !== this._map[e];
                        }
                        forEach(e) {
                            const t = this._map,
                                r = t.length;
                            if (r <= 65536) for (let a = 0; a < r; a++) void 0 !== t[a] && e(a, t[a]);
                            else for (const r in t) e(r, t[r]);
                        }
                        charCodeOf(e) {
                            const t = this._map;
                            if (t.length <= 65536) return t.indexOf(e);
                            for (const r in t) if (t[r] === e) return 0 | r;
                            return -1;
                        }
                        getMap() {
                            return this._map;
                        }
                        readCharCode(e, t, r) {
                            let a = 0;
                            const i = this.codespaceRanges;
                            for (let n = 0, s = i.length; n < s; n++) {
                                a = ((a << 8) | e.charCodeAt(t + n)) >>> 0;
                                const s = i[n];
                                for (let e = 0, t = s.length; e < t; ) {
                                    const t = s[e++],
                                        i = s[e++];
                                    if (a >= t && a <= i) {
                                        r.charcode = a;
                                        r.length = n + 1;
                                        return;
                                    }
                                }
                            }
                            r.charcode = 0;
                            r.length = 1;
                        }
                        getCharCodeLength(e) {
                            const t = this.codespaceRanges;
                            for (let r = 0, a = t.length; r < a; r++) {
                                const a = t[r];
                                for (let t = 0, i = a.length; t < i; ) {
                                    const i = a[t++],
                                        n = a[t++];
                                    if (e >= i && e <= n) return r + 1;
                                }
                            }
                            return 1;
                        }
                        get length() {
                            return this._map.length;
                        }
                        get isIdentityCMap() {
                            if ('Identity-H' !== this.name && 'Identity-V' !== this.name) return !1;
                            if (65536 !== this._map.length) return !1;
                            for (let e = 0; e < 65536; e++) if (this._map[e] !== e) return !1;
                            return !0;
                        }
                    }
                    t.CMap = CMap;
                    class IdentityCMap extends CMap {
                        constructor(e, t) {
                            super();
                            this.vertical = e;
                            this.addCodespaceRange(t, 0, 65535);
                        }
                        mapCidRange(e, t, r) {
                            (0, a.unreachable)('should not call mapCidRange');
                        }
                        mapBfRange(e, t, r) {
                            (0, a.unreachable)('should not call mapBfRange');
                        }
                        mapBfRangeToArray(e, t, r) {
                            (0, a.unreachable)('should not call mapBfRangeToArray');
                        }
                        mapOne(e, t) {
                            (0, a.unreachable)('should not call mapCidOne');
                        }
                        lookup(e) {
                            return Number.isInteger(e) && e <= 65535 ? e : void 0;
                        }
                        contains(e) {
                            return Number.isInteger(e) && e <= 65535;
                        }
                        forEach(e) {
                            for (let t = 0; t <= 65535; t++) e(t, t);
                        }
                        charCodeOf(e) {
                            return Number.isInteger(e) && e <= 65535 ? e : -1;
                        }
                        getMap() {
                            const e = new Array(65536);
                            for (let t = 0; t <= 65535; t++) e[t] = t;
                            return e;
                        }
                        get length() {
                            return 65536;
                        }
                        get isIdentityCMap() {
                            (0, a.unreachable)('should not access .isIdentityCMap');
                        }
                    }
                    t.IdentityCMap = IdentityCMap;
                    const h = (function BinaryCMapReaderClosure() {
                            function hexToInt(e, t) {
                                let r = 0;
                                for (let a = 0; a <= t; a++) r = (r << 8) | e[a];
                                return r >>> 0;
                            }
                            function hexToStr(e, t) {
                                return 1 === t
                                    ? String.fromCharCode(e[0], e[1])
                                    : 3 === t
                                    ? String.fromCharCode(e[0], e[1], e[2], e[3])
                                    : String.fromCharCode.apply(null, e.subarray(0, t + 1));
                            }
                            function addHex(e, t, r) {
                                let a = 0;
                                for (let i = r; i >= 0; i--) {
                                    a += e[i] + t[i];
                                    e[i] = 255 & a;
                                    a >>= 8;
                                }
                            }
                            function incHex(e, t) {
                                let r = 1;
                                for (let a = t; a >= 0 && r > 0; a--) {
                                    r += e[a];
                                    e[a] = 255 & r;
                                    r >>= 8;
                                }
                            }
                            const e = 16;
                            class BinaryCMapStream {
                                constructor(e) {
                                    this.buffer = e;
                                    this.pos = 0;
                                    this.end = e.length;
                                    this.tmpBuf = new Uint8Array(19);
                                }
                                readByte() {
                                    return this.pos >= this.end ? -1 : this.buffer[this.pos++];
                                }
                                readNumber() {
                                    let e,
                                        t = 0;
                                    do {
                                        const r = this.readByte();
                                        if (r < 0) throw new a.FormatError('unexpected EOF in bcmap');
                                        e = !(128 & r);
                                        t = (t << 7) | (127 & r);
                                    } while (!e);
                                    return t;
                                }
                                readSigned() {
                                    const e = this.readNumber();
                                    return 1 & e ? ~(e >>> 1) : e >>> 1;
                                }
                                readHex(e, t) {
                                    e.set(this.buffer.subarray(this.pos, this.pos + t + 1));
                                    this.pos += t + 1;
                                }
                                readHexNumber(e, t) {
                                    let r;
                                    const i = this.tmpBuf;
                                    let n = 0;
                                    do {
                                        const e = this.readByte();
                                        if (e < 0) throw new a.FormatError('unexpected EOF in bcmap');
                                        r = !(128 & e);
                                        i[n++] = 127 & e;
                                    } while (!r);
                                    let s = t,
                                        o = 0,
                                        c = 0;
                                    for (; s >= 0; ) {
                                        for (; c < 8 && i.length > 0; ) {
                                            o = (i[--n] << c) | o;
                                            c += 7;
                                        }
                                        e[s] = 255 & o;
                                        s--;
                                        o >>= 8;
                                        c -= 8;
                                    }
                                }
                                readHexSigned(e, t) {
                                    this.readHexNumber(e, t);
                                    const r = 1 & e[t] ? 255 : 0;
                                    let a = 0;
                                    for (let i = 0; i <= t; i++) {
                                        a = ((1 & a) << 8) | e[i];
                                        e[i] = (a >> 1) ^ r;
                                    }
                                }
                                readString() {
                                    const e = this.readNumber();
                                    let t = '';
                                    for (let r = 0; r < e; r++) t += String.fromCharCode(this.readNumber());
                                    return t;
                                }
                            }
                            return class BinaryCMapReader {
                                async process(t, r, a) {
                                    const i = new BinaryCMapStream(t),
                                        n = i.readByte();
                                    r.vertical = !!(1 & n);
                                    let s = null;
                                    const o = new Uint8Array(e),
                                        c = new Uint8Array(e),
                                        l = new Uint8Array(e),
                                        h = new Uint8Array(e),
                                        u = new Uint8Array(e);
                                    let d, f;
                                    for (; (f = i.readByte()) >= 0; ) {
                                        const t = f >> 5;
                                        if (7 === t) {
                                            switch (31 & f) {
                                                case 0:
                                                    i.readString();
                                                    break;
                                                case 1:
                                                    s = i.readString();
                                            }
                                            continue;
                                        }
                                        const a = !!(16 & f),
                                            n = 15 & f;
                                        if (n + 1 > e) throw new Error('BinaryCMapReader.process: Invalid dataSize.');
                                        const g = 1,
                                            p = i.readNumber();
                                        switch (t) {
                                            case 0:
                                                i.readHex(o, n);
                                                i.readHexNumber(c, n);
                                                addHex(c, o, n);
                                                r.addCodespaceRange(n + 1, hexToInt(o, n), hexToInt(c, n));
                                                for (let e = 1; e < p; e++) {
                                                    incHex(c, n);
                                                    i.readHexNumber(o, n);
                                                    addHex(o, c, n);
                                                    i.readHexNumber(c, n);
                                                    addHex(c, o, n);
                                                    r.addCodespaceRange(n + 1, hexToInt(o, n), hexToInt(c, n));
                                                }
                                                break;
                                            case 1:
                                                i.readHex(o, n);
                                                i.readHexNumber(c, n);
                                                addHex(c, o, n);
                                                i.readNumber();
                                                for (let e = 1; e < p; e++) {
                                                    incHex(c, n);
                                                    i.readHexNumber(o, n);
                                                    addHex(o, c, n);
                                                    i.readHexNumber(c, n);
                                                    addHex(c, o, n);
                                                    i.readNumber();
                                                }
                                                break;
                                            case 2:
                                                i.readHex(l, n);
                                                d = i.readNumber();
                                                r.mapOne(hexToInt(l, n), d);
                                                for (let e = 1; e < p; e++) {
                                                    incHex(l, n);
                                                    if (!a) {
                                                        i.readHexNumber(u, n);
                                                        addHex(l, u, n);
                                                    }
                                                    d = i.readSigned() + (d + 1);
                                                    r.mapOne(hexToInt(l, n), d);
                                                }
                                                break;
                                            case 3:
                                                i.readHex(o, n);
                                                i.readHexNumber(c, n);
                                                addHex(c, o, n);
                                                d = i.readNumber();
                                                r.mapCidRange(hexToInt(o, n), hexToInt(c, n), d);
                                                for (let e = 1; e < p; e++) {
                                                    incHex(c, n);
                                                    if (a) o.set(c);
                                                    else {
                                                        i.readHexNumber(o, n);
                                                        addHex(o, c, n);
                                                    }
                                                    i.readHexNumber(c, n);
                                                    addHex(c, o, n);
                                                    d = i.readNumber();
                                                    r.mapCidRange(hexToInt(o, n), hexToInt(c, n), d);
                                                }
                                                break;
                                            case 4:
                                                i.readHex(l, g);
                                                i.readHex(h, n);
                                                r.mapOne(hexToInt(l, g), hexToStr(h, n));
                                                for (let e = 1; e < p; e++) {
                                                    incHex(l, g);
                                                    if (!a) {
                                                        i.readHexNumber(u, g);
                                                        addHex(l, u, g);
                                                    }
                                                    incHex(h, n);
                                                    i.readHexSigned(u, n);
                                                    addHex(h, u, n);
                                                    r.mapOne(hexToInt(l, g), hexToStr(h, n));
                                                }
                                                break;
                                            case 5:
                                                i.readHex(o, g);
                                                i.readHexNumber(c, g);
                                                addHex(c, o, g);
                                                i.readHex(h, n);
                                                r.mapBfRange(hexToInt(o, g), hexToInt(c, g), hexToStr(h, n));
                                                for (let e = 1; e < p; e++) {
                                                    incHex(c, g);
                                                    if (a) o.set(c);
                                                    else {
                                                        i.readHexNumber(o, g);
                                                        addHex(o, c, g);
                                                    }
                                                    i.readHexNumber(c, g);
                                                    addHex(c, o, g);
                                                    i.readHex(h, n);
                                                    r.mapBfRange(hexToInt(o, g), hexToInt(c, g), hexToStr(h, n));
                                                }
                                                break;
                                            default:
                                                throw new Error(`BinaryCMapReader.process - unknown type: ${t}`);
                                        }
                                    }
                                    return s ? a(s) : r;
                                }
                            };
                        })(),
                        u = (function CMapFactoryClosure() {
                            function strToInt(e) {
                                let t = 0;
                                for (let r = 0; r < e.length; r++) t = (t << 8) | e.charCodeAt(r);
                                return t >>> 0;
                            }
                            function expectString(e) {
                                if (!(0, a.isString)(e)) throw new a.FormatError('Malformed CMap: expected string.');
                            }
                            function expectInt(e) {
                                if (!Number.isInteger(e)) throw new a.FormatError('Malformed CMap: expected int.');
                            }
                            function parseBfChar(e, t) {
                                for (;;) {
                                    let r = t.getObj();
                                    if ((0, i.isEOF)(r)) break;
                                    if ((0, i.isCmd)(r, 'endbfchar')) return;
                                    expectString(r);
                                    const a = strToInt(r);
                                    r = t.getObj();
                                    expectString(r);
                                    const n = r;
                                    e.mapOne(a, n);
                                }
                            }
                            function parseBfRange(e, t) {
                                for (;;) {
                                    let r = t.getObj();
                                    if ((0, i.isEOF)(r)) break;
                                    if ((0, i.isCmd)(r, 'endbfrange')) return;
                                    expectString(r);
                                    const n = strToInt(r);
                                    r = t.getObj();
                                    expectString(r);
                                    const s = strToInt(r);
                                    r = t.getObj();
                                    if (Number.isInteger(r) || (0, a.isString)(r)) {
                                        const t = Number.isInteger(r) ? String.fromCharCode(r) : r;
                                        e.mapBfRange(n, s, t);
                                    } else {
                                        if (!(0, i.isCmd)(r, '[')) break;
                                        {
                                            r = t.getObj();
                                            const a = [];
                                            for (; !(0, i.isCmd)(r, ']') && !(0, i.isEOF)(r); ) {
                                                a.push(r);
                                                r = t.getObj();
                                            }
                                            e.mapBfRangeToArray(n, s, a);
                                        }
                                    }
                                }
                                throw new a.FormatError('Invalid bf range.');
                            }
                            function parseCidChar(e, t) {
                                for (;;) {
                                    let r = t.getObj();
                                    if ((0, i.isEOF)(r)) break;
                                    if ((0, i.isCmd)(r, 'endcidchar')) return;
                                    expectString(r);
                                    const a = strToInt(r);
                                    r = t.getObj();
                                    expectInt(r);
                                    const n = r;
                                    e.mapOne(a, n);
                                }
                            }
                            function parseCidRange(e, t) {
                                for (;;) {
                                    let r = t.getObj();
                                    if ((0, i.isEOF)(r)) break;
                                    if ((0, i.isCmd)(r, 'endcidrange')) return;
                                    expectString(r);
                                    const a = strToInt(r);
                                    r = t.getObj();
                                    expectString(r);
                                    const n = strToInt(r);
                                    r = t.getObj();
                                    expectInt(r);
                                    const s = r;
                                    e.mapCidRange(a, n, s);
                                }
                            }
                            function parseCodespaceRange(e, t) {
                                for (;;) {
                                    let r = t.getObj();
                                    if ((0, i.isEOF)(r)) break;
                                    if ((0, i.isCmd)(r, 'endcodespacerange')) return;
                                    if (!(0, a.isString)(r)) break;
                                    const n = strToInt(r);
                                    r = t.getObj();
                                    if (!(0, a.isString)(r)) break;
                                    const s = strToInt(r);
                                    e.addCodespaceRange(r.length, n, s);
                                }
                                throw new a.FormatError('Invalid codespace range.');
                            }
                            function parseWMode(e, t) {
                                const r = t.getObj();
                                Number.isInteger(r) && (e.vertical = !!r);
                            }
                            function parseCMapName(e, t) {
                                const r = t.getObj();
                                (0, i.isName)(r) && (0, a.isString)(r.name) && (e.name = r.name);
                            }
                            async function parseCMap(e, t, r, n) {
                                let o, c;
                                e: for (;;)
                                    try {
                                        const r = t.getObj();
                                        if ((0, i.isEOF)(r)) break;
                                        if ((0, i.isName)(r)) {
                                            'WMode' === r.name
                                                ? parseWMode(e, t)
                                                : 'CMapName' === r.name && parseCMapName(e, t);
                                            o = r;
                                        } else if ((0, i.isCmd)(r))
                                            switch (r.cmd) {
                                                case 'endcmap':
                                                    break e;
                                                case 'usecmap':
                                                    (0, i.isName)(o) && (c = o.name);
                                                    break;
                                                case 'begincodespacerange':
                                                    parseCodespaceRange(e, t);
                                                    break;
                                                case 'beginbfchar':
                                                    parseBfChar(e, t);
                                                    break;
                                                case 'begincidchar':
                                                    parseCidChar(e, t);
                                                    break;
                                                case 'beginbfrange':
                                                    parseBfRange(e, t);
                                                    break;
                                                case 'begincidrange':
                                                    parseCidRange(e, t);
                                            }
                                    } catch (e) {
                                        if (e instanceof s.MissingDataException) throw e;
                                        (0, a.warn)('Invalid cMap data: ' + e);
                                        continue;
                                    }
                                !n && c && (n = c);
                                return n ? extendCMap(e, r, n) : e;
                            }
                            async function extendCMap(e, t, r) {
                                e.useCMap = await createBuiltInCMap(r, t);
                                if (0 === e.numCodespaceRanges) {
                                    const t = e.useCMap.codespaceRanges;
                                    for (let r = 0; r < t.length; r++) e.codespaceRanges[r] = t[r].slice();
                                    e.numCodespaceRanges = e.useCMap.numCodespaceRanges;
                                }
                                e.useCMap.forEach(function (t, r) {
                                    e.contains(t) || e.mapOne(t, e.useCMap.lookup(t));
                                });
                                return e;
                            }
                            async function createBuiltInCMap(e, t) {
                                if ('Identity-H' === e) return new IdentityCMap(!1, 2);
                                if ('Identity-V' === e) return new IdentityCMap(!0, 2);
                                if (!c.includes(e)) throw new Error('Unknown CMap name: ' + e);
                                if (!t) throw new Error('Built-in CMap parameters are not provided.');
                                const { cMapData: r, compressionType: i } = await t(e),
                                    s = new CMap(!0);
                                if (i === a.CMapCompressionType.BINARY)
                                    return new h().process(r, s, (e) => extendCMap(s, t, e));
                                if (i === a.CMapCompressionType.NONE) {
                                    const e = new n.Lexer(new o.Stream(r));
                                    return parseCMap(s, e, t, null);
                                }
                                throw new Error('TODO: Only BINARY/NONE CMap compression is currently supported.');
                            }
                            return {
                                async create(e) {
                                    const t = e.encoding,
                                        r = e.fetchBuiltInCMap,
                                        a = e.useCMap;
                                    if ((0, i.isName)(t)) return createBuiltInCMap(t.name, r);
                                    if ((0, i.isStream)(t)) {
                                        const e = await parseCMap(new CMap(), new n.Lexer(t), r, a);
                                        return e.isIdentityCMap ? createBuiltInCMap(e.name, r) : e;
                                    }
                                    throw new Error('Encoding required.');
                                },
                            };
                        })();
                    t.CMapFactory = u;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.Parser = t.Linearization = t.Lexer = void 0;
                    var a = r(2),
                        i = r(5),
                        n = r(9),
                        s = r(18),
                        o = r(20),
                        c = r(21),
                        l = r(23),
                        h = r(24),
                        u = r(27),
                        d = r(29),
                        f = r(31),
                        g = r(10),
                        p = r(32),
                        m = r(33);
                    function computeAdler32(e) {
                        const t = e.length;
                        let r = 1,
                            a = 0;
                        for (let i = 0; i < t; ++i) {
                            r += 255 & e[i];
                            a += r;
                        }
                        return (a % 65521 << 16) | r % 65521;
                    }
                    class Parser {
                        constructor({ lexer: e, xref: t, allowStreams: r = !1, recoveryMode: a = !1 }) {
                            this.lexer = e;
                            this.xref = t;
                            this.allowStreams = r;
                            this.recoveryMode = a;
                            this.imageCache = Object.create(null);
                            this.refill();
                        }
                        refill() {
                            this.buf1 = this.lexer.getObj();
                            this.buf2 = this.lexer.getObj();
                        }
                        shift() {
                            if (this.buf2 instanceof i.Cmd && 'ID' === this.buf2.cmd) {
                                this.buf1 = this.buf2;
                                this.buf2 = null;
                            } else {
                                this.buf1 = this.buf2;
                                this.buf2 = this.lexer.getObj();
                            }
                        }
                        tryShift() {
                            try {
                                this.shift();
                                return !0;
                            } catch (e) {
                                if (e instanceof n.MissingDataException) throw e;
                                return !1;
                            }
                        }
                        getObj(e = null) {
                            const t = this.buf1;
                            this.shift();
                            if (t instanceof i.Cmd)
                                switch (t.cmd) {
                                    case 'BI':
                                        return this.makeInlineImage(e);
                                    case '[':
                                        const r = [];
                                        for (; !(0, i.isCmd)(this.buf1, ']') && !(0, i.isEOF)(this.buf1); )
                                            r.push(this.getObj(e));
                                        if ((0, i.isEOF)(this.buf1)) {
                                            if (!this.recoveryMode) throw new a.FormatError('End of file inside array');
                                            return r;
                                        }
                                        this.shift();
                                        return r;
                                    case '<<':
                                        const n = new i.Dict(this.xref);
                                        for (; !(0, i.isCmd)(this.buf1, '>>') && !(0, i.isEOF)(this.buf1); ) {
                                            if (!(0, i.isName)(this.buf1)) {
                                                (0, a.info)('Malformed dictionary: key must be a name object');
                                                this.shift();
                                                continue;
                                            }
                                            const t = this.buf1.name;
                                            this.shift();
                                            if ((0, i.isEOF)(this.buf1)) break;
                                            n.set(t, this.getObj(e));
                                        }
                                        if ((0, i.isEOF)(this.buf1)) {
                                            if (!this.recoveryMode)
                                                throw new a.FormatError('End of file inside dictionary');
                                            return n;
                                        }
                                        if ((0, i.isCmd)(this.buf2, 'stream'))
                                            return this.allowStreams ? this.makeStream(n, e) : n;
                                        this.shift();
                                        return n;
                                    default:
                                        return t;
                                }
                            if (Number.isInteger(t)) {
                                if (Number.isInteger(this.buf1) && (0, i.isCmd)(this.buf2, 'R')) {
                                    const e = i.Ref.get(t, this.buf1);
                                    this.shift();
                                    this.shift();
                                    return e;
                                }
                                return t;
                            }
                            return 'string' == typeof t && e ? e.decryptString(t) : t;
                        }
                        findDefaultInlineStreamEnd(e) {
                            const t = this.lexer,
                                r = e.pos;
                            let s,
                                o,
                                c = 0;
                            for (; -1 !== (s = e.getByte()); )
                                if (0 === c) c = 69 === s ? 1 : 0;
                                else if (1 === c) c = 73 === s ? 2 : 0;
                                else {
                                    (0, a.assert)(2 === c, 'findDefaultInlineStreamEnd - invalid state.');
                                    if (32 === s || 10 === s || 13 === s) {
                                        o = e.pos;
                                        const r = e.peekBytes(10);
                                        for (let e = 0, t = r.length; e < t; e++) {
                                            s = r[e];
                                            if (
                                                (0 !== s || 0 === r[e + 1]) &&
                                                10 !== s &&
                                                13 !== s &&
                                                (s < 32 || s > 127)
                                            ) {
                                                c = 0;
                                                break;
                                            }
                                        }
                                        if (2 !== c) continue;
                                        if (t.knownCommands) {
                                            const e = t.peekObj();
                                            e instanceof i.Cmd && !t.knownCommands[e.cmd] && (c = 0);
                                        } else
                                            (0, a.warn)(
                                                'findDefaultInlineStreamEnd - `lexer.knownCommands` is undefined.'
                                            );
                                        if (2 === c) break;
                                    } else c = 0;
                                }
                            if (-1 === s) {
                                (0, a.warn)(
                                    'findDefaultInlineStreamEnd: Reached the end of the stream without finding a valid EI marker'
                                );
                                if (o) {
                                    (0, a.warn)('... trying to recover by using the last "EI" occurrence.');
                                    e.skip(-(e.pos - o));
                                }
                            }
                            let l = 4;
                            e.skip(-l);
                            s = e.peekByte();
                            e.skip(l);
                            (0, n.isWhiteSpace)(s) || l--;
                            return e.pos - l - r;
                        }
                        findDCTDecodeInlineStreamEnd(e) {
                            const t = e.pos;
                            let r,
                                i,
                                n = !1;
                            for (; -1 !== (r = e.getByte()); )
                                if (255 === r) {
                                    switch (e.getByte()) {
                                        case 0:
                                            break;
                                        case 255:
                                            e.skip(-1);
                                            break;
                                        case 217:
                                            n = !0;
                                            break;
                                        case 192:
                                        case 193:
                                        case 194:
                                        case 195:
                                        case 197:
                                        case 198:
                                        case 199:
                                        case 201:
                                        case 202:
                                        case 203:
                                        case 205:
                                        case 206:
                                        case 207:
                                        case 196:
                                        case 204:
                                        case 218:
                                        case 219:
                                        case 220:
                                        case 221:
                                        case 222:
                                        case 223:
                                        case 224:
                                        case 225:
                                        case 226:
                                        case 227:
                                        case 228:
                                        case 229:
                                        case 230:
                                        case 231:
                                        case 232:
                                        case 233:
                                        case 234:
                                        case 235:
                                        case 236:
                                        case 237:
                                        case 238:
                                        case 239:
                                        case 254:
                                            i = e.getUint16();
                                            i > 2 ? e.skip(i - 2) : e.skip(-2);
                                    }
                                    if (n) break;
                                }
                            const s = e.pos - t;
                            if (-1 === r) {
                                (0, a.warn)(
                                    'Inline DCTDecode image stream: EOI marker not found, searching for /EI/ instead.'
                                );
                                e.skip(-s);
                                return this.findDefaultInlineStreamEnd(e);
                            }
                            this.inlineStreamSkipEI(e);
                            return s;
                        }
                        findASCII85DecodeInlineStreamEnd(e) {
                            const t = e.pos;
                            let r;
                            for (; -1 !== (r = e.getByte()); )
                                if (126 === r) {
                                    const t = e.pos;
                                    r = e.peekByte();
                                    for (; (0, n.isWhiteSpace)(r); ) {
                                        e.skip();
                                        r = e.peekByte();
                                    }
                                    if (62 === r) {
                                        e.skip();
                                        break;
                                    }
                                    if (e.pos > t) {
                                        const t = e.peekBytes(2);
                                        if (69 === t[0] && 73 === t[1]) break;
                                    }
                                }
                            const i = e.pos - t;
                            if (-1 === r) {
                                (0, a.warn)(
                                    'Inline ASCII85Decode image stream: EOD marker not found, searching for /EI/ instead.'
                                );
                                e.skip(-i);
                                return this.findDefaultInlineStreamEnd(e);
                            }
                            this.inlineStreamSkipEI(e);
                            return i;
                        }
                        findASCIIHexDecodeInlineStreamEnd(e) {
                            const t = e.pos;
                            let r;
                            for (; -1 !== (r = e.getByte()) && 62 !== r; );
                            const i = e.pos - t;
                            if (-1 === r) {
                                (0, a.warn)(
                                    'Inline ASCIIHexDecode image stream: EOD marker not found, searching for /EI/ instead.'
                                );
                                e.skip(-i);
                                return this.findDefaultInlineStreamEnd(e);
                            }
                            this.inlineStreamSkipEI(e);
                            return i;
                        }
                        inlineStreamSkipEI(e) {
                            let t,
                                r = 0;
                            for (; -1 !== (t = e.getByte()); )
                                if (0 === r) r = 69 === t ? 1 : 0;
                                else if (1 === r) r = 73 === t ? 2 : 0;
                                else if (2 === r) break;
                        }
                        makeInlineImage(e) {
                            const t = this.lexer,
                                r = t.stream,
                                n = new i.Dict(this.xref);
                            let s;
                            for (; !(0, i.isCmd)(this.buf1, 'ID') && !(0, i.isEOF)(this.buf1); ) {
                                if (!(0, i.isName)(this.buf1))
                                    throw new a.FormatError('Dictionary key must be a name object');
                                const t = this.buf1.name;
                                this.shift();
                                if ((0, i.isEOF)(this.buf1)) break;
                                n.set(t, this.getObj(e));
                            }
                            -1 !== t.beginInlineImagePos && (s = r.pos - t.beginInlineImagePos);
                            const o = n.get('Filter', 'F');
                            let c;
                            if ((0, i.isName)(o)) c = o.name;
                            else if (Array.isArray(o)) {
                                const e = this.xref.fetchIfRef(o[0]);
                                (0, i.isName)(e) && (c = e.name);
                            }
                            const l = r.pos;
                            let h;
                            h =
                                'DCTDecode' === c || 'DCT' === c
                                    ? this.findDCTDecodeInlineStreamEnd(r)
                                    : 'ASCII85Decode' === c || 'A85' === c
                                    ? this.findASCII85DecodeInlineStreamEnd(r)
                                    : 'ASCIIHexDecode' === c || 'AHx' === c
                                    ? this.findASCIIHexDecodeInlineStreamEnd(r)
                                    : this.findDefaultInlineStreamEnd(r);
                            let u,
                                d = r.makeSubStream(l, h, n);
                            if (h < 1e3 && s < 5552) {
                                const e = d.getBytes();
                                d.reset();
                                const a = r.pos;
                                r.pos = t.beginInlineImagePos;
                                const n = r.getBytes(s);
                                r.pos = a;
                                u = computeAdler32(e) + '_' + computeAdler32(n);
                                const o = this.imageCache[u];
                                if (void 0 !== o) {
                                    this.buf2 = i.Cmd.get('EI');
                                    this.shift();
                                    o.reset();
                                    return o;
                                }
                            }
                            e && (d = e.createStream(d, h));
                            d = this.filter(d, n, h);
                            d.dict = n;
                            if (void 0 !== u) {
                                d.cacheKey = `inline_${h}_${u}`;
                                this.imageCache[u] = d;
                            }
                            this.buf2 = i.Cmd.get('EI');
                            this.shift();
                            return d;
                        }
                        _findStreamLength(e, t) {
                            const { stream: r } = this.lexer;
                            r.pos = e;
                            const a = t.length;
                            for (; r.pos < r.end; ) {
                                const i = r.peekBytes(2048),
                                    n = i.length - a;
                                if (n <= 0) break;
                                let s = 0;
                                for (; s < n; ) {
                                    let n = 0;
                                    for (; n < a && i[s + n] === t[n]; ) n++;
                                    if (n >= a) {
                                        r.pos += s;
                                        return r.pos - e;
                                    }
                                    s++;
                                }
                                r.pos += n;
                            }
                            return -1;
                        }
                        makeStream(e, t) {
                            const r = this.lexer;
                            let s = r.stream;
                            r.skipToNextLine();
                            const o = s.pos - 1;
                            let c = e.get('Length');
                            if (!Number.isInteger(c)) {
                                (0, a.info)(`Bad length "${c}" in stream`);
                                c = 0;
                            }
                            s.pos = o + c;
                            r.nextChar();
                            if (this.tryShift() && (0, i.isCmd)(this.buf2, 'endstream')) this.shift();
                            else {
                                const e = new Uint8Array([101, 110, 100, 115, 116, 114, 101, 97, 109]);
                                let t = this._findStreamLength(o, e);
                                if (t < 0) {
                                    const r = 1;
                                    for (let i = 1; i <= r; i++) {
                                        const r = e.length - i,
                                            c = e.slice(0, r),
                                            l = this._findStreamLength(o, c);
                                        if (l >= 0) {
                                            const e = s.peekBytes(r + 1)[r];
                                            if (!(0, n.isWhiteSpace)(e)) break;
                                            (0, a.info)(
                                                `Found "${(0, a.bytesToString)(
                                                    c
                                                )}" when searching for endstream command.`
                                            );
                                            t = l;
                                            break;
                                        }
                                    }
                                    if (t < 0) throw new a.FormatError('Missing endstream command.');
                                }
                                c = t;
                                r.nextChar();
                                this.shift();
                                this.shift();
                            }
                            this.shift();
                            s = s.makeSubStream(o, c, e);
                            t && (s = t.createStream(s, c));
                            s = this.filter(s, e, c);
                            s.dict = e;
                            return s;
                        }
                        filter(e, t, r) {
                            let n = t.get('Filter', 'F'),
                                s = t.get('DecodeParms', 'DP');
                            if ((0, i.isName)(n)) {
                                Array.isArray(s) &&
                                    (0, a.warn)(
                                        '/DecodeParms should not contain an Array, when /Filter contains a Name.'
                                    );
                                return this.makeFilter(e, n.name, r, s);
                            }
                            let o = r;
                            if (Array.isArray(n)) {
                                const t = n,
                                    r = s;
                                for (let c = 0, l = t.length; c < l; ++c) {
                                    n = this.xref.fetchIfRef(t[c]);
                                    if (!(0, i.isName)(n)) throw new a.FormatError(`Bad filter name "${n}"`);
                                    s = null;
                                    Array.isArray(r) && c in r && (s = this.xref.fetchIfRef(r[c]));
                                    e = this.makeFilter(e, n.name, o, s);
                                    o = null;
                                }
                            }
                            return e;
                        }
                        makeFilter(e, t, r, i) {
                            if (0 === r) {
                                (0, a.warn)(`Empty "${t}" stream.`);
                                return new g.NullStream();
                            }
                            try {
                                const n = this.xref.stats.streamTypes;
                                if ('FlateDecode' === t || 'Fl' === t) {
                                    n[a.StreamType.FLATE] = !0;
                                    return i
                                        ? new p.PredictorStream(new l.FlateStream(e, r), r, i)
                                        : new l.FlateStream(e, r);
                                }
                                if ('LZWDecode' === t || 'LZW' === t) {
                                    n[a.StreamType.LZW] = !0;
                                    let t = 1;
                                    if (i) {
                                        i.has('EarlyChange') && (t = i.get('EarlyChange'));
                                        return new p.PredictorStream(new f.LZWStream(e, r, t), r, i);
                                    }
                                    return new f.LZWStream(e, r, t);
                                }
                                if ('DCTDecode' === t || 'DCT' === t) {
                                    n[a.StreamType.DCT] = !0;
                                    return new u.JpegStream(e, r, i);
                                }
                                if ('JPXDecode' === t || 'JPX' === t) {
                                    n[a.StreamType.JPX] = !0;
                                    return new d.JpxStream(e, r, i);
                                }
                                if ('ASCII85Decode' === t || 'A85' === t) {
                                    n[a.StreamType.A85] = !0;
                                    return new s.Ascii85Stream(e, r);
                                }
                                if ('ASCIIHexDecode' === t || 'AHx' === t) {
                                    n[a.StreamType.AHX] = !0;
                                    return new o.AsciiHexStream(e, r);
                                }
                                if ('CCITTFaxDecode' === t || 'CCF' === t) {
                                    n[a.StreamType.CCF] = !0;
                                    return new c.CCITTFaxStream(e, r, i);
                                }
                                if ('RunLengthDecode' === t || 'RL' === t) {
                                    n[a.StreamType.RLX] = !0;
                                    return new m.RunLengthStream(e, r);
                                }
                                if ('JBIG2Decode' === t) {
                                    n[a.StreamType.JBIG] = !0;
                                    return new h.Jbig2Stream(e, r, i);
                                }
                                (0, a.warn)(`Filter "${t}" is not supported.`);
                                return e;
                            } catch (e) {
                                if (e instanceof n.MissingDataException) throw e;
                                (0, a.warn)(`Invalid stream: "${e}"`);
                                return new g.NullStream();
                            }
                        }
                    }
                    t.Parser = Parser;
                    const b = [
                        1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        1, 0, 0, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    ];
                    function toHexDigit(e) {
                        return e >= 48 && e <= 57
                            ? 15 & e
                            : (e >= 65 && e <= 70) || (e >= 97 && e <= 102)
                            ? 9 + (15 & e)
                            : -1;
                    }
                    class Lexer {
                        constructor(e, t = null) {
                            this.stream = e;
                            this.nextChar();
                            this.strBuf = [];
                            this.knownCommands = t;
                            this._hexStringNumWarn = 0;
                            this.beginInlineImagePos = -1;
                        }
                        nextChar() {
                            return (this.currentChar = this.stream.getByte());
                        }
                        peekChar() {
                            return this.stream.peekByte();
                        }
                        getNumber() {
                            let e = this.currentChar,
                                t = !1,
                                r = 0,
                                i = 0;
                            if (45 === e) {
                                i = -1;
                                e = this.nextChar();
                                45 === e && (e = this.nextChar());
                            } else if (43 === e) {
                                i = 1;
                                e = this.nextChar();
                            }
                            if (10 === e || 13 === e)
                                do {
                                    e = this.nextChar();
                                } while (10 === e || 13 === e);
                            if (46 === e) {
                                r = 10;
                                e = this.nextChar();
                            }
                            if (e < 48 || e > 57) {
                                if (10 === r && 0 === i && ((0, n.isWhiteSpace)(e) || -1 === e)) {
                                    (0, a.warn)('Lexer.getNumber - treating a single decimal point as zero.');
                                    return 0;
                                }
                                throw new a.FormatError(`Invalid number: ${String.fromCharCode(e)} (charCode ${e})`);
                            }
                            i = i || 1;
                            let s = e - 48,
                                o = 0,
                                c = 1;
                            for (; (e = this.nextChar()) >= 0; )
                                if (e >= 48 && e <= 57) {
                                    const a = e - 48;
                                    if (t) o = 10 * o + a;
                                    else {
                                        0 !== r && (r *= 10);
                                        s = 10 * s + a;
                                    }
                                } else if (46 === e) {
                                    if (0 !== r) break;
                                    r = 1;
                                } else if (45 === e) (0, a.warn)('Badly formatted number: minus sign in the middle');
                                else {
                                    if (69 !== e && 101 !== e) break;
                                    e = this.peekChar();
                                    if (43 === e || 45 === e) {
                                        c = 45 === e ? -1 : 1;
                                        this.nextChar();
                                    } else if (e < 48 || e > 57) break;
                                    t = !0;
                                }
                            0 !== r && (s /= r);
                            t && (s *= 10 ** (c * o));
                            return i * s;
                        }
                        getString() {
                            let e = 1,
                                t = !1;
                            const r = this.strBuf;
                            r.length = 0;
                            let i = this.nextChar();
                            for (;;) {
                                let n = !1;
                                switch (0 | i) {
                                    case -1:
                                        (0, a.warn)('Unterminated string');
                                        t = !0;
                                        break;
                                    case 40:
                                        ++e;
                                        r.push('(');
                                        break;
                                    case 41:
                                        if (0 == --e) {
                                            this.nextChar();
                                            t = !0;
                                        } else r.push(')');
                                        break;
                                    case 92:
                                        i = this.nextChar();
                                        switch (i) {
                                            case -1:
                                                (0, a.warn)('Unterminated string');
                                                t = !0;
                                                break;
                                            case 110:
                                                r.push('\n');
                                                break;
                                            case 114:
                                                r.push('\r');
                                                break;
                                            case 116:
                                                r.push('\t');
                                                break;
                                            case 98:
                                                r.push('\b');
                                                break;
                                            case 102:
                                                r.push('\f');
                                                break;
                                            case 92:
                                            case 40:
                                            case 41:
                                                r.push(String.fromCharCode(i));
                                                break;
                                            case 48:
                                            case 49:
                                            case 50:
                                            case 51:
                                            case 52:
                                            case 53:
                                            case 54:
                                            case 55:
                                                let e = 15 & i;
                                                i = this.nextChar();
                                                n = !0;
                                                if (i >= 48 && i <= 55) {
                                                    e = (e << 3) + (15 & i);
                                                    i = this.nextChar();
                                                    if (i >= 48 && i <= 55) {
                                                        n = !1;
                                                        e = (e << 3) + (15 & i);
                                                    }
                                                }
                                                r.push(String.fromCharCode(e));
                                                break;
                                            case 13:
                                                10 === this.peekChar() && this.nextChar();
                                                break;
                                            case 10:
                                                break;
                                            default:
                                                r.push(String.fromCharCode(i));
                                        }
                                        break;
                                    default:
                                        r.push(String.fromCharCode(i));
                                }
                                if (t) break;
                                n || (i = this.nextChar());
                            }
                            return r.join('');
                        }
                        getName() {
                            let e, t;
                            const r = this.strBuf;
                            r.length = 0;
                            for (; (e = this.nextChar()) >= 0 && !b[e]; )
                                if (35 === e) {
                                    e = this.nextChar();
                                    if (b[e]) {
                                        (0, a.warn)(
                                            'Lexer_getName: NUMBER SIGN (#) should be followed by a hexadecimal number.'
                                        );
                                        r.push('#');
                                        break;
                                    }
                                    const i = toHexDigit(e);
                                    if (-1 !== i) {
                                        t = e;
                                        e = this.nextChar();
                                        const n = toHexDigit(e);
                                        if (-1 === n) {
                                            (0, a.warn)(
                                                `Lexer_getName: Illegal digit (${String.fromCharCode(
                                                    e
                                                )}) in hexadecimal number.`
                                            );
                                            r.push('#', String.fromCharCode(t));
                                            if (b[e]) break;
                                            r.push(String.fromCharCode(e));
                                            continue;
                                        }
                                        r.push(String.fromCharCode((i << 4) | n));
                                    } else r.push('#', String.fromCharCode(e));
                                } else r.push(String.fromCharCode(e));
                            r.length > 127 && (0, a.warn)(`Name token is longer than allowed by the spec: ${r.length}`);
                            return i.Name.get(r.join(''));
                        }
                        _hexStringWarn(e) {
                            5 != this._hexStringNumWarn++
                                ? this._hexStringNumWarn > 5 ||
                                  (0, a.warn)(`getHexString - ignoring invalid character: ${e}`)
                                : (0, a.warn)('getHexString - ignoring additional invalid characters.');
                        }
                        getHexString() {
                            const e = this.strBuf;
                            e.length = 0;
                            let t,
                                r,
                                i = this.currentChar,
                                n = !0;
                            this._hexStringNumWarn = 0;
                            for (;;) {
                                if (i < 0) {
                                    (0, a.warn)('Unterminated hex string');
                                    break;
                                }
                                if (62 === i) {
                                    this.nextChar();
                                    break;
                                }
                                if (1 !== b[i]) {
                                    if (n) {
                                        t = toHexDigit(i);
                                        if (-1 === t) {
                                            this._hexStringWarn(i);
                                            i = this.nextChar();
                                            continue;
                                        }
                                    } else {
                                        r = toHexDigit(i);
                                        if (-1 === r) {
                                            this._hexStringWarn(i);
                                            i = this.nextChar();
                                            continue;
                                        }
                                        e.push(String.fromCharCode((t << 4) | r));
                                    }
                                    n = !n;
                                    i = this.nextChar();
                                } else i = this.nextChar();
                            }
                            return e.join('');
                        }
                        getObj() {
                            let e = !1,
                                t = this.currentChar;
                            for (;;) {
                                if (t < 0) return i.EOF;
                                if (e) (10 !== t && 13 !== t) || (e = !1);
                                else if (37 === t) e = !0;
                                else if (1 !== b[t]) break;
                                t = this.nextChar();
                            }
                            switch (0 | t) {
                                case 48:
                                case 49:
                                case 50:
                                case 51:
                                case 52:
                                case 53:
                                case 54:
                                case 55:
                                case 56:
                                case 57:
                                case 43:
                                case 45:
                                case 46:
                                    return this.getNumber();
                                case 40:
                                    return this.getString();
                                case 47:
                                    return this.getName();
                                case 91:
                                    this.nextChar();
                                    return i.Cmd.get('[');
                                case 93:
                                    this.nextChar();
                                    return i.Cmd.get(']');
                                case 60:
                                    t = this.nextChar();
                                    if (60 === t) {
                                        this.nextChar();
                                        return i.Cmd.get('<<');
                                    }
                                    return this.getHexString();
                                case 62:
                                    t = this.nextChar();
                                    if (62 === t) {
                                        this.nextChar();
                                        return i.Cmd.get('>>');
                                    }
                                    return i.Cmd.get('>');
                                case 123:
                                    this.nextChar();
                                    return i.Cmd.get('{');
                                case 125:
                                    this.nextChar();
                                    return i.Cmd.get('}');
                                case 41:
                                    this.nextChar();
                                    throw new a.FormatError(`Illegal character: ${t}`);
                            }
                            let r = String.fromCharCode(t);
                            const n = this.knownCommands;
                            let s = n && void 0 !== n[r];
                            for (; (t = this.nextChar()) >= 0 && !b[t]; ) {
                                const e = r + String.fromCharCode(t);
                                if (s && void 0 === n[e]) break;
                                if (128 === r.length) throw new a.FormatError(`Command token too long: ${r.length}`);
                                r = e;
                                s = n && void 0 !== n[r];
                            }
                            if ('true' === r) return !0;
                            if ('false' === r) return !1;
                            if ('null' === r) return null;
                            'BI' === r && (this.beginInlineImagePos = this.stream.pos);
                            return i.Cmd.get(r);
                        }
                        peekObj() {
                            const e = this.stream.pos,
                                t = this.currentChar,
                                r = this.beginInlineImagePos;
                            let i;
                            try {
                                i = this.getObj();
                            } catch (e) {
                                if (e instanceof n.MissingDataException) throw e;
                                (0, a.warn)(`peekObj: ${e}`);
                            }
                            this.stream.pos = e;
                            this.currentChar = t;
                            this.beginInlineImagePos = r;
                            return i;
                        }
                        skipToNextLine() {
                            let e = this.currentChar;
                            for (; e >= 0; ) {
                                if (13 === e) {
                                    e = this.nextChar();
                                    10 === e && this.nextChar();
                                    break;
                                }
                                if (10 === e) {
                                    this.nextChar();
                                    break;
                                }
                                e = this.nextChar();
                            }
                        }
                    }
                    t.Lexer = Lexer;
                    t.Linearization = class Linearization {
                        static create(e) {
                            function getInt(e, t, r = !1) {
                                const a = e.get(t);
                                if (Number.isInteger(a) && (r ? a >= 0 : a > 0)) return a;
                                throw new Error(`The "${t}" parameter in the linearization dictionary is invalid.`);
                            }
                            const t = new Parser({ lexer: new Lexer(e), xref: null }),
                                r = t.getObj(),
                                n = t.getObj(),
                                s = t.getObj(),
                                o = t.getObj();
                            let c, l;
                            if (
                                !(
                                    Number.isInteger(r) &&
                                    Number.isInteger(n) &&
                                    (0, i.isCmd)(s, 'obj') &&
                                    (0, i.isDict)(o) &&
                                    (0, a.isNum)((c = o.get('Linearized'))) &&
                                    c > 0
                                )
                            )
                                return null;
                            if ((l = getInt(o, 'L')) !== e.length)
                                throw new Error(
                                    'The "L" parameter in the linearization dictionary does not equal the stream length.'
                                );
                            return {
                                length: l,
                                hints: (function getHints(e) {
                                    const t = e.get('H');
                                    let r;
                                    if (Array.isArray(t) && (2 === (r = t.length) || 4 === r)) {
                                        for (let e = 0; e < r; e++) {
                                            const r = t[e];
                                            if (!(Number.isInteger(r) && r > 0))
                                                throw new Error(
                                                    `Hint (${e}) in the linearization dictionary is invalid.`
                                                );
                                        }
                                        return t;
                                    }
                                    throw new Error('Hint array in the linearization dictionary is invalid.');
                                })(o),
                                objectNumberFirst: getInt(o, 'O'),
                                endFirst: getInt(o, 'E'),
                                numPages: getInt(o, 'N'),
                                mainXRefEntriesOffset: getInt(o, 'T'),
                                pageFirst: o.has('P') ? getInt(o, 'P', !0) : 0,
                            };
                        }
                    };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.Ascii85Stream = void 0;
                    var a = r(19),
                        i = r(9);
                    class Ascii85Stream extends a.DecodeStream {
                        constructor(e, t) {
                            t && (t *= 0.8);
                            super(t);
                            this.str = e;
                            this.dict = e.dict;
                            this.input = new Uint8Array(5);
                        }
                        readBlock() {
                            const e = this.str;
                            let t = e.getByte();
                            for (; (0, i.isWhiteSpace)(t); ) t = e.getByte();
                            if (-1 === t || 126 === t) {
                                this.eof = !0;
                                return;
                            }
                            const r = this.bufferLength;
                            let a, n;
                            if (122 === t) {
                                a = this.ensureBuffer(r + 4);
                                for (n = 0; n < 4; ++n) a[r + n] = 0;
                                this.bufferLength += 4;
                            } else {
                                const s = this.input;
                                s[0] = t;
                                for (n = 1; n < 5; ++n) {
                                    t = e.getByte();
                                    for (; (0, i.isWhiteSpace)(t); ) t = e.getByte();
                                    s[n] = t;
                                    if (-1 === t || 126 === t) break;
                                }
                                a = this.ensureBuffer(r + n - 1);
                                this.bufferLength += n - 1;
                                if (n < 5) {
                                    for (; n < 5; ++n) s[n] = 117;
                                    this.eof = !0;
                                }
                                let o = 0;
                                for (n = 0; n < 5; ++n) o = 85 * o + (s[n] - 33);
                                for (n = 3; n >= 0; --n) {
                                    a[r + n] = 255 & o;
                                    o >>= 8;
                                }
                            }
                        }
                    }
                    t.Ascii85Stream = Ascii85Stream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.StreamsSequenceStream = t.DecodeStream = void 0;
                    var a = r(6),
                        i = r(10);
                    const n = new Uint8Array(0);
                    class DecodeStream extends a.BaseStream {
                        constructor(e) {
                            super();
                            this._rawMinBufferLength = e || 0;
                            this.pos = 0;
                            this.bufferLength = 0;
                            this.eof = !1;
                            this.buffer = n;
                            this.minBufferLength = 512;
                            if (e) for (; this.minBufferLength < e; ) this.minBufferLength *= 2;
                        }
                        get isEmpty() {
                            for (; !this.eof && 0 === this.bufferLength; ) this.readBlock();
                            return 0 === this.bufferLength;
                        }
                        ensureBuffer(e) {
                            const t = this.buffer;
                            if (e <= t.byteLength) return t;
                            let r = this.minBufferLength;
                            for (; r < e; ) r *= 2;
                            const a = new Uint8Array(r);
                            a.set(t);
                            return (this.buffer = a);
                        }
                        getByte() {
                            const e = this.pos;
                            for (; this.bufferLength <= e; ) {
                                if (this.eof) return -1;
                                this.readBlock();
                            }
                            return this.buffer[this.pos++];
                        }
                        getBytes(e, t = !1) {
                            const r = this.pos;
                            let a;
                            if (e) {
                                this.ensureBuffer(r + e);
                                a = r + e;
                                for (; !this.eof && this.bufferLength < a; ) this.readBlock();
                                const t = this.bufferLength;
                                a > t && (a = t);
                            } else {
                                for (; !this.eof; ) this.readBlock();
                                a = this.bufferLength;
                            }
                            this.pos = a;
                            const i = this.buffer.subarray(r, a);
                            return !t || i instanceof Uint8ClampedArray ? i : new Uint8ClampedArray(i);
                        }
                        reset() {
                            this.pos = 0;
                        }
                        makeSubStream(e, t, r = null) {
                            if (void 0 === t) for (; !this.eof; ) this.readBlock();
                            else {
                                const r = e + t;
                                for (; this.bufferLength <= r && !this.eof; ) this.readBlock();
                            }
                            return new i.Stream(this.buffer, e, t, r);
                        }
                        getBaseStreams() {
                            return this.str ? this.str.getBaseStreams() : null;
                        }
                    }
                    t.DecodeStream = DecodeStream;
                    t.StreamsSequenceStream = class StreamsSequenceStream extends DecodeStream {
                        constructor(e) {
                            let t = 0;
                            for (const r of e) t += r instanceof DecodeStream ? r._rawMinBufferLength : r.length;
                            super(t);
                            this.streams = e;
                        }
                        readBlock() {
                            const e = this.streams;
                            if (0 === e.length) {
                                this.eof = !0;
                                return;
                            }
                            const t = e.shift().getBytes(),
                                r = this.bufferLength,
                                a = r + t.length;
                            this.ensureBuffer(a).set(t, r);
                            this.bufferLength = a;
                        }
                        getBaseStreams() {
                            const e = [];
                            for (const t of this.streams) {
                                const r = t.getBaseStreams();
                                r && e.push(...r);
                            }
                            return e.length > 0 ? e : null;
                        }
                    };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.AsciiHexStream = void 0;
                    var a = r(19);
                    class AsciiHexStream extends a.DecodeStream {
                        constructor(e, t) {
                            t && (t *= 0.5);
                            super(t);
                            this.str = e;
                            this.dict = e.dict;
                            this.firstDigit = -1;
                        }
                        readBlock() {
                            const e = this.str.getBytes(8e3);
                            if (!e.length) {
                                this.eof = !0;
                                return;
                            }
                            const t = (e.length + 1) >> 1,
                                r = this.ensureBuffer(this.bufferLength + t);
                            let a = this.bufferLength,
                                i = this.firstDigit;
                            for (const t of e) {
                                let e;
                                if (t >= 48 && t <= 57) e = 15 & t;
                                else {
                                    if (!((t >= 65 && t <= 70) || (t >= 97 && t <= 102))) {
                                        if (62 === t) {
                                            this.eof = !0;
                                            break;
                                        }
                                        continue;
                                    }
                                    e = 9 + (15 & t);
                                }
                                if (i < 0) i = e;
                                else {
                                    r[a++] = (i << 4) | e;
                                    i = -1;
                                }
                            }
                            if (i >= 0 && this.eof) {
                                r[a++] = i << 4;
                                i = -1;
                            }
                            this.firstDigit = i;
                            this.bufferLength = a;
                        }
                    }
                    t.AsciiHexStream = AsciiHexStream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.CCITTFaxStream = void 0;
                    var a = r(5),
                        i = r(22),
                        n = r(19);
                    class CCITTFaxStream extends n.DecodeStream {
                        constructor(e, t, r) {
                            super(t);
                            this.str = e;
                            this.dict = e.dict;
                            (0, a.isDict)(r) || (r = a.Dict.empty);
                            const n = { next: () => e.getByte() };
                            this.ccittFaxDecoder = new i.CCITTFaxDecoder(n, {
                                K: r.get('K'),
                                EndOfLine: r.get('EndOfLine'),
                                EncodedByteAlign: r.get('EncodedByteAlign'),
                                Columns: r.get('Columns'),
                                Rows: r.get('Rows'),
                                EndOfBlock: r.get('EndOfBlock'),
                                BlackIs1: r.get('BlackIs1'),
                            });
                        }
                        readBlock() {
                            for (; !this.eof; ) {
                                const e = this.ccittFaxDecoder.readNextChar();
                                if (-1 === e) {
                                    this.eof = !0;
                                    return;
                                }
                                this.ensureBuffer(this.bufferLength + 1);
                                this.buffer[this.bufferLength++] = e;
                            }
                        }
                    }
                    t.CCITTFaxStream = CCITTFaxStream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.CCITTFaxDecoder = void 0;
                    var a = r(2);
                    const i = -1,
                        n = [
                            [-1, -1],
                            [-1, -1],
                            [7, 8],
                            [7, 7],
                            [6, 6],
                            [6, 6],
                            [6, 5],
                            [6, 5],
                            [4, 0],
                            [4, 0],
                            [4, 0],
                            [4, 0],
                            [4, 0],
                            [4, 0],
                            [4, 0],
                            [4, 0],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [3, 3],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                            [1, 2],
                        ],
                        s = [
                            [-1, -1],
                            [12, -2],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [11, 1792],
                            [11, 1792],
                            [12, 1984],
                            [12, 2048],
                            [12, 2112],
                            [12, 2176],
                            [12, 2240],
                            [12, 2304],
                            [11, 1856],
                            [11, 1856],
                            [11, 1920],
                            [11, 1920],
                            [12, 2368],
                            [12, 2432],
                            [12, 2496],
                            [12, 2560],
                        ],
                        o = [
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [8, 29],
                            [8, 29],
                            [8, 30],
                            [8, 30],
                            [8, 45],
                            [8, 45],
                            [8, 46],
                            [8, 46],
                            [7, 22],
                            [7, 22],
                            [7, 22],
                            [7, 22],
                            [7, 23],
                            [7, 23],
                            [7, 23],
                            [7, 23],
                            [8, 47],
                            [8, 47],
                            [8, 48],
                            [8, 48],
                            [6, 13],
                            [6, 13],
                            [6, 13],
                            [6, 13],
                            [6, 13],
                            [6, 13],
                            [6, 13],
                            [6, 13],
                            [7, 20],
                            [7, 20],
                            [7, 20],
                            [7, 20],
                            [8, 33],
                            [8, 33],
                            [8, 34],
                            [8, 34],
                            [8, 35],
                            [8, 35],
                            [8, 36],
                            [8, 36],
                            [8, 37],
                            [8, 37],
                            [8, 38],
                            [8, 38],
                            [7, 19],
                            [7, 19],
                            [7, 19],
                            [7, 19],
                            [8, 31],
                            [8, 31],
                            [8, 32],
                            [8, 32],
                            [6, 1],
                            [6, 1],
                            [6, 1],
                            [6, 1],
                            [6, 1],
                            [6, 1],
                            [6, 1],
                            [6, 1],
                            [6, 12],
                            [6, 12],
                            [6, 12],
                            [6, 12],
                            [6, 12],
                            [6, 12],
                            [6, 12],
                            [6, 12],
                            [8, 53],
                            [8, 53],
                            [8, 54],
                            [8, 54],
                            [7, 26],
                            [7, 26],
                            [7, 26],
                            [7, 26],
                            [8, 39],
                            [8, 39],
                            [8, 40],
                            [8, 40],
                            [8, 41],
                            [8, 41],
                            [8, 42],
                            [8, 42],
                            [8, 43],
                            [8, 43],
                            [8, 44],
                            [8, 44],
                            [7, 21],
                            [7, 21],
                            [7, 21],
                            [7, 21],
                            [7, 28],
                            [7, 28],
                            [7, 28],
                            [7, 28],
                            [8, 61],
                            [8, 61],
                            [8, 62],
                            [8, 62],
                            [8, 63],
                            [8, 63],
                            [8, 0],
                            [8, 0],
                            [8, 320],
                            [8, 320],
                            [8, 384],
                            [8, 384],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 10],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [5, 11],
                            [7, 27],
                            [7, 27],
                            [7, 27],
                            [7, 27],
                            [8, 59],
                            [8, 59],
                            [8, 60],
                            [8, 60],
                            [9, 1472],
                            [9, 1536],
                            [9, 1600],
                            [9, 1728],
                            [7, 18],
                            [7, 18],
                            [7, 18],
                            [7, 18],
                            [7, 24],
                            [7, 24],
                            [7, 24],
                            [7, 24],
                            [8, 49],
                            [8, 49],
                            [8, 50],
                            [8, 50],
                            [8, 51],
                            [8, 51],
                            [8, 52],
                            [8, 52],
                            [7, 25],
                            [7, 25],
                            [7, 25],
                            [7, 25],
                            [8, 55],
                            [8, 55],
                            [8, 56],
                            [8, 56],
                            [8, 57],
                            [8, 57],
                            [8, 58],
                            [8, 58],
                            [6, 192],
                            [6, 192],
                            [6, 192],
                            [6, 192],
                            [6, 192],
                            [6, 192],
                            [6, 192],
                            [6, 192],
                            [6, 1664],
                            [6, 1664],
                            [6, 1664],
                            [6, 1664],
                            [6, 1664],
                            [6, 1664],
                            [6, 1664],
                            [6, 1664],
                            [8, 448],
                            [8, 448],
                            [8, 512],
                            [8, 512],
                            [9, 704],
                            [9, 768],
                            [8, 640],
                            [8, 640],
                            [8, 576],
                            [8, 576],
                            [9, 832],
                            [9, 896],
                            [9, 960],
                            [9, 1024],
                            [9, 1088],
                            [9, 1152],
                            [9, 1216],
                            [9, 1280],
                            [9, 1344],
                            [9, 1408],
                            [7, 256],
                            [7, 256],
                            [7, 256],
                            [7, 256],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 2],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [4, 3],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 128],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 8],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [5, 9],
                            [6, 16],
                            [6, 16],
                            [6, 16],
                            [6, 16],
                            [6, 16],
                            [6, 16],
                            [6, 16],
                            [6, 16],
                            [6, 17],
                            [6, 17],
                            [6, 17],
                            [6, 17],
                            [6, 17],
                            [6, 17],
                            [6, 17],
                            [6, 17],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 4],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [6, 14],
                            [6, 14],
                            [6, 14],
                            [6, 14],
                            [6, 14],
                            [6, 14],
                            [6, 14],
                            [6, 14],
                            [6, 15],
                            [6, 15],
                            [6, 15],
                            [6, 15],
                            [6, 15],
                            [6, 15],
                            [6, 15],
                            [6, 15],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [5, 64],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                            [4, 7],
                        ],
                        c = [
                            [-1, -1],
                            [-1, -1],
                            [12, -2],
                            [12, -2],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [11, 1792],
                            [11, 1792],
                            [11, 1792],
                            [11, 1792],
                            [12, 1984],
                            [12, 1984],
                            [12, 2048],
                            [12, 2048],
                            [12, 2112],
                            [12, 2112],
                            [12, 2176],
                            [12, 2176],
                            [12, 2240],
                            [12, 2240],
                            [12, 2304],
                            [12, 2304],
                            [11, 1856],
                            [11, 1856],
                            [11, 1856],
                            [11, 1856],
                            [11, 1920],
                            [11, 1920],
                            [11, 1920],
                            [11, 1920],
                            [12, 2368],
                            [12, 2368],
                            [12, 2432],
                            [12, 2432],
                            [12, 2496],
                            [12, 2496],
                            [12, 2560],
                            [12, 2560],
                            [10, 18],
                            [10, 18],
                            [10, 18],
                            [10, 18],
                            [10, 18],
                            [10, 18],
                            [10, 18],
                            [10, 18],
                            [12, 52],
                            [12, 52],
                            [13, 640],
                            [13, 704],
                            [13, 768],
                            [13, 832],
                            [12, 55],
                            [12, 55],
                            [12, 56],
                            [12, 56],
                            [13, 1280],
                            [13, 1344],
                            [13, 1408],
                            [13, 1472],
                            [12, 59],
                            [12, 59],
                            [12, 60],
                            [12, 60],
                            [13, 1536],
                            [13, 1600],
                            [11, 24],
                            [11, 24],
                            [11, 24],
                            [11, 24],
                            [11, 25],
                            [11, 25],
                            [11, 25],
                            [11, 25],
                            [13, 1664],
                            [13, 1728],
                            [12, 320],
                            [12, 320],
                            [12, 384],
                            [12, 384],
                            [12, 448],
                            [12, 448],
                            [13, 512],
                            [13, 576],
                            [12, 53],
                            [12, 53],
                            [12, 54],
                            [12, 54],
                            [13, 896],
                            [13, 960],
                            [13, 1024],
                            [13, 1088],
                            [13, 1152],
                            [13, 1216],
                            [10, 64],
                            [10, 64],
                            [10, 64],
                            [10, 64],
                            [10, 64],
                            [10, 64],
                            [10, 64],
                            [10, 64],
                        ],
                        l = [
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [8, 13],
                            [11, 23],
                            [11, 23],
                            [12, 50],
                            [12, 51],
                            [12, 44],
                            [12, 45],
                            [12, 46],
                            [12, 47],
                            [12, 57],
                            [12, 58],
                            [12, 61],
                            [12, 256],
                            [10, 16],
                            [10, 16],
                            [10, 16],
                            [10, 16],
                            [10, 17],
                            [10, 17],
                            [10, 17],
                            [10, 17],
                            [12, 48],
                            [12, 49],
                            [12, 62],
                            [12, 63],
                            [12, 30],
                            [12, 31],
                            [12, 32],
                            [12, 33],
                            [12, 40],
                            [12, 41],
                            [11, 22],
                            [11, 22],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [8, 14],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 10],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [7, 11],
                            [9, 15],
                            [9, 15],
                            [9, 15],
                            [9, 15],
                            [9, 15],
                            [9, 15],
                            [9, 15],
                            [9, 15],
                            [12, 128],
                            [12, 192],
                            [12, 26],
                            [12, 27],
                            [12, 28],
                            [12, 29],
                            [11, 19],
                            [11, 19],
                            [11, 20],
                            [11, 20],
                            [12, 34],
                            [12, 35],
                            [12, 36],
                            [12, 37],
                            [12, 38],
                            [12, 39],
                            [11, 21],
                            [11, 21],
                            [12, 42],
                            [12, 43],
                            [10, 0],
                            [10, 0],
                            [10, 0],
                            [10, 0],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                            [7, 12],
                        ],
                        h = [
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [-1, -1],
                            [6, 9],
                            [6, 8],
                            [5, 7],
                            [5, 7],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 6],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [4, 5],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 1],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [3, 4],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 3],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                            [2, 2],
                        ];
                    t.CCITTFaxDecoder = class CCITTFaxDecoder {
                        constructor(e, t = {}) {
                            if (!e || 'function' != typeof e.next)
                                throw new Error('CCITTFaxDecoder - invalid "source" parameter.');
                            this.source = e;
                            this.eof = !1;
                            this.encoding = t.K || 0;
                            this.eoline = t.EndOfLine || !1;
                            this.byteAlign = t.EncodedByteAlign || !1;
                            this.columns = t.Columns || 1728;
                            this.rows = t.Rows || 0;
                            let r,
                                a = t.EndOfBlock;
                            null == a && (a = !0);
                            this.eoblock = a;
                            this.black = t.BlackIs1 || !1;
                            this.codingLine = new Uint32Array(this.columns + 1);
                            this.refLine = new Uint32Array(this.columns + 2);
                            this.codingLine[0] = this.columns;
                            this.codingPos = 0;
                            this.row = 0;
                            this.nextLine2D = this.encoding < 0;
                            this.inputBits = 0;
                            this.inputBuf = 0;
                            this.outputBits = 0;
                            this.rowsDone = !1;
                            for (; 0 === (r = this._lookBits(12)); ) this._eatBits(1);
                            1 === r && this._eatBits(12);
                            if (this.encoding > 0) {
                                this.nextLine2D = !this._lookBits(1);
                                this._eatBits(1);
                            }
                        }
                        readNextChar() {
                            if (this.eof) return -1;
                            const e = this.refLine,
                                t = this.codingLine,
                                r = this.columns;
                            let n, s, o, c, l;
                            if (0 === this.outputBits) {
                                this.rowsDone && (this.eof = !0);
                                if (this.eof) return -1;
                                this.err = !1;
                                let o, l, h;
                                if (this.nextLine2D) {
                                    for (c = 0; t[c] < r; ++c) e[c] = t[c];
                                    e[c++] = r;
                                    e[c] = r;
                                    t[0] = 0;
                                    this.codingPos = 0;
                                    n = 0;
                                    s = 0;
                                    for (; t[this.codingPos] < r; ) {
                                        o = this._getTwoDimCode();
                                        switch (o) {
                                            case 0:
                                                this._addPixels(e[n + 1], s);
                                                e[n + 1] < r && (n += 2);
                                                break;
                                            case 1:
                                                o = l = 0;
                                                if (s) {
                                                    do {
                                                        o += h = this._getBlackCode();
                                                    } while (h >= 64);
                                                    do {
                                                        l += h = this._getWhiteCode();
                                                    } while (h >= 64);
                                                } else {
                                                    do {
                                                        o += h = this._getWhiteCode();
                                                    } while (h >= 64);
                                                    do {
                                                        l += h = this._getBlackCode();
                                                    } while (h >= 64);
                                                }
                                                this._addPixels(t[this.codingPos] + o, s);
                                                t[this.codingPos] < r && this._addPixels(t[this.codingPos] + l, 1 ^ s);
                                                for (; e[n] <= t[this.codingPos] && e[n] < r; ) n += 2;
                                                break;
                                            case 7:
                                                this._addPixels(e[n] + 3, s);
                                                s ^= 1;
                                                if (t[this.codingPos] < r) {
                                                    ++n;
                                                    for (; e[n] <= t[this.codingPos] && e[n] < r; ) n += 2;
                                                }
                                                break;
                                            case 5:
                                                this._addPixels(e[n] + 2, s);
                                                s ^= 1;
                                                if (t[this.codingPos] < r) {
                                                    ++n;
                                                    for (; e[n] <= t[this.codingPos] && e[n] < r; ) n += 2;
                                                }
                                                break;
                                            case 3:
                                                this._addPixels(e[n] + 1, s);
                                                s ^= 1;
                                                if (t[this.codingPos] < r) {
                                                    ++n;
                                                    for (; e[n] <= t[this.codingPos] && e[n] < r; ) n += 2;
                                                }
                                                break;
                                            case 2:
                                                this._addPixels(e[n], s);
                                                s ^= 1;
                                                if (t[this.codingPos] < r) {
                                                    ++n;
                                                    for (; e[n] <= t[this.codingPos] && e[n] < r; ) n += 2;
                                                }
                                                break;
                                            case 8:
                                                this._addPixelsNeg(e[n] - 3, s);
                                                s ^= 1;
                                                if (t[this.codingPos] < r) {
                                                    n > 0 ? --n : ++n;
                                                    for (; e[n] <= t[this.codingPos] && e[n] < r; ) n += 2;
                                                }
                                                break;
                                            case 6:
                                                this._addPixelsNeg(e[n] - 2, s);
                                                s ^= 1;
                                                if (t[this.codingPos] < r) {
                                                    n > 0 ? --n : ++n;
                                                    for (; e[n] <= t[this.codingPos] && e[n] < r; ) n += 2;
                                                }
                                                break;
                                            case 4:
                                                this._addPixelsNeg(e[n] - 1, s);
                                                s ^= 1;
                                                if (t[this.codingPos] < r) {
                                                    n > 0 ? --n : ++n;
                                                    for (; e[n] <= t[this.codingPos] && e[n] < r; ) n += 2;
                                                }
                                                break;
                                            case i:
                                                this._addPixels(r, 0);
                                                this.eof = !0;
                                                break;
                                            default:
                                                (0, a.info)('bad 2d code');
                                                this._addPixels(r, 0);
                                                this.err = !0;
                                        }
                                    }
                                } else {
                                    t[0] = 0;
                                    this.codingPos = 0;
                                    s = 0;
                                    for (; t[this.codingPos] < r; ) {
                                        o = 0;
                                        if (s)
                                            do {
                                                o += h = this._getBlackCode();
                                            } while (h >= 64);
                                        else
                                            do {
                                                o += h = this._getWhiteCode();
                                            } while (h >= 64);
                                        this._addPixels(t[this.codingPos] + o, s);
                                        s ^= 1;
                                    }
                                }
                                let u = !1;
                                this.byteAlign && (this.inputBits &= -8);
                                if (this.eoblock || this.row !== this.rows - 1) {
                                    o = this._lookBits(12);
                                    if (this.eoline)
                                        for (; o !== i && 1 !== o; ) {
                                            this._eatBits(1);
                                            o = this._lookBits(12);
                                        }
                                    else
                                        for (; 0 === o; ) {
                                            this._eatBits(1);
                                            o = this._lookBits(12);
                                        }
                                    if (1 === o) {
                                        this._eatBits(12);
                                        u = !0;
                                    } else o === i && (this.eof = !0);
                                } else this.rowsDone = !0;
                                if (!this.eof && this.encoding > 0 && !this.rowsDone) {
                                    this.nextLine2D = !this._lookBits(1);
                                    this._eatBits(1);
                                }
                                if (this.eoblock && u && this.byteAlign) {
                                    o = this._lookBits(12);
                                    if (1 === o) {
                                        this._eatBits(12);
                                        if (this.encoding > 0) {
                                            this._lookBits(1);
                                            this._eatBits(1);
                                        }
                                        if (this.encoding >= 0)
                                            for (c = 0; c < 4; ++c) {
                                                o = this._lookBits(12);
                                                1 !== o && (0, a.info)('bad rtc code: ' + o);
                                                this._eatBits(12);
                                                if (this.encoding > 0) {
                                                    this._lookBits(1);
                                                    this._eatBits(1);
                                                }
                                            }
                                        this.eof = !0;
                                    }
                                } else if (this.err && this.eoline) {
                                    for (;;) {
                                        o = this._lookBits(13);
                                        if (o === i) {
                                            this.eof = !0;
                                            return -1;
                                        }
                                        if (o >> 1 == 1) break;
                                        this._eatBits(1);
                                    }
                                    this._eatBits(12);
                                    if (this.encoding > 0) {
                                        this._eatBits(1);
                                        this.nextLine2D = !(1 & o);
                                    }
                                }
                                t[0] > 0
                                    ? (this.outputBits = t[(this.codingPos = 0)])
                                    : (this.outputBits = t[(this.codingPos = 1)]);
                                this.row++;
                            }
                            if (this.outputBits >= 8) {
                                l = 1 & this.codingPos ? 0 : 255;
                                this.outputBits -= 8;
                                if (0 === this.outputBits && t[this.codingPos] < r) {
                                    this.codingPos++;
                                    this.outputBits = t[this.codingPos] - t[this.codingPos - 1];
                                }
                            } else {
                                o = 8;
                                l = 0;
                                do {
                                    if (this.outputBits > o) {
                                        l <<= o;
                                        1 & this.codingPos || (l |= 255 >> (8 - o));
                                        this.outputBits -= o;
                                        o = 0;
                                    } else {
                                        l <<= this.outputBits;
                                        1 & this.codingPos || (l |= 255 >> (8 - this.outputBits));
                                        o -= this.outputBits;
                                        this.outputBits = 0;
                                        if (t[this.codingPos] < r) {
                                            this.codingPos++;
                                            this.outputBits = t[this.codingPos] - t[this.codingPos - 1];
                                        } else if (o > 0) {
                                            l <<= o;
                                            o = 0;
                                        }
                                    }
                                } while (o);
                            }
                            this.black && (l ^= 255);
                            return l;
                        }
                        _addPixels(e, t) {
                            const r = this.codingLine;
                            let i = this.codingPos;
                            if (e > r[i]) {
                                if (e > this.columns) {
                                    (0, a.info)('row is wrong length');
                                    this.err = !0;
                                    e = this.columns;
                                }
                                (1 & i) ^ t && ++i;
                                r[i] = e;
                            }
                            this.codingPos = i;
                        }
                        _addPixelsNeg(e, t) {
                            const r = this.codingLine;
                            let i = this.codingPos;
                            if (e > r[i]) {
                                if (e > this.columns) {
                                    (0, a.info)('row is wrong length');
                                    this.err = !0;
                                    e = this.columns;
                                }
                                (1 & i) ^ t && ++i;
                                r[i] = e;
                            } else if (e < r[i]) {
                                if (e < 0) {
                                    (0, a.info)('invalid code');
                                    this.err = !0;
                                    e = 0;
                                }
                                for (; i > 0 && e < r[i - 1]; ) --i;
                                r[i] = e;
                            }
                            this.codingPos = i;
                        }
                        _findTableCode(e, t, r, a) {
                            const n = a || 0;
                            for (let a = e; a <= t; ++a) {
                                let e = this._lookBits(a);
                                if (e === i) return [!0, 1, !1];
                                a < t && (e <<= t - a);
                                if (!n || e >= n) {
                                    const t = r[e - n];
                                    if (t[0] === a) {
                                        this._eatBits(a);
                                        return [!0, t[1], !0];
                                    }
                                }
                            }
                            return [!1, 0, !1];
                        }
                        _getTwoDimCode() {
                            let e,
                                t = 0;
                            if (this.eoblock) {
                                t = this._lookBits(7);
                                e = n[t];
                                if (e && e[0] > 0) {
                                    this._eatBits(e[0]);
                                    return e[1];
                                }
                            } else {
                                const e = this._findTableCode(1, 7, n);
                                if (e[0] && e[2]) return e[1];
                            }
                            (0, a.info)('Bad two dim code');
                            return i;
                        }
                        _getWhiteCode() {
                            let e,
                                t = 0;
                            if (this.eoblock) {
                                t = this._lookBits(12);
                                if (t === i) return 1;
                                e = t >> 5 == 0 ? s[t] : o[t >> 3];
                                if (e[0] > 0) {
                                    this._eatBits(e[0]);
                                    return e[1];
                                }
                            } else {
                                let e = this._findTableCode(1, 9, o);
                                if (e[0]) return e[1];
                                e = this._findTableCode(11, 12, s);
                                if (e[0]) return e[1];
                            }
                            (0, a.info)('bad white code');
                            this._eatBits(1);
                            return 1;
                        }
                        _getBlackCode() {
                            let e, t;
                            if (this.eoblock) {
                                e = this._lookBits(13);
                                if (e === i) return 1;
                                t = e >> 7 == 0 ? c[e] : e >> 9 == 0 && e >> 7 != 0 ? l[(e >> 1) - 64] : h[e >> 7];
                                if (t[0] > 0) {
                                    this._eatBits(t[0]);
                                    return t[1];
                                }
                            } else {
                                let e = this._findTableCode(2, 6, h);
                                if (e[0]) return e[1];
                                e = this._findTableCode(7, 12, l, 64);
                                if (e[0]) return e[1];
                                e = this._findTableCode(10, 13, c);
                                if (e[0]) return e[1];
                            }
                            (0, a.info)('bad black code');
                            this._eatBits(1);
                            return 1;
                        }
                        _lookBits(e) {
                            let t;
                            for (; this.inputBits < e; ) {
                                if (-1 === (t = this.source.next()))
                                    return 0 === this.inputBits
                                        ? i
                                        : (this.inputBuf << (e - this.inputBits)) & (65535 >> (16 - e));
                                this.inputBuf = (this.inputBuf << 8) | t;
                                this.inputBits += 8;
                            }
                            return (this.inputBuf >> (this.inputBits - e)) & (65535 >> (16 - e));
                        }
                        _eatBits(e) {
                            (this.inputBits -= e) < 0 && (this.inputBits = 0);
                        }
                    };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.FlateStream = void 0;
                    var a = r(19),
                        i = r(2);
                    const n = new Int32Array([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]),
                        s = new Int32Array([
                            3, 4, 5, 6, 7, 8, 9, 10, 65547, 65549, 65551, 65553, 131091, 131095, 131099, 131103, 196643,
                            196651, 196659, 196667, 262211, 262227, 262243, 262259, 327811, 327843, 327875, 327907, 258,
                            258, 258,
                        ]),
                        o = new Int32Array([
                            1, 2, 3, 4, 65541, 65543, 131081, 131085, 196625, 196633, 262177, 262193, 327745, 327777,
                            393345, 393409, 459009, 459137, 524801, 525057, 590849, 591361, 657409, 658433, 724993,
                            727041, 794625, 798721, 868353, 876545,
                        ]),
                        c = [
                            new Int32Array([
                                459008, 524368, 524304, 524568, 459024, 524400, 524336, 590016, 459016, 524384, 524320,
                                589984, 524288, 524416, 524352, 590048, 459012, 524376, 524312, 589968, 459028, 524408,
                                524344, 590032, 459020, 524392, 524328, 59e4, 524296, 524424, 524360, 590064, 459010,
                                524372, 524308, 524572, 459026, 524404, 524340, 590024, 459018, 524388, 524324, 589992,
                                524292, 524420, 524356, 590056, 459014, 524380, 524316, 589976, 459030, 524412, 524348,
                                590040, 459022, 524396, 524332, 590008, 524300, 524428, 524364, 590072, 459009, 524370,
                                524306, 524570, 459025, 524402, 524338, 590020, 459017, 524386, 524322, 589988, 524290,
                                524418, 524354, 590052, 459013, 524378, 524314, 589972, 459029, 524410, 524346, 590036,
                                459021, 524394, 524330, 590004, 524298, 524426, 524362, 590068, 459011, 524374, 524310,
                                524574, 459027, 524406, 524342, 590028, 459019, 524390, 524326, 589996, 524294, 524422,
                                524358, 590060, 459015, 524382, 524318, 589980, 459031, 524414, 524350, 590044, 459023,
                                524398, 524334, 590012, 524302, 524430, 524366, 590076, 459008, 524369, 524305, 524569,
                                459024, 524401, 524337, 590018, 459016, 524385, 524321, 589986, 524289, 524417, 524353,
                                590050, 459012, 524377, 524313, 589970, 459028, 524409, 524345, 590034, 459020, 524393,
                                524329, 590002, 524297, 524425, 524361, 590066, 459010, 524373, 524309, 524573, 459026,
                                524405, 524341, 590026, 459018, 524389, 524325, 589994, 524293, 524421, 524357, 590058,
                                459014, 524381, 524317, 589978, 459030, 524413, 524349, 590042, 459022, 524397, 524333,
                                590010, 524301, 524429, 524365, 590074, 459009, 524371, 524307, 524571, 459025, 524403,
                                524339, 590022, 459017, 524387, 524323, 589990, 524291, 524419, 524355, 590054, 459013,
                                524379, 524315, 589974, 459029, 524411, 524347, 590038, 459021, 524395, 524331, 590006,
                                524299, 524427, 524363, 590070, 459011, 524375, 524311, 524575, 459027, 524407, 524343,
                                590030, 459019, 524391, 524327, 589998, 524295, 524423, 524359, 590062, 459015, 524383,
                                524319, 589982, 459031, 524415, 524351, 590046, 459023, 524399, 524335, 590014, 524303,
                                524431, 524367, 590078, 459008, 524368, 524304, 524568, 459024, 524400, 524336, 590017,
                                459016, 524384, 524320, 589985, 524288, 524416, 524352, 590049, 459012, 524376, 524312,
                                589969, 459028, 524408, 524344, 590033, 459020, 524392, 524328, 590001, 524296, 524424,
                                524360, 590065, 459010, 524372, 524308, 524572, 459026, 524404, 524340, 590025, 459018,
                                524388, 524324, 589993, 524292, 524420, 524356, 590057, 459014, 524380, 524316, 589977,
                                459030, 524412, 524348, 590041, 459022, 524396, 524332, 590009, 524300, 524428, 524364,
                                590073, 459009, 524370, 524306, 524570, 459025, 524402, 524338, 590021, 459017, 524386,
                                524322, 589989, 524290, 524418, 524354, 590053, 459013, 524378, 524314, 589973, 459029,
                                524410, 524346, 590037, 459021, 524394, 524330, 590005, 524298, 524426, 524362, 590069,
                                459011, 524374, 524310, 524574, 459027, 524406, 524342, 590029, 459019, 524390, 524326,
                                589997, 524294, 524422, 524358, 590061, 459015, 524382, 524318, 589981, 459031, 524414,
                                524350, 590045, 459023, 524398, 524334, 590013, 524302, 524430, 524366, 590077, 459008,
                                524369, 524305, 524569, 459024, 524401, 524337, 590019, 459016, 524385, 524321, 589987,
                                524289, 524417, 524353, 590051, 459012, 524377, 524313, 589971, 459028, 524409, 524345,
                                590035, 459020, 524393, 524329, 590003, 524297, 524425, 524361, 590067, 459010, 524373,
                                524309, 524573, 459026, 524405, 524341, 590027, 459018, 524389, 524325, 589995, 524293,
                                524421, 524357, 590059, 459014, 524381, 524317, 589979, 459030, 524413, 524349, 590043,
                                459022, 524397, 524333, 590011, 524301, 524429, 524365, 590075, 459009, 524371, 524307,
                                524571, 459025, 524403, 524339, 590023, 459017, 524387, 524323, 589991, 524291, 524419,
                                524355, 590055, 459013, 524379, 524315, 589975, 459029, 524411, 524347, 590039, 459021,
                                524395, 524331, 590007, 524299, 524427, 524363, 590071, 459011, 524375, 524311, 524575,
                                459027, 524407, 524343, 590031, 459019, 524391, 524327, 589999, 524295, 524423, 524359,
                                590063, 459015, 524383, 524319, 589983, 459031, 524415, 524351, 590047, 459023, 524399,
                                524335, 590015, 524303, 524431, 524367, 590079,
                            ]),
                            9,
                        ],
                        l = [
                            new Int32Array([
                                327680, 327696, 327688, 327704, 327684, 327700, 327692, 327708, 327682, 327698, 327690,
                                327706, 327686, 327702, 327694, 0, 327681, 327697, 327689, 327705, 327685, 327701,
                                327693, 327709, 327683, 327699, 327691, 327707, 327687, 327703, 327695, 0,
                            ]),
                            5,
                        ];
                    class FlateStream extends a.DecodeStream {
                        constructor(e, t) {
                            super(t);
                            this.str = e;
                            this.dict = e.dict;
                            const r = e.getByte(),
                                a = e.getByte();
                            if (-1 === r || -1 === a)
                                throw new i.FormatError(`Invalid header in flate stream: ${r}, ${a}`);
                            if (8 != (15 & r))
                                throw new i.FormatError(`Unknown compression method in flate stream: ${r}, ${a}`);
                            if (((r << 8) + a) % 31 != 0)
                                throw new i.FormatError(`Bad FCHECK in flate stream: ${r}, ${a}`);
                            if (32 & a) throw new i.FormatError(`FDICT bit set in flate stream: ${r}, ${a}`);
                            this.codeSize = 0;
                            this.codeBuf = 0;
                        }
                        getBits(e) {
                            const t = this.str;
                            let r,
                                a = this.codeSize,
                                n = this.codeBuf;
                            for (; a < e; ) {
                                if (-1 === (r = t.getByte())) throw new i.FormatError('Bad encoding in flate stream');
                                n |= r << a;
                                a += 8;
                            }
                            r = n & ((1 << e) - 1);
                            this.codeBuf = n >> e;
                            this.codeSize = a -= e;
                            return r;
                        }
                        getCode(e) {
                            const t = this.str,
                                r = e[0],
                                a = e[1];
                            let n,
                                s = this.codeSize,
                                o = this.codeBuf;
                            for (; s < a && -1 !== (n = t.getByte()); ) {
                                o |= n << s;
                                s += 8;
                            }
                            const c = r[o & ((1 << a) - 1)],
                                l = c >> 16,
                                h = 65535 & c;
                            if (l < 1 || s < l) throw new i.FormatError('Bad encoding in flate stream');
                            this.codeBuf = o >> l;
                            this.codeSize = s - l;
                            return h;
                        }
                        generateHuffmanTable(e) {
                            const t = e.length;
                            let r,
                                a = 0;
                            for (r = 0; r < t; ++r) e[r] > a && (a = e[r]);
                            const i = 1 << a,
                                n = new Int32Array(i);
                            for (let s = 1, o = 0, c = 2; s <= a; ++s, o <<= 1, c <<= 1)
                                for (let a = 0; a < t; ++a)
                                    if (e[a] === s) {
                                        let e = 0,
                                            t = o;
                                        for (r = 0; r < s; ++r) {
                                            e = (e << 1) | (1 & t);
                                            t >>= 1;
                                        }
                                        for (r = e; r < i; r += c) n[r] = (s << 16) | a;
                                        ++o;
                                    }
                            return [n, a];
                        }
                        readBlock() {
                            let e, t;
                            const r = this.str;
                            let a,
                                h,
                                u = this.getBits(3);
                            1 & u && (this.eof = !0);
                            u >>= 1;
                            if (0 === u) {
                                let t;
                                if (-1 === (t = r.getByte()))
                                    throw new i.FormatError('Bad block header in flate stream');
                                let a = t;
                                if (-1 === (t = r.getByte()))
                                    throw new i.FormatError('Bad block header in flate stream');
                                a |= t << 8;
                                if (-1 === (t = r.getByte()))
                                    throw new i.FormatError('Bad block header in flate stream');
                                let n = t;
                                if (-1 === (t = r.getByte()))
                                    throw new i.FormatError('Bad block header in flate stream');
                                n |= t << 8;
                                if (n !== (65535 & ~a) && (0 !== a || 0 !== n))
                                    throw new i.FormatError('Bad uncompressed block length in flate stream');
                                this.codeBuf = 0;
                                this.codeSize = 0;
                                const s = this.bufferLength,
                                    o = s + a;
                                e = this.ensureBuffer(o);
                                this.bufferLength = o;
                                if (0 === a) -1 === r.peekByte() && (this.eof = !0);
                                else {
                                    const t = r.getBytes(a);
                                    e.set(t, s);
                                    t.length < a && (this.eof = !0);
                                }
                                return;
                            }
                            if (1 === u) {
                                a = c;
                                h = l;
                            } else {
                                if (2 !== u) throw new i.FormatError('Unknown block type in flate stream');
                                {
                                    const e = this.getBits(5) + 257,
                                        r = this.getBits(5) + 1,
                                        i = this.getBits(4) + 4,
                                        s = new Uint8Array(n.length);
                                    let o;
                                    for (o = 0; o < i; ++o) s[n[o]] = this.getBits(3);
                                    const c = this.generateHuffmanTable(s);
                                    t = 0;
                                    o = 0;
                                    const l = e + r,
                                        u = new Uint8Array(l);
                                    let d, f, g;
                                    for (; o < l; ) {
                                        const e = this.getCode(c);
                                        if (16 === e) {
                                            d = 2;
                                            f = 3;
                                            g = t;
                                        } else if (17 === e) {
                                            d = 3;
                                            f = 3;
                                            g = t = 0;
                                        } else {
                                            if (18 !== e) {
                                                u[o++] = t = e;
                                                continue;
                                            }
                                            d = 7;
                                            f = 11;
                                            g = t = 0;
                                        }
                                        let r = this.getBits(d) + f;
                                        for (; r-- > 0; ) u[o++] = g;
                                    }
                                    a = this.generateHuffmanTable(u.subarray(0, e));
                                    h = this.generateHuffmanTable(u.subarray(e, l));
                                }
                            }
                            e = this.buffer;
                            let d = e ? e.length : 0,
                                f = this.bufferLength;
                            for (;;) {
                                let r = this.getCode(a);
                                if (r < 256) {
                                    if (f + 1 >= d) {
                                        e = this.ensureBuffer(f + 1);
                                        d = e.length;
                                    }
                                    e[f++] = r;
                                    continue;
                                }
                                if (256 === r) {
                                    this.bufferLength = f;
                                    return;
                                }
                                r -= 257;
                                r = s[r];
                                let i = r >> 16;
                                i > 0 && (i = this.getBits(i));
                                t = (65535 & r) + i;
                                r = this.getCode(h);
                                r = o[r];
                                i = r >> 16;
                                i > 0 && (i = this.getBits(i));
                                const n = (65535 & r) + i;
                                if (f + t >= d) {
                                    e = this.ensureBuffer(f + t);
                                    d = e.length;
                                }
                                for (let r = 0; r < t; ++r, ++f) e[f] = e[f - n];
                            }
                        }
                    }
                    t.FlateStream = FlateStream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.Jbig2Stream = void 0;
                    var a = r(5),
                        i = r(19),
                        n = r(25),
                        s = r(2);
                    class Jbig2Stream extends i.DecodeStream {
                        constructor(e, t, r) {
                            super(t);
                            this.stream = e;
                            this.dict = e.dict;
                            this.maybeLength = t;
                            this.params = r;
                        }
                        get bytes() {
                            return (0, s.shadow)(this, 'bytes', this.stream.getBytes(this.maybeLength));
                        }
                        ensureBuffer(e) {}
                        readBlock() {
                            if (this.eof) return;
                            const e = new n.Jbig2Image(),
                                t = [];
                            if ((0, a.isDict)(this.params)) {
                                const e = this.params.get('JBIG2Globals');
                                if ((0, a.isStream)(e)) {
                                    const r = e.getBytes();
                                    t.push({ data: r, start: 0, end: r.length });
                                }
                            }
                            t.push({ data: this.bytes, start: 0, end: this.bytes.length });
                            const r = e.parseChunks(t),
                                i = r.length;
                            for (let e = 0; e < i; e++) r[e] ^= 255;
                            this.buffer = r;
                            this.bufferLength = i;
                            this.eof = !0;
                        }
                    }
                    t.Jbig2Stream = Jbig2Stream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.Jbig2Image = void 0;
                    var a = r(2),
                        i = r(9),
                        n = r(26),
                        s = r(22);
                    class Jbig2Error extends a.BaseException {
                        constructor(e) {
                            super(`JBIG2 error: ${e}`);
                        }
                    }
                    class ContextCache {
                        getContexts(e) {
                            return e in this ? this[e] : (this[e] = new Int8Array(65536));
                        }
                    }
                    class DecodingContext {
                        constructor(e, t, r) {
                            this.data = e;
                            this.start = t;
                            this.end = r;
                        }
                        get decoder() {
                            const e = new n.ArithmeticDecoder(this.data, this.start, this.end);
                            return (0, a.shadow)(this, 'decoder', e);
                        }
                        get contextCache() {
                            const e = new ContextCache();
                            return (0, a.shadow)(this, 'contextCache', e);
                        }
                    }
                    function decodeInteger(e, t, r) {
                        const a = e.getContexts(t);
                        let i = 1;
                        function readBits(e) {
                            let t = 0;
                            for (let n = 0; n < e; n++) {
                                const e = r.readBit(a, i);
                                i = i < 256 ? (i << 1) | e : (511 & ((i << 1) | e)) | 256;
                                t = (t << 1) | e;
                            }
                            return t >>> 0;
                        }
                        const n = readBits(1),
                            s = readBits(1)
                                ? readBits(1)
                                    ? readBits(1)
                                        ? readBits(1)
                                            ? readBits(1)
                                                ? readBits(32) + 4436
                                                : readBits(12) + 340
                                            : readBits(8) + 84
                                        : readBits(6) + 20
                                    : readBits(4) + 4
                                : readBits(2);
                        return 0 === n ? s : s > 0 ? -s : null;
                    }
                    function decodeIAID(e, t, r) {
                        const a = e.getContexts('IAID');
                        let i = 1;
                        for (let e = 0; e < r; e++) {
                            i = (i << 1) | t.readBit(a, i);
                        }
                        return r < 31 ? i & ((1 << r) - 1) : 2147483647 & i;
                    }
                    const o = [
                            'SymbolDictionary',
                            null,
                            null,
                            null,
                            'IntermediateTextRegion',
                            null,
                            'ImmediateTextRegion',
                            'ImmediateLosslessTextRegion',
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            'PatternDictionary',
                            null,
                            null,
                            null,
                            'IntermediateHalftoneRegion',
                            null,
                            'ImmediateHalftoneRegion',
                            'ImmediateLosslessHalftoneRegion',
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            'IntermediateGenericRegion',
                            null,
                            'ImmediateGenericRegion',
                            'ImmediateLosslessGenericRegion',
                            'IntermediateGenericRefinementRegion',
                            null,
                            'ImmediateGenericRefinementRegion',
                            'ImmediateLosslessGenericRefinementRegion',
                            null,
                            null,
                            null,
                            null,
                            'PageInformation',
                            'EndOfPage',
                            'EndOfStripe',
                            'EndOfFile',
                            'Profiles',
                            'Tables',
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            null,
                            'Extension',
                        ],
                        c = [
                            [
                                { x: -1, y: -2 },
                                { x: 0, y: -2 },
                                { x: 1, y: -2 },
                                { x: -2, y: -1 },
                                { x: -1, y: -1 },
                                { x: 0, y: -1 },
                                { x: 1, y: -1 },
                                { x: 2, y: -1 },
                                { x: -4, y: 0 },
                                { x: -3, y: 0 },
                                { x: -2, y: 0 },
                                { x: -1, y: 0 },
                            ],
                            [
                                { x: -1, y: -2 },
                                { x: 0, y: -2 },
                                { x: 1, y: -2 },
                                { x: 2, y: -2 },
                                { x: -2, y: -1 },
                                { x: -1, y: -1 },
                                { x: 0, y: -1 },
                                { x: 1, y: -1 },
                                { x: 2, y: -1 },
                                { x: -3, y: 0 },
                                { x: -2, y: 0 },
                                { x: -1, y: 0 },
                            ],
                            [
                                { x: -1, y: -2 },
                                { x: 0, y: -2 },
                                { x: 1, y: -2 },
                                { x: -2, y: -1 },
                                { x: -1, y: -1 },
                                { x: 0, y: -1 },
                                { x: 1, y: -1 },
                                { x: -2, y: 0 },
                                { x: -1, y: 0 },
                            ],
                            [
                                { x: -3, y: -1 },
                                { x: -2, y: -1 },
                                { x: -1, y: -1 },
                                { x: 0, y: -1 },
                                { x: 1, y: -1 },
                                { x: -4, y: 0 },
                                { x: -3, y: 0 },
                                { x: -2, y: 0 },
                                { x: -1, y: 0 },
                            ],
                        ],
                        l = [
                            {
                                coding: [
                                    { x: 0, y: -1 },
                                    { x: 1, y: -1 },
                                    { x: -1, y: 0 },
                                ],
                                reference: [
                                    { x: 0, y: -1 },
                                    { x: 1, y: -1 },
                                    { x: -1, y: 0 },
                                    { x: 0, y: 0 },
                                    { x: 1, y: 0 },
                                    { x: -1, y: 1 },
                                    { x: 0, y: 1 },
                                    { x: 1, y: 1 },
                                ],
                            },
                            {
                                coding: [
                                    { x: -1, y: -1 },
                                    { x: 0, y: -1 },
                                    { x: 1, y: -1 },
                                    { x: -1, y: 0 },
                                ],
                                reference: [
                                    { x: 0, y: -1 },
                                    { x: -1, y: 0 },
                                    { x: 0, y: 0 },
                                    { x: 1, y: 0 },
                                    { x: 0, y: 1 },
                                    { x: 1, y: 1 },
                                ],
                            },
                        ],
                        h = [39717, 1941, 229, 405],
                        u = [32, 8];
                    function decodeBitmap(e, t, r, a, i, n, s, o) {
                        if (e) {
                            return decodeMMRBitmap(new Reader(o.data, o.start, o.end), t, r, !1);
                        }
                        if (
                            0 === a &&
                            !n &&
                            !i &&
                            4 === s.length &&
                            3 === s[0].x &&
                            -1 === s[0].y &&
                            -3 === s[1].x &&
                            -1 === s[1].y &&
                            2 === s[2].x &&
                            -2 === s[2].y &&
                            -2 === s[3].x &&
                            -2 === s[3].y
                        )
                            return (function decodeBitmapTemplate0(e, t, r) {
                                const a = r.decoder,
                                    i = r.contextCache.getContexts('GB'),
                                    n = [];
                                let s, o, c, l, h, u, d;
                                for (o = 0; o < t; o++) {
                                    h = n[o] = new Uint8Array(e);
                                    u = o < 1 ? h : n[o - 1];
                                    d = o < 2 ? h : n[o - 2];
                                    s =
                                        (d[0] << 13) |
                                        (d[1] << 12) |
                                        (d[2] << 11) |
                                        (u[0] << 7) |
                                        (u[1] << 6) |
                                        (u[2] << 5) |
                                        (u[3] << 4);
                                    for (c = 0; c < e; c++) {
                                        h[c] = l = a.readBit(i, s);
                                        s =
                                            ((31735 & s) << 1) |
                                            (c + 3 < e ? d[c + 3] << 11 : 0) |
                                            (c + 4 < e ? u[c + 4] << 4 : 0) |
                                            l;
                                    }
                                }
                                return n;
                            })(t, r, o);
                        const l = !!n,
                            u = c[a].concat(s);
                        u.sort(function (e, t) {
                            return e.y - t.y || e.x - t.x;
                        });
                        const d = u.length,
                            f = new Int8Array(d),
                            g = new Int8Array(d),
                            p = [];
                        let m,
                            b,
                            y = 0,
                            w = 0,
                            S = 0,
                            x = 0;
                        for (b = 0; b < d; b++) {
                            f[b] = u[b].x;
                            g[b] = u[b].y;
                            w = Math.min(w, u[b].x);
                            S = Math.max(S, u[b].x);
                            x = Math.min(x, u[b].y);
                            b < d - 1 && u[b].y === u[b + 1].y && u[b].x === u[b + 1].x - 1
                                ? (y |= 1 << (d - 1 - b))
                                : p.push(b);
                        }
                        const k = p.length,
                            C = new Int8Array(k),
                            v = new Int8Array(k),
                            O = new Uint16Array(k);
                        for (m = 0; m < k; m++) {
                            b = p[m];
                            C[m] = u[b].x;
                            v[m] = u[b].y;
                            O[m] = 1 << (d - 1 - b);
                        }
                        const F = -w,
                            T = -x,
                            E = t - S,
                            M = h[a];
                        let D = new Uint8Array(t);
                        const N = [],
                            L = o.decoder,
                            R = o.contextCache.getContexts('GB');
                        let j,
                            _,
                            U,
                            $,
                            X,
                            q = 0,
                            H = 0;
                        for (let e = 0; e < r; e++) {
                            if (i) {
                                q ^= L.readBit(R, M);
                                if (q) {
                                    N.push(D);
                                    continue;
                                }
                            }
                            D = new Uint8Array(D);
                            N.push(D);
                            for (j = 0; j < t; j++) {
                                if (l && n[e][j]) {
                                    D[j] = 0;
                                    continue;
                                }
                                if (j >= F && j < E && e >= T) {
                                    H = (H << 1) & y;
                                    for (b = 0; b < k; b++) {
                                        _ = e + v[b];
                                        U = j + C[b];
                                        $ = N[_][U];
                                        if ($) {
                                            $ = O[b];
                                            H |= $;
                                        }
                                    }
                                } else {
                                    H = 0;
                                    X = d - 1;
                                    for (b = 0; b < d; b++, X--) {
                                        U = j + f[b];
                                        if (U >= 0 && U < t) {
                                            _ = e + g[b];
                                            if (_ >= 0) {
                                                $ = N[_][U];
                                                $ && (H |= $ << X);
                                            }
                                        }
                                    }
                                }
                                const r = L.readBit(R, H);
                                D[j] = r;
                            }
                        }
                        return N;
                    }
                    function decodeRefinement(e, t, r, a, i, n, s, o, c) {
                        let h = l[r].coding;
                        0 === r && (h = h.concat([o[0]]));
                        const d = h.length,
                            f = new Int32Array(d),
                            g = new Int32Array(d);
                        let p;
                        for (p = 0; p < d; p++) {
                            f[p] = h[p].x;
                            g[p] = h[p].y;
                        }
                        let m = l[r].reference;
                        0 === r && (m = m.concat([o[1]]));
                        const b = m.length,
                            y = new Int32Array(b),
                            w = new Int32Array(b);
                        for (p = 0; p < b; p++) {
                            y[p] = m[p].x;
                            w[p] = m[p].y;
                        }
                        const S = a[0].length,
                            x = a.length,
                            k = u[r],
                            C = [],
                            v = c.decoder,
                            O = c.contextCache.getContexts('GR');
                        let F = 0;
                        for (let r = 0; r < t; r++) {
                            if (s) {
                                F ^= v.readBit(O, k);
                                if (F) throw new Jbig2Error('prediction is not supported');
                            }
                            const t = new Uint8Array(e);
                            C.push(t);
                            for (let s = 0; s < e; s++) {
                                let o,
                                    c,
                                    l = 0;
                                for (p = 0; p < d; p++) {
                                    o = r + g[p];
                                    c = s + f[p];
                                    o < 0 || c < 0 || c >= e ? (l <<= 1) : (l = (l << 1) | C[o][c]);
                                }
                                for (p = 0; p < b; p++) {
                                    o = r + w[p] - n;
                                    c = s + y[p] - i;
                                    o < 0 || o >= x || c < 0 || c >= S ? (l <<= 1) : (l = (l << 1) | a[o][c]);
                                }
                                const h = v.readBit(O, l);
                                t[s] = h;
                            }
                        }
                        return C;
                    }
                    function decodeTextRegion(e, t, r, a, i, n, s, o, c, l, h, u, d, f, g, p, m, b, y) {
                        if (e && t) throw new Jbig2Error('refinement with Huffman is not supported');
                        const w = [];
                        let S, x;
                        for (S = 0; S < a; S++) {
                            x = new Uint8Array(r);
                            if (i) for (let e = 0; e < r; e++) x[e] = i;
                            w.push(x);
                        }
                        const k = m.decoder,
                            C = m.contextCache;
                        let v = e ? -f.tableDeltaT.decode(y) : -decodeInteger(C, 'IADT', k),
                            O = 0;
                        S = 0;
                        for (; S < n; ) {
                            v += e ? f.tableDeltaT.decode(y) : decodeInteger(C, 'IADT', k);
                            O += e ? f.tableFirstS.decode(y) : decodeInteger(C, 'IAFS', k);
                            let a = O;
                            for (;;) {
                                let i = 0;
                                s > 1 && (i = e ? y.readBits(b) : decodeInteger(C, 'IAIT', k));
                                const n = s * v + i,
                                    O = e ? f.symbolIDTable.decode(y) : decodeIAID(C, k, c),
                                    F = t && (e ? y.readBit() : decodeInteger(C, 'IARI', k));
                                let T = o[O],
                                    E = T[0].length,
                                    M = T.length;
                                if (F) {
                                    const e = decodeInteger(C, 'IARDW', k),
                                        t = decodeInteger(C, 'IARDH', k),
                                        r = decodeInteger(C, 'IARDX', k),
                                        a = decodeInteger(C, 'IARDY', k);
                                    E += e;
                                    M += t;
                                    T = decodeRefinement(E, M, g, T, (e >> 1) + r, (t >> 1) + a, !1, p, m);
                                }
                                const D = n - (1 & u ? 0 : M - 1),
                                    N = a - (2 & u ? E - 1 : 0);
                                let L, R, j;
                                if (l) {
                                    for (L = 0; L < M; L++) {
                                        x = w[N + L];
                                        if (!x) continue;
                                        j = T[L];
                                        const e = Math.min(r - D, E);
                                        switch (d) {
                                            case 0:
                                                for (R = 0; R < e; R++) x[D + R] |= j[R];
                                                break;
                                            case 2:
                                                for (R = 0; R < e; R++) x[D + R] ^= j[R];
                                                break;
                                            default:
                                                throw new Jbig2Error(`operator ${d} is not supported`);
                                        }
                                    }
                                    a += M - 1;
                                } else {
                                    for (R = 0; R < M; R++) {
                                        x = w[D + R];
                                        if (x) {
                                            j = T[R];
                                            switch (d) {
                                                case 0:
                                                    for (L = 0; L < E; L++) x[N + L] |= j[L];
                                                    break;
                                                case 2:
                                                    for (L = 0; L < E; L++) x[N + L] ^= j[L];
                                                    break;
                                                default:
                                                    throw new Jbig2Error(`operator ${d} is not supported`);
                                            }
                                        }
                                    }
                                    a += E - 1;
                                }
                                S++;
                                const _ = e ? f.tableDeltaS.decode(y) : decodeInteger(C, 'IADS', k);
                                if (null === _) break;
                                a += _ + h;
                            }
                        }
                        return w;
                    }
                    function readSegmentHeader(e, t) {
                        const r = {};
                        r.number = (0, i.readUint32)(e, t);
                        const a = e[t + 4],
                            n = 63 & a;
                        if (!o[n]) throw new Jbig2Error('invalid segment type: ' + n);
                        r.type = n;
                        r.typeName = o[n];
                        r.deferredNonRetain = !!(128 & a);
                        const s = !!(64 & a),
                            c = e[t + 5];
                        let l = (c >> 5) & 7;
                        const h = [31 & c];
                        let u = t + 6;
                        if (7 === c) {
                            l = 536870911 & (0, i.readUint32)(e, u - 1);
                            u += 3;
                            let t = (l + 7) >> 3;
                            h[0] = e[u++];
                            for (; --t > 0; ) h.push(e[u++]);
                        } else if (5 === c || 6 === c) throw new Jbig2Error('invalid referred-to flags');
                        r.retainBits = h;
                        let f = 4;
                        r.number <= 256 ? (f = 1) : r.number <= 65536 && (f = 2);
                        const g = [];
                        let p, m;
                        for (p = 0; p < l; p++) {
                            let t;
                            t = 1 === f ? e[u] : 2 === f ? (0, i.readUint16)(e, u) : (0, i.readUint32)(e, u);
                            g.push(t);
                            u += f;
                        }
                        r.referredTo = g;
                        if (s) {
                            r.pageAssociation = (0, i.readUint32)(e, u);
                            u += 4;
                        } else r.pageAssociation = e[u++];
                        r.length = (0, i.readUint32)(e, u);
                        u += 4;
                        if (4294967295 === r.length) {
                            if (38 !== n) throw new Jbig2Error('invalid unknown segment length');
                            {
                                const t = readRegionSegmentInformation(e, u),
                                    a = !!(1 & e[u + d]),
                                    i = 6,
                                    n = new Uint8Array(i);
                                if (!a) {
                                    n[0] = 255;
                                    n[1] = 172;
                                }
                                n[2] = (t.height >>> 24) & 255;
                                n[3] = (t.height >> 16) & 255;
                                n[4] = (t.height >> 8) & 255;
                                n[5] = 255 & t.height;
                                for (p = u, m = e.length; p < m; p++) {
                                    let t = 0;
                                    for (; t < i && n[t] === e[p + t]; ) t++;
                                    if (t === i) {
                                        r.length = p + i;
                                        break;
                                    }
                                }
                                if (4294967295 === r.length) throw new Jbig2Error('segment end was not found');
                            }
                        }
                        r.headerEnd = u;
                        return r;
                    }
                    function readSegments(e, t, r, a) {
                        const i = [];
                        let n = r;
                        for (; n < a; ) {
                            const r = readSegmentHeader(t, n);
                            n = r.headerEnd;
                            const a = { header: r, data: t };
                            if (!e.randomAccess) {
                                a.start = n;
                                n += r.length;
                                a.end = n;
                            }
                            i.push(a);
                            if (51 === r.type) break;
                        }
                        if (e.randomAccess)
                            for (let e = 0, t = i.length; e < t; e++) {
                                i[e].start = n;
                                n += i[e].header.length;
                                i[e].end = n;
                            }
                        return i;
                    }
                    function readRegionSegmentInformation(e, t) {
                        return {
                            width: (0, i.readUint32)(e, t),
                            height: (0, i.readUint32)(e, t + 4),
                            x: (0, i.readUint32)(e, t + 8),
                            y: (0, i.readUint32)(e, t + 12),
                            combinationOperator: 7 & e[t + 16],
                        };
                    }
                    const d = 17;
                    function processSegment(e, t) {
                        const r = e.header,
                            a = e.data,
                            n = e.end;
                        let s,
                            o,
                            c,
                            l,
                            h = e.start;
                        switch (r.type) {
                            case 0:
                                const e = {},
                                    t = (0, i.readUint16)(a, h);
                                e.huffman = !!(1 & t);
                                e.refinement = !!(2 & t);
                                e.huffmanDHSelector = (t >> 2) & 3;
                                e.huffmanDWSelector = (t >> 4) & 3;
                                e.bitmapSizeSelector = (t >> 6) & 1;
                                e.aggregationInstancesSelector = (t >> 7) & 1;
                                e.bitmapCodingContextUsed = !!(256 & t);
                                e.bitmapCodingContextRetained = !!(512 & t);
                                e.template = (t >> 10) & 3;
                                e.refinementTemplate = (t >> 12) & 1;
                                h += 2;
                                if (!e.huffman) {
                                    l = 0 === e.template ? 4 : 1;
                                    o = [];
                                    for (c = 0; c < l; c++) {
                                        o.push({ x: (0, i.readInt8)(a, h), y: (0, i.readInt8)(a, h + 1) });
                                        h += 2;
                                    }
                                    e.at = o;
                                }
                                if (e.refinement && !e.refinementTemplate) {
                                    o = [];
                                    for (c = 0; c < 2; c++) {
                                        o.push({ x: (0, i.readInt8)(a, h), y: (0, i.readInt8)(a, h + 1) });
                                        h += 2;
                                    }
                                    e.refinementAt = o;
                                }
                                e.numberOfExportedSymbols = (0, i.readUint32)(a, h);
                                h += 4;
                                e.numberOfNewSymbols = (0, i.readUint32)(a, h);
                                h += 4;
                                s = [e, r.number, r.referredTo, a, h, n];
                                break;
                            case 6:
                            case 7:
                                const u = {};
                                u.info = readRegionSegmentInformation(a, h);
                                h += d;
                                const f = (0, i.readUint16)(a, h);
                                h += 2;
                                u.huffman = !!(1 & f);
                                u.refinement = !!(2 & f);
                                u.logStripSize = (f >> 2) & 3;
                                u.stripSize = 1 << u.logStripSize;
                                u.referenceCorner = (f >> 4) & 3;
                                u.transposed = !!(64 & f);
                                u.combinationOperator = (f >> 7) & 3;
                                u.defaultPixelValue = (f >> 9) & 1;
                                u.dsOffset = (f << 17) >> 27;
                                u.refinementTemplate = (f >> 15) & 1;
                                if (u.huffman) {
                                    const e = (0, i.readUint16)(a, h);
                                    h += 2;
                                    u.huffmanFS = 3 & e;
                                    u.huffmanDS = (e >> 2) & 3;
                                    u.huffmanDT = (e >> 4) & 3;
                                    u.huffmanRefinementDW = (e >> 6) & 3;
                                    u.huffmanRefinementDH = (e >> 8) & 3;
                                    u.huffmanRefinementDX = (e >> 10) & 3;
                                    u.huffmanRefinementDY = (e >> 12) & 3;
                                    u.huffmanRefinementSizeSelector = !!(16384 & e);
                                }
                                if (u.refinement && !u.refinementTemplate) {
                                    o = [];
                                    for (c = 0; c < 2; c++) {
                                        o.push({ x: (0, i.readInt8)(a, h), y: (0, i.readInt8)(a, h + 1) });
                                        h += 2;
                                    }
                                    u.refinementAt = o;
                                }
                                u.numberOfSymbolInstances = (0, i.readUint32)(a, h);
                                h += 4;
                                s = [u, r.referredTo, a, h, n];
                                break;
                            case 16:
                                const g = {},
                                    p = a[h++];
                                g.mmr = !!(1 & p);
                                g.template = (p >> 1) & 3;
                                g.patternWidth = a[h++];
                                g.patternHeight = a[h++];
                                g.maxPatternIndex = (0, i.readUint32)(a, h);
                                h += 4;
                                s = [g, r.number, a, h, n];
                                break;
                            case 22:
                            case 23:
                                const m = {};
                                m.info = readRegionSegmentInformation(a, h);
                                h += d;
                                const b = a[h++];
                                m.mmr = !!(1 & b);
                                m.template = (b >> 1) & 3;
                                m.enableSkip = !!(8 & b);
                                m.combinationOperator = (b >> 4) & 7;
                                m.defaultPixelValue = (b >> 7) & 1;
                                m.gridWidth = (0, i.readUint32)(a, h);
                                h += 4;
                                m.gridHeight = (0, i.readUint32)(a, h);
                                h += 4;
                                m.gridOffsetX = 4294967295 & (0, i.readUint32)(a, h);
                                h += 4;
                                m.gridOffsetY = 4294967295 & (0, i.readUint32)(a, h);
                                h += 4;
                                m.gridVectorX = (0, i.readUint16)(a, h);
                                h += 2;
                                m.gridVectorY = (0, i.readUint16)(a, h);
                                h += 2;
                                s = [m, r.referredTo, a, h, n];
                                break;
                            case 38:
                            case 39:
                                const y = {};
                                y.info = readRegionSegmentInformation(a, h);
                                h += d;
                                const w = a[h++];
                                y.mmr = !!(1 & w);
                                y.template = (w >> 1) & 3;
                                y.prediction = !!(8 & w);
                                if (!y.mmr) {
                                    l = 0 === y.template ? 4 : 1;
                                    o = [];
                                    for (c = 0; c < l; c++) {
                                        o.push({ x: (0, i.readInt8)(a, h), y: (0, i.readInt8)(a, h + 1) });
                                        h += 2;
                                    }
                                    y.at = o;
                                }
                                s = [y, a, h, n];
                                break;
                            case 48:
                                const S = {
                                    width: (0, i.readUint32)(a, h),
                                    height: (0, i.readUint32)(a, h + 4),
                                    resolutionX: (0, i.readUint32)(a, h + 8),
                                    resolutionY: (0, i.readUint32)(a, h + 12),
                                };
                                4294967295 === S.height && delete S.height;
                                const x = a[h + 16];
                                (0, i.readUint16)(a, h + 17);
                                S.lossless = !!(1 & x);
                                S.refinement = !!(2 & x);
                                S.defaultPixelValue = (x >> 2) & 1;
                                S.combinationOperator = (x >> 3) & 3;
                                S.requiresBuffer = !!(32 & x);
                                S.combinationOperatorOverride = !!(64 & x);
                                s = [S];
                                break;
                            case 49:
                            case 50:
                            case 51:
                                break;
                            case 53:
                                s = [r.number, a, h, n];
                                break;
                            case 62:
                                break;
                            default:
                                throw new Jbig2Error(`segment type ${r.typeName}(${r.type}) is not implemented`);
                        }
                        const u = 'on' + r.typeName;
                        u in t && t[u].apply(t, s);
                    }
                    function processSegments(e, t) {
                        for (let r = 0, a = e.length; r < a; r++) processSegment(e[r], t);
                    }
                    class SimpleSegmentVisitor {
                        onPageInformation(e) {
                            this.currentPageInfo = e;
                            const t = (e.width + 7) >> 3,
                                r = new Uint8ClampedArray(t * e.height);
                            if (e.defaultPixelValue) for (let e = 0, t = r.length; e < t; e++) r[e] = 255;
                            this.buffer = r;
                        }
                        drawBitmap(e, t) {
                            const r = this.currentPageInfo,
                                a = e.width,
                                i = e.height,
                                n = (r.width + 7) >> 3,
                                s = r.combinationOperatorOverride ? e.combinationOperator : r.combinationOperator,
                                o = this.buffer,
                                c = 128 >> (7 & e.x);
                            let l,
                                h,
                                u,
                                d,
                                f = e.y * n + (e.x >> 3);
                            switch (s) {
                                case 0:
                                    for (l = 0; l < i; l++) {
                                        u = c;
                                        d = f;
                                        for (h = 0; h < a; h++) {
                                            t[l][h] && (o[d] |= u);
                                            u >>= 1;
                                            if (!u) {
                                                u = 128;
                                                d++;
                                            }
                                        }
                                        f += n;
                                    }
                                    break;
                                case 2:
                                    for (l = 0; l < i; l++) {
                                        u = c;
                                        d = f;
                                        for (h = 0; h < a; h++) {
                                            t[l][h] && (o[d] ^= u);
                                            u >>= 1;
                                            if (!u) {
                                                u = 128;
                                                d++;
                                            }
                                        }
                                        f += n;
                                    }
                                    break;
                                default:
                                    throw new Jbig2Error(`operator ${s} is not supported`);
                            }
                        }
                        onImmediateGenericRegion(e, t, r, a) {
                            const i = e.info,
                                n = new DecodingContext(t, r, a),
                                s = decodeBitmap(e.mmr, i.width, i.height, e.template, e.prediction, null, e.at, n);
                            this.drawBitmap(i, s);
                        }
                        onImmediateLosslessGenericRegion() {
                            this.onImmediateGenericRegion.apply(this, arguments);
                        }
                        onSymbolDictionary(e, t, r, a, n, s) {
                            let o, c;
                            if (e.huffman) {
                                o = (function getSymbolDictionaryHuffmanTables(e, t, r) {
                                    let a,
                                        i,
                                        n,
                                        s,
                                        o = 0;
                                    switch (e.huffmanDHSelector) {
                                        case 0:
                                        case 1:
                                            a = getStandardTable(e.huffmanDHSelector + 4);
                                            break;
                                        case 3:
                                            a = getCustomHuffmanTable(o, t, r);
                                            o++;
                                            break;
                                        default:
                                            throw new Jbig2Error('invalid Huffman DH selector');
                                    }
                                    switch (e.huffmanDWSelector) {
                                        case 0:
                                        case 1:
                                            i = getStandardTable(e.huffmanDWSelector + 2);
                                            break;
                                        case 3:
                                            i = getCustomHuffmanTable(o, t, r);
                                            o++;
                                            break;
                                        default:
                                            throw new Jbig2Error('invalid Huffman DW selector');
                                    }
                                    if (e.bitmapSizeSelector) {
                                        n = getCustomHuffmanTable(o, t, r);
                                        o++;
                                    } else n = getStandardTable(1);
                                    s = e.aggregationInstancesSelector
                                        ? getCustomHuffmanTable(o, t, r)
                                        : getStandardTable(1);
                                    return {
                                        tableDeltaHeight: a,
                                        tableDeltaWidth: i,
                                        tableBitmapSize: n,
                                        tableAggregateInstances: s,
                                    };
                                })(e, r, this.customTables);
                                c = new Reader(a, n, s);
                            }
                            let l = this.symbols;
                            l || (this.symbols = l = {});
                            let h = [];
                            for (let e = 0, t = r.length; e < t; e++) {
                                const t = l[r[e]];
                                t && (h = h.concat(t));
                            }
                            const u = new DecodingContext(a, n, s);
                            l[t] = (function decodeSymbolDictionary(e, t, r, a, n, s, o, c, l, h, u, d) {
                                if (e && t) throw new Jbig2Error('symbol refinement with Huffman is not supported');
                                const f = [];
                                let g = 0,
                                    p = (0, i.log2)(r.length + a);
                                const m = u.decoder,
                                    b = u.contextCache;
                                let y, w;
                                if (e) {
                                    y = getStandardTable(1);
                                    w = [];
                                    p = Math.max(p, 1);
                                }
                                for (; f.length < a; ) {
                                    g += e ? s.tableDeltaHeight.decode(d) : decodeInteger(b, 'IADH', m);
                                    let a = 0,
                                        i = 0;
                                    const n = e ? w.length : 0;
                                    for (;;) {
                                        const n = e ? s.tableDeltaWidth.decode(d) : decodeInteger(b, 'IADW', m);
                                        if (null === n) break;
                                        a += n;
                                        i += a;
                                        let y;
                                        if (t) {
                                            const i = decodeInteger(b, 'IAAI', m);
                                            if (i > 1)
                                                y = decodeTextRegion(
                                                    e,
                                                    t,
                                                    a,
                                                    g,
                                                    0,
                                                    i,
                                                    1,
                                                    r.concat(f),
                                                    p,
                                                    0,
                                                    0,
                                                    1,
                                                    0,
                                                    s,
                                                    l,
                                                    h,
                                                    u,
                                                    0,
                                                    d
                                                );
                                            else {
                                                const e = decodeIAID(b, m, p),
                                                    t = decodeInteger(b, 'IARDX', m),
                                                    i = decodeInteger(b, 'IARDY', m);
                                                y = decodeRefinement(
                                                    a,
                                                    g,
                                                    l,
                                                    e < r.length ? r[e] : f[e - r.length],
                                                    t,
                                                    i,
                                                    !1,
                                                    h,
                                                    u
                                                );
                                            }
                                            f.push(y);
                                        } else if (e) w.push(a);
                                        else {
                                            y = decodeBitmap(!1, a, g, o, !1, null, c, u);
                                            f.push(y);
                                        }
                                    }
                                    if (e && !t) {
                                        const e = s.tableBitmapSize.decode(d);
                                        d.byteAlign();
                                        let t;
                                        if (0 === e) t = readUncompressedBitmap(d, i, g);
                                        else {
                                            const r = d.end,
                                                a = d.position + e;
                                            d.end = a;
                                            t = decodeMMRBitmap(d, i, g, !1);
                                            d.end = r;
                                            d.position = a;
                                        }
                                        const r = w.length;
                                        if (n === r - 1) f.push(t);
                                        else {
                                            let e,
                                                a,
                                                i,
                                                s,
                                                o,
                                                c = 0;
                                            for (e = n; e < r; e++) {
                                                s = w[e];
                                                i = c + s;
                                                o = [];
                                                for (a = 0; a < g; a++) o.push(t[a].subarray(c, i));
                                                f.push(o);
                                                c = i;
                                            }
                                        }
                                    }
                                }
                                const S = [],
                                    x = [];
                                let k,
                                    C,
                                    v = !1;
                                const O = r.length + a;
                                for (; x.length < O; ) {
                                    let t = e ? y.decode(d) : decodeInteger(b, 'IAEX', m);
                                    for (; t--; ) x.push(v);
                                    v = !v;
                                }
                                for (k = 0, C = r.length; k < C; k++) x[k] && S.push(r[k]);
                                for (let e = 0; e < a; k++, e++) x[k] && S.push(f[e]);
                                return S;
                            })(
                                e.huffman,
                                e.refinement,
                                h,
                                e.numberOfNewSymbols,
                                e.numberOfExportedSymbols,
                                o,
                                e.template,
                                e.at,
                                e.refinementTemplate,
                                e.refinementAt,
                                u,
                                c
                            );
                        }
                        onImmediateTextRegion(e, t, r, a, n) {
                            const s = e.info;
                            let o, c;
                            const l = this.symbols;
                            let h = [];
                            for (let e = 0, r = t.length; e < r; e++) {
                                const r = l[t[e]];
                                r && (h = h.concat(r));
                            }
                            const u = (0, i.log2)(h.length);
                            if (e.huffman) {
                                c = new Reader(r, a, n);
                                o = (function getTextRegionHuffmanTables(e, t, r, a, i) {
                                    const n = [];
                                    for (let e = 0; e <= 34; e++) {
                                        const t = i.readBits(4);
                                        n.push(new HuffmanLine([e, t, 0, 0]));
                                    }
                                    const s = new HuffmanTable(n, !1);
                                    n.length = 0;
                                    for (let e = 0; e < a; ) {
                                        const t = s.decode(i);
                                        if (t >= 32) {
                                            let r, a, s;
                                            switch (t) {
                                                case 32:
                                                    if (0 === e)
                                                        throw new Jbig2Error('no previous value in symbol ID table');
                                                    a = i.readBits(2) + 3;
                                                    r = n[e - 1].prefixLength;
                                                    break;
                                                case 33:
                                                    a = i.readBits(3) + 3;
                                                    r = 0;
                                                    break;
                                                case 34:
                                                    a = i.readBits(7) + 11;
                                                    r = 0;
                                                    break;
                                                default:
                                                    throw new Jbig2Error('invalid code length in symbol ID table');
                                            }
                                            for (s = 0; s < a; s++) {
                                                n.push(new HuffmanLine([e, r, 0, 0]));
                                                e++;
                                            }
                                        } else {
                                            n.push(new HuffmanLine([e, t, 0, 0]));
                                            e++;
                                        }
                                    }
                                    i.byteAlign();
                                    const o = new HuffmanTable(n, !1);
                                    let c,
                                        l,
                                        h,
                                        u = 0;
                                    switch (e.huffmanFS) {
                                        case 0:
                                        case 1:
                                            c = getStandardTable(e.huffmanFS + 6);
                                            break;
                                        case 3:
                                            c = getCustomHuffmanTable(u, t, r);
                                            u++;
                                            break;
                                        default:
                                            throw new Jbig2Error('invalid Huffman FS selector');
                                    }
                                    switch (e.huffmanDS) {
                                        case 0:
                                        case 1:
                                        case 2:
                                            l = getStandardTable(e.huffmanDS + 8);
                                            break;
                                        case 3:
                                            l = getCustomHuffmanTable(u, t, r);
                                            u++;
                                            break;
                                        default:
                                            throw new Jbig2Error('invalid Huffman DS selector');
                                    }
                                    switch (e.huffmanDT) {
                                        case 0:
                                        case 1:
                                        case 2:
                                            h = getStandardTable(e.huffmanDT + 11);
                                            break;
                                        case 3:
                                            h = getCustomHuffmanTable(u, t, r);
                                            u++;
                                            break;
                                        default:
                                            throw new Jbig2Error('invalid Huffman DT selector');
                                    }
                                    if (e.refinement) throw new Jbig2Error('refinement with Huffman is not supported');
                                    return { symbolIDTable: o, tableFirstS: c, tableDeltaS: l, tableDeltaT: h };
                                })(e, t, this.customTables, h.length, c);
                            }
                            const d = new DecodingContext(r, a, n),
                                f = decodeTextRegion(
                                    e.huffman,
                                    e.refinement,
                                    s.width,
                                    s.height,
                                    e.defaultPixelValue,
                                    e.numberOfSymbolInstances,
                                    e.stripSize,
                                    h,
                                    u,
                                    e.transposed,
                                    e.dsOffset,
                                    e.referenceCorner,
                                    e.combinationOperator,
                                    o,
                                    e.refinementTemplate,
                                    e.refinementAt,
                                    d,
                                    e.logStripSize,
                                    c
                                );
                            this.drawBitmap(s, f);
                        }
                        onImmediateLosslessTextRegion() {
                            this.onImmediateTextRegion.apply(this, arguments);
                        }
                        onPatternDictionary(e, t, r, a, i) {
                            let n = this.patterns;
                            n || (this.patterns = n = {});
                            const s = new DecodingContext(r, a, i);
                            n[t] = (function decodePatternDictionary(e, t, r, a, i, n) {
                                const s = [];
                                if (!e) {
                                    s.push({ x: -t, y: 0 });
                                    0 === i && s.push({ x: -3, y: -1 }, { x: 2, y: -2 }, { x: -2, y: -2 });
                                }
                                const o = decodeBitmap(e, (a + 1) * t, r, i, !1, null, s, n),
                                    c = [];
                                for (let e = 0; e <= a; e++) {
                                    const a = [],
                                        i = t * e,
                                        n = i + t;
                                    for (let e = 0; e < r; e++) a.push(o[e].subarray(i, n));
                                    c.push(a);
                                }
                                return c;
                            })(e.mmr, e.patternWidth, e.patternHeight, e.maxPatternIndex, e.template, s);
                        }
                        onImmediateHalftoneRegion(e, t, r, a, n) {
                            const s = this.patterns[t[0]],
                                o = e.info,
                                c = new DecodingContext(r, a, n),
                                l = (function decodeHalftoneRegion(e, t, r, a, n, s, o, c, l, h, u, d, f, g, p) {
                                    if (o) throw new Jbig2Error('skip is not supported');
                                    if (0 !== c)
                                        throw new Jbig2Error(`operator "${c}" is not supported in halftone region`);
                                    const m = [];
                                    let b, y, w;
                                    for (b = 0; b < n; b++) {
                                        w = new Uint8Array(a);
                                        if (s) for (y = 0; y < a; y++) w[y] = s;
                                        m.push(w);
                                    }
                                    const S = t.length,
                                        x = t[0],
                                        k = x[0].length,
                                        C = x.length,
                                        v = (0, i.log2)(S),
                                        O = [];
                                    if (!e) {
                                        O.push({ x: r <= 1 ? 3 : 2, y: -1 });
                                        0 === r && O.push({ x: -3, y: -1 }, { x: 2, y: -2 }, { x: -2, y: -2 });
                                    }
                                    const F = [];
                                    let T, E, M, D, N, L, R, j, _, U, $;
                                    e && (T = new Reader(p.data, p.start, p.end));
                                    for (b = v - 1; b >= 0; b--) {
                                        E = e
                                            ? decodeMMRBitmap(T, l, h, !0)
                                            : decodeBitmap(!1, l, h, r, !1, null, O, p);
                                        F[b] = E;
                                    }
                                    for (M = 0; M < h; M++)
                                        for (D = 0; D < l; D++) {
                                            N = 0;
                                            L = 0;
                                            for (y = v - 1; y >= 0; y--) {
                                                N = F[y][M][D] ^ N;
                                                L |= N << y;
                                            }
                                            R = t[L];
                                            j = (u + M * g + D * f) >> 8;
                                            _ = (d + M * f - D * g) >> 8;
                                            if (j >= 0 && j + k <= a && _ >= 0 && _ + C <= n)
                                                for (b = 0; b < C; b++) {
                                                    $ = m[_ + b];
                                                    U = R[b];
                                                    for (y = 0; y < k; y++) $[j + y] |= U[y];
                                                }
                                            else {
                                                let e, t;
                                                for (b = 0; b < C; b++) {
                                                    t = _ + b;
                                                    if (!(t < 0 || t >= n)) {
                                                        $ = m[t];
                                                        U = R[b];
                                                        for (y = 0; y < k; y++) {
                                                            e = j + y;
                                                            e >= 0 && e < a && ($[e] |= U[y]);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    return m;
                                })(
                                    e.mmr,
                                    s,
                                    e.template,
                                    o.width,
                                    o.height,
                                    e.defaultPixelValue,
                                    e.enableSkip,
                                    e.combinationOperator,
                                    e.gridWidth,
                                    e.gridHeight,
                                    e.gridOffsetX,
                                    e.gridOffsetY,
                                    e.gridVectorX,
                                    e.gridVectorY,
                                    c
                                );
                            this.drawBitmap(o, l);
                        }
                        onImmediateLosslessHalftoneRegion() {
                            this.onImmediateHalftoneRegion.apply(this, arguments);
                        }
                        onTables(e, t, r, a) {
                            let n = this.customTables;
                            n || (this.customTables = n = {});
                            n[e] = (function decodeTablesSegment(e, t, r) {
                                const a = e[t],
                                    n = 4294967295 & (0, i.readUint32)(e, t + 1),
                                    s = 4294967295 & (0, i.readUint32)(e, t + 5),
                                    o = new Reader(e, t + 9, r),
                                    c = 1 + ((a >> 1) & 7),
                                    l = 1 + ((a >> 4) & 7),
                                    h = [];
                                let u,
                                    d,
                                    f = n;
                                do {
                                    u = o.readBits(c);
                                    d = o.readBits(l);
                                    h.push(new HuffmanLine([f, u, d, 0]));
                                    f += 1 << d;
                                } while (f < s);
                                u = o.readBits(c);
                                h.push(new HuffmanLine([n - 1, u, 32, 0, 'lower']));
                                u = o.readBits(c);
                                h.push(new HuffmanLine([s, u, 32, 0]));
                                if (1 & a) {
                                    u = o.readBits(c);
                                    h.push(new HuffmanLine([u, 0]));
                                }
                                return new HuffmanTable(h, !1);
                            })(t, r, a);
                        }
                    }
                    class HuffmanLine {
                        constructor(e) {
                            if (2 === e.length) {
                                this.isOOB = !0;
                                this.rangeLow = 0;
                                this.prefixLength = e[0];
                                this.rangeLength = 0;
                                this.prefixCode = e[1];
                                this.isLowerRange = !1;
                            } else {
                                this.isOOB = !1;
                                this.rangeLow = e[0];
                                this.prefixLength = e[1];
                                this.rangeLength = e[2];
                                this.prefixCode = e[3];
                                this.isLowerRange = 'lower' === e[4];
                            }
                        }
                    }
                    class HuffmanTreeNode {
                        constructor(e) {
                            this.children = [];
                            if (e) {
                                this.isLeaf = !0;
                                this.rangeLength = e.rangeLength;
                                this.rangeLow = e.rangeLow;
                                this.isLowerRange = e.isLowerRange;
                                this.isOOB = e.isOOB;
                            } else this.isLeaf = !1;
                        }
                        buildTree(e, t) {
                            const r = (e.prefixCode >> t) & 1;
                            if (t <= 0) this.children[r] = new HuffmanTreeNode(e);
                            else {
                                let a = this.children[r];
                                a || (this.children[r] = a = new HuffmanTreeNode(null));
                                a.buildTree(e, t - 1);
                            }
                        }
                        decodeNode(e) {
                            if (this.isLeaf) {
                                if (this.isOOB) return null;
                                const t = e.readBits(this.rangeLength);
                                return this.rangeLow + (this.isLowerRange ? -t : t);
                            }
                            const t = this.children[e.readBit()];
                            if (!t) throw new Jbig2Error('invalid Huffman data');
                            return t.decodeNode(e);
                        }
                    }
                    class HuffmanTable {
                        constructor(e, t) {
                            t || this.assignPrefixCodes(e);
                            this.rootNode = new HuffmanTreeNode(null);
                            for (let t = 0, r = e.length; t < r; t++) {
                                const r = e[t];
                                r.prefixLength > 0 && this.rootNode.buildTree(r, r.prefixLength - 1);
                            }
                        }
                        decode(e) {
                            return this.rootNode.decodeNode(e);
                        }
                        assignPrefixCodes(e) {
                            const t = e.length;
                            let r = 0;
                            for (let a = 0; a < t; a++) r = Math.max(r, e[a].prefixLength);
                            const a = new Uint32Array(r + 1);
                            for (let r = 0; r < t; r++) a[e[r].prefixLength]++;
                            let i,
                                n,
                                s,
                                o = 1,
                                c = 0;
                            a[0] = 0;
                            for (; o <= r; ) {
                                c = (c + a[o - 1]) << 1;
                                i = c;
                                n = 0;
                                for (; n < t; ) {
                                    s = e[n];
                                    if (s.prefixLength === o) {
                                        s.prefixCode = i;
                                        i++;
                                    }
                                    n++;
                                }
                                o++;
                            }
                        }
                    }
                    const f = {};
                    function getStandardTable(e) {
                        let t,
                            r = f[e];
                        if (r) return r;
                        switch (e) {
                            case 1:
                                t = [
                                    [0, 1, 4, 0],
                                    [16, 2, 8, 2],
                                    [272, 3, 16, 6],
                                    [65808, 3, 32, 7],
                                ];
                                break;
                            case 2:
                                t = [
                                    [0, 1, 0, 0],
                                    [1, 2, 0, 2],
                                    [2, 3, 0, 6],
                                    [3, 4, 3, 14],
                                    [11, 5, 6, 30],
                                    [75, 6, 32, 62],
                                    [6, 63],
                                ];
                                break;
                            case 3:
                                t = [
                                    [-256, 8, 8, 254],
                                    [0, 1, 0, 0],
                                    [1, 2, 0, 2],
                                    [2, 3, 0, 6],
                                    [3, 4, 3, 14],
                                    [11, 5, 6, 30],
                                    [-257, 8, 32, 255, 'lower'],
                                    [75, 7, 32, 126],
                                    [6, 62],
                                ];
                                break;
                            case 4:
                                t = [
                                    [1, 1, 0, 0],
                                    [2, 2, 0, 2],
                                    [3, 3, 0, 6],
                                    [4, 4, 3, 14],
                                    [12, 5, 6, 30],
                                    [76, 5, 32, 31],
                                ];
                                break;
                            case 5:
                                t = [
                                    [-255, 7, 8, 126],
                                    [1, 1, 0, 0],
                                    [2, 2, 0, 2],
                                    [3, 3, 0, 6],
                                    [4, 4, 3, 14],
                                    [12, 5, 6, 30],
                                    [-256, 7, 32, 127, 'lower'],
                                    [76, 6, 32, 62],
                                ];
                                break;
                            case 6:
                                t = [
                                    [-2048, 5, 10, 28],
                                    [-1024, 4, 9, 8],
                                    [-512, 4, 8, 9],
                                    [-256, 4, 7, 10],
                                    [-128, 5, 6, 29],
                                    [-64, 5, 5, 30],
                                    [-32, 4, 5, 11],
                                    [0, 2, 7, 0],
                                    [128, 3, 7, 2],
                                    [256, 3, 8, 3],
                                    [512, 4, 9, 12],
                                    [1024, 4, 10, 13],
                                    [-2049, 6, 32, 62, 'lower'],
                                    [2048, 6, 32, 63],
                                ];
                                break;
                            case 7:
                                t = [
                                    [-1024, 4, 9, 8],
                                    [-512, 3, 8, 0],
                                    [-256, 4, 7, 9],
                                    [-128, 5, 6, 26],
                                    [-64, 5, 5, 27],
                                    [-32, 4, 5, 10],
                                    [0, 4, 5, 11],
                                    [32, 5, 5, 28],
                                    [64, 5, 6, 29],
                                    [128, 4, 7, 12],
                                    [256, 3, 8, 1],
                                    [512, 3, 9, 2],
                                    [1024, 3, 10, 3],
                                    [-1025, 5, 32, 30, 'lower'],
                                    [2048, 5, 32, 31],
                                ];
                                break;
                            case 8:
                                t = [
                                    [-15, 8, 3, 252],
                                    [-7, 9, 1, 508],
                                    [-5, 8, 1, 253],
                                    [-3, 9, 0, 509],
                                    [-2, 7, 0, 124],
                                    [-1, 4, 0, 10],
                                    [0, 2, 1, 0],
                                    [2, 5, 0, 26],
                                    [3, 6, 0, 58],
                                    [4, 3, 4, 4],
                                    [20, 6, 1, 59],
                                    [22, 4, 4, 11],
                                    [38, 4, 5, 12],
                                    [70, 5, 6, 27],
                                    [134, 5, 7, 28],
                                    [262, 6, 7, 60],
                                    [390, 7, 8, 125],
                                    [646, 6, 10, 61],
                                    [-16, 9, 32, 510, 'lower'],
                                    [1670, 9, 32, 511],
                                    [2, 1],
                                ];
                                break;
                            case 9:
                                t = [
                                    [-31, 8, 4, 252],
                                    [-15, 9, 2, 508],
                                    [-11, 8, 2, 253],
                                    [-7, 9, 1, 509],
                                    [-5, 7, 1, 124],
                                    [-3, 4, 1, 10],
                                    [-1, 3, 1, 2],
                                    [1, 3, 1, 3],
                                    [3, 5, 1, 26],
                                    [5, 6, 1, 58],
                                    [7, 3, 5, 4],
                                    [39, 6, 2, 59],
                                    [43, 4, 5, 11],
                                    [75, 4, 6, 12],
                                    [139, 5, 7, 27],
                                    [267, 5, 8, 28],
                                    [523, 6, 8, 60],
                                    [779, 7, 9, 125],
                                    [1291, 6, 11, 61],
                                    [-32, 9, 32, 510, 'lower'],
                                    [3339, 9, 32, 511],
                                    [2, 0],
                                ];
                                break;
                            case 10:
                                t = [
                                    [-21, 7, 4, 122],
                                    [-5, 8, 0, 252],
                                    [-4, 7, 0, 123],
                                    [-3, 5, 0, 24],
                                    [-2, 2, 2, 0],
                                    [2, 5, 0, 25],
                                    [3, 6, 0, 54],
                                    [4, 7, 0, 124],
                                    [5, 8, 0, 253],
                                    [6, 2, 6, 1],
                                    [70, 5, 5, 26],
                                    [102, 6, 5, 55],
                                    [134, 6, 6, 56],
                                    [198, 6, 7, 57],
                                    [326, 6, 8, 58],
                                    [582, 6, 9, 59],
                                    [1094, 6, 10, 60],
                                    [2118, 7, 11, 125],
                                    [-22, 8, 32, 254, 'lower'],
                                    [4166, 8, 32, 255],
                                    [2, 2],
                                ];
                                break;
                            case 11:
                                t = [
                                    [1, 1, 0, 0],
                                    [2, 2, 1, 2],
                                    [4, 4, 0, 12],
                                    [5, 4, 1, 13],
                                    [7, 5, 1, 28],
                                    [9, 5, 2, 29],
                                    [13, 6, 2, 60],
                                    [17, 7, 2, 122],
                                    [21, 7, 3, 123],
                                    [29, 7, 4, 124],
                                    [45, 7, 5, 125],
                                    [77, 7, 6, 126],
                                    [141, 7, 32, 127],
                                ];
                                break;
                            case 12:
                                t = [
                                    [1, 1, 0, 0],
                                    [2, 2, 0, 2],
                                    [3, 3, 1, 6],
                                    [5, 5, 0, 28],
                                    [6, 5, 1, 29],
                                    [8, 6, 1, 60],
                                    [10, 7, 0, 122],
                                    [11, 7, 1, 123],
                                    [13, 7, 2, 124],
                                    [17, 7, 3, 125],
                                    [25, 7, 4, 126],
                                    [41, 8, 5, 254],
                                    [73, 8, 32, 255],
                                ];
                                break;
                            case 13:
                                t = [
                                    [1, 1, 0, 0],
                                    [2, 3, 0, 4],
                                    [3, 4, 0, 12],
                                    [4, 5, 0, 28],
                                    [5, 4, 1, 13],
                                    [7, 3, 3, 5],
                                    [15, 6, 1, 58],
                                    [17, 6, 2, 59],
                                    [21, 6, 3, 60],
                                    [29, 6, 4, 61],
                                    [45, 6, 5, 62],
                                    [77, 7, 6, 126],
                                    [141, 7, 32, 127],
                                ];
                                break;
                            case 14:
                                t = [
                                    [-2, 3, 0, 4],
                                    [-1, 3, 0, 5],
                                    [0, 1, 0, 0],
                                    [1, 3, 0, 6],
                                    [2, 3, 0, 7],
                                ];
                                break;
                            case 15:
                                t = [
                                    [-24, 7, 4, 124],
                                    [-8, 6, 2, 60],
                                    [-4, 5, 1, 28],
                                    [-2, 4, 0, 12],
                                    [-1, 3, 0, 4],
                                    [0, 1, 0, 0],
                                    [1, 3, 0, 5],
                                    [2, 4, 0, 13],
                                    [3, 5, 1, 29],
                                    [5, 6, 2, 61],
                                    [9, 7, 4, 125],
                                    [-25, 7, 32, 126, 'lower'],
                                    [25, 7, 32, 127],
                                ];
                                break;
                            default:
                                throw new Jbig2Error(`standard table B.${e} does not exist`);
                        }
                        for (let e = 0, r = t.length; e < r; e++) t[e] = new HuffmanLine(t[e]);
                        r = new HuffmanTable(t, !0);
                        f[e] = r;
                        return r;
                    }
                    class Reader {
                        constructor(e, t, r) {
                            this.data = e;
                            this.start = t;
                            this.end = r;
                            this.position = t;
                            this.shift = -1;
                            this.currentByte = 0;
                        }
                        readBit() {
                            if (this.shift < 0) {
                                if (this.position >= this.end) throw new Jbig2Error('end of data while reading bit');
                                this.currentByte = this.data[this.position++];
                                this.shift = 7;
                            }
                            const e = (this.currentByte >> this.shift) & 1;
                            this.shift--;
                            return e;
                        }
                        readBits(e) {
                            let t,
                                r = 0;
                            for (t = e - 1; t >= 0; t--) r |= this.readBit() << t;
                            return r;
                        }
                        byteAlign() {
                            this.shift = -1;
                        }
                        next() {
                            return this.position >= this.end ? -1 : this.data[this.position++];
                        }
                    }
                    function getCustomHuffmanTable(e, t, r) {
                        let a = 0;
                        for (let i = 0, n = t.length; i < n; i++) {
                            const n = r[t[i]];
                            if (n) {
                                if (e === a) return n;
                                a++;
                            }
                        }
                        throw new Jbig2Error("can't find custom Huffman table");
                    }
                    function readUncompressedBitmap(e, t, r) {
                        const a = [];
                        for (let i = 0; i < r; i++) {
                            const r = new Uint8Array(t);
                            a.push(r);
                            for (let a = 0; a < t; a++) r[a] = e.readBit();
                            e.byteAlign();
                        }
                        return a;
                    }
                    function decodeMMRBitmap(e, t, r, a) {
                        const i = { K: -1, Columns: t, Rows: r, BlackIs1: !0, EndOfBlock: a },
                            n = new s.CCITTFaxDecoder(e, i),
                            o = [];
                        let c,
                            l = !1;
                        for (let e = 0; e < r; e++) {
                            const e = new Uint8Array(t);
                            o.push(e);
                            let r = -1;
                            for (let a = 0; a < t; a++) {
                                if (r < 0) {
                                    c = n.readNextChar();
                                    if (-1 === c) {
                                        c = 0;
                                        l = !0;
                                    }
                                    r = 7;
                                }
                                e[a] = (c >> r) & 1;
                                r--;
                            }
                        }
                        if (a && !l) {
                            const e = 5;
                            for (let t = 0; t < e && -1 !== n.readNextChar(); t++);
                        }
                        return o;
                    }
                    t.Jbig2Image = class Jbig2Image {
                        parseChunks(e) {
                            return (function parseJbig2Chunks(e) {
                                const t = new SimpleSegmentVisitor();
                                for (let r = 0, a = e.length; r < a; r++) {
                                    const a = e[r];
                                    processSegments(readSegments({}, a.data, a.start, a.end), t);
                                }
                                return t.buffer;
                            })(e);
                        }
                        parse(e) {
                            const {
                                imgData: t,
                                width: r,
                                height: a,
                            } = (function parseJbig2(e) {
                                const t = e.length;
                                let r = 0;
                                if (
                                    151 !== e[r] ||
                                    74 !== e[r + 1] ||
                                    66 !== e[r + 2] ||
                                    50 !== e[r + 3] ||
                                    13 !== e[r + 4] ||
                                    10 !== e[r + 5] ||
                                    26 !== e[r + 6] ||
                                    10 !== e[r + 7]
                                )
                                    throw new Jbig2Error('parseJbig2 - invalid header.');
                                const a = Object.create(null);
                                r += 8;
                                const n = e[r++];
                                a.randomAccess = !(1 & n);
                                if (!(2 & n)) {
                                    a.numberOfPages = (0, i.readUint32)(e, r);
                                    r += 4;
                                }
                                const s = readSegments(a, e, r, t),
                                    o = new SimpleSegmentVisitor();
                                processSegments(s, o);
                                const { width: c, height: l } = o.currentPageInfo,
                                    h = o.buffer,
                                    u = new Uint8ClampedArray(c * l);
                                let d = 0,
                                    f = 0;
                                for (let e = 0; e < l; e++) {
                                    let e,
                                        t = 0;
                                    for (let r = 0; r < c; r++) {
                                        if (!t) {
                                            t = 128;
                                            e = h[f++];
                                        }
                                        u[d++] = e & t ? 0 : 255;
                                        t >>= 1;
                                    }
                                }
                                return { imgData: u, width: c, height: l };
                            })(e);
                            this.width = r;
                            this.height = a;
                            return t;
                        }
                    };
                },
                (e, t) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.ArithmeticDecoder = void 0;
                    const r = [
                        { qe: 22017, nmps: 1, nlps: 1, switchFlag: 1 },
                        { qe: 13313, nmps: 2, nlps: 6, switchFlag: 0 },
                        { qe: 6145, nmps: 3, nlps: 9, switchFlag: 0 },
                        { qe: 2753, nmps: 4, nlps: 12, switchFlag: 0 },
                        { qe: 1313, nmps: 5, nlps: 29, switchFlag: 0 },
                        { qe: 545, nmps: 38, nlps: 33, switchFlag: 0 },
                        { qe: 22017, nmps: 7, nlps: 6, switchFlag: 1 },
                        { qe: 21505, nmps: 8, nlps: 14, switchFlag: 0 },
                        { qe: 18433, nmps: 9, nlps: 14, switchFlag: 0 },
                        { qe: 14337, nmps: 10, nlps: 14, switchFlag: 0 },
                        { qe: 12289, nmps: 11, nlps: 17, switchFlag: 0 },
                        { qe: 9217, nmps: 12, nlps: 18, switchFlag: 0 },
                        { qe: 7169, nmps: 13, nlps: 20, switchFlag: 0 },
                        { qe: 5633, nmps: 29, nlps: 21, switchFlag: 0 },
                        { qe: 22017, nmps: 15, nlps: 14, switchFlag: 1 },
                        { qe: 21505, nmps: 16, nlps: 14, switchFlag: 0 },
                        { qe: 20737, nmps: 17, nlps: 15, switchFlag: 0 },
                        { qe: 18433, nmps: 18, nlps: 16, switchFlag: 0 },
                        { qe: 14337, nmps: 19, nlps: 17, switchFlag: 0 },
                        { qe: 13313, nmps: 20, nlps: 18, switchFlag: 0 },
                        { qe: 12289, nmps: 21, nlps: 19, switchFlag: 0 },
                        { qe: 10241, nmps: 22, nlps: 19, switchFlag: 0 },
                        { qe: 9217, nmps: 23, nlps: 20, switchFlag: 0 },
                        { qe: 8705, nmps: 24, nlps: 21, switchFlag: 0 },
                        { qe: 7169, nmps: 25, nlps: 22, switchFlag: 0 },
                        { qe: 6145, nmps: 26, nlps: 23, switchFlag: 0 },
                        { qe: 5633, nmps: 27, nlps: 24, switchFlag: 0 },
                        { qe: 5121, nmps: 28, nlps: 25, switchFlag: 0 },
                        { qe: 4609, nmps: 29, nlps: 26, switchFlag: 0 },
                        { qe: 4353, nmps: 30, nlps: 27, switchFlag: 0 },
                        { qe: 2753, nmps: 31, nlps: 28, switchFlag: 0 },
                        { qe: 2497, nmps: 32, nlps: 29, switchFlag: 0 },
                        { qe: 2209, nmps: 33, nlps: 30, switchFlag: 0 },
                        { qe: 1313, nmps: 34, nlps: 31, switchFlag: 0 },
                        { qe: 1089, nmps: 35, nlps: 32, switchFlag: 0 },
                        { qe: 673, nmps: 36, nlps: 33, switchFlag: 0 },
                        { qe: 545, nmps: 37, nlps: 34, switchFlag: 0 },
                        { qe: 321, nmps: 38, nlps: 35, switchFlag: 0 },
                        { qe: 273, nmps: 39, nlps: 36, switchFlag: 0 },
                        { qe: 133, nmps: 40, nlps: 37, switchFlag: 0 },
                        { qe: 73, nmps: 41, nlps: 38, switchFlag: 0 },
                        { qe: 37, nmps: 42, nlps: 39, switchFlag: 0 },
                        { qe: 21, nmps: 43, nlps: 40, switchFlag: 0 },
                        { qe: 9, nmps: 44, nlps: 41, switchFlag: 0 },
                        { qe: 5, nmps: 45, nlps: 42, switchFlag: 0 },
                        { qe: 1, nmps: 45, nlps: 43, switchFlag: 0 },
                        { qe: 22017, nmps: 46, nlps: 46, switchFlag: 0 },
                    ];
                    t.ArithmeticDecoder = class ArithmeticDecoder {
                        constructor(e, t, r) {
                            this.data = e;
                            this.bp = t;
                            this.dataEnd = r;
                            this.chigh = e[t];
                            this.clow = 0;
                            this.byteIn();
                            this.chigh = ((this.chigh << 7) & 65535) | ((this.clow >> 9) & 127);
                            this.clow = (this.clow << 7) & 65535;
                            this.ct -= 7;
                            this.a = 32768;
                        }
                        byteIn() {
                            const e = this.data;
                            let t = this.bp;
                            if (255 === e[t])
                                if (e[t + 1] > 143) {
                                    this.clow += 65280;
                                    this.ct = 8;
                                } else {
                                    t++;
                                    this.clow += e[t] << 9;
                                    this.ct = 7;
                                    this.bp = t;
                                }
                            else {
                                t++;
                                this.clow += t < this.dataEnd ? e[t] << 8 : 65280;
                                this.ct = 8;
                                this.bp = t;
                            }
                            if (this.clow > 65535) {
                                this.chigh += this.clow >> 16;
                                this.clow &= 65535;
                            }
                        }
                        readBit(e, t) {
                            let a = e[t] >> 1,
                                i = 1 & e[t];
                            const n = r[a],
                                s = n.qe;
                            let o,
                                c = this.a - s;
                            if (this.chigh < s)
                                if (c < s) {
                                    c = s;
                                    o = i;
                                    a = n.nmps;
                                } else {
                                    c = s;
                                    o = 1 ^ i;
                                    1 === n.switchFlag && (i = o);
                                    a = n.nlps;
                                }
                            else {
                                this.chigh -= s;
                                if (0 != (32768 & c)) {
                                    this.a = c;
                                    return i;
                                }
                                if (c < s) {
                                    o = 1 ^ i;
                                    1 === n.switchFlag && (i = o);
                                    a = n.nlps;
                                } else {
                                    o = i;
                                    a = n.nmps;
                                }
                            }
                            do {
                                0 === this.ct && this.byteIn();
                                c <<= 1;
                                this.chigh = ((this.chigh << 1) & 65535) | ((this.clow >> 15) & 1);
                                this.clow = (this.clow << 1) & 65535;
                                this.ct--;
                            } while (0 == (32768 & c));
                            this.a = c;
                            e[t] = (a << 1) | i;
                            return o;
                        }
                    };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.JpegStream = void 0;
                    var a = r(19),
                        i = r(5),
                        n = r(28),
                        s = r(2);
                    class JpegStream extends a.DecodeStream {
                        constructor(e, t, r) {
                            let a;
                            for (; -1 !== (a = e.getByte()); )
                                if (255 === a) {
                                    e.skip(-1);
                                    break;
                                }
                            super(t);
                            this.stream = e;
                            this.dict = e.dict;
                            this.maybeLength = t;
                            this.params = r;
                        }
                        get bytes() {
                            return (0, s.shadow)(this, 'bytes', this.stream.getBytes(this.maybeLength));
                        }
                        ensureBuffer(e) {}
                        readBlock() {
                            if (this.eof) return;
                            const e = { decodeTransform: void 0, colorTransform: void 0 },
                                t = this.dict.getArray('Decode', 'D');
                            if (this.forceRGB && Array.isArray(t)) {
                                const r = this.dict.get('BitsPerComponent') || 8,
                                    a = t.length,
                                    i = new Int32Array(a);
                                let n = !1;
                                const s = (1 << r) - 1;
                                for (let e = 0; e < a; e += 2) {
                                    i[e] = (256 * (t[e + 1] - t[e])) | 0;
                                    i[e + 1] = (t[e] * s) | 0;
                                    (256 === i[e] && 0 === i[e + 1]) || (n = !0);
                                }
                                n && (e.decodeTransform = i);
                            }
                            if ((0, i.isDict)(this.params)) {
                                const t = this.params.get('ColorTransform');
                                Number.isInteger(t) && (e.colorTransform = t);
                            }
                            const r = new n.JpegImage(e);
                            r.parse(this.bytes);
                            const a = r.getData({
                                width: this.drawWidth,
                                height: this.drawHeight,
                                forceRGB: this.forceRGB,
                                isSourcePDF: !0,
                            });
                            this.buffer = a;
                            this.bufferLength = a.length;
                            this.eof = !0;
                        }
                    }
                    t.JpegStream = JpegStream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.JpegImage = void 0;
                    var a = r(2),
                        i = r(9);
                    class JpegError extends a.BaseException {
                        constructor(e) {
                            super(`JPEG error: ${e}`);
                        }
                    }
                    class DNLMarkerError extends a.BaseException {
                        constructor(e, t) {
                            super(e);
                            this.scanLines = t;
                        }
                    }
                    class EOIMarkerError extends a.BaseException {}
                    const n = new Uint8Array([
                            0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27,
                            20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51,
                            58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63,
                        ]),
                        s = 4017,
                        o = 799,
                        c = 3406,
                        l = 2276,
                        h = 1567,
                        u = 3784,
                        d = 5793,
                        f = 2896;
                    function buildHuffmanTable(e, t) {
                        let r,
                            a,
                            i = 0,
                            n = 16;
                        for (; n > 0 && !e[n - 1]; ) n--;
                        const s = [{ children: [], index: 0 }];
                        let o,
                            c = s[0];
                        for (r = 0; r < n; r++) {
                            for (a = 0; a < e[r]; a++) {
                                c = s.pop();
                                c.children[c.index] = t[i];
                                for (; c.index > 0; ) c = s.pop();
                                c.index++;
                                s.push(c);
                                for (; s.length <= r; ) {
                                    s.push((o = { children: [], index: 0 }));
                                    c.children[c.index] = o.children;
                                    c = o;
                                }
                                i++;
                            }
                            if (r + 1 < n) {
                                s.push((o = { children: [], index: 0 }));
                                c.children[c.index] = o.children;
                                c = o;
                            }
                        }
                        return s[0].children;
                    }
                    function getBlockBufferOffset(e, t, r) {
                        return 64 * ((e.blocksPerLine + 1) * t + r);
                    }
                    function decodeScan(e, t, r, s, o, c, l, h, u, d = !1) {
                        const f = r.mcusPerLine,
                            g = r.progressive,
                            p = t;
                        let m = 0,
                            b = 0;
                        function readBit() {
                            if (b > 0) {
                                b--;
                                return (m >> b) & 1;
                            }
                            m = e[t++];
                            if (255 === m) {
                                const a = e[t++];
                                if (a) {
                                    if (220 === a && d) {
                                        t += 2;
                                        const a = (0, i.readUint16)(e, t);
                                        t += 2;
                                        if (a > 0 && a !== r.scanLines)
                                            throw new DNLMarkerError(
                                                'Found DNL marker (0xFFDC) while parsing scan data',
                                                a
                                            );
                                    } else if (217 === a) {
                                        if (d) {
                                            const e = x * (8 === r.precision ? 8 : 0);
                                            if (e > 0 && Math.round(r.scanLines / e) >= 10)
                                                throw new DNLMarkerError(
                                                    'Found EOI marker (0xFFD9) while parsing scan data, possibly caused by incorrect `scanLines` parameter',
                                                    e
                                                );
                                        }
                                        throw new EOIMarkerError('Found EOI marker (0xFFD9) while parsing scan data');
                                    }
                                    throw new JpegError(`unexpected marker ${((m << 8) | a).toString(16)}`);
                                }
                            }
                            b = 7;
                            return m >>> 7;
                        }
                        function decodeHuffman(e) {
                            let t = e;
                            for (;;) {
                                t = t[readBit()];
                                switch (typeof t) {
                                    case 'number':
                                        return t;
                                    case 'object':
                                        continue;
                                }
                                throw new JpegError('invalid huffman sequence');
                            }
                        }
                        function receive(e) {
                            let t = 0;
                            for (; e > 0; ) {
                                t = (t << 1) | readBit();
                                e--;
                            }
                            return t;
                        }
                        function receiveAndExtend(e) {
                            if (1 === e) return 1 === readBit() ? 1 : -1;
                            const t = receive(e);
                            return t >= 1 << (e - 1) ? t : t + (-1 << e) + 1;
                        }
                        let y = 0;
                        let w,
                            S = 0;
                        let x = 0;
                        function decodeMcu(e, t, r, a, i) {
                            const n = r % f;
                            x = ((r / f) | 0) * e.v + a;
                            const s = n * e.h + i;
                            t(e, getBlockBufferOffset(e, x, s));
                        }
                        function decodeBlock(e, t, r) {
                            x = (r / e.blocksPerLine) | 0;
                            const a = r % e.blocksPerLine;
                            t(e, getBlockBufferOffset(e, x, a));
                        }
                        const k = s.length;
                        let C, v, O, F, T, E;
                        E = g
                            ? 0 === c
                                ? 0 === h
                                    ? function decodeDCFirst(e, t) {
                                          const r = decodeHuffman(e.huffmanTableDC),
                                              a = 0 === r ? 0 : receiveAndExtend(r) << u;
                                          e.blockData[t] = e.pred += a;
                                      }
                                    : function decodeDCSuccessive(e, t) {
                                          e.blockData[t] |= readBit() << u;
                                      }
                                : 0 === h
                                ? function decodeACFirst(e, t) {
                                      if (y > 0) {
                                          y--;
                                          return;
                                      }
                                      let r = c;
                                      const a = l;
                                      for (; r <= a; ) {
                                          const a = decodeHuffman(e.huffmanTableAC),
                                              i = 15 & a,
                                              s = a >> 4;
                                          if (0 === i) {
                                              if (s < 15) {
                                                  y = receive(s) + (1 << s) - 1;
                                                  break;
                                              }
                                              r += 16;
                                              continue;
                                          }
                                          r += s;
                                          const o = n[r];
                                          e.blockData[t + o] = receiveAndExtend(i) * (1 << u);
                                          r++;
                                      }
                                  }
                                : function decodeACSuccessive(e, t) {
                                      let r = c;
                                      const a = l;
                                      let i,
                                          s,
                                          o = 0;
                                      for (; r <= a; ) {
                                          const a = t + n[r],
                                              c = e.blockData[a] < 0 ? -1 : 1;
                                          switch (S) {
                                              case 0:
                                                  s = decodeHuffman(e.huffmanTableAC);
                                                  i = 15 & s;
                                                  o = s >> 4;
                                                  if (0 === i)
                                                      if (o < 15) {
                                                          y = receive(o) + (1 << o);
                                                          S = 4;
                                                      } else {
                                                          o = 16;
                                                          S = 1;
                                                      }
                                                  else {
                                                      if (1 !== i) throw new JpegError('invalid ACn encoding');
                                                      w = receiveAndExtend(i);
                                                      S = o ? 2 : 3;
                                                  }
                                                  continue;
                                              case 1:
                                              case 2:
                                                  if (e.blockData[a]) e.blockData[a] += c * (readBit() << u);
                                                  else {
                                                      o--;
                                                      0 === o && (S = 2 === S ? 3 : 0);
                                                  }
                                                  break;
                                              case 3:
                                                  if (e.blockData[a]) e.blockData[a] += c * (readBit() << u);
                                                  else {
                                                      e.blockData[a] = w << u;
                                                      S = 0;
                                                  }
                                                  break;
                                              case 4:
                                                  e.blockData[a] && (e.blockData[a] += c * (readBit() << u));
                                          }
                                          r++;
                                      }
                                      if (4 === S) {
                                          y--;
                                          0 === y && (S = 0);
                                      }
                                  }
                            : function decodeBaseline(e, t) {
                                  const r = decodeHuffman(e.huffmanTableDC),
                                      a = 0 === r ? 0 : receiveAndExtend(r);
                                  e.blockData[t] = e.pred += a;
                                  let i = 1;
                                  for (; i < 64; ) {
                                      const r = decodeHuffman(e.huffmanTableAC),
                                          a = 15 & r,
                                          s = r >> 4;
                                      if (0 === a) {
                                          if (s < 15) break;
                                          i += 16;
                                          continue;
                                      }
                                      i += s;
                                      const o = n[i];
                                      e.blockData[t + o] = receiveAndExtend(a);
                                      i++;
                                  }
                              };
                        let M,
                            D,
                            N,
                            L,
                            R = 0;
                        D = 1 === k ? s[0].blocksPerLine * s[0].blocksPerColumn : f * r.mcusPerColumn;
                        for (; R <= D; ) {
                            const r = o ? Math.min(D - R, o) : D;
                            if (r > 0) {
                                for (v = 0; v < k; v++) s[v].pred = 0;
                                y = 0;
                                if (1 === k) {
                                    C = s[0];
                                    for (T = 0; T < r; T++) {
                                        decodeBlock(C, E, R);
                                        R++;
                                    }
                                } else
                                    for (T = 0; T < r; T++) {
                                        for (v = 0; v < k; v++) {
                                            C = s[v];
                                            N = C.h;
                                            L = C.v;
                                            for (O = 0; O < L; O++) for (F = 0; F < N; F++) decodeMcu(C, E, R, O, F);
                                        }
                                        R++;
                                    }
                            }
                            b = 0;
                            M = findNextFileMarker(e, t);
                            if (!M) break;
                            if (M.invalid) {
                                const e = r > 0 ? 'unexpected' : 'excessive';
                                (0, a.warn)(`decodeScan - ${e} MCU data, current marker is: ${M.invalid}`);
                                t = M.offset;
                            }
                            if (!(M.marker >= 65488 && M.marker <= 65495)) break;
                            t += 2;
                        }
                        return t - p;
                    }
                    function quantizeAndInverse(e, t, r) {
                        const a = e.quantizationTable,
                            i = e.blockData;
                        let n, g, p, m, b, y, w, S, x, k, C, v, O, F, T, E, M;
                        if (!a) throw new JpegError('missing required Quantization Table.');
                        for (let e = 0; e < 64; e += 8) {
                            x = i[t + e];
                            k = i[t + e + 1];
                            C = i[t + e + 2];
                            v = i[t + e + 3];
                            O = i[t + e + 4];
                            F = i[t + e + 5];
                            T = i[t + e + 6];
                            E = i[t + e + 7];
                            x *= a[e];
                            if (0 != (k | C | v | O | F | T | E)) {
                                k *= a[e + 1];
                                C *= a[e + 2];
                                v *= a[e + 3];
                                O *= a[e + 4];
                                F *= a[e + 5];
                                T *= a[e + 6];
                                E *= a[e + 7];
                                n = (d * x + 128) >> 8;
                                g = (d * O + 128) >> 8;
                                p = C;
                                m = T;
                                b = (f * (k - E) + 128) >> 8;
                                S = (f * (k + E) + 128) >> 8;
                                y = v << 4;
                                w = F << 4;
                                n = (n + g + 1) >> 1;
                                g = n - g;
                                M = (p * u + m * h + 128) >> 8;
                                p = (p * h - m * u + 128) >> 8;
                                m = M;
                                b = (b + w + 1) >> 1;
                                w = b - w;
                                S = (S + y + 1) >> 1;
                                y = S - y;
                                n = (n + m + 1) >> 1;
                                m = n - m;
                                g = (g + p + 1) >> 1;
                                p = g - p;
                                M = (b * l + S * c + 2048) >> 12;
                                b = (b * c - S * l + 2048) >> 12;
                                S = M;
                                M = (y * o + w * s + 2048) >> 12;
                                y = (y * s - w * o + 2048) >> 12;
                                w = M;
                                r[e] = n + S;
                                r[e + 7] = n - S;
                                r[e + 1] = g + w;
                                r[e + 6] = g - w;
                                r[e + 2] = p + y;
                                r[e + 5] = p - y;
                                r[e + 3] = m + b;
                                r[e + 4] = m - b;
                            } else {
                                M = (d * x + 512) >> 10;
                                r[e] = M;
                                r[e + 1] = M;
                                r[e + 2] = M;
                                r[e + 3] = M;
                                r[e + 4] = M;
                                r[e + 5] = M;
                                r[e + 6] = M;
                                r[e + 7] = M;
                            }
                        }
                        for (let e = 0; e < 8; ++e) {
                            x = r[e];
                            k = r[e + 8];
                            C = r[e + 16];
                            v = r[e + 24];
                            O = r[e + 32];
                            F = r[e + 40];
                            T = r[e + 48];
                            E = r[e + 56];
                            if (0 != (k | C | v | O | F | T | E)) {
                                n = (d * x + 2048) >> 12;
                                g = (d * O + 2048) >> 12;
                                p = C;
                                m = T;
                                b = (f * (k - E) + 2048) >> 12;
                                S = (f * (k + E) + 2048) >> 12;
                                y = v;
                                w = F;
                                n = 4112 + ((n + g + 1) >> 1);
                                g = n - g;
                                M = (p * u + m * h + 2048) >> 12;
                                p = (p * h - m * u + 2048) >> 12;
                                m = M;
                                b = (b + w + 1) >> 1;
                                w = b - w;
                                S = (S + y + 1) >> 1;
                                y = S - y;
                                n = (n + m + 1) >> 1;
                                m = n - m;
                                g = (g + p + 1) >> 1;
                                p = g - p;
                                M = (b * l + S * c + 2048) >> 12;
                                b = (b * c - S * l + 2048) >> 12;
                                S = M;
                                M = (y * o + w * s + 2048) >> 12;
                                y = (y * s - w * o + 2048) >> 12;
                                w = M;
                                x = n + S;
                                E = n - S;
                                k = g + w;
                                T = g - w;
                                C = p + y;
                                F = p - y;
                                v = m + b;
                                O = m - b;
                                x < 16 ? (x = 0) : x >= 4080 ? (x = 255) : (x >>= 4);
                                k < 16 ? (k = 0) : k >= 4080 ? (k = 255) : (k >>= 4);
                                C < 16 ? (C = 0) : C >= 4080 ? (C = 255) : (C >>= 4);
                                v < 16 ? (v = 0) : v >= 4080 ? (v = 255) : (v >>= 4);
                                O < 16 ? (O = 0) : O >= 4080 ? (O = 255) : (O >>= 4);
                                F < 16 ? (F = 0) : F >= 4080 ? (F = 255) : (F >>= 4);
                                T < 16 ? (T = 0) : T >= 4080 ? (T = 255) : (T >>= 4);
                                E < 16 ? (E = 0) : E >= 4080 ? (E = 255) : (E >>= 4);
                                i[t + e] = x;
                                i[t + e + 8] = k;
                                i[t + e + 16] = C;
                                i[t + e + 24] = v;
                                i[t + e + 32] = O;
                                i[t + e + 40] = F;
                                i[t + e + 48] = T;
                                i[t + e + 56] = E;
                            } else {
                                M = (d * x + 8192) >> 14;
                                M = M < -2040 ? 0 : M >= 2024 ? 255 : (M + 2056) >> 4;
                                i[t + e] = M;
                                i[t + e + 8] = M;
                                i[t + e + 16] = M;
                                i[t + e + 24] = M;
                                i[t + e + 32] = M;
                                i[t + e + 40] = M;
                                i[t + e + 48] = M;
                                i[t + e + 56] = M;
                            }
                        }
                    }
                    function buildComponentData(e, t) {
                        const r = t.blocksPerLine,
                            a = t.blocksPerColumn,
                            i = new Int16Array(64);
                        for (let e = 0; e < a; e++)
                            for (let a = 0; a < r; a++) {
                                quantizeAndInverse(t, getBlockBufferOffset(t, e, a), i);
                            }
                        return t.blockData;
                    }
                    function findNextFileMarker(e, t, r = t) {
                        const a = e.length - 1;
                        let n = r < t ? r : t;
                        if (t >= a) return null;
                        const s = (0, i.readUint16)(e, t);
                        if (s >= 65472 && s <= 65534) return { invalid: null, marker: s, offset: t };
                        let o = (0, i.readUint16)(e, n);
                        for (; !(o >= 65472 && o <= 65534); ) {
                            if (++n >= a) return null;
                            o = (0, i.readUint16)(e, n);
                        }
                        return { invalid: s.toString(16), marker: o, offset: n };
                    }
                    t.JpegImage = class JpegImage {
                        constructor({ decodeTransform: e = null, colorTransform: t = -1 } = {}) {
                            this._decodeTransform = e;
                            this._colorTransform = t;
                        }
                        parse(e, { dnlScanLines: t = null } = {}) {
                            function readDataBlock() {
                                const t = (0, i.readUint16)(e, o);
                                o += 2;
                                let r = o + t - 2;
                                const n = findNextFileMarker(e, r, o);
                                if (n && n.invalid) {
                                    (0, a.warn)('readDataBlock - incorrect length, current marker is: ' + n.invalid);
                                    r = n.offset;
                                }
                                const s = e.subarray(o, r);
                                o += s.length;
                                return s;
                            }
                            function prepareComponents(e) {
                                const t = Math.ceil(e.samplesPerLine / 8 / e.maxH),
                                    r = Math.ceil(e.scanLines / 8 / e.maxV);
                                for (let a = 0, i = e.components.length; a < i; a++) {
                                    const i = e.components[a],
                                        n = Math.ceil((Math.ceil(e.samplesPerLine / 8) * i.h) / e.maxH),
                                        s = Math.ceil((Math.ceil(e.scanLines / 8) * i.v) / e.maxV),
                                        o = t * i.h,
                                        c = 64 * (r * i.v) * (o + 1);
                                    i.blockData = new Int16Array(c);
                                    i.blocksPerLine = n;
                                    i.blocksPerColumn = s;
                                }
                                e.mcusPerLine = t;
                                e.mcusPerColumn = r;
                            }
                            let r,
                                s,
                                o = 0,
                                c = null,
                                l = null,
                                h = 0;
                            const u = [],
                                d = [],
                                f = [];
                            let g = (0, i.readUint16)(e, o);
                            o += 2;
                            if (65496 !== g) throw new JpegError('SOI not found');
                            g = (0, i.readUint16)(e, o);
                            o += 2;
                            e: for (; 65497 !== g; ) {
                                let p, m, b;
                                switch (g) {
                                    case 65504:
                                    case 65505:
                                    case 65506:
                                    case 65507:
                                    case 65508:
                                    case 65509:
                                    case 65510:
                                    case 65511:
                                    case 65512:
                                    case 65513:
                                    case 65514:
                                    case 65515:
                                    case 65516:
                                    case 65517:
                                    case 65518:
                                    case 65519:
                                    case 65534:
                                        const y = readDataBlock();
                                        65504 === g &&
                                            74 === y[0] &&
                                            70 === y[1] &&
                                            73 === y[2] &&
                                            70 === y[3] &&
                                            0 === y[4] &&
                                            (c = {
                                                version: { major: y[5], minor: y[6] },
                                                densityUnits: y[7],
                                                xDensity: (y[8] << 8) | y[9],
                                                yDensity: (y[10] << 8) | y[11],
                                                thumbWidth: y[12],
                                                thumbHeight: y[13],
                                                thumbData: y.subarray(14, 14 + 3 * y[12] * y[13]),
                                            });
                                        65518 === g &&
                                            65 === y[0] &&
                                            100 === y[1] &&
                                            111 === y[2] &&
                                            98 === y[3] &&
                                            101 === y[4] &&
                                            (l = {
                                                version: (y[5] << 8) | y[6],
                                                flags0: (y[7] << 8) | y[8],
                                                flags1: (y[9] << 8) | y[10],
                                                transformCode: y[11],
                                            });
                                        break;
                                    case 65499:
                                        const w = (0, i.readUint16)(e, o);
                                        o += 2;
                                        const S = w + o - 2;
                                        let x;
                                        for (; o < S; ) {
                                            const t = e[o++],
                                                r = new Uint16Array(64);
                                            if (t >> 4 == 0)
                                                for (m = 0; m < 64; m++) {
                                                    x = n[m];
                                                    r[x] = e[o++];
                                                }
                                            else {
                                                if (t >> 4 != 1) throw new JpegError('DQT - invalid table spec');
                                                for (m = 0; m < 64; m++) {
                                                    x = n[m];
                                                    r[x] = (0, i.readUint16)(e, o);
                                                    o += 2;
                                                }
                                            }
                                            u[15 & t] = r;
                                        }
                                        break;
                                    case 65472:
                                    case 65473:
                                    case 65474:
                                        if (r) throw new JpegError('Only single frame JPEGs supported');
                                        o += 2;
                                        r = {};
                                        r.extended = 65473 === g;
                                        r.progressive = 65474 === g;
                                        r.precision = e[o++];
                                        const k = (0, i.readUint16)(e, o);
                                        o += 2;
                                        r.scanLines = t || k;
                                        r.samplesPerLine = (0, i.readUint16)(e, o);
                                        o += 2;
                                        r.components = [];
                                        r.componentIds = {};
                                        const C = e[o++];
                                        let v = 0,
                                            O = 0;
                                        for (p = 0; p < C; p++) {
                                            const t = e[o],
                                                a = e[o + 1] >> 4,
                                                i = 15 & e[o + 1];
                                            v < a && (v = a);
                                            O < i && (O = i);
                                            const n = e[o + 2];
                                            b = r.components.push({
                                                h: a,
                                                v: i,
                                                quantizationId: n,
                                                quantizationTable: null,
                                            });
                                            r.componentIds[t] = b - 1;
                                            o += 3;
                                        }
                                        r.maxH = v;
                                        r.maxV = O;
                                        prepareComponents(r);
                                        break;
                                    case 65476:
                                        const F = (0, i.readUint16)(e, o);
                                        o += 2;
                                        for (p = 2; p < F; ) {
                                            const t = e[o++],
                                                r = new Uint8Array(16);
                                            let a = 0;
                                            for (m = 0; m < 16; m++, o++) a += r[m] = e[o];
                                            const i = new Uint8Array(a);
                                            for (m = 0; m < a; m++, o++) i[m] = e[o];
                                            p += 17 + a;
                                            (t >> 4 == 0 ? f : d)[15 & t] = buildHuffmanTable(r, i);
                                        }
                                        break;
                                    case 65501:
                                        o += 2;
                                        s = (0, i.readUint16)(e, o);
                                        o += 2;
                                        break;
                                    case 65498:
                                        const T = 1 == ++h && !t;
                                        o += 2;
                                        const E = e[o++],
                                            M = [];
                                        for (p = 0; p < E; p++) {
                                            const t = e[o++],
                                                a = r.componentIds[t],
                                                i = r.components[a];
                                            i.index = t;
                                            const n = e[o++];
                                            i.huffmanTableDC = f[n >> 4];
                                            i.huffmanTableAC = d[15 & n];
                                            M.push(i);
                                        }
                                        const D = e[o++],
                                            N = e[o++],
                                            L = e[o++];
                                        try {
                                            const t = decodeScan(e, o, r, M, s, D, N, L >> 4, 15 & L, T);
                                            o += t;
                                        } catch (t) {
                                            if (t instanceof DNLMarkerError) {
                                                (0, a.warn)(`${t.message} -- attempting to re-parse the JPEG image.`);
                                                return this.parse(e, { dnlScanLines: t.scanLines });
                                            }
                                            if (t instanceof EOIMarkerError) {
                                                (0, a.warn)(`${t.message} -- ignoring the rest of the image data.`);
                                                break e;
                                            }
                                            throw t;
                                        }
                                        break;
                                    case 65500:
                                        o += 4;
                                        break;
                                    case 65535:
                                        255 !== e[o] && o--;
                                        break;
                                    default:
                                        const R = findNextFileMarker(e, o - 2, o - 3);
                                        if (R && R.invalid) {
                                            (0, a.warn)(
                                                'JpegImage.parse - unexpected data, current marker is: ' + R.invalid
                                            );
                                            o = R.offset;
                                            break;
                                        }
                                        if (!R || o >= e.length - 1) {
                                            (0, a.warn)(
                                                'JpegImage.parse - reached the end of the image data without finding an EOI marker (0xFFD9).'
                                            );
                                            break e;
                                        }
                                        throw new JpegError('JpegImage.parse - unknown marker: ' + g.toString(16));
                                }
                                g = (0, i.readUint16)(e, o);
                                o += 2;
                            }
                            this.width = r.samplesPerLine;
                            this.height = r.scanLines;
                            this.jfif = c;
                            this.adobe = l;
                            this.components = [];
                            for (let e = 0, t = r.components.length; e < t; e++) {
                                const t = r.components[e],
                                    a = u[t.quantizationId];
                                a && (t.quantizationTable = a);
                                this.components.push({
                                    index: t.index,
                                    output: buildComponentData(0, t),
                                    scaleX: t.h / r.maxH,
                                    scaleY: t.v / r.maxV,
                                    blocksPerLine: t.blocksPerLine,
                                    blocksPerColumn: t.blocksPerColumn,
                                });
                            }
                            this.numComponents = this.components.length;
                        }
                        _getLinearizedBlockData(e, t, r = !1) {
                            const a = this.width / e,
                                i = this.height / t;
                            let n,
                                s,
                                o,
                                c,
                                l,
                                h,
                                u,
                                d,
                                f,
                                g,
                                p,
                                m = 0;
                            const b = this.components.length,
                                y = e * t * b,
                                w = new Uint8ClampedArray(y),
                                S = new Uint32Array(e),
                                x = 4294967288;
                            let k;
                            for (u = 0; u < b; u++) {
                                n = this.components[u];
                                s = n.scaleX * a;
                                o = n.scaleY * i;
                                m = u;
                                p = n.output;
                                c = (n.blocksPerLine + 1) << 3;
                                if (s !== k) {
                                    for (l = 0; l < e; l++) {
                                        d = 0 | (l * s);
                                        S[l] = ((d & x) << 3) | (7 & d);
                                    }
                                    k = s;
                                }
                                for (h = 0; h < t; h++) {
                                    d = 0 | (h * o);
                                    g = (c * (d & x)) | ((7 & d) << 3);
                                    for (l = 0; l < e; l++) {
                                        w[m] = p[g + S[l]];
                                        m += b;
                                    }
                                }
                            }
                            let C = this._decodeTransform;
                            r || 4 !== b || C || (C = new Int32Array([-256, 255, -256, 255, -256, 255, -256, 255]));
                            if (C)
                                for (u = 0; u < y; )
                                    for (d = 0, f = 0; d < b; d++, u++, f += 2) w[u] = ((w[u] * C[f]) >> 8) + C[f + 1];
                            return w;
                        }
                        get _isColorConversionNeeded() {
                            return this.adobe
                                ? !!this.adobe.transformCode
                                : 3 === this.numComponents
                                ? 0 !== this._colorTransform &&
                                  (82 !== this.components[0].index ||
                                      71 !== this.components[1].index ||
                                      66 !== this.components[2].index)
                                : 1 === this._colorTransform;
                        }
                        _convertYccToRgb(e) {
                            let t, r, a;
                            for (let i = 0, n = e.length; i < n; i += 3) {
                                t = e[i];
                                r = e[i + 1];
                                a = e[i + 2];
                                e[i] = t - 179.456 + 1.402 * a;
                                e[i + 1] = t + 135.459 - 0.344 * r - 0.714 * a;
                                e[i + 2] = t - 226.816 + 1.772 * r;
                            }
                            return e;
                        }
                        _convertYcckToRgb(e) {
                            let t,
                                r,
                                a,
                                i,
                                n = 0;
                            for (let s = 0, o = e.length; s < o; s += 4) {
                                t = e[s];
                                r = e[s + 1];
                                a = e[s + 2];
                                i = e[s + 3];
                                e[n++] =
                                    r *
                                        (-660635669420364e-19 * r +
                                            0.000437130475926232 * a -
                                            54080610064599e-18 * t +
                                            0.00048449797120281 * i -
                                            0.154362151871126) -
                                    122.67195406894 +
                                    a *
                                        (-0.000957964378445773 * a +
                                            0.000817076911346625 * t -
                                            0.00477271405408747 * i +
                                            1.53380253221734) +
                                    t * (0.000961250184130688 * t - 0.00266257332283933 * i + 0.48357088451265) +
                                    i * (-0.000336197177618394 * i + 0.484791561490776);
                                e[n++] =
                                    107.268039397724 +
                                    r *
                                        (219927104525741e-19 * r -
                                            0.000640992018297945 * a +
                                            0.000659397001245577 * t +
                                            0.000426105652938837 * i -
                                            0.176491792462875) +
                                    a *
                                        (-0.000778269941513683 * a +
                                            0.00130872261408275 * t +
                                            0.000770482631801132 * i -
                                            0.151051492775562) +
                                    t * (0.00126935368114843 * t - 0.00265090189010898 * i + 0.25802910206845) +
                                    i * (-0.000318913117588328 * i - 0.213742400323665);
                                e[n++] =
                                    r *
                                        (-0.000570115196973677 * r -
                                            263409051004589e-19 * a +
                                            0.0020741088115012 * t -
                                            0.00288260236853442 * i +
                                            0.814272968359295) -
                                    20.810012546947 +
                                    a *
                                        (-153496057440975e-19 * a -
                                            0.000132689043961446 * t +
                                            0.000560833691242812 * i -
                                            0.195152027534049) +
                                    t * (0.00174418132927582 * t - 0.00255243321439347 * i + 0.116935020465145) +
                                    i * (-0.000343531996510555 * i + 0.24165260232407);
                            }
                            return e.subarray(0, n);
                        }
                        _convertYcckToCmyk(e) {
                            let t, r, a;
                            for (let i = 0, n = e.length; i < n; i += 4) {
                                t = e[i];
                                r = e[i + 1];
                                a = e[i + 2];
                                e[i] = 434.456 - t - 1.402 * a;
                                e[i + 1] = 119.541 - t + 0.344 * r + 0.714 * a;
                                e[i + 2] = 481.816 - t - 1.772 * r;
                            }
                            return e;
                        }
                        _convertCmykToRgb(e) {
                            let t,
                                r,
                                a,
                                i,
                                n = 0;
                            for (let s = 0, o = e.length; s < o; s += 4) {
                                t = e[s];
                                r = e[s + 1];
                                a = e[s + 2];
                                i = e[s + 3];
                                e[n++] =
                                    255 +
                                    t *
                                        (-6747147073602441e-20 * t +
                                            0.0008379262121013727 * r +
                                            0.0002894718188643294 * a +
                                            0.003264231057537806 * i -
                                            1.1185611867203937) +
                                    r *
                                        (26374107616089405e-21 * r -
                                            8626949158638572e-20 * a -
                                            0.0002748769067499491 * i -
                                            0.02155688794978967) +
                                    a * (-3878099212869363e-20 * a - 0.0003267808279485286 * i + 0.0686742238595345) -
                                    i * (0.0003361971776183937 * i + 0.7430659151342254);
                                e[n++] =
                                    255 +
                                    t *
                                        (0.00013596372813588848 * t +
                                            0.000924537132573585 * r +
                                            0.00010567359618683593 * a +
                                            0.0004791864687436512 * i -
                                            0.3109689587515875) +
                                    r *
                                        (-0.00023545346108370344 * r +
                                            0.0002702845253534714 * a +
                                            0.0020200308977307156 * i -
                                            0.7488052167015494) +
                                    a * (6834815998235662e-20 * a + 0.00015168452363460973 * i - 0.09751927774728933) -
                                    i * (0.0003189131175883281 * i + 0.7364883807733168);
                                e[n++] =
                                    255 +
                                    t *
                                        (13598650411385307e-21 * t +
                                            0.00012423956175490851 * r +
                                            0.0004751985097583589 * a -
                                            36729317476630422e-22 * i -
                                            0.05562186980264034) +
                                    r *
                                        (0.00016141380598724676 * r +
                                            0.0009692239130725186 * a +
                                            0.0007782692450036253 * i -
                                            0.44015232367526463) +
                                    a * (5.068882914068769e-7 * a + 0.0017778369011375071 * i - 0.7591454649749609) -
                                    i * (0.0003435319965105553 * i + 0.7063770186160144);
                            }
                            return e.subarray(0, n);
                        }
                        getData({ width: e, height: t, forceRGB: r = !1, isSourcePDF: a = !1 }) {
                            if (this.numComponents > 4) throw new JpegError('Unsupported color mode');
                            const i = this._getLinearizedBlockData(e, t, a);
                            if (1 === this.numComponents && r) {
                                const e = i.length,
                                    t = new Uint8ClampedArray(3 * e);
                                let r = 0;
                                for (let a = 0; a < e; a++) {
                                    const e = i[a];
                                    t[r++] = e;
                                    t[r++] = e;
                                    t[r++] = e;
                                }
                                return t;
                            }
                            if (3 === this.numComponents && this._isColorConversionNeeded)
                                return this._convertYccToRgb(i);
                            if (4 === this.numComponents) {
                                if (this._isColorConversionNeeded)
                                    return r ? this._convertYcckToRgb(i) : this._convertYcckToCmyk(i);
                                if (r) return this._convertCmykToRgb(i);
                            }
                            return i;
                        }
                    };
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.JpxStream = void 0;
                    var a = r(19),
                        i = r(30),
                        n = r(2);
                    class JpxStream extends a.DecodeStream {
                        constructor(e, t, r) {
                            super(t);
                            this.stream = e;
                            this.dict = e.dict;
                            this.maybeLength = t;
                            this.params = r;
                        }
                        get bytes() {
                            return (0, n.shadow)(this, 'bytes', this.stream.getBytes(this.maybeLength));
                        }
                        ensureBuffer(e) {}
                        readBlock() {
                            if (this.eof) return;
                            const e = new i.JpxImage();
                            e.parse(this.bytes);
                            const t = e.width,
                                r = e.height,
                                a = e.componentsCount,
                                n = e.tiles.length;
                            if (1 === n) this.buffer = e.tiles[0].items;
                            else {
                                const i = new Uint8ClampedArray(t * r * a);
                                for (let r = 0; r < n; r++) {
                                    const n = e.tiles[r],
                                        s = n.width,
                                        o = n.height,
                                        c = n.left,
                                        l = n.top,
                                        h = n.items;
                                    let u = 0,
                                        d = (t * l + c) * a;
                                    const f = t * a,
                                        g = s * a;
                                    for (let e = 0; e < o; e++) {
                                        const e = h.subarray(u, u + g);
                                        i.set(e, d);
                                        u += g;
                                        d += f;
                                    }
                                }
                                this.buffer = i;
                            }
                            this.bufferLength = this.buffer.length;
                            this.eof = !0;
                        }
                    }
                    t.JpxStream = JpxStream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.JpxImage = void 0;
                    var a = r(2),
                        i = r(9),
                        n = r(26);
                    class JpxError extends a.BaseException {
                        constructor(e) {
                            super(`JPX error: ${e}`);
                        }
                    }
                    const s = { LL: 0, LH: 1, HL: 1, HH: 2 };
                    t.JpxImage = class JpxImage {
                        constructor() {
                            this.failOnCorruptedImage = !1;
                        }
                        parse(e) {
                            if (65359 === (0, i.readUint16)(e, 0)) {
                                this.parseCodestream(e, 0, e.length);
                                return;
                            }
                            const t = e.length;
                            let r = 0;
                            for (; r < t; ) {
                                let n = 8,
                                    s = (0, i.readUint32)(e, r);
                                const o = (0, i.readUint32)(e, r + 4);
                                r += n;
                                if (1 === s) {
                                    s = 4294967296 * (0, i.readUint32)(e, r) + (0, i.readUint32)(e, r + 4);
                                    r += 8;
                                    n += 8;
                                }
                                0 === s && (s = t - r + n);
                                if (s < n) throw new JpxError('Invalid box field size');
                                const c = s - n;
                                let l = !0;
                                switch (o) {
                                    case 1785737832:
                                        l = !1;
                                        break;
                                    case 1668246642:
                                        const t = e[r];
                                        if (1 === t) {
                                            const t = (0, i.readUint32)(e, r + 3);
                                            switch (t) {
                                                case 16:
                                                case 17:
                                                case 18:
                                                    break;
                                                default:
                                                    (0, a.warn)('Unknown colorspace ' + t);
                                            }
                                        } else 2 === t && (0, a.info)('ICC profile not supported');
                                        break;
                                    case 1785737827:
                                        this.parseCodestream(e, r, r + c);
                                        break;
                                    case 1783636e3:
                                        218793738 !== (0, i.readUint32)(e, r) && (0, a.warn)('Invalid JP2 signature');
                                        break;
                                    case 1783634458:
                                    case 1718909296:
                                    case 1920099697:
                                    case 1919251232:
                                    case 1768449138:
                                        break;
                                    default:
                                        const n = String.fromCharCode(
                                            (o >> 24) & 255,
                                            (o >> 16) & 255,
                                            (o >> 8) & 255,
                                            255 & o
                                        );
                                        (0, a.warn)(`Unsupported header type ${o} (${n}).`);
                                }
                                l && (r += c);
                            }
                        }
                        parseImageProperties(e) {
                            let t = e.getByte();
                            for (; t >= 0; ) {
                                const r = t;
                                t = e.getByte();
                                if (65361 === ((r << 8) | t)) {
                                    e.skip(4);
                                    const t = e.getInt32() >>> 0,
                                        r = e.getInt32() >>> 0,
                                        a = e.getInt32() >>> 0,
                                        i = e.getInt32() >>> 0;
                                    e.skip(16);
                                    const n = e.getUint16();
                                    this.width = t - a;
                                    this.height = r - i;
                                    this.componentsCount = n;
                                    this.bitsPerComponent = 8;
                                    return;
                                }
                            }
                            throw new JpxError('No size marker found in JPX stream');
                        }
                        parseCodestream(e, t, r) {
                            const n = {};
                            let s = !1;
                            try {
                                let o = t;
                                for (; o + 1 < r; ) {
                                    const t = (0, i.readUint16)(e, o);
                                    o += 2;
                                    let r,
                                        c,
                                        l,
                                        h,
                                        u,
                                        d,
                                        f = 0;
                                    switch (t) {
                                        case 65359:
                                            n.mainHeader = !0;
                                            break;
                                        case 65497:
                                            break;
                                        case 65361:
                                            f = (0, i.readUint16)(e, o);
                                            const g = {};
                                            g.Xsiz = (0, i.readUint32)(e, o + 4);
                                            g.Ysiz = (0, i.readUint32)(e, o + 8);
                                            g.XOsiz = (0, i.readUint32)(e, o + 12);
                                            g.YOsiz = (0, i.readUint32)(e, o + 16);
                                            g.XTsiz = (0, i.readUint32)(e, o + 20);
                                            g.YTsiz = (0, i.readUint32)(e, o + 24);
                                            g.XTOsiz = (0, i.readUint32)(e, o + 28);
                                            g.YTOsiz = (0, i.readUint32)(e, o + 32);
                                            const p = (0, i.readUint16)(e, o + 36);
                                            g.Csiz = p;
                                            const m = [];
                                            r = o + 38;
                                            for (let t = 0; t < p; t++) {
                                                const t = {
                                                    precision: 1 + (127 & e[r]),
                                                    isSigned: !!(128 & e[r]),
                                                    XRsiz: e[r + 1],
                                                    YRsiz: e[r + 2],
                                                };
                                                r += 3;
                                                calculateComponentDimensions(t, g);
                                                m.push(t);
                                            }
                                            n.SIZ = g;
                                            n.components = m;
                                            calculateTileGrids(n, m);
                                            n.QCC = [];
                                            n.COC = [];
                                            break;
                                        case 65372:
                                            f = (0, i.readUint16)(e, o);
                                            const b = {};
                                            r = o + 2;
                                            c = e[r++];
                                            switch (31 & c) {
                                                case 0:
                                                    h = 8;
                                                    u = !0;
                                                    break;
                                                case 1:
                                                    h = 16;
                                                    u = !1;
                                                    break;
                                                case 2:
                                                    h = 16;
                                                    u = !0;
                                                    break;
                                                default:
                                                    throw new Error('Invalid SQcd value ' + c);
                                            }
                                            b.noQuantization = 8 === h;
                                            b.scalarExpounded = u;
                                            b.guardBits = c >> 5;
                                            l = [];
                                            for (; r < f + o; ) {
                                                const t = {};
                                                if (8 === h) {
                                                    t.epsilon = e[r++] >> 3;
                                                    t.mu = 0;
                                                } else {
                                                    t.epsilon = e[r] >> 3;
                                                    t.mu = ((7 & e[r]) << 8) | e[r + 1];
                                                    r += 2;
                                                }
                                                l.push(t);
                                            }
                                            b.SPqcds = l;
                                            if (n.mainHeader) n.QCD = b;
                                            else {
                                                n.currentTile.QCD = b;
                                                n.currentTile.QCC = [];
                                            }
                                            break;
                                        case 65373:
                                            f = (0, i.readUint16)(e, o);
                                            const y = {};
                                            r = o + 2;
                                            let w;
                                            if (n.SIZ.Csiz < 257) w = e[r++];
                                            else {
                                                w = (0, i.readUint16)(e, r);
                                                r += 2;
                                            }
                                            c = e[r++];
                                            switch (31 & c) {
                                                case 0:
                                                    h = 8;
                                                    u = !0;
                                                    break;
                                                case 1:
                                                    h = 16;
                                                    u = !1;
                                                    break;
                                                case 2:
                                                    h = 16;
                                                    u = !0;
                                                    break;
                                                default:
                                                    throw new Error('Invalid SQcd value ' + c);
                                            }
                                            y.noQuantization = 8 === h;
                                            y.scalarExpounded = u;
                                            y.guardBits = c >> 5;
                                            l = [];
                                            for (; r < f + o; ) {
                                                const t = {};
                                                if (8 === h) {
                                                    t.epsilon = e[r++] >> 3;
                                                    t.mu = 0;
                                                } else {
                                                    t.epsilon = e[r] >> 3;
                                                    t.mu = ((7 & e[r]) << 8) | e[r + 1];
                                                    r += 2;
                                                }
                                                l.push(t);
                                            }
                                            y.SPqcds = l;
                                            n.mainHeader ? (n.QCC[w] = y) : (n.currentTile.QCC[w] = y);
                                            break;
                                        case 65362:
                                            f = (0, i.readUint16)(e, o);
                                            const S = {};
                                            r = o + 2;
                                            const x = e[r++];
                                            S.entropyCoderWithCustomPrecincts = !!(1 & x);
                                            S.sopMarkerUsed = !!(2 & x);
                                            S.ephMarkerUsed = !!(4 & x);
                                            S.progressionOrder = e[r++];
                                            S.layersCount = (0, i.readUint16)(e, r);
                                            r += 2;
                                            S.multipleComponentTransform = e[r++];
                                            S.decompositionLevelsCount = e[r++];
                                            S.xcb = 2 + (15 & e[r++]);
                                            S.ycb = 2 + (15 & e[r++]);
                                            const k = e[r++];
                                            S.selectiveArithmeticCodingBypass = !!(1 & k);
                                            S.resetContextProbabilities = !!(2 & k);
                                            S.terminationOnEachCodingPass = !!(4 & k);
                                            S.verticallyStripe = !!(8 & k);
                                            S.predictableTermination = !!(16 & k);
                                            S.segmentationSymbolUsed = !!(32 & k);
                                            S.reversibleTransformation = e[r++];
                                            if (S.entropyCoderWithCustomPrecincts) {
                                                const t = [];
                                                for (; r < f + o; ) {
                                                    const a = e[r++];
                                                    t.push({ PPx: 15 & a, PPy: a >> 4 });
                                                }
                                                S.precinctsSizes = t;
                                            }
                                            const C = [];
                                            S.selectiveArithmeticCodingBypass &&
                                                C.push('selectiveArithmeticCodingBypass');
                                            S.resetContextProbabilities && C.push('resetContextProbabilities');
                                            S.terminationOnEachCodingPass && C.push('terminationOnEachCodingPass');
                                            S.verticallyStripe && C.push('verticallyStripe');
                                            S.predictableTermination && C.push('predictableTermination');
                                            if (C.length > 0) {
                                                s = !0;
                                                (0, a.warn)(`JPX: Unsupported COD options (${C.join(', ')}).`);
                                            }
                                            if (n.mainHeader) n.COD = S;
                                            else {
                                                n.currentTile.COD = S;
                                                n.currentTile.COC = [];
                                            }
                                            break;
                                        case 65424:
                                            f = (0, i.readUint16)(e, o);
                                            d = {};
                                            d.index = (0, i.readUint16)(e, o + 2);
                                            d.length = (0, i.readUint32)(e, o + 4);
                                            d.dataEnd = d.length + o - 2;
                                            d.partIndex = e[o + 8];
                                            d.partsCount = e[o + 9];
                                            n.mainHeader = !1;
                                            if (0 === d.partIndex) {
                                                d.COD = n.COD;
                                                d.COC = n.COC.slice(0);
                                                d.QCD = n.QCD;
                                                d.QCC = n.QCC.slice(0);
                                            }
                                            n.currentTile = d;
                                            break;
                                        case 65427:
                                            d = n.currentTile;
                                            if (0 === d.partIndex) {
                                                initializeTile(n, d.index);
                                                buildPackets(n);
                                            }
                                            f = d.dataEnd - o;
                                            parseTilePackets(n, e, o, f);
                                            break;
                                        case 65363:
                                            (0, a.warn)('JPX: Codestream code 0xFF53 (COC) is not implemented.');
                                        case 65365:
                                        case 65367:
                                        case 65368:
                                        case 65380:
                                            f = (0, i.readUint16)(e, o);
                                            break;
                                        default:
                                            throw new Error('Unknown codestream code: ' + t.toString(16));
                                    }
                                    o += f;
                                }
                            } catch (e) {
                                if (s || this.failOnCorruptedImage) throw new JpxError(e.message);
                                (0, a.warn)(`JPX: Trying to recover from: "${e.message}".`);
                            }
                            this.tiles = (function transformComponents(e) {
                                const t = e.SIZ,
                                    r = e.components,
                                    a = t.Csiz,
                                    i = [];
                                for (let t = 0, n = e.tiles.length; t < n; t++) {
                                    const n = e.tiles[t],
                                        s = [];
                                    for (let t = 0; t < a; t++) s[t] = transformTile(e, n, t);
                                    const o = s[0],
                                        c = new Uint8ClampedArray(o.items.length * a),
                                        l = { left: o.left, top: o.top, width: o.width, height: o.height, items: c };
                                    let h,
                                        u,
                                        d,
                                        f,
                                        g,
                                        p,
                                        m,
                                        b = 0;
                                    if (n.codingStyleDefaultParameters.multipleComponentTransform) {
                                        const e = 4 === a,
                                            t = s[0].items,
                                            i = s[1].items,
                                            o = s[2].items,
                                            l = e ? s[3].items : null;
                                        h = r[0].precision - 8;
                                        u = 0.5 + (128 << h);
                                        const y = n.components[0],
                                            w = a - 3;
                                        f = t.length;
                                        if (y.codingStyleParameters.reversibleTransformation)
                                            for (d = 0; d < f; d++, b += w) {
                                                g = t[d] + u;
                                                p = i[d];
                                                m = o[d];
                                                const e = g - ((m + p) >> 2);
                                                c[b++] = (e + m) >> h;
                                                c[b++] = e >> h;
                                                c[b++] = (e + p) >> h;
                                            }
                                        else
                                            for (d = 0; d < f; d++, b += w) {
                                                g = t[d] + u;
                                                p = i[d];
                                                m = o[d];
                                                c[b++] = (g + 1.402 * m) >> h;
                                                c[b++] = (g - 0.34413 * p - 0.71414 * m) >> h;
                                                c[b++] = (g + 1.772 * p) >> h;
                                            }
                                        if (e) for (d = 0, b = 3; d < f; d++, b += 4) c[b] = (l[d] + u) >> h;
                                    } else
                                        for (let e = 0; e < a; e++) {
                                            const t = s[e].items;
                                            h = r[e].precision - 8;
                                            u = 0.5 + (128 << h);
                                            for (b = e, d = 0, f = t.length; d < f; d++) {
                                                c[b] = (t[d] + u) >> h;
                                                b += a;
                                            }
                                        }
                                    i.push(l);
                                }
                                return i;
                            })(n);
                            this.width = n.SIZ.Xsiz - n.SIZ.XOsiz;
                            this.height = n.SIZ.Ysiz - n.SIZ.YOsiz;
                            this.componentsCount = n.SIZ.Csiz;
                        }
                    };
                    function calculateComponentDimensions(e, t) {
                        e.x0 = Math.ceil(t.XOsiz / e.XRsiz);
                        e.x1 = Math.ceil(t.Xsiz / e.XRsiz);
                        e.y0 = Math.ceil(t.YOsiz / e.YRsiz);
                        e.y1 = Math.ceil(t.Ysiz / e.YRsiz);
                        e.width = e.x1 - e.x0;
                        e.height = e.y1 - e.y0;
                    }
                    function calculateTileGrids(e, t) {
                        const r = e.SIZ,
                            a = [];
                        let i;
                        const n = Math.ceil((r.Xsiz - r.XTOsiz) / r.XTsiz),
                            s = Math.ceil((r.Ysiz - r.YTOsiz) / r.YTsiz);
                        for (let e = 0; e < s; e++)
                            for (let t = 0; t < n; t++) {
                                i = {};
                                i.tx0 = Math.max(r.XTOsiz + t * r.XTsiz, r.XOsiz);
                                i.ty0 = Math.max(r.YTOsiz + e * r.YTsiz, r.YOsiz);
                                i.tx1 = Math.min(r.XTOsiz + (t + 1) * r.XTsiz, r.Xsiz);
                                i.ty1 = Math.min(r.YTOsiz + (e + 1) * r.YTsiz, r.Ysiz);
                                i.width = i.tx1 - i.tx0;
                                i.height = i.ty1 - i.ty0;
                                i.components = [];
                                a.push(i);
                            }
                        e.tiles = a;
                        for (let e = 0, n = r.Csiz; e < n; e++) {
                            const r = t[e];
                            for (let t = 0, n = a.length; t < n; t++) {
                                const n = {};
                                i = a[t];
                                n.tcx0 = Math.ceil(i.tx0 / r.XRsiz);
                                n.tcy0 = Math.ceil(i.ty0 / r.YRsiz);
                                n.tcx1 = Math.ceil(i.tx1 / r.XRsiz);
                                n.tcy1 = Math.ceil(i.ty1 / r.YRsiz);
                                n.width = n.tcx1 - n.tcx0;
                                n.height = n.tcy1 - n.tcy0;
                                i.components[e] = n;
                            }
                        }
                    }
                    function getBlocksDimensions(e, t, r) {
                        const a = t.codingStyleParameters,
                            i = {};
                        if (a.entropyCoderWithCustomPrecincts) {
                            i.PPx = a.precinctsSizes[r].PPx;
                            i.PPy = a.precinctsSizes[r].PPy;
                        } else {
                            i.PPx = 15;
                            i.PPy = 15;
                        }
                        i.xcb_ = r > 0 ? Math.min(a.xcb, i.PPx - 1) : Math.min(a.xcb, i.PPx);
                        i.ycb_ = r > 0 ? Math.min(a.ycb, i.PPy - 1) : Math.min(a.ycb, i.PPy);
                        return i;
                    }
                    function buildPrecincts(e, t, r) {
                        const a = 1 << r.PPx,
                            i = 1 << r.PPy,
                            n = 0 === t.resLevel,
                            s = 1 << (r.PPx + (n ? 0 : -1)),
                            o = 1 << (r.PPy + (n ? 0 : -1)),
                            c = t.trx1 > t.trx0 ? Math.ceil(t.trx1 / a) - Math.floor(t.trx0 / a) : 0,
                            l = t.try1 > t.try0 ? Math.ceil(t.try1 / i) - Math.floor(t.try0 / i) : 0,
                            h = c * l;
                        t.precinctParameters = {
                            precinctWidth: a,
                            precinctHeight: i,
                            numprecinctswide: c,
                            numprecinctshigh: l,
                            numprecincts: h,
                            precinctWidthInSubband: s,
                            precinctHeightInSubband: o,
                        };
                    }
                    function buildCodeblocks(e, t, r) {
                        const a = r.xcb_,
                            i = r.ycb_,
                            n = 1 << a,
                            s = 1 << i,
                            o = t.tbx0 >> a,
                            c = t.tby0 >> i,
                            l = (t.tbx1 + n - 1) >> a,
                            h = (t.tby1 + s - 1) >> i,
                            u = t.resolution.precinctParameters,
                            d = [],
                            f = [];
                        let g, p, m, b;
                        for (p = c; p < h; p++)
                            for (g = o; g < l; g++) {
                                m = { cbx: g, cby: p, tbx0: n * g, tby0: s * p, tbx1: n * (g + 1), tby1: s * (p + 1) };
                                m.tbx0_ = Math.max(t.tbx0, m.tbx0);
                                m.tby0_ = Math.max(t.tby0, m.tby0);
                                m.tbx1_ = Math.min(t.tbx1, m.tbx1);
                                m.tby1_ = Math.min(t.tby1, m.tby1);
                                b =
                                    Math.floor((m.tbx0_ - t.tbx0) / u.precinctWidthInSubband) +
                                    Math.floor((m.tby0_ - t.tby0) / u.precinctHeightInSubband) * u.numprecinctswide;
                                m.precinctNumber = b;
                                m.subbandType = t.type;
                                m.Lblock = 3;
                                if (m.tbx1_ <= m.tbx0_ || m.tby1_ <= m.tby0_) continue;
                                d.push(m);
                                let e = f[b];
                                if (void 0 !== e) {
                                    g < e.cbxMin ? (e.cbxMin = g) : g > e.cbxMax && (e.cbxMax = g);
                                    p < e.cbyMin ? (e.cbxMin = p) : p > e.cbyMax && (e.cbyMax = p);
                                } else f[b] = e = { cbxMin: g, cbyMin: p, cbxMax: g, cbyMax: p };
                                m.precinct = e;
                            }
                        t.codeblockParameters = {
                            codeblockWidth: a,
                            codeblockHeight: i,
                            numcodeblockwide: l - o + 1,
                            numcodeblockhigh: h - c + 1,
                        };
                        t.codeblocks = d;
                        t.precincts = f;
                    }
                    function createPacket(e, t, r) {
                        const a = [],
                            i = e.subbands;
                        for (let e = 0, r = i.length; e < r; e++) {
                            const r = i[e].codeblocks;
                            for (let e = 0, i = r.length; e < i; e++) {
                                const i = r[e];
                                i.precinctNumber === t && a.push(i);
                            }
                        }
                        return { layerNumber: r, codeblocks: a };
                    }
                    function LayerResolutionComponentPositionIterator(e) {
                        const t = e.SIZ,
                            r = e.currentTile.index,
                            a = e.tiles[r],
                            i = a.codingStyleDefaultParameters.layersCount,
                            n = t.Csiz;
                        let s = 0;
                        for (let e = 0; e < n; e++)
                            s = Math.max(s, a.components[e].codingStyleParameters.decompositionLevelsCount);
                        let o = 0,
                            c = 0,
                            l = 0,
                            h = 0;
                        this.nextPacket = function JpxImage_nextPacket() {
                            for (; o < i; o++) {
                                for (; c <= s; c++) {
                                    for (; l < n; l++) {
                                        const e = a.components[l];
                                        if (c > e.codingStyleParameters.decompositionLevelsCount) continue;
                                        const t = e.resolutions[c],
                                            r = t.precinctParameters.numprecincts;
                                        for (; h < r; ) {
                                            const e = createPacket(t, h, o);
                                            h++;
                                            return e;
                                        }
                                        h = 0;
                                    }
                                    l = 0;
                                }
                                c = 0;
                            }
                            throw new JpxError('Out of packets');
                        };
                    }
                    function ResolutionLayerComponentPositionIterator(e) {
                        const t = e.SIZ,
                            r = e.currentTile.index,
                            a = e.tiles[r],
                            i = a.codingStyleDefaultParameters.layersCount,
                            n = t.Csiz;
                        let s = 0;
                        for (let e = 0; e < n; e++)
                            s = Math.max(s, a.components[e].codingStyleParameters.decompositionLevelsCount);
                        let o = 0,
                            c = 0,
                            l = 0,
                            h = 0;
                        this.nextPacket = function JpxImage_nextPacket() {
                            for (; o <= s; o++) {
                                for (; c < i; c++) {
                                    for (; l < n; l++) {
                                        const e = a.components[l];
                                        if (o > e.codingStyleParameters.decompositionLevelsCount) continue;
                                        const t = e.resolutions[o],
                                            r = t.precinctParameters.numprecincts;
                                        for (; h < r; ) {
                                            const e = createPacket(t, h, c);
                                            h++;
                                            return e;
                                        }
                                        h = 0;
                                    }
                                    l = 0;
                                }
                                c = 0;
                            }
                            throw new JpxError('Out of packets');
                        };
                    }
                    function ResolutionPositionComponentLayerIterator(e) {
                        const t = e.SIZ,
                            r = e.currentTile.index,
                            a = e.tiles[r],
                            i = a.codingStyleDefaultParameters.layersCount,
                            n = t.Csiz;
                        let s,
                            o,
                            c,
                            l,
                            h = 0;
                        for (c = 0; c < n; c++) {
                            const e = a.components[c];
                            h = Math.max(h, e.codingStyleParameters.decompositionLevelsCount);
                        }
                        const u = new Int32Array(h + 1);
                        for (o = 0; o <= h; ++o) {
                            let e = 0;
                            for (c = 0; c < n; ++c) {
                                const t = a.components[c].resolutions;
                                o < t.length && (e = Math.max(e, t[o].precinctParameters.numprecincts));
                            }
                            u[o] = e;
                        }
                        s = 0;
                        o = 0;
                        c = 0;
                        l = 0;
                        this.nextPacket = function JpxImage_nextPacket() {
                            for (; o <= h; o++) {
                                for (; l < u[o]; l++) {
                                    for (; c < n; c++) {
                                        const e = a.components[c];
                                        if (o > e.codingStyleParameters.decompositionLevelsCount) continue;
                                        const t = e.resolutions[o],
                                            r = t.precinctParameters.numprecincts;
                                        if (!(l >= r)) {
                                            for (; s < i; ) {
                                                const e = createPacket(t, l, s);
                                                s++;
                                                return e;
                                            }
                                            s = 0;
                                        }
                                    }
                                    c = 0;
                                }
                                l = 0;
                            }
                            throw new JpxError('Out of packets');
                        };
                    }
                    function PositionComponentResolutionLayerIterator(e) {
                        const t = e.SIZ,
                            r = e.currentTile.index,
                            a = e.tiles[r],
                            i = a.codingStyleDefaultParameters.layersCount,
                            n = t.Csiz,
                            s = getPrecinctSizesInImageScale(a),
                            o = s;
                        let c = 0,
                            l = 0,
                            h = 0,
                            u = 0,
                            d = 0;
                        this.nextPacket = function JpxImage_nextPacket() {
                            for (; d < o.maxNumHigh; d++) {
                                for (; u < o.maxNumWide; u++) {
                                    for (; h < n; h++) {
                                        const e = a.components[h],
                                            t = e.codingStyleParameters.decompositionLevelsCount;
                                        for (; l <= t; l++) {
                                            const t = e.resolutions[l],
                                                r = s.components[h].resolutions[l],
                                                a = getPrecinctIndexIfExist(u, d, r, o, t);
                                            if (null !== a) {
                                                for (; c < i; ) {
                                                    const e = createPacket(t, a, c);
                                                    c++;
                                                    return e;
                                                }
                                                c = 0;
                                            }
                                        }
                                        l = 0;
                                    }
                                    h = 0;
                                }
                                u = 0;
                            }
                            throw new JpxError('Out of packets');
                        };
                    }
                    function ComponentPositionResolutionLayerIterator(e) {
                        const t = e.SIZ,
                            r = e.currentTile.index,
                            a = e.tiles[r],
                            i = a.codingStyleDefaultParameters.layersCount,
                            n = t.Csiz,
                            s = getPrecinctSizesInImageScale(a);
                        let o = 0,
                            c = 0,
                            l = 0,
                            h = 0,
                            u = 0;
                        this.nextPacket = function JpxImage_nextPacket() {
                            for (; l < n; ++l) {
                                const e = a.components[l],
                                    t = s.components[l],
                                    r = e.codingStyleParameters.decompositionLevelsCount;
                                for (; u < t.maxNumHigh; u++) {
                                    for (; h < t.maxNumWide; h++) {
                                        for (; c <= r; c++) {
                                            const r = e.resolutions[c],
                                                a = t.resolutions[c],
                                                n = getPrecinctIndexIfExist(h, u, a, t, r);
                                            if (null !== n) {
                                                for (; o < i; ) {
                                                    const e = createPacket(r, n, o);
                                                    o++;
                                                    return e;
                                                }
                                                o = 0;
                                            }
                                        }
                                        c = 0;
                                    }
                                    h = 0;
                                }
                                u = 0;
                            }
                            throw new JpxError('Out of packets');
                        };
                    }
                    function getPrecinctIndexIfExist(e, t, r, a, i) {
                        const n = e * a.minWidth,
                            s = t * a.minHeight;
                        if (n % r.width != 0 || s % r.height != 0) return null;
                        const o = (s / r.width) * i.precinctParameters.numprecinctswide;
                        return n / r.height + o;
                    }
                    function getPrecinctSizesInImageScale(e) {
                        const t = e.components.length;
                        let r = Number.MAX_VALUE,
                            a = Number.MAX_VALUE,
                            i = 0,
                            n = 0;
                        const s = new Array(t);
                        for (let o = 0; o < t; o++) {
                            const t = e.components[o],
                                c = t.codingStyleParameters.decompositionLevelsCount,
                                l = new Array(c + 1);
                            let h = Number.MAX_VALUE,
                                u = Number.MAX_VALUE,
                                d = 0,
                                f = 0,
                                g = 1;
                            for (let e = c; e >= 0; --e) {
                                const r = t.resolutions[e],
                                    a = g * r.precinctParameters.precinctWidth,
                                    i = g * r.precinctParameters.precinctHeight;
                                h = Math.min(h, a);
                                u = Math.min(u, i);
                                d = Math.max(d, r.precinctParameters.numprecinctswide);
                                f = Math.max(f, r.precinctParameters.numprecinctshigh);
                                l[e] = { width: a, height: i };
                                g <<= 1;
                            }
                            r = Math.min(r, h);
                            a = Math.min(a, u);
                            i = Math.max(i, d);
                            n = Math.max(n, f);
                            s[o] = { resolutions: l, minWidth: h, minHeight: u, maxNumWide: d, maxNumHigh: f };
                        }
                        return { components: s, minWidth: r, minHeight: a, maxNumWide: i, maxNumHigh: n };
                    }
                    function buildPackets(e) {
                        const t = e.SIZ,
                            r = e.currentTile.index,
                            a = e.tiles[r],
                            i = t.Csiz;
                        for (let e = 0; e < i; e++) {
                            const t = a.components[e],
                                r = t.codingStyleParameters.decompositionLevelsCount,
                                i = [],
                                n = [];
                            for (let e = 0; e <= r; e++) {
                                const a = getBlocksDimensions(0, t, e),
                                    s = {},
                                    o = 1 << (r - e);
                                s.trx0 = Math.ceil(t.tcx0 / o);
                                s.try0 = Math.ceil(t.tcy0 / o);
                                s.trx1 = Math.ceil(t.tcx1 / o);
                                s.try1 = Math.ceil(t.tcy1 / o);
                                s.resLevel = e;
                                buildPrecincts(0, s, a);
                                i.push(s);
                                let c;
                                if (0 === e) {
                                    c = {};
                                    c.type = 'LL';
                                    c.tbx0 = Math.ceil(t.tcx0 / o);
                                    c.tby0 = Math.ceil(t.tcy0 / o);
                                    c.tbx1 = Math.ceil(t.tcx1 / o);
                                    c.tby1 = Math.ceil(t.tcy1 / o);
                                    c.resolution = s;
                                    buildCodeblocks(0, c, a);
                                    n.push(c);
                                    s.subbands = [c];
                                } else {
                                    const i = 1 << (r - e + 1),
                                        o = [];
                                    c = {};
                                    c.type = 'HL';
                                    c.tbx0 = Math.ceil(t.tcx0 / i - 0.5);
                                    c.tby0 = Math.ceil(t.tcy0 / i);
                                    c.tbx1 = Math.ceil(t.tcx1 / i - 0.5);
                                    c.tby1 = Math.ceil(t.tcy1 / i);
                                    c.resolution = s;
                                    buildCodeblocks(0, c, a);
                                    n.push(c);
                                    o.push(c);
                                    c = {};
                                    c.type = 'LH';
                                    c.tbx0 = Math.ceil(t.tcx0 / i);
                                    c.tby0 = Math.ceil(t.tcy0 / i - 0.5);
                                    c.tbx1 = Math.ceil(t.tcx1 / i);
                                    c.tby1 = Math.ceil(t.tcy1 / i - 0.5);
                                    c.resolution = s;
                                    buildCodeblocks(0, c, a);
                                    n.push(c);
                                    o.push(c);
                                    c = {};
                                    c.type = 'HH';
                                    c.tbx0 = Math.ceil(t.tcx0 / i - 0.5);
                                    c.tby0 = Math.ceil(t.tcy0 / i - 0.5);
                                    c.tbx1 = Math.ceil(t.tcx1 / i - 0.5);
                                    c.tby1 = Math.ceil(t.tcy1 / i - 0.5);
                                    c.resolution = s;
                                    buildCodeblocks(0, c, a);
                                    n.push(c);
                                    o.push(c);
                                    s.subbands = o;
                                }
                            }
                            t.resolutions = i;
                            t.subbands = n;
                        }
                        const n = a.codingStyleDefaultParameters.progressionOrder;
                        switch (n) {
                            case 0:
                                a.packetsIterator = new LayerResolutionComponentPositionIterator(e);
                                break;
                            case 1:
                                a.packetsIterator = new ResolutionLayerComponentPositionIterator(e);
                                break;
                            case 2:
                                a.packetsIterator = new ResolutionPositionComponentLayerIterator(e);
                                break;
                            case 3:
                                a.packetsIterator = new PositionComponentResolutionLayerIterator(e);
                                break;
                            case 4:
                                a.packetsIterator = new ComponentPositionResolutionLayerIterator(e);
                                break;
                            default:
                                throw new JpxError(`Unsupported progression order ${n}`);
                        }
                    }
                    function parseTilePackets(e, t, r, a) {
                        let n,
                            s = 0,
                            o = 0,
                            c = !1;
                        function readBits(e) {
                            for (; o < e; ) {
                                const e = t[r + s];
                                s++;
                                if (c) {
                                    n = (n << 7) | e;
                                    o += 7;
                                    c = !1;
                                } else {
                                    n = (n << 8) | e;
                                    o += 8;
                                }
                                255 === e && (c = !0);
                            }
                            o -= e;
                            return (n >>> o) & ((1 << e) - 1);
                        }
                        function skipMarkerIfEqual(e) {
                            if (255 === t[r + s - 1] && t[r + s] === e) {
                                skipBytes(1);
                                return !0;
                            }
                            if (255 === t[r + s] && t[r + s + 1] === e) {
                                skipBytes(2);
                                return !0;
                            }
                            return !1;
                        }
                        function skipBytes(e) {
                            s += e;
                        }
                        function alignToByte() {
                            o = 0;
                            if (c) {
                                s++;
                                c = !1;
                            }
                        }
                        function readCodingpasses() {
                            if (0 === readBits(1)) return 1;
                            if (0 === readBits(1)) return 2;
                            let e = readBits(2);
                            if (e < 3) return e + 3;
                            e = readBits(5);
                            if (e < 31) return e + 6;
                            e = readBits(7);
                            return e + 37;
                        }
                        const l = e.currentTile.index,
                            h = e.tiles[l],
                            u = e.COD.sopMarkerUsed,
                            d = e.COD.ephMarkerUsed,
                            f = h.packetsIterator;
                        for (; s < a; ) {
                            alignToByte();
                            u && skipMarkerIfEqual(145) && skipBytes(4);
                            const e = f.nextPacket();
                            if (!readBits(1)) continue;
                            const a = e.layerNumber,
                                n = [];
                            let o;
                            for (let t = 0, r = e.codeblocks.length; t < r; t++) {
                                o = e.codeblocks[t];
                                let r = o.precinct;
                                const s = o.cbx - r.cbxMin,
                                    c = o.cby - r.cbyMin;
                                let l,
                                    h,
                                    u = !1,
                                    d = !1;
                                if (void 0 !== o.included) u = !!readBits(1);
                                else {
                                    r = o.precinct;
                                    let e;
                                    if (void 0 !== r.inclusionTree) e = r.inclusionTree;
                                    else {
                                        const t = r.cbxMax - r.cbxMin + 1,
                                            i = r.cbyMax - r.cbyMin + 1;
                                        e = new InclusionTree(t, i, a);
                                        h = new TagTree(t, i);
                                        r.inclusionTree = e;
                                        r.zeroBitPlanesTree = h;
                                    }
                                    if (e.reset(s, c, a))
                                        for (;;) {
                                            if (!readBits(1)) {
                                                e.incrementValue(a);
                                                break;
                                            }
                                            l = !e.nextLevel();
                                            if (l) {
                                                o.included = !0;
                                                u = d = !0;
                                                break;
                                            }
                                        }
                                }
                                if (!u) continue;
                                if (d) {
                                    h = r.zeroBitPlanesTree;
                                    h.reset(s, c);
                                    for (;;)
                                        if (readBits(1)) {
                                            l = !h.nextLevel();
                                            if (l) break;
                                        } else h.incrementValue();
                                    o.zeroBitPlanes = h.value;
                                }
                                const f = readCodingpasses();
                                for (; readBits(1); ) o.Lblock++;
                                const g = (0, i.log2)(f),
                                    p = readBits((f < 1 << g ? g - 1 : g) + o.Lblock);
                                n.push({ codeblock: o, codingpasses: f, dataLength: p });
                            }
                            alignToByte();
                            d && skipMarkerIfEqual(146);
                            for (; n.length > 0; ) {
                                const e = n.shift();
                                o = e.codeblock;
                                void 0 === o.data && (o.data = []);
                                o.data.push({
                                    data: t,
                                    start: r + s,
                                    end: r + s + e.dataLength,
                                    codingpasses: e.codingpasses,
                                });
                                s += e.dataLength;
                            }
                        }
                        return s;
                    }
                    function copyCoefficients(e, t, r, a, i, s, c, l) {
                        const h = a.tbx0,
                            u = a.tby0,
                            d = a.tbx1 - a.tbx0,
                            f = a.codeblocks,
                            g = 'H' === a.type.charAt(0) ? 1 : 0,
                            p = 'H' === a.type.charAt(1) ? t : 0;
                        for (let r = 0, m = f.length; r < m; ++r) {
                            const m = f[r],
                                b = m.tbx1_ - m.tbx0_,
                                y = m.tby1_ - m.tby0_;
                            if (0 === b || 0 === y) continue;
                            if (void 0 === m.data) continue;
                            const w = new o(b, y, m.subbandType, m.zeroBitPlanes, s);
                            let S = 2;
                            const x = m.data;
                            let k,
                                C,
                                v,
                                O = 0,
                                F = 0;
                            for (k = 0, C = x.length; k < C; k++) {
                                v = x[k];
                                O += v.end - v.start;
                                F += v.codingpasses;
                            }
                            const T = new Uint8Array(O);
                            let E = 0;
                            for (k = 0, C = x.length; k < C; k++) {
                                v = x[k];
                                const e = v.data.subarray(v.start, v.end);
                                T.set(e, E);
                                E += e.length;
                            }
                            const M = new n.ArithmeticDecoder(T, 0, O);
                            w.setDecoder(M);
                            for (k = 0; k < F; k++) {
                                switch (S) {
                                    case 0:
                                        w.runSignificancePropagationPass();
                                        break;
                                    case 1:
                                        w.runMagnitudeRefinementPass();
                                        break;
                                    case 2:
                                        w.runCleanupPass();
                                        l && w.checkSegmentationSymbol();
                                }
                                S = (S + 1) % 3;
                            }
                            let D = m.tbx0_ - h + (m.tby0_ - u) * d;
                            const N = w.coefficentsSign,
                                L = w.coefficentsMagnitude,
                                R = w.bitsDecoded,
                                j = c ? 0 : 0.5;
                            let _, U, $;
                            E = 0;
                            const X = 'LL' !== a.type;
                            for (k = 0; k < y; k++) {
                                const r = 2 * ((D / d) | 0) * (t - d) + g + p;
                                for (_ = 0; _ < b; _++) {
                                    U = L[E];
                                    if (0 !== U) {
                                        U = (U + j) * i;
                                        0 !== N[E] && (U = -U);
                                        $ = R[E];
                                        const t = X ? r + (D << 1) : D;
                                        e[t] = c && $ >= s ? U : U * (1 << (s - $));
                                    }
                                    D++;
                                    E++;
                                }
                                D += d - b;
                            }
                        }
                    }
                    function transformTile(e, t, r) {
                        const a = t.components[r],
                            i = a.codingStyleParameters,
                            n = a.quantizationParameters,
                            o = i.decompositionLevelsCount,
                            c = n.SPqcds,
                            l = n.scalarExpounded,
                            h = n.guardBits,
                            u = i.segmentationSymbolUsed,
                            d = e.components[r].precision,
                            f = i.reversibleTransformation,
                            g = f ? new ReversibleTransform() : new IrreversibleTransform(),
                            p = [];
                        let m = 0;
                        for (let e = 0; e <= o; e++) {
                            const t = a.resolutions[e],
                                r = t.trx1 - t.trx0,
                                i = t.try1 - t.try0,
                                n = new Float32Array(r * i);
                            for (let a = 0, i = t.subbands.length; a < i; a++) {
                                let i, o;
                                if (l) {
                                    i = c[m].mu;
                                    o = c[m].epsilon;
                                    m++;
                                } else {
                                    i = c[0].mu;
                                    o = c[0].epsilon + (e > 0 ? 1 - e : 0);
                                }
                                const g = t.subbands[a],
                                    p = s[g.type];
                                copyCoefficients(
                                    n,
                                    r,
                                    0,
                                    g,
                                    f ? 1 : 2 ** (d + p - o) * (1 + i / 2048),
                                    h + o - 1,
                                    f,
                                    u
                                );
                            }
                            p.push({ width: r, height: i, items: n });
                        }
                        const b = g.calculate(p, a.tcx0, a.tcy0);
                        return { left: a.tcx0, top: a.tcy0, width: b.width, height: b.height, items: b.items };
                    }
                    function initializeTile(e, t) {
                        const r = e.SIZ.Csiz,
                            a = e.tiles[t];
                        for (let t = 0; t < r; t++) {
                            const r = a.components[t],
                                i = void 0 !== e.currentTile.QCC[t] ? e.currentTile.QCC[t] : e.currentTile.QCD;
                            r.quantizationParameters = i;
                            const n = void 0 !== e.currentTile.COC[t] ? e.currentTile.COC[t] : e.currentTile.COD;
                            r.codingStyleParameters = n;
                        }
                        a.codingStyleDefaultParameters = e.currentTile.COD;
                    }
                    class TagTree {
                        constructor(e, t) {
                            const r = (0, i.log2)(Math.max(e, t)) + 1;
                            this.levels = [];
                            for (let a = 0; a < r; a++) {
                                const r = { width: e, height: t, items: [] };
                                this.levels.push(r);
                                e = Math.ceil(e / 2);
                                t = Math.ceil(t / 2);
                            }
                        }
                        reset(e, t) {
                            let r,
                                a = 0,
                                i = 0;
                            for (; a < this.levels.length; ) {
                                r = this.levels[a];
                                const n = e + t * r.width;
                                if (void 0 !== r.items[n]) {
                                    i = r.items[n];
                                    break;
                                }
                                r.index = n;
                                e >>= 1;
                                t >>= 1;
                                a++;
                            }
                            a--;
                            r = this.levels[a];
                            r.items[r.index] = i;
                            this.currentLevel = a;
                            delete this.value;
                        }
                        incrementValue() {
                            const e = this.levels[this.currentLevel];
                            e.items[e.index]++;
                        }
                        nextLevel() {
                            let e = this.currentLevel,
                                t = this.levels[e];
                            const r = t.items[t.index];
                            e--;
                            if (e < 0) {
                                this.value = r;
                                return !1;
                            }
                            this.currentLevel = e;
                            t = this.levels[e];
                            t.items[t.index] = r;
                            return !0;
                        }
                    }
                    class InclusionTree {
                        constructor(e, t, r) {
                            const a = (0, i.log2)(Math.max(e, t)) + 1;
                            this.levels = [];
                            for (let i = 0; i < a; i++) {
                                const a = new Uint8Array(e * t);
                                for (let e = 0, t = a.length; e < t; e++) a[e] = r;
                                const i = { width: e, height: t, items: a };
                                this.levels.push(i);
                                e = Math.ceil(e / 2);
                                t = Math.ceil(t / 2);
                            }
                        }
                        reset(e, t, r) {
                            let a = 0;
                            for (; a < this.levels.length; ) {
                                const i = this.levels[a],
                                    n = e + t * i.width;
                                i.index = n;
                                const s = i.items[n];
                                if (255 === s) break;
                                if (s > r) {
                                    this.currentLevel = a;
                                    this.propagateValues();
                                    return !1;
                                }
                                e >>= 1;
                                t >>= 1;
                                a++;
                            }
                            this.currentLevel = a - 1;
                            return !0;
                        }
                        incrementValue(e) {
                            const t = this.levels[this.currentLevel];
                            t.items[t.index] = e + 1;
                            this.propagateValues();
                        }
                        propagateValues() {
                            let e = this.currentLevel,
                                t = this.levels[e];
                            const r = t.items[t.index];
                            for (; --e >= 0; ) {
                                t = this.levels[e];
                                t.items[t.index] = r;
                            }
                        }
                        nextLevel() {
                            let e = this.currentLevel,
                                t = this.levels[e];
                            const r = t.items[t.index];
                            t.items[t.index] = 255;
                            e--;
                            if (e < 0) return !1;
                            this.currentLevel = e;
                            t = this.levels[e];
                            t.items[t.index] = r;
                            return !0;
                        }
                    }
                    const o = (function BitModelClosure() {
                        const e = 17,
                            t = new Uint8Array([
                                0, 5, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 1, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0,
                                0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7,
                                8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8,
                            ]),
                            r = new Uint8Array([
                                0, 3, 4, 0, 5, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 1, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0,
                                0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8,
                                8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8,
                            ]),
                            a = new Uint8Array([
                                0, 1, 2, 0, 1, 2, 2, 0, 2, 2, 2, 0, 0, 0, 0, 0, 3, 4, 5, 0, 4, 5, 5, 0, 5, 5, 5, 0, 0,
                                0, 0, 0, 6, 7, 7, 0, 7, 7, 7, 0, 7, 7, 7, 0, 0, 0, 0, 0, 8, 8, 8, 0, 8, 8, 8, 0, 8, 8,
                                8, 0, 0, 0, 0, 0, 8, 8, 8, 0, 8, 8, 8, 0, 8, 8, 8,
                            ]);
                        return class BitModel {
                            constructor(e, i, n, s, o) {
                                this.width = e;
                                this.height = i;
                                let c;
                                c = 'HH' === n ? a : 'HL' === n ? r : t;
                                this.contextLabelTable = c;
                                const l = e * i;
                                this.neighborsSignificance = new Uint8Array(l);
                                this.coefficentsSign = new Uint8Array(l);
                                let h;
                                h = o > 14 ? new Uint32Array(l) : o > 6 ? new Uint16Array(l) : new Uint8Array(l);
                                this.coefficentsMagnitude = h;
                                this.processingFlags = new Uint8Array(l);
                                const u = new Uint8Array(l);
                                if (0 !== s) for (let e = 0; e < l; e++) u[e] = s;
                                this.bitsDecoded = u;
                                this.reset();
                            }
                            setDecoder(e) {
                                this.decoder = e;
                            }
                            reset() {
                                this.contexts = new Int8Array(19);
                                this.contexts[0] = 8;
                                this.contexts[17] = 92;
                                this.contexts[18] = 6;
                            }
                            setNeighborsSignificance(e, t, r) {
                                const a = this.neighborsSignificance,
                                    i = this.width,
                                    n = this.height,
                                    s = t > 0,
                                    o = t + 1 < i;
                                let c;
                                if (e > 0) {
                                    c = r - i;
                                    s && (a[c - 1] += 16);
                                    o && (a[c + 1] += 16);
                                    a[c] += 4;
                                }
                                if (e + 1 < n) {
                                    c = r + i;
                                    s && (a[c - 1] += 16);
                                    o && (a[c + 1] += 16);
                                    a[c] += 4;
                                }
                                s && (a[r - 1] += 1);
                                o && (a[r + 1] += 1);
                                a[r] |= 128;
                            }
                            runSignificancePropagationPass() {
                                const e = this.decoder,
                                    t = this.width,
                                    r = this.height,
                                    a = this.coefficentsMagnitude,
                                    i = this.coefficentsSign,
                                    n = this.neighborsSignificance,
                                    s = this.processingFlags,
                                    o = this.contexts,
                                    c = this.contextLabelTable,
                                    l = this.bitsDecoded;
                                for (let h = 0; h < r; h += 4)
                                    for (let u = 0; u < t; u++) {
                                        let d = h * t + u;
                                        for (let f = 0; f < 4; f++, d += t) {
                                            const t = h + f;
                                            if (t >= r) break;
                                            s[d] &= -2;
                                            if (a[d] || !n[d]) continue;
                                            const g = c[n[d]];
                                            if (e.readBit(o, g)) {
                                                const e = this.decodeSignBit(t, u, d);
                                                i[d] = e;
                                                a[d] = 1;
                                                this.setNeighborsSignificance(t, u, d);
                                                s[d] |= 2;
                                            }
                                            l[d]++;
                                            s[d] |= 1;
                                        }
                                    }
                            }
                            decodeSignBit(e, t, r) {
                                const a = this.width,
                                    i = this.height,
                                    n = this.coefficentsMagnitude,
                                    s = this.coefficentsSign;
                                let o, c, l, h, u, d;
                                h = t > 0 && 0 !== n[r - 1];
                                if (t + 1 < a && 0 !== n[r + 1]) {
                                    l = s[r + 1];
                                    if (h) {
                                        c = s[r - 1];
                                        o = 1 - l - c;
                                    } else o = 1 - l - l;
                                } else if (h) {
                                    c = s[r - 1];
                                    o = 1 - c - c;
                                } else o = 0;
                                const f = 3 * o;
                                h = e > 0 && 0 !== n[r - a];
                                if (e + 1 < i && 0 !== n[r + a]) {
                                    l = s[r + a];
                                    if (h) {
                                        c = s[r - a];
                                        o = 1 - l - c + f;
                                    } else o = 1 - l - l + f;
                                } else if (h) {
                                    c = s[r - a];
                                    o = 1 - c - c + f;
                                } else o = f;
                                if (o >= 0) {
                                    u = 9 + o;
                                    d = this.decoder.readBit(this.contexts, u);
                                } else {
                                    u = 9 - o;
                                    d = 1 ^ this.decoder.readBit(this.contexts, u);
                                }
                                return d;
                            }
                            runMagnitudeRefinementPass() {
                                const e = this.decoder,
                                    t = this.width,
                                    r = this.height,
                                    a = this.coefficentsMagnitude,
                                    i = this.neighborsSignificance,
                                    n = this.contexts,
                                    s = this.bitsDecoded,
                                    o = this.processingFlags,
                                    c = t * r,
                                    l = 4 * t;
                                for (let r, h = 0; h < c; h = r) {
                                    r = Math.min(c, h + l);
                                    for (let c = 0; c < t; c++)
                                        for (let l = h + c; l < r; l += t) {
                                            if (!a[l] || 0 != (1 & o[l])) continue;
                                            let t = 16;
                                            if (0 != (2 & o[l])) {
                                                o[l] ^= 2;
                                                t = 0 === (127 & i[l]) ? 15 : 14;
                                            }
                                            const r = e.readBit(n, t);
                                            a[l] = (a[l] << 1) | r;
                                            s[l]++;
                                            o[l] |= 1;
                                        }
                                }
                            }
                            runCleanupPass() {
                                const t = this.decoder,
                                    r = this.width,
                                    a = this.height,
                                    i = this.neighborsSignificance,
                                    n = this.coefficentsMagnitude,
                                    s = this.coefficentsSign,
                                    o = this.contexts,
                                    c = this.contextLabelTable,
                                    l = this.bitsDecoded,
                                    h = this.processingFlags,
                                    u = r,
                                    d = 2 * r,
                                    f = 3 * r;
                                let g;
                                for (let p = 0; p < a; p = g) {
                                    g = Math.min(p + 4, a);
                                    const m = p * r,
                                        b = p + 3 < a;
                                    for (let a = 0; a < r; a++) {
                                        const y = m + a;
                                        let w,
                                            S = 0,
                                            x = y,
                                            k = p;
                                        if (
                                            b &&
                                            0 === h[y] &&
                                            0 === h[y + u] &&
                                            0 === h[y + d] &&
                                            0 === h[y + f] &&
                                            0 === i[y] &&
                                            0 === i[y + u] &&
                                            0 === i[y + d] &&
                                            0 === i[y + f]
                                        ) {
                                            if (!t.readBit(o, 18)) {
                                                l[y]++;
                                                l[y + u]++;
                                                l[y + d]++;
                                                l[y + f]++;
                                                continue;
                                            }
                                            S = (t.readBit(o, e) << 1) | t.readBit(o, e);
                                            if (0 !== S) {
                                                k = p + S;
                                                x += S * r;
                                            }
                                            w = this.decodeSignBit(k, a, x);
                                            s[x] = w;
                                            n[x] = 1;
                                            this.setNeighborsSignificance(k, a, x);
                                            h[x] |= 2;
                                            x = y;
                                            for (let e = p; e <= k; e++, x += r) l[x]++;
                                            S++;
                                        }
                                        for (k = p + S; k < g; k++, x += r) {
                                            if (n[x] || 0 != (1 & h[x])) continue;
                                            const e = c[i[x]];
                                            if (1 === t.readBit(o, e)) {
                                                w = this.decodeSignBit(k, a, x);
                                                s[x] = w;
                                                n[x] = 1;
                                                this.setNeighborsSignificance(k, a, x);
                                                h[x] |= 2;
                                            }
                                            l[x]++;
                                        }
                                    }
                                }
                            }
                            checkSegmentationSymbol() {
                                const t = this.decoder,
                                    r = this.contexts;
                                if (
                                    10 !==
                                    ((t.readBit(r, e) << 3) |
                                        (t.readBit(r, e) << 2) |
                                        (t.readBit(r, e) << 1) |
                                        t.readBit(r, e))
                                )
                                    throw new JpxError('Invalid segmentation symbol');
                            }
                        };
                    })();
                    class Transform {
                        constructor() {
                            this.constructor === Transform && (0, a.unreachable)('Cannot initialize Transform.');
                        }
                        calculate(e, t, r) {
                            let a = e[0];
                            for (let i = 1, n = e.length; i < n; i++) a = this.iterate(a, e[i], t, r);
                            return a;
                        }
                        extend(e, t, r) {
                            let a = t - 1,
                                i = t + 1,
                                n = t + r - 2,
                                s = t + r;
                            e[a--] = e[i++];
                            e[s++] = e[n--];
                            e[a--] = e[i++];
                            e[s++] = e[n--];
                            e[a--] = e[i++];
                            e[s++] = e[n--];
                            e[a] = e[i];
                            e[s] = e[n];
                        }
                        filter(e, t, r) {
                            (0, a.unreachable)('Abstract method `filter` called');
                        }
                        iterate(e, t, r, a) {
                            const i = e.width,
                                n = e.height;
                            let s = e.items;
                            const o = t.width,
                                c = t.height,
                                l = t.items;
                            let h, u, d, f, g, p;
                            for (d = 0, h = 0; h < n; h++) {
                                f = 2 * h * o;
                                for (u = 0; u < i; u++, d++, f += 2) l[f] = s[d];
                            }
                            s = e.items = null;
                            const m = new Float32Array(o + 8);
                            if (1 === o) {
                                if (0 != (1 & r)) for (p = 0, d = 0; p < c; p++, d += o) l[d] *= 0.5;
                            } else
                                for (p = 0, d = 0; p < c; p++, d += o) {
                                    m.set(l.subarray(d, d + o), 4);
                                    this.extend(m, 4, o);
                                    this.filter(m, 4, o);
                                    l.set(m.subarray(4, 4 + o), d);
                                }
                            let b = 16;
                            const y = [];
                            for (h = 0; h < b; h++) y.push(new Float32Array(c + 8));
                            let w,
                                S = 0;
                            e = 4 + c;
                            if (1 === c) {
                                if (0 != (1 & a)) for (g = 0; g < o; g++) l[g] *= 0.5;
                            } else
                                for (g = 0; g < o; g++) {
                                    if (0 === S) {
                                        b = Math.min(o - g, b);
                                        for (d = g, f = 4; f < e; d += o, f++)
                                            for (w = 0; w < b; w++) y[w][f] = l[d + w];
                                        S = b;
                                    }
                                    S--;
                                    const t = y[S];
                                    this.extend(t, 4, c);
                                    this.filter(t, 4, c);
                                    if (0 === S) {
                                        d = g - b + 1;
                                        for (f = 4; f < e; d += o, f++) for (w = 0; w < b; w++) l[d + w] = y[w][f];
                                    }
                                }
                            return { width: o, height: c, items: l };
                        }
                    }
                    class IrreversibleTransform extends Transform {
                        filter(e, t, r) {
                            const a = r >> 1;
                            let i, n, s, o;
                            const c = -1.586134342059924,
                                l = -0.052980118572961,
                                h = 0.882911075530934,
                                u = 0.443506852043971,
                                d = 1.230174104914001;
                            i = (t |= 0) - 3;
                            for (n = a + 4; n--; i += 2) e[i] *= 0.8128930661159609;
                            i = t - 2;
                            s = u * e[i - 1];
                            for (n = a + 3; n--; i += 2) {
                                o = u * e[i + 1];
                                e[i] = d * e[i] - s - o;
                                if (!n--) break;
                                i += 2;
                                s = u * e[i + 1];
                                e[i] = d * e[i] - s - o;
                            }
                            i = t - 1;
                            s = h * e[i - 1];
                            for (n = a + 2; n--; i += 2) {
                                o = h * e[i + 1];
                                e[i] -= s + o;
                                if (!n--) break;
                                i += 2;
                                s = h * e[i + 1];
                                e[i] -= s + o;
                            }
                            i = t;
                            s = l * e[i - 1];
                            for (n = a + 1; n--; i += 2) {
                                o = l * e[i + 1];
                                e[i] -= s + o;
                                if (!n--) break;
                                i += 2;
                                s = l * e[i + 1];
                                e[i] -= s + o;
                            }
                            if (0 !== a) {
                                i = t + 1;
                                s = c * e[i - 1];
                                for (n = a; n--; i += 2) {
                                    o = c * e[i + 1];
                                    e[i] -= s + o;
                                    if (!n--) break;
                                    i += 2;
                                    s = c * e[i + 1];
                                    e[i] -= s + o;
                                }
                            }
                        }
                    }
                    class ReversibleTransform extends Transform {
                        filter(e, t, r) {
                            const a = r >> 1;
                            let i, n;
                            for (i = t |= 0, n = a + 1; n--; i += 2) e[i] -= (e[i - 1] + e[i + 1] + 2) >> 2;
                            for (i = t + 1, n = a; n--; i += 2) e[i] += (e[i - 1] + e[i + 1]) >> 1;
                        }
                    }
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.LZWStream = void 0;
                    var a = r(19);
                    class LZWStream extends a.DecodeStream {
                        constructor(e, t, r) {
                            super(t);
                            this.str = e;
                            this.dict = e.dict;
                            this.cachedData = 0;
                            this.bitsCached = 0;
                            const a = 4096,
                                i = {
                                    earlyChange: r,
                                    codeLength: 9,
                                    nextCode: 258,
                                    dictionaryValues: new Uint8Array(a),
                                    dictionaryLengths: new Uint16Array(a),
                                    dictionaryPrevCodes: new Uint16Array(a),
                                    currentSequence: new Uint8Array(a),
                                    currentSequenceLength: 0,
                                };
                            for (let e = 0; e < 256; ++e) {
                                i.dictionaryValues[e] = e;
                                i.dictionaryLengths[e] = 1;
                            }
                            this.lzwState = i;
                        }
                        readBits(e) {
                            let t = this.bitsCached,
                                r = this.cachedData;
                            for (; t < e; ) {
                                const e = this.str.getByte();
                                if (-1 === e) {
                                    this.eof = !0;
                                    return null;
                                }
                                r = (r << 8) | e;
                                t += 8;
                            }
                            this.bitsCached = t -= e;
                            this.cachedData = r;
                            this.lastCode = null;
                            return (r >>> t) & ((1 << e) - 1);
                        }
                        readBlock() {
                            let e,
                                t,
                                r,
                                a = 1024;
                            const i = this.lzwState;
                            if (!i) return;
                            const n = i.earlyChange;
                            let s = i.nextCode;
                            const o = i.dictionaryValues,
                                c = i.dictionaryLengths,
                                l = i.dictionaryPrevCodes;
                            let h = i.codeLength,
                                u = i.prevCode;
                            const d = i.currentSequence;
                            let f = i.currentSequenceLength,
                                g = 0,
                                p = this.bufferLength,
                                m = this.ensureBuffer(this.bufferLength + a);
                            for (e = 0; e < 512; e++) {
                                const e = this.readBits(h),
                                    i = f > 0;
                                if (e < 256) {
                                    d[0] = e;
                                    f = 1;
                                } else {
                                    if (!(e >= 258)) {
                                        if (256 === e) {
                                            h = 9;
                                            s = 258;
                                            f = 0;
                                            continue;
                                        }
                                        this.eof = !0;
                                        delete this.lzwState;
                                        break;
                                    }
                                    if (e < s) {
                                        f = c[e];
                                        for (t = f - 1, r = e; t >= 0; t--) {
                                            d[t] = o[r];
                                            r = l[r];
                                        }
                                    } else d[f++] = d[0];
                                }
                                if (i) {
                                    l[s] = u;
                                    c[s] = c[u] + 1;
                                    o[s] = d[0];
                                    s++;
                                    h =
                                        (s + n) & (s + n - 1)
                                            ? h
                                            : 0 | Math.min(Math.log(s + n) / 0.6931471805599453 + 1, 12);
                                }
                                u = e;
                                g += f;
                                if (a < g) {
                                    do {
                                        a += 512;
                                    } while (a < g);
                                    m = this.ensureBuffer(this.bufferLength + a);
                                }
                                for (t = 0; t < f; t++) m[p++] = d[t];
                            }
                            i.nextCode = s;
                            i.codeLength = h;
                            i.prevCode = u;
                            i.currentSequenceLength = f;
                            this.bufferLength = p;
                        }
                    }
                    t.LZWStream = LZWStream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.PredictorStream = void 0;
                    var a = r(19),
                        i = r(2),
                        n = r(5);
                    class PredictorStream extends a.DecodeStream {
                        constructor(e, t, r) {
                            super(t);
                            if (!(0, n.isDict)(r)) return e;
                            const a = (this.predictor = r.get('Predictor') || 1);
                            if (a <= 1) return e;
                            if (2 !== a && (a < 10 || a > 15)) throw new i.FormatError(`Unsupported predictor: ${a}`);
                            this.readBlock = 2 === a ? this.readBlockTiff : this.readBlockPng;
                            this.str = e;
                            this.dict = e.dict;
                            const s = (this.colors = r.get('Colors') || 1),
                                o = (this.bits = r.get('BitsPerComponent') || 8),
                                c = (this.columns = r.get('Columns') || 1);
                            this.pixBytes = (s * o + 7) >> 3;
                            this.rowBytes = (c * s * o + 7) >> 3;
                            return this;
                        }
                        readBlockTiff() {
                            const e = this.rowBytes,
                                t = this.bufferLength,
                                r = this.ensureBuffer(t + e),
                                a = this.bits,
                                i = this.colors,
                                n = this.str.getBytes(e);
                            this.eof = !n.length;
                            if (this.eof) return;
                            let s,
                                o = 0,
                                c = 0,
                                l = 0,
                                h = 0,
                                u = t;
                            if (1 === a && 1 === i)
                                for (s = 0; s < e; ++s) {
                                    let e = n[s] ^ o;
                                    e ^= e >> 1;
                                    e ^= e >> 2;
                                    e ^= e >> 4;
                                    o = (1 & e) << 7;
                                    r[u++] = e;
                                }
                            else if (8 === a) {
                                for (s = 0; s < i; ++s) r[u++] = n[s];
                                for (; s < e; ++s) {
                                    r[u] = r[u - i] + n[s];
                                    u++;
                                }
                            } else if (16 === a) {
                                const t = 2 * i;
                                for (s = 0; s < t; ++s) r[u++] = n[s];
                                for (; s < e; s += 2) {
                                    const e =
                                        ((255 & n[s]) << 8) +
                                        (255 & n[s + 1]) +
                                        ((255 & r[u - t]) << 8) +
                                        (255 & r[u - t + 1]);
                                    r[u++] = (e >> 8) & 255;
                                    r[u++] = 255 & e;
                                }
                            } else {
                                const e = new Uint8Array(i + 1),
                                    u = (1 << a) - 1;
                                let d = 0,
                                    f = t;
                                const g = this.columns;
                                for (s = 0; s < g; ++s)
                                    for (let t = 0; t < i; ++t) {
                                        if (l < a) {
                                            o = (o << 8) | (255 & n[d++]);
                                            l += 8;
                                        }
                                        e[t] = (e[t] + (o >> (l - a))) & u;
                                        l -= a;
                                        c = (c << a) | e[t];
                                        h += a;
                                        if (h >= 8) {
                                            r[f++] = (c >> (h - 8)) & 255;
                                            h -= 8;
                                        }
                                    }
                                h > 0 && (r[f++] = (c << (8 - h)) + (o & ((1 << (8 - h)) - 1)));
                            }
                            this.bufferLength += e;
                        }
                        readBlockPng() {
                            const e = this.rowBytes,
                                t = this.pixBytes,
                                r = this.str.getByte(),
                                a = this.str.getBytes(e);
                            this.eof = !a.length;
                            if (this.eof) return;
                            const n = this.bufferLength,
                                s = this.ensureBuffer(n + e);
                            let o = s.subarray(n - e, n);
                            0 === o.length && (o = new Uint8Array(e));
                            let c,
                                l,
                                h,
                                u = n;
                            switch (r) {
                                case 0:
                                    for (c = 0; c < e; ++c) s[u++] = a[c];
                                    break;
                                case 1:
                                    for (c = 0; c < t; ++c) s[u++] = a[c];
                                    for (; c < e; ++c) {
                                        s[u] = (s[u - t] + a[c]) & 255;
                                        u++;
                                    }
                                    break;
                                case 2:
                                    for (c = 0; c < e; ++c) s[u++] = (o[c] + a[c]) & 255;
                                    break;
                                case 3:
                                    for (c = 0; c < t; ++c) s[u++] = (o[c] >> 1) + a[c];
                                    for (; c < e; ++c) {
                                        s[u] = (((o[c] + s[u - t]) >> 1) + a[c]) & 255;
                                        u++;
                                    }
                                    break;
                                case 4:
                                    for (c = 0; c < t; ++c) {
                                        l = o[c];
                                        h = a[c];
                                        s[u++] = l + h;
                                    }
                                    for (; c < e; ++c) {
                                        l = o[c];
                                        const e = o[c - t],
                                            r = s[u - t],
                                            i = r + l - e;
                                        let n = i - r;
                                        n < 0 && (n = -n);
                                        let d = i - l;
                                        d < 0 && (d = -d);
                                        let f = i - e;
                                        f < 0 && (f = -f);
                                        h = a[c];
                                        s[u++] = n <= d && n <= f ? r + h : d <= f ? l + h : e + h;
                                    }
                                    break;
                                default:
                                    throw new i.FormatError(`Unsupported predictor: ${r}`);
                            }
                            this.bufferLength += e;
                        }
                    }
                    t.PredictorStream = PredictorStream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.RunLengthStream = void 0;
                    var a = r(19);
                    class RunLengthStream extends a.DecodeStream {
                        constructor(e, t) {
                            super(t);
                            this.str = e;
                            this.dict = e.dict;
                        }
                        readBlock() {
                            const e = this.str.getBytes(2);
                            if (!e || e.length < 2 || 128 === e[0]) {
                                this.eof = !0;
                                return;
                            }
                            let t,
                                r = this.bufferLength,
                                a = e[0];
                            if (a < 128) {
                                t = this.ensureBuffer(r + a + 1);
                                t[r++] = e[1];
                                if (a > 0) {
                                    const e = this.str.getBytes(a);
                                    t.set(e, r);
                                    r += a;
                                }
                            } else {
                                a = 257 - a;
                                const i = e[1];
                                t = this.ensureBuffer(r + a + 1);
                                for (let e = 0; e < a; e++) t[r++] = i;
                            }
                            this.bufferLength = r;
                        }
                    }
                    t.RunLengthStream = RunLengthStream;
                },
                (e, t, r) => {
                    Object.defineProperty(t, '__esModule', { value: !0 });
                    t.Font = t.ErrorFont = void 0;
                    var a = r(2),
                        i = r(35),
                        n = r(38),
                        s = r(39),
                        o = r(37),
                        c = r(41),
                        l = r(40),
                        h = r(42),
                        u = r(43),
                        d = r(44),
                        f = r(16),
                        g = r(45),
                        p = r(9),
                        m = r(10),
                        b = r(46);
                    const y = [
                            [57344, 63743],
                            [1048576, 1114109],
                        ],
                        w = 1e3,
                        S = [
                            'ascent',
                            'bbox',
                            'black',
                            'bold',
                            'charProcOperatorList',
                            'composite',
                            'cssFontInfo',
                            'data',
                            'defaultVMetrics',
                            'defaultWidth',
                            'descent',
                            'fallbackName',
                            'fontMatrix',
                            'fontType',
                            'isMonospace',
                            'isSerifFont',
                            'isType3Font',
                            'italic',
                            'loadedName',
                            'mimetype',
                            'missingFile',
                            'name',
                            'remeasure',
                            'subtype',
                            'type',
                            'vertical',
                        ],
                        x = [
                            'cMap',
                            'defaultEncoding',
                            'differences',
                            'isSymbolicFont',
                            'seacMap',
                            'toFontChar',
                            'toUnicode',
                            'vmetrics',
                            'widths',
                        ];
                    function adjustWidths(e) {
                        if (!e.fontMatrix) return;
                        if (e.fontMatrix[0] === a.FONT_IDENTITY_MATRIX[0]) return;
                        const t = 0.001 / e.fontMatrix[0],
                            r = e.widths;
                        for (const e in r) r[e] *= t;
                        e.defaultWidth *= t;
                    }
                    class Glyph {
                        constructor(e, t, r, a, i, n, s, o) {
                            this.fontChar = e;
                            this.unicode = t;
                            this.accent = r;
                            this.width = a;
                            this.vmetric = i;
                            this.operatorListId = n;
                            this.isSpace = s;
                            this.isInFont = o;
                        }
                        matchesForCache(e, t, r, a, i, n, s, o) {
                            return (
                                this.fontChar === e &&
                                this.unicode === t &&
                                this.accent === r &&
                                this.width === a &&
                                this.vmetric === i &&
                                this.operatorListId === n &&
                                this.isSpace === s &&
                                this.isInFont === o
                            );
                        }
                    }
                    function int16(e, t) {
                        return (e << 8) + t;
                    }
                    function signedInt16(e, t) {
                        const r = (e << 8) + t;
                        return 32768 & r ? r - 65536 : r;
                    }
                    function string16(e) {
                        return String.fromCharCode((e >> 8) & 255, 255 & e);
                    }
                    function safeString16(e) {
                        e > 32767 ? (e = 32767) : e < -32768 && (e = -32768);
                        return String.fromCharCode((e >> 8) & 255, 255 & e);
                    }
                    function isTrueTypeCollectionFile(e) {
                        const t = e.peekBytes(4);
                        return 'ttcf' === (0, a.bytesToString)(t);
                    }
                    function getFontFileType(e, { type: t, subtype: r, composite: i }) {
                        let n, s;
                        if (
                            (function isTrueTypeFile(e) {
                                const t = e.peekBytes(4);
                                return 65536 === (0, p.readUint32)(t, 0) || 'true' === (0, a.bytesToString)(t);
                            })(e) ||
                            isTrueTypeCollectionFile(e)
                        )
                            n = i ? 'CIDFontType2' : 'TrueType';
                        else if (
                            (function isOpenTypeFile(e) {
                                const t = e.peekBytes(4);
                                return 'OTTO' === (0, a.bytesToString)(t);
                            })(e)
                        )
                            n = i ? 'CIDFontType2' : 'OpenType';
                        else if (
                            (function isType1File(e) {
                                const t = e.peekBytes(2);
                                return (37 === t[0] && 33 === t[1]) || (128 === t[0] && 1 === t[1]);
                            })(e)
                        )
                            n = i ? 'CIDFontType0' : 'MMType1' === t ? 'MMType1' : 'Type1';
                        else if (
                            (function isCFFFile(e) {
                                const t = e.peekBytes(4);
                                return t[0] >= 1 && t[3] >= 1 && t[3] <= 4;
                            })(e)
                        )
                            if (i) {
                                n = 'CIDFontType0';
                                s = 'CIDFontType0C';
                            } else {
                                n = 'MMType1' === t ? 'MMType1' : 'Type1';
                                s = 'Type1C';
                            }
                        else {
                            (0, a.warn)('getFontFileType: Unable to detect correct font file Type/Subtype.');
                            n = t;
                            s = r;
                        }
                        return [n, s];
                    }
                    function buildToFontChar(e, t, r) {
                        const a = [];
                        let i;
                        for (let r = 0, n = e.length; r < n; r++) {
                            i = (0, l.getUnicodeForGlyph)(e[r], t);
                            -1 !== i && (a[r] = i);
                        }
                        for (const e in r) {
                            i = (0, l.getUnicodeForGlyph)(r[e], t);
                            -1 !== i && (a[+e] = i);
                        }
                        return a;
                    }
                    function adjustMapping(e, t, r) {
                        const i = Object.create(null),
                            n = [];
                        let s = 0,
                            o = y[s][0],
                            c = y[s][1];
                        for (let l in e) {
                            l |= 0;
                            let h = e[l];
                            if (!t(h)) continue;
                            if (o > c) {
                                s++;
                                if (s >= y.length) {
                                    (0, a.warn)('Ran out of space in font private use area.');
                                    break;
                                }
                                o = y[s][0];
                                c = y[s][1];
                            }
                            const u = o++;
                            0 === h && (h = r);
                            i[u] = h;
                            n[l] = u;
                        }
                        return { toFontChar: n, charCodeToGlyphId: i, nextAvailableFontCharCode: o };
                    }
                    function createCmapTable(e, t) {
                        const r = (function getRanges(e, t) {
                                const r = [];
                                for (const a in e) e[a] >= t || r.push({ fontCharCode: 0 | a, glyphId: e[a] });
                                0 === r.length && r.push({ fontCharCode: 0, glyphId: 0 });
                                r.sort(function fontGetRangesSort(e, t) {
                                    return e.fontCharCode - t.fontCharCode;
                                });
                                const a = [],
                                    i = r.length;
                                for (let e = 0; e < i; ) {
                                    const t = r[e].fontCharCode,
                                        n = [r[e].glyphId];
                                    ++e;
                                    let s = t;
                                    for (; e < i && s + 1 === r[e].fontCharCode; ) {
                                        n.push(r[e].glyphId);
                                        ++s;
                                        ++e;
                                        if (65535 === s) break;
                                    }
                                    a.push([t, s, n]);
                                }
                                return a;
                            })(e, t),
                            i = r[r.length - 1][1] > 65535 ? 2 : 1;
                        let n,
                            s,
                            o,
                            c,
                            l = '\0\0' + string16(i) + '\0\0' + (0, a.string32)(4 + 8 * i);
                        for (n = r.length - 1; n >= 0 && !(r[n][0] <= 65535); --n);
                        const h = n + 1;
                        r[n][0] < 65535 && 65535 === r[n][1] && (r[n][1] = 65534);
                        const u = r[n][1] < 65535 ? 1 : 0,
                            d = h + u,
                            f = g.OpenTypeFileBuilder.getSearchParams(d, 2);
                        let p,
                            m,
                            b,
                            y,
                            w = '',
                            S = '',
                            x = '',
                            k = '',
                            C = '',
                            v = 0;
                        for (n = 0, s = h; n < s; n++) {
                            p = r[n];
                            m = p[0];
                            b = p[1];
                            w += string16(m);
                            S += string16(b);
                            y = p[2];
                            let e = !0;
                            for (o = 1, c = y.length; o < c; ++o)
                                if (y[o] !== y[o - 1] + 1) {
                                    e = !1;
                                    break;
                                }
                            if (e) {
                                x += string16((y[0] - m) & 65535);
                                k += string16(0);
                            } else {
                                const e = 2 * (d - n) + 2 * v;
                                v += b - m + 1;
                                x += string16(0);
                                k += string16(e);
                                for (o = 0, c = y.length; o < c; ++o) C += string16(y[o]);
                            }
                        }
                        if (u > 0) {
                            S += 'ÿÿ';
                            w += 'ÿÿ';
                            x += '\0';
                            k += '\0\0';
                        }
                        const O =
                            '\0\0' +
                            string16(2 * d) +
                            string16(f.range) +
                            string16(f.entry) +
                            string16(f.rangeShift) +
                            S +
                            '\0\0' +
                            w +
                            x +
                            k +
                            C;
                        let F = '',
                            T = '';
                        if (i > 1) {
                            l += '\0\0\n' + (0, a.string32)(4 + 8 * i + 4 + O.length);
                            F = '';
                            for (n = 0, s = r.length; n < s; n++) {
                                p = r[n];
                                m = p[0];
                                y = p[2];
                                let e = y[0];
                                for (o = 1, c = y.length; o < c; ++o)
                                    if (y[o] !== y[o - 1] + 1) {
                                        b = p[0] + o - 1;
                                        F += (0, a.string32)(m) + (0, a.string32)(b) + (0, a.string32)(e);
                                        m = b + 1;
                                        e = y[o];
                                    }
                                F += (0, a.string32)(m) + (0, a.string32)(p[1]) + (0, a.string32)(e);
                            }
                            T =
                                '\0\f\0\0' +
                                (0, a.string32)(F.length + 16) +
                                '\0\0\0\0' +
                                (0, a.string32)(F.length / 12);
                        }
                        return l + '\0' + string16(O.length + 4) + O + T + F;
                    }
                    function createOS2Table(e, t, r) {
                        r = r || { unitsPerEm: 0, yMax: 0, yMin: 0, ascent: 0, descent: 0 };
                        let i = 0,
                            n = 0,
                            s = 0,
                            o = 0,
                            c = null,
                            h = 0;
                        if (t) {
                            for (let e in t) {
                                e |= 0;
                                (c > e || !c) && (c = e);
                                h < e && (h = e);
                                const t = (0, l.getUnicodeRangeFor)(e);
                                if (t < 32) i |= 1 << t;
                                else if (t < 64) n |= 1 << (t - 32);
                                else if (t < 96) s |= 1 << (t - 64);
                                else {
                                    if (!(t < 123))
                                        throw new a.FormatError(
                                            'Unicode ranges Bits > 123 are reserved for internal usage'
                                        );
                                    o |= 1 << (t - 96);
                                }
                            }
                            h > 65535 && (h = 65535);
                        } else {
                            c = 0;
                            h = 255;
                        }
                        const u = e.bbox || [0, 0, 0, 0],
                            d = r.unitsPerEm || 1 / (e.fontMatrix || a.FONT_IDENTITY_MATRIX)[0],
                            f = e.ascentScaled ? 1 : d / w,
                            g = r.ascent || Math.round(f * (e.ascent || u[3]));
                        let p = r.descent || Math.round(f * (e.descent || u[1]));
                        p > 0 && e.descent > 0 && u[1] < 0 && (p = -p);
                        const m = r.yMax || g,
                            b = -r.yMin || -p;
                        return (
                            '\0$ô\0\0\0»\0\0\0»\0\0ß\x001\0\0\0\0' +
                            String.fromCharCode(e.fixedPitch ? 9 : 0) +
                            '\0\0\0\0\0\0' +
                            (0, a.string32)(i) +
                            (0, a.string32)(n) +
                            (0, a.string32)(s) +
                            (0, a.string32)(o) +
                            '*21*' +
                            string16(e.italicAngle ? 1 : 0) +
                            string16(c || e.firstChar) +
                            string16(h || e.lastChar) +
                            string16(g) +
                            string16(p) +
                            '\0d' +
                            string16(m) +
                            string16(b) +
                            '\0\0\0\0\0\0\0\0' +
                            string16(e.xHeight) +
                            string16(e.capHeight) +
                            string16(0) +
                            string16(c || e.firstChar) +
                            '\0'
                        );
                    }
                    function createPostTable(e) {
                        const t = Math.floor(65536 * e.italicAngle);
                        return (
                            '\0\0\0' +
                            (0, a.string32)(t) +
                            '\0\0\0\0' +
                            (0, a.string32)(e.fixedPitch) +
                            '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0'
                        );
                    }
                    function createPostscriptName(e) {
                        return e.replace(/[^\x21-\x7E]|[[\](){}<>/%]/g, '').slice(0, 63);
                    }
                    function createNameTable(e, t) {
                        t || (t = [[], []]);
                        const r = [
                                t[0][0] || 'Original licence',
                                t[0][1] || e,
                                t[0][2] || 'Unknown',
                                t[0][3] || 'uniqueID',
                                t[0][4] || e,
                                t[0][5] || 'Version 0.11',
                                t[0][6] || createPostscriptName(e),
                                t[0][7] || 'Unknown',
                                t[0][8] || 'Unknown',
                                t[0][9] || 'Unknown',
                            ],
                            a = [];
                        let i, n, s, o, c;
                        for (i = 0, n = r.length; i < n; i++) {
                            c = t[1][i] || r[i];
                            const e = [];
                            for (s = 0, o = c.length; s < o; s++) e.push(string16(c.charCodeAt(s)));
                            a.push(e.join(''));
                        }
                        const l = [r, a],
                            h = ['\0', '\0'],
                            u = ['\0\0', '\0'],
                            d = ['\0\0', '\t'],
                            f = r.length * h.length;
                        let g = '\0\0' + string16(f) + string16(12 * f + 6),
                            p = 0;
                        for (i = 0, n = h.length; i < n; i++) {
                            const e = l[i];
                            for (s = 0, o = e.length; s < o; s++) {
                                c = e[s];
                                g += h[i] + u[i] + d[i] + string16(s) + string16(c.length) + string16(p);
                                p += c.length;
                            }
                        }
                        g += r.join('') + a.join('');
                        return g;
                    }
                    t.Font = class Font {
                        constructor(e, t, r) {
                            this.name = e;
                            this.mimetype = null;
                            this.disableFontFace = !1;
                            this.loadedName = r.loadedName;
                            this.isType3Font = r.isType3Font;
                            this.missingFile = !1;
                            this.cssFontInfo = r.cssFontInfo;
                            this._charsCache = Object.create(null);
                            this._glyphCache = Object.create(null);
                            this.isSerifFont = !!(r.flags & n.FontFlags.Serif);
                            this.isSymbolicFont = !!(r.flags & n.FontFlags.Symbolic);
                            this.isMonospace = !!(r.flags & n.FontFlags.FixedPitch);
                            let i = r.type,
                                s = r.subtype;
                            this.type = i;
                            this.subtype = s;
                            let o,
                                c = 'sans-serif';
                            this.isMonospace ? (c = 'monospace') : this.isSerifFont && (c = 'serif');
                            this.fallbackName = c;
                            this.differences = r.differences;
                            this.widths = r.widths;
                            this.defaultWidth = r.defaultWidth;
                            this.composite = r.composite;
                            this.cMap = r.cMap;
                            this.capHeight = r.capHeight / w;
                            this.ascent = r.ascent / w;
                            this.descent = r.descent / w;
                            this.fontMatrix = r.fontMatrix;
                            this.bbox = r.bbox;
                            this.defaultEncoding = r.defaultEncoding;
                            this.toUnicode = r.toUnicode;
                            this.fallbackToUnicode = r.fallbackToUnicode || new h.ToUnicodeMap();
                            this.toFontChar = [];
                            if ('Type3' !== r.type) {
                                this.cidEncoding = r.cidEncoding;
                                this.vertical = !!r.vertical;
                                if (this.vertical) {
                                    this.vmetrics = r.vmetrics;
                                    this.defaultVMetrics = r.defaultVMetrics;
                                }
                                if (t && !t.isEmpty) {
                                    [i, s] = getFontFileType(t, r);
                                    (i === this.type && s === this.subtype) ||
                                        (0, a.info)(
                                            `Inconsistent font file Type/SubType, expected: ${this.type}/${this.subtype} but found: ${i}/${s}.`
                                        );
                                    try {
                                        switch (i) {
                                            case 'MMType1':
                                                (0, a.info)('MMType1 font (' + e + '), falling back to Type1.');
                                            case 'Type1':
                                            case 'CIDFontType0':
                                                this.mimetype = 'font/opentype';
                                                const n =
                                                    'Type1C' === s || 'CIDFontType0C' === s
                                                        ? new u.CFFFont(t, r)
                                                        : new b.Type1Font(e, t, r);
                                                adjustWidths(r);
                                                o = this.convert(e, n, r);
                                                break;
                                            case 'OpenType':
                                            case 'TrueType':
                                            case 'CIDFontType2':
                                                this.mimetype = 'font/opentype';
                                                o = this.checkAndRepair(e, t, r);
                                                if (this.isOpenType) {
                                                    adjustWidths(r);
                                                    i = 'OpenType';
                                                }
                                                break;
                                            default:
                                                throw new a.FormatError(`Font ${i} is not supported`);
                                        }
                                    } catch (e) {
                                        (0, a.warn)(e);
                                        this.fallbackToSystemFont(r);
                                        return;
                                    }
                                    this.data = o;
                                    this.fontType = (0, n.getFontType)(i, s);
                                    this.fontMatrix = r.fontMatrix;
                                    this.widths = r.widths;
                                    this.defaultWidth = r.defaultWidth;
                                    this.toUnicode = r.toUnicode;
                                    this.seacMap = r.seacMap;
                                } else {
                                    t && (0, a.warn)('Font file is empty in "' + e + '" (' + this.loadedName + ')');
                                    this.fallbackToSystemFont(r);
                                }
                            } else {
                                for (let e = 0; e < 256; e++)
                                    this.toFontChar[e] = this.differences[e] || r.defaultEncoding[e];
                                this.fontType = a.FontType.TYPE3;
                            }
                        }
                        get renderer() {
                            const e = d.FontRendererFactory.create(this, n.SEAC_ANALYSIS_ENABLED);
                            return (0, a.shadow)(this, 'renderer', e);
                        }
                        exportData(e = !1) {
                            const t = e ? [...S, ...x] : S,
                                r = Object.create(null);
                            let a, i;
                            for (a of t) {
                                i = this[a];
                                void 0 !== i && (r[a] = i);
                            }
                            return r;
                        }
                        fallbackToSystemFont(e) {
                            this.missingFile = !0;
                            const t = this.name,
                                r = this.type,
                                i = this.subtype;
                            let u = t.replace(/[,_]/g, '-').replace(/\s/g, '');
                            const d = (0, c.getStdFontMap)(),
                                f = (0, c.getNonStdFontMap)(),
                                g = !!d[u],
                                p = !(!f[u] || !d[f[u]]);
                            u = d[u] || f[u] || u;
                            this.bold = -1 !== u.search(/bold/gi);
                            this.italic = -1 !== u.search(/oblique/gi) || -1 !== u.search(/italic/gi);
                            this.black = -1 !== t.search(/Black/g);
                            const m = -1 !== t.search(/Narrow/g);
                            this.remeasure = (!g || m) && Object.keys(this.widths).length > 0;
                            if ((g || p) && 'CIDFontType2' === r && this.cidEncoding.startsWith('Identity-')) {
                                const r = (0, c.getGlyphMapForStandardFonts)(),
                                    a = e.cidToGidMap,
                                    i = [];
                                for (const e in r) i[+e] = r[e];
                                if (/Arial-?Black/i.test(t)) {
                                    const e = (0, c.getSupplementalGlyphMapForArialBlack)();
                                    for (const t in e) i[+t] = e[t];
                                } else if (/Calibri/i.test(t)) {
                                    const e = (0, c.getSupplementalGlyphMapForCalibri)();
                                    for (const t in e) i[+t] = e[t];
                                }
                                if (a)
                                    for (const e in i) {
                                        const t = i[e];
                                        void 0 !== a[t] && (i[+e] = a[t]);
                                    }
                                this.toUnicode instanceof h.IdentityToUnicodeMap ||
                                    this.toUnicode.forEach(function (e, t) {
                                        i[+e] = t;
                                    });
                                this.toFontChar = i;
                                this.toUnicode = new h.ToUnicodeMap(i);
                            } else if (/Symbol/i.test(u))
                                this.toFontChar = buildToFontChar(
                                    o.SymbolSetEncoding,
                                    (0, s.getGlyphsUnicode)(),
                                    this.differences
                                );
                            else if (/Dingbats/i.test(u)) {
                                /Wingdings/i.test(t) &&
                                    (0, a.warn)('Non-embedded Wingdings font, falling back to ZapfDingbats.');
                                this.toFontChar = buildToFontChar(
                                    o.ZapfDingbatsEncoding,
                                    (0, s.getDingbatsGlyphsUnicode)(),
                                    this.differences
                                );
                            } else if (g)
                                this.toFontChar = buildToFontChar(
                                    this.defaultEncoding,
                                    (0, s.getGlyphsUnicode)(),
                                    this.differences
                                );
                            else {
                                const e = (0, s.getGlyphsUnicode)(),
                                    r = [];
                                this.toUnicode.forEach((t, a) => {
                                    if (!this.composite) {
                                        const r = this.differences[t] || this.defaultEncoding[t],
                                            i = (0, l.getUnicodeForGlyph)(r, e);
                                        -1 !== i && (a = i);
                                    }
                                    r[+t] = a;
                                });
                                if (
                                    this.composite &&
                                    this.toUnicode instanceof h.IdentityToUnicodeMap &&
                                    /Verdana/i.test(t)
                                ) {
                                    const e = (0, c.getGlyphMapForStandardFonts)();
                                    for (const t in e) r[+t] = e[t];
                                }
                                this.toFontChar = r;
                            }
                            this.loadedName = u.split('-')[0];
                            this.fontType = (0, n.getFontType)(r, i);
                        }
                        checkAndRepair(e, t, r) {
                            const c = [
                                'OS/2',
                                'cmap',
                                'head',
                                'hhea',
                                'hmtx',
                                'maxp',
                                'name',
                                'post',
                                'loca',
                                'glyf',
                                'fpgm',
                                'prep',
                                'cvt ',
                                'CFF ',
                            ];
                            function readTables(e, t) {
                                const r = Object.create(null);
                                r['OS/2'] = null;
                                r.cmap = null;
                                r.head = null;
                                r.hhea = null;
                                r.hmtx = null;
                                r.maxp = null;
                                r.name = null;
                                r.post = null;
                                for (let a = 0; a < t; a++) {
                                    const t = readTableEntry(e);
                                    c.includes(t.tag) && 0 !== t.length && (r[t.tag] = t);
                                }
                                return r;
                            }
                            function readTableEntry(e) {
                                const t = e.getString(4),
                                    r = e.getInt32() >>> 0,
                                    a = e.getInt32() >>> 0,
                                    i = e.getInt32() >>> 0,
                                    n = e.pos;
                                e.pos = e.start ? e.start : 0;
                                e.skip(a);
                                const s = e.getBytes(i);
                                e.pos = n;
                                if ('head' === t) {
                                    s[8] = s[9] = s[10] = s[11] = 0;
                                    s[17] |= 32;
                                }
                                return { tag: t, checksum: r, length: i, offset: a, data: s };
                            }
                            function readOpenTypeHeader(e) {
                                return {
                                    version: e.getString(4),
                                    numTables: e.getUint16(),
                                    searchRange: e.getUint16(),
                                    entrySelector: e.getUint16(),
                                    rangeShift: e.getUint16(),
                                };
                            }
                            function sanitizeGlyph(e, t, r, a, i, n) {
                                const s = { length: 0, sizeOfInstructions: 0 };
                                if (r - t <= 12) return s;
                                const o = e.subarray(t, r);
                                let c = signedInt16(o[0], o[1]);
                                if (c < 0) {
                                    c = -1;
                                    !(function writeSignedInt16(e, t, r) {
                                        e[t + 1] = r;
                                        e[t] = r >>> 8;
                                    })(o, 0, c);
                                    a.set(o, i);
                                    s.length = o.length;
                                    return s;
                                }
                                let l,
                                    h = 10,
                                    u = 0;
                                for (l = 0; l < c; l++) {
                                    u = ((o[h] << 8) | o[h + 1]) + 1;
                                    h += 2;
                                }
                                const d = h,
                                    f = (o[h] << 8) | o[h + 1];
                                s.sizeOfInstructions = f;
                                h += 2 + f;
                                const g = h;
                                let p = 0;
                                for (l = 0; l < u; l++) {
                                    const e = o[h++];
                                    192 & e && (o[h - 1] = 63 & e);
                                    let t = 2;
                                    2 & e ? (t = 1) : 16 & e && (t = 0);
                                    let r = 2;
                                    4 & e ? (r = 1) : 32 & e && (r = 0);
                                    const a = t + r;
                                    p += a;
                                    if (8 & e) {
                                        const e = o[h++];
                                        l += e;
                                        p += e * a;
                                    }
                                }
                                if (0 === p) return s;
                                let m = h + p;
                                if (m > o.length) return s;
                                if (!n && f > 0) {
                                    a.set(o.subarray(0, d), i);
                                    a.set([0, 0], i + d);
                                    a.set(o.subarray(g, m), i + d + 2);
                                    m -= f;
                                    o.length - m > 3 && (m = (m + 3) & -4);
                                    s.length = m;
                                    return s;
                                }
                                if (o.length - m > 3) {
                                    m = (m + 3) & -4;
                                    a.set(o.subarray(0, m), i);
                                    s.length = m;
                                    return s;
                                }
                                a.set(o, i);
                                s.length = o.length;
                                return s;
                            }
                            function readNameTable(e) {
                                const r = (t.start ? t.start : 0) + e.offset;
                                t.pos = r;
                                const a = [[], []],
                                    i = e.length,
                                    n = r + i;
                                if (0 !== t.getUint16() || i < 6) return a;
                                const s = t.getUint16(),
                                    o = t.getUint16(),
                                    c = [];
                                let l, h;
                                for (l = 0; l < s && t.pos + 12 <= n; l++) {
                                    const e = {
                                        platform: t.getUint16(),
                                        encoding: t.getUint16(),
                                        language: t.getUint16(),
                                        name: t.getUint16(),
                                        length: t.getUint16(),
                                        offset: t.getUint16(),
                                    };
                                    ((1 === e.platform && 0 === e.encoding && 0 === e.language) ||
                                        (3 === e.platform && 1 === e.encoding && 1033 === e.language)) &&
                                        c.push(e);
                                }
                                for (l = 0, h = c.length; l < h; l++) {
                                    const e = c[l];
                                    if (e.length <= 0) continue;
                                    const i = r + o + e.offset;
                                    if (i + e.length > n) continue;
                                    t.pos = i;
                                    const s = e.name;
                                    if (e.encoding) {
                                        let r = '';
                                        for (let a = 0, i = e.length; a < i; a += 2)
                                            r += String.fromCharCode(t.getUint16());
                                        a[1][s] = r;
                                    } else a[0][s] = t.getString(e.length);
                                }
                                return a;
                            }
                            const l = [
                                0, 0, 0, 0, 0, 0, 0, 0, -2, -2, -2, -2, 0, 0, -2, -5, -1, -1, -1, -1, -1, -1, -1, -1, 0,
                                0, -1, 0, -1, -1, -1, -1, 1, -1, -999, 0, 1, 0, -1, -2, 0, -1, -2, -1, -1, 0, -1, -1, 0,
                                0, -999, -999, -1, -1, -1, -1, -2, -999, -2, -2, -999, 0, -2, -2, 0, 0, -2, 0, -2, 0, 0,
                                0, -2, -1, -1, 1, 1, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, -1, -1, 0, -999, -1,
                                -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, -999, -999, -999, -999,
                                -999, -1, -1, -2, -2, 0, 0, 0, 0, -1, -1, -999, -2, -2, 0, 0, -1, -2, -2, 0, 0, 0, -1,
                                -1, -1, -2,
                            ];
                            function sanitizeTTProgram(e, t) {
                                let r,
                                    i,
                                    n,
                                    s,
                                    o,
                                    c = e.data,
                                    h = 0,
                                    u = 0,
                                    d = 0;
                                const f = [],
                                    g = [],
                                    p = [];
                                let m = t.tooComplexToFollowFunctions,
                                    b = !1,
                                    y = 0,
                                    w = 0;
                                for (let e = c.length; h < e; ) {
                                    const e = c[h++];
                                    if (64 === e) {
                                        i = c[h++];
                                        if (b || w) h += i;
                                        else for (r = 0; r < i; r++) f.push(c[h++]);
                                    } else if (65 === e) {
                                        i = c[h++];
                                        if (b || w) h += 2 * i;
                                        else
                                            for (r = 0; r < i; r++) {
                                                n = c[h++];
                                                f.push((n << 8) | c[h++]);
                                            }
                                    } else if (176 == (248 & e)) {
                                        i = e - 176 + 1;
                                        if (b || w) h += i;
                                        else for (r = 0; r < i; r++) f.push(c[h++]);
                                    } else if (184 == (248 & e)) {
                                        i = e - 184 + 1;
                                        if (b || w) h += 2 * i;
                                        else
                                            for (r = 0; r < i; r++) {
                                                n = c[h++];
                                                f.push((n << 8) | c[h++]);
                                            }
                                    } else if (43 !== e || m)
                                        if (44 !== e || m) {
                                            if (45 === e)
                                                if (b) {
                                                    b = !1;
                                                    u = h;
                                                } else {
                                                    o = g.pop();
                                                    if (!o) {
                                                        (0, a.warn)('TT: ENDF bad stack');
                                                        t.hintsValid = !1;
                                                        return;
                                                    }
                                                    s = p.pop();
                                                    c = o.data;
                                                    h = o.i;
                                                    t.functionsStackDeltas[s] = f.length - o.stackTop;
                                                }
                                            else if (137 === e) {
                                                if (b || w) {
                                                    (0, a.warn)('TT: nested IDEFs not allowed');
                                                    m = !0;
                                                }
                                                b = !0;
                                                d = h;
                                            } else if (88 === e) ++y;
                                            else if (27 === e) w = y;
                                            else if (89 === e) {
                                                w === y && (w = 0);
                                                --y;
                                            } else if (28 === e && !b && !w) {
                                                const e = f[f.length - 1];
                                                e > 0 && (h += e - 1);
                                            }
                                        } else {
                                            if (b || w) {
                                                (0, a.warn)('TT: nested FDEFs not allowed');
                                                m = !0;
                                            }
                                            b = !0;
                                            d = h;
                                            s = f.pop();
                                            t.functionsDefined[s] = { data: c, i: h };
                                        }
                                    else if (!b && !w) {
                                        s = f[f.length - 1];
                                        if (isNaN(s)) (0, a.info)('TT: CALL empty stack (or invalid entry).');
                                        else {
                                            t.functionsUsed[s] = !0;
                                            if (s in t.functionsStackDeltas) {
                                                const e = f.length + t.functionsStackDeltas[s];
                                                if (e < 0) {
                                                    (0, a.warn)('TT: CALL invalid functions stack delta.');
                                                    t.hintsValid = !1;
                                                    return;
                                                }
                                                f.length = e;
                                            } else if (s in t.functionsDefined && !p.includes(s)) {
                                                g.push({ data: c, i: h, stackTop: f.length - 1 });
                                                p.push(s);
                                                o = t.functionsDefined[s];
                                                if (!o) {
                                                    (0, a.warn)('TT: CALL non-existent function');
                                                    t.hintsValid = !1;
                                                    return;
                                                }
                                                c = o.data;
                                                h = o.i;
                                            }
                                        }
                                    }
                                    if (!b && !w) {
                                        let t = 0;
                                        e <= 142 ? (t = l[e]) : e >= 192 && e <= 223 ? (t = -1) : e >= 224 && (t = -2);
                                        if (e >= 113 && e <= 117) {
                                            i = f.pop();
                                            isNaN(i) || (t = 2 * -i);
                                        }
                                        for (; t < 0 && f.length > 0; ) {
                                            f.pop();
                                            t++;
                                        }
                                        for (; t > 0; ) {
                                            f.push(NaN);
                                            t--;
                                        }
                                    }
                                }
                                t.tooComplexToFollowFunctions = m;
                                const S = [c];
                                h > c.length && S.push(new Uint8Array(h - c.length));
                                if (d > u) {
                                    (0, a.warn)('TT: complementing a missing function tail');
                                    S.push(new Uint8Array([34, 45]));
                                }
                                !(function foldTTTable(e, t) {
                                    if (t.length > 1) {
                                        let r,
                                            a,
                                            i = 0;
                                        for (r = 0, a = t.length; r < a; r++) i += t[r].length;
                                        i = (i + 3) & -4;
                                        const n = new Uint8Array(i);
                                        let s = 0;
                                        for (r = 0, a = t.length; r < a; r++) {
                                            n.set(t[r], s);
                                            s += t[r].length;
                                        }
                                        e.data = n;
                                        e.length = i;
                                    }
                                })(e, S);
                            }
                            let h, d, p, b;
                            if (isTrueTypeCollectionFile((t = new m.Stream(new Uint8Array(t.getBytes()))))) {
                                const e = (function readTrueTypeCollectionData(e, t) {
                                    const { numFonts: r, offsetTable: i } = (function readTrueTypeCollectionHeader(e) {
                                            const t = e.getString(4);
                                            (0, a.assert)('ttcf' === t, 'Must be a TrueType Collection font.');
                                            const r = e.getUint16(),
                                                i = e.getUint16(),
                                                n = e.getInt32() >>> 0,
                                                s = [];
                                            for (let t = 0; t < n; t++) s.push(e.getInt32() >>> 0);
                                            const o = {
                                                ttcTag: t,
                                                majorVersion: r,
                                                minorVersion: i,
                                                numFonts: n,
                                                offsetTable: s,
                                            };
                                            switch (r) {
                                                case 1:
                                                    return o;
                                                case 2:
                                                    o.dsigTag = e.getInt32() >>> 0;
                                                    o.dsigLength = e.getInt32() >>> 0;
                                                    o.dsigOffset = e.getInt32() >>> 0;
                                                    return o;
                                            }
                                            throw new a.FormatError(`Invalid TrueType Collection majorVersion: ${r}.`);
                                        })(e),
                                        n = t.split('+');
                                    let s;
                                    for (let o = 0; o < r; o++) {
                                        e.pos = (e.start || 0) + i[o];
                                        const r = readOpenTypeHeader(e),
                                            c = readTables(e, r.numTables);
                                        if (!c.name)
                                            throw new a.FormatError(
                                                'TrueType Collection font must contain a "name" table.'
                                            );
                                        const l = readNameTable(c.name);
                                        for (let e = 0, a = l.length; e < a; e++)
                                            for (let a = 0, i = l[e].length; a < i; a++) {
                                                const i = l[e][a] && l[e][a].replace(/\s/g, '');
                                                if (i) {
                                                    if (i === t) return { header: r, tables: c };
                                                    if (!(n.length < 2))
                                                        for (const e of n)
                                                            i === e && (s = { name: e, header: r, tables: c });
                                                }
                                            }
                                    }
                                    if (s) {
                                        (0, a.warn)(
                                            `TrueType Collection does not contain "${t}" font, falling back to "${s.name}" font instead.`
                                        );
                                        return { header: s.header, tables: s.tables };
                                    }
                                    throw new a.FormatError(`TrueType Collection does not contain "${t}" font.`);
                                })(t, this.name);
                                h = e.header;
                                d = e.tables;
                            } else {
                                h = readOpenTypeHeader(t);
                                d = readTables(t, h.numTables);
                            }
                            const y = !d['CFF '];
                            if (y) {
                                if (!d.loca) throw new a.FormatError('Required "loca" table is not found');
                                if (!d.glyf) {
                                    (0, a.warn)('Required "glyf" table is not found -- trying to recover.');
                                    d.glyf = { tag: 'glyf', data: new Uint8Array(0) };
                                }
                                this.isOpenType = !1;
                            } else {
                                const t =
                                    r.composite &&
                                    ((r.cidToGidMap || []).length > 0 || !(r.cMap instanceof f.IdentityCMap));
                                if (('OTTO' === h.version && !t) || !d.head || !d.hhea || !d.maxp || !d.post) {
                                    b = new m.Stream(d['CFF '].data);
                                    p = new u.CFFFont(b, r);
                                    adjustWidths(r);
                                    return this.convert(e, p, r);
                                }
                                delete d.glyf;
                                delete d.loca;
                                delete d.fpgm;
                                delete d.prep;
                                delete d['cvt '];
                                this.isOpenType = !0;
                            }
                            if (!d.maxp) throw new a.FormatError('Required "maxp" table is not found');
                            t.pos = (t.start || 0) + d.maxp.offset;
                            const w = t.getInt32(),
                                S = t.getUint16();
                            let x = S + 1,
                                k = !0;
                            if (x > 65535) {
                                k = !1;
                                x = S;
                                (0, a.warn)('Not enough space in glyfs to duplicate first glyph.');
                            }
                            let C = 0,
                                v = 0;
                            if (w >= 65536 && d.maxp.length >= 22) {
                                t.pos += 8;
                                if (t.getUint16() > 2) {
                                    d.maxp.data[14] = 0;
                                    d.maxp.data[15] = 2;
                                }
                                t.pos += 4;
                                C = t.getUint16();
                                t.pos += 4;
                                v = t.getUint16();
                            }
                            d.maxp.data[4] = x >> 8;
                            d.maxp.data[5] = 255 & x;
                            const O = (function sanitizeTTPrograms(e, t, r, i) {
                                const n = {
                                    functionsDefined: [],
                                    functionsUsed: [],
                                    functionsStackDeltas: [],
                                    tooComplexToFollowFunctions: !1,
                                    hintsValid: !0,
                                };
                                e && sanitizeTTProgram(e, n);
                                t && sanitizeTTProgram(t, n);
                                e &&
                                    (function checkInvalidFunctions(e, t) {
                                        if (!e.tooComplexToFollowFunctions)
                                            if (e.functionsDefined.length > t) {
                                                (0, a.warn)('TT: more functions defined than expected');
                                                e.hintsValid = !1;
                                            } else
                                                for (let r = 0, i = e.functionsUsed.length; r < i; r++) {
                                                    if (r > t) {
                                                        (0, a.warn)('TT: invalid function id: ' + r);
                                                        e.hintsValid = !1;
                                                        return;
                                                    }
                                                    if (e.functionsUsed[r] && !e.functionsDefined[r]) {
                                                        (0, a.warn)('TT: undefined function: ' + r);
                                                        e.hintsValid = !1;
                                                        return;
                                                    }
                                                }
                                    })(n, i);
                                if (r && 1 & r.length) {
                                    const e = new Uint8Array(r.length + 1);
                                    e.set(r.data);
                                    r.data = e;
                                }
                                return n.hintsValid;
                            })(d.fpgm, d.prep, d['cvt '], C);
                            if (!O) {
                                delete d.fpgm;
                                delete d.prep;
                                delete d['cvt '];
                            }
                            !(function sanitizeMetrics(e, t, r, i, n) {
                                if (!t) {
                                    r && (r.data = null);
                                    return;
                                }
                                e.pos = (e.start ? e.start : 0) + t.offset;
                                e.pos += 4;
                                e.pos += 2;
                                e.pos += 2;
                                e.pos += 2;
                                e.pos += 2;
                                e.pos += 2;
                                e.pos += 2;
                                e.pos += 2;
                                e.pos += 2;
                                e.pos += 2;
                                e.pos += 2;
                                e.pos += 8;
                                e.pos += 2;
                                let s = e.getUint16();
                                if (s > i) {
                                    (0, a.info)(
                                        'The numOfMetrics (' +
                                            s +
                                            ') should not be greater than the numGlyphs (' +
                                            i +
                                            ')'
                                    );
                                    s = i;
                                    t.data[34] = (65280 & s) >> 8;
                                    t.data[35] = 255 & s;
                                }
                                const o = i - s - ((r.length - 4 * s) >> 1);
                                if (o > 0) {
                                    const e = new Uint8Array(r.length + 2 * o);
                                    e.set(r.data);
                                    if (n) {
                                        e[r.length] = r.data[2];
                                        e[r.length + 1] = r.data[3];
                                    }
                                    r.data = e;
                                }
                            })(t, d.hhea, d.hmtx, x, k);
                            if (!d.head) throw new a.FormatError('Required "head" table is not found');
                            !(function sanitizeHead(e, t, r) {
                                const i = e.data,
                                    n = (function int32(e, t, r, a) {
                                        return (e << 24) + (t << 16) + (r << 8) + a;
                                    })(i[0], i[1], i[2], i[3]);
                                if (n >> 16 != 1) {
                                    (0, a.info)('Attempting to fix invalid version in head table: ' + n);
                                    i[0] = 0;
                                    i[1] = 1;
                                    i[2] = 0;
                                    i[3] = 0;
                                }
                                const s = int16(i[50], i[51]);
                                if (s < 0 || s > 1) {
                                    (0, a.info)('Attempting to fix invalid indexToLocFormat in head table: ' + s);
                                    const e = t + 1;
                                    if (r === e << 1) {
                                        i[50] = 0;
                                        i[51] = 0;
                                    } else {
                                        if (r !== e << 2)
                                            throw new a.FormatError('Could not fix indexToLocFormat: ' + s);
                                        i[50] = 0;
                                        i[51] = 1;
                                    }
                                }
                            })(d.head, S, y ? d.loca.length : 0);
                            let F = Object.create(null);
                            if (y) {
                                const e = int16(d.head.data[50], d.head.data[51]),
                                    t = (function sanitizeGlyphLocations(e, t, r, a, i, n, s) {
                                        let o, c, l;
                                        if (a) {
                                            o = 4;
                                            c = function fontItemDecodeLong(e, t) {
                                                return (e[t] << 24) | (e[t + 1] << 16) | (e[t + 2] << 8) | e[t + 3];
                                            };
                                            l = function fontItemEncodeLong(e, t, r) {
                                                e[t] = (r >>> 24) & 255;
                                                e[t + 1] = (r >> 16) & 255;
                                                e[t + 2] = (r >> 8) & 255;
                                                e[t + 3] = 255 & r;
                                            };
                                        } else {
                                            o = 2;
                                            c = function fontItemDecode(e, t) {
                                                return (e[t] << 9) | (e[t + 1] << 1);
                                            };
                                            l = function fontItemEncode(e, t, r) {
                                                e[t] = (r >> 9) & 255;
                                                e[t + 1] = (r >> 1) & 255;
                                            };
                                        }
                                        const h = n ? r + 1 : r,
                                            u = o * (1 + h),
                                            d = new Uint8Array(u);
                                        d.set(e.data.subarray(0, u));
                                        e.data = d;
                                        const f = t.data,
                                            g = f.length,
                                            p = new Uint8Array(g);
                                        let m, b;
                                        const y = [];
                                        for (m = 0, b = 0; m < r + 1; m++, b += o) {
                                            let e = c(d, b);
                                            e > g && (e = g);
                                            y.push({ index: m, offset: e, endOffset: 0 });
                                        }
                                        y.sort((e, t) => e.offset - t.offset);
                                        for (m = 0; m < r; m++) y[m].endOffset = y[m + 1].offset;
                                        y.sort((e, t) => e.index - t.index);
                                        const w = Object.create(null);
                                        let S = 0;
                                        l(d, 0, S);
                                        for (m = 0, b = o; m < r; m++, b += o) {
                                            const e = sanitizeGlyph(f, y[m].offset, y[m].endOffset, p, S, i),
                                                t = e.length;
                                            0 === t && (w[m] = !0);
                                            e.sizeOfInstructions > s && (s = e.sizeOfInstructions);
                                            S += t;
                                            l(d, b, S);
                                        }
                                        if (0 === S) {
                                            const e = new Uint8Array([0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 0]);
                                            for (m = 0, b = o; m < h; m++, b += o) l(d, b, e.length);
                                            t.data = e;
                                        } else if (n) {
                                            const r = c(d, o);
                                            if (p.length > r + S) t.data = p.subarray(0, r + S);
                                            else {
                                                t.data = new Uint8Array(r + S);
                                                t.data.set(p.subarray(0, S));
                                            }
                                            t.data.set(p.subarray(0, r), S);
                                            l(e.data, d.length - o, S + r);
                                        } else t.data = p.subarray(0, S);
                                        return { missingGlyphs: w, maxSizeOfInstructions: s };
                                    })(d.loca, d.glyf, S, e, O, k, v);
                                F = t.missingGlyphs;
                                if (w >= 65536 && d.maxp.length >= 22) {
                                    d.maxp.data[26] = t.maxSizeOfInstructions >> 8;
                                    d.maxp.data[27] = 255 & t.maxSizeOfInstructions;
                                }
                            }
                            if (!d.hhea) throw new a.FormatError('Required "hhea" table is not found');
                            if (0 === d.hhea.data[10] && 0 === d.hhea.data[11]) {
                                d.hhea.data[10] = 255;
                                d.hhea.data[11] = 255;
                            }
                            const T = {
                                unitsPerEm: int16(d.head.data[18], d.head.data[19]),
                                yMax: int16(d.head.data[42], d.head.data[43]),
                                yMin: signedInt16(d.head.data[38], d.head.data[39]),
                                ascent: int16(d.hhea.data[4], d.hhea.data[5]),
                                descent: signedInt16(d.hhea.data[6], d.hhea.data[7]),
                            };
                            this.ascent = T.ascent / T.unitsPerEm;
                            this.descent = T.descent / T.unitsPerEm;
                            d.post &&
                                (function readPostScriptTable(e, r, i) {
                                    const s = (t.start ? t.start : 0) + e.offset;
                                    t.pos = s;
                                    const o = s + e.length,
                                        c = t.getInt32();
                                    t.skip(28);
                                    let l,
                                        h,
                                        u = !0;
                                    switch (c) {
                                        case 65536:
                                            l = n.MacStandardGlyphOrdering;
                                            break;
                                        case 131072:
                                            const e = t.getUint16();
                                            if (e !== i) {
                                                u = !1;
                                                break;
                                            }
                                            const s = [];
                                            for (h = 0; h < e; ++h) {
                                                const e = t.getUint16();
                                                if (e >= 32768) {
                                                    u = !1;
                                                    break;
                                                }
                                                s.push(e);
                                            }
                                            if (!u) break;
                                            const d = [],
                                                f = [];
                                            for (; t.pos < o; ) {
                                                const e = t.getByte();
                                                f.length = e;
                                                for (h = 0; h < e; ++h) f[h] = String.fromCharCode(t.getByte());
                                                d.push(f.join(''));
                                            }
                                            l = [];
                                            for (h = 0; h < e; ++h) {
                                                const e = s[h];
                                                e < 258 ? l.push(n.MacStandardGlyphOrdering[e]) : l.push(d[e - 258]);
                                            }
                                            break;
                                        case 196608:
                                            break;
                                        default:
                                            (0, a.warn)('Unknown/unsupported post table version ' + c);
                                            u = !1;
                                            r.defaultEncoding && (l = r.defaultEncoding);
                                    }
                                    r.glyphNames = l;
                                    return u;
                                })(d.post, r, S);
                            d.post = { tag: 'post', data: createPostTable(r) };
                            const E = [];
                            function hasGlyph(e) {
                                return !F[e];
                            }
                            if (r.composite) {
                                const e = r.cidToGidMap || [],
                                    t = 0 === e.length;
                                r.cMap.forEach(function (r, i) {
                                    if (i > 65535) throw new a.FormatError('Max size of CID is 65,535');
                                    let n = -1;
                                    t ? (n = i) : void 0 !== e[i] && (n = e[i]);
                                    n >= 0 && n < S && hasGlyph(n) && (E[r] = n);
                                });
                            } else {
                                const e = (function readCmapTable(e, t, r, i) {
                                        if (!e) {
                                            (0, a.warn)('No cmap table available.');
                                            return { platformId: -1, encodingId: -1, mappings: [], hasShortCmap: !1 };
                                        }
                                        let n,
                                            s = (t.start ? t.start : 0) + e.offset;
                                        t.pos = s;
                                        t.skip(2);
                                        const o = t.getUint16();
                                        let c,
                                            l = !1;
                                        for (let e = 0; e < o; e++) {
                                            const e = t.getUint16(),
                                                a = t.getUint16(),
                                                n = t.getInt32() >>> 0;
                                            let s = !1;
                                            if (!c || c.platformId !== e || c.encodingId !== a) {
                                                if (0 !== e || (0 !== a && 1 !== a && 3 !== a))
                                                    if (1 === e && 0 === a) s = !0;
                                                    else if (3 !== e || 1 !== a || (!i && c)) {
                                                        if (r && 3 === e && 0 === a) {
                                                            s = !0;
                                                            l = !0;
                                                        }
                                                    } else {
                                                        s = !0;
                                                        r || (l = !0);
                                                    }
       