<?php
/**
 * Uninstall Group Accounts
 *
 * Deletes the following plugin data:
 *      - Group Accounts pages
 *      - Clears cron events
 *      - Database tables
 *      - Options added by Group Accounts
 *      - Membership level meta
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license   GPL2+
 * @since     2.0
 */

// Exit if accessed directly
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Load Group Accounts file.
include_once 'rcp-group-accounts.php';

global $wpdb;
$rcp_options = get_option( 'rcp_settings' );

if ( isset( $rcp_options['remove_data_on_uninstall'] ) ) {

	/*
	 * This is kind of stupid but it ensures that rcpga_group_accounts() gets loaded (used below).
	 * Otherwise Group Accounts never gets loaded because it's hooked in via `plugins_loaded`, which is
	 * too late for uninstall.
	 */
	new RCP_Group_Accounts_Requirements_Check;

	if ( class_exists( 'RCP_Group_Accounts' ) ) {
		RCP_Group_Accounts::instance( dirname( __FILE__ ) . '/rcp-group-accounts.php' );
	}

	// Delete Group Accounts dashboard page
	$dashboard_page_id = $rcp_options['rcpga_dashboard_page'];
	if ( ! empty( $dashboard_page_id ) ) {
		wp_trash_post( $dashboard_page_id );
	}

	// Clear scheduled cron events.
	wp_clear_scheduled_hook( 'rcpga_purge_unclaimed_invitations' );

	// Drop database tables.
	if ( function_exists( 'rcpga_group_accounts' ) ) {
		if ( rcpga_group_accounts()->table_groups->exists() ) {
			rcpga_group_accounts()->table_groups->uninstall();
		}
		if ( rcpga_group_accounts()->table_groupmeta->exists() ) {
			rcpga_group_accounts()->table_groupmeta->uninstall();
		}
		if ( rcpga_group_accounts()->table_group_members->exists() ) {
			rcpga_group_accounts()->table_group_members->uninstall();
		}
	}

	// Remove all plugin options.
	$wpdb->query( "DELETE FROM $wpdb->options WHERE option_name LIKE 'rcpga\_%' OR option_name LIKE '%_rcp_group%'" );

	// Delete membership level meta.
	$wpdb->query( "DELETE FROM {$wpdb->levelmeta} WHERE meta_key = 'group_seats_enabled' OR meta_key = 'group_seats_allowed';" );

}