<?php
/**
 * Template: Group Registration Form Fields
 *
 * For modifying this template, please see: http://docs.restrictcontentpro.com/article/1738-template-files
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     1.0
 */

/**
 * These fields should not appear if the current user is already a group owner and one of the following is true:
 *      - Multiple memberships are disabled; or:
 *      - Multiple memberships are enabled and this is not a "new" registration.
 */
if (
	rcpga_user_is_group_member( get_current_user_id(), 'owner' ) &&
	( ! rcp_multiple_memberships_enabled() || ( rcp_multiple_memberships_enabled() && method_exists( rcp_get_registration(), 'get_registration_type' ) && 'new' != rcp_get_registration()->get_registration_type() ) )
) {
	return;
}
?>

<div class="rcpga-group-fields">

	<?php do_action( 'rcpga_register_group_before' ); ?>

	<fieldset class="rcpga-group-fieldset">

		<p id="rcpga-group-name-wrap">
			<label for="rcpga-group-name"><?php _e( 'Group Name', 'rcp-group-accounts' ); ?></label>
			<input type="text" name="rcpga-group-name" id="rcpga-group-name"/>
		</p>

		<p id="rcpga-group-description-wrap">
			<label for="rcpga-group-description"><?php _e( 'Group Description', 'rcp-group-accounts' ); ?></label>
			<textarea name="rcpga-group-description" id="rcpga-group-description"></textarea>
		</p>

	</fieldset>

	<?php do_action( 'rcpga_register_group_after' ); ?>

</div>
