<?php
/**
 * Template: Group Registration Seats Form Field
 *
 * This is used with per-seat pricing only.
 *
 * For modifying this template, please see: http://docs.restrictcontentpro.com/article/1738-template-files
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license   GPL2+
 * @since     2.2
 */

$default_value = 1;

if ( ! empty( $_GET['membership_id'] ) ) {
	$group = rcpga_get_group_by( 'membership_id', absint( $_GET['membership_id'] ) );

	if ( $group instanceof RCPGA_Group ) {
		$default_value = $group->get_seats();
	}
}
?>
<div class="rcpga-group-fields rcpga-group-per-seat-fields">
	<div id="rcpga-group-number-seats-wrap" style="display: none;">
		<label for="rcpga-group-number-seats"><?php _e( 'Group Seats', 'rcp-group-accounts' ); ?></label>
		<input type="number" name="rcpga-group-number-seats" id="rcpga-group-number-seats" value="<?php echo absint( $default_value ); ?>"/>
		<p>
            <span class="rcpga-group-seats-has-max" style="display: none;">
                <?php
                    $message = wp_sprintf (
                        __( 'Enter a number between %s and %s.', 'rcp-group-accounts' ),
                        '<span class="rcpga-group-seats-min"></span>',
                        '<span class="rcpga-group-seats-max"></span>'
                    );

                    _e( apply_filters( 'rcpga_group_seats_has_max', $message) );
                ?>
            </span>
			<span class="rcpga-group-seats-no-max" style="display: none;">
					<?php
                        $message = wp_sprintf(
	                        __( 'Enter a number %s or greater.', 'rcp-group-accounts' ),
	                        '<span class="rcpga-group-seats-min"></span>'
                        );
					_e( apply_filters( 'rcpga_group_seats_no_max', $message) );
					?>
				</span>
			<?php
			    _e( apply_filters( 'rcpga_maximum_number_of_people', 'This is the maximum number of people you\'ll be able to add to your group.'), 'rcp-group-accounts' );
            ?>
		</p>
	</div>
</div>
