<?php
/**
 * Template: Group Members List
 *
 * For modifying this template, please see: http://docs.restrictcontentpro.com/article/1738-template-files
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     1.0
 */

use function RCPGA\Shortcodes\get_dashboard;

$dashboard = get_dashboard();

$current_page  = add_query_arg( 'rcpga-group', urlencode( $dashboard->get_group()->get_group_id() ) );
$search        = ! empty( $_GET['rcpga-search'] ) ? rawurldecode( $_GET['rcpga-search'] ) : '';
$members       = $dashboard->get_members_list();
$total_members = $dashboard->get_members_list_count();
$total_pages   = ceil( $total_members / 20 );
$current_role  = ! isset( $_GET['rcpga-role'] ) ? 'total' : urldecode( $_GET['rcpga-role'] );
?>
	<h3 class="rcp-header"><?php _e( 'Group Members', 'rcp-group-accounts' ); ?></h3>

	<ul id="rcpga-group-members-list-roles-filter" style="list-style:none; margin: 0; float: left;">
		<?php
		$counts = rcpga_get_group_member_counts( array( 'group_id' => $dashboard->get_group()->get_group_id() ) );
		foreach ( $counts as $role => $count ) {
			?>
			<li style="display: inline-block; padding-right: 5px;">
				<?php if ( 'total' == $role ) : ?>
					<a href="<?php echo esc_url( remove_query_arg( 'rcpga-role' ) ); ?>" <?php echo $role == $current_role ? 'style="font-weight: bold;"' : ''; ?>><?php printf( '%s (%d)', __( 'Total', 'rcp-group-accounts' ), $count ); ?></a>
				<?php else : ?>
					<a href="<?php echo esc_url( add_query_arg( 'rcpga-role', urlencode( $role ) ) ); ?>" <?php echo $role == $current_role ? 'style="font-weight: bold;"' : ''; ?>><?php printf( '%s (%d)', rcpga_get_member_role_label( $role ), $count ); ?></a>
				<?php endif; ?>
			</li>
			<?php
		}
		?>
	</ul>

	<form id="rcpga-members-search" method="GET" action="<?php echo esc_url( get_permalink() ); ?>" style="float: right; margin-bottom: 1em;">
		<label for="rcpga-members-search-input" class="screen-reader-text"><?php _e( 'Search Members', 'rcp-group-accounts' ); ?></label>
		<input type="search" id="rcpga-members-search-input" name="rcpga-search" placeholder="<?php esc_attr_e( 'Username or email', 'rcp-group-accounts' ); ?>" value="<?php echo esc_attr( $search ); ?>">
		<input type="hidden" name="rcpga-group" value="<?php echo absint( $dashboard->get_group()->get_group_id() ); ?>"/>
		<input type="submit" class="button" value="<?php esc_attr_e( 'Search members', 'rcp-group-accounts' ); ?>">
	</form>

	<table id="rcpga-group-members-list" class="rcp-table">
		<thead>
		<tr>
			<th><?php _e( 'Name', 'rcp-group-accounts' ); ?></th>
			<th><?php _e( 'Role', 'rcp-group-accounts' ); ?></th>
			<th><?php _e( 'Actions', 'rcp-group-accounts' ); ?></th>
		</tr>
		</thead>
		<tbody>
		<?php
		if ( ! empty( $members ) ) {
			/**
			 * Display list of members.
			 */
			foreach ( $members as $member ) {
				/**
				 * @var RCPGA_Group_Member $member
				 */

				$user_data = get_userdata( $member->get_user_id() );
				?>
				<tr>
					<?php
					/**
					 * Triggers before the member's data is displayed.
					 *
					 * @param WP_User            $user_data User object.
					 * @param RCPGA_Group_Member $member    Group member object.
					 * @param RCPGA_Group        $group     Group object.
					 */
					do_action( 'rcpga_before_member_data', $user_data, $member, $dashboard->get_group() );
					?>
					<td class="member-name" data-th="<?php esc_attr_e( 'Name', 'rcp-group-accounts' ); ?>"><?php echo esc_html( $user_data->display_name ); ?></td>
					<td class="member-role" data-th="<?php esc_attr_e( 'Role', 'rcp-group-accounts' ); ?>"><?php echo esc_html( rcpga_get_member_role_label( $member->get_role() ) ); ?></td>
					<td class="member-actions" data-th="<?php esc_attr_e( 'Actions', 'rcp-group-accounts' ); ?>">
						<?php if ( 'owner' !== $member->get_role() ) : ?>
							<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array(
								'rcpga-action' => 'remove-member',
								'group-member-id' => absint( $member->get_id() )
							), $current_page ), 'rcpga_remove_from_group' ) ); ?>"><?php _e( 'Remove from Group', 'rcp-group-accounts' ); ?></a>
							<br/>
							<?php if ( 'admin' == $member->get_role() ) : ?>
								<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array(
									'rcpga-action' => 'make-member',
									'group-member-id' => absint( $member->get_id() )
								), $current_page ), 'rcpga_make_member' ) ); ?>"><?php _e( 'Set as Member', 'rcp-group-accounts' ); ?></a>
							<?php elseif ( 'member' == $member->get_role() ) : ?>
								<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array(
									'rcpga-action' => 'make-admin',
									'group-member-id' => absint( $member->get_id() )
								), $current_page ), 'rcpga_make_admin' ) ); ?>"><?php _e( 'Set as Admin', 'rcp-group-accounts' ); ?></a>
							<?php elseif ( 'invited' == $member->get_role() ) : ?>
								<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array(
									'rcpga-action' => 'make-member',
									'group-member-id' => absint( $member->get_id() )
								), $current_page ), 'rcpga_make_member' ) ); ?>"><?php _e( 'Set as Member', 'rcp-group-accounts' ); ?></a> |
								<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array(
									'rcpga-action' => 'resend-invite',
									'group-member-id' => absint( $member->get_id() )
								), $current_page ), 'rcpga_resend_invite' ) ); ?>"><?php _e( 'Resend Invite', 'rcp-group-accounts' ); ?></a>
							<?php endif; ?>
						<?php endif; ?>
					</td>
					<?php
					/**
					 * Triggers after the member's data is displayed.
					 *
					 * @param WP_User            $user_data User object.
					 * @param RCPGA_Group_Member $member    Group member object.
					 * @param RCPGA_Group        $group     Group object.
					 */
					do_action( 'rcpga_after_member_data', $user_data, $member, $dashboard->get_group() );
					?>
				</tr>
				<?php
			}
		} else {
			/**
			 * No members found for whatever reason.
			 */
			?>
			<tr>
				<td colspan="3">
					<?php
					if ( ! empty( $search ) ) {
						printf( __( 'Member &#8220;%s&#8221; not found. <a href="%s">Clear search.</a>', 'rcp-group-accounts' ), esc_html( $search ), esc_url( remove_query_arg( 'rcpga-search' ) ) );
					} else {
						_e( 'No members found.', 'rcp-group-accounts' );
					}
					?>
				</td>
			</tr>
			<?php
		}
		?>
		</tbody>
	</table>

<?php
if ( $total_pages > 1 ) {
	?>
	<div id="rcpga-group-members-pagination">
		<?php
		$big = 999999;
		echo paginate_links( array(
			'base'     => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format'   => '?paged=%#%',
			'total'    => $total_pages,
			'current'  => get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1,
			'end_size' => 1,
			'mid_size' => 5,
		) );
		?>
	</div>
	<?php
}