<?php
/**
 * Template: Group Member Join Info
 *
 * For modifying this template, please see: http://docs.restrictcontentpro.com/article/1738-template-files
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.1
 */

use function RCPGA\Shortcodes\get_dashboard;

global $rcp_options;

$dashboard         = get_dashboard();
$join_form_page_id = $rcp_options['group_join_page'];

// Bail if no join page is selected.
if ( empty( $join_form_page_id ) ) {
	return;
}

// Bail if self-registration is not enabled.
if ( empty( $rcp_options['groups_allow_member_registration'] ) ) {
	return;
}

$page_url = get_permalink( $join_form_page_id );

if ( empty( $page_url ) ) {
	return;
}

// Bail if there's no code saved.
if ( ! $dashboard->get_group()->get_code() ) {
	return;
}
?>
<h4 class="rcp-header"><?php _e( 'Invite Group Members', 'rcp-group-accounts' ); ?></h4>

<p><?php _e( 'You can invite members to self-register for your group by giving them this URL:', 'rcp-group-accounts' ); ?></p>
<p>
	<pre><?php echo esc_url( add_query_arg( 'group_code', urlencode( $dashboard->get_group()->get_code() ), $page_url ) ); ?></pre>
</p>