<?php
/**
 * Group Member Registration Form
 *
 * This template is used to show the form that allows members to register their own accounts and join a specific group.
 *
 * For modifying this template, please see: http://docs.restrictcontentpro.com/article/1738-template-files
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.1
 */

global $rcp_options;

if ( ! empty( $_POST['rcpga_group_id'] ) ) {
	$group_code = $_POST['rcpga_group_id'];
} elseif ( ! empty( $_GET['group_code'] ) ) {
	$group_code = urldecode( $_GET['group_code'] );
} else {
	$group_code = '';
}

$group = ! empty( $group_code ) ? rcpga_get_group_by( 'code', sanitize_text_field( $group_code ) ) : false;

// Special errors for when multiple memberships is not enabled.
if ( is_user_logged_in() && ! rcp_multiple_memberships_enabled() ) {

	if ( rcpga_user_is_group_member() ) {
		/**
		 * User is already in a group -- they cannot join another.
		 */
		rcp_errors()->add( 'already_in_group', __( 'You are already in a group.', 'rcp-group-accounts' ), 'rcpga_member_registration' );
		rcp_show_error_messages( 'rcpga_member_registration' );

		return;
	}

	if ( rcp_user_has_paid_membership( get_current_user_id() ) ) {
		/**
		 * User already has their own independent, active, paid membership -- they cannot join a group.
		 */
		rcp_errors()->add( 'already_has_membership', __( 'You already have an active membership. You need to cancel your membership before you can join a group.', 'rcp-group-accounts' ), 'rcpga_member_registration' );
		rcp_show_error_messages( 'rcpga_member_registration' );

		return;
	}

}

/**
 * Show error if current user is already in this group.
 */
if ( $group instanceof RCPGA_Group && is_user_logged_in() && rcpga_user_is_member_of_group( get_current_user_id(), $group->get_group_id() ) ) {
	rcp_errors()->add( 'already_in_group', sprintf( __( 'You are already a member of the group "%s".', 'rcp-group-accounts' ), esc_html( $group->get_name() ) ), 'rcpga_member_registration' );
	rcp_show_error_messages( 'rcpga_member_registration' );

	return;
}

rcp_show_error_messages( 'rcpga_member_registration' );
?>
<form id="rcpga_group_member_registration" class="rcpga_form rcp_form" method="POST" action="<?php echo esc_url( rcp_get_current_url() ); ?>">

	<?php
	/**
	 * If group is supplied via URL, display the name of the group.
	 */
	if ( ! empty( $_GET['group_code'] ) && $group instanceof RCPGA_Group ) {
		?>
		<h2><?php printf( __( 'Register for "%s"', 'rcp-group-accounts' ), esc_html( $group->get_name() ) ); ?></h2>
		<?php
	}

	if ( ! is_user_logged_in() ) {
		/**
		 * User needs to create a brand new account.
		 */
		?>
		<fieldset class="rcpga_user_fieldset">
			<p id="rcpga_user_login_wrap">
				<label for="rcpga_user_login"><?php echo apply_filters( 'rcp_registration_username_label', __( 'Username', 'rcp-group-accounts' ) ); ?></label>
				<input name="rcpga_user_login" id="rcpga_user_login" class="required" type="text" <?php echo ! empty( $_POST['rcpga_user_login'] ) ? 'value="' . esc_attr( $_POST['rcpga_user_login'] ) . '"' : ''; ?>/>
			</p>
			<p id="rcpga_user_email_wrap">
				<label for="rcpga_user_email"><?php echo apply_filters( 'rcp_registration_email_label', __( 'Email', 'rcp-group-accounts' ) ); ?></label>
				<input name="rcpga_user_email" id="rcpga_user_email" class="required" type="text" <?php echo ! empty( $_POST['rcpga_user_email'] ) ? 'value="' . esc_attr( $_POST['rcpga_user_email'] ) . '"' : ''; ?>/>
			</p>
			<p id="rcpga_user_first_wrap">
				<label for="rcpga_user_first"><?php echo apply_filters( 'rcp_registration_firstname_label', __( 'First Name', 'rcp-group-accounts' ) ); ?></label>
				<input name="rcpga_user_first" id="rcpga_user_first" type="text" <?php echo ! empty( $_POST['rcpga_user_first'] ) ? 'value="' . esc_attr( $_POST['rcpga_user_first'] ) . '"' : ''; ?>/>
			</p>
			<p id="rcpga_user_last_wrap">
				<label for="rcpga_user_last"><?php echo apply_filters( 'rcp_registration_lastname_label', __( 'Last Name', 'rcp-group-accounts' ) ); ?></label>
				<input name="rcpga_user_last" id="rcpga_user_last" type="text" <?php echo ! empty( $_POST['rcpga_user_last'] ) ? 'value="' . esc_attr( $_POST['rcpga_user_last'] ) . '"' : ''; ?>/>
			</p>
			<p id="rcpga_password_wrap">
				<label for="rcpga_password"><?php echo apply_filters( 'rcp_registration_password_label', __( 'Password', 'rcp-group-accounts' ) ); ?></label>
				<input name="rcpga_user_pass" id="rcpga_password" class="required" type="password"/>
			</p>
			<p id="rcpga_password_again_wrap">
				<label for="rcpga_password_again"><?php echo apply_filters( 'rcp_registration_password_again_label', __( 'Password Again', 'rcp-group-accounts' ) ); ?></label>
				<input name="rcpga_user_pass_confirm" id="rcpga_password_again" class="required" type="password"/>
			</p>

		</fieldset>
		<?php
	}
	?>

	<fieldset class="rcpga_group_id_fieldset">
		<p id="rcpga_group_id_wrap">
			<label for="rcpga_group_id"><?php _e( 'Group Code', 'rcp-group-accounts' ); ?></label>
			<input name="rcpga_group_id" id="rcpga_group_id" type="text" class="required" value="<?php echo esc_attr( $group_code ); ?>" required/>
		</p>
	</fieldset>

	<?php
	/**
	 * Terms & Conditions
	 */
	if ( ! empty( $rcp_options['enable_terms'] ) ) {
		$label = ! empty( $rcp_options['terms_label'] ) ? $rcp_options['terms_label'] : __( 'I agree to the terms and conditions', 'rcp-group-accounts' );
		?>
		<fieldset class="rcpga_group_terms_fieldset">
			<p id="rcpga_group_agree_to_terms_wrap">
				<input name="rcpga_member_agree_to_terms" id="rcpga_member_agree_to_terms" class="required" type="checkbox" value="1"/>
				<label for="rcpga_member_agree_to_terms">
					<?php if ( ! empty ( $rcp_options['terms_link'] ) ) : ?>
						<a href="<?php echo esc_url( $rcp_options['terms_link'] ); ?>" target="_blank"><?php echo $label; ?></a>
					<?php else: ?>
						<?php echo $label; ?>
					<?php endif; ?>
				</label>
			</p>
		</fieldset>
		<?php
	}

	/**
	 * Privacy Policy
	 */
	if ( ! empty( $rcp_options['enable_privacy_policy'] ) ) {
		$label = ! empty( $rcp_options['privacy_policy_label'] ) ? $rcp_options['privacy_policy_label'] : __( 'I agree to the privacy policy', 'rcp-group-accounts' );
		?>
		<fieldset class="rcpga_group_privacy_policy_fieldset">
			<p id="rcpga_group_agree_to_privacy_policy_wrap">
				<input name="rcpga_member_agree_to_privacy_policy" id="rcpga_member_agree_to_privacy_policy" class="required" type="checkbox" value="1"/>
				<label for="rcpga_member_agree_to_privacy_policy">
					<?php if ( ! empty ( $rcp_options['privacy_policy_link'] ) ) : ?>
						<a href="<?php echo esc_url( $rcp_options['privacy_policy_link'] ); ?>" target="_blank"><?php echo $label; ?></a>
					<?php else: ?>
						<?php echo $label; ?>
					<?php endif; ?>
				</label>
			</p>
		</fieldset>
		<?php
	}
	?>

	<p id="rcpga_member_registration_submit_wrap">
		<input type="hidden" name="rcpga_member_register_nonce" value="<?php echo wp_create_nonce( 'rcpga-member-register-nonce' ); ?>"/>
		<input type="submit" name="rcpga_submit_member_registration" id="rcpga_submit" value="<?php esc_attr_e( 'Register', 'rcp-group-accounts' ); ?>"/>
	</p>

</form>
