<?php
/**
 * Group Creation Form
 *
 * This template is used to show a form for creating a group. This is used if someone has a Group Accounts-enabled
 * membership, but for some reason doesn't have a corresponding group. This allows them to create the group
 * after the fact.
 *
 * For modifying this template, please see: http://docs.restrictcontentpro.com/article/1738-template-files
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.1
 */

if ( empty( $_GET['rcpga-create-group'] ) ) {
	return;
}

$membership = rcp_get_membership( absint( $_GET['rcpga-create-group'] ) );

if ( ! $membership instanceof RCP_Membership ) {
	return;
}

/*
 * Show error messages.
 */
rcp_show_error_messages( 'rcpga_create_group' );
?>
<form id="rcpga-group-create-form" class="rcp_form" method="POST" action="<?php echo esc_url( add_query_arg( 'rcpga-create-group', urlencode( $membership->get_id() ), rcp_get_current_url() ) ); ?>">
	<div class="rcpga-group-fields">

		<fieldset class="rcpga-group-fieldset">

			<p id="rcpga-group-name-wrap">
				<label for="rcpga-group-name"><?php _e( 'Group Name', 'rcp-group-accounts' ); ?></label>
				<input type="text" id="rcpga-group-name" name="rcpga-group-name" value="<?php echo ! empty( $_POST['rcpga-group-name'] ) ? esc_attr( $_POST['rcpga-group-name'] ) : ''; ?>" />
			</p>

			<p id="rcpga-group-description-wrap">
				<label for="rcpga-group-description"><?php _e( 'Group Description', 'rcp-group-accounts' ); ?></label>
				<textarea id="rcpga-group-description" name="rcpga-group-description"><?php echo ! empty( $_POST['rcpga-group-description'] ) ? esc_textarea( $_POST['rcpga-group-description'] ) : ''; ?></textarea>
			</p>

		</fieldset>

	</div>

	<?php wp_nonce_field( 'rcpga_create_membership_group', 'rcpga_create_membership_group_nonce' ); ?>
	<input type="hidden" name="rcpga_membership_id" value="<?php echo esc_attr( $membership->get_id() ); ?>">
	<input type="submit" class="rcp-button" value="<?php esc_attr_e( 'Create Group', 'rcp-group-accounts' ); ?>">
</form>