<?php
/**
 * Template Filters
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA;

use RCP_Membership;

/**
 * Include Group Accounts `templates/` directory in the RCP template stack.
 *
 * @param array $template_stack
 *
 * @since 2.0
 * @return array
 */
function add_template_stack( $template_stack ) {

	$template_stack[] = RCPGA_GROUPS_PLUGIN_DIR . 'templates';

	return $template_stack;

}

add_filter( 'rcp_template_stack', __NAMESPACE__ . '\add_template_stack' );

/**
 * Add a "Manage Group" link to the membership table.
 *
 * @param array                $links
 * @param RCP_Membership|false $membership
 *
 * @since 2.0
 * @return void
 */
function membership_manage_group_link( $links, $membership = false ) {

	global $rcp_options;

	if ( empty( $rcp_options['rcpga_dashboard_page'] ) || empty( $membership ) ) {
		return;
	}

	$dashboard_page = get_permalink( $rcp_options['rcpga_dashboard_page'] );

	$group = rcpga_get_group_by( 'membership_id', $membership->get_id() );

	if ( empty( $group ) ) {
		// Find out if a group should exist.
		if ( rcpga_is_level_group_accounts_enabled( $membership->get_object_id() ) && $membership->is_active() ) {
			?>
			<br/>
			<a href="<?php echo esc_url( add_query_arg( 'rcpga-create-group', urlencode( $membership->get_id() ), $dashboard_page ) ); ?>"><?php _e( 'Create Group', 'rcp-group-accounts' ); ?></a>
			<?php
		}

		return;
	}

	if ( $group->get_owner_id() != get_current_user_id() ) {
		return;
	}

	?>
	<br/>
	<a href="<?php echo esc_url( add_query_arg( 'rcpga-group', urlencode( $group->get_group_id() ), $dashboard_page ) ); ?>"><?php _e( 'Manage Group', 'rcp-group-accounts' ); ?></a>
	<?php

}

add_action( 'rcp_subscription_details_action_links', __NAMESPACE__ . '\membership_manage_group_link', 10, 2 );

/**
 * Display group memberships in the `[subscription_details]` shortcode.
 *
 * @since 2.0
 * @return void
 */
function group_memberships_table() {
	rcp_get_template_part( 'group', 'memberships' );
}

add_action( 'rcp_subscription_details_bottom', __NAMESPACE__ . '\group_memberships_table' );