<?php
/**
 * Scripts
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA;

/**
 * Register scripts
 *
 * @since 2.0
 * @return void
 */
function register_scripts() {
	wp_register_script( 'rcp-group-accounts', RCPGA_GROUPS_PLUGIN_URL . 'includes/assets/js/group-accounts.js', array( 'jquery' ), RCPGA_GROUPS_VERSION, true );
	wp_localize_script( 'rcp-group-accounts', 'rcpgaLevelMap', rcpga_get_group_enabled_levels() );
	wp_localize_script( 'rcp-group-accounts', 'rcpgaPerSeatPricingLevelMap', rcpga_get_group_enabled_per_seat_levels() );
	wp_localize_script( 'rcp-group-accounts', 'rcpgaVars', array(
		'per_seat' => esc_html__( 'Per Seat', 'rcp-group-accounts' )
	) );
}

add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\register_scripts' );