<?php
/**
 * Group Filters
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA;

use RCP_Membership;

/**
 * Memberships export: add a "Group Name" column.
 *
 * @param array $columns Column header names.
 *
 * @since 2.0
 * @return array
 */
function memberships_export_column_header( $columns ) {

	$columns['group_name'] = __( 'Group Name', 'rcp-group-accounts' );

	return $columns;

}

add_filter( 'rcp_export_csv_cols_members', __NAMESPACE__ . '\memberships_export_column_header' );

/**
 * Memberships export: populate the "Group Name" column value for each membership.
 *
 * @param array          $row        Array of row data.
 * @param RCP_Membership $membership Membership object.
 *
 * @since 2.0
 * @return array
 */
function memberships_export_column_value( $row, $membership ) {

	$group = rcpga_get_group_by( 'membership_id', $membership->get_id() );

	if ( empty( $group ) ) {
		return $row;
	}

	$row['group_name'] = $group->get_name();

	return $row;

}

add_filter( 'rcp_export_memberships_get_data_row', __NAMESPACE__ . '\memberships_export_column_value', 10, 2 );