<?php
/**
 * Export Functions
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license   GPL2+
 * @since     2.2
 */

namespace RCPGA\Export;

/**
 * Registers Group Accounts exporters.
 *
 * @param array $exporters
 *
 * @return array
 */
function register_exporters( $exporters ) {
	$exporters['groups'] = array(
		'name'          => __( 'Groups', 'rcp-group-accounts' ),
		'description'   => __( 'Download Group Accounts group records as a CSV file. Note: this contains group data only; it does not include membership records.', 'rcp-group-accounts' ),
		'key'           => 'groups',
		'callback'      => '\\RCPGA\\Export\\Export_Groups',
		'callback_file' => RCPGA_GROUPS_PLUGIN_DIR . 'includes/export/class-export-groups.php'
	);

	$exporters['group_members'] = array(
		'name'          => __( 'Group Members', 'rcp-group-accounts' ),
		'description'   => __( 'Download Group Accounts member as a CSV file. Note: this contains all group members across all groups. To export members from one specific group, visit the Group Details page for that group.', 'rcp-group-accounts' ),
		'key'           => 'group_members',
		'callback'      => '\\RCPGA\\Export\\Export_Group_Members',
		'callback_file' => RCPGA_GROUPS_PLUGIN_DIR . 'includes/export/class-export-group-members.php'
	);

	return $exporters;
}

add_filter( 'rcp_csv_exporters', __NAMESPACE__ . '\register_exporters' );