<?php
/**
 * Export Groups
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license   GPL2+
 * @since     2.2
 */

namespace RCPGA\Export;

use RCPGA_Group;

class Export_Groups extends \RCP\Batch\CSV_Exports\Base {

	/**
	 * Column headers
	 *
	 * @return array
	 */
	public function get_columns() {
		$columns = array(
			'id'            => esc_html__( 'Group ID', 'rcp-group-accounts' ),
			'name'          => esc_html__( 'Group Name', 'rcp-group-accounts' ),
			'description'   => esc_html__( 'Group Description', 'rcp-group-accounts' ),
			'code'          => esc_html__( 'Group Code', 'rcp-group-accounts' ),
			'seat_limit'    => esc_html__( 'Seat Limit', 'rcp-group-accounts' ),
			'member_count'  => esc_html__( 'Member Count', 'rcp-group-accounts' ),
			'date_created'  => esc_html__( 'Date Created', 'rcp-group-accounts' ),
			'owner_user_id' => esc_html__( 'Owner User ID', 'rcp-group-accounts' ),
			'owner_email'   => esc_html__( 'Owner Email', 'rcp-group-accounts' ),
			'membership_id' => esc_html__( 'Owner Membership ID', 'rcp-group-accounts' ),
		);

		/**
		 * Filters the columns to export.
		 *
		 * @param array $columns
		 *
		 * @since 2.2
		 */
		return apply_filters( 'rcpga_export_csv_cols_groups', $columns );
	}

	/**
	 * Total number of groups to export.
	 *
	 * @return int
	 */
	public function get_total() {
		return rcpga_count_groups();
	}

	/**
	 * Builds up the batch data for the current step.
	 *
	 * @return array
	 */
	public function get_batch() {
		$groups = rcpga_get_groups( array(
			'number' => $this->get_amount_per_step(),
			'offset' => $this->offset,
			'orderby' => 'group_id',
			'order' => 'ASC'
		) );

		$batch = array();

		foreach ( $groups as $group ) {
			/**
			 * @var RCPGA_Group $group
			 */
			$owner = $group->get_owner();

			$group_data = array(
				'id'            => $group->get_group_id(),
				'name'          => $group->get_name(),
				'description'   => $group->get_description(),
				'code'          => $group->get_code(),
				'seat_limit'    => $group->get_seats(),
				'member_count'  => $group->get_member_count(),
				'date_created'  => $group->get_date_created(),
				'owner_user_id' => $group->get_owner_id(),
				'owner_email'   => ! empty( $owner ) ? $owner->user_email : '',
				'membership_id' => $group->get_membership_id()
			);

			/**
			 * Filters the data for this row.
			 *
			 * @param array       $group_data Row data.
			 * @param RCPGA_Group $group      Group object.
			 *
			 * @since 2.2
			 */
			$batch[] = apply_filters( 'rcpga_export_groups_row', $group_data, $group );
		}

		return $batch;
	}
}
