<?php
/**
 * class-export-group-members.php
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Ashley Gibson
 * @license   GPL2+
 */

namespace RCPGA\Export;


use RCPGA_Group_Member;

class Export_Group_Members extends \RCP\Batch\CSV_Exports\Base {

	/**
	 * Column headers
	 *
	 * @return array
	 */
	public function get_columns() {
		$columns = array(
			'group_id'      => esc_html__( 'Group ID', 'rcp-group-accounts' ),
			'group_name'    => esc_html__( 'Group Name', 'rcp-group-accounts' ),
			'user_id'       => esc_html__( 'User ID', 'rcp-group-accounts' ),
			'username'      => esc_html__( 'User Login', 'rcp-group-accounts' ),
			'email_address' => esc_html__( 'User Email', 'rcp-group-accounts' ),
			'first_name'    => esc_html__( 'First Name', 'rcp-group-accounts' ),
			'last_name'     => esc_html__( 'Last Name', 'rcp-group-accounts' ),
			'role'          => esc_html__( 'Role', 'rcp-group-accounts' ),
			'date_added'    => esc_html__( 'Date Added', 'rcp-group-accounts' )
		);

		/**
		 * Filters the columns to export.
		 *
		 * @param array $columns
		 *
		 * @since 2.2
		 */
		return apply_filters( 'rcpga_export_csv_cols_group_members', $columns );
	}

	/**
	 * Total number of groups to export.
	 *
	 * @return int
	 */
	public function get_total() {
		$args = array();
		if ( ! empty( $this->settings['group_id'] ) ) {
			$args['group_id'] = intval( $this->settings['group_id'] );
		}

		return rcpga_count_group_members( $args );
	}

	/**
	 * Builds up the batch data for the current step.
	 *
	 * @return array
	 */
	public function get_batch() {
		$args = array(
			'number'  => $this->get_amount_per_step(),
			'offset'  => $this->offset,
			'orderby' => 'group_id',
			'order'   => 'ASC'
		);
		if ( ! empty( $this->settings['group_id'] ) ) {
			$args['group_id'] = intval( $this->settings['group_id'] );
		}

		$group_members = rcpga_get_group_members( $args );
		$group         = ! empty( $this->settings['group_id'] ) ? rcpga_get_group( intval( $this->settings['group_id'] ) ) : false;
		$batch         = array();

		foreach ( $group_members as $group_member ) {
			/**
			 * @var RCPGA_Group_Member $group_member
			 */

			$this_group = ! empty( $group ) ? $group : $group_member->get_group();
			$this_user  = get_userdata( $group_member->get_user_id() );

			$member_data = array(
				'group_id'      => $group_member->get_group_id(),
				'group_name'    => $this_group->get_name(),
				'user_id'       => $group_member->get_user_id(),
				'username'      => ! empty( $this_user ) ? $this_user->user_login : '',
				'email_address' => ! empty( $this_user ) ? $this_user->user_email : '',
				'first_name'    => ! empty( $this_user ) ? $this_user->first_name : '',
				'last_name'     => ! empty( $this_user ) ? $this_user->last_name : '',
				'role'          => rcpga_get_member_role_label( $group_member->get_role() ),
				'date_added'    => $group_member->get_date_added()
			);

			/**
			 * Filters the data for this row.
			 *
			 * @param array              $member_data Row data.
			 * @param RCPGA_Group_Member $member_data Group member object.
			 *
			 * @since 2.2
			 */
			$batch[] = apply_filters( 'rcpga_export_group_members_row', $member_data, $member_data );
		}

		return $batch;
	}
}