<?php
/**
 * Deprecated Functions
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

/**
 * Add member to group
 *
 * @param array $args
 *
 * @since
 * @return int|string
 */
function rcpga_add_member_to_group( $args ) {

	$args = wp_parse_args( $args, array(
		'user_email'  => '',
		'user_login'  => '',
		'first_name'  => '',
		'last_name'   => '',
		'user_pass'   => wp_generate_password( 24 ),
		'group_id'    => 0,
		'send_invite' => true,
		'role'        => 'rcp-invited'
	) );

	$new_args = array(
		'user_id'     => 0,
		'user_email'  => $args['user_email'],
		'user_login'  => $args['user_login'],
		'first_name'  => $args['first_name'],
		'last_name'   => $args['last_name'],
		'user_pass'   => $args['user_pass'],
		'role'        => false !== strpos( $args['role'], 'invited' ) ? 'invited' : $args['role'],
		'send_invite' => $args['send_invite']
	);

	$group_member_id = rcpga_add_group_member( absint( $args['group_id'] ), $new_args );

	if ( is_wp_error( $group_member_id ) ) {
		return $group_member_id->get_error_code();
	}

	$group_member = rcpga_get_group_member_by_id( $group_member_id );

	return $group_member->get_user_id();

}