<?php
/**
 * Deprecated Filters
 *
 * Ensures that deprecated filters continue to work.
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

/**
 * Deprecated `rcpga_get_tasks_of_role` filter. Replaced with `rcpga_get_role_capabilities`.
 */
add_filter( 'rcpga_get_role_capabilities', function ( $capabilties, $role ) {
	return apply_filters( 'rcpga_get_tasks_of_role', $capabilties, $role );
}, 10, 2 );

/**
 * Add group information to Stripe charge meta data
 *
 * @deprecated 2.0.1 In favour of add_stripe_payment_intent_args()
 * @see add_stripe_payment_intent_args()
 *
 * @param array                       $args Charge arguments.
 * @param \RCP_Payment_Gateway_Stripe $stripe_gateway
 *
 * @since 2.0
 * @return array
 */
function add_stripe_charges_args( $args, $stripe_gateway ) {

	if ( ! $group = rcpga_get_group_by( 'membership_id', $stripe_gateway->membership->get_id() ) ) {
		return $args;
	}

	$args['metadata']['rcp_group_name'] = esc_html( $group->get_name() );

	return $args;

}

if ( defined( 'RCP_PLUGIN_VERSION' ) && version_compare( RCP_PLUGIN_VERSION, '3.2', '<' ) ) {
	add_filter( 'rcp_stripe_charge_create_args', __NAMESPACE__ . '\add_stripe_charges_args', 10, 2 );
}