<?php
/**
 * Deprecated Groups Database Class
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     1.0
 */

/**
 * Class RCPGA_Groups
 *
 * @deprecated 2.0
 */
class RCPGA_Groups {

	/**
	 * Instance of this class.
	 *
	 * @var RCPGA_Groups
	 */
	protected static $_instance;

	/**
	 * Only make one instance of RCPGA_Groups
	 *
	 * @return RCPGA_Groups
	 */
	public static function get_instance() {
		if ( ! self::$_instance instanceof RCPGA_Groups ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Determines if the group is active
	 *
	 * A group is active if the group owner has an active membership.
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::is_active()`
	 * @see        RCPGA_Group::is_active()
	 *
	 * @param int $group_id
	 *
	 * @return bool
	 */
	public function is_group_active( $group_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group::is_active' );

		if ( empty( $group_id ) ) {
			return false;
		}

		$group = rcpga_get_group( $group_id );

		return $group->is_active();

	}

	/**
	 * Get the name of the group.
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::get_name()`
	 * @see        RCPGA_Group::get_name()
	 *
	 * @param int $group_id
	 *
	 * @return string
	 */
	public function get_name( $group_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group::get_name' );

		if ( empty( $group_id ) ) {
			return '';
		}

		$group = rcpga_get_group( $group_id );

		return ! empty( $group ) ? $group->get_name() : '';

	}

	/**
	 * Get the group description
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::get_description()`
	 * @see        RCPGA_Group::get_description()
	 *
	 * @param int $group_id
	 *
	 * @return string
	 */
	public function get_description( $group_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group::get_description' );

		if ( empty( $group_id ) ) {
			return '';
		}

		$group = rcpga_get_group( $group_id );

		return ! empty( $group ) ? $group->get_description() : '';

	}

	/**
	 * Get the group member count
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::get_member_count()`
	 * @see        RCPGA_Group::get_member_count()
	 *
	 * @param int $group_id
	 *
	 * @return int
	 */
	public function get_member_count( $group_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group::get_member_count' );

		if ( empty( $group_id ) ) {
			return 0;
		}

		$group = rcpga_get_group( $group_id );

		return ! empty( $group ) ? $group->get_member_count() : 0;

	}

	/**
	 * Get the number of seats
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::get_seats()`
	 * @see        RCPGA_Group::get_seats()
	 *
	 * @param int $group_id
	 *
	 * @return int
	 */
	public function get_seats_count( $group_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group::get_seats' );

		if ( empty( $group_id ) ) {
			return 0;
		}

		$group = rcpga_get_group( $group_id );

		return ! empty( $group ) ? $group->get_seats() : 0;

	}

	/**
	 * Get the group owner ID
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::get_owner_id()`
	 * @see        RCPGA_Group::get_owner_id()
	 *
	 * @param int $group_id
	 *
	 * @return int
	 */
	public function get_owner_id( $group_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group::get_owner_id' );

		if ( empty( $group_id ) ) {
			return 0;
		}

		$group = rcpga_get_group( $group_id );

		return ! empty( $group ) ? $group->get_owner_id() : 0;

	}

	/**
	 * Get the ID of the corresponding membership record
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::get_membership_id()`
	 * @see        RCPGA_Group::get_membership_id()
	 *
	 * @param int $group_id
	 *
	 * @return int
	 */
	public function get_membership_id( $group_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group::get_membership_id' );

		if ( empty( $group_id ) ) {
			return 0;
		}

		$group = rcpga_get_group( $group_id );

		return ! empty( $group ) ? $group->get_membership_id() : 0;

	}

	/**
	 * Get group by owner ID
	 *
	 * @deprecated 2.0 In favour of `rcpga_get_groups()`
	 * @see        rcpga_get_groups()
	 *
	 * @param int $owner_id
	 *
	 * @return RCPGA_Group|false
	 */
	public function get_group_by_owner( $owner_id ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_get_groups' );

		$groups = rcpga_get_groups( array(
			'owner_id' => absint( $owner_id ),
			'number'   => 1
		) );

		if ( empty( $groups ) || empty( $groups[0] ) ) {
			return false;
		}

		return $groups[0];

	}

	/**
	 * Return group role
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::get_membership_role()`
	 * @see        RCPGA_Group::get_membership_role()
	 *
	 * @param int $group_id
	 *
	 * @return string|false
	 */
	public function get_group_role( $group_id ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group::get_membership_role' );

		$group = rcpga_get_group( $group_id );

		return ! empty( $group ) ? $group->get_membership_role() : false;

	}

	/**
	 * Retrieve groups from the database
	 *
	 * @deprecated 2.0 In favour of `rcpga_get_groups()`
	 * @see        rcpga_get_groups()
	 *
	 * @param array $args
	 *
	 * @return array
	 */
	public function get_groups( $args = array() ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_get_groups' );

		$defaults = array(
			'number'  => 20,
			'offset'  => 0,
			'order'   => 'DESC',
			'orderby' => 'group_id'
		);

		$args = wp_parse_args( $args, $defaults );

		if ( $args['number'] < 1 ) {
			$args['number'] = 999999999999;
		}

		return rcpga_get_groups( $args );

	}

	/**
	 * Retrieve count of groups from the database
	 *
	 * @deprecated 2.0 In favour of `rcpga_count_groups()`
	 * @see        rcpga_count_groups()
	 *
	 * @return int
	 */
	public function get_group_count() {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_count_groups' );

		return rcpga_count_groups();

	}

	/**
	 * Get a group
	 *
	 * @deprecated 2.0 In favour of `rcpga_get_group()`
	 * @see        rcpga_get_group()
	 *
	 * @param int $group_id
	 *
	 * @return RCPGA_Group|false
	 */
	public function get( $group_id ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_get_group' );

		return rcpga_get_group( $group_id );

	}

	/**
	 * Get a group by column value
	 *
	 * @deprecated 2.0 In favour of `rcpga_get_group_by()`
	 * @see        rcpga_get_group_by()
	 *
	 * @param string $column The column to search.
	 * @param mixed  $row_id The value to search for.
	 *
	 * @return RCPGA_Group|false
	 */
	public function get_by( $column, $row_id ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_get_group_by' );

		return rcpga_get_group_by( $column, $row_id );

	}

	/**
	 * Get a single value from a group.
	 *
	 * @deprecated 2.0
	 *
	 * @param string $column The value to retrieve.
	 * @param int    $row_id The row ID.
	 *
	 * @return mixed|false
	 */
	public function get_column( $column, $row_id ) {

		_deprecated_function( __METHOD__, '2.0' );

		$group = rcpga_get_group( $row_id );

		if ( empty( $group ) ) {
			return false;
		}

		if ( ! method_exists( $group, 'get_' . $column ) ) {
			return false;
		}

		return call_user_func( array( $group, 'get_' . $column ) );

	}

	/**
	 * Search for a value in the table
	 *
	 * @deprecated 2.0
	 *
	 * @param string $column       Name of the column to retrieve the value of.
	 * @param string $column_where The column to search.
	 * @param mixed  $column_value The value to search for.
	 *
	 * @return mixed
	 */
	public function get_column_by( $column, $column_where, $column_value ) {

		_deprecated_function( __METHOD__, '2.0' );

		$query = new \RCP\Database\Queries\Groups();

		$results = $query->get_results( array( $column ), array(
			$column_where => $column_value
		), 1 );

		if ( empty( $results ) || ! is_array( $results ) ) {
			return false;
		}

		return reset( $results );

	}

	/**
	 * Adds a new group
	 *
	 * @deprecated 2.0 In favour of `rcpga_add_group()`
	 * @see        rcpga_add_group()
	 *
	 * @param array $args
	 *
	 * @return int|false
	 */
	public function add( $args = array() ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_add_group' );

		$defaults = array(
			'owner_id'      => 0,
			'membership_id' => 0,
			'description'   => '',
			'name'          => '',
			'seats'         => 0,
			'member_count'  => 0,
			'date_created'  => current_time( 'mysql' ),
		);

		$args = wp_parse_args( $args, $defaults );

		$result = rcpga_add_group( $args );

		if ( is_wp_error( $result ) ) {
			$result = false;
		}

		return $result;

	}

	/**
	 * Update a group
	 *
	 * @deprecated 2.0 In favour of `rcpga_update_group()`
	 * @see        rcpga_update_group()
	 *
	 * @param int    $row_id Row ID to update.
	 * @param array  $data   Array of data to update.
	 * @param string $where  Where clause.
	 *
	 * @return bool
	 */
	public function update( $row_id, $data = array(), $where = '' ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_update_group' );

		return rcpga_update_group( $row_id, $data );

	}

	/**
	 * Delete a group
	 *
	 * @deprecated 2.0 In favour of `rcpga_delete_group()`
	 * @see        rcpga_delete_group()
	 *
	 * @param int $row_id
	 *
	 * @return bool
	 */
	public function delete( $row_id ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_delete_group' );

		return rcpga_delete_group( $row_id );

	}

	/**
	 * Update the group's member count
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::update_member_count()`
	 * @see        RCPGA_Group::update_member_count()
	 *
	 * @param int $group_id
	 *
	 * @return int
	 */
	public function update_count( $group_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group::update_member_count' );

		if ( empty( $group_id ) ) {
			return 0;
		}

		$group = rcpga_get_group( $group_id );

		if ( ! empty( $group ) ) {
			$group->update_member_count();

			return $group->get_member_count();
		}

		return 0;

	}

}