<?php
/**
 * Deprecated Group Members Database Class
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     1.0
 */

/**
 * Class RCPGA_Group_Members
 *
 * @deprecated 2.0
 */
class RCPGA_Group_Members {

	/**
	 * Instance of this class.
	 *
	 * @var RCPGA_Group_Members
	 */
	protected static $_instance;

	/**
	 * Only make one instance of RCPGA_Group_Members
	 *
	 * @return RCPGA_Group_Members
	 */
	public static function get_instance() {
		if ( ! self::$_instance instanceof RCPGA_Group_Members ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Get the members of a group
	 *
	 * @deprecated 2.0 In favour of `rcpga_get_group_members()`
	 * @see        rcpga_get_group_members()
	 *
	 * @param int   $group_id
	 * @param array $args
	 *
	 * @return array
	 */
	public function get_members( $group_id = 0, $args = array() ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_get_group_members' );

		$defaults = array(
			'number' => 20,
			'offset' => 0
		);

		$args = wp_parse_args( $args, $defaults );

		if ( empty( $group_id ) && empty( $args['user_id'] ) ) {
			return array();
		}

		$args['group_id'] = absint( $group_id );

		if ( $args['number'] < 1 ) {
			$args['number'] = 999999999999;
		}

		return rcpga_get_group_members( $args );

	}

	/**
	 * Count the number of members in a group
	 *
	 * @deprecated 2.0 In favour of `rcpga_count_group_members()`
	 * @see        rcpga_count_group_members()
	 *
	 * @param int   $group_id
	 * @param array $args
	 *
	 * @return int
	 */
	public function count( $group_id = 0, $args = array() ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_count_group_members' );

		$args = wp_parse_args( $args, array(
			'group_id' => absint( $group_id )
		) );

		return rcpga_count_group_members( $args );

	}

	/**
	 * Determine if the user is a member of a group
	 *
	 * @deprecated 2.0 In favour of `rcpga_user_is_group_member()`
	 * @see        rcpga_user_is_group_member()
	 *
	 * @param int $user_id
	 *
	 * @return bool
	 */
	public function is_group_member( $user_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_user_is_group_member' );

		if ( empty( $user_id ) ) {
			$user_id = get_current_user_id();
		}

		return rcpga_user_is_group_member( $user_id, 'member' );

	}

	/**
	 * Determine if the user is an admin of a group
	 *
	 * @deprecated 2.0 In favour of `rcpga_user_is_group_member()`
	 * @see        rcpga_user_is_group_member()
	 *
	 * @param int $user_id
	 *
	 * @return bool
	 */
	public function is_group_admin( $user_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_user_is_group_member' );

		if ( empty( $user_id ) ) {
			$user_id = get_current_user_id();
		}

		return rcpga_user_is_group_member( $user_id, 'admin' );

	}

	/**
	 * Determine if the user is an owner of a group
	 *
	 * @deprecated 2.0 In favour of `rcpga_user_is_group_member()`
	 * @see        rcpga_user_is_group_member()
	 *
	 * @param int $user_id
	 *
	 * @return bool
	 */
	public function is_group_owner( $user_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_user_is_group_member' );

		if ( empty( $user_id ) ) {
			$user_id = get_current_user_id();
		}

		return rcpga_user_is_group_member( $user_id, 'owner' );

	}

	/**
	 * Get a user's single group membership record. If a user has multiple records then just
	 * the first result is used.
	 *
	 * @param int $user_id
	 *
	 * @since 2.0
	 * @return RCPGA_Group_Member|false
	 */
	protected function get_user_single_membership( $user_id ) {

		if ( empty( $user_id ) ) {
			$user_id = get_current_user_id();
		}

		$members = rcpga_get_group_members( array(
			'user_id' => $user_id,
			'number'  => 1
		) );

		if ( empty( $members ) || empty( $members[0] ) ) {
			return false;
		}

		/**
		 * @var RCPGA_Group_Member $member
		 */
		$member = $members[0];

		return $member;

	}

	/**
	 * Get the member role
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group_Member::get_role()`
	 * @see        RCPGA_Group_Member::get_role()
	 *
	 * @param $user_id
	 *
	 * @return string|false
	 */
	public function get_role( $user_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group_Member::get_role' );

		$member = $this->get_user_single_membership( $user_id );

		return ! empty( $member ) ? $member->get_role() : false;

	}

	/**
	 * Get the group name for this member
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group::get_name()`
	 * @see        RCPGA_Group::get_name()
	 *
	 * @param int $user_id
	 *
	 * @return string|false
	 */
	public function get_group_name( $user_id = 0 ) {

		$member = $this->get_user_single_membership( $user_id );

		if ( empty( $member ) ) {
			return false;
		}

		$group = $member->get_group();

		if ( empty( $group ) ) {
			return false;
		}

		return $group->get_name();

	}

	/**
	 * Get the group ID for this member
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group_Member::get_group_id()`
	 * @see        RCPGA_Group_Member::get_group_id()
	 *
	 * @param int $user_id
	 *
	 * @return int|false
	 */
	public function get_group_id( $user_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group_Member::get_group_id' );

		$member = $this->get_user_single_membership( $user_id );

		if ( empty( $member ) ) {
			return false;
		}

		$group = $member->get_group();

		if ( empty( $group ) ) {
			return false;
		}

		return $group->get_group_id();

	}

	/**
	 * Get a group member
	 *
	 * @deprecated 2.0 In favour of `rcpga_get_group_member()`
	 * @see        rcpga_get_group_member()
	 *
	 * @param int $user_id
	 *
	 * @return RCPGA_Group_Member|false
	 */
	public function get( $user_id ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_get_group_member' );

		$member = $this->get_user_single_membership( $user_id );

		if ( empty( $member ) ) {
			return false;
		}

		return rcpga_get_group_member( $user_id, $member->get_group_id() );

	}

	/**
	 * Get a group member by column value
	 *
	 * @deprecated 2.0
	 *
	 * @param string $column The column to search.
	 * @param mixed  $row_id The value to search for.
	 *
	 * @return RCPGA_Group_Member|false
	 */
	public function get_by( $column, $row_id ) {

		_deprecated_function( __METHOD__, '2.0' );

		$query = new \RCP\Database\Queries\Group_Members();

		return $query->get_item_by( $column, $row_id );

	}

	/**
	 * Get a single value from a group member.
	 *
	 * @deprecated 2.0
	 *
	 * @param string $column The value to retrieve.
	 * @param int    $row_id The row ID.
	 *
	 * @return mixed|false
	 */
	public function get_column( $column, $row_id ) {

		_deprecated_function( __METHOD__, '2.0' );

		$member = $this->get_user_single_membership( $row_id );

		if ( ! method_exists( $member, 'get_' . $column ) ) {
			return false;
		}

		return call_user_func( array( $member, 'get_' . $column ) );

	}

	/**
	 * Search for a value in the table
	 *
	 * @deprecated 2.0
	 *
	 * @param string $column       Name of the column to retrieve the value of.
	 * @param string $column_where The column to search.
	 * @param mixed  $column_value The value to search for.
	 *
	 * @return mixed
	 */
	public function get_column_by( $column, $column_where, $column_value ) {

		_deprecated_function( __METHOD__, '2.0' );

		$query = new \RCP\Database\Queries\Group_Members();

		$results = $query->get_results( array( $column ), array(
			$column_where => $column_value
		), 1 );

		if ( empty( $results ) || ! is_array( $results ) ) {
			return false;
		}

		return reset( $results );

	}

	/**
	 * Adds a new member to a group
	 *
	 * @deprecated 2.0 In favour of `rcpga_add_group_member()`
	 * @see        rcpga_add_group_member()
	 *
	 * @param array $args
	 *
	 * @return int|false
	 */
	public function add( $args = array() ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_add_group_member' );

		$defaults = array(
			'user_id'    => 0,
			'group_id'   => 0,
			'role'       => 'member',
			'date_added' => current_time( 'mysql' ),
		);

		$args = wp_parse_args( $args, $defaults );

		if ( empty( $args['user_id'] ) || empty( $args['group_id'] ) ) {
			return false;
		}

		$group_member_id = rcpga_add_group_member( $args['group_id'], $args );

		if ( is_wp_error( $group_member_id ) ) {
			return false;
		}

		return $args['user_id'];

	}

	/**
	 * Update a group member
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group_Member::update()`
	 * @see        RCPGA_Group_Member::update()
	 *
	 * @param int    $row_id Row ID to update.
	 * @param array  $data   Array of data to update.
	 * @param string $where  Where clause.
	 *
	 * @return bool
	 */
	public function update( $row_id, $data = array(), $where = '' ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group_Member::update' );

		$member = $this->get_user_single_membership( $row_id );

		if ( empty( $member ) ) {
			return false;
		}

		return $member->update( $data );

	}

	/**
	 * Delete a group member
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group_Member::remove()`
	 * @see        RCPGA_Group_Member::remove()
	 *
	 * @param int $row_id
	 *
	 * @return bool
	 */
	public function delete( $row_id ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group_Member::remove' );

		$member = $this->get_user_single_membership( $row_id );

		if ( empty( $member ) ) {
			return false;
		}

		$member->remove();

		return true;

	}

	/**
	 * Removes a user from their group
	 *
	 * @deprecated 2.0 In favour of `RCPGA_Group_Member::remove()`
	 * @see        RCPGA_Group_Member::remove()
	 *
	 * @param int $user_id
	 *
	 * @return bool
	 */
	public function remove( $user_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'RCPGA_Group_Member::remove' );

		if ( empty( $user_id ) ) {
			return false;
		}

		$group = $this->get_user_single_membership( $user_id );

		if ( empty( $group ) ) {
			return false;
		}

		$group->remove();

		return true;

	}

	/**
	 * Removes all members from a specific group.
	 *
	 * @deprecated 2.0 In favour of `rcpga_delete_all_members_of_group()`
	 * @see        rcpga_delete_all_members_of_group()
	 *
	 * @param int $group_id
	 *
	 * @return bool
	 */
	public function remove_all_from_group( $group_id = 0 ) {

		_deprecated_function( __METHOD__, '2.0', 'rcpga_delete_all_members_of_group' );

		if ( empty( $group_id ) ) {
			return false;
		}

		$result = rcpga_delete_all_members_of_group( $group_id );

		if ( false === $result ) {
			return false;
		}

		return true;

	}

}