<?php
/**
 * Group Members Schema Class
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCP\Database\Schemas;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

use RCP\Database\Schema;

/**
 * Group Members Schema Class
 *
 * @package RCP\Database\Tables
 * @since   2.0
 */
class Group_Members extends Schema {

	/**
	 * Array of database column objects
	 *
	 * @var array
	 * @since  2.0
	 * @access public
	 */
	public $columns = array(

		// id
		array(
			'name'     => 'id',
			'type'     => 'bigint',
			'length'   => '20',
			'unsigned' => true,
			'sortable' => true,
			'primary'  => true,
			'default'  => 0
		),

		// user_id
		array(
			'name'     => 'user_id',
			'type'     => 'bigint',
			'length'   => '20',
			'unsigned' => true,
			'sortable' => true,
			'default'  => 0
		),

		// group_id
		array(
			'name'     => 'group_id',
			'type'     => 'bigint',
			'length'   => '20',
			'unsigned' => true,
			'sortable' => true,
			'default'  => 0
		),

		// role
		array(
			'name'       => 'role',
			'type'       => 'tinytext',
			'sortable'   => true,
			'default'    => '',
			'transition' => true
		),

		// activation_key
		array(
			'name'    => 'activation_key',
			'type'    => 'varchar',
			'length'  => '255',
			'default' => '',
		),

		// date_added
		array(
			'name'       => 'date_added',
			'type'       => 'datetime',
			'default'    => '0000-00-00 00:00:00',
			'date_query' => true,
			'sortable'   => true
		)

	);

}