<?php
/**
 * Group Member Query Class
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCP\Database\Queries;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

use RCP\Database\Query;

/**
 * Class used for querying group members
 *
 * @see     \RCP\Database\Queries\Group_Members::__construct() for accepted arguments.
 * @package RCP\Database\Queries
 * @since   2.0
 */
class Group_Members extends Query {

	/** Table Properties ******************************************************/

	/**
	 * Name of the database table to query.
	 *
	 * @since  2.0
	 * @access public
	 * @var string
	 */
	protected $table_name = 'group_members';

	/**
	 * String used to alias the database table in MySQL statement.
	 *
	 * @since  2.0
	 * @access public
	 * @var string
	 */
	protected $table_alias = 'gagm';

	/**
	 * Name of class used to setup the database schema
	 *
	 * @since  2.0
	 * @access public
	 * @var string
	 */
	protected $table_schema = '\\RCP\\Database\\Schemas\\Group_Members';

	/** Item ******************************************************************/

	/**
	 * Name for a single item
	 *
	 * @since  2.0
	 * @access public
	 * @var string
	 */
	protected $item_name = 'group_member';

	/**
	 * Plural version for a group of items.
	 *
	 * @since  2.0
	 * @access public
	 * @var string
	 */
	protected $item_name_plural = 'group_members';

	/**
	 * Callback function for turning IDs into objects
	 *
	 * @since  2.0
	 * @access public
	 * @var mixed
	 */
	protected $item_shape = '\\RCPGA_Group_Member';

	/**
	 * Group to cache queries and queried items in.
	 *
	 * @since  2.0
	 * @access public
	 * @var string
	 */
	protected $cache_group = 'group_members';

	/**
	 * Sets up the group query, based on the query vars passed.
	 *
	 * @param string|array $query                   {
	 *                                              Optional. Array or query string of membership query parameters.
	 *                                              Default empty.
	 *
	 * @type int           $id                      A group member ID to only return that member. Default empty.
	 * @type array         $id__in                  Array of member IDs to include. Default empty.
	 * @type array         $id__not_in              Array of group member IDs to exclude. Default empty.
	 * @type int           $user_id                 A user ID to filter by. Default empty.
	 * @type array         $user_id__in             Array of user IDs to include. Default empty.
	 * @type array         $user_id__not_in         Array of user IDs to exclude. Default empty.
	 * @type int           $group_id                A group ID to filter by. Default empty.
	 * @type array         $group_id_in             Array of group IDs to include. Default empty.
	 * @type array         $group_id__not_in        Array of group IDs to exclude. Default empty.
	 * @type string        $role                    A specific member role to search for. Default empty.
	 * @type array         $role__in                Filter by roles. Default empty.
	 * @type array         $role__not_in            Array of roles to exclude. Default empty.
	 * @type array         $date_query              Query all datetime columns together. See WP_Date_Query.
	 * @type array         $date_created_query      Date query clauses to limit groups by. See WP_Date_Query.
	 *                                              Default null.
	 * @type bool          $count                   Whether to return a group member count (true) or array of group
	 *                                              member objects. Default false.
	 * @type string        $fields                  Item fields to return. Accepts any column known names
	 *                                              or empty (returns an array of complete group member objects).
	 *                                              Default empty.
	 * @type int           $number                  Limit number of group members to retrieve. Default 100.
	 * @type int           $offset                  Number of group members to offset the query. Used to build LIMIT
	 *                                              clause. Default 0.
	 * @type bool          $no_found_rows           Whether to disable the `SQL_CALC_FOUND_ROWS` query. Default true.
	 * @type string|array  $orderby                 Accepts 'user_id', 'group_id', 'role', and 'date_created'.
	 *                                              Also accepts false, an empty array, or 'none' to disable
	 *                                              `ORDER BY` clause. Default 'user_id'.
	 * @type string        $order                   How to order results. Accepts 'ASC', 'DESC'. Default 'DESC'.
	 * @type string        $search                  Search term(s) to retrieve matching group members for. Default
	 *                                              empty.
	 * @type bool          $update_cache            Whether to prime the cache for found group members. Default false.
	 * }
	 *
	 * @access public
	 * @since  2.0
	 */
	public function __construct( $query = array() ) {
		parent::__construct( $query );
	}

}