<?php
/**
 * Groups Schema Class
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCP\Database\Schemas;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

use RCP\Database\Schema;

/**
 * Groups Schema Class
 *
 * @package RCP\Database\Tables
 * @since   2.0
 */
class Groups extends Schema {

	/**
	 * Array of database column objects
	 *
	 * @var array
	 * @since  2.0
	 * @access public
	 */
	public $columns = array(

		// group_id
		array(
			'name'     => 'group_id',
			'type'     => 'bigint',
			'length'   => '20',
			'unsigned' => true,
			'extra'    => 'auto_increment',
			'primary'  => true,
			'sortable' => true
		),

		// owner_id
		array(
			'name'     => 'owner_id',
			'type'     => 'bigint',
			'length'   => '20',
			'unsigned' => true,
			'sortable' => true,
			'default'  => 0
		),

		// membership_id
		array(
			'name'     => 'membership_id',
			'type'     => 'bigint',
			'length'   => '20',
			'unsigned' => true,
			'sortable' => true,
			'default'  => 0
		),

		// name
		array(
			'name'       => 'name',
			'type'       => 'mediumtext',
			'sortable'   => true,
			'searchable' => true,
			'default'    => ''
		),

		// description
		array(
			'name'    => 'description',
			'type'    => 'longtext',
			'default' => ''
		),

		// code
		array(
			'name'       => 'code',
			'type'       => 'varchar',
			'length'     => '255',
			'sortable'   => true,
			'searchable' => true,
			'default'    => ''
		),

		// seats
		array(
			'name'     => 'seats',
			'type'     => 'bigint',
			'length'   => '20',
			'unsigned' => true,
			'sortable' => true,
			'default'  => 0
		),

		// member_count
		array(
			'name'     => 'member_count',
			'type'     => 'bigint',
			'length'   => '20',
			'unsigned' => true,
			'sortable' => true,
			'default'  => 1
		),

		// date_created
		array(
			'name'       => 'date_created',
			'type'       => 'datetime',
			'default'    => '0000-00-00 00:00:00',
			'date_query' => true,
			'sortable'   => true
		)

	);

}