<?php
/**
 * Group Meta Table
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.1
 */

namespace RCP\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

use RCP\Database\Table;

/**
 * Class Group_Meta
 *
 * @package RCP\Database\Tables
 */
class Group_Meta extends Table {

	/**
	 * @var string Table name
	 */
	protected $name = 'groupmeta';

	/**
	 * @var int Current database version
	 */
	protected $version = 201905231;

	/**
	 * @var array Array of upgrade versions and methods
	 */
	protected $upgrades = array();

	/**
	 * Setup the database schema
	 *
	 * @access protected
	 * @since  2.1
	 * @return void
	 */
	protected function set_schema() {
		$max_index_length = 191;
		$this->schema     = "meta_id bigint(20) unsigned NOT NULL auto_increment,
		rcp_group_id bigint(20) unsigned NOT NULL default '0',
		meta_key varchar(255) DEFAULT NULL,
		meta_value longtext DEFAULT NULL,
		PRIMARY KEY (meta_id),
		KEY rcp_group_id (rcp_group_id),
		KEY meta_key (meta_key({$max_index_length}))";
	}

}