/*global jQuery, document, rcpga_group_vars*/
/*jslint newcap: true*/
jQuery( document ).ready( function ( $ ) {
	'use strict';

	const seatPricingType = $( '#rcpga-group-seat-pricing-type' );
	const seatCount = $( '#rcpga-group-seats' );
	const minSeats = $( '#rcpga-group-min-seats' );
	const maxSeats = $( '#rcpga-group-max-seats' );

	$( '#rcpga-group-seats-allow' ).on( 'change', function () {
		if ( $( this ).prop( 'checked' ) ) {
			// Show seat pricing type.
			seatPricingType.trigger( 'change' ).parents( 'tr' ).css( 'display', 'table-row' );
		} else {
			// Hide all Group Accounts fields.
			seatPricingType.parents( 'tr' ).css( 'display', 'none' );
			seatCount.parents( 'tr' ).css( 'display', 'none' );
			minSeats.parents( 'tr' ).css( 'display', 'none' );
			maxSeats.parents( 'tr' ).css( 'display', 'none' );
		}
	} ).trigger( 'change' );

	seatPricingType.on( 'change', function ( e ) {
		if ( 'fixed' === $( this ).val() ) {
			// Show seat count.
			seatCount.parents( 'tr' ).css( 'display', 'table-row' );

			// Hide `per_seat` fields.
			minSeats.parents( 'tr' ).css( 'display', 'none' );
			maxSeats.parents( 'tr' ).css( 'display', 'none' );
		} else {
			// Hide seat count.
			seatCount.parents( 'tr' ).css( 'display', 'none' );

			// Show `per_seat` fields.
			minSeats.parents( 'tr' ).css( 'display', 'table-row' );
			maxSeats.parents( 'tr' ).css( 'display', 'table-row' );
		}
	} );

	$( '#rcpga-add-member-is-new' ).on( 'change', function () {
		if ( $( this ).is( ':checked' ) ) {
			$( '.rcpga-new-member-field' ).parents( 'tr' ).css( 'display', 'table-row' );
		} else {
			$( '.rcpga-new-member-field' ).parents( 'tr' ).css( 'display', 'none' );
		}
	} ).trigger( 'change' );

	$( '.rcpga-group-delete' ).on( 'click', function ( e ) {

		if ( !confirm( rcpga_group_vars.delete_group ) ) {
			return false;
		}
	} );

	$( '.rcp-member-delete' ).on( 'click', function ( e ) {

		if ( !confirm( rcpga_group_vars.delete_member ) ) {
			return false;
		}
	} );

	$( '.rcpga-make-owner' ).on( 'click', function ( e ) {
		if ( !confirm( rcpga_group_vars.make_owner ) ) {
			return false;
		}
	} );

	$( '#rcpga-change-admin-user-select' ).on( 'change', function () {
		console.log('select changed');
		$( '#change-admin-submit' ).attr( 'href', $( this ).val() );
	});

	$( '#change-admin-submit' ).on( 'click', function (e) {
		if ( !confirm( rcpga_group_vars.make_admin) ) {
			return false;
		}
	});
} );
