<?php
/**
 * Add-On Settings
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA\Admin\Settings;

/**
 * Add settings for the group invite email
 *
 * @param array $rcp_options
 *
 * @since 2.0
 * @return void
 */
function invite_email( $rcp_options ) {

	?>
	<table class="form-table">
		<tr valign="top">
			<th colspan=2>
				<h3><?php _e( 'Group Invite Email', 'rcp-group-accounts' ); ?></h3>
			</th>
		</tr>
		<tr>
			<th>
				<label for="rcp_settings[disable_group_invite_email]"><?php _e( 'Disabled', 'rcp' ); ?></label>
			</th>
			<td>
				<p>
					<input type="checkbox" value="1" name="rcp_settings[disable_group_invite_email]" id="rcp_settings[disable_group_invite_email]" <?php checked( isset( $rcp_options['disable_group_invite_email'] ) ); ?>/>
					<span><?php _e( 'Check this to disable the email sent out when a member is invited to a group.', 'rcp-group-accounts' ); ?></span>
				</p>
				<p>
					<input type="checkbox" value="1" name="rcp_settings[disable_group_welcome_email]" id="rcp_settings[disable_group_welcome_email]" <?php checked( isset( $rcp_options['disable_group_welcome_email'] ) ); ?>/>
					<span><?php _e( 'Check this to disable the new user welcome email sent out when a new member accepts an invite link.', 'rcp-group-accounts' ); ?></span>
				</p>
			</td>
		</tr>
		<tr valign="top">
			<th>
				<label for="rcp_settings[group_invite_subject]"><?php _e( 'Subject', 'rcp' ); ?></label>
			</th>
			<td>
				<input type="text" class="regular-text" id="rcp_settings[group_invite_subject]" style="width: 300px;" name="rcp_settings[group_invite_subject]" value="<?php echo ! empty( $rcp_options['group_invite_subject'] ) ? esc_attr( $rcp_options['group_invite_subject'] ) : ''; ?>"/>
				<p class="description"><?php _e( 'The subject line for the email sent out when a member is invited to a group.', 'rcp-group-accounts' ); ?></p>
			</td>
		</tr>
		<tr valign="top">
			<th>
				<label for="rcp_settings[group_invite_email]"><?php _e( 'Email Body', 'rcp' ); ?></label>
			</th>
			<td>
				<?php
				$invite_email = isset( $rcp_options['group_invite_email'] ) ? $rcp_options['group_invite_email'] : '';

				wp_editor( $invite_email, 'rcp_settings_group_invite_email', array(
					'textarea_name' => 'rcp_settings[group_invite_email]',
					'teeny'         => true
				) );
				?>
				<p class="description"><?php _e( 'This is the email message that is sent out when a member is invited to a group.', 'rcp-group-accounts' ); ?></p>
			</td>
		</tr>
	</table>
	<?php

}

add_action( 'rcp_email_settings', __NAMESPACE__ . '\invite_email' );

/**
 * Add settings to Restrict > Settings > Misc.
 *
 * @since 2.0
 * @return void
 */
function misc_settings() {

	global $rcp_options;

	$pages          = get_pages();
	$dashboard_page = ! empty( $rcp_options['rcpga_dashboard_page'] ) ? $rcp_options['rcpga_dashboard_page'] : 0;
	$remove_pending = ! empty( $rcp_options['groups_delete_pending_invites'] ) ? $rcp_options['groups_delete_pending_invites'] : 0;
	?>
	<table class="form-table">
		<tr>
			<th colspan="2">
				<h3><?php _e( 'Group Accounts', 'rcp-group-accounts' ); ?></h3>
			</th>
		</tr>
		<tr valign="top">
			<th>
				<label for="rcp_settings[rcpga_dashboard_page]"><?php _e( 'Group Dashboard Page', 'rcp' ); ?></label>
			</th>
			<td>
				<select id="rcp_settings[rcpga_dashboard_page]" name="rcp_settings[rcpga_dashboard_page]">
					<?php
					if ( $pages ) :
						?>
						<option value=""><?php _e( 'None', 'rcp-group-accounts' ); ?></option>
						<?php
						foreach ( $pages as $page ) {
							$option = '<option value="' . esc_attr( $page->ID ) . '" ' . selected( $page->ID, $dashboard_page, false ) . '>';
							$option .= esc_html( $page->post_title );
							$option .= ' (ID: ' . $page->ID . ')';
							$option .= '</option>';
							echo $option;
						}
					else :
						echo '<option>' . __( 'No pages found', 'rcp-group-accounts' ) . '</option>';
					endif;
					?>
				</select>
				<?php if ( ! empty( $dashboard_page ) ) : ?>
					<a href="<?php echo esc_url( get_edit_post_link( $dashboard_page ) ); ?>" class="button-secondary"><?php _e( 'Edit Page', 'rcp-group-accounts' ); ?></a>
					<a href="<?php echo esc_url( get_permalink( $dashboard_page ) ); ?>" class="button-secondary"><?php _e( 'View Page', 'rcp-group-accounts' ); ?></a>
				<?php endif; ?>
				<p class="description"><?php printf( __( 'Choose the primary group dashboard page. This must contain the [rcp_group_dashboard] short code. <a href="%s" target="_blank">See documentation</a>.', 'rcp-group-accounts' ), 'https://docs.restrictcontentpro.com/article/1631-group-accounts-shortcodes' ); ?></p>
			</td>
		</tr>
		<tr valign="top">
			<th>
				<label for="rcp_settings[groups_allow_member_removal]"><?php _e( 'Allow Group Members to Leave', 'rcp-group-accounts' ); ?></label>
			</th>
			<td>
				<input type="checkbox" id="rcp_settings[groups_allow_member_removal]" name="rcp_settings[groups_allow_member_removal]" value="1" <?php checked( ! empty( $rcp_options['groups_allow_member_removal'] ) ); ?>/>
				<span class="description"><?php _e( 'Check this on to allow group members to leave their group.', 'rcp-group-accounts' ); ?></span>
			</td>
		</tr>
		<tr valign="top">
			<th>
				<label for="rcp_settings[groups_delete_pending_invites]"><?php _e( 'Delete Pending Invites', 'rcp-group-accounts' ); ?></label>
			</th>
			<td>
				<select id="rcp_settings[groups_delete_pending_invites]" name="rcp_settings[groups_delete_pending_invites]">
					<option value="0" <?php selected( $remove_pending, 0 ); ?>><?php _e( 'Never delete', 'rcp-group-accounts' ); ?></option>
					<option value="-1 day" <?php selected( $remove_pending, '-1 day' ); ?>><?php _e( 'Delete after 1 day', 'rcp-group-accounts' ); ?></option>
					<option value="-3 day" <?php selected( $remove_pending, '-3 days' ); ?>><?php _e( 'Delete after 3 days', 'rcp-group-accounts' ); ?></option>
					<option value="-7 days" <?php selected( $remove_pending, '-7 days' ); ?>><?php _e( 'Delete after 7 days', 'rcp-group-accounts' ); ?></option>
					<option value="-14 days" <?php selected( $remove_pending, '-14 days' ); ?>><?php _e( 'Delete after 14 days', 'rcp-group-accounts' ); ?></option>
					<option value="-1 month" <?php selected( $remove_pending, '-1 month' ); ?>><?php _e( 'Delete after 1 month', 'rcp-group-accounts' ); ?></option>
				</select>
				<p class="description"><?php _e( 'If a group invitation is not accepted after the defined period, the invitation will be deleted. Select "Never delete" to never delete pending invitations.', 'rcp-group-accounts' ); ?></p>
			</td>
		</tr>
		<tr valign="top">
			<th>
				<label for="rcp_settings[groups_allow_member_registration]"><?php _e( 'Allow Group Member Registration', 'rcp' ); ?></label>
			</th>
			<td>
				<input type="checkbox" id="rcp_settings[groups_allow_member_registration]" name="rcp_settings[groups_allow_member_registration]" value="1" <?php checked( ! empty( $rcp_options['groups_allow_member_registration'] ) ); ?>/>
				<span class="description"><?php printf( __( 'Check this on to allow users to register for groups without receiving an invite. This will enable a new "code" field for group owners. Users will have to enter the correct code to join a group. If enabled, you also need to create a page with the shortcode [rcp_group_join_form]. <a href="%s" target="_blank">See documentation</a>.', 'rcp-group-accounts' ), 'https://docs.restrictcontentpro.com/article/2264-group-accounts-group-member-registration' ); ?></span>
			</td>
		</tr>
		<tr valign="top">
			<th>
				<label for="rcp_settings[group_join_page]">&nbsp;&mdash;&nbsp;<?php _e( 'Group Join Page', 'rcp' ); ?></label>
			</th>
			<td>
				<select id="rcp_settings[group_join_page]" name="rcp_settings[group_join_page]">
					<?php
					$pages = get_pages();
					$selected_page = isset( $rcp_options['group_join_page'] ) ? absint( $rcp_options['group_join_page'] ) : 0;
					if( $pages ) {
						foreach ( $pages as $page ) {
							$option = '<option value="' . esc_attr( $page->ID ) . '" ' . selected( $page->ID, $selected_page, false ) . '>';
							$option .= esc_html( $page->post_title );
							$option .= '</option>';
							echo $option;
						}
					} else {
						echo '<option>' . __( 'No pages found', 'rcp-group-accounts' ) . '</option>';
					}
					?>
				</select>
				<?php if ( ! empty( $rcp_options['group_join_page'] ) ) : ?>
					<a href="<?php echo esc_url( get_edit_post_link( $rcp_options['group_join_page'] ) ); ?>" class="button-secondary"><?php _e( 'Edit Page', 'rcp-group-accounts' ); ?></a>
					<a href="<?php echo esc_url( get_permalink( $rcp_options['group_join_page'] ) ); ?>" class="button-secondary"><?php _e( 'View Page', 'rcp-group-accounts' ); ?></a>
				<?php endif; ?>
				<p class="description"><?php printf( __( 'This is the page where users will be able to register and join a group. It should contain the [rcp_group_join_form] shortcode. <a href="%s" target="_blank">See documentation</a>.', 'rcp-group-accounts' ), 'https://docs.restrictcontentpro.com/article/2264-group-accounts-group-member-registration' ); ?></p>
			</td>
		</tr>
	</table>
	<?php

}

add_action( 'rcp_misc_settings', __NAMESPACE__ . '\misc_settings' );
