<?php
/**
 * Group Screen Options
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA\Admin;

/**
 * Register screen options
 *
 * @since 2.0
 * @return void
 */
function screen_options() {

	global $rcpga_groups_page;

	$screen = get_current_screen();

	if ( ! is_object( $screen ) ) {
		return;
	}

	switch ( $screen->id ) {

		case $rcpga_groups_page :
			$args = array(
				'label'   => __( 'Groups/members per page', 'rcp-group-accounts' ),
				'default' => 10,
				'option'  => 'rcpga_groups_per_page'
			);
			add_screen_option( 'per_page', $args );
			break;

	}

}

/**
 * Filters option for number of rows when listing groupos
 *
 * @param bool|int $status Screen option value. Default false to skip.
 * @param string   $option The option name.
 * @param int      $value  The number of rows to use.
 *
 * @since 2.0
 * @return int|bool
 */
function set_screen_option( $status, $option, $value ) {
	if ( 'rcpga_groups_per_page' == $option ) {
		return $value;
	}

	return $status;
}

add_filter( 'set-screen-option', __NAMESPACE__ . '\set_screen_option', 10, 3 );
