<?php
/**
 * Membership Actions
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA\Admin;

use RCP_Membership;

/**
 * Display group name associated with this membership.
 *
 * @param RCP_Membership $membership
 *
 * @since 2.0
 * @return void
 */
function membership_group_association( $membership ) {

	$group = rcpga_get_group_by( 'membership_id', $membership->get_id() );

	if ( empty( $group ) ) {
		return;
	}

	$edit_group_url = get_groups_page( array(
		'rcpga-group' => urlencode( $group->get_group_id() ),
		'rcpga-view'  => 'edit'
	) );
	?>
	<tr>
		<th scope="row" class="row-title">
			<label><?php _e( 'Group:', 'rcp' ); ?></label>
		</th>
		<td>
			<a href="<?php echo esc_url( $edit_group_url ); ?>"><?php echo esc_html( $group->get_name() ); ?></a>
		</td>
	</tr>
	<?php

}

add_action( 'rcp_edit_membership_after', __NAMESPACE__ . '\membership_group_association' );