<?php
/**
 * Import Group Members
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

global $rcp_options;
$group_id = absint( $_GET['rcpga-group'] );
$group    = rcpga_get_group( $group_id );

if ( empty( $group ) ) {
	wp_die( __( 'Invalid group.', 'rcp-group-accounts' ), __( 'Error', 'rcp' ), array( 'response' => 500 ) );
}
?>
<div id="rcpga-group-accounts-import-members" class="rcp-info-wrapper rcp-item-section rcpga-group-card-wrapper">
	<h3><?php _e( 'Import Group Members', 'rcp-group-accounts' ); ?></h3>
	<p><?php echo apply_filters( 'rcpga_group_csv_import_sample_link', sprintf( '<a href="%s">%s</a>', RCPGA_GROUPS_PLUGIN_URL . 'member-import-sample.csv', __( 'Click here to see a sample CSV file.', 'rcp-group-accounts' ) ) ); ?></p>
	<form method="post" enctype="multipart/form-data">
		<table class="widefat">
			<tbody>
			<tr class="form-required">
				<th scope="row" class="row-title">
					<label for="rcpga-group-csv"><?php _e( 'CSV File Upload', 'rcp-group-accounts' ); ?></label>
				</th>
				<td>
					<input type="file" accept=".csv, text/csv" name="rcpga-group-csv" id="rcpga-group-member-import"/>
				</td>
			</tr>

			<tr>
				<?php if ( isset( $rcp_options['group_invite_email'] ) && empty( $rcp_options['disable_group_invite_email'] ) ) : ?>
					<th scope="row" class="row-title">
						<label for="rcpga-group-member-disable-invite"><label for="rcpga-group-member-disable-invite"><?php _e( 'Disable Invite', 'rcp-group-accounts' ); ?></label></label>
					</th>
					<td>
						<input type="checkbox" name="rcpga-disable-invite-email" id="rcpga-group-member-disable-invite"/>
						<?php _e( 'Disable the group invite email and automatically add these users to the group.', 'rcp-group-accounts' ); ?>
						<?php if ( empty( $rcp_options['disable_new_user_notices'] ) ) : ?>
							<?php _e( '(If a new users are created, then the new user notification will be sent out.)', 'rcp-group-accounts' ); ?>
						<?php endif; ?>
					</td>
				<?php endif; ?>
			</tr>
			</tbody>
		</table>

		<div id="rcp-item-edit-actions" class="edit-item">
			<input type="hidden" name="rcpga-group" value="<?php echo esc_attr( $group->get_group_id() ) ?>"/>
			<input type="hidden" name="rcpga-action" value="import-members"/>
			<input type="hidden" name="rcpga-view" value="edit"/>
			<?php wp_nonce_field( 'rcpga_import_group_members', 'rcpga_import_group_members_nonce' ); ?>
			<?php submit_button( __( 'Import Members', 'rcp-group-accounts' ) ); ?>
		</div>
	</form>
</div>