<?php
/**
 * Export Members
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license   GPL2+
 * @since     2.2
 */

global $rcp_options;
$group_id = absint( $_GET['rcpga-group'] );

?>
<div id="rcpga-group-accounts-export-members" class="rcp-info-wrapper rcp-item-section rcpga-group-card-wrapper">
	<h3><?php _e( 'Export Group Members', 'rcp-group-accounts' ); ?></h3>
	<p><?php esc_html_e( 'Export all members in this group to a CSV file.', 'rcp-group-accounts' ); ?></p>
	<form method="post" class="edit-item">
		<input type="hidden" name="export_settings[group_id]" value="<?php echo esc_attr( $group_id ); ?>"/>
		<input type="hidden" name="exporter" value="group_members"/>
		<input type="hidden" name="rcp-action" value="add_export_job"/>
		<?php wp_nonce_field( 'rcp_batch_export', 'rcp_batch_export_nonce' ); ?>

		<p class="submit">
			<input type="submit" class="button-primary" value="<?php esc_attr_e( 'Export', 'rcp-group-accounts' ); ?>"/>
		</p>
	</form>
</div>