<?php
/**
 * Change a Group's Admin
 *
 * @package     rcp-group-accounts
 * @copyright   Copyright (c) 2021, Restrict Content Pro Team
 * @license     GPL2+
 * @since       2.2.1
 */

use function RCPGA\Admin\get_groups_page;

global $rcp_options;

$group_id = absint($_GET['rcpga-group']);
$base_url = get_groups_page();
?>

<div id="rcpga-group-accounts-change-admin" class="rcp-info-wrapper rcp-item-section rcpga-group-card-wrapper">
	<h3><?php _e( 'Change Group Admin', 'rcp' ); ?></h3>
	<table class="widefat striped">
		<tbody>
			<tr>
				<th scope="row" class="row-title">
					<label for="rcpga-change-admin-user-select"><?php _e( 'Available Users:', 'rcp-group-accounts' ); ?></label>
				</th>
				<?php if ( empty( $group_members )) : ?>
					<td colspan="3"><?php _e( 'No members found.', 'rcp-group-accounts' ); ?></td>
				<?php else : ?>
					<td>
						<select name="rcpga-change-admin-user-select" id="rcpga-change-admin-user-select">
							<option value="Choose One">Please choose one</option>
							<?php foreach ( $group_members as $group_member ) :
								/**
								 * @var RCPGA_Group_Member $group_member
								 */
								$user = get_userdata( $group_member->get_user_id() );
								$url = wp_nonce_url( add_query_arg( array(
									'rcpga-action'    => 'make-admin',
									'group-member-id' => urlencode( $group_member->get_id() )
								), $base_url ), 'rcpga_make_admin' );
							?>
							<?php if ( $group_member->get_role() === 'member' ) : ?>
								<option value="<?php echo $url ?>"><?php echo esc_html( $user->display_name ); ?></option>
							<?php endif; ?>
							<?php endforeach; ?>
						</select>
					</td>
				<?php endif; ?>
			</tr>
		</tbody>
	</table>
	<div id="rcp-item-edit-actions" class="edit-item">
		<a href="" id="change-admin-submit" class="button button-primary">Change Admin</a>
	</div>
</div>
