<?php
/**
 * Add Group Member
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

global $rcp_options;
$group_id = absint( $_GET['rcpga-group'] );
?>
<div id="rcpga-group-accounts-add-member" class="rcp-info-wrapper rcp-item-section rcpga-group-card-wrapper">
	<h3><?php _e( 'Add Group Member', 'rcp' ); ?></h3>
	<?php if ( $group->get_code() && ! empty( $rcp_options['groups_allow_member_registration'] ) && ! empty( $rcp_options['group_join_page'] ) ) : ?>
		<p>
			<?php
			printf(
				__( 'Members can also be invited to join via this URL: %s', 'rcp-group-accounts' ),
				'<pre>' . esc_url( add_query_arg( 'group_code', urlencode( $group->get_code() ), get_permalink( $rcp_options['group_join_page'] ) ) ) . '</pre>'
			)
			?>
		</p>
	<?php endif; ?>
	<form id="rcpga-add-group-member" method="POST">
		<div class="rcp-item-info">
			<table class="widefat striped">
				<tbody>
				<?php
				/**
				 * Insert content at the start of the Add Group Member table.
				 */
				do_action( 'rcpga_add_member_before' );
				?>
				<tr>
					<th scope="row" class="row-title">
						<label for="rcpga-add-member-is-new"><?php _e( 'New User?', 'rcp-group-accounts' ); ?></label>
					</th>
					<td>
						<input type="checkbox" id="rcpga-add-member-is-new" name="rcpga-add-member-is-new" value="1"/>
						<span class="description"><?php _e( 'Check if this is a new user account', 'rcp-group-accounts' ); ?></span>
					</td>
				</tr>
				<tr>
					<th scope="row" class="row-title">
						<label for="rcpga-user-email"><?php _e( 'User Email:', 'rcp-group-accounts' ); ?></label>
					</th>
					<td>
						<input type="text" id="rcpga-user-email" name="rcpga-user-email" class="rcp-user-search" autocomplete="off"/>
						<p class="description"><?php _e( 'Enter the email address of a user account to add to the group.', 'rcp-group-accounts' ); ?></p>
					</td>
				</tr>
				<tr style="display: none;">
					<th scope="row" class="row-title">
						<label for="rcpga-user-login"><?php _e( 'Username:', 'rcp-group-accounts' ); ?></label>
					</th>
					<td>
						<input type="text" id="rcpga-user-login" name="rcpga-user-login" class="rcpga-new-member-field" autocomplete="off"/>
						<p class="description"><?php _e( 'Enter the username for the new account. If left blank, the email address will be used.', 'rcp-group-accounts' ); ?></p>
					</td>
				</tr>
				<tr class="user-pass1-wrap" style="display: none;">
					<th scope="row" class="row-title">
						<label for="pass1"><?php _e( 'Password:', 'rcp-group-accounts' ); ?></label>
					</th>
					<td>
						<button type="button" class="button wp-generate-pw hide-if-no-js"><?php _e( 'Show password', 'rcp-group-accounts' ); ?></button>
						<div class="wp-pwd hide-if-js">
							<?php $initial_password = wp_generate_password( 24 ); ?>
							<span class="password-input-wrapper">
								<input type="password" name="rcpga-user-password" id="pass1" class="regular-text rcpga-new-member-field" autocomplete="off" data-reveal="1" data-pw="<?php echo esc_attr( $initial_password ); ?>" aria-describedby="pass-strength-result"/>
							</span>
							<button type="button" class="button wp-hide-pw hide-if-no-js" data-toggle="0" aria-label="<?php esc_attr_e( 'Hide password', 'rcp-group-accounts' ); ?>">
								<span class="dashicons dashicons-hidden"></span>
								<span class="text"><?php _e( 'Hide', 'rcp-group-accounts' ); ?></span>
							</button>
							<button type="button" class="button wp-cancel-pw hide-if-no-js" data-toggle="0" aria-label="<?php esc_attr_e( 'Cancel password change', 'rcp-group-accounts' ); ?>">
								<span class="text"><?php _e( 'Cancel', 'rcp-group-accounts' ); ?></span>
							</button>
							<div style="display:none" id="pass-strength-result" aria-live="polite"></div>
						</div>
						<p class="description"><?php _e( 'Enter the password for the new account.', 'rcp-group-accounts' ); ?></p>
					</td>
				</tr>
				<tr class="pw-weak">
					<th><?php _e( 'Confirm Password:', 'rcp-group-accounts' ); ?></th>
					<td>
						<label>
							<input type="checkbox" name="pw_weak" class="pw-checkbox"/>
							<?php _e( 'Confirm use of weak password', 'rcp-group-accounts' ); ?>
						</label>
					</td>
				</tr>
				<tr style="display: none;">
					<th scope="row" class="row-title">
						<label for="rcpga-first-name"><?php _e( 'User First Name:', 'rcp-group-accounts' ); ?></label>
					</th>
					<td>
						<input type="text" id="rcpga-first-name" name="rcpga-first-name" class="rcpga-new-member-field" autocomplete="off"/>
						<p class="description"><?php _e( 'Enter the user\'s first name.', 'rcp-group-accounts' ); ?></p>
					</td>
				</tr>
				<tr style="display: none;">
					<th scope="row" class="row-title">
						<label for="rcpga-last-name"><?php _e( 'User Last Name:', 'rcp-group-accounts' ); ?></label>
					</th>
					<td>
						<input type="text" id="rcpga-last-name" name="rcpga-last-name" class="rcpga-new-member-field" autocomplete="off"/>
						<p class="description"><?php _e( 'Enter the user\'s last name', 'rcp-group-accounts' ); ?></p>
					</td>
				</tr>

				<?php
				/**
				 * Insert content at the end of the Add Group Member table.
				 */
				do_action( 'rcpga_add_member_after' );
				?>

				<tr>
					<?php if ( isset( $rcp_options['group_invite_email'] ) && empty( $rcp_options['disable_group_invite_email'] ) ) : ?>
						<th scope="row" class="row-title">
							<label for="rcpga-group-member-disable-invite"><?php _e( 'Disable Invite', 'rcp-group-accounts' ); ?></label>
						</th>
						<td>
							<input type="checkbox" name="rcpga-disable-invite-email" id="rcpga-group-member-disable-invite"/>
							<?php _e( 'Disable the group invite email and automatically add this user to the group.', 'rcp-group-accounts' ); ?>
							<?php if ( empty( $rcp_options['disable_new_user_notices'] ) ) : ?>
								<?php _e( '(If a new user is created, then the new user notification will be sent out.)', 'rcp-group-accounts' ); ?>
							<?php endif; ?>
						</td>
					<?php endif; ?>
				</tr>
				</tbody>
			</table>
		</div>

		<div id="rcp-item-edit-actions" class="edit-item">
			<input type="hidden" name="rcpga-action" value="add-member"/>
			<input type="hidden" name="rcpga-group" id="rcpga-group" value="<?php echo absint( $group_id ); ?>"/>
			<input type="hidden" name="rcpga-view" value="edit"/>
			<?php wp_nonce_field( 'rcpga_add_group_member', 'rcpga_add_group_member_nonce' ); ?>
			<input type="submit" class="button button-primary" value="<?php _e( 'Add Member', 'rcp-group-accounts' ); ?>"/>
		</div>
	</form>
</div>