<?php
/**
 * Groups Page
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA\Admin;

/**
 * Render the "Groups" admin page.
 *
 * Depending on any query args, this may be the "Add Group", "Edit Group", or "Groups" table page.
 *
 * @since 2.0
 * @return void
 */
function render_groups_page() {

	if ( ! empty( $_GET['rcpga-view'] ) && 'view-members' == $_GET['rcpga-view'] ) {
		/**
		 * Members
		 */
		// List all members.
		group_members_table();
	} else {
		/**
		 * Groups
		 */
		if ( ! empty( $_GET['rcpga-view'] ) && 'edit' == $_GET['rcpga-view'] && ! empty( $_GET['rcpga-group'] ) ) {
			require_once RCPGA_GROUPS_PLUGIN_DIR . 'includes/admin/groups/edit-group.php';
		} elseif ( ! empty( $_GET['rcpga-view'] ) && 'add' == $_GET['rcpga-view'] ) {
			require_once RCPGA_GROUPS_PLUGIN_DIR . 'includes/admin/groups/add-group.php';
		} else {
			// List all groups.
			groups_table();
		}

	}

}

/**
 * Display groups list table
 *
 * @since 2.0
 * @return void
 */
function groups_table() {

	include_once RCPGA_GROUPS_PLUGIN_DIR . 'includes/admin/groups/class-groups-table.php';

	$table_class = new Groups_Table();
	$table_class->prepare_items();

	?>
	<div class="wrap">
		<h1>
			<?php _e( 'Groups', 'rcp-group-accounts' ); ?>
			<a href="<?php echo esc_url( get_groups_page( array( 'rcpga-view' => 'add' ) ) ); ?>" class="page-title-action"><?php _e( 'Add New', 'rcp-group-accounts' ); ?></a>
			<a href="<?php echo esc_url( get_groups_page( array( 'rcpga-view' => 'view-members' ) ) ); ?>" class="page-title-action"><?php _e( 'Group Members', 'rcp-group-accounts' ); ?></a>
		</h1>

		<form id="rcp-groups-filter" method="GET" action="<?php echo esc_url( get_groups_page() ); ?>">
			<input type="hidden" name="page" value="rcp-groups"/>
			<?php
			$table_class->views();
			$table_class->search_box( __( 'Search groups', 'rcp-group-accounts' ), 'rcp-groups' );
			$table_class->display();
			?>
		</form>
	</div>
	<?php

}

/**
 * Display group members list table
 *
 * @since 2.0
 * @return void
 */
function group_members_table() {

	include_once RCPGA_GROUPS_PLUGIN_DIR . 'includes/admin/members/class-group-members-table.php';

	$table_class = new Group_Members_Table();
	$table_class->prepare_items();
	$group = ! empty( $_GET['rcpga-group'] ) ? rcpga_get_group( absint( $_GET['rcpga-group'] ) ) : false;

	?>
	<div class="wrap">
		<h1>
			<?php
			if ( ! empty( $group ) ) {
				$edit_group_url = get_groups_page( array(
					'rcpga-view'  => 'edit',
					'rcpga-group' => urlencode( $group->get_group_id() )
				) );
				printf( __( '"%s" Group Members', 'rcp-group-accounts' ), '<a href="' . esc_url( $edit_group_url ) . '" title="' . esc_attr__( 'Edit group', 'rcp-group-accounts' ) . '">' . esc_html( $group->get_name() ) . '</a>' );
				?>
				<a href="<?php echo esc_url( $edit_group_url ) . '#rcpga-group-accounts-add-member'; ?>" class="page-title-action" title="<?php esc_attr_e( 'Add new group member', 'rcp-group-accounts' ); ?>"><?php _e( 'Add New', 'rcp-group-accounts' ); ?></a>
				<?php
			} else {
				_e( 'Group Members', 'rcp-group-accounts' );
			}
			?>
			<a href="<?php echo esc_url( get_groups_page() ); ?>" class="page-title-action"><?php _e( '&laquo; Back to Groups', 'rcp-group-accounts' ); ?></a>
		</h1>

		<form id="rcp-groups-filter" method="GET" action="<?php echo esc_url( get_groups_page() ); ?>">
			<input type="hidden" name="page" value="rcp-groups"/>
			<?php
			$table_class->views();
			$table_class->search_box( __( 'Search members', 'rcp-group-accounts' ), 'rcp-groups' );
			$table_class->display();
			?>
		</form>
	</div>
	<?php

}