<?php
/**
 * Group Actions
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA\Admin;

/**
 * @param \WP_Screen $screen
 *
 * @since 2.0
 * @return void
 */
function maybe_redirect_to_group_members_table( $screen ) {

	global $rcpga_groups_page;

	if ( empty( $rcpga_groups_page ) || $screen->id != $rcpga_groups_page ) {
		return;
	}

	if ( ! empty( $_GET['rcpga-view'] ) || empty( $_GET['search_type'] ) || 'member' != $_GET['search_type'] || empty( $_GET['s'] ) ) {
		return;
	}

	$args = array(
		'rcpga-view' => 'view-members',
		's'          => rawurldecode( $_GET['s'] )
	);

	if ( ! empty( $_GET['rcpga-group'] ) ) {
		$args['rcpga-group'] = absint( $_GET['rcpga-group'] );
	}

	wp_safe_redirect( get_groups_page( $args ) );
	exit;

}

add_action( 'current_screen', __NAMESPACE__ . '\maybe_redirect_to_group_members_table' );