<?php
/**
 * Edit Group
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

use function RCPGA\Admin\get_groups_page;

$group_id = absint( $_GET['rcpga-group'] );
$group    = rcpga_get_group( $group_id );

if ( empty( $group ) ) {
	wp_die( __( 'Something went wrong.', 'rcp-group-accounts' ), __( 'Error', 'rcp' ), array( 'response' => 500 ) );
}

$owner      = $group->get_owner();
$customer   = ! empty( $owner ) ? rcp_get_customer_by_user_id( $owner->ID ) : false;
$membership = $group->get_membership();

$group_members_url = get_groups_page( array(
	'rcpga-group' => $group->get_group_id(),
	'rcpga-view'  => 'view-members'
) );

$group_owner   = rcpga_get_group_member( $group->get_owner_id(), $group_id );
$group_members = rcpga_get_group_members( array(
	'group_id'        => absint( $group_id ),
	'number'          => 4,
	'orderby'         => 'role',
	'order'           => 'DESC',
	'user_id__not_in' => ! empty( $group_owner ) ? array( $group_owner->get_user_id() ) : array()
) );
$group_members = ! empty( $group_owner ) ? array_merge( array( $group_owner ), $group_members ) : $group_members;
?>
<div class="wrap">
	<h1><?php _e( 'Group Details', 'rcp' ); ?></h1>

	<?php if ( empty( $membership ) ) : ?>
		<div class="error">
			<p><?php _e( 'Warning: There is no membership associated with this group.', 'rcp-group-accounts' ); ?></p>
		</div>
	<?php endif; ?>

	<div id="rcp-item-card-wrapper">
		<div class="rcp-info-wrapper rcp-item-section rcpga-group-card-wrapper">
			<form id="rcpga-edit-group-info" method="POST">
				<div class="rcp-item-info">
					<table class="widefat striped">
						<tbody>
						<?php
						/**
						 * Insert content at the start of the Edit Group table.
						 *
						 * @param RCPGA_Group $group
						 */
						do_action( 'rcpga_edit_group_form_fields_before', $group );
						?>
						<tr>
							<th scope="row" class="row-title">
								<label for="tablecell"><?php _e( 'ID:', 'rcp-group-accounts' ); ?></label>
							</th>
							<td>
								<?php echo $group->get_group_id(); ?>
							</td>
						</tr>
						<tr>
							<th scope="row" class="row-title">
								<label for="rcpga-group-name"><?php _e( 'Name:', 'rcp-group-accounts' ); ?></label>
							</th>
							<td>
								<input type="text" id="rcpga-group-name" class="regular-text" name="rcpga-group-name" value="<?php echo esc_attr( $group->get_name() ); ?>"/>
							</td>
						</tr>
						<tr>
							<th scope="row" class="row-title">
								<label for="rcpga-group-description"><?php _e( 'Description:', 'rcp-group-accounts' ); ?></label>
							</th>
							<td>
								<?php wp_editor( wp_kses_post( $group->get_description() ), 'rcpga-group-description', array(
									'textarea_name' => 'rcpga-group-description',
									'media_buttons' => false,
									'editor_height' => 180
								) ); ?>
							</td>
						</tr>
						<tr>
							<th scope="row" class="row-title">
								<label for="rcpga-group-code"><?php _e( 'Code:', 'rcp-group-accounts' ); ?></label>
							</th>
							<td>
								<input type="text" id="rcpga-group-code" class="regular-text" name="rcpga-group-code" value="<?php echo esc_attr( $group->get_code() ); ?>"/>
								<p class="description"><?php _e( 'Unique code for this group. Used when members join through the self-registration form.', 'rcp-group-accounts' ); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row" class="row-title">
								<label for="table-cell"><?php _e( 'Date Created:', 'rcp-group-accounts' ); ?></label>
							</th>
							<td>
								<?php echo esc_html( $group->get_date_created( true ) ); ?>
							</td>
						</tr>
						<tr>
							<th scope="row" class="row-title">
								<label for="rcpga-group-owner"><?php _e( 'Owner:', 'rcp-group-accounts' ); ?></label>
							</th>
							<td>
								<input type="text" id="rcpga-group-owner" class="regular-text" disabled="disabled" value="<?php echo ! empty( $owner ) ? esc_attr( $owner->user_login ) : ''; ?>"/>
								<?php
								$links = array();

								if ( ! empty( $owner ) ) {
									$links[] = '<a href="' . esc_url( add_query_arg( 'user_id', urlencode( $owner->ID ), admin_url( 'user-edit.php' ) ) ) . '">' . __( 'Edit User', 'rcp-group-accounts' ) . '</a>';
								}

								if ( ! empty( $customer ) ) {
									$links[] = '<a href="' . esc_url( rcp_get_customers_admin_page( array(
											'customer_id' => urlencode( $customer->get_id() ),
											'view'        => 'edit'
										) ) ) . '">' . __( 'View Customer', 'rcp-group-accounts' ) . '</a>';
								}

								if ( ! empty( $links ) ) {
									echo implode( ' | ', $links );
								}
								?>
							</td>
						</tr>
							<tr>
								<th scope="row" class="row-title">
									<label for="rcpga-group-membership"><?php _e( 'Membership:', 'rcp-group-accounts' ); ?></label>
								</th>
								<td>
									<?php
									$customer                  = rcp_get_customer_by_user_id( $group->get_owner_id() );
									$owner_memberships         = ! empty( $customer ) ? $customer->get_memberships() : false;
									$group_account_memberships = array();

									if ( ! empty( $owner_memberships ) && is_array( $owner_memberships ) ) {
										foreach ( $owner_memberships as $owner_membership ) {
											/**
											 * @var RCP_Membership $owner_membership
											 */
											if ( rcpga_is_level_group_accounts_enabled( $owner_membership->get_object_id() ) ) {
												// Only add this membership if it doesn't belong to another group.
												if ( $owner_membership->get_id() == $group->get_membership_id() || ! rcpga_get_group_by( 'membership_id', $owner_membership->get_id() ) ) {
													$group_account_memberships[ $owner_membership->get_id() ] = $owner_membership;
												}
											}
										}
									}

									if ( ! empty ( $group_account_memberships ) ) {
										?>
										<select id="rcpga-group-membership" name="rcpga-group-membership-id">
											<option value="" <?php selected( empty( $membership ) || ! in_array( $membership->get_id(), $group_account_memberships ) ); ?>><?php _e( '- None -', 'rcp-group-accounts' ); ?></option>
											<?php foreach ( $group_account_memberships as $group_account_membership ) : ?>
												<option value="<?php echo esc_attr( $group_account_membership->get_id() ); ?>" <?php selected( $group_account_membership->get_id(), $group->get_membership_id() ); ?>>
													<?php printf( '#%d - %s', $group_account_membership->get_id(), $group_account_membership->get_membership_level_name() ); ?>
												</option>
											<?php endforeach; ?>
										</select>
										<?php
										if ( ! empty( $membership ) ) {
											$edit_membership_url = rcp_get_memberships_admin_page( array(
												'view'          => 'edit',
												'membership_id' => urlencode( $membership->get_id() )
											) );

											echo '<a href="' . esc_url( $edit_membership_url ) . '" class="button">' . __( 'View', 'rcp-group-accounts' ) . '</a>';
										}
									} else {
										printf(
											__( 'This customer doesn\'t have any memberships. <a href="%s">Add one.</a>', 'rcp-group-accounts' ),
											esc_url( rcp_get_memberships_admin_page( array(
												'view'  => 'add',
												'email' => urlencode( $group->get_owner()->user_email )
											) ) )
										);
									}
									?>
								</td>
							</tr>
						<tr>
							<th scope="row" class="row-title">
								<label for="rcpga-group-seats"><?php _e( 'Seats:', 'rcp-group-accounts' ); ?></label>
							</th>
							<td>
								<?php echo $group->get_member_count(); ?> /
								<input type="number" id="rcpga-group-seats" min="1" step="1" name="rcpga-group-seats" autocomplete="off" value="<?php echo esc_attr( $group->get_seats() ); ?>"/>
							</td>
						</tr>

						<?php
						/**
						 * Insert content at the end of the Edit Group table.
						 *
						 * @param RCPGA_Group $group
						 */
						do_action( 'rcpga_edit_group_form_fields_after', $group );
						?>
						</tbody>
					</table>
				</div>

				<div id="rcp-item-edit-actions" class="edit-item">
					<input type="hidden" name="rcpga-action" value="edit-group"/>
					<input type="hidden" name="rcpga-group" value="<?php echo esc_attr( $group->get_group_id() ); ?>"/>
					<?php wp_nonce_field( 'rcpga_edit_group', 'rcpga_edit_group_nonce' ); ?>
					<input type="submit" class="button button-primary" value="<?php _e( 'Update Group', 'rcp-group-accounts' ); ?>"/>
				</div>
			</form>
		</div>

		<div id="rcpga-group-members-wrapper" class="rcp-item-section">
			<h3><?php _e( 'Members', 'rcp-group-accounts' ); ?></h3>
			<table class="wp-list-table widefat striped">
				<thead>
				<tr>
					<th class="column-primary"><?php _e( 'Member', 'rcp-group-accounts' ); ?></th>
					<th><?php _e( 'Date Added', 'rcp-group-accounts' ); ?></th>
					<th><?php _e( 'Role', 'rcp-group-accounts' ); ?></th>
				</tr>
				</thead>
				<tbody>
				<?php if ( ! empty( $group_members ) ) : ?>
					<?php foreach ( $group_members as $group_member ) :
						/**
						 * @var RCPGA_Group_Member $group_member
						 */
						$user = get_userdata( $group_member->get_user_id() );
						?>
						<tr>
							<td class="column-primary" data-colname="<?php esc_attr_e( 'Member', 'rcp-group-accounts' ); ?>">
								<a href="<?php echo esc_url( add_query_arg( 'user_id', urlencode( $group_member->get_user_id() ), admin_url( 'user-edit.php' ) ) ); ?>"><?php echo esc_html( $user->display_name ); ?></a>
								<button type="button" class="toggle-row">
									<span class="screen-reader-text"><?php _e( 'Show more details', 'rcp-group-accounts' ); ?></span>
								</button>
							</td>
							<td data-colname="<?php esc_attr_e( 'Date Added', 'rcp-group-accounts' ); ?>"><?php echo $group_member->get_date_added( true ); ?></td>
							<td data-colname="<?php esc_attr_e( 'Role' ); ?>"><?php echo rcpga_get_member_role_label( $group_member->get_role() ); ?></td>
						</tr>
					<?php endforeach; ?>
				<?php else : ?>
					<tr>
						<td colspan="3"><?php _e( 'No members found.', 'rcp-group-accounts' ); ?></td>
					</tr>
				<?php endif; ?>
				</tbody>
			</table>

			<div id="rcp-item-edit-actions" class="edit-item">
				<a href="<?php echo esc_url( $group_members_url ); ?>" class="button-secondary"><?php _e( 'View All Members', 'rcp-group-accounts' ); ?></a>
			</div>
		</div>

		<?php
		if ( rcpga_user_can( get_current_user_id(), 'manage_members', $group->get_group_id() ) ) {
			require_once RCPGA_GROUPS_PLUGIN_DIR . 'includes/admin/groups/partials/add-member.php';
			require_once RCPGA_GROUPS_PLUGIN_DIR . 'includes/admin/groups/partials/import-members.php';
			require_once RCPGA_GROUPS_PLUGIN_DIR . 'includes/admin/groups/partials/change-admin.php';

			if ( function_exists( 'rcp_get_csv_exporters' ) ) {
				require_once RCPGA_GROUPS_PLUGIN_DIR . 'includes/admin/groups/partials/export-members.php';
			}
		}
		?>
	</div>
</div>
