<?php
/**
 * Customer Actions
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA\Admin;

use \RCPGA_Group_Member;
use \RCP_Customer;

/**
 * Display a list of the customer's group memberships.
 *
 * @param RCP_Customer $customer
 *
 * @since 2.0
 * @return void
 */
function customer_group_memberships( $customer ) {

	$user = get_userdata( $customer->get_user_id() );

	if ( empty( $user ) ) {
		return;
	}

	$group_memberships = rcpga_get_group_members( array(
		'user_id' => $user->ID
	) );

	if ( empty( $group_memberships ) ) {
		return;
	}
	?>
	<div id="rcpga-customer-group-memberships" class="rcp-item-section">
		<h3><?php _e( 'Group Memberships', 'rcp-group-accounts' ); ?></h3>
		<table class="wp-list-table widefat striped payments">
			<thead>
			<tr>
				<th class="column-primary"><?php _e( 'Group', 'rcp-group-accounts' ); ?></th>
				<th><?php _e( 'Date Added', 'rcp-group-accounts' ); ?></th>
				<th><?php _e( 'Role', 'rcp-group-accounts' ); ?></th>
			</tr>
			</thead>
			<tbody>
			<?php
			foreach ( $group_memberships as $group_membership ) :
				/**
				 * @var RCPGA_Group_Member $group_membership
				 */
				?>
				<tr>
					<td class="column-primary" data-colname="<?php esc_attr_e( 'Group', 'rcp-group-accounts' ); ?>">
						<a href="<?php echo esc_url( get_groups_page( array(
							'rcpga-group' => urlencode( $group_membership->get_group_id() ),
							'rcpga-view'  => 'edit'
						) ) ); ?>"><?php echo $group_membership->get_group()->get_name(); ?></a>
						<button type="button" class="toggle-row">
							<span class="screen-reader-text"><?php _e( 'Show more details', 'rcp-group-accounts' ); ?></span>
						</button>
					</td>
					<td data-colname="<?php esc_attr_e( 'Date Added', 'rcp-group-accounts' ); ?>"><?php echo $group_membership->get_date_added( true ); ?></td>
					<td data-colname="<?php esc_attr_e( 'Role' ); ?>"><?php echo rcpga_get_member_role_label( $group_membership->get_role() ); ?></td>
				</tr>
			<?php endforeach; ?>
			</tbody>
		</table>
	</div>
	<?php

}

add_action( 'rcp_edit_customer_after_memberships_section', __NAMESPACE__ . '\customer_group_memberships' );