<?php
/**
 * Database Upgrades
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA\Admin;


/**
 * Class Upgrades
 * @package RCPGA\Admin
 */
class Upgrades {

	/**
	 * Version number from the database
	 *
	 * @var float|int
	 */
	private $version = 0;

	/**
	 * Whether or not the plugin has been upgraded
	 *
	 * @var bool
	 */
	private $upgraded = false;

	/**
	 * Upgrades constructor.
	 *
	 * @since 2.0
	 */
	public function __construct() {

		$this->version = get_option( 'rcpga_version', 0 );

		add_action( 'admin_init', array( $this, 'init' ), - 9999 );

	}

	/**
	 * Trigger updates and maybe update the Group Accounts version number.
	 *
	 * @since 2.0
	 */
	public function init() {

		// If upgrades have occurred or the DB version is different from the version constant.
		if ( $this->upgraded || $this->version <> RCPGA_GROUPS_VERSION ) {
			rcp_log( sprintf( 'RCP Group Accounts upgraded from version %s to %s.', $this->version, RCPGA_GROUPS_VERSION ), true );
			update_option( 'rcpga_version_upgraded_from', $this->version );
			update_option( 'rcpga_version', RCPGA_GROUPS_VERSION );
		}

	}

}

new Upgrades();