<?php
/**
 * Admin Pages
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA\Admin;

/**
 * Register admin menus
 *
 * @since 2.0
 * @return void
 */
function register_menus() {
	global $rcpga_groups_page;

	$rcpga_groups_page = add_submenu_page( 'rcp-members', __( 'Groups', 'rcp-group-accounts' ), __( 'Groups', 'rcp-group-accounts' ), 'rcp_view_members', 'rcp-groups', __NAMESPACE__ . '\render_groups_page' );

	add_action( "load-$rcpga_groups_page", __NAMESPACE__ . '\screen_options' );
}

add_action( 'admin_menu', __NAMESPACE__ . '\register_menus', 100 );

/**
 * Returns the URL to the Groups admin page.
 *
 * @param array $args Array of query args to append to the URL.
 *
 * @since 2.0
 * @return string
 */
function get_groups_page( $args = array() ) {

	$args = wp_parse_args( $args, array(
		'page' => 'rcp-groups'
	) );

	$sanitized_args = array();

	foreach ( $args as $key => $value ) {
		$sanitized_key   = urlencode( $key );
		$sanitized_value = urlencode( $value );

		$sanitized_args[ $sanitized_key ] = $sanitized_value;
	}

	$groups_page = add_query_arg( $sanitized_args, admin_url( 'admin.php' ) );

	return $groups_page;

}

/**
 * Enqueue admin scripts and styles
 *
 * @param string $hook
 *
 * @since 2.0
 * @return void
 */
function enqueue_scripts( $hook ) {

	global $rcpga_groups_page, $rcp_subscriptions_page;

	if ( $rcpga_groups_page != $hook && $rcp_subscriptions_page != $hook ) {
		return;
	}

	$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_script( 'jquery-ui-tooltip' );

	// Loads the password show/hide feature and strength meter.
	wp_enqueue_script( 'user-profile' );

	wp_enqueue_script( 'rcp-group-accounts-admin', RCPGA_GROUPS_PLUGIN_URL . 'includes/assets/js/admin.js', array( 'jquery' ), RCPGA_GROUPS_VERSION );
	wp_localize_script( 'rcp-group-accounts-admin', 'rcpga_group_vars', array(
		'delete_group'  => __( 'Are you sure you want to delete this group?', 'rcp-group-accounts' ),
		'delete_member' => __( 'Are you sure you want to remove this member from the group?', 'rcp-group-accounts' ),
		'make_owner'    => __( 'Are you sure you want to set this member as the new owner? All membership settings will be copied to the new owner, the old owner\'s membership will be cancelled, and the old owner will be demoted to "admin" rank.', 'rcp-group-accounts' ),
		'make_admin'    => __( 'Are you sure you want to set this member as the new admin?', 'rcp-group-accounts' )
	) );

	// Load core RCP styles on groups pages.
	wp_enqueue_style( 'rcp-admin', RCP_PLUGIN_URL . 'includes/css/admin-styles' . $suffix . '.css', array(), RCP_PLUGIN_VERSION );

	/*
	 * @todo Load core RCP scripts on groups pages.
	 * We'll want to do this eventually to add support for the auto suggest user email. But before we can do this
	 * we need some changes in RCP core to make it easier to enqueue this script with all the vars.
	 */

}

add_action( 'admin_enqueue_scripts', __NAMESPACE__ . '\enqueue_scripts' );