<?php
/**
 * Admin Notices
 *
 * @package   rcp-group-accounts
 * @copyright Copyright (c) 2019, Restrict Content Pro team
 * @license   GPL2+
 * @since     2.0
 */

namespace RCPGA\Admin;

/**
 * Display admin notices
 *
 * @since 2.0
 * @return void
 */
function display_admin_notices() {

	$message = ! empty( $_GET['rcpga-notice'] ) ? urldecode( $_GET['rcpga-notice'] ) : false;
	$class   = 'updated';
	$text    = '';

	if ( empty( $message ) ) {
		return;
	}

	// Groups
	switch ( $message ) {
		case 'group-updated' :
			$text = __( 'Group updated', 'rcp-group-accounts' );
			break;
	}

	if ( $text ) {
		echo '<div class="' . $class . '"><p>' . $text . '</p></div>';
	}

}

add_action( 'admin_notices', __NAMESPACE__ . '\display_admin_notices' );