<?php

$query = new WP_Query( array(
	'post_type' => 'qp_popup',
) );

$posts = $query->posts;

?>

<link rel="stylesheet" href="https://use.typekit.net/eip0gix.css">

<section class="section-qp-popup">
	<div class="section__logo">
		<img src="<?php echo QP_PLUGIN_URL . 'images/quickpop-logo.png' ?>"/>
	</div><!-- /.section__logo -->

	<div class="section__inner">
		<div class="section__content">
			<header class="section__head">
				<p><?php echo __( 'Popup Library', 'crb' ) ?></p>
			</header><!-- /.section__head -->

			<div class="section__body">
				<div class="qp-popups-list">
					<?php if ( $query->have_posts() ): ?>
						<div class="qp-popups__head">
							<p><?php echo __( 'Title', 'crb' ) ?></p>
						</div><!-- /.qp-popups__head -->

						<div class="qp-popups__body">
							<ul>
								<?php foreach ( $posts as $post ) :

									$post_status = $post->post_status;

									if ( $post_status === 'publish' ) {
										$post_status = 'live';
									} else {
										$post_status = 'disabled';
									}

									$post_disabled = carbon_get_post_meta( $post->ID, 'qp_status' );

									if ( $post_disabled === 'qp_disabled' ) {
										$post_status = 'disabled';
									}

								?>
									<?php include QP_PLUGIN_DIR . 'templates/parts/popup-list-item.php'; ?>
								<?php endforeach; ?>
							</ul>
						</div><!-- /.qp-popups__body -->
					<?php endif ?>
				</div><!-- /.qp-popups -->
			</div><!-- /.section__body -->
		</div><!-- /.section__content -->

		<div class="section__sidebar">
			<div class="section__sidebar-navigation">
				<ul>
					<li>
						<a href="<?php echo admin_url('post-new.php?post_type=qp_popup'); ?>"><?php echo __( 'Design New Popup', 'mb-qp' ) ?></a>
					</li>

					<li>
						<a target="_blank" href="https://mybrindle.com/quickpop-pro-documentation/"><?php echo __( 'QuickPopPRO Documentation', 'mb-qp' ) ?></a>
					</li>
				</ul>
			</div><!-- /.section__sidebar-navigation -->

			<?php if ( ! isset( $_COOKIE['qp_library_upsell_hidden'] ) ): ?>
				<div class="qp-upsell-ad">
					<img width="207" height="183" src="<?php echo QP_PLUGIN_URL . 'images/qp-upsell-sidebar.png' ?>" alt="" />

					<p>
						<strong><?php echo __( 'Premium Business Plugins', 'mb-qp' ) ?></strong>

						<br>

						<?php echo __( 'Need other plugins with the Brindle seal of quality? Add custom banner announcements and cookie notifications with', 'mb-qp' ) ?>

						<a target="_blank" href="https://mybrindle.com/product/banners-wordpress-plugin/"><?php echo __( 'SleekAnnounce,', 'mb-qp' ) ?></a>

						<?php echo __( ' Let visitors book appointments based on your personalized calendar with ', 'mb-qp' ) ?>

						<a target="_blank" href="https://mybrindle.com/product/book-appointments-wordpress-plugin/"><?php echo __( 'Brindle Booking.' ) ?></a>

						<?php echo __( ' Give them a shot and ' ) ?>

						<span><?php echo __( 'save 15%!' ) ?></span>
					</p>

					<p>
						<?php echo __( 'Use Promo Code' ) ?>

						<br>

						<strong><?php echo __( 'MOBRNDL15' ) ?></strong>
					</p>

					<a target="_blank" href="https://mybrindle.com/shop/" class="qp-upsell-ad__btn">
						<strong><?php echo __( 'Shop Brindle Plugins', 'mb-qp' ); ?></strong><br><?php echo __( 'All include 14 day FREE TRIAL', 'mb-qp' ); ?>
					</a>

					<a href="#" class="qp-upsell__snooze js-upsell-snooze"><?php echo __( 'Dismiss this message', 'mb-qp' ) ?></a>
				</div><!-- /.qp-upsell-ad -->
			<?php endif; ?>
		</div><!-- /.section__sidebar -->

		<div class="section__confirmation">
			<div class="qp-popup-duplicate-confirmation">
				<p><?php echo sprintf( '%s', __( 'Are you sure you want to duplicate this popup?', 'mb-qp' ) ) ?></p>

				<a href="#" class="qp-btn js-confirm-duplicate">
					<?php _e( 'Confirm', 'brindle-booking' ); ?>
				</a>

				<a href="#" class="qp-btn js-reject-duplicate">
					<?php _e( 'Cancel', 'brindle-booking' ); ?>
				</a>
			</div><!-- /.qp-popup-duplicate-confirmation -->
		</div><!-- /.section__confirmation -->
	</div><!-- /.section__inner -->
</section><!-- /.section-qp-popup -->