<?php
use Carbon_Fields\Container;
use Carbon_Fields\Field;

$popup_id = isset( $_GET['post'] ) ? $_GET['post'] : '${popup-id}';

Container::make( 'post_meta', __( 'QuickPop by Brindle', 'mb-qp' ) )
	->where( 'post_type', '=', 'qp_popup' )
	->add_tab( __( 'Content', 'mb-qp' ), array(
		Field::make( 'separator', 'qp_hero_image_separator', __( 'Hero Image', 'mb-qp' ) ),
		Field::make( 'image', 'qp_hero_image', '' ),
		Field::make( 'separator', 'qp_headline_separator', __( 'Headline', 'mb-qp' ) ),
		Field::make( 'rich_text', 'qp_title', '' )
			->set_settings(array(
				'media_buttons' => false,
				'tinymce' => array(
					'toolbar1' => 'formatselect,bold,italic,alignleft,aligncenter,alignright',
					'height' => '100'
				),
				'quicktags' => false
			) )
			->set_default_value( '<h2>Enter Your Headline Here</h2>' ),
		Field::make( 'separator', 'qp_body_separator', __( 'Body', 'mb-qp' ) ),
		Field::make( 'rich_text', 'qp_body', '' )
			->set_default_value( 'Sign up now and receive custom offers and informative tips in building and marketing your software business.' ),
		Field::make( 'select', 'qp_embed_forms', __( 'Embed Third Party Form', 'mb-qp' ) )
			->add_options( array(
				'' => __( 'Select A Third Party Service' ),
				'hubspot' => __( 'Hubspot', 'mb-qp' ),
				'mailchimp' => __( 'Mailchimp', 'mb-qp' )
			) ),
		Field::make( 'textarea', 'qp_mailchimp_form', __( 'MailChimp Form', 'mb-qp' ) )
			->set_rows( 8 )
			->set_help_text( sprintf( '%s - <code>%s</code> - %s', __( 'Please add this class', 'mb-qp' ), 'qp-mailchimp-form', __( 'in the class attribute for the QuickPop MailChimp form customizations.', 'mb-qp' ) ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_embed_forms',
					'value' => 'mailchimp',
					'compare' => '='
				)
			) ),
		Field::make( 'text', 'qp_hubspot_form_id', __( 'Form ID', 'mb-qp' ) )
			->set_width( 33 )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_embed_forms',
					'value' => 'hubspot',
					'compare' => '='
				)
			) ),
		Field::make( 'text', 'qp_hubspot_form_region', __( 'Region', 'mb-qp' ) )
			->set_width( 33 )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_embed_forms',
					'value' => 'hubspot',
					'compare' => '='
				)
			) ),
		Field::make( 'text', 'qp_hubspot_form_portal', __( 'Portal ID', 'mb-qp' ) )
			->set_width( 33 )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_embed_forms',
					'value' => 'hubspot',
					'compare' => '='
				)
			) ),
		Field::make( 'separator', 'qp_button_separator', __( 'Button', 'mb-qp' ) ),
		Field::make( 'text', 'qp_button_text', __( 'Button Text', 'mb-qp' ) )
			->set_default_value( 'Find Out More' ),
		Field::make( 'text', 'qp_button_link', __( 'Button Link', 'mb-qp' ) )
			->set_default_value( 'https://www.enterlink.com' ),
		Field::make( 'checkbox', 'qp_button_new_tab', __( 'Open in New Tab', 'mb-qp' ) ),
		Field::make( 'separator', 'qp_form_separator', __( 'QuickPop Form', 'mb-qp' ) ),
		Field::make( 'html', 'qp_acknoledgement_title', '' )
			->set_html( '<h3 class="qp_cf-form-field-label">Acknowledgement Checkbox</h3>' )
			->set_width( 16 ),
		Field::make( 'checkbox', 'qp_acknoledgement_include', __( 'Include', 'mb-qp' ) )
			->set_width( 8 )
			->set_default_value( '' ),
		Field::make( 'checkbox', 'qp_acknoledgement_required', __( 'Required', 'mb-qp' ) )
			->set_width( 8 )
			->set_default_value( '' ),
		Field::make( 'checkbox', 'qp_acknoledgement_checked', __( 'Checked by Default?', 'mb-qp' ) )
			->set_width( 16 )
			->set_default_value( '' ),
		Field::make( 'rich_text', 'qp_acknoledgement', '' )
			->set_settings(array(
				'media_buttons' => false,
				'tinymce' => array(
					'toolbar1' => 'formatselect,bold,italic,underline,link',
					'toolbar2' => false,
				),
				'quicktags' => false
			) )
			->set_default_value( 'I have read and agree to the terms and privacy policy' ),
		Field::make( 'html', 'qp_email_title', __( 'Email', 'mb-qp' ) )
			->set_html( '<h3 class="qp_cf-form-field-label">Email</h3>' )
			->set_width( 6 ),
		Field::make( 'checkbox', 'qp_email_include', __( 'Include', 'mb-qp' ) )
			->set_width( 8 )
			->set_default_value( 'yes' ),
		Field::make( 'checkbox', 'qp_email_required', __( 'Required', 'mb-qp' ) )
			->set_width( 8 )
			->set_default_value( 'yes' ),
		Field::make( 'text', 'qp_email_placeholder', '' )
			->set_default_value( 'Enter your email...' ),
		Field::make( 'html', 'qp_name_title', __( 'Name', 'mb-qp' ) )
			->set_html( '<h3 class="qp_cf-form-field-label">Name<h3>' )
			->set_width( 6 ),
		Field::make( 'checkbox', 'qp_name_include', __( 'Include', 'mb-qp' ) )
			->set_width( 8 )
			->set_default_value( 'no' ),
		Field::make( 'checkbox', 'qp_name_required', __( 'Required', 'mb-qp' ) )
			->set_width( 8 )
			->set_default_value( 'no' ),
		Field::make( 'text', 'qp_field_name_placeholder', '' )
			->set_default_value( 'Your Full Name' ),
		Field::make( 'html', 'qp_phone_title', __( 'Phone', 'mb-qp' ) )
			->set_html( '<h3 class="qp_cf-form-field-label">Phone<h3>' )
			->set_width( 6 ),
		Field::make( 'checkbox', 'qp_phone_include', __( 'Include', 'mb-qp' ) )
			->set_width( 8 )
			->set_default_value( 'no' ),
		Field::make( 'checkbox', 'qp_phone_required', __( 'Required', 'mb-qp' ) )
			->set_width( 8 )
			->set_default_value( 'no' ),
		Field::make( 'text', 'qp_field_phone_placeholder', '' )
			->set_default_value( 'Your Phone Number' ),
		Field::make( 'text', 'qp_field_form_button_text', __( 'Form Button', 'mb-qp' ) )
			->set_default_value( 'Sign Up' ),
		Field::make( 'separator', 'qp_other_separator', __( 'Other Settings', 'mb-qp' ) ),
		Field::make( 'text', 'qp_field_form_message', __( 'Thank You Message', 'mb-qp' ) )
			->set_default_value( 'Submission received, thank you!' ),
		Field::make( 'html', 'qp_popup_close_link_title', '' )
			->set_html( '<h3 class="qp_cf-form-field-label qp_cf-form-field-label--bold">Close Popup Message<h3>' )
			->set_width( 20 ),
		Field::make( 'checkbox', 'qp_popup_close_link_include', __( 'Include', 'mb-qp' ) )
			->set_width( 8 )
			->set_default_value( 'no' ),
		Field::make( 'text', 'qp_popup_close_link_message', '' )
			->set_default_value( 'No thanks, I’m not interested' ),
		Field::make( 'select', 'qp_popup_close_link_message_alignment', __( 'Alignment', 'mb-qp' ) )
			->add_options( array(
				'left' => __( 'Left', 'mb-qp' ),
				'center' => __( 'Center', 'mb-qp' ),
				'right' => __( 'Right', 'mb-qp' )
			) ),
	) )
	->add_tab( __( 'Design', 'mb-qp' ), array(
		Field::make( 'separator', 'qp_include_separator', __( 'Include / Exclude', 'mb-qp' ) ),
		Field::make( 'checkbox', 'qp_include_button', __( 'Standard Button', 'mb-qp' ) )
			->set_width( 20 )
			->set_default_value( 'no' ),
		Field::make( 'checkbox', 'qp_include_form', __( 'Form', 'mb-qp' ) )
			->set_width( 20 )
			->set_default_value( 'yes' ),
		Field::make( 'separator', 'qp_style_separator', __( 'Style', 'mb-qp' ) ),
		Field::make( 'select', 'qp_text_color', __( 'Text Color', 'mb-qp' ) )
			->add_options( [
				'dark' => __( 'Dark', 'mb-qp' ),
				'light' => __( 'Light', 'mb-qp' ),
			] )
			->set_width( 50 ),
		Field::make( 'select', 'qp_fields_color', __( 'Fields Text Color', 'mb-qp' ) )
			->add_options( [
				'dark' => __( 'Dark', 'mb-qp' ),
				'light' => __( 'Light', 'mb-qp' ),
			] )
			->set_width( 50 ),
		Field::make( 'radio', 'qp_popup_width_type', __( 'Popup Container Size', 'mb-qp' ) )
			->add_options( array(
				'default' => __( 'Default', 'mb-qp' ),
				'custom' => __( 'Custom Size', 'mb-qp' ),
			) ),
		Field::make( 'text', 'qp_popup_width', '' )
			->set_default_value( '550px' )
			->set_help_text( 'Percentage of browser width or pixel width of popup container. Mobile view will remain full width. ' ),
		Field::make( 'text', 'qp_popup_container_radius', __( 'Popup Container Corner Radius', 'mb-qp' ) )
			->set_default_value( '12px' )
			->set_help_text( 'Sets corner radius of popup container. Set to 0 for square corners.' ),
		Field::make( 'select', 'qp_popup_bg_type', __( 'Popup Container Background Color Type', 'mb-qp' ) )
			->set_options( array(
				'regular' => __( 'Regular', 'mb-qp' ),
				'gradient' => __( 'Gradient', 'mb-qp' ),
			) ),
		Field::make( 'color', 'qp_popup_bg', __( 'Popup Container Color', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_popup_bg_type',
					'value' => 'regular',
					'compare' => '='
				)
			) )
			->set_default_value( '#ffffff' )
			->set_width( 50 ),
		Field::make( 'select', 'qp_popup_exit_button_styling', __( 'Exit Button Styling', 'mb-qp' ) )
			->add_options( array(
				'dark'  => __( 'Dark', 'mb-qp' ),
				'light' => __( 'Light', 'mb-qp' )
			) )
			->set_width( 50 ),
		Field::make( 'color', 'qp_popup_gradient_color_1', __( 'Gradient First Color', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_popup_bg_type',
					'value' => 'gradient',
					'compare' => '='
				)
			) )
			->set_width( 33 ),
		Field::make( 'color', 'qp_popup_gradient_color_2', __( 'Gradient Second Color', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_popup_bg_type',
					'value' => 'gradient',
					'compare' => '='
				)
			) )
			->set_width( 33 ),
		Field::make( 'select', 'qp_popup_gradient_direction', __( 'Gradient Direction', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_popup_bg_type',
					'value' => 'gradient',
					'compare' => '='
				)
			) )
			->add_options( array(
				'to_right' => __( 'From Left to Right' ),
				'to_left' => __( 'From Right to Left' ),
				'to_bottom' => __( 'From Top to Bottom' ),
				'to_top' => __( 'From Bottom to Top' ),
			) )
			->set_width( 33 ),
		Field::make( 'text', 'qp_popup_border_width', __( 'Border Width', 'mb-qp' ) )
			->set_help_text( 'In pixels.' )
			->set_width( 50 ),
		Field::make( 'color', 'qp_popup_border_color', __( 'Border Color', 'mb-qp' ) )
			->set_width( 50 ),
		Field::make( 'html', 'qp_padding_separator' )
			->set_html( '<h4 class="cf__separator cf__separator--small">Padding</h4>' ),
		Field::make( 'checkbox', 'qp_default_padding', __( 'Default Padding', 'mb-qp' ) )
			->set_default_value( true ),
		Field::make( 'text', 'qp_padding_top', __( 'Padding Top', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_default_padding',
					'value' => false,
					'compare' => '='
				)
			) )
			->set_width( 25 ),
		Field::make( 'text', 'qp_padding_bottom', __( 'Padding Bottom', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_default_padding',
					'value' => false,
					'compare' => '='
				)
			) )
			->set_width( 25 ),
		Field::make( 'text', 'qp_padding_left', __( 'Padding Left', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_default_padding',
					'value' => false,
					'compare' => '='
				)
			) )
			->set_width( 25 ),
		Field::make( 'text', 'qp_padding_right', __( 'Padding Right', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_default_padding',
					'value' => false,
					'compare' => '='
				)
			) )
			->set_width( 25 ),
		Field::make( 'html', 'qp_padding_help_text' )
			->set_html( sprintf( '<em class="cf-field__help">%s</em>', __( 'Custom interior padding. Must add "px" or "%" after number.', 'mb-qp' ) ) ),
		Field::make( 'html', 'qp_x_btn_separator' )
			->set_html( '<h4 class="cf__separator cf__separator--small">X Button Corner Offset</h4>' ),
		Field::make( 'checkbox', 'qp_x_btn_default_offset', __( 'Default Offset', 'mb-qp' ) )
			->set_default_value( true ),
		Field::make( 'text', 'qp_x_btn_offset', __( 'Offset', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_x_btn_default_offset',
					'value' => false,
					'compare' => '='
				)
			) ),
		Field::make( 'html', 'qp_x_btn_offset_help_text' )
			->set_html( sprintf( '<em class="cf-field__help">%s</em>', __( 'Positions "X" icon inward or outward for popups with high corner radius. Must add "px" after number.', 'mb-qp' ) ) ),
		Field::make( 'html', 'qp_bg_overlay_separator' )
			->set_html( '<h4 class="cf__separator cf__separator--small">Background/Overlay</h4>' ),
				Field::make( 'select', 'qp_popup_overlay_bg_type', __( 'Overlay Background Color Type', 'mb-qp' ) )
			->set_options( array(
				'regular' => __( 'Regular', 'mb-qp' ),
				'gradient' => __( 'Gradient', 'mb-qp' ),
			) ),
		Field::make( 'color', 'qp_popup_overlay_bg', __( 'Overlay Background Color', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_popup_overlay_bg_type',
					'value' => 'regular',
					'compare' => '='
				)
			) )
			->set_default_value( '#333333' ),
		Field::make( 'color', 'qp_popup_overlay_gradient_color_1', __( 'Overlay Gradient First Color', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_popup_overlay_bg_type',
					'value' => 'gradient',
					'compare' => '='
				)
			) )
			->set_default_value( '#333333' )
			->set_width( 33 ),
		Field::make( 'color', 'qp_popup_overlay_gradient_color_2', __( 'Overlay Gradient Second Color', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_popup_overlay_bg_type',
					'value' => 'gradient',
					'compare' => '='
				)
			) )
			->set_default_value( '#333333' )
			->set_width( 33 ),
		Field::make( 'select', 'qp_popup_overlay_gradient_direction', __( 'Overlay Gradient Direction', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_popup_overlay_bg_type',
					'value' => 'gradient',
					'compare' => '='
				)
			) )
			->add_options( array(
				'to_right' => __( 'From Left to Right' ),
				'to_left' => __( 'From Right to Left' ),
				'to_bottom' => __( 'From Top to Bottom' ),
				'to_top' => __( 'From Bottom to Top' ),
			) )
			->set_width( 33 ),
		Field::make( 'text', 'qp_overlay_opacity', __( 'Opacity', 'mb-qp' ) )
			->set_default_value( '84%' )
			->set_help_text( 'Enter a percentage' ),
		Field::make( 'text', 'qp_btn_radius', __( 'Button Corner Radius', 'mb-qp' ) )
			->set_default_value( '4px' )
			->set_help_text( 'Set to 0 for square corner buttons. Default design is 4px corner radius.' ),
		Field::make( 'color', 'qp_standard_button_color', __( 'Standard Button Color', 'mb-qp' ) )
			->set_default_value( '#ff2f73' )
			->set_width( 50 ),
		Field::make( 'select', 'qp_standard_button_alignment', __( 'Standard Button Alignment', 'mb-qp' ) )
			->add_options( array(
				'left'   => __( 'Left', 'mb-qp' ),
				'center' => __( 'Center', 'mb-qp' ),
				'right'  => __( 'Right', 'mb-qp' ),
			) )
			->set_width( 50 ),
		Field::make( 'separator', 'qp_form_style_separator', __( 'Form Style', 'mb-qp' ) ),
		Field::make( 'color', 'qp_form_button_color', __( 'Form Button Color', 'mb-qp' ) )
			->set_default_value( '#4e83cb' ),
		Field::make( 'color', 'qp_form_field_background', __( 'Form Field Background', 'mb-qp' ) )
			->set_default_value( '#f9f9f9' )
			->set_width( 50 ),
		Field::make( 'color', 'qp_form_field_border', __( 'Form Field Border', 'mb-qp' ) )
			->set_default_value( '#e2e2e2' )
			->set_width( 50 ),
		Field::make( 'separator', 'qp_custom_code_separator', __( 'Custom Code', 'mb-qp' ) ),
		Field::make( 'textarea', 'qp_custom_css_code', __( 'Custom CSS Code', 'mb-qp' ) )
			->set_rows( 6 )
			->set_help_text( __( 'Can be used to add custom CSS styling to this popup or to overwrite theme CSS.', 'mb-qp' ) ),
	) )
	->add_tab( __( 'Settings', 'mb-qp' ), array(
		Field::make( 'separator', 'qp_status_separator', __( 'Status', 'mb-qp' ) ),
		Field::make( 'select', 'qp_status', '' )
			->add_options( array(
				'qp_enabled' => 'Enabled',
				'qp_disabled' => 'Disabled'
			) ),
		Field::make( 'html', 'qp_settings_form_title', '' )
			->set_html( sprintf('<h3 class="qp_cf-separator-title">%s <span>%s</span><h3>', __( 'Popup Title', 'mb-qp' ), __( '(for reference only)' ) ) ),
		Field::make( 'text', 'qp_form_title', '' )
			->set_default_value( 'Site-Wide Popup' ),
		Field::make( 'separator', 'qp_settings_visibility', __( 'Visibility', 'mb-qp' ) ),
		Field::make( 'html', 'qp_display_title', '' )
			->set_html( '<h3 class="qp_cf-form-field-label">Display Popup<h3>' )
			->set_width( 8 ),
		Field::make( 'select', 'qp_settings_display_pages', '' )
			->add_options( array(
				'qp_all' => 'All Pages',
				'qp_choose' => 'Choose Pages'
			) )
			->set_width( 12 ),
		Field::make( 'association', 'qp_popup_visible_pages', __( 'Pages To Display Popup', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_settings_display_pages',
					'value' => 'qp_choose',
					'compare' => '='
				)
			) )
			->set_duplicates_allowed( false )
			->set_types( array(
				array(
					'type' => 'post',
					'post_type' => 'page',
				),
				array(
					'type' => 'post',
					'post_type' => 'post',
				),
				array(
					'type' => 'post',
					'post_type' => 'product',
				),
			) ),
		Field::make( 'separator', 'qp_settings_position', __( 'Popup Position', 'mb-qp' ) ),
		Field::make( 'select', 'qp_position', '' )
			->add_options( [
				'center'       => __( 'Default (Center)', 'mb-qp' ),
				'top-left'     => __( 'Top Left', 'mb-qp' ),
				'top-right'    => __( 'Top Right', 'mb-qp' ),
				'bottom-left'  => __( 'Bottom Left', 'mb-qp' ),
				'bottom-right' => __( 'Bottom Right', 'mb-qp' )
			] ),
		Field::make( 'separator', 'qp_settings_events', __( 'Events', 'mb-qp' ) ),
		Field::make( 'html', 'qp_event_type_label', __( 'Type', 'mb-qp' ) )
			->set_html( '<h3 class="qp_cf-form-field-label">Type<h3>' )
			->set_width( 6 ),
		Field::make( 'select', 'qp_event_type', '' )
			->add_options( array(
				'delay' => __( 'Delay', 'mb-qp' ),
				'on_click' => __( 'On Click', 'mb-qp' ),
				'on_exit' => __( 'On Exit', 'mb-qp' ),
			) )
			->set_width( 15 ),
		Field::make( 'text', 'qp_settings_delay', '' )
			->set_width( 15 )
			->set_help_text( 'seconds after page load' )
			->set_default_value( '5' )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_event_type',
					'value' => 'delay',
					'compare' => '='
				)
			) ),
		Field::make( 'separator', 'qp_cookies_settings_separator', __( 'Cookie Settings', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_event_type',
					'value' => 'on_click',
					'compare' => '!='
				)
			) ),
		Field::make( 'checkbox', 'qp_snooze_popup', __( 'Snooze popup after form submission or closing. *Does not apply to on-click popups.', 'mb-qp' ) )
			->set_default_value( true )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_event_type',
					'value' => 'on_click',
					'compare' => '!='
				)
			) ),
		Field::make( 'text', 'qp_number_of_days_snooze', '' )
			->set_default_value( '10' )
			->set_help_text( __( 'Number of days to snooze popup', 'mb-qp' ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_event_type',
					'value' => 'on_click',
					'compare' => '!='
				),
				array(
					'field' => 'qp_snooze_popup',
					'value' => true,
					'compare' => '='
				),
			) ),
		Field::make( 'text', 'qp_event_btn_shortcode', '' )
			->set_help_text( 'Use this shortcode to display a button that triggers this popup.<br>You can add custom attributes to the popup using shortcode attributes.<br> The first one - <code>popup-id</code> - is required and it specifies which popup this button will trigger.<br>Publish the popup and refresh the page and "${popup-id}" will be replaced with the actual popup\'s ID.<br> Other possible attributes are:<br>
				<code>content</code> - specify button\'s text content <br>
				<code>class</code> - adds class attribute to the html element<br>
				<code>id</code> - adds id attribute to the html element<br>
				<code>data-{something}</code> - you can add any data attribute and it will translate to a data attribute on the html element <br><br> Finally if you\'d like to just turn an existing button into a popup trigger you can simply apply a css class and a data attribute to specify which popup it will trigger to it: <br>class: <code>qp-js-trigger-popup-' . $popup_id . '</code><br>where <code>' . $popup_id . '</code> is this specific popup\'s ID'  )
			->set_width( 100 )
			->set_attribute( 'readOnly', 'true' )
			->set_attribute( 'placeholder', sprintf( '[qp_popup_trigger_btn popup-id="%s" content="Find Out More" class="button"]', $popup_id ) )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_event_type',
					'value' => 'on_click',
					'compare' => '='
				)
			) ),
		Field::make( 'separator', 'qp_settings_animation', __( 'Animation', 'mb-qp' ) ),
		Field::make( 'html', 'qp_animation_type_label', '' )
			->set_html( '<h3 class="qp_cf-form-field-label">Type<h3>' )
			->set_width( 8 ),
		Field::make( 'select', 'qp_animation_type', '' )
			->add_options( array(
				'slide_up' => __( 'Slide Up', 'mb-qp' ),
				'slide_from_right' => __( 'Slide From Right', 'mb-qp' ),
				'slide_from_left' => __( 'Slide From Left', 'mb-qp' ),
				'fade_in' => 'Fade In'
			) )
			->set_width( 20 ),
		Field::make( 'html', 'qp_animation_speed_label', '' )
			->set_html( '<h3 class="qp_cf-form-field-label">Transition Speed<h3>' )
			->set_width( 16 ),
		Field::make( 'text', 'qp_animation_speed', '' )
			->set_default_value( '400' )
			->set_help_text( 'ms' )
			->set_width( 8 ),
	) );

if ( ! isset( $_COOKIE['qp_library_upsell_hidden'] ) ) {
	$sidebar_image = QP_PLUGIN_URL . 'images/qp-upsell-sidebar.png';

	Container::make( 'post_meta', 'QP Sidebar' )
		->set_priority( 'low' )
		->where( 'post_type', '=', 'qp_popup' )
		->set_context( 'side' )
		->add_fields( array(
			Field::make( 'html', 'qp_single_post_sidebar', '' )
				->set_html( '<div class="qp-upsell-ad"><img width="208" height="182" src="' . $sidebar_image . '"><p><strong>Premium Business Plugins</strong><br>Need other plugins with the Brindle seal of quality? Add custom banner announcements and cookie notifications with <a target="_blank" href="https://mybrindle.com/product/banners-wordpress-plugin/">SleekAnnounce</a> or let customers &amp; clients book appointments based on your personalized calendar with <a target="_blank" href="https://mybrindle.com/product/book-appointments-wordpress-plugin/">Brindle Booking.</a> Give them a shot and <span>save 15%!</span></p><p>Use Promo Code<br><strong>MOBRNDL15</strong></p><a target="_blank" href="https://mybrindle.com/shop/" class="qp-upsell-ad__btn"><strong>Shop Brindle Plugins</strong><br>All include 14 day FREE TRIAL</a><a href="#" class="qp-upsell__snooze js-upsell-snooze">Dismiss this message</a></div>' ),
		) );
}

Container::make( 'post_meta', __( 'Submission Info:', 'mb-qp' ) )
	->where( 'post_type', '=', 'qp_submissions' )
	->add_fields( array(
		Field::make( 'text', 'qp_submission_popup_title', __( 'Popup Title', 'crb' ) )
			->set_default_value( '' )
			->set_attribute( 'readOnly', 'true' ),
		Field::make( 'text', 'qp_submission_form', __( 'Form Type', 'mb-qp' ) )
			->set_default_value( 'Default QuickPop Form' )
			->set_attribute( 'readOnly', 'true' ),
		Field::make( 'text', 'qp_submission_name', __( 'Name', 'mb-qp' ) )
			->set_width( 50 )
			->set_attribute( 'readOnly', 'true' )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_submission_form',
					'value' => 'Default QuickPop Form',
					'compare' => '='
				)
			) ),
		Field::make( 'text', 'qp_submission_phone', __( 'Phone Number', 'mb-qp' ) )
			->set_width( 50 )
			->set_attribute( 'readOnly', 'true' )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_submission_form',
					'value' => 'Default QuickPop Form',
					'compare' => '='
				)
			) ),
		Field::make( 'textarea', 'qp_submission_hubspot_form_data', __( 'Hubspot Form Data', 'mb-qp' ) )
			->set_attribute( 'readOnly', 'true' )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_submission_form',
					'value' => 'Hubspot Form',
					'compare' => '='
				)
			) ),
		Field::make( 'textarea', 'qp_submission_mailchimp_form_data', __( 'MailChimp Form Data', 'mb-qp' ) )
			->set_attribute( 'readOnly', 'true' )
			->set_conditional_logic( array(
				'relation' => 'AND',
				array(
					'field' => 'qp_submission_form',
					'value' => 'MailChimp Form',
					'compare' => '='
				)
			) ),
	) );