;(function($, window, document, undefined) {
	$(function() {
		qpStatusDropdown();

		function qpStatusDropdown() {
			var $dropdown = $('.qp-js-status-dropdown');

			$dropdown.find('.dropdown__head').on('click', function() {
				var $this = $(this);

				$this.closest('.qp-dropdown-status').toggleClass('is-active');
			});

			$dropdown.find('.dropdown__body > ul a').on('click', function(event) {
				event.preventDefault();
				var $this = $(this);
				var $dropdown = $this.closest('.qp-js-status-dropdown')
				var currentStatus = $dropdown.attr('data-status');
				var newStatus = $this.attr('data-status');

				if (currentStatus === newStatus) {
					$dropdown.removeClass('is-active');

					return
				}

				$dropdown.attr('data-status', newStatus);
				$dropdown.find('.dropdown__head span').text($this.text()).removeClass('qp-live qp-draft');
				$dropdown.removeClass('is-active');

				var popupID = $dropdown.closest('.qp-popup-list').attr('data-id');
				var $ajaxContainer = $dropdown.closest('.section-qp-popup');

				qpUpdatePopupStatus($ajaxContainer, popupID, newStatus);
			});
		}

		function qpUpdatePopupStatus($ajaxContainer, popupID, newStatus) {
			console.log(popupID)
			console.log(newStatus)
			$.ajax({
				url: qp_site_ajax.ajaxurl,
				method: 'POST',
				data: {
					action: 'qp_update_popup_status',
					id: popupID,
					status: newStatus
				},
				beforeSend: function() {
					$ajaxContainer.addClass('is-loading');
					$ajaxContainer.append('<i class="qp-ico-loading"></i>');
				},
				success: function(data) {
					$ajaxContainer.removeClass('is-loading');
					$ajaxContainer.find('.qp-ico-loading').remove();
				}
			});
		}
	});
})(jQuery, window, document);