;(function($, window, document, undefined) {
	$(function() {
		$(document).on('click', '.js-duplicate-popup', function(event) {
			event.preventDefault();

			var $this = $(this);
			var popupID = $this.closest('.qp-popup-list').attr('data-id');

			$this.closest('.section-qp-popup').addClass('is-confirming').find('.qp-popup-duplicate-confirmation').attr('data-id', popupID);
		});

		$('.js-confirm-duplicate').on('click', function() {
			event.preventDefault();
			var $this = $(this);
			var popupID = $this.closest('.qp-popup-duplicate-confirmation').attr('data-id');

			var $ajaxContainer = $('.section-qp-popup');

			$ajaxContainer.removeClass('is-confirming');

			$.ajax({
				url: qp_site_ajax.ajaxurl,
				method: 'POST',
				data: {
					action: 'qp_duplicate_popup',
					id: popupID,
				},
				beforeSend: function() {
					$ajaxContainer.addClass('is-loading');
					$ajaxContainer.append('<i class="qp-ico-loading"></i>');
				},
				success: function(data) {
					$ajaxContainer.removeClass('is-loading');
					$ajaxContainer.find('.qp-ico-loading').remove();

					if (data.status === 'success') {
						$ajaxContainer.find('.qp-popups-list .qp-popups__body > ul').prepend(data.new_popup_html);
					}

				}
			});
		});

		$('.js-reject-duplicate').on('click', function(event) {
			event.preventDefault();

			$(this).closest('.section-qp-popup').removeClass('is-confirming');
		});
	});
})(jQuery, window, document);